////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user program. //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// cat (print) for lnk (Shell Links or Desktop Shortcuts).                    //
// Print content of Shell Link files: *.lnk on Windows, *.desktop on Unix.    //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241022 - Sample created by A.K.                                          //
// 20241026 - 1st version of catlnk by Alexey Kuryakin                        //
////////////////////////////////////////////////////////////////////////////////

program catlnk;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics, interfaces, forms,
 _crw_alloc, _crw_cmdargs, _crw_environ, _crw_proc, _crw_rtc, _crw_ef,
 _crw_str, _crw_utf8, _crw_fio, _crw_fifo, _crw_hl, _crw_ee, _crw_colors;

function VersionInfo:LongString;
const Info:LongString='';
begin
 if (Info='') then Info:=GetFileVersionInfoAsText(ProgName);
 Result:=Info;
end;

function FileDescription:LongString;
begin
 Result:=CookieScan(VersionInfo,'FileDescription');
end;

function ProductVersion:LongString;
begin
 Result:=CookieScan(VersionInfo,'ProductVersion');
end;

function LegalCopyright:LongString;
begin
 Result:=CookieScan(VersionInfo,'LegalCopyright');
end;

function DotEnding(const S:LongString):LongString;
const dot='.';
begin
 Result:=S;
 if (Result='') then Exit;
 if (StrFetch(Result,Length(Result))<>dot) then Result:=Result+dot;
end;
 
procedure About;
var sAbout,base:LongString;
begin
 base:=ExtractBaseName(ProgName);
 sAbout:=TrimDef(DotEnding(base+' version '+ProductVersion),'Help on '+base+' command.')+EOL
        +TrimDef(DotEnding(LegalCopyright),'Copyright(c) 2021-2024 DaqGroup daqgroup@mail.ru.')+EOL
        +TrimDef(DotEnding(FileDescription),base+' - cat (read) content of Shell Link (Desktop Shortcut) file.')+EOL
        +''+EOL
        +'Usage: '+base+' ['+AdaptLnkFileName('filename.lnk')+']'+EOL; 
 StdOutPrintLn(sAbout);
end;

procedure PrintShellLink;
var FileName,Ext:LongString;
begin
 if (ParamCount=0) then begin About; Exit; end;
 FileName:=ParamStr(1); Ext:=ExtractFileExt(FileName);
 if IsUnix and not SameText(Ext,'.desktop') then begin
  StdErrPrintLn('Error: expected *.desktop file.');
  ExitCode:=1;
  Exit;
 end;
 if IsWindows and not SameText(Ext,'.lnk') then begin
  StdErrPrintLn('Error: expected *.lnk file.');
  ExitCode:=1;
  Exit;
 end;
 if not FileExists(FileName) then begin
  StdErrPrintLn('Error: file not found.');
  ExitCode:=1;
  Exit;
 end;
 StdOutPrint(ReadShellLinkAsText(FileName));
end;

begin

 try
  PrintShellLink;
 except
  on E:Exception do BugReport(E,nil,'catlnk');
 end;

end.

/////////////////
// END OF FILE //
/////////////////
