#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

function note(){ return; };

function fatal(){
 local date="$(date +%Y.%m.%d-%H:%M:%S)"; local script="$(basename ${BASH_SOURCE[0]})";
 if which notify-send; then notify-send -t 30000 -i dialog-error "$date: $script" "$1"; fi;
 echo -ne "\n$1\n\n";
 exit 1;
};

note "Script identification.";
note "######################";
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";


function clear_daqgroup_garbage(){
 function deletebackuplib(){
  while [ -n "$1" ]; do
   if [ -d "$1" ]; then
    local arch="$(uname -m)";
    local bckfiles="$(find $1 -type d | grep "/backup$")";
    local libfiles="$(find $1 -type d | grep "/lib/$arch-linux$")";
    for f in $bckfiles $libfiles; do rm -fvr $f; done;
   fi;
   shift;
  done;
 };
 if pushd $scriptHOME; then
  local flist="";
  for d in $(ls -1 .); do
   if [ -d $d ]; then
    flist="$flist $d";
   fi;
  done;
  #flist="crwdaq crwkit crwlib crwtst";
  deletebackuplib $flist;
 fi;
 popd;
 echo -e "\n$(date +%Y.%m.%d-%H:%M:%S) - $scriptname done.\n";
}

function main(){
 if pushd $scriptHOME > /dev/null 2>&1; then
  if [ -t 1 ]; then
   clear_daqgroup_garbage;
  else
   exec xterm -fa 'PT Mono' -fs 12 -geometry 118x35+167+100 -hold -e "$scriptFILE";
  fi;
 fi;
 popd $scriptHOME > /dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
