#!/bin/bash

############################################################
# Copyright (c) 2021-2023 Alexey Kuryakin kouriakine@mail.ru
# Script uses to start sercatgui.lm9
############################################################
# Usage: unix sercatgui
############################################################

function fatal(){
 1>&2 echo -ne "\n$1\n\n";
 exit 1;
};

function run_sercatgui(){
 local scriptfile="${BASH_SOURCE[0]}";
 local scriptFILE="$(realpath $scriptfile)";
 local scriptHOME="$(dirname  $scriptFILE)";
 local sercatgui="$scriptHOME/sercatgui.lm9";
 if which CrossMachine >/dev/null 2>&1; then
  if [ -e "$sercatgui" ]; then
   CrossMachine $sercatgui "$@" </dev/null >/dev/null 2>&1 & disown;
  else
   fatal "Error: could not find $sercatgui.";
  fi;
 else
  fatal "Error: could not find CrossMachine.";
 fi;
};


#######
## MAIN
#######

function main(){
 ##################
 ## Execute command
 ##################
 run_sercatgui "$@";
};

main "$@";

##############
## END OF FILE
##############
