#!/bin/bash

astra_tweak() {
  greetings() {
   echo " ";
   echo " Utility to tweak Astra Linux user directories + parameters";
   echo " Copyright (c) 2020-2023 Alexey Kuryakin kouriakine@mail.ru";
   echo " Version: 20230117";
   echo " ";
   echo "Hello, $USER.";
   echo "Let's tweak your $(lsb_release -ds) ...";
   echo " ";
  };
  show_title() {
   echo " ";
   echo " $*";
   echo " ";
  };
  skip(){
    true;
  };
  tweak_mntdata_mntshar() {
   mkdir_own_mod() {
    if [ -z "$1" ]; then return 0; fi; local dir=$1;
    if [ -z "$2" ]; then return 0; fi; local own=$2;
    if [ -z "$3" ]; then return 0; fi; local mod=$3;
    if [ -L "$dir" ]; then
     echo "$dir - link to $(readlink "$dir").";
    else
     if [ -d "$dir" ]; then
      echo "$dir - found.";
     else
      echo "$dir - create.";
      sudo mkdir "$dir";
     fi;
    fi;
    sudo chown -c $own "$dir";
    sudo chmod -c $mod "$dir";
   };
   make_dir_link_own_mod_xdg() {
    if [ -z "$1" ]; then return 0; fi; local dir=$1;
    if [ -z "$2" ]; then return 0; fi; local lnk=$2;
    if [ -z "$3" ]; then return 0; fi; local own=$3;
    if [ -z "$4" ]; then return 0; fi; local mod=$4;
    mkdir_own_mod "$dir" $own $mod;
    if [ -L "$lnk" ]; then
     sudo rm -f "$lnk";
    else
     if [ -d "$lnk" ]; then
      sudo mv -f ${lnk// /\\ }/.directory ${dir// /\\ }/;
      sudo mv -f ${lnk// /\\ }/* ${dir// /\\ }/;
      sudo rmdir "$lnk";
     else
      if [ -e "$lnk" ]; then
       echo "$lnk - not directory.";
       return 1;
      fi;
     fi;
    fi;
    sudo ln -s -T "$dir" "$lnk";
    sudo chown -ch $own  "$dir";
    sudo chown -ch $own  "$lnk";
    sudo chown -cR $own  "$dir/";
    sudo chown -cR $own  "$lnk/";
    echo "$lnk - link to $(readlink "$lnk")";
    if [ -n "$5" ]; then xdg-user-dirs-update --set "$5" "$lnk"; fi;
   };
   sed_etc_xdg_user_dirs_defaults(){
    local conf="/etc/xdg/user-dirs.defaults";
    if [ -e "$conf.bak" ]; then return 0; fi;
    if [ -e "$conf" ]; then
     sudo sed -i*.bak $conf  -e 's/^ *\t*TEMPLATES=Documents\/Templates *\t*$/TEMPLATES=Templates/I'  -e 's/^ *\t*MUSIC=Documents\/Music *\t*$/MUSIC=Music/I'  -e 's/^ *\t*PICTURES=Documents\/Pictures *\t*$/PICTURES=Pictures/I'  -e 's/^ *\t*VIDEOS=Documents\/Videos *\t*$/VIDEOS=Videos/I'  -e 's/^ *\t*PHOTOS=Documents\/Photos *\t*$/PHOTOS=Photos/I'  -e 's/^ *\t*MOVIES=Documents\/Movies *\t*$/MOVIES=Movies/I';
     echo "$conf:";
     cat $conf;
    fi;
   };
   xdg_user_dir_list(){
    show_title "xdg-user-dir list:";
    for id in DESKTOP DOWNLOAD TEMPLATES PUBLICSHARE DOCUMENTS MUSIC PICTURES VIDEOS; do
     local lnk=$(xdg-user-dir $id); local dir=$(readlink $lnk);
     echo "xdg-user-dir $id $(basename $lnk) -> $dir";
    done;
   };
   make_data_dir() {
    if [ -z "$1" ]; then return 0; fi; local dir=$1;
    if [ -z "$2" ]; then return 0; fi; local lnk=$2;
    if [ -e $mntdata ]; then make_dir_link_own_mod_xdg "$mntdata/home/$USER/$dir/" "$HOME/$lnk" $USER:$USER 755 "$3"; fi;
   };
   make_shar_dir() {
    [ -z "$1" ] && return 0; local dir=$1;
    [ -z "$2" ] && return 0; local lnk=$2;
    if [ -e $mntshar ]; then make_dir_link_own_mod_xdg "$mntshar/home/$USER/$dir" "$mntdata/home/$USER/$dir" $USER:$USER 755; fi;
    make_data_dir "$@";
   };
   make_fast_dir() {
    if [ -z "$1" ]; then return 0; fi; local dir=$1;
    if [ -z "$2" ]; then return 0; fi; local lnk=$2;
    if [ -e $mntfast ]; then make_dir_link_own_mod_xdg "$mntfast/home/$USER/$dir" "$mntdata/home/$USER/$dir" $USER:$USER 755; fi;
    make_data_dir "$@";
   };
   if [ "$(sudo whoami)" == "root" ]; then
    echo -ne "sudo works fine.\n";
    if [ -z "$1" ]; then mntdata=/mnt/data; else mntdata="$1"; fi;
    if [ -z "$2" ]; then mntshar=/mnt/shar; else mntshar="$2"; fi;
    if [ -z "$3" ]; then mntfast=/mnt/fast; else mntfast="$3"; fi;
    if [ -e $mntdata ]; then
     echo -ne "$mntdata - found.\n";
     mkdir_own_mod $mntdata/home root:root 755;
     mkdir_own_mod $mntdata/root root:root 755;
     mkdir_own_mod $mntdata/root/scripts root:root 755;
     mkdir_own_mod $mntdata/home/$USER $USER:$USER 755;
     if [ -e $mntshar ]; then
      echo -ne "$mntshar - found.\n";
      mkdir_own_mod $mntshar/home root:root 755;
      mkdir_own_mod $mntshar/home/$USER $USER:$USER 755;
     fi;
     if [ -e $mntfast ]; then
      echo -ne "$mntfast - found.\n";
      mkdir_own_mod $mntfast/home root:root 755;
      mkdir_own_mod $mntfast/home/$USER $USER:$USER 755;
     fi;
     make_data_dir "desktops"        "Desktops"          ; skip DESKTOP;
     make_data_dir "movies"          "Фильмы"            ; skip MOVIES;
     make_data_dir "videos"          "Видео"             ; skip VIDEOS;
     make_data_dir "music"           "Музыка"            ; skip MUSIC;
     make_data_dir "photos"          "Снимки"            ; skip PHOTOS;
     make_data_dir "photos"          "Фотографии"        ; skip PHOTOS;
     make_data_dir "pictures"        "Картинки"          ; skip PICTURES;
     make_data_dir "pictures"        "Изображения"       ; skip PICTURES;
     make_data_dir "download"        "Загрузки"          ; skip DOWNLOAD;
     make_data_dir "templates"       "Шаблоны"           ; skip TEMPLATES;
     make_data_dir "documents"       "Документы"         ; skip DOCUMENTS;
     make_shar_dir "publicshare"     "Общедоступные"     ; skip PUBLICSHARE;
     make_data_dir "autorun"         "autorun"           ;
     make_data_dir "scripts"         "scripts"           ;
     make_data_dir "projects"        "projects"          ;
     make_data_dir ".wine"           ".wine"             ;
     make_fast_dir ".VirtualBox"     ".VirtualBox"       ;
     make_fast_dir "VirtualBox VMs"  "VirtualBox VMs"    ;
     skip sed_etc_xdg_user_dirs_defaults;
     mkdir_own_mod /srv/public root:root 755;
     mkdir_own_mod $mntdata/srv root:root 755;
     mkdir_own_mod $mntdata/srv/public root:root 755;
     mkdir_own_mod $mntdata/srv/public/mirror root:root 755;
     mkdir_own_mod $mntdata/srv/public/mirror/astra root:root 755;
     mkdir_own_mod $mntdata/srv/public/mirror/addons root:root 755;
     mkdir_own_mod $mntdata/srv/public/mirror/ALTLinux root:root 755;
     if [ -L /srv/public/mirror ]; then sudo rm -f /srv/public/mirror; fi;
     sudo ln -s -T $mntdata/srv/public/mirror /srv/public/mirror;
     echo "/srv/public/mirror - link to $(readlink /srv/public/mirror)";
    else
     echo -ne "$mntdata is not mounted. Please mount or link this directory first.\n\n";
    fi;
    xdg_user_dir_list;
   else
    echo -ne "sudo failed. Please make it work first.\n\n";
   fi;
  };
  tweak_bashrc() {
   if [ -z "$(cat ~/.bashrc | grep PS1=)" ]; then
    echo -ne '\n\n# Set nice colored prompt...\n' | tee -a ~/.bashrc;
    echo "PS1='[\[\033[32m\]\u@\h\[\033[m\] \[\033[36m\]\w\[\033[m\]]\[\033[31;1m\]\\$ \[\033[m\]'" | tee -a ~/.bashrc;
   fi;
   if [ -z "$(sudo cat /root/.bashrc | grep PS1=)" ]; then
    echo -ne '\n\n# Set nice colored prompt...\n' | sudo tee -a /root/.bashrc;
    echo "PS1='[\[\033[32m\]\u@\h\[\033[m\] \[\033[36m\]\w\[\033[m\]]\[\033[31;1m\]\\$ \[\033[m\]'" | sudo tee -a /root/.bashrc;
   fi;
  };
  clear;
  greetings;
  if [ "$(whoami)" == "root" ]; then
    echo "This scipt is not designed for root.";
    echo "Please run this script as ordinary user.";
    echo " ";
    return 1;
  fi;
  tweak_bashrc;
  tweak_mntdata_mntshar /mnt/data /mnt/shar /mnt/fast;
  show_title "Done";
};
astra_tweak;
