/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import java.util.Map;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbConnectionProperties;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.management.FBManagerMBean;
import org.firebirdsql.management.PageSizeConstants;

public class FBManager
implements FBManagerMBean {
    private static final System.Logger log = System.getLogger(FBManager.class.getName());
    private FbDatabaseFactory dbFactory;
    private final IConnectionProperties connectionProperties = new FbConnectionProperties();
    private String fileName;
    private int dialect = 3;
    private int pageSize = -1;
    private String defaultCharacterSet;
    private Boolean forceWrite;
    private boolean forceCreate;
    private boolean createOnStart;
    private boolean dropOnStop;
    private String state = "Stopped";
    private static final String STOPPED = "Stopped";
    private static final String STARTED = "Started";
    private GDSType type;

    public FBManager() {
        this(GDSFactory.getDefaultGDSType());
    }

    public FBManager(GDSType type) {
        this.type = type;
        this.connectionProperties.setType(type.toString());
    }

    public FBManager(String type) {
        this(GDSType.getType(type));
    }

    @Override
    public synchronized void start() throws Exception {
        if (STARTED.equals(this.state)) {
            throw new IllegalStateException("FBManager already started. Call stop() before starting again.");
        }
        this.dbFactory = GDSFactory.getDatabaseFactoryForType(this.type);
        this.state = STARTED;
        String fileName = this.getFileName();
        if (this.isCreateOnStart() && fileName != null) {
            this.createDatabase(fileName, this.getUserName(), this.getPassword(), this.getRoleName());
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        try {
            if (STOPPED.equals(this.state)) {
                log.log(System.Logger.Level.WARNING, "FBManager already stopped");
                return;
            }
            String fileName = this.getFileName();
            if (this.isDropOnStop() && fileName != null) {
                this.dropDatabase(fileName, this.getUserName(), this.getPassword(), this.getRoleName());
            }
        }
        finally {
            this.dbFactory = null;
            this.state = STOPPED;
        }
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getName() {
        return "Firebird Database manager";
    }

    @Override
    public void setServerName(String serverName) {
        FBManagerMBean.super.setServerName(serverName);
    }

    @Override
    public String getServerName() {
        return FBManagerMBean.super.getServerName();
    }

    @Override
    public void setServer(String host) {
        this.setServerName(host);
    }

    @Override
    public String getServer() {
        return this.getServerName();
    }

    @Override
    public void setPortNumber(int portNumber) {
        FBManagerMBean.super.setPortNumber(portNumber);
    }

    @Override
    public int getPortNumber() {
        return FBManagerMBean.super.getPortNumber();
    }

    @Override
    public void setPort(int port) {
        this.setPortNumber(port);
    }

    @Override
    public int getPort() {
        return this.getPortNumber();
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getType() {
        return this.type.toString();
    }

    @Override
    public void setType(String type) {
        GDSType gdsType = GDSType.getType(type);
        if (gdsType == null) {
            throw new IllegalArgumentException("Unrecognized type '" + type + "'");
        }
        this.type = gdsType;
        this.connectionProperties.setType(gdsType.toString());
    }

    @Override
    public String getUser() {
        return FBManagerMBean.super.getUser();
    }

    @Override
    public void setUser(String user) {
        FBManagerMBean.super.setUser(user);
    }

    @Override
    public String getUserName() {
        return this.getUser();
    }

    @Override
    public void setUserName(String userName) {
        this.setUser(userName);
    }

    @Override
    public String getPassword() {
        return FBManagerMBean.super.getPassword();
    }

    @Override
    public void setPassword(String password) {
        FBManagerMBean.super.setPassword(password);
    }

    @Override
    public String getRoleName() {
        return FBManagerMBean.super.getRoleName();
    }

    @Override
    public void setRoleName(String roleName) {
        FBManagerMBean.super.setRoleName(roleName);
    }

    @Override
    public String getAuthPlugins() {
        return FBManagerMBean.super.getAuthPlugins();
    }

    @Override
    public void setAuthPlugins(String authPlugins) {
        FBManagerMBean.super.setAuthPlugins(authPlugins);
    }

    @Override
    public void setEnableProtocol(String enableProtocol) {
        FBManagerMBean.super.setEnableProtocol(enableProtocol);
    }

    @Override
    public String getEnableProtocol() {
        return FBManagerMBean.super.getEnableProtocol();
    }

    @Override
    public void setDialect(int dialect) {
        if (dialect != 1 && dialect != 3) {
            throw new IllegalArgumentException("Only dialect 1 or 3 allowed");
        }
        this.dialect = dialect;
    }

    @Override
    public int getDialect() {
        return this.dialect;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = PageSizeConstants.requireValidPageSize(pageSize);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setDefaultCharacterSet(String firebirdCharsetName) {
        this.defaultCharacterSet = firebirdCharsetName;
    }

    @Override
    public String getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    @Override
    public void setForceWrite(Boolean forceWrite) {
        this.forceWrite = forceWrite;
    }

    @Override
    public Boolean getForceWrite() {
        return this.forceWrite;
    }

    @Override
    public boolean isCreateOnStart() {
        return this.createOnStart;
    }

    @Override
    public void setCreateOnStart(boolean createOnStart) {
        this.createOnStart = createOnStart;
    }

    @Override
    public boolean isDropOnStop() {
        return this.dropOnStop;
    }

    @Override
    public void setDropOnStop(boolean dropOnStop) {
        this.dropOnStop = dropOnStop;
    }

    @Override
    public boolean isForceCreate() {
        return this.forceCreate;
    }

    @Override
    public void setForceCreate(boolean forceCreate) {
        this.forceCreate = forceCreate;
    }

    @Override
    public void createDatabase(String fileName, String user, String password) throws Exception {
        this.createDatabase(fileName, user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createDatabase(String fileName, String user, String password, String roleName) throws Exception {
        FbDatabase db;
        IConnectionProperties connectionProperties2;
        block18: {
            this.checkStarted();
            try {
                connectionProperties2 = this.createDefaultConnectionProperties(user, password, roleName);
                connectionProperties2.setDatabaseName(fileName);
                db = this.dbFactory.connect(connectionProperties2);
                try {
                    db.attach();
                    if (this.forceCreate) {
                        db.dropDatabase();
                        break block18;
                    }
                    return;
                }
                finally {
                    if (db.isAttached()) {
                        db.close();
                    }
                }
            }
            catch (SQLException connectionProperties2) {
                // empty catch block
            }
        }
        try {
            connectionProperties2 = this.createDefaultConnectionProperties(user, password, roleName);
            connectionProperties2.setDatabaseName(fileName);
            connectionProperties2.setSqlDialect(this.dialect);
            if (this.getPageSize() != -1) {
                connectionProperties2.setIntProperty("page_size", this.getPageSize());
            }
            if (this.getDefaultCharacterSet() != null) {
                connectionProperties2.setProperty("set_db_charset", this.getDefaultCharacterSet());
            }
            if (this.forceWrite != null) {
                connectionProperties2.setBooleanProperty("force_write", this.forceWrite);
            }
            db = this.dbFactory.connect(connectionProperties2);
            try {
                db.createDatabase();
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        catch (Exception e) {
            log.log(System.Logger.Level.ERROR, "Exception creating database", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void dropDatabase(String fileName, String user, String password) throws Exception {
        this.dropDatabase(fileName, user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dropDatabase(String fileName, String user, String password, String roleName) throws Exception {
        this.checkStarted();
        try {
            IConnectionProperties connectionProperties = this.createDefaultConnectionProperties(user, password, roleName);
            connectionProperties.setDatabaseName(fileName);
            FbDatabase db = this.dbFactory.connect(connectionProperties);
            try {
                db.attach();
                db.dropDatabase();
            }
            finally {
                if (db.isAttached()) {
                    db.close();
                }
            }
        }
        catch (Exception e) {
            log.log(System.Logger.Level.ERROR, "Exception dropping database", (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized boolean isDatabaseExists(String fileName, String user, String password) throws Exception {
        this.checkStarted();
        try {
            IConnectionProperties connectionProperties = this.createDefaultConnectionProperties(user, password, null);
            connectionProperties.setDatabaseName(fileName);
            try (FbDatabase db = this.dbFactory.connect(connectionProperties);){
                db.attach();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private IConnectionProperties createDefaultConnectionProperties(String user, String password, String roleName) {
        IConnectionProperties connectionProperties = this.connectionProperties.asNewMutable();
        connectionProperties.setUser(user);
        connectionProperties.setPassword(password);
        connectionProperties.setRoleName(roleName);
        return connectionProperties;
    }

    private synchronized void checkStarted() {
        if (!STARTED.equals(this.state)) {
            throw new IllegalStateException("FBManager has not been started. Call start() before use.");
        }
    }

    @Override
    public final String getProperty(String name) {
        return this.connectionProperties.getProperty(name);
    }

    @Override
    public final void setProperty(String name, String value) {
        this.connectionProperties.setProperty(name, value);
    }

    @Override
    public final Integer getIntProperty(String name) {
        return this.connectionProperties.getIntProperty(name);
    }

    @Override
    public final void setIntProperty(String name, Integer value) {
        this.connectionProperties.setIntProperty(name, value);
    }

    @Override
    public final Boolean getBooleanProperty(String name) {
        return this.connectionProperties.getBooleanProperty(name);
    }

    @Override
    public final void setBooleanProperty(String name, Boolean value) {
        this.connectionProperties.setBooleanProperty(name, value);
    }

    @Override
    public final Map<ConnectionProperty, Object> connectionPropertyValues() {
        return this.connectionProperties.connectionPropertyValues();
    }
}

