/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Objects;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jaybird.util.ConditionalHelpers;
import org.firebirdsql.jdbc.ResultSetBehavior;

public record FetchConfig(int fetchSize, int maxRows, int direction, ResultSetBehavior resultSetBehavior) {
    public static final int USE_DEFAULT_FETCH_SIZE = 0;
    public static final int NO_MAX_ROWS = 0;

    public FetchConfig {
        if (fetchSize < 0) {
            throw new IllegalArgumentException("fetchSize must be >= 0, was: " + fetchSize);
        }
        if (maxRows < 0) {
            throw new IllegalArgumentException("maxRows must be >= 0, was: " + maxRows);
        }
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new IllegalArgumentException("Unsupported value for fetch direction, was: " + direction);
        }
        Objects.requireNonNull(resultSetBehavior, "resultSetBehavior");
    }

    public FetchConfig(ResultSetBehavior resultSetBehavior) {
        this(0, 0, 1000, resultSetBehavior);
    }

    public int fetchSizeOr(int defaultFetchSize) {
        return ConditionalHelpers.firstNonZero(this.fetchSize, defaultFetchSize);
    }

    public FetchConfig withFetchSize(int fetchSize) throws SQLException {
        if (this.fetchSize == fetchSize) {
            return this;
        }
        try {
            return new FetchConfig(fetchSize, this.maxRows, this.direction, this.resultSetBehavior);
        }
        catch (IllegalArgumentException e) {
            throw new SQLNonTransientException(e.getMessage(), "HY024");
        }
    }

    public FetchConfig withMaxRows(int maxRows) throws SQLException {
        if (this.maxRows == maxRows) {
            return this;
        }
        try {
            return new FetchConfig(this.fetchSize, maxRows, this.direction, this.resultSetBehavior);
        }
        catch (IllegalArgumentException e) {
            throw new SQLNonTransientException(e.getMessage(), "HY024");
        }
    }

    public FetchConfig withDirection(int direction) throws SQLException {
        if (this.direction == direction) {
            return this;
        }
        try {
            return new FetchConfig(this.fetchSize, this.maxRows, direction, this.resultSetBehavior);
        }
        catch (IllegalArgumentException e) {
            throw FbExceptionBuilder.forNonTransientException(337248278).messageParameter(direction).toSQLException();
        }
    }

    public FetchConfig withReadOnly() {
        if (this.resultSetBehavior.isReadOnly()) {
            return this;
        }
        return new FetchConfig(this.fetchSize, this.maxRows, this.direction, this.resultSetBehavior.withReadOnly());
    }
}

