/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.firebirdsql.gds.ClumpletReader;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.jaybird.util.ByteArrayHelper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record CachedInfoResponse(byte[] infoResponse) {
    private final byte[] infoResponse;
    private static final System.Logger logger = System.getLogger(CachedInfoResponse.class.getName());
    private static final CachedInfoResponse EMPTY = new CachedInfoResponse(ByteArrayHelper.emptyByteArray());

    public CachedInfoResponse {
        Objects.requireNonNull(infoResponse, "infoResponse");
    }

    public static CachedInfoResponse empty() {
        return EMPTY;
    }

    public byte[] filtered(byte[] requestItems) {
        return this.filtered(requestItems, true).orElseGet(() -> new byte[]{1});
    }

    public Optional<byte[]> filteredComplete(byte[] requestItems) {
        return this.filtered(requestItems, false);
    }

    private Optional<byte[]> filtered(byte[] requestItems, boolean returnPartial) {
        if (this.infoResponse.length == 0) {
            return Optional.empty();
        }
        try {
            int requestItem;
            ClumpletReader requested = new ClumpletReader(ClumpletReader.Kind.InfoItems, requestItems);
            ClumpletReader cached = new ClumpletReader(ClumpletReader.Kind.InfoResponse, this.infoResponse);
            ByteArrayOutputStream response = new ByteArrayOutputStream();
            requested.rewind();
            while (!requested.isEof() && (requestItem = requested.getClumpTag()) != 1) {
                if (cached.find(requestItem)) {
                    byte[] data = cached.getBytes();
                    response.write(requestItem);
                    VaxEncoding.encodeVaxInteger2WithoutLength(response, data.length);
                    response.write(data);
                } else if (!returnPartial) {
                    logger.log(System.Logger.Level.DEBUG, "Requested info item {0} not in cache, returning empty", requestItem);
                    return Optional.empty();
                }
                requested.moveNext();
            }
            response.write(1);
            return Optional.of(response.toByteArray());
        }
        catch (IOException | SQLException e) {
            logger.log(System.Logger.Level.WARNING, "Error in filteredResponse, returning empty", (Throwable)e);
            return Optional.empty();
        }
    }

    public byte[] infoResponse() {
        return (byte[])this.infoResponse.clone();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.infoResponse);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CachedInfoResponse)) return false;
        CachedInfoResponse that = (CachedInfoResponse)obj;
        if (!Arrays.equals(this.infoResponse, that.infoResponse)) return false;
        return true;
    }
}

