package spark.layouts
{
   import spark.layouts.supportClasses.LayoutBase;
   import mx.core.mx_internal;
   import mx.core.ILayoutElement;
   import spark.layouts.supportClasses.LayoutElementHelper;
   import spark.components.supportClasses.GroupBase;
   import spark.layouts.supportClasses.LinearLayoutVector;
   import mx.events.PropertyChangeEvent;
   import flash.events.Event;
   import flash.geom.Rectangle;
   import spark.core.NavigationUnit;
   import mx.containers.utilityClasses.Flex;
   import spark.layouts.supportClasses.DropLocation;
   import mx.core.IVisualElement;
   import flash.geom.Point;
   
   use namespace mx_internal;
   
   public class HorizontalLayout extends LayoutBase
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var llv:LinearLayoutVector;
      
      private var _gap:int = 6;
      
      private var _columnCount:int = -1;
      
      private var _paddingLeft:Number = 0;
      
      private var _paddingRight:Number = 0;
      
      private var _paddingTop:Number = 0;
      
      private var _paddingBottom:Number = 0;
      
      private var _requestedMinColumnCount:int = -1;
      
      private var _requestedColumnCount:int = -1;
      
      private var _columnWidth:Number;
      
      private var _variableColumnWidth:Boolean = true;
      
      private var _firstIndexInView:int = -1;
      
      private var _lastIndexInView:int = -1;
      
      private var _horizontalAlign:String = "left";
      
      private var _verticalAlign:String = "top";
      
      public function HorizontalLayout()
      {
         this.llv = new LinearLayoutVector(LinearLayoutVector.HORIZONTAL);
         super();
         dragScrollRegionSizeVertical = 0;
         this.llv.defaultMinorSize = 22;
         this.llv.defaultMajorSize = 71;
      }
      
      private static function calculatePercentHeight(layoutElement:ILayoutElement, height:Number) : Number
      {
         var percentHeight:Number = LayoutElementHelper.pinBetween(Math.round(layoutElement.percentHeight * 0.01 * height),layoutElement.getMinBoundsHeight(),layoutElement.getMaxBoundsHeight());
         return percentHeight < height?Number(percentHeight):Number(height);
      }
      
      private static function sizeLayoutElement(layoutElement:ILayoutElement, height:Number, verticalAlign:String, restrictedHeight:Number, width:Number, variableColumnWidth:Boolean, columnWidth:Number) : void
      {
         var newHeight:Number = NaN;
         if(Boolean(verticalAlign == VerticalAlign.JUSTIFY) || Boolean(verticalAlign == VerticalAlign.CONTENT_JUSTIFY))
         {
            newHeight = restrictedHeight;
         }
         else if(!isNaN(layoutElement.percentHeight))
         {
            newHeight = calculatePercentHeight(layoutElement,height);
         }
         if(variableColumnWidth)
         {
            layoutElement.setLayoutBoundsSize(width,newHeight);
         }
         else
         {
            layoutElement.setLayoutBoundsSize(columnWidth,newHeight);
         }
      }
      
      private static function findIndexAt(x:Number, gap:int, g:GroupBase, i0:int, i1:int) : int
      {
         var index:int = (i0 + i1) / 2;
         var element:ILayoutElement = g.getElementAt(index);
         var elementX:Number = element.getLayoutBoundsX();
         if(Boolean(x >= elementX) && Boolean(x < elementX + element.getLayoutBoundsWidth() + gap))
         {
            return index;
         }
         if(i0 == i1)
         {
            return -1;
         }
         if(x < elementX)
         {
            return findIndexAt(x,gap,g,i0,Math.max(i0,index - 1));
         }
         return findIndexAt(x,gap,g,Math.min(index + 1,i1),i1);
      }
      
      private static function findLayoutElementIndex(g:GroupBase, i:int, dir:int) : int
      {
         var element:ILayoutElement = null;
         var n:int = g.numElements;
         while(Boolean(i >= 0) && Boolean(i < n))
         {
            element = g.getElementAt(i);
            if(Boolean(element) && Boolean(element.includeInLayout))
            {
               return i;
            }
            i = i + dir;
         }
         return -1;
      }
      
      [Inspectable(category="General")]
      public function get gap() : int
      {
         return this._gap;
      }
      
      public function set gap(value:int) : void
      {
         if(this._gap == value)
         {
            return;
         }
         this._gap = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General")]
      [Bindable("propertyChange")]
      public function get columnCount() : int
      {
         return this._columnCount;
      }
      
      private function setColumnCount(value:int) : void
      {
         if(this._columnCount == value)
         {
            return;
         }
         var oldValue:int = this._columnCount;
         this._columnCount = value;
         dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"columnCount",oldValue,value));
      }
      
      [Inspectable(category="General")]
      public function get paddingLeft() : Number
      {
         return this._paddingLeft;
      }
      
      public function set paddingLeft(value:Number) : void
      {
         if(this._paddingLeft == value)
         {
            return;
         }
         this._paddingLeft = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General")]
      public function get paddingRight() : Number
      {
         return this._paddingRight;
      }
      
      public function set paddingRight(value:Number) : void
      {
         if(this._paddingRight == value)
         {
            return;
         }
         this._paddingRight = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General")]
      public function get paddingTop() : Number
      {
         return this._paddingTop;
      }
      
      public function set paddingTop(value:Number) : void
      {
         if(this._paddingTop == value)
         {
            return;
         }
         this._paddingTop = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General")]
      public function get paddingBottom() : Number
      {
         return this._paddingBottom;
      }
      
      public function set paddingBottom(value:Number) : void
      {
         if(this._paddingBottom == value)
         {
            return;
         }
         this._paddingBottom = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(minValue="-1",category="General")]
      public function get requestedMinColumnCount() : int
      {
         return this._requestedMinColumnCount;
      }
      
      public function set requestedMinColumnCount(value:int) : void
      {
         if(this._requestedMinColumnCount == value)
         {
            return;
         }
         this._requestedMinColumnCount = value;
         if(target)
         {
            target.invalidateSize();
         }
      }
      
      [Inspectable(minValue="-1",category="General")]
      public function get requestedColumnCount() : int
      {
         return this._requestedColumnCount;
      }
      
      public function set requestedColumnCount(value:int) : void
      {
         if(this._requestedColumnCount == value)
         {
            return;
         }
         this._requestedColumnCount = value;
         if(target)
         {
            target.invalidateSize();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get columnWidth() : Number
      {
         var elt:ILayoutElement = null;
         if(!isNaN(this._columnWidth))
         {
            return this._columnWidth;
         }
         elt = typicalLayoutElement;
         return Boolean(elt)?Number(elt.getPreferredBoundsWidth()):Number(0);
      }
      
      public function set columnWidth(value:Number) : void
      {
         if(this._columnWidth == value)
         {
            return;
         }
         this._columnWidth = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General",enumeration="true,false")]
      public function get variableColumnWidth() : Boolean
      {
         return this._variableColumnWidth;
      }
      
      public function set variableColumnWidth(value:Boolean) : void
      {
         if(value == this._variableColumnWidth)
         {
            return;
         }
         this._variableColumnWidth = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Bindable("indexInViewChanged")]
      [Inspectable(category="General")]
      public function get firstIndexInView() : int
      {
         return this._firstIndexInView;
      }
      
      [Bindable("indexInViewChanged")]
      [Inspectable(category="General")]
      public function get lastIndexInView() : int
      {
         return this._lastIndexInView;
      }
      
      [Inspectable(defaultValue="left",category="General",enumeration="left,right,center")]
      public function get horizontalAlign() : String
      {
         return this._horizontalAlign;
      }
      
      public function set horizontalAlign(value:String) : void
      {
         if(value == this._horizontalAlign)
         {
            return;
         }
         this._horizontalAlign = value;
         var layoutTarget:GroupBase = target;
         if(layoutTarget)
         {
            layoutTarget.invalidateDisplayList();
         }
      }
      
      [Inspectable(defaultValue="top",category="General",enumeration="top,bottom,middle,justify,contentJustify")]
      public function get verticalAlign() : String
      {
         return this._verticalAlign;
      }
      
      public function set verticalAlign(value:String) : void
      {
         if(value == this._verticalAlign)
         {
            return;
         }
         this._verticalAlign = value;
         var layoutTarget:GroupBase = target;
         if(layoutTarget)
         {
            layoutTarget.invalidateDisplayList();
         }
      }
      
      private function setIndexInView(firstIndex:int, lastIndex:int) : void
      {
         if(Boolean(this._firstIndexInView == firstIndex) && Boolean(this._lastIndexInView == lastIndex))
         {
            return;
         }
         this._firstIndexInView = firstIndex;
         this._lastIndexInView = lastIndex;
         dispatchEvent(new Event("indexInViewChanged"));
      }
      
      override public function set clipAndEnableScrolling(value:Boolean) : void
      {
         var g:GroupBase = null;
         super.clipAndEnableScrolling = value;
         var hAlign:String = this.horizontalAlign;
         if(Boolean(hAlign == HorizontalAlign.CENTER) || Boolean(hAlign == HorizontalAlign.RIGHT))
         {
            g = target;
            if(g)
            {
               g.invalidateDisplayList();
            }
         }
      }
      
      override public function clearVirtualLayoutCache() : void
      {
         this.llv.clear();
      }
      
      override public function getElementBounds(index:int) : Rectangle
      {
         if(!useVirtualLayout)
         {
            return super.getElementBounds(index);
         }
         var g:GroupBase = GroupBase(target);
         if(Boolean(!g) || Boolean(index < 0) || Boolean(index >= g.numElements))
         {
            return null;
         }
         return this.llv.getBounds(index);
      }
      
      public function fractionOfElementInView(index:int) : Number
      {
         var eltX:Number = NaN;
         var eltWidth:Number = NaN;
         var elt:ILayoutElement = null;
         var g:GroupBase = target;
         if(!g)
         {
            return 0;
         }
         if(Boolean(index < 0) || Boolean(index >= g.numElements))
         {
            return 0;
         }
         if(!clipAndEnableScrolling)
         {
            return 1;
         }
         var r0:int = this.firstIndexInView;
         var r1:int = this.lastIndexInView;
         if(Boolean(r0 == -1) || Boolean(r1 == -1) || Boolean(index < r0) || Boolean(index > r1))
         {
            return 0;
         }
         if(Boolean(index > r0) && Boolean(index < r1))
         {
            return 1;
         }
         if(useVirtualLayout)
         {
            eltX = this.llv.start(index);
            eltWidth = this.llv.getMajorSize(index);
         }
         else
         {
            elt = g.getElementAt(index);
            if(Boolean(!elt) || Boolean(!elt.includeInLayout))
            {
               return 0;
            }
            eltX = elt.getLayoutBoundsX();
            eltWidth = elt.getLayoutBoundsWidth();
         }
         var x0:Number = g.horizontalScrollPosition;
         var x1:Number = x0 + g.width;
         var ix0:Number = eltX;
         var ix1:Number = ix0 + eltWidth;
         if(ix0 >= ix1)
         {
            return 1;
         }
         if(Boolean(ix0 >= x0) && Boolean(ix1 <= x1))
         {
            return 1;
         }
         return (Math.min(x1,ix1) - Math.max(x0,ix0)) / (ix1 - ix0);
      }
      
      override protected function scrollPositionChanged() : void
      {
         var i0:int = 0;
         var i1:int = 0;
         var index0:int = 0;
         var element0:ILayoutElement = null;
         var element0X:Number = NaN;
         var element0Width:Number = NaN;
         var index1:int = 0;
         var element1:ILayoutElement = null;
         var element1X:Number = NaN;
         var element1Width:Number = NaN;
         super.scrollPositionChanged();
         var g:GroupBase = target;
         if(!g)
         {
            return;
         }
         var n:int = g.numElements - 1;
         if(n < 0)
         {
            this.setIndexInView(-1,-1);
            return;
         }
         var scrollR:Rectangle = getScrollRect();
         if(!scrollR)
         {
            this.setIndexInView(0,n);
            return;
         }
         var x0:Number = scrollR.left;
         var x1:Number = scrollR.right - 0.0001;
         if(x1 <= x0)
         {
            this.setIndexInView(-1,-1);
            return;
         }
         if(useVirtualLayout)
         {
            i0 = this.llv.indexOf(x0);
            i1 = this.llv.indexOf(x1);
         }
         else
         {
            i0 = findIndexAt(x0 + this.gap,this.gap,g,0,n);
            i1 = findIndexAt(x1,this.gap,g,0,n);
         }
         if(i0 == -1)
         {
            index0 = findLayoutElementIndex(g,0,1);
            if(index0 != -1)
            {
               element0 = g.getElementAt(index0);
               element0X = element0.getLayoutBoundsX();
               element0Width = element0.getLayoutBoundsWidth();
               if(Boolean(element0X < x1) && Boolean(element0X + element0Width > x0))
               {
                  i0 = index0;
               }
            }
         }
         if(i1 == -1)
         {
            index1 = findLayoutElementIndex(g,n,-1);
            if(index1 != -1)
            {
               element1 = g.getElementAt(index1);
               element1X = element1.getLayoutBoundsX();
               element1Width = element1.getLayoutBoundsWidth();
               if(Boolean(element1X < x1) && Boolean(element1X + element1Width > x0))
               {
                  i1 = index1;
               }
            }
         }
         if(useVirtualLayout)
         {
            g.invalidateDisplayList();
         }
         this.setIndexInView(i0,i1);
      }
      
      private function findLayoutElementBounds(g:GroupBase, i:int, dir:int, r:Rectangle) : Rectangle
      {
         var elementR:Rectangle = null;
         var overlapsLeft:Boolean = false;
         var overlapsRight:Boolean = false;
         var n:int = g.numElements;
         if(this.fractionOfElementInView(i) >= 1)
         {
            i = i + dir;
            if(i < 0)
            {
               return new Rectangle(0,0,this.paddingLeft,0);
            }
            if(i >= n)
            {
               return new Rectangle(this.getElementBounds(n - 1).right,0,this.paddingRight,0);
            }
         }
         while(Boolean(i >= 0) && Boolean(i < n))
         {
            elementR = this.getElementBounds(i);
            if(elementR)
            {
               overlapsLeft = Boolean(dir == -1) && Boolean(elementR.left == r.left) && Boolean(elementR.right >= r.right);
               overlapsRight = Boolean(dir == 1) && Boolean(elementR.right == r.right) && Boolean(elementR.left <= r.left);
               if(!(Boolean(overlapsLeft) || Boolean(overlapsRight)))
               {
                  return elementR;
               }
            }
            i = i + dir;
         }
         return null;
      }
      
      override protected function getElementBoundsLeftOfScrollRect(scrollRect:Rectangle) : Rectangle
      {
         return this.findLayoutElementBounds(target,this.firstIndexInView,-1,scrollRect);
      }
      
      override protected function getElementBoundsRightOfScrollRect(scrollRect:Rectangle) : Rectangle
      {
         return this.findLayoutElementBounds(target,this.lastIndexInView,1,scrollRect);
      }
      
      private function getElementWidth(element:ILayoutElement, fixedColumnWidth:Number, result:SizesAndLimit) : void
      {
         var elementPreferredWidth:Number = !!isNaN(fixedColumnWidth)?Number(Math.ceil(element.getPreferredBoundsWidth())):Number(fixedColumnWidth);
         var flexibleWidth:Boolean = !isNaN(element.percentWidth);
         var elementMinWidth:Number = !!flexibleWidth?Number(Math.ceil(element.getMinBoundsWidth())):Number(elementPreferredWidth);
         result.preferredSize = elementPreferredWidth;
         result.minSize = elementMinWidth;
      }
      
      private function getElementHeight(element:ILayoutElement, justify:Boolean, result:SizesAndLimit) : void
      {
         var elementPreferredHeight:Number = Math.ceil(element.getPreferredBoundsHeight());
         var flexibleHeight:Boolean = Boolean(!isNaN(element.percentHeight)) || Boolean(justify);
         var elementMinHeight:Number = !!flexibleHeight?Number(Math.ceil(element.getMinBoundsHeight())):Number(elementPreferredHeight);
         result.preferredSize = elementPreferredHeight;
         result.minSize = elementMinHeight;
      }
      
      private function measureReal(layoutTarget:GroupBase) : void
      {
         var element:ILayoutElement = null;
         var hgap:Number = NaN;
         var size:SizesAndLimit = new SizesAndLimit();
         var justify:Boolean = this.verticalAlign == VerticalAlign.JUSTIFY;
         var numElements:int = layoutTarget.numElements;
         var numElementsInLayout:int = numElements;
         var requestedColumnCount:int = this.requestedColumnCount;
         var columnsMeasured:int = 0;
         var preferredHeight:Number = 0;
         var preferredWidth:Number = 0;
         var minHeight:Number = 0;
         var minWidth:Number = 0;
         var fixedColumnWidth:Number = NaN;
         if(!this.variableColumnWidth)
         {
            fixedColumnWidth = this.columnWidth;
         }
         for(var i:int = 0; i < numElements; i++)
         {
            element = layoutTarget.getElementAt(i);
            if(Boolean(!element) || Boolean(!element.includeInLayout))
            {
               numElementsInLayout--;
            }
            else
            {
               this.getElementHeight(element,justify,size);
               preferredHeight = Math.max(preferredHeight,size.preferredSize);
               minHeight = Math.max(minHeight,size.minSize);
               if(Boolean(requestedColumnCount == -1) || Boolean(columnsMeasured < requestedColumnCount))
               {
                  this.getElementWidth(element,fixedColumnWidth,size);
                  preferredWidth = preferredWidth + size.preferredSize;
                  minWidth = minWidth + size.minSize;
                  columnsMeasured++;
               }
            }
         }
         var columnsToMeasure:int = requestedColumnCount != -1?int(requestedColumnCount):int(Math.max(this.requestedMinColumnCount,numElementsInLayout));
         if(columnsMeasured < columnsToMeasure)
         {
            element = typicalLayoutElement;
            if(element)
            {
               this.getElementHeight(element,justify,size);
               preferredHeight = Math.max(preferredHeight,size.preferredSize);
               minHeight = Math.max(minHeight,size.minSize);
               this.getElementWidth(element,fixedColumnWidth,size);
               preferredWidth = preferredWidth + size.preferredSize * (columnsToMeasure - columnsMeasured);
               minWidth = minWidth + size.minSize * (columnsToMeasure - columnsMeasured);
               columnsMeasured = columnsToMeasure;
            }
         }
         if(columnsMeasured > 1)
         {
            hgap = this.gap * (columnsMeasured - 1);
            preferredWidth = preferredWidth + hgap;
            minWidth = minWidth + hgap;
         }
         var hPadding:Number = this.paddingLeft + this.paddingRight;
         var vPadding:Number = this.paddingTop + this.paddingBottom;
         layoutTarget.measuredHeight = preferredHeight + vPadding;
         layoutTarget.measuredWidth = preferredWidth + hPadding;
         layoutTarget.measuredMinHeight = minHeight + vPadding;
         layoutTarget.measuredMinWidth = minWidth + hPadding;
      }
      
      private function updateLLV(layoutTarget:GroupBase) : void
      {
         var typicalWidth:Number = NaN;
         var typicalHeight:Number = NaN;
         var typicalElt:ILayoutElement = typicalLayoutElement;
         if(typicalElt)
         {
            typicalWidth = typicalElt.getPreferredBoundsWidth();
            typicalHeight = typicalElt.getPreferredBoundsHeight();
            this.llv.defaultMinorSize = typicalHeight;
            this.llv.defaultMajorSize = typicalWidth;
         }
         if(layoutTarget)
         {
            this.llv.length = layoutTarget.numElements;
         }
         this.llv.gap = this.gap;
         this.llv.majorAxisOffset = this.paddingLeft;
      }
      
      override public function elementAdded(index:int) : void
      {
         if(Boolean(index >= 0) && Boolean(useVirtualLayout))
         {
            this.llv.insert(index);
         }
      }
      
      override public function elementRemoved(index:int) : void
      {
         if(Boolean(index >= 0) && Boolean(useVirtualLayout))
         {
            this.llv.remove(index);
         }
      }
      
      private function measureVirtual(layoutTarget:GroupBase) : void
      {
         var oldLength:int = 0;
         var hgap:Number = NaN;
         var eltCount:uint = layoutTarget.numElements;
         var measuredEltCount:int = this.requestedColumnCount != -1?int(this.requestedColumnCount):int(Math.max(this.requestedMinColumnCount,eltCount));
         var hPadding:Number = this.paddingLeft + this.paddingRight;
         var vPadding:Number = this.paddingTop + this.paddingBottom;
         if(measuredEltCount <= 0)
         {
            layoutTarget.measuredWidth = layoutTarget.measuredMinWidth = hPadding;
            layoutTarget.measuredHeight = layoutTarget.measuredMinHeight = vPadding;
            return;
         }
         this.updateLLV(layoutTarget);
         if(this.variableColumnWidth)
         {
            oldLength = -1;
            if(measuredEltCount > this.llv.length)
            {
               oldLength = this.llv.length;
               this.llv.length = measuredEltCount;
            }
            layoutTarget.measuredWidth = this.llv.end(measuredEltCount - 1) + this.paddingRight;
            if(oldLength != -1)
            {
               this.llv.length = oldLength;
            }
         }
         else
         {
            hgap = measuredEltCount > 1?Number((measuredEltCount - 1) * this.gap):Number(0);
            layoutTarget.measuredWidth = measuredEltCount * this.columnWidth + hgap + hPadding;
         }
         layoutTarget.measuredHeight = this.llv.minorSize + vPadding;
         layoutTarget.measuredMinWidth = layoutTarget.measuredWidth;
         layoutTarget.measuredMinHeight = this.verticalAlign == VerticalAlign.JUSTIFY?Number(this.llv.minMinorSize + vPadding):Number(layoutTarget.measuredHeight);
      }
      
      override public function measure() : void
      {
         var layoutTarget:GroupBase = target;
         if(!layoutTarget)
         {
            return;
         }
         if(useVirtualLayout)
         {
            this.measureVirtual(layoutTarget);
         }
         else
         {
            this.measureReal(layoutTarget);
         }
         layoutTarget.measuredWidth = Math.ceil(layoutTarget.measuredWidth);
         layoutTarget.measuredHeight = Math.ceil(layoutTarget.measuredHeight);
         layoutTarget.measuredMinWidth = Math.ceil(layoutTarget.measuredMinWidth);
         layoutTarget.measuredMinHeight = Math.ceil(layoutTarget.measuredMinHeight);
      }
      
      override public function getNavigationDestinationIndex(currentIndex:int, navigationUnit:uint, arrowKeysWrapFocus:Boolean) : int
      {
         var newIndex:int = 0;
         var bounds:Rectangle = null;
         var x:Number = NaN;
         var firstVisible:int = 0;
         var firstFullyVisible:int = 0;
         var lastVisible:int = 0;
         var lastFullyVisible:int = 0;
         if(Boolean(!target) || Boolean(target.numElements < 1))
         {
            return -1;
         }
         var maxIndex:int = target.numElements - 1;
         if(currentIndex == -1)
         {
            if(navigationUnit == NavigationUnit.LEFT)
            {
               return !!arrowKeysWrapFocus?int(maxIndex):int(-1);
            }
            if(navigationUnit == NavigationUnit.RIGHT)
            {
               return 0;
            }
         }
         currentIndex = Math.max(0,Math.min(maxIndex,currentIndex));
         switch(navigationUnit)
         {
            case NavigationUnit.LEFT:
               if(Boolean(arrowKeysWrapFocus) && Boolean(currentIndex == 0))
               {
                  newIndex = maxIndex;
               }
               else
               {
                  newIndex = currentIndex - 1;
               }
               break;
            case NavigationUnit.RIGHT:
               if(Boolean(arrowKeysWrapFocus) && Boolean(currentIndex == maxIndex))
               {
                  newIndex = 0;
               }
               else
               {
                  newIndex = currentIndex + 1;
               }
               break;
            case NavigationUnit.PAGE_UP:
            case NavigationUnit.PAGE_LEFT:
               firstVisible = this.firstIndexInView;
               firstFullyVisible = firstVisible;
               if(this.fractionOfElementInView(firstFullyVisible) < 1)
               {
                  firstFullyVisible = firstFullyVisible + 1;
               }
               if(Boolean(firstFullyVisible < currentIndex) && Boolean(currentIndex <= this.lastIndexInView))
               {
                  newIndex = firstFullyVisible;
               }
               else
               {
                  if(Boolean(currentIndex == firstFullyVisible) || Boolean(currentIndex == firstVisible))
                  {
                     x = getHorizontalScrollPositionDelta(NavigationUnit.PAGE_LEFT) + getScrollRect().left;
                  }
                  else
                  {
                     x = this.getElementBounds(currentIndex).right - getScrollRect().width;
                  }
                  newIndex = currentIndex - 1;
                  while(0 <= newIndex)
                  {
                     bounds = this.getElementBounds(newIndex);
                     if(Boolean(bounds) && Boolean(bounds.left < x))
                     {
                        newIndex = Math.min(currentIndex - 1,newIndex + 1);
                        break;
                     }
                     newIndex--;
                  }
               }
               break;
            case NavigationUnit.PAGE_DOWN:
            case NavigationUnit.PAGE_RIGHT:
               lastVisible = this.lastIndexInView;
               lastFullyVisible = lastVisible;
               if(this.fractionOfElementInView(lastFullyVisible) < 1)
               {
                  lastFullyVisible = lastFullyVisible - 1;
               }
               if(Boolean(this.firstIndexInView <= currentIndex) && Boolean(currentIndex < lastFullyVisible))
               {
                  newIndex = lastFullyVisible;
               }
               else
               {
                  if(Boolean(currentIndex == lastFullyVisible) || Boolean(currentIndex == lastVisible))
                  {
                     x = getHorizontalScrollPositionDelta(NavigationUnit.PAGE_RIGHT) + getScrollRect().right;
                  }
                  else
                  {
                     x = this.getElementBounds(currentIndex).left + getScrollRect().width;
                  }
                  newIndex = currentIndex + 1;
                  while(newIndex <= maxIndex)
                  {
                     bounds = this.getElementBounds(newIndex);
                     if(Boolean(bounds) && Boolean(bounds.right > x))
                     {
                        newIndex = Math.max(currentIndex + 1,newIndex - 1);
                        break;
                     }
                     newIndex++;
                  }
               }
               break;
            default:
               return super.getNavigationDestinationIndex(currentIndex,navigationUnit,arrowKeysWrapFocus);
         }
         return Math.max(0,Math.min(maxIndex,newIndex));
      }
      
      private function calculateElementHeight(elt:ILayoutElement, targetHeight:Number, containerHeight:Number) : Number
      {
         var height:Number = NaN;
         var percentHeight:Number = elt.percentHeight;
         if(!isNaN(percentHeight))
         {
            height = percentHeight * 0.01 * targetHeight;
            return Math.min(targetHeight,Math.min(elt.getMaxBoundsHeight(),Math.max(elt.getMinBoundsHeight(),height)));
         }
         switch(this.verticalAlign)
         {
            case VerticalAlign.JUSTIFY:
               return targetHeight;
            case VerticalAlign.CONTENT_JUSTIFY:
               return Math.max(elt.getPreferredBoundsHeight(),containerHeight);
            default:
               return NaN;
         }
      }
      
      private function calculateElementY(elt:ILayoutElement, eltHeight:Number, containerHeight:Number) : Number
      {
         switch(this.verticalAlign)
         {
            case VerticalAlign.MIDDLE:
               return Math.round((containerHeight - eltHeight) * 0.5);
            case VerticalAlign.BOTTOM:
               return containerHeight - eltHeight;
            default:
               return 0;
         }
      }
      
      private function updateDisplayListVirtual() : void
      {
         var elt:ILayoutElement = null;
         var w:Number = NaN;
         var h:Number = NaN;
         var y:Number = NaN;
         var excessWidth:Number = NaN;
         var dx:Number = NaN;
         var hAlign:String = null;
         var layoutTarget:GroupBase = target;
         var eltCount:int = layoutTarget.numElements;
         var targetHeight:Number = Math.max(0,layoutTarget.height - this.paddingTop - this.paddingBottom);
         var minVisibleX:Number = layoutTarget.horizontalScrollPosition;
         var maxVisibleX:Number = minVisibleX + layoutTarget.width;
         this.updateLLV(layoutTarget);
         var startIndex:int = this.llv.indexOf(Math.max(0,minVisibleX + this.gap));
         if(startIndex == -1)
         {
            return;
         }
         var fixedColumnWidth:Number = NaN;
         if(!this.variableColumnWidth)
         {
            fixedColumnWidth = this.columnWidth;
         }
         var justifyHeights:Boolean = this.verticalAlign == VerticalAlign.JUSTIFY;
         var eltWidth:Number = NaN;
         var eltHeight:Number = !!justifyHeights?Number(Math.max(this.llv.minMinorSize,targetHeight)):Number(this.llv.minorSize);
         var contentHeight:Number = !!justifyHeights?Number(Math.max(this.llv.minMinorSize,targetHeight)):Number(this.llv.minorSize);
         var containerHeight:Number = Math.max(contentHeight,targetHeight);
         var x:Number = this.llv.start(startIndex);
         var index:int = startIndex;
         var y0:Number = this.paddingTop;
         while(Boolean(x < maxVisibleX) && Boolean(index < eltCount))
         {
            elt = layoutTarget.getVirtualElementAt(index);
            w = fixedColumnWidth;
            h = this.calculateElementHeight(elt,targetHeight,containerHeight);
            elt.setLayoutBoundsSize(w,h);
            w = elt.getLayoutBoundsWidth();
            h = elt.getLayoutBoundsHeight();
            y = y0 + this.calculateElementY(elt,h,containerHeight);
            elt.setLayoutBoundsPosition(x,y);
            this.llv.cacheDimensions(index,elt);
            x = x + (w + this.gap);
            index++;
         }
         var endIndex:int = index - 1;
         if(Boolean(!justifyHeights) && Boolean(this.llv.minorSize != contentHeight))
         {
            contentHeight = this.llv.minorSize;
            containerHeight = Math.max(contentHeight,targetHeight);
            if(Boolean(this.verticalAlign != VerticalAlign.TOP) && Boolean(this.verticalAlign != VerticalAlign.JUSTIFY))
            {
               for(index = startIndex; index <= endIndex; index++)
               {
                  elt = layoutTarget.getVirtualElementAt(index);
                  h = this.calculateElementHeight(elt,targetHeight,containerHeight);
                  elt.setLayoutBoundsSize(elt.getLayoutBoundsWidth(),h);
                  h = elt.getLayoutBoundsHeight();
                  y = y0 + this.calculateElementY(elt,h,containerHeight);
                  elt.setLayoutBoundsPosition(elt.getLayoutBoundsX(),y);
               }
            }
         }
         var contentWidth:Number = this.llv.end(this.llv.length - 1) - this.paddingLeft;
         var targetWidth:Number = Math.max(0,layoutTarget.width - this.paddingLeft - this.paddingRight);
         if(contentWidth < targetWidth)
         {
            excessWidth = targetWidth - contentWidth;
            dx = 0;
            hAlign = this.horizontalAlign;
            if(hAlign == HorizontalAlign.CENTER)
            {
               dx = Math.round(excessWidth / 2);
            }
            else if(hAlign == HorizontalAlign.RIGHT)
            {
               dx = excessWidth;
            }
            if(dx > 0)
            {
               for(index = startIndex; index <= endIndex; index++)
               {
                  elt = layoutTarget.getVirtualElementAt(index,NaN,NaN);
                  elt.setLayoutBoundsPosition(dx + elt.getLayoutBoundsX(),elt.getLayoutBoundsY());
               }
               contentWidth = contentWidth + dx;
            }
         }
         this.setColumnCount(index - startIndex);
         this.setIndexInView(startIndex,endIndex);
         var paddedContentWidth:Number = Math.ceil(contentWidth + this.paddingLeft + this.paddingRight);
         var paddedContentHeight:Number = Math.ceil(contentHeight + this.paddingTop + this.paddingBottom);
         layoutTarget.setContentSize(paddedContentWidth,paddedContentHeight);
      }
      
      private function updateDisplayListReal() : void
      {
         var layoutElement:ILayoutElement = null;
         var i:int = 0;
         var layoutElementHeight:Number = NaN;
         var hAlign:String = null;
         var dx:Number = NaN;
         var dy:Number = NaN;
         var y:Number = NaN;
         var layoutTarget:GroupBase = target;
         var targetWidth:Number = Math.max(0,layoutTarget.width - this.paddingLeft - this.paddingRight);
         var targetHeight:Number = Math.max(0,layoutTarget.height - this.paddingTop - this.paddingBottom);
         var count:uint = layoutTarget.numElements;
         var containerHeight:Number = targetHeight;
         if(Boolean(this.verticalAlign == VerticalAlign.CONTENT_JUSTIFY) || Boolean(clipAndEnableScrolling) && (Boolean(this.verticalAlign == VerticalAlign.MIDDLE) || Boolean(this.verticalAlign == VerticalAlign.BOTTOM)))
         {
            for(i = 0; i < count; i++)
            {
               layoutElement = layoutTarget.getElementAt(i);
               if(!(Boolean(!layoutElement) || Boolean(!layoutElement.includeInLayout)))
               {
                  if(!isNaN(layoutElement.percentHeight))
                  {
                     layoutElementHeight = calculatePercentHeight(layoutElement,targetHeight);
                  }
                  else
                  {
                     layoutElementHeight = layoutElement.getPreferredBoundsHeight();
                  }
                  containerHeight = Math.max(containerHeight,Math.ceil(layoutElementHeight));
               }
            }
         }
         var excessWidth:Number = this.distributeWidth(targetWidth,targetHeight,containerHeight);
         var vAlign:Number = 0;
         if(this.verticalAlign == VerticalAlign.MIDDLE)
         {
            vAlign = 0.5;
         }
         else if(this.verticalAlign == VerticalAlign.BOTTOM)
         {
            vAlign = 1;
         }
         var visibleColumns:uint = 0;
         var minVisibleX:Number = layoutTarget.horizontalScrollPosition;
         var maxVisibleX:Number = minVisibleX + targetWidth;
         var x:Number = this.paddingLeft;
         var y0:Number = this.paddingTop;
         var maxX:Number = this.paddingLeft;
         var maxY:Number = this.paddingTop;
         var firstColInView:int = -1;
         var lastColInView:int = -1;
         if(Boolean(excessWidth > 0) || Boolean(!clipAndEnableScrolling))
         {
            hAlign = this.horizontalAlign;
            if(hAlign == HorizontalAlign.CENTER)
            {
               x = this.paddingLeft + Math.round(excessWidth / 2);
            }
            else if(hAlign == HorizontalAlign.RIGHT)
            {
               x = this.paddingLeft + excessWidth;
            }
         }
         for(var index:int = 0; index < count; index++)
         {
            layoutElement = layoutTarget.getElementAt(index);
            if(!(Boolean(!layoutElement) || Boolean(!layoutElement.includeInLayout)))
            {
               dx = Math.ceil(layoutElement.getLayoutBoundsWidth());
               dy = Math.ceil(layoutElement.getLayoutBoundsHeight());
               y = y0 + (containerHeight - dy) * vAlign;
               if(vAlign == 0.5)
               {
                  y = Math.round(y);
               }
               layoutElement.setLayoutBoundsPosition(x,y);
               maxX = Math.max(maxX,x + dx);
               maxY = Math.max(maxY,y + dy);
               if(Boolean(!clipAndEnableScrolling) || Boolean(x < maxVisibleX) && Boolean(x + dx > minVisibleX) || Boolean(dx <= 0) && (Boolean(x == maxVisibleX) || Boolean(x == minVisibleX)))
               {
                  visibleColumns = visibleColumns + 1;
                  if(firstColInView == -1)
                  {
                     firstColInView = lastColInView = index;
                  }
                  else
                  {
                     lastColInView = index;
                  }
               }
               x = x + (dx + this.gap);
            }
         }
         this.setColumnCount(visibleColumns);
         this.setIndexInView(firstColInView,lastColInView);
         layoutTarget.setContentSize(Math.ceil(maxX + this.paddingRight),Math.ceil(maxY + this.paddingBottom));
      }
      
      private function distributeWidth(width:Number, height:Number, restrictedHeight:Number) : Number
      {
         var childInfo:HLayoutElementFlexChildInfo = null;
         var newHeight:Number = NaN;
         var layoutElement:ILayoutElement = null;
         var roundOff:Number = NaN;
         var childSize:int = 0;
         var spaceToDistribute:Number = width;
         var totalPercentWidth:Number = 0;
         var childInfoArray:Array = [];
         var cw:Number = !!this.variableColumnWidth?Number(0):Number(Math.ceil(this.columnWidth));
         var count:uint = target.numElements;
         var totalCount:uint = count;
         for(var index:int = 0; index < count; index++)
         {
            layoutElement = target.getElementAt(index);
            if(Boolean(!layoutElement) || Boolean(!layoutElement.includeInLayout))
            {
               totalCount--;
            }
            else if(Boolean(!isNaN(layoutElement.percentWidth)) && Boolean(this.variableColumnWidth))
            {
               totalPercentWidth = totalPercentWidth + layoutElement.percentWidth;
               childInfo = new HLayoutElementFlexChildInfo();
               childInfo.layoutElement = layoutElement;
               childInfo.percent = layoutElement.percentWidth;
               childInfo.min = layoutElement.getMinBoundsWidth();
               childInfo.max = layoutElement.getMaxBoundsWidth();
               childInfoArray.push(childInfo);
            }
            else
            {
               sizeLayoutElement(layoutElement,height,this.verticalAlign,restrictedHeight,NaN,this.variableColumnWidth,cw);
               spaceToDistribute = spaceToDistribute - Math.ceil(layoutElement.getLayoutBoundsWidth());
            }
         }
         if(totalCount > 1)
         {
            spaceToDistribute = spaceToDistribute - (totalCount - 1) * this.gap;
         }
         if(totalPercentWidth)
         {
            Flex.flexChildrenProportionally(width,spaceToDistribute,totalPercentWidth,childInfoArray);
            roundOff = 0;
            for each(childInfo in childInfoArray)
            {
               childSize = Math.round(childInfo.size + roundOff);
               roundOff = roundOff + (childInfo.size - childSize);
               sizeLayoutElement(childInfo.layoutElement,height,this.verticalAlign,restrictedHeight,childSize,this.variableColumnWidth,cw);
               spaceToDistribute = spaceToDistribute - childSize;
            }
         }
         return spaceToDistribute;
      }
      
      override public function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         var layoutTarget:GroupBase = target;
         if(!layoutTarget)
         {
            return;
         }
         if(Boolean(layoutTarget.numElements == 0) || Boolean(unscaledWidth == 0) || Boolean(unscaledHeight == 0))
         {
            this.setColumnCount(0);
            this.setIndexInView(-1,-1);
            if(layoutTarget.numElements == 0)
            {
               layoutTarget.setContentSize(Math.ceil(this.paddingLeft + this.paddingRight),Math.ceil(this.paddingTop + this.paddingBottom));
            }
            return;
         }
         if(useVirtualLayout)
         {
            this.updateDisplayListVirtual();
         }
         else
         {
            this.updateDisplayListReal();
         }
      }
      
      private function invalidateTargetSizeAndDisplayList() : void
      {
         var g:GroupBase = target;
         if(!g)
         {
            return;
         }
         g.invalidateSize();
         g.invalidateDisplayList();
      }
      
      override protected function calculateDropIndex(x:Number, y:Number) : int
      {
         var elementBounds:Rectangle = null;
         var curDistance:Number = NaN;
         var centerX:Number = NaN;
         var layoutTarget:GroupBase = target;
         var count:int = layoutTarget.numElements;
         if(count == 0)
         {
            return 0;
         }
         var minDistance:Number = Number.MAX_VALUE;
         var bestIndex:int = -1;
         var start:int = this.firstIndexInView;
         var end:int = this.lastIndexInView;
         for(var i:int = start; i <= end; i++)
         {
            elementBounds = this.getElementBounds(i);
            if(elementBounds)
            {
               if(Boolean(elementBounds.left <= x) && Boolean(x <= elementBounds.right))
               {
                  centerX = elementBounds.x + elementBounds.width / 2;
                  return x < centerX?int(i):int(i + 1);
               }
               curDistance = Math.min(Math.abs(x - elementBounds.left),Math.abs(x - elementBounds.right));
               if(curDistance < minDistance)
               {
                  minDistance = curDistance;
                  bestIndex = x < elementBounds.left?int(i):int(i + 1);
               }
            }
         }
         if(bestIndex == -1)
         {
            bestIndex = this.getElementBounds(0).x < x?int(count):int(0);
         }
         return bestIndex;
      }
      
      override protected function calculateDropIndicatorBounds(dropLocation:DropLocation) : Rectangle
      {
         var element:IVisualElement = null;
         var dropIndex:int = dropLocation.dropIndex;
         var count:int = target.numElements;
         var gap:Number = this.gap;
         if(Boolean(gap < 0) && Boolean(dropIndex == count))
         {
            gap = 0;
         }
         var emptySpace:Number = 0 < gap?Number(gap):Number(0);
         var emptySpaceLeft:Number = 0;
         if(target.numElements > 0)
         {
            emptySpaceLeft = dropIndex < count?Number(this.getElementBounds(dropIndex).left - emptySpace):Number(this.getElementBounds(dropIndex - 1).right + gap - emptySpace);
         }
         var width:Number = emptySpace;
         var height:Number = Math.max(target.height,target.contentHeight) - this.paddingTop - this.paddingBottom;
         if(dropIndicator is IVisualElement)
         {
            element = IVisualElement(dropIndicator);
            width = Math.max(Math.min(width,element.getMaxBoundsWidth(false)),element.getMinBoundsWidth(false));
         }
         var x:Number = emptySpaceLeft + Math.round((emptySpace - width) / 2);
         x = Math.max(-Math.ceil(width / 2),Math.min(target.contentWidth - Math.ceil(width / 2),x));
         var y:Number = this.paddingTop;
         return new Rectangle(x,y,width,height);
      }
      
      override protected function calculateDragScrollDelta(dropLocation:DropLocation, elapsedTime:Number) : Point
      {
         var delta:Point = super.calculateDragScrollDelta(dropLocation,elapsedTime);
         if(delta)
         {
            delta.y = 0;
         }
         return delta;
      }
   }
}

import mx.containers.utilityClasses.FlexChildInfo;
import mx.core.ILayoutElement;

class HLayoutElementFlexChildInfo extends FlexChildInfo
{
    
   public var layoutElement:ILayoutElement;
   
   function HLayoutElementFlexChildInfo()
   {
      super();
   }
}

class SizesAndLimit
{
    
   public var preferredSize:Number;
   
   public var minSize:Number;
   
   function SizesAndLimit()
   {
      super();
   }
}
