package spark.components.supportClasses
{
   import mx.managers.IFocusManagerComponent;
   import mx.core.mx_internal;
   import flash.utils.Timer;
   import flash.events.Event;
   import mx.events.FlexEvent;
   import flash.events.MouseEvent;
   import mx.events.SandboxMouseEvent;
   import flash.events.TimerEvent;
   import flash.events.FocusEvent;
   import flash.events.KeyboardEvent;
   import flash.ui.Keyboard;
   
   use namespace mx_internal;
   
   [DefaultProperty("label")]
   [DefaultTriggerEvent("click")]
   [AccessibilityClass(implementation="spark.accessibility.ButtonBaseAccImpl")]
   [SkinState("disabled")]
   [SkinState("down")]
   [SkinState("over")]
   [SkinState("up")]
   [Event(name="buttonDown",type="mx.events.FlexEvent")]
   [Style(inherit="no",name="repeatInterval",format="Time",type="Number",minValueExclusive="0.0")]
   [Style(minValue="0.0",inherit="no",name="repeatDelay",format="Time",type="Number")]
   [Style(inherit="yes",name="focusColor",format="Color",theme="spark",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="no",name="focusAlpha",theme="spark",type="Number")]
   [Style(minValue="0.0",inherit="no",name="cornerRadius",format="Length",theme="spark",type="Number")]
   [Style(inherit="yes",name="typographicCase",type="String",enumeration="default,capsToSmallCaps,uppercase,lowercase,lowercaseToSmallCaps")]
   [Style(inherit="yes",name="trackingRight",type="Object")]
   [Style(inherit="yes",name="trackingLeft",type="Object")]
   [Style(inherit="yes",name="textJustify",type="String",enumeration="interWord,distribute")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="textAlpha",type="Number")]
   [Style(inherit="yes",name="textAlignLast",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="renderingMode",type="String",enumeration="cff,normal")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="lineThrough",type="Boolean")]
   [Style(inherit="yes",name="lineHeight",type="Object")]
   [Style(inherit="yes",name="ligatureLevel",type="String",enumeration="common,minimum,uncommon,exotic")]
   [Style(inherit="yes",name="kerning",type="String",enumeration="auto,on,off")]
   [Style(inherit="yes",name="justificationStyle",type="String",enumeration="auto,prioritizeLeastAdjustment,pushInKinsoku,pushOutOnly")]
   [Style(inherit="yes",name="justificationRule",type="String",enumeration="auto,space,eastAsian")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(minValue="1.0",maxValue="720.0",inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontLookup",type="String",enumeration="auto,device,embeddedCFF")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="dominantBaseline",type="String",enumeration="auto,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl")]
   [Style(inherit="yes",name="digitWidth",type="String",enumeration="default,proportional,tabular")]
   [Style(inherit="yes",name="digitCase",type="String",enumeration="default,lining,oldStyle")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="yes",name="cffHinting",type="String",enumeration="horizontalStem,none")]
   [Style(inherit="yes",name="baselineShift",type="Object")]
   [Style(inherit="yes",name="alignmentBaseline",type="String",enumeration="useDominantBaseline,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   public class ButtonBase extends SkinnableComponent implements IFocusManagerComponent
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      mx_internal static var createAccessibilityImplementation:Function;
       
      private var _downEventFired:Boolean = false;
      
      private var checkForButtonDownConditions:Boolean = false;
      
      private var autoRepeatTimer:Timer;
      
      [SkinPart(required="false")]
      public var labelDisplay:spark.components.supportClasses.TextBase;
      
      [Inspectable(defaultValue="null",category="General")]
      private var _explicitToolTip:Boolean = false;
      
      private var _autoRepeat:Boolean;
      
      private var _content;
      
      private var _hovered:Boolean = false;
      
      private var _keepDown:Boolean = false;
      
      private var _keyboardPressed:Boolean = false;
      
      private var _mouseCaptured:Boolean = false;
      
      private var _stickyHighlighting:Boolean = false;
      
      public function ButtonBase()
      {
         super();
         mouseChildren = false;
         this.addHandlers();
      }
      
      override public function get baselinePosition() : Number
      {
         return getBaselinePositionForPart(this.labelDisplay);
      }
      
      override public function set toolTip(value:String) : void
      {
         super.toolTip = value;
         this._explicitToolTip = value != null;
      }
      
      [Inspectable(defaultValue="false")]
      public function get autoRepeat() : Boolean
      {
         return this._autoRepeat;
      }
      
      public function set autoRepeat(value:Boolean) : void
      {
         if(value == this._autoRepeat)
         {
            return;
         }
         this._autoRepeat = value;
         this.checkAutoRepeatTimerConditions(this.isDown());
      }
      
      [Bindable("contentChange")]
      public function get content() : Object
      {
         return this._content;
      }
      
      public function set content(value:Object) : void
      {
         this._content = value;
         if(this.labelDisplay)
         {
            this.labelDisplay.text = this.label;
         }
         dispatchEvent(new Event("contentChange"));
      }
      
      protected function get hovered() : Boolean
      {
         return this._hovered;
      }
      
      protected function set hovered(value:Boolean) : void
      {
         if(value == this._hovered)
         {
            return;
         }
         this._hovered = value;
         this.invalidateButtonState();
      }
      
      mx_internal function keepDown(down:Boolean, fireEvent:Boolean = true) : void
      {
         if(this._keepDown == down)
         {
            return;
         }
         this._keepDown = down;
         if(!fireEvent)
         {
            this._downEventFired = true;
         }
         if(this._keepDown)
         {
            invalidateSkinState();
         }
         else
         {
            this.invalidateButtonState();
         }
      }
      
      protected function get keyboardPressed() : Boolean
      {
         return this._keyboardPressed;
      }
      
      protected function set keyboardPressed(value:Boolean) : void
      {
         if(value == this._keyboardPressed)
         {
            return;
         }
         this._keyboardPressed = value;
         this.invalidateButtonState();
      }
      
      [Bindable("contentChange")]
      public function set label(value:String) : void
      {
         this.content = value;
      }
      
      public function get label() : String
      {
         return this.content != null?this.content.toString():"";
      }
      
      protected function get mouseCaptured() : Boolean
      {
         return this._mouseCaptured;
      }
      
      protected function set mouseCaptured(value:Boolean) : void
      {
         if(value == this._mouseCaptured)
         {
            return;
         }
         this._mouseCaptured = value;
         this.invalidateButtonState();
         if(!value)
         {
            this.removeSystemMouseHandlers();
         }
      }
      
      public function get stickyHighlighting() : Boolean
      {
         return this._stickyHighlighting;
      }
      
      public function set stickyHighlighting(value:Boolean) : void
      {
         if(value == this._stickyHighlighting)
         {
            return;
         }
         this._stickyHighlighting = value;
         this.invalidateButtonState();
      }
      
      override protected function initializeAccessibility() : void
      {
         if(ButtonBase.createAccessibilityImplementation != null)
         {
            ButtonBase.createAccessibilityImplementation(this);
         }
      }
      
      override protected function commitProperties() : void
      {
         var isCurrentlyDown:Boolean = false;
         super.commitProperties();
         if(this.checkForButtonDownConditions)
         {
            isCurrentlyDown = this.isDown();
            if(this._downEventFired != isCurrentlyDown)
            {
               if(isCurrentlyDown)
               {
                  dispatchEvent(new FlexEvent(FlexEvent.BUTTON_DOWN));
               }
               this._downEventFired = isCurrentlyDown;
               this.checkAutoRepeatTimerConditions(isCurrentlyDown);
            }
            this.checkForButtonDownConditions = false;
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         super.partAdded(partName,instance);
         if(instance == this.labelDisplay)
         {
            this.labelDisplay.addEventListener("isTruncatedChanged",this.labelDisplay_isTruncatedChangedHandler);
            if(this._content !== undefined)
            {
               this.labelDisplay.text = this.label;
            }
         }
      }
      
      override protected function partRemoved(partName:String, instance:Object) : void
      {
         super.partRemoved(partName,instance);
         if(instance == this.labelDisplay)
         {
            this.labelDisplay.removeEventListener("isTruncatedChanged",this.labelDisplay_isTruncatedChangedHandler);
         }
      }
      
      override protected function getCurrentSkinState() : String
      {
         if(!enabled)
         {
            return "disabled";
         }
         if(this.isDown())
         {
            return "down";
         }
         if(Boolean(this.hovered) || Boolean(this.mouseCaptured))
         {
            return "over";
         }
         return "up";
      }
      
      protected function addHandlers() : void
      {
         addEventListener(MouseEvent.ROLL_OVER,this.mouseEventHandler);
         addEventListener(MouseEvent.ROLL_OUT,this.mouseEventHandler);
         addEventListener(MouseEvent.MOUSE_DOWN,this.mouseEventHandler);
         addEventListener(MouseEvent.MOUSE_UP,this.mouseEventHandler);
         addEventListener(MouseEvent.CLICK,this.mouseEventHandler);
      }
      
      private function addSystemMouseHandlers() : void
      {
         systemManager.getSandboxRoot().addEventListener(MouseEvent.MOUSE_UP,this.systemManager_mouseUpHandler,true);
         systemManager.getSandboxRoot().addEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.systemManager_mouseUpHandler);
      }
      
      private function removeSystemMouseHandlers() : void
      {
         systemManager.getSandboxRoot().removeEventListener(MouseEvent.MOUSE_UP,this.systemManager_mouseUpHandler,true);
         systemManager.getSandboxRoot().removeEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.systemManager_mouseUpHandler);
      }
      
      private function isDown() : Boolean
      {
         if(!enabled)
         {
            return false;
         }
         if(this._keepDown)
         {
            return true;
         }
         if(this.keyboardPressed)
         {
            return true;
         }
         if(Boolean(this.mouseCaptured) && (Boolean(this.hovered) || Boolean(this.stickyHighlighting)))
         {
            return true;
         }
         return false;
      }
      
      private function invalidateButtonState() : void
      {
         this.checkForButtonDownConditions = true;
         invalidateProperties();
         invalidateSkinState();
      }
      
      private function checkAutoRepeatTimerConditions(buttonDown:Boolean) : void
      {
         var needsTimer:Boolean = Boolean(this.autoRepeat) && Boolean(buttonDown);
         var hasTimer:Boolean = this.autoRepeatTimer != null;
         if(needsTimer == hasTimer)
         {
            return;
         }
         if(needsTimer)
         {
            this.startTimer();
         }
         else
         {
            this.stopTimer();
         }
      }
      
      private function startTimer() : void
      {
         this.autoRepeatTimer = new Timer(1);
         this.autoRepeatTimer.delay = getStyle("repeatDelay");
         this.autoRepeatTimer.addEventListener(TimerEvent.TIMER,this.autoRepeat_timerDelayHandler);
         this.autoRepeatTimer.start();
      }
      
      private function stopTimer() : void
      {
         this.autoRepeatTimer.stop();
         this.autoRepeatTimer = null;
      }
      
      protected function buttonReleased() : void
      {
      }
      
      override protected function focusOutHandler(event:FocusEvent) : void
      {
         super.focusOutHandler(event);
         this.mouseCaptured = false;
         this.keyboardPressed = false;
      }
      
      override protected function keyDownHandler(event:KeyboardEvent) : void
      {
         if(event.keyCode != Keyboard.SPACE)
         {
            return;
         }
         this.keyboardPressed = true;
         event.updateAfterEvent();
      }
      
      override protected function keyUpHandler(event:KeyboardEvent) : void
      {
         if(event.keyCode != Keyboard.SPACE)
         {
            return;
         }
         if(Boolean(enabled) && Boolean(this.keyboardPressed))
         {
            this.buttonReleased();
            this.keyboardPressed = false;
            dispatchEvent(new MouseEvent(MouseEvent.CLICK));
         }
         event.updateAfterEvent();
      }
      
      protected function mouseEventHandler(event:Event) : void
      {
         var mouseEvent:MouseEvent = event as MouseEvent;
         switch(event.type)
         {
            case MouseEvent.ROLL_OVER:
               if(Boolean(mouseEvent.buttonDown) && Boolean(!this.mouseCaptured))
               {
                  return;
               }
               this.hovered = true;
               break;
            case MouseEvent.ROLL_OUT:
               this.hovered = false;
               break;
            case MouseEvent.MOUSE_DOWN:
               this.addSystemMouseHandlers();
               this.mouseCaptured = true;
               break;
            case MouseEvent.MOUSE_UP:
               if(event.target == this)
               {
                  this.hovered = true;
                  if(this.mouseCaptured)
                  {
                     this.buttonReleased();
                     this.mouseCaptured = false;
                  }
               }
               break;
            case MouseEvent.CLICK:
               if(!enabled)
               {
                  event.stopImmediatePropagation();
               }
               else
               {
                  this.clickHandler(MouseEvent(event));
               }
               return;
         }
         if(mouseEvent)
         {
            mouseEvent.updateAfterEvent();
         }
      }
      
      protected function clickHandler(event:MouseEvent) : void
      {
      }
      
      private function systemManager_mouseUpHandler(event:Event) : void
      {
         if(event.target == this)
         {
            return;
         }
         this.mouseCaptured = false;
      }
      
      private function autoRepeat_timerDelayHandler(event:TimerEvent) : void
      {
         this.autoRepeatTimer.reset();
         this.autoRepeatTimer.removeEventListener(TimerEvent.TIMER,this.autoRepeat_timerDelayHandler);
         this.autoRepeatTimer.delay = getStyle("repeatInterval");
         this.autoRepeatTimer.addEventListener(TimerEvent.TIMER,this.autoRepeat_timerHandler);
         this.autoRepeatTimer.start();
      }
      
      private function autoRepeat_timerHandler(event:TimerEvent) : void
      {
         dispatchEvent(new FlexEvent(FlexEvent.BUTTON_DOWN));
      }
      
      private function labelDisplay_isTruncatedChangedHandler(event:Event) : void
      {
         if(this._explicitToolTip)
         {
            return;
         }
         var isTruncated:Boolean = this.labelDisplay.isTruncated;
         super.toolTip = !!isTruncated?this.labelDisplay.text:null;
      }
   }
}
