package spark.components
{
   import spark.components.supportClasses.SkinnableTextBase;
   import mx.core.mx_internal;
   import flash.events.Event;
   
   use namespace mx_internal;
   
   [IconFile("TextInput.png")]
   [DefaultTriggerEvent("change")]
   [DefaultProperty("text")]
   [Exclude(kind="style",name="lineBreak")]
   [Exclude(kind="style",name="verticalAlign")]
   [SkinState("disabled")]
   [SkinState("normal")]
   [Event(name="enter",type="mx.events.FlexEvent")]
   public class TextInput extends SkinnableTextBase
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static const focusExclusions:Array = ["textDisplay"];
       
      public function TextInput()
      {
         super();
      }
      
      override public function get suggestedFocusSkinExclusions() : Array
      {
         return focusExclusions;
      }
      
      [CollapseWhiteSpace]
      [Bindable("textChanged")]
      [Bindable("change")]
      override public function set text(value:String) : void
      {
         super.text = value;
         dispatchEvent(new Event("textChanged"));
      }
      
      [Inspectable(minValue="0.0")]
      public function get widthInChars() : Number
      {
         return getWidthInChars();
      }
      
      public function set widthInChars(value:Number) : void
      {
         setWidthInChars(value);
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         super.partAdded(partName,instance);
         if(instance == textDisplay)
         {
            textDisplay.multiline = false;
            textDisplay.setStyle("lineBreak","explicit");
            textDisplay.heightInLines = 1;
         }
      }
   }
}
