package spark.components
{
   import spark.components.supportClasses.ButtonBase;
   import mx.core.IButton;
   import mx.core.mx_internal;
   import flash.events.Event;
   
   use namespace mx_internal;
   
   [IconFile("Button.png")]
   [Exclude(kind="style",name="textAlign")]
   [Style(inherit="yes",name="accentColor",format="Color",theme="spark",type="uint")]
   public class Button extends ButtonBase implements IButton
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var _emphasized:Boolean = false;
      
      public function Button()
      {
         super();
      }
      
      [Inspectable(defaultValue="false",category="General")]
      [Bindable("emphasizedChanged")]
      public function get emphasized() : Boolean
      {
         return this._emphasized;
      }
      
      public function set emphasized(value:Boolean) : void
      {
         if(value == this._emphasized)
         {
            return;
         }
         this._emphasized = value;
         this.emphasizeStyleName();
         dispatchEvent(new Event("emphasizedChanged"));
      }
      
      override public function set styleName(value:Object) : void
      {
         super.styleName = value;
         if(Boolean(value == null) || Boolean(value is String))
         {
            if(Boolean(!value) || Boolean(this._emphasized) && Boolean(value.indexOf(" emphasized") == -1))
            {
               this.emphasizeStyleName();
            }
         }
      }
      
      private function emphasizeStyleName() : void
      {
         var style:String = styleName is String?styleName as String:"";
         if(Boolean(!styleName) || Boolean(styleName is String))
         {
            if(this._emphasized)
            {
               super.styleName = style + " emphasized";
            }
            else
            {
               super.styleName = style.split(" emphasized").join("");
            }
         }
      }
   }
}
