package org.alivepdf.export
{
   import org.alivepdf.serializer.ISerializer;
   import flash.utils.ByteArray;
   import org.alivepdf.data.GridColumn;
   
   public final class CSVExport implements ISerializer
   {
       
      private var _data:Array;
      
      private var _columns:Array;
      
      private var buffer:String;
      
      private var output:ByteArray;
      
      public function CSVExport(data:Array, columns:Array)
      {
         this.buffer = new String();
         this.output = new ByteArray();
         super();
         this._data = data;
         this._columns = columns;
      }
      
      public function serialize() : ByteArray
      {
         var line:String = null;
         var column:GridColumn = null;
         var field:String = null;
         var item:Object = null;
         var i:int = 0;
         if(this._columns == null)
         {
            throw new Error("Set the Grid.columns property to use the export feature.");
         }
         var lng:int = this._columns.length;
         var delimiter:String = ";";
         for each(item in this._data)
         {
            line = new String();
            for(i = 0; i < lng; i++)
            {
               column = this._columns[i];
               field = item[column.dataField] != null?item[column.dataField]:"";
               line = line + (line.length > 0?delimiter + field:field);
            }
            line = line + "\n";
            this.buffer = this.buffer + line;
         }
         this.output.writeUTFBytes(this.buffer);
         return this.output;
      }
   }
}
