package mx.managers
{
   import mx.core.mx_internal;
   import mx.core.Singleton;
   import mx.core.IFlexDisplayObject;
   import flash.display.DisplayObject;
   import mx.core.IFlexModuleFactory;
   
   use namespace mx_internal;
   
   public class PopUpManager
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var implClassDependency:mx.managers.PopUpManagerImpl;
      
      private static var _impl:mx.managers.IPopUpManager;
       
      public function PopUpManager()
      {
         super();
      }
      
      private static function get impl() : mx.managers.IPopUpManager
      {
         if(!_impl)
         {
            _impl = IPopUpManager(Singleton.getInstance("mx.managers::IPopUpManager"));
         }
         return _impl;
      }
      
      public static function createPopUp(parent:DisplayObject, className:Class, modal:Boolean = false, childList:String = null, moduleFactory:IFlexModuleFactory = null) : IFlexDisplayObject
      {
         return impl.createPopUp(parent,className,modal,childList,moduleFactory);
      }
      
      public static function addPopUp(window:IFlexDisplayObject, parent:DisplayObject, modal:Boolean = false, childList:String = null, moduleFactory:IFlexModuleFactory = null) : void
      {
         impl.addPopUp(window,parent,modal,childList,moduleFactory);
      }
      
      public static function centerPopUp(popUp:IFlexDisplayObject) : void
      {
         impl.centerPopUp(popUp);
      }
      
      public static function removePopUp(popUp:IFlexDisplayObject) : void
      {
         impl.removePopUp(popUp);
      }
      
      public static function bringToFront(popUp:IFlexDisplayObject) : void
      {
         impl.bringToFront(popUp);
      }
   }
}
