package flashx.textLayout.property
{
   import flashx.textLayout.tlf_internal;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class NumberOrPercentOrEnumProperty extends NumberOrPercentProperty
   {
       
      private var _range:Object;
      
      private var _defaultValue:Object;
      
      public function NumberOrPercentOrEnumProperty(nameValue:String, defaultValue:Object, inherited:Boolean, category:String, minValue:Number, maxValue:Number, minPercentValue:String, maxPercentValue:String, ... rest)
      {
         this._range = EnumStringProperty.createRange(rest);
         if(Boolean(defaultValue is String) && Boolean(this._range.hasOwnProperty(defaultValue)))
         {
            this._defaultValue = defaultValue;
         }
         super(nameValue,defaultValue,inherited,category,minValue,maxValue,minPercentValue,maxPercentValue);
      }
      
      override public function get defaultValue() : Object
      {
         return this._defaultValue != null?this._defaultValue:super.defaultValue;
      }
      
      public function get range() : Object
      {
         return Property.shallowCopy(this._range);
      }
      
      override public function setHelper(currVal:*, newObject:*) : *
      {
         if(newObject === null)
         {
            newObject = undefined;
         }
         if(newObject === undefined)
         {
            return newObject;
         }
         return !!this._range.hasOwnProperty(newObject)?newObject:super.setHelper(currVal,newObject);
      }
      
      override public function hash(val:Object, seed:uint) : uint
      {
         var hash:uint = this._range[val];
         if(hash != 0)
         {
            return UintProperty.doHash(hash,seed);
         }
         return super.hash(val,seed);
      }
   }
}
