package flashx.textLayout.operations
{
   import flashx.textLayout.edit.TextScrap;
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.edit.SelectionState;
   import flashx.textLayout.edit.TextFlowEdit;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.tlf_internal;
   
   use namespace tlf_internal;
   
   public class DeleteTextOperation extends FlowTextOperation
   {
       
      private var _textScrap:TextScrap;
      
      private var _allowMerge:Boolean;
      
      private var _undoParaFormat:TextLayoutFormatValueHolder;
      
      private var _undoCharacterFormat:TextLayoutFormatValueHolder;
      
      private var _needsOldFormat:Boolean = false;
      
      private var _pendingFormat:TextLayoutFormatValueHolder;
      
      private var _deleteSelectionState:SelectionState = null;
      
      public function DeleteTextOperation(operationState:SelectionState, deleteSelectionState:SelectionState = null, allowMerge:Boolean = false)
      {
         this._deleteSelectionState = Boolean(deleteSelectionState)?deleteSelectionState:operationState;
         super(this._deleteSelectionState);
         originalSelectionState = operationState;
         this._allowMerge = allowMerge;
      }
      
      public function get allowMerge() : Boolean
      {
         return this._allowMerge;
      }
      
      public function set allowMerge(value:Boolean) : void
      {
         this._allowMerge = value;
      }
      
      public function get deleteSelectionState() : SelectionState
      {
         return this._deleteSelectionState;
      }
      
      public function set deleteSelectionState(value:SelectionState) : void
      {
         this._deleteSelectionState = value;
      }
      
      override public function doOperation() : Boolean
      {
         var state:SelectionState = null;
         if(absoluteStart == absoluteEnd)
         {
            return false;
         }
         this._textScrap = TextFlowEdit.createTextScrap(textFlow,absoluteStart,absoluteEnd);
         var leafEl:FlowLeafElement = textFlow.findLeaf(absoluteStart);
         var paraEl:ParagraphElement = leafEl.getParagraph();
         var paraElAbsStart:int = paraEl.getAbsoluteStart();
         this._pendingFormat = new TextLayoutFormatValueHolder(leafEl.format);
         if(this._textScrap)
         {
            if(Boolean(this._textScrap.textFlow.textLength == 1) && (Boolean(absoluteEnd == textFlow.textLength - 1) || Boolean(absoluteEnd == paraElAbsStart + paraEl.textLength)))
            {
               this._textScrap.beginMissingArray = new Array();
               this._textScrap.endMissingArray = new Array();
            }
            if(this._textScrap.textFlow.textLength >= 1)
            {
               leafEl = textFlow.findLeaf(absoluteEnd);
               paraEl = leafEl.getParagraph();
               if(absoluteEnd == paraEl.getAbsoluteStart())
               {
                  this._undoParaFormat = new TextLayoutFormatValueHolder(paraEl.format);
                  this._undoCharacterFormat = new TextLayoutFormatValueHolder(leafEl.format);
                  this._needsOldFormat = true;
               }
            }
         }
         var beforeOpLen:int = textFlow.textLength;
         TextFlowEdit.replaceRange(textFlow,absoluteStart,absoluteEnd,null);
         if(textFlow.interactionManager)
         {
            textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,-(absoluteEnd - absoluteStart));
         }
         if(Boolean(originalSelectionState.selectionManagerOperationState) && Boolean(textFlow.interactionManager))
         {
            state = textFlow.interactionManager.getSelectionState();
            if(state.anchorPosition == state.activePosition)
            {
               state.pointFormat = new TextLayoutFormatValueHolder(this._pendingFormat);
               textFlow.interactionManager.setSelectionState(state);
            }
         }
         if(beforeOpLen == textFlow.textLength)
         {
            this._textScrap = null;
         }
         return true;
      }
      
      override public function undo() : SelectionState
      {
         var leafEl:FlowLeafElement = null;
         var paraEl:ParagraphElement = null;
         if(this._textScrap != null)
         {
            TextFlowEdit.replaceRange(textFlow,absoluteStart,absoluteStart,this._textScrap);
            if(this._needsOldFormat)
            {
               textFlow.normalize();
               leafEl = textFlow.findLeaf(absoluteEnd);
               if(leafEl)
               {
                  paraEl = leafEl.getParagraph();
                  paraEl.format = this._undoParaFormat;
                  leafEl.format = this._undoCharacterFormat;
               }
            }
            if(textFlow.interactionManager)
            {
               textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,absoluteEnd - absoluteStart);
            }
         }
         return originalSelectionState;
      }
      
      override public function redo() : SelectionState
      {
         TextFlowEdit.replaceRange(textFlow,absoluteStart,absoluteEnd,null);
         if(textFlow.interactionManager)
         {
            textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,-(absoluteEnd - absoluteStart));
         }
         return new SelectionState(textFlow,absoluteStart,absoluteStart,this._pendingFormat);
      }
      
      override tlf_internal function merge(op2:FlowOperation) : FlowOperation
      {
         if(this.endGeneration != op2.beginGeneration)
         {
            return null;
         }
         var delOp:DeleteTextOperation = op2 as DeleteTextOperation;
         if(Boolean(delOp == null) || Boolean(!delOp.allowMerge) || Boolean(!this._allowMerge))
         {
            return null;
         }
         return new CompositeOperation([this,op2]);
      }
   }
}
