package flashx.textLayout.factory
{
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.compose.IFlowComposer;
   import flashx.textLayout.elements.SpanElement;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flash.text.engine.TextLine;
   import flashx.textLayout.elements.FlowGroupElement;
   import flashx.textLayout.elements.FlowLeafElement;
   import flash.display.Shape;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.container.ScrollPolicy;
   import flashx.textLayout.elements.ParagraphElement;
   import flash.geom.Rectangle;
   import flashx.textLayout.formats.BlockProgression;
   
   use namespace tlf_internal;
   
   public final class TextFlowTextLineFactory extends TextLineFactoryBase
   {
       
      private var _truncatedTextFlowCallback:Function;
      
      public function TextFlowTextLineFactory()
      {
         super();
      }
      
      public function createTextLines(callback:Function, textFlow:TextFlow) : void
      {
         var helper:IFlowComposer = null;
         var somethingFit:Boolean = false;
         var truncationIndicatorSpan:SpanElement = null;
         var hostFormat:ITextLayoutFormat = null;
         var line:TextLine = null;
         var truncateAtCharPosition:int = 0;
         var parent:FlowGroupElement = null;
         var lastLeaf:FlowLeafElement = null;
         var bgShape:Shape = null;
         var measureWidth:Boolean = isNaN(compositionBounds.width);
         var bp:String = textFlow.computedFormat.blockProgression;
         helper = createFlowComposer();
         helper.swfContext = swfContext;
         helper.addController(containerController);
         textFlow.flowComposer = helper;
         textFlow.backgroundManager = null;
         _isTruncated = false;
         containerController.setCompositionSize(compositionBounds.width,compositionBounds.height);
         containerController.verticalScrollPolicy = Boolean(truncationOptions)?ScrollPolicy.OFF:verticalScrollPolicy;
         containerController.horizontalScrollPolicy = Boolean(truncationOptions)?ScrollPolicy.OFF:horizontalScrollPolicy;
         textFlow.normalize();
         textFlow.applyUpdateElements(true);
         helper.compose();
         if(Boolean(truncationOptions) && Boolean(!doesComposedTextFit(truncationOptions.lineCountLimit,textFlow.textLength,bp)))
         {
            _isTruncated = true;
            somethingFit = false;
            computeLastAllowedLineIndex(truncationOptions.lineCountLimit);
            if(_truncationLineIndex >= 0)
            {
               truncationIndicatorSpan = new SpanElement();
               truncationIndicatorSpan.text = truncationOptions.truncationIndicator;
               truncationIndicatorSpan.id = "truncationIndicator";
               if(truncationOptions.truncationIndicatorFormat)
               {
                  truncationIndicatorSpan.format = truncationOptions.truncationIndicatorFormat;
               }
               hostFormat = textFlow.hostFormat;
               line = _factoryComposer._lines[_truncationLineIndex] as TextLine;
               truncateAtCharPosition = line.userData + line.rawTextLength;
               if(!_pass0Lines)
               {
                  _pass0Lines = new Array();
               }
               _pass0Lines = _factoryComposer.swapLines(_pass0Lines);
               do
               {
                  textFlow = textFlow.deepCopy(0,truncateAtCharPosition) as TextFlow;
                  if(hostFormat)
                  {
                     textFlow.hostFormat = hostFormat;
                  }
                  lastLeaf = textFlow.getLastLeaf();
                  if(lastLeaf)
                  {
                     parent = lastLeaf.parent;
                     if(!truncationOptions.truncationIndicatorFormat)
                     {
                        truncationIndicatorSpan.format = lastLeaf.format;
                     }
                  }
                  else
                  {
                     parent = new ParagraphElement();
                     textFlow.addChild(parent);
                  }
                  if(truncationIndicatorSpan.parent)
                  {
                     truncationIndicatorSpan.parent.removeChild(truncationIndicatorSpan);
                  }
                  parent.addChild(truncationIndicatorSpan);
                  textFlow.flowComposer = helper;
                  textFlow.normalize();
                  helper.compose();
                  if(doesComposedTextFit(truncationOptions.lineCountLimit,textFlow.textLength,bp))
                  {
                     somethingFit = true;
                     break;
                  }
                  if(truncateAtCharPosition == 0)
                  {
                     break;
                  }
                  truncateAtCharPosition = getNextTruncationPosition(truncateAtCharPosition,true);
               }
               while(true);
               
            }
            if(this._truncatedTextFlowCallback != null)
            {
               this._truncatedTextFlowCallback(!!somethingFit?textFlow:null);
            }
            if(!somethingFit)
            {
               _factoryComposer._lines.splice(0);
            }
         }
         var xadjust:Number = compositionBounds.x;
         var controllerBounds:Rectangle = containerController.getContentBounds();
         if(bp == BlockProgression.RL)
         {
            xadjust = xadjust + (!!measureWidth?controllerBounds.width:compositionBounds.width);
         }
         controllerBounds.left = controllerBounds.left + xadjust;
         controllerBounds.right = controllerBounds.right + xadjust;
         controllerBounds.top = controllerBounds.top + compositionBounds.y;
         controllerBounds.bottom = controllerBounds.bottom + compositionBounds.y;
         if(textFlow.backgroundManager)
         {
            bgShape = new Shape();
            textFlow.backgroundManager.drawAllRects(bgShape,containerController);
            bgShape.x = xadjust;
            bgShape.y = compositionBounds.y;
            callback(bgShape);
            textFlow.backgroundManager = null;
         }
         callbackWithTextLines(callback,xadjust,compositionBounds.y);
         setContentBounds(controllerBounds);
         textFlow.changeFlowComposer(null,false);
         _factoryComposer._lines.splice(0);
         if(_pass0Lines)
         {
            _pass0Lines.splice(0);
         }
      }
      
      tlf_internal function set truncatedTextFlowCallback(val:Function) : void
      {
         this._truncatedTextFlowCallback = val;
      }
   }
}
