package flashx.textLayout.conversion
{
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.elements.BreakElement;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.elements.SpanElement;
   import flashx.textLayout.elements.LinkElement;
   import flashx.textLayout.elements.InlineGraphicElement;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.property.StringProperty;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flash.utils.Dictionary;
   import flashx.textLayout.elements.FlowGroupElement;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flash.text.engine.FontWeight;
   import flash.text.engine.FontPosture;
   import flashx.textLayout.formats.TextDecoration;
   import flashx.textLayout.property.Property;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.formats.LeadingModel;
   import flashx.textLayout.elements.TabElement;
   import flash.text.engine.Kerning;
   import flashx.textLayout.elements.GlobalSettings;
   import flashx.textLayout.elements.IConfiguration;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   class HtmlImporter extends BaseTextLayoutImporter
   {
      
      static var _fontDescription:Object = {
         "color":TextLayoutFormat.colorProperty,
         "trackingRight":TextLayoutFormat.trackingRightProperty,
         "fontFamily":TextLayoutFormat.fontFamilyProperty
      };
      
      static const _fontMiscDescription:Object = {
         "size":new StringProperty("size",null,false,null),
         "kerning":new StringProperty("kerning",null,false,null)
      };
      
      static var _textFormatDescription:Object = {
         "paragraphStartIndent":TextLayoutFormat.paragraphStartIndentProperty,
         "paragraphEndIndent":TextLayoutFormat.paragraphEndIndentProperty,
         "textIndent":TextLayoutFormat.textIndentProperty,
         "lineHeight":TextLayoutFormat.lineHeightProperty,
         "tabStops":TextLayoutFormat.tabStopsProperty
      };
      
      static const _textFormatMiscDescription:Object = {"blockIndent":new StringProperty("blockIndent",null,false,null)};
      
      static var _paragraphFormatDescription:Object = {"textAlign":TextLayoutFormat.textAlignProperty};
      
      static const _linkHrefDescription:Object = {"href":new StringProperty("href",null,false,null)};
      
      static const _linkTargetDescription:Object = {"target":new StringProperty("target",null,false,null)};
      
      static const _imageDescription:Object = {
         "height":InlineGraphicElement.heightPropertyDefinition,
         "width":InlineGraphicElement.widthPropertyDefinition
      };
      
      static const _imageMiscDescription:Object = {
         "src":new StringProperty("src",null,false,null),
         "id":new StringProperty("id",null,false,null)
      };
      
      static const _classDescription:Object = {};
      
      private static var _fontImporter:FontImporter;
      
      private static var _fontMiscImporter:CaseInsensitiveTLFFormatImporter;
      
      private static var _textFormatImporter:TextFormatImporter;
      
      private static var _textFormatMiscImporter:CaseInsensitiveTLFFormatImporter;
      
      private static var _paragraphFormatImporter:HtmlCustomParaFormatImporter;
      
      private static var _linkHrefImporter:CaseInsensitiveTLFFormatImporter;
      
      private static var _linkTargetImporter:CaseInsensitiveTLFFormatImporter;
      
      private static var _ilgFormatImporter:CaseInsensitiveTLFFormatImporter;
      
      private static var _ilgMiscFormatImporter:CaseInsensitiveTLFFormatImporter;
      
      private static var _classImporter:CaseInsensitiveTLFFormatImporter;
      
      private static var _activeFormat:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder();
      
      private static var _activeParaFormat:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder();
      
      private static var _activeImpliedParaFormat:TextLayoutFormatValueHolder = null;
      
      private static var _baseFontSize:Number;
      
      private static var stripRegex:RegExp = /<!--.*?-->|<\?(".*?"|'.*?'|[^>"']+)*>|<!(".*?"|'.*?'|[^>"']+)*>/sg;
      
      private static var tagRegex:RegExp = /<(\\/?)(\w+)((?:\s+\w+(?:\s*=\s*(?:".*?"|'.*?'|[\w\.]+))?)*)\s*(\\/?)>/sg;
      
      private static var attrRegex:RegExp = /\s+(\w+)(?:\s*=\s*(".*?"|'.*?'|[\w\.]+))?/sg;
      
      private static const anyPrintChar:RegExp = /[^\t\n\r ]/g;
       
      function HtmlImporter(textFlowConfiguration:IConfiguration)
      {
         super(textFlowConfiguration,null,createConfig());
      }
      
      private static function createConfig() : ImportExportConfiguration
      {
         var config:ImportExportConfiguration = new ImportExportConfiguration();
         config.addIEInfo("br",BreakElement,BaseTextLayoutImporter.parseBreak,null,false);
         config.addIEInfo("p",ParagraphElement,HtmlImporter.parsePara,null,true);
         config.addIEInfo("span",SpanElement,HtmlImporter.parseSpan,null,false);
         config.addIEInfo("a",LinkElement,HtmlImporter.parseLink,null,false);
         config.addIEInfo("img",InlineGraphicElement,HtmlImporter.parseInlineGraphic,null,false);
         config.addIEInfo("font",null,HtmlImporter.parseFont,null,false);
         config.addIEInfo("textformat",null,HtmlImporter.parseTextFormat,null,false);
         config.addIEInfo("u",null,HtmlImporter.parseUnderline,null,false);
         config.addIEInfo("i",null,HtmlImporter.parseItalic,null,false);
         config.addIEInfo("b",null,HtmlImporter.parseBold,null,false);
         if(_classDescription["class"] === undefined)
         {
            _classDescription["class"] = new StringProperty("class",null,false,null);
            _paragraphFormatImporter = new HtmlCustomParaFormatImporter(TextLayoutFormat,_paragraphFormatDescription);
            _textFormatImporter = new TextFormatImporter(TextLayoutFormat,_textFormatDescription);
            _fontImporter = new FontImporter(TextLayoutFormat,_fontDescription);
            _fontMiscImporter = new CaseInsensitiveTLFFormatImporter(Dictionary,_fontMiscDescription);
            _textFormatMiscImporter = new CaseInsensitiveTLFFormatImporter(Dictionary,_textFormatMiscDescription);
            _linkHrefImporter = new CaseInsensitiveTLFFormatImporter(Dictionary,_linkHrefDescription,false);
            _linkTargetImporter = new CaseInsensitiveTLFFormatImporter(Dictionary,_linkTargetDescription);
            _ilgFormatImporter = new CaseInsensitiveTLFFormatImporter(Dictionary,_imageDescription);
            _ilgMiscFormatImporter = new CaseInsensitiveTLFFormatImporter(Dictionary,_imageMiscDescription,false);
            _classImporter = new CaseInsensitiveTLFFormatImporter(Dictionary,_classDescription);
         }
         return config;
      }
      
      public static function parsePara(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var fontFormattingElement:XML = null;
         var paraElem:ParagraphElement = (importFilter as HtmlImporter).createParagraphFromXML(xmlToParse);
         if(importFilter.addChild(parent,paraElem))
         {
            fontFormattingElement = getSingleFontChild(xmlToParse);
            parseChildrenUnderNewActiveFormat(importFilter,Boolean(fontFormattingElement)?fontFormattingElement:xmlToParse,paraElem,_activeFormat,null);
            if(paraElem.numChildren == 0)
            {
               paraElem.addChild(new SpanElement());
            }
         }
         replaceBreakElementsWithParaSplits(paraElem);
      }
      
      private static function getSingleFontChild(xmlToParse:XML) : XML
      {
         var child:XML = null;
         var children:XMLList = xmlToParse.children();
         if(children.length() == 1)
         {
            child = children[0];
            if(child.name().localName.toLowerCase() == "font")
            {
               return child;
            }
         }
         return null;
      }
      
      public static function parseLink(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var linkElem:LinkElement = HtmlImporter(importFilter).createLinkFromXML(xmlToParse);
         if(importFilter.addChild(parent,linkElem))
         {
            parseChildrenUnderNewActiveFormat(importFilter,xmlToParse,linkElem,_activeFormat,null);
            if(linkElem.numChildren == 0)
            {
               linkElem.addChild(new SpanElement());
            }
         }
      }
      
      public static function parseSpan(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var child:XML = null;
         var elemName:String = null;
         var s:SpanElement = null;
         var firstSpan:SpanElement = new SpanElement();
         var formatImporters:Array = [_classImporter];
         importFilter.parseAttributes(xmlToParse,formatImporters);
         firstSpan.styleName = _classImporter.getFormatValue("class");
         firstSpan.format = _activeFormat;
         var elemList:XMLList = xmlToParse[0].children();
         if(elemList.length() == 0)
         {
            importFilter.addChild(parent,firstSpan);
            return;
         }
         for each(child in elemList)
         {
            elemName = Boolean(child.name())?child.name().localName:null;
            if(elemName == null)
            {
               if(firstSpan.parent == null)
               {
                  firstSpan.text = child.toString();
                  importFilter.addChild(parent,firstSpan);
               }
               else
               {
                  s = new SpanElement();
                  copyAllStyleProps(s,firstSpan);
                  s.text = child.toString();
                  importFilter.addChild(parent,s);
               }
            }
            else
            {
               importFilter.parseObject(elemName,child,parent);
            }
         }
      }
      
      public static function parseInlineGraphic(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var ilg:InlineGraphicElement = HtmlImporter(importFilter).createInlineGraphicFromXML(xmlToParse);
         importFilter.addChild(parent,ilg);
      }
      
      public static function parseFont(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var newFormat:ITextLayoutFormat = (importFilter as HtmlImporter).parseFontAttributes(xmlToParse);
         parseChildrenUnderNewActiveFormatWithImpliedParaFormat(importFilter,xmlToParse,parent,newFormat);
      }
      
      public static function parseTextFormat(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var blockIndentVal:Number = NaN;
         var formatImporters:Array = [_textFormatImporter,_textFormatMiscImporter];
         importFilter.parseAttributes(xmlToParse,formatImporters);
         var newFormat:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder(_textFormatImporter.result as ITextLayoutFormat);
         var blockIndent:String = _textFormatMiscImporter.getFormatValue("blockIndent");
         if(blockIndent)
         {
            blockIndentVal = TextLayoutFormat.paragraphStartIndentProperty.setHelper(NaN,blockIndent);
            if(!isNaN(blockIndentVal))
            {
               newFormat.paragraphStartIndent = newFormat.paragraphStartIndent === undefined?blockIndentVal:newFormat.paragraphStartIndent + blockIndentVal;
            }
         }
         parseChildrenUnderNewActiveFormat(importFilter,xmlToParse,parent,_activeParaFormat,newFormat,true);
      }
      
      public static function parseBold(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var newFormat:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder();
         newFormat.fontWeight = FontWeight.BOLD;
         parseChildrenUnderNewActiveFormatWithImpliedParaFormat(importFilter,xmlToParse,parent,newFormat);
      }
      
      public static function parseItalic(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var newFormat:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder();
         newFormat.fontStyle = FontPosture.ITALIC;
         parseChildrenUnderNewActiveFormatWithImpliedParaFormat(importFilter,xmlToParse,parent,newFormat);
      }
      
      public static function parseUnderline(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         var newFormat:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder();
         newFormat.textDecoration = TextDecoration.UNDERLINE;
         parseChildrenUnderNewActiveFormatWithImpliedParaFormat(importFilter,xmlToParse,parent,newFormat);
      }
      
      private static function parseChildrenUnderNewActiveFormatWithImpliedParaFormat(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement, newFormat:ITextLayoutFormat) : void
      {
         var oldActiveImpliedParaFormat:TextLayoutFormatValueHolder = _activeImpliedParaFormat;
         if(_activeImpliedParaFormat == null)
         {
            _activeImpliedParaFormat = new TextLayoutFormatValueHolder(_activeFormat);
         }
         try
         {
            parseChildrenUnderNewActiveFormat(importFilter,xmlToParse,parent,_activeFormat,newFormat,true);
         }
         finally
         {
            _activeImpliedParaFormat = oldActiveImpliedParaFormat;
         }
      }
      
      private static function parseChildrenUnderNewActiveFormat(importFilter:BaseTextLayoutImporter, xmlToParse:XML, parent:FlowGroupElement, currFormat:TextLayoutFormatValueHolder, newFormat:ITextLayoutFormat, chainedParent:Boolean = false) : void
      {
         var restoreBaseFontSize:Number = _baseFontSize;
         var restoreCoreStyles:Object = Property.shallowCopy(currFormat.coreStyles);
         if(newFormat)
         {
            if(newFormat.fontSize !== undefined)
            {
               _baseFontSize = newFormat.fontSize;
            }
            currFormat.apply(newFormat);
         }
         else
         {
            currFormat.coreStyles = null;
         }
         try
         {
            importFilter.parseFlowGroupElementChildren(xmlToParse,parent,null,chainedParent);
         }
         finally
         {
            currFormat.coreStyles = restoreCoreStyles;
            _baseFontSize = restoreBaseFontSize;
         }
      }
      
      private static function replaceBreakElementsWithParaSplits(para:ParagraphElement) : void
      {
         var paraArray:Array = null;
         var paraIndex:int = 0;
         var paraParent:FlowGroupElement = null;
         var elem:FlowLeafElement = para.getFirstLeaf();
         while(elem)
         {
            if(!(elem is BreakElement))
            {
               elem = elem.getNextLeaf(para);
            }
            else
            {
               if(!paraArray)
               {
                  paraArray = [para];
                  paraParent = para.parent;
                  paraIndex = paraParent.getChildIndex(para);
                  paraParent.removeChildAt(paraIndex);
               }
               para = para.splitAtPosition(elem.getAbsoluteStart() + elem.textLength) as ParagraphElement;
               paraArray.push(para);
               elem.parent.removeChild(elem);
               elem = para.getFirstLeaf();
            }
         }
         if(paraArray)
         {
            paraParent.replaceChildren(paraIndex,paraIndex,paraArray);
         }
      }
      
      override protected function importFromString(source:String) : TextFlow
      {
         var xml:XML = this.toXML(source);
         return Boolean(xml)?this.importFromXML(xml):null;
      }
      
      override protected function importFromXML(xmlSource:XML) : TextFlow
      {
         var textFlow:TextFlow = new TextFlow(_textFlowConfiguration);
         _baseFontSize = textFlow.fontSize === undefined?Number(12):Number(textFlow.fontSize);
         this.parseObject(xmlSource.name().localName,xmlSource,textFlow);
         resetImpliedPara();
         textFlow.normalize();
         textFlow.applyWhiteSpaceCollapse(null);
         return textFlow;
      }
      
      override protected function clear() : void
      {
         _activeParaFormat.coreStyles = null;
         _activeFormat.coreStyles = null;
         super.clear();
      }
      
      override tlf_internal function createImpliedParagraph() : ParagraphElement
      {
         var rslt:ParagraphElement = null;
         var savedActiveFormat:TextLayoutFormatValueHolder = _activeFormat;
         if(_activeImpliedParaFormat)
         {
            _activeFormat = _activeImpliedParaFormat;
         }
         try
         {
            rslt = super.createImpliedParagraph();
         }
         finally
         {
            _activeFormat = savedActiveFormat;
         }
         return rslt;
      }
      
      override public function createParagraphFromXML(xmlToParse:XML) : ParagraphElement
      {
         var paraElem:ParagraphElement = new ParagraphElement();
         var formatImporters:Array = [_paragraphFormatImporter,_classImporter];
         parseAttributes(xmlToParse,formatImporters);
         var paragraphFormat:TextLayoutFormat = new TextLayoutFormat(_paragraphFormatImporter.result as ITextLayoutFormat);
         if(_activeParaFormat)
         {
            paragraphFormat.apply(_activeParaFormat);
         }
         if(_activeFormat)
         {
            paragraphFormat.apply(_activeFormat);
         }
         var fontFormattingElement:XML = getSingleFontChild(xmlToParse);
         if(fontFormattingElement)
         {
            paragraphFormat.apply(this.parseFontAttributes(fontFormattingElement));
         }
         if(paragraphFormat.lineHeight !== undefined)
         {
            paragraphFormat.leadingModel = LeadingModel.APPROXIMATE_TEXT_FIELD;
         }
         paraElem.format = paragraphFormat;
         paraElem.styleName = _classImporter.getFormatValue("class");
         return paraElem;
      }
      
      override protected function onResetImpliedPara(para:ParagraphElement) : void
      {
         replaceBreakElementsWithParaSplits(para);
      }
      
      private function createLinkFromXML(xmlToParse:XML) : LinkElement
      {
         var linkElem:LinkElement = new LinkElement();
         var formatImporters:Array = [_linkHrefImporter,_linkTargetImporter];
         parseAttributes(xmlToParse,formatImporters);
         linkElem.href = _linkHrefImporter.getFormatValue("href");
         linkElem.target = _linkTargetImporter.getFormatValue("target");
         if(!linkElem.target)
         {
            linkElem.target = "_self";
         }
         linkElem.format = _activeFormat;
         return linkElem;
      }
      
      private function createInlineGraphicFromXML(xmlToParse:XML) : InlineGraphicElement
      {
         var imgElem:InlineGraphicElement = new InlineGraphicElement();
         var formatImporters:Array = [_ilgFormatImporter,_ilgMiscFormatImporter];
         parseAttributes(xmlToParse,formatImporters);
         var source:String = _ilgMiscFormatImporter.getFormatValue("src");
         imgElem.source = source;
         imgElem.height = InlineGraphicElement.heightPropertyDefinition.setHelper(imgElem.height,_ilgFormatImporter.getFormatValue("height"));
         imgElem.width = InlineGraphicElement.heightPropertyDefinition.setHelper(imgElem.width,_ilgFormatImporter.getFormatValue("width"));
         var id:String = _ilgMiscFormatImporter.getFormatValue("id");
         imgElem.id = id;
         imgElem.format = _activeFormat;
         return imgElem;
      }
      
      override public function createTabFromXML(xmlToParse:XML) : TabElement
      {
         return null;
      }
      
      private function parseFontAttributes(xmlToParse:XML) : ITextLayoutFormat
      {
         var kerningVal:Number = NaN;
         var sizeVal:Number = NaN;
         var formatImporters:Array = [_fontImporter,_fontMiscImporter];
         parseAttributes(xmlToParse,formatImporters);
         var newFormat:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder(_fontImporter.result as ITextLayoutFormat);
         var kerning:String = _fontMiscImporter.getFormatValue("kerning");
         if(kerning)
         {
            kerningVal = Number(kerning);
            newFormat.kerning = kerningVal == 0?Kerning.OFF:Kerning.AUTO;
         }
         var size:String = _fontMiscImporter.getFormatValue("size");
         if(size)
         {
            sizeVal = TextLayoutFormat.fontSizeProperty.setHelper(NaN,size);
            if(!isNaN(sizeVal))
            {
               if(size.search(/\s*(-|\+)/) != -1)
               {
                  sizeVal = sizeVal + _baseFontSize;
               }
               newFormat.fontSize = sizeVal;
            }
         }
         return newFormat;
      }
      
      override protected function handleUnknownAttribute(elementName:String, propertyName:String) : void
      {
      }
      
      override protected function handleUnknownElement(name:String, xmlToParse:XML, parent:FlowGroupElement) : void
      {
         parseFlowGroupElementChildren(xmlToParse,parent,null,true);
      }
      
      override tlf_internal function parseObject(name:String, xmlToParse:XML, parent:FlowGroupElement, exceptionElements:Object = null) : void
      {
         super.parseObject(name.toLowerCase(),xmlToParse,parent,exceptionElements);
      }
      
      override protected function checkNamespace(xmlToParse:XML) : Boolean
      {
         return true;
      }
      
      private function toXML(source:String) : XML
      {
         var xml:XML = null;
         var originalSettings:Object = XML.settings();
         try
         {
            XML.ignoreProcessingInstructions = false;
            XML.ignoreWhitespace = false;
            xml = this.toXMLInternal(source);
         }
         finally
         {
            XML.setSettings(originalSettings);
         }
         return xml;
      }
      
      private function toXMLInternal(source:String) : XML
      {
         var openElemName:String = null;
         var result:Object = null;
         var tag:String = null;
         var hasStartModifier:Boolean = false;
         var name:String = null;
         var attrs:String = null;
         var hasEndModifier:Boolean = false;
         var innerResult:Object = null;
         var attrName:String = null;
         var val:String = null;
         var startChar:String = null;
         var openElem:XML = null;
         source = source.replace(stripRegex,"");
         var root:XML = <html/>;
         var currElem:XML = root;
         var lastIndex:int = tagRegex.lastIndex = 0;
         do
         {
            result = tagRegex.exec(source);
            if(!result)
            {
               this.appendTextChild(currElem,source.substring(lastIndex));
               break;
            }
            if(result.index != lastIndex)
            {
               this.appendTextChild(currElem,source.substring(lastIndex,result.index));
            }
            tag = result[0];
            hasStartModifier = result[1] == "/";
            name = result[2].toLowerCase();
            attrs = result[3];
            hasEndModifier = result[4] == "/";
            if(!hasStartModifier)
            {
               if(Boolean(name == "p") && Boolean(currElem.name().localName == "p"))
               {
                  currElem = currElem.parent();
               }
               tag = "<" + name;
               do
               {
                  innerResult = attrRegex.exec(attrs);
                  if(!innerResult)
                  {
                     break;
                  }
                  attrName = innerResult[1].toLowerCase();
                  tag = tag + (" " + attrName + "=");
                  val = Boolean(innerResult[2])?innerResult[2]:attrName;
                  startChar = val.charAt(0);
                  tag = tag + (Boolean(startChar == "\'") || Boolean(startChar == "\"")?val:"\"" + val + "\"");
               }
               while(true);
               
               tag = tag + "/>";
               currElem.appendChild(new XML(tag));
               if(Boolean(!hasEndModifier) && Boolean(!this.doesStartTagCloseElement(name)))
               {
                  currElem = currElem.children()[currElem.children().length() - 1];
               }
            }
            else if(Boolean(hasEndModifier) || Boolean(attrs.length))
            {
               reportError(GlobalSettings.resourceStringFunction("malformedTag",[tag]));
            }
            else
            {
               openElem = currElem;
               do
               {
                  openElemName = openElem.name().localName;
                  openElem = openElem.parent();
                  if(openElemName == name)
                  {
                     currElem = openElem;
                     break;
                  }
                  if(!openElem)
                  {
                     break;
                  }
               }
               while(true);
               
            }
            lastIndex = tagRegex.lastIndex;
            if(lastIndex == source.length)
            {
               break;
            }
         }
         while(currElem);
         
         return root;
      }
      
      private function doesStartTagCloseElement(tagName:String) : Boolean
      {
         switch(tagName)
         {
            case "br":
            case "img":
               return true;
            default:
               return false;
         }
      }
      
      private function appendTextChild(parent:XML, text:String) : void
      {
         var xml:XML = null;
         var parentIsSpan:Boolean = parent.localName() == "span";
         var elemName:String = !!parentIsSpan?"dummy":"span";
         var xmlText:String = "<" + elemName + ">" + text + "</" + elemName + ">";
         try
         {
            xml = new XML(xmlText);
            parent.appendChild(!!parentIsSpan?xml.children()[0]:xml);
         }
         catch(e:*)
         {
            reportError(GlobalSettings.resourceStringFunction("malformedMarkup",[text]));
         }
      }
   }
}

import flashx.textLayout.conversion.TLFormatImporter;

class CaseInsensitiveTLFFormatImporter extends TLFormatImporter
{
    
   private var _convertValuesToLowerCase:Boolean;
   
   function CaseInsensitiveTLFFormatImporter(classType:Class, description:Object, convertValuesToLowerCase:Boolean = true)
   {
      var prop:* = null;
      this._convertValuesToLowerCase = convertValuesToLowerCase;
      var lowerCaseDescription:Object = new Object();
      for(prop in description)
      {
         lowerCaseDescription[prop.toLowerCase()] = description[prop];
      }
      super(classType,lowerCaseDescription);
   }
   
   override public function importOneFormat(key:String, val:String) : Boolean
   {
      return super.importOneFormat(key.toLowerCase(),!!this._convertValuesToLowerCase?val.toLowerCase():val);
   }
   
   public function getFormatValue(key:String) : *
   {
      return Boolean(result)?result[key.toLowerCase()]:undefined;
   }
}

import flashx.textLayout.conversion.TLFormatImporter;

class HtmlCustomParaFormatImporter extends TLFormatImporter
{
    
   function HtmlCustomParaFormatImporter(classType:Class, description:Object)
   {
      super(classType,description);
   }
   
   override public function importOneFormat(key:String, val:String) : Boolean
   {
      key = key.toLowerCase();
      if(key == "align")
      {
         key = "textAlign";
      }
      return super.importOneFormat(key,val.toLowerCase());
   }
}

import flashx.textLayout.conversion.TLFormatImporter;

class TextFormatImporter extends TLFormatImporter
{
    
   function TextFormatImporter(classType:Class, description:Object)
   {
      super(classType,description);
   }
   
   override public function importOneFormat(key:String, val:String) : Boolean
   {
      key = key.toLowerCase();
      if(key == "leftmargin")
      {
         key = "paragraphStartIndent";
      }
      else if(key == "rightmargin")
      {
         key = "paragraphEndIndent";
      }
      else if(key == "indent")
      {
         key = "textIndent";
      }
      else if(key == "leading")
      {
         key = "lineHeight";
      }
      else if(key == "tabstops")
      {
         key = "tabStops";
         val = val.replace(/,/g," ");
      }
      return super.importOneFormat(key,val);
   }
}

import flashx.textLayout.conversion.TLFormatImporter;

class FontImporter extends TLFormatImporter
{
    
   function FontImporter(classType:Class, description:Object)
   {
      super(classType,description);
   }
   
   override public function importOneFormat(key:String, val:String) : Boolean
   {
      key = key.toLowerCase();
      if(key == "letterspacing")
      {
         key = "trackingRight";
      }
      else if(key == "face")
      {
         key = "fontFamily";
      }
      return super.importOneFormat(key,val);
   }
}
