package com.beka.util.calc
{
   import com.beka.util.EECalculator;
   
   public class Calc_tw
   {
       
      private var cew:com.beka.util.calc.Calc_ew;
      
      public function Calc_tw(cew:com.beka.util.calc.Calc_ew)
      {
         super();
         this.cew = cew;
      }
      
      public function calculate(p:Number, t:Number, e:Number) : Number
      {
         if(Boolean(p > 1500) || Boolean(p <= 0))
         {
            return NaN;
         }
         if(Boolean(e > this.cew.calculate(p,t,true)) || Boolean(e < this.cew.calculate(p,-100,true)))
         {
            return NaN;
         }
         if(Boolean(t > 115) || Boolean(t < -10))
         {
            return NaN;
         }
         var a:Number = 0.000653;
         var b:Number = 0.000944;
         var tw:Number = NaN;
         var twMax:Number = t + 1;
         var twMin:Number = -81;
         var pist:Number = p * 1.1;
         var cnt:int = 0;
         while(Boolean(Math.abs(e / pist - 1) > 1.0e-6) && Boolean(cnt < EECalculator.MAX_ITERATIONS))
         {
            tw = (twMax + twMin) / 2;
            pist = this.cew.calculate(p,tw,false) - a * (1 + b * tw) * p * (t - tw);
            if(pist > e)
            {
               twMax = tw;
            }
            else
            {
               twMin = tw;
            }
            cnt++;
         }
         return tw;
      }
   }
}
