////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// // Form Spectr Zon Fit Breaker.                                            //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231205 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrzonfitbreaker; // Form Spectr Zon Fit Breaker

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 lcltype, lclintf,
 Form_SpectrZonFitWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_sort, _crw_ef, _crw_ee, _crw_zm,
 _crw_curves, _crw_riff, _crw_calib,
 _crw_daqsys, _crw_daqdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormSpectrZonFitBreaker = class(TMasterForm)
    ButtonBreak: TButton;
    Timer: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure ButtonBreakClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Win : TFormSpectrZonFitWindow;
  end;

procedure FormSpectrZonFitBreakerExecute(Win:TFormSpectrZonFitWindow);

implementation

{$R *.lfm}

procedure FormSpectrZonFitBreakerExecute(Win:TFormSpectrZonFitWindow);
var
 Form : TFormSpectrZonFitBreaker;
begin
 if Win.Ok then begin
  Application.CreateForm(TFormSpectrZonFitBreaker, Form);
  Form.Win:=Win;
  Form.Caption:=Format(RusEng('Минимизация [%s]','Minimization [%s]'),[Win.Caption]);
  Form.ShowModal;
  Kill(TForm(Form));
 end;
end;

procedure TFormSpectrZonFitBreaker.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 ButtonBreak.Caption:=RusEng('Остановить минимизацию','Break minimization');
end;

procedure TFormSpectrZonFitBreaker.TimerTimer(Sender: TObject);
begin
 if Win.ZonFit.UserBreak then ModalResult:=mrOk;
end;

procedure TFormSpectrZonFitBreaker.ButtonBreakClick(Sender: TObject);
begin
 Win.ZonFit.UserBreak:=true;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrzonfitbreaker;
begin
end;

procedure Free_form_spectrzonfitbreaker;
begin
end;

initialization

 Init_form_spectrzonfitbreaker;

finalization

 Free_form_spectrzonfitbreaker;

end.

//////////////
// END OF FILE
//////////////

