////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Const Generator Property Dialog.                                      //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231207 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_constgeneratorpropertydialog; // Form Const Generator Property Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf,
 Form_CrwDaqSysChild,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_ef, _crw_daqsys, _crw_daqdev,
 _crw_softdev, _crw_softdevconstgenerator,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormConstGeneratorPropertyDialog = class(TDaqDevicePropertyDialog)
    LabelCurrentValue: TLabel;
    EditNewValue: TEdit;
    LabelNewValue: TLabel;
    ButtonApply: TButton;
    procedure FormCreate(Sender: TObject);
    procedure LabelNewValueClick(Sender: TObject);
    procedure ButtonApplyClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function  Device:TConstGeneratorDevice;
    procedure UpdateControls(Flags:Cardinal);
    procedure LocateToMouse;
  end;

function NewFormConstGeneratorPropertyDialog:TFormConstGeneratorPropertyDialog;

implementation

{$R *.lfm}

function NewFormConstGeneratorPropertyDialog:TFormConstGeneratorPropertyDialog;
begin
 Application.CreateForm(TFormConstGeneratorPropertyDialog, Result);
 if Result.Ok then with Result do begin
  Show;
  BringToFront;
  ActiveControl:=EditNewValue;
 end;
end;

function TFormConstGeneratorPropertyDialog.Device:TConstGeneratorDevice;
begin
 if (LinkedDevice is TConstGeneratorDevice)
 then Result:=TConstGeneratorDevice(LinkedDevice)
 else Result:=nil;
end;

procedure TFormConstGeneratorPropertyDialog.UpdateControls(Flags:Cardinal);
begin
 if Ok then begin
  if HasFlags(Flags,1) then Caption:=Device.Model+': '+Device.Name;
  if HasFlags(Flags,2) then SmartUpdate(EditNewValue,Format('%g',[Device.ConstValue]));
  if HasFlags(Flags,4) then with Device do SmartUpdate(LabelCurrentValue,Format('%s = %g',[ConstName, ConstValue]));
 end;
end;

procedure TFormConstGeneratorPropertyDialog.LocateToMouse;
begin
 if Ok then begin
  Left:=Mouse.CursorPos.X-(EditNewValue.Left+20);
  Top:=Mouse.CursorPos.Y-(EditNewValue.Top+30);
  Show;
  BringToFront;
  ActiveControl:=EditNewValue;
 end;
end;

procedure TFormConstGeneratorPropertyDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 LabelNewValue.Caption:=RusEng('Новое значение','New value');
 ButtonApply.Caption:=RusEng('Принять','Accept');
end;

procedure TFormConstGeneratorPropertyDialog.LabelNewValueClick(Sender: TObject);
begin
 if Ok then ActiveControl:=EditNewValue;
end;

procedure TFormConstGeneratorPropertyDialog.ButtonApplyClick(Sender: TObject);
var r:Double;
begin
 if Ok then begin
  if Str2Real(EditNewValue.Text, r) then begin
   Device.ConstValue:=r;
   mrVoice(mrOk);
   if Device.CloseOnEnter then Hide;
  end else begin
   Daq.ConsoleEcho(RusEng('Ошибка ввода ','Error input ')+Device.Name);
   mrVoice(mrError);
  end;
 end;
end;

procedure TFormConstGeneratorPropertyDialog.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
 if Ok then
 case Key of
  VK_ESCAPE : Hide;
  VK_RETURN : ButtonApplyClick(Sender);
 end;
end;

procedure TFormConstGeneratorPropertyDialog.FormActivate(Sender: TObject);
begin
 UpdateControls(1+2+4);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_constgeneratorpropertydialog;
begin
end;

procedure Free_form_constgeneratorpropertydialog;
begin
end;

initialization

 Init_form_constgeneratorpropertydialog;

finalization

 Free_form_constgeneratorpropertydialog;

end.

//////////////
// END OF FILE
//////////////

