#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

##########################################################
# Copy files in directory to $HOME/.config/daqgroup/geany
##########################################################

########################
# Script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

function cp_config(){
 local src="$scriptHOME";
 local dst="$HOME/.config/daqgroup/geany";
 if mkdir -p $dst; then cp -rufv $src/* $dst/; fi;
 for f in $(find $dst -name geany.conf); do sed -i "$f" -e "s|/home/user|$HOME|g"; done;
};

function main(){
 if pushd $scriptHOME > /dev/null 2>&1; then
  cp_config;
 fi;
 popd $scriptHOME > /dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
