@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:Main
if "%~1" == ""       goto :Help
if "%~1" == "-h"     goto :Help
if "%~1" == "--help" goto :Help
set option= 
set /a nerror=0
set /a ntotal=0
set /a ngoods=0
set /a verbose=0
set dircmd=dir /b
set homedir=%~dp0
call :ProcessFiles %*
goto :EOF

:Help
echo.
echo Copyright^(c^) Alex Kuryakin 2017 kouriakine@mail.ru RU
echo %~n0 is data integrity tool to add/check text metadata,
echo i.e. checksum which stored in [MetaData] section @CheckSum variable
echo %~n0 uses textmetadata.exe to apply actions to group of files
echo.
echo Usage is:
echo  %~n0 -a files           - add   text metadata to files
echo  %~n0 -c files           - check text metadata of files
echo  %~n0 -r -a files        - add   text metadata to files recursively
echo  %~n0 -r -c files        - check text metadata of files recursively
echo.
echo Example:
echo  %~n0 -r -c *.cal *.ini  - checks all *.cal *.ini files recursively
echo.
goto :EOF

:Execute
if "%~1" == "" goto :EOF
if "%verbose%" == "1" echo %*
call %*
goto :EOF

:ProcessFiles
if "%~1" == "" goto :EOF
if "%~1" == "-v"          ( set /a verbose=1        & shift & goto :ProcessFiles )
if "%~1" == "--verbose"   ( set /a verbose=1        & shift & goto :ProcessFiles )
if "%~1" == "-r"          ( set dircmd=dir /b /s    & shift & goto :ProcessFiles )
if "%~1" == "--recursive" ( set dircmd=dir /b /s    & shift & goto :ProcessFiles )
if "%~1" == "-a"          ( set option=%option% %~1 & shift & goto :ProcessFiles )
if "%~1" == "--add"       ( set option=%option% %~1 & shift & goto :ProcessFiles )
if "%~1" == "-c"          ( set option=%option% %~1 & shift & goto :ProcessFiles )
if "%~1" == "--check"     ( set option=%option% %~1 & shift & goto :ProcessFiles )
if "%option%" == " "      ( echo Error: bad option. & call :Failure & goto :EOF  )
for /f %%i in ('%dircmd% %1 %2 %3 %4 %5 %6 %7 %8 %9') do (
 call :Execute "%homedir%textmetadata.exe" %option% "%%~fi" && set /a ngoods+=1
 set /a ntotal+=1
)
set /a nerror=ntotal-ngoods
>&2 echo file^(s^) processed: %ntotal% 
>&2 echo file^(s^) succeeded: %ngoods%
>&2 echo file^(s^) failed:    %nerror%
rem set exit code according to nerror=0 or not
call :Success & if "%nerror%" == "0" goto :EOF
call :Failure
goto :EOF

:Success
ver 1>nul 2>nul
goto :EOF

:Failure
ver / 1>nul 2>nul
goto :EOF
