////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
// 20241104 - Translated from DPR source by A.K.                              //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Эта утилита служит примером вызова функций графического интерфейса пользователя.
[]
[Manual.Eng]
This demo for graphical user interface calls.
[]
[Arguments.Rus]
Аргумент1 = Строка
Аргумент2 = Столбец
[]
[Arguments.Eng]
Argument1 = Row
Argument2 = Column
[]
}

library demo_gui;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics,
 _crw_crwapi;

/////////////////////////////////////////////////////////
{$I _crw_plugin_declare.inc} // Declare CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:ICrwApi):Integer;     //
/////////////////////////////////////////////////////////
const
 swin = +1; // Source window reference
 twin = -1; // Target window reference
 cwin =  0; // Clipboard window reference
var
 i : Integer;
 s : LongString;
begin
 Result:=0;
 with CrwApi,SysApi,GuiApi,DanApi do
 try
  RedirectStdIn(Input);
  RedirectStdOut(Output);
  VerifyPluginDate(CrwApiEdition,Version);
  VerifyPluginType(Target,ForDataAnalysis);
  writeln('GUI demo plugin.');
  Warning('Warning window.');
  Information('Information window.');
  YesNo('Yes/No confirmation.');
  YesNoCancel('Yes/No/Cancel confirmation.');
  Error('Error message.');
  Trouble(true,'Trouble message.');
  NoProblem(false,'No problem message.');
  i:=ListBoxMenu('List box menu demo','Select item:',
                 'Item 0'+CRLF+
                 'Item 1'+CRLF+
                 'Item 2'+CRLF+
                 'Item 3');
  writeln('ListBoxMenu:',CRLF,i);
  s:=ListBoxMultiSelection('Multiselection demo','Select multiple items:',
                           'Item 0'+CRLF+
                           'Item 1'+CRLF+
                           'Item 2'+CRLF+
                           'Item 3');
  writeln('ListBoxMultiSelection:',CRLF,s);
  s:='';
  TextEditDialog('Edit text dialog',
                 'User defined arguments:',
                 GetArguments);
  writeln(GetArgumentAsString(RusEng('Аргумент1','Argument1')));
  writeln(GetArgumentAsString(RusEng('Аргумент2','Argument2')));
 except
  on E:Exception do begin
   if WindowExists(twin) then CurvesCount[twin]:=0;
   Echo(PluginName+RusEng(': ОШИБКА!',': ERROR!'));
   if UsesBlaster then Voice('EXCEPTION');
   Echo(E.Message); Error(E.Message);
   Result:=-1;
  end;
 end;
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_exports.inc} // Exports CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID;        //
/////////////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////

