////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
// 20241104 - Translated from DPR source by A.K.                              //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Эта утилита служит для сглаживания кривой в области 
между правой и левой вертикальной границей "Области интересов" ROI.
Для этого надо задать в полях ввода абсолютную и относительную
ширину окна сглаживания, степень полинома (-1 соответствует интегралу),
а также параметры ядра сглаживания K(x)=(1-x^K1)^K2.
"Область интересов" должна быть задана в окне - источнике
перед вызовом утилиты при помощи двух маркеров ROI.
[]
[Manual.Eng]
This plugin uses to smooth curve to suppress noise
for points between left and right "Region Of Interest", ROI, markers.
You have to specify absolute and relative smooth window width,
polynom power (-1 mean integral) and kernel parameters K(x)=(1-x^K1)^K2.
Set "Region Of Interest" before call plugin.
Uses ROI markers in source data window.
[]
[Arguments.Rus]
Имя окна = Результат:"Сглаживание кривой ROI X"
Заголовок = ^CЗаголовок^N^L  Y
Легенда = ^RX  ^N^CЛегенда
Абс.Окно = 0
Отн.Окно = 0.05
Степень = 1
K1 = 2
K2 = 2
[]
[Arguments.Eng]
Caption = Result:"Smooth curve ROI X"
Title = ^CTitle^N^L  Y
Legend = ^RX  ^N^CLegend
Abs.Window = 0
Rel.Window = 0.05
Power = 1
K1 = 2
K2 = 2
[]
}

library _curve_smooth_roi_x;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics,
 _crw_crwapi;

/////////////////////////////////////////////////////////
{$I _crw_plugin_declare.inc} // Declare CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:ICrwApi):Integer;     //
/////////////////////////////////////////////////////////
const
 swin = +1; // Source window reference
 twin = -1; // Target window reference
 cwin =  0; // Clipboard window reference
 CheckFlags = cfInvalid + cfNoData + cfTooSmall + cfNotSortedX + cfDuplicatesX + cfNanInf;
var
 AbsEps, RelEps, Window : Double;
 p : TPoint2D;
 i, k1, k2, Power, c1, c2, cFirst, cLast : Integer;
 Roi : TRect2D;
 procedure Refreshment(Delta:Integer);
 const LastTicks : Cardinal = 0;
 begin
  if LastTicks=0 then LastTicks:=GetTickCount;
  if abs(GetTickCount-LastTicks) > Delta then begin
   with CrwApi,GuiApi do begin ApplicationProcessMessages; UpdateSystemConsole; end;
   LastTicks:=GetTickCount;
  end;
 end;
begin
 Result:=0;					
 with CrwApi,SysApi,GuiApi,DanApi do
 try
  RedirectStdIn(Input);				
  RedirectStdOut(Output);
  VerifyPluginDate(CrwApiEdition,Version);
  VerifyPluginType(Target,ForDataAnalysis);
  if not WindowExists(swin) 
  then Raise EDanApi.Create(RusEng('Не найдено окно - источник!',
                                   'Source window not found!'));
  if not WindowExists(twin) 
  then Raise EDanApi.Create(RusEng('Не найдено окно - приемник!',
                                   'Target window not found!'));
  if CurvesCount[swin]=0 
  then Raise EDanApi.Create(RusEng('Нет данных для обработки!',
                                   'No input data curves found!'));
  Roi:=WindowRoi[swin];
  if isNAN(Roi.A.X+Roi.A.Y)
  then Raise EDanApi.Create(RusEng('Левый маркер РОИ не определен!',
                                   'Left ROI marker is not defined!'));
  if isNAN(Roi.B.X+Roi.B.Y)
  then Raise EDanApi.Create(RusEng('Правый маркер РОИ не определен!',
                                   'Right ROI marker is not defined!'));
  Roi:=Rect2DValidate(Roi);
  Roi.A.Y:=_MinusInf;
  Roi.B.Y:=_PlusInf;
  WindowRoi[twin]:=WindowRoi[swin];
  WindowCaption[twin]:=GetArgumentAsString(RusEng('Имя окна','Caption'));
  WindowTitle[twin]:=GetArgumentAsString(RusEng('Заголовок','Title'));
  WindowLegend[twin]:=GetArgumentAsString(RusEng('Легенда','Legend'));
  if not GetArgumentAsDouble(RusEng('Абс.Окно','Abs.Window'),AbsEps) or
     not GetArgumentAsDouble(RusEng('Отн.Окно','Rel.Window'),RelEps) or
     not GetArgumentAsInteger(RusEng('Степень','Power'),Power) or
     not GetArgumentAsInteger(RusEng('K1','K1'),k1) or
     not GetArgumentAsInteger(RusEng('K2','K2'),k2)
  then Raise EDanApi.Create(RusEng('Ошибка задания аргументов!',
                                   'Invalid input arguments!'));
  if SelectedCurve[swin]>0 then begin
   cFirst:=SelectedCurve[swin];
   cLast:=SelectedCurve[swin];
  end else begin
   if YesNo(RusEng('Выполнить для всех кривых в окне?',
                   'Execute for all curves in window?'))<>mrYes
   then Raise EDanApi.Create(RusEng('Пользователь прервал!','User break!'));
   cFirst:=1;
   cLast:=CurvesCount[swin];
  end;
  for c1:=cFirst to cLast do begin
   if CurveFlags(c1,0,1E-10,3) and CheckFlags <> 0
   then Raise EDanApi.Create(Format(RusEng('Кривая %d непригодна для сглаживания!',
                                           'Curve %d is not convenient for smoothing!'),[c1]));
   Window:=Max(Abs(AbsEps),Abs(RelEps*Rect2DSize(CurveLimits[c1]).X));
   c2:=CreateCurve(twin,CurveName[c1],CurveColor[c1],CurveStyle[c1],CurveComment[c1]);
   CurveLength[c2]:=CurveLength[c1];
   for i:=0 to CurveLength[c1]-1 do begin
    p:=CurvePoint[c1,i];
    if Rect2DContainsPoint(Roi,p) 
    then p.y:=CurveSmoothAt(c1,p.x,Window,Power,k1,k2);
    CurvePoint[c2,i]:=p;
    Refreshment(100);
   end;
  end;
  if SelectedCurve[swin]>0 then SelectedCurve[twin]:=1 else SelectedCurve[twin]:=0;
 except
  on E:Exception do begin
   if WindowExists(twin) then CurvesCount[twin]:=0;
   Echo(PluginName+RusEng(': ОШИБКА!',': ERROR!')); 
   if UsesBlaster then Voice('EXCEPTION');
   Echo(E.Message); Error(E.Message);
   Result:=-1;
  end;
 end;
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_exports.inc} // Exports CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID;        //
/////////////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
 
