---

# Unicode cheat sheet

see **[github](https://gist.github.com/jpassaro/bf400b0410810a071a7fb3509ef6c2c3)**

A curated list of unicode characters I want to have quick reference toward,
including their literal presentation (where possible), description from the
unicode table, various representations, and how to enter it as a Vim digraph\*.

They are grouped by category, including a link to the relevant Unicode block.
Also see [the full list of Unicode
blocks](https://en.wikipedia.org/wiki/Unicode_block)

To update the table by adding, deleting or moving various characters, edit the
function `genchars()` in 01-generate.py, then run this command:

```console
$ python3 01-generate.py 02-vim-digraphs.txt > 00-unicode-cheat-sheet.md
```

### Vim digraphs

The *Vim* column in this table lists Vim *digraphs*. To use these, go into
insertion mode and type `Ctrl-K` followed by the listed pair of keys. For
example, `Ctrl-K` + `C` + `o` generates the copyright symbol &copy;.  See
`:help digraph` or `:help ^K` for more information.

## Data


* [Latin-1 Supplement](#latin-1)
* [Greek and Coptic](#greek)
* [Cyrillic](#cyrillic)
* [General Punctuation](#punctuation)
* [Superscripts and Subscripts](#subscripts)
* [Mathematical Operators](#math)
* [Miscellaneous Symbols](#misc)
* [Number Forms](#number-forms)
* [Geometric Shapes](#geometry)
* [ASCII](#ascii)
* [music](#music)
* [emoji](#emoji)
* [Vim Digraphs](#vim)
* [Unassigned Digraphs](#unassigned-digraphs)

Actual                             | Description                                                                                                  | Vim        | HTML          | Hex    | Dec    | UTF-8       | UTF-16            | Category
---------------------------------- | ------------------------------------------------------------------------------------------------------------ | ---------- | ------------- | ------ | ------ | ----------- | ----------------- | ---
<a id="latin-1">*Section*</a>      | [**Latin-1 Supplement**](https://en.wikipedia.org/wiki/Latin-1_Supplement_(Unicode_block))                   |            |               |        |        |             |                   |
                                   | NO-BREAK SPACE                                                                                               | `NS`       | &amp;nbsp;    | xA0    | 160    | C2 A0       | FF FE A0 00       | Zs
¡                                  | INVERTED EXCLAMATION MARK                                                                                    | `!I`       | &amp;iexcl;   | xA1    | 161    | C2 A1       | FF FE A1 00       | Po
¢                                  | CENT SIGN                                                                                                    | `Ct`       | &amp;cent;    | xA2    | 162    | C2 A2       | FF FE A2 00       | Sc
£                                  | POUND SIGN                                                                                                   | `Pd`       | &amp;pound;   | xA3    | 163    | C2 A3       | FF FE A3 00       | Sc
¤                                  | CURRENCY SIGN                                                                                                | `Cu`       | &amp;curren;  | xA4    | 164    | C2 A4       | FF FE A4 00       | Sc
¥                                  | YEN SIGN                                                                                                     | `Ye`       | &amp;yen;     | xA5    | 165    | C2 A5       | FF FE A5 00       | Sc
¦                                  | BROKEN BAR                                                                                                   | `BB`       | &amp;brvbar;  | xA6    | 166    | C2 A6       | FF FE A6 00       | So
§                                  | SECTION SIGN                                                                                                 | `SE`       | &amp;sect;    | xA7    | 167    | C2 A7       | FF FE A7 00       | Po
¨                                  | DIAERESIS                                                                                                    | `':`       | &amp;uml;     | xA8    | 168    | C2 A8       | FF FE A8 00       | Sk
©                                  | COPYRIGHT SIGN                                                                                               | `Co`       | &amp;copy;    | xA9    | 169    | C2 A9       | FF FE A9 00       | So
ª                                  | FEMININE ORDINAL INDICATOR                                                                                   | `-a`       | &amp;ordf;    | xAA    | 170    | C2 AA       | FF FE AA 00       | Lo
«                                  | LEFT-POINTING DOUBLE ANGLE QUOTATION MARK                                                                    | `<<`       | &amp;laquo;   | xAB    | 171    | C2 AB       | FF FE AB 00       | Pi
¬                                  | NOT SIGN                                                                                                     | `NO`       | &amp;not;     | xAC    | 172    | C2 AC       | FF FE AC 00       | Sm
*n/a*                              | SOFT HYPHEN                                                                                                  | `--`       | &amp;shy;     | xAD    | 173    | C2 AD       | FF FE AD 00       | Cf
®                                  | REGISTERED SIGN                                                                                              | `Rg`       | &amp;reg;     | xAE    | 174    | C2 AE       | FF FE AE 00       | So
¯                                  | MACRON                                                                                                       | `'m`       | &amp;macr;    | xAF    | 175    | C2 AF       | FF FE AF 00       | Sk
°                                  | DEGREE SIGN                                                                                                  | `DG`       | &amp;deg;     | xB0    | 176    | C2 B0       | FF FE B0 00       | So
±                                  | PLUS-MINUS SIGN                                                                                              | `+-`       | &amp;plusmn;  | xB1    | 177    | C2 B1       | FF FE B1 00       | Sm
²                                  | SUPERSCRIPT TWO                                                                                              | `2S`       | &amp;sup2;    | xB2    | 178    | C2 B2       | FF FE B2 00       | No
³                                  | SUPERSCRIPT THREE                                                                                            | `3S`       | &amp;sup3;    | xB3    | 179    | C2 B3       | FF FE B3 00       | No
´                                  | ACUTE ACCENT                                                                                                 | `''`       | &amp;acute;   | xB4    | 180    | C2 B4       | FF FE B4 00       | Sk
µ                                  | MICRO SIGN                                                                                                   | `My`       | &amp;micro;   | xB5    | 181    | C2 B5       | FF FE B5 00       | Ll
¶                                  | PILCROW SIGN                                                                                                 | `PI`       | &amp;para;    | xB6    | 182    | C2 B6       | FF FE B6 00       | Po
·                                  | MIDDLE DOT                                                                                                   | `.M`       | &amp;middot;  | xB7    | 183    | C2 B7       | FF FE B7 00       | Po
¸                                  | CEDILLA                                                                                                      | `',`       | &amp;cedil;   | xB8    | 184    | C2 B8       | FF FE B8 00       | Sk
¹                                  | SUPERSCRIPT ONE                                                                                              | `1S`       | &amp;sup1;    | xB9    | 185    | C2 B9       | FF FE B9 00       | No
º                                  | MASCULINE ORDINAL INDICATOR                                                                                  | `-o`       | &amp;ordm;    | xBA    | 186    | C2 BA       | FF FE BA 00       | Lo
»                                  | RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK                                                                   | `>>`       | &amp;raquo;   | xBB    | 187    | C2 BB       | FF FE BB 00       | Pf
¼                                  | VULGAR FRACTION ONE QUARTER                                                                                  | `14`       | &amp;frac14;  | xBC    | 188    | C2 BC       | FF FE BC 00       | No
½                                  | VULGAR FRACTION ONE HALF                                                                                     | `12`       | &amp;frac12;  | xBD    | 189    | C2 BD       | FF FE BD 00       | No
¾                                  | VULGAR FRACTION THREE QUARTERS                                                                               | `34`       | &amp;frac34;  | xBE    | 190    | C2 BE       | FF FE BE 00       | No
¿                                  | INVERTED QUESTION MARK                                                                                       | `?I`       | &amp;iquest;  | xBF    | 191    | C2 BF       | FF FE BF 00       | Po
À                                  | LATIN CAPITAL LETTER A WITH GRAVE                                                                            | `A!`       | &amp;Agrave;  | xC0    | 192    | C3 80       | FF FE C0 00       | Lu
Á                                  | LATIN CAPITAL LETTER A WITH ACUTE                                                                            | `A'`       | &amp;Aacute;  | xC1    | 193    | C3 81       | FF FE C1 00       | Lu
Â                                  | LATIN CAPITAL LETTER A WITH CIRCUMFLEX                                                                       | `A>`       | &amp;Acirc;   | xC2    | 194    | C3 82       | FF FE C2 00       | Lu
Ã                                  | LATIN CAPITAL LETTER A WITH TILDE                                                                            | `A?`       | &amp;Atilde;  | xC3    | 195    | C3 83       | FF FE C3 00       | Lu
Ä                                  | LATIN CAPITAL LETTER A WITH DIAERESIS                                                                        | `A:`       | &amp;Auml;    | xC4    | 196    | C3 84       | FF FE C4 00       | Lu
Å                                  | LATIN CAPITAL LETTER A WITH RING ABOVE                                                                       | `AA`       | &amp;Aring;   | xC5    | 197    | C3 85       | FF FE C5 00       | Lu
Æ                                  | LATIN CAPITAL LETTER AE                                                                                      | `AE`       | &amp;AElig;   | xC6    | 198    | C3 86       | FF FE C6 00       | Lu
Ç                                  | LATIN CAPITAL LETTER C WITH CEDILLA                                                                          | `C,`       | &amp;Ccedil;  | xC7    | 199    | C3 87       | FF FE C7 00       | Lu
È                                  | LATIN CAPITAL LETTER E WITH GRAVE                                                                            | `E!`       | &amp;Egrave;  | xC8    | 200    | C3 88       | FF FE C8 00       | Lu
É                                  | LATIN CAPITAL LETTER E WITH ACUTE                                                                            | `E'`       | &amp;Eacute;  | xC9    | 201    | C3 89       | FF FE C9 00       | Lu
Ê                                  | LATIN CAPITAL LETTER E WITH CIRCUMFLEX                                                                       | `E>`       | &amp;Ecirc;   | xCA    | 202    | C3 8A       | FF FE CA 00       | Lu
Ë                                  | LATIN CAPITAL LETTER E WITH DIAERESIS                                                                        | `E:`       | &amp;Euml;    | xCB    | 203    | C3 8B       | FF FE CB 00       | Lu
Ì                                  | LATIN CAPITAL LETTER I WITH GRAVE                                                                            | `I!`       | &amp;Igrave;  | xCC    | 204    | C3 8C       | FF FE CC 00       | Lu
Í                                  | LATIN CAPITAL LETTER I WITH ACUTE                                                                            | `I'`       | &amp;Iacute;  | xCD    | 205    | C3 8D       | FF FE CD 00       | Lu
Î                                  | LATIN CAPITAL LETTER I WITH CIRCUMFLEX                                                                       | `I>`       | &amp;Icirc;   | xCE    | 206    | C3 8E       | FF FE CE 00       | Lu
Ï                                  | LATIN CAPITAL LETTER I WITH DIAERESIS                                                                        | `I:`       | &amp;Iuml;    | xCF    | 207    | C3 8F       | FF FE CF 00       | Lu
Ð                                  | LATIN CAPITAL LETTER ETH (Icelandic)                                                                         | `D-`       | &amp;ETH;     | xD0    | 208    | C3 90       | FF FE D0 00       | Lu
Ñ                                  | LATIN CAPITAL LETTER N WITH TILDE                                                                            | `N?`       | &amp;Ntilde;  | xD1    | 209    | C3 91       | FF FE D1 00       | Lu
Ò                                  | LATIN CAPITAL LETTER O WITH GRAVE                                                                            | `O!`       | &amp;Ograve;  | xD2    | 210    | C3 92       | FF FE D2 00       | Lu
Ó                                  | LATIN CAPITAL LETTER O WITH ACUTE                                                                            | `O'`       | &amp;Oacute;  | xD3    | 211    | C3 93       | FF FE D3 00       | Lu
Ô                                  | LATIN CAPITAL LETTER O WITH CIRCUMFLEX                                                                       | `O>`       | &amp;Ocirc;   | xD4    | 212    | C3 94       | FF FE D4 00       | Lu
Õ                                  | LATIN CAPITAL LETTER O WITH TILDE                                                                            | `O?`       | &amp;Otilde;  | xD5    | 213    | C3 95       | FF FE D5 00       | Lu
Ö                                  | LATIN CAPITAL LETTER O WITH DIAERESIS                                                                        | `O:`       | &amp;Ouml;    | xD6    | 214    | C3 96       | FF FE D6 00       | Lu
×                                  | MULTIPLICATION SIGN                                                                                          | `*X`       | &amp;times;   | xD7    | 215    | C3 97       | FF FE D7 00       | Sm
Ø                                  | LATIN CAPITAL LETTER O WITH STROKE                                                                           | `O/`       | &amp;Oslash;  | xD8    | 216    | C3 98       | FF FE D8 00       | Lu
Ù                                  | LATIN CAPITAL LETTER U WITH GRAVE                                                                            | `U!`       | &amp;Ugrave;  | xD9    | 217    | C3 99       | FF FE D9 00       | Lu
Ú                                  | LATIN CAPITAL LETTER U WITH ACUTE                                                                            | `U'`       | &amp;Uacute;  | xDA    | 218    | C3 9A       | FF FE DA 00       | Lu
Û                                  | LATIN CAPITAL LETTER U WITH CIRCUMFLEX                                                                       | `U>`       | &amp;Ucirc;   | xDB    | 219    | C3 9B       | FF FE DB 00       | Lu
Ü                                  | LATIN CAPITAL LETTER U WITH DIAERESIS                                                                        | `U:`       | &amp;Uuml;    | xDC    | 220    | C3 9C       | FF FE DC 00       | Lu
Ý                                  | LATIN CAPITAL LETTER Y WITH ACUTE                                                                            | `Y'`       | &amp;Yacute;  | xDD    | 221    | C3 9D       | FF FE DD 00       | Lu
Þ                                  | LATIN CAPITAL LETTER THORN (Icelandic)                                                                       | `TH`       | &amp;THORN;   | xDE    | 222    | C3 9E       | FF FE DE 00       | Lu
ß                                  | LATIN SMALL LETTER SHARP S (German)                                                                          | `ss`       | &amp;szlig;   | xDF    | 223    | C3 9F       | FF FE DF 00       | Ll
à                                  | LATIN SMALL LETTER A WITH GRAVE                                                                              | `a!`       | &amp;agrave;  | xE0    | 224    | C3 A0       | FF FE E0 00       | Ll
á                                  | LATIN SMALL LETTER A WITH ACUTE                                                                              | `a'`       | &amp;aacute;  | xE1    | 225    | C3 A1       | FF FE E1 00       | Ll
â                                  | LATIN SMALL LETTER A WITH CIRCUMFLEX                                                                         | `a>`       | &amp;acirc;   | xE2    | 226    | C3 A2       | FF FE E2 00       | Ll
ã                                  | LATIN SMALL LETTER A WITH TILDE                                                                              | `a?`       | &amp;atilde;  | xE3    | 227    | C3 A3       | FF FE E3 00       | Ll
ä                                  | LATIN SMALL LETTER A WITH DIAERESIS                                                                          | `a:`       | &amp;auml;    | xE4    | 228    | C3 A4       | FF FE E4 00       | Ll
å                                  | LATIN SMALL LETTER A WITH RING ABOVE                                                                         | `aa`       | &amp;aring;   | xE5    | 229    | C3 A5       | FF FE E5 00       | Ll
æ                                  | LATIN SMALL LETTER AE                                                                                        | `ae`       | &amp;aelig;   | xE6    | 230    | C3 A6       | FF FE E6 00       | Ll
ç                                  | LATIN SMALL LETTER C WITH CEDILLA                                                                            | `c,`       | &amp;ccedil;  | xE7    | 231    | C3 A7       | FF FE E7 00       | Ll
è                                  | LATIN SMALL LETTER E WITH GRAVE                                                                              | `e!`       | &amp;egrave;  | xE8    | 232    | C3 A8       | FF FE E8 00       | Ll
é                                  | LATIN SMALL LETTER E WITH ACUTE                                                                              | `e'`       | &amp;eacute;  | xE9    | 233    | C3 A9       | FF FE E9 00       | Ll
ê                                  | LATIN SMALL LETTER E WITH CIRCUMFLEX                                                                         | `e>`       | &amp;ecirc;   | xEA    | 234    | C3 AA       | FF FE EA 00       | Ll
ë                                  | LATIN SMALL LETTER E WITH DIAERESIS                                                                          | `e:`       | &amp;euml;    | xEB    | 235    | C3 AB       | FF FE EB 00       | Ll
ì                                  | LATIN SMALL LETTER I WITH GRAVE                                                                              | `i!`       | &amp;igrave;  | xEC    | 236    | C3 AC       | FF FE EC 00       | Ll
í                                  | LATIN SMALL LETTER I WITH ACUTE                                                                              | `i'`       | &amp;iacute;  | xED    | 237    | C3 AD       | FF FE ED 00       | Ll
î                                  | LATIN SMALL LETTER I WITH CIRCUMFLEX                                                                         | `i>`       | &amp;icirc;   | xEE    | 238    | C3 AE       | FF FE EE 00       | Ll
ï                                  | LATIN SMALL LETTER I WITH DIAERESIS                                                                          | `i:`       | &amp;iuml;    | xEF    | 239    | C3 AF       | FF FE EF 00       | Ll
ð                                  | LATIN SMALL LETTER ETH (Icelandic)                                                                           | `d-`       | &amp;eth;     | xF0    | 240    | C3 B0       | FF FE F0 00       | Ll
ñ                                  | LATIN SMALL LETTER N WITH TILDE                                                                              | `n?`       | &amp;ntilde;  | xF1    | 241    | C3 B1       | FF FE F1 00       | Ll
ò                                  | LATIN SMALL LETTER O WITH GRAVE                                                                              | `o!`       | &amp;ograve;  | xF2    | 242    | C3 B2       | FF FE F2 00       | Ll
ó                                  | LATIN SMALL LETTER O WITH ACUTE                                                                              | `o'`       | &amp;oacute;  | xF3    | 243    | C3 B3       | FF FE F3 00       | Ll
ô                                  | LATIN SMALL LETTER O WITH CIRCUMFLEX                                                                         | `o>`       | &amp;ocirc;   | xF4    | 244    | C3 B4       | FF FE F4 00       | Ll
õ                                  | LATIN SMALL LETTER O WITH TILDE                                                                              | `o?`       | &amp;otilde;  | xF5    | 245    | C3 B5       | FF FE F5 00       | Ll
ö                                  | LATIN SMALL LETTER O WITH DIAERESIS                                                                          | `o:`       | &amp;ouml;    | xF6    | 246    | C3 B6       | FF FE F6 00       | Ll
÷                                  | DIVISION SIGN                                                                                                | `-:`       | &amp;divide;  | xF7    | 247    | C3 B7       | FF FE F7 00       | Sm
ø                                  | LATIN SMALL LETTER O WITH STROKE                                                                             | `o/`       | &amp;oslash;  | xF8    | 248    | C3 B8       | FF FE F8 00       | Ll
ù                                  | LATIN SMALL LETTER U WITH GRAVE                                                                              | `u!`       | &amp;ugrave;  | xF9    | 249    | C3 B9       | FF FE F9 00       | Ll
ú                                  | LATIN SMALL LETTER U WITH ACUTE                                                                              | `u'`       | &amp;uacute;  | xFA    | 250    | C3 BA       | FF FE FA 00       | Ll
û                                  | LATIN SMALL LETTER U WITH CIRCUMFLEX                                                                         | `u>`       | &amp;ucirc;   | xFB    | 251    | C3 BB       | FF FE FB 00       | Ll
ü                                  | LATIN SMALL LETTER U WITH DIAERESIS                                                                          | `u:`       | &amp;uuml;    | xFC    | 252    | C3 BC       | FF FE FC 00       | Ll
ý                                  | LATIN SMALL LETTER Y WITH ACUTE                                                                              | `y'`       | &amp;yacute;  | xFD    | 253    | C3 BD       | FF FE FD 00       | Ll
þ                                  | LATIN SMALL LETTER THORN (Icelandic)                                                                         | `th`       | &amp;thorn;   | xFE    | 254    | C3 BE       | FF FE FE 00       | Ll
ÿ                                  | LATIN SMALL LETTER Y WITH DIAERESIS                                                                          | `y:`       | &amp;yuml;    | xFF    | 255    | C3 BF       | FF FE FF 00       | Ll
<a id="greek">*Section*</a>        | [**Greek and Coptic**](https://en.wikipedia.org/wiki/Greek_and_Coptic)                                       |            |               |        |        |             |                   |
Α                                  | GREEK CAPITAL LETTER ALPHA                                                                                   | `A*`       | &amp;Alpha;   | x391   | 913    | CE 91       | FF FE 91 03       | Lu
Β                                  | GREEK CAPITAL LETTER BETA                                                                                    | `B*`       | &amp;Beta;    | x392   | 914    | CE 92       | FF FE 92 03       | Lu
Γ                                  | GREEK CAPITAL LETTER GAMMA                                                                                   | `G*`       | &amp;Gamma;   | x393   | 915    | CE 93       | FF FE 93 03       | Lu
Δ                                  | GREEK CAPITAL LETTER DELTA                                                                                   | `D*`       | &amp;Delta;   | x394   | 916    | CE 94       | FF FE 94 03       | Lu
Ε                                  | GREEK CAPITAL LETTER EPSILON                                                                                 | `E*`       | &amp;Epsilon; | x395   | 917    | CE 95       | FF FE 95 03       | Lu
Ζ                                  | GREEK CAPITAL LETTER ZETA                                                                                    | `Z*`       | &amp;Zeta;    | x396   | 918    | CE 96       | FF FE 96 03       | Lu
Η                                  | GREEK CAPITAL LETTER ETA                                                                                     | `Y*`       | &amp;Eta;     | x397   | 919    | CE 97       | FF FE 97 03       | Lu
Θ                                  | GREEK CAPITAL LETTER THETA                                                                                   | `H*`       | &amp;Theta;   | x398   | 920    | CE 98       | FF FE 98 03       | Lu
Ι                                  | GREEK CAPITAL LETTER IOTA                                                                                    | `I*`       | &amp;Iota;    | x399   | 921    | CE 99       | FF FE 99 03       | Lu
Κ                                  | GREEK CAPITAL LETTER KAPPA                                                                                   | `K*`       | &amp;Kappa;   | x39A   | 922    | CE 9A       | FF FE 9A 03       | Lu
Λ                                  | GREEK CAPITAL LETTER LAMDA                                                                                   | `L*`       | &amp;Lambda;  | x39B   | 923    | CE 9B       | FF FE 9B 03       | Lu
Μ                                  | GREEK CAPITAL LETTER MU                                                                                      | `M*`       | &amp;Mu;      | x39C   | 924    | CE 9C       | FF FE 9C 03       | Lu
Ν                                  | GREEK CAPITAL LETTER NU                                                                                      | `N*`       | &amp;Nu;      | x39D   | 925    | CE 9D       | FF FE 9D 03       | Lu
Ξ                                  | GREEK CAPITAL LETTER XI                                                                                      | `C*`       | &amp;Xi;      | x39E   | 926    | CE 9E       | FF FE 9E 03       | Lu
Ο                                  | GREEK CAPITAL LETTER OMICRON                                                                                 | `O*`       | &amp;Omicron; | x39F   | 927    | CE 9F       | FF FE 9F 03       | Lu
Π                                  | GREEK CAPITAL LETTER PI                                                                                      | `P*`       | &amp;Pi;      | x3A0   | 928    | CE A0       | FF FE A0 03       | Lu
Ρ                                  | GREEK CAPITAL LETTER RHO                                                                                     | `R*`       | &amp;Rho;     | x3A1   | 929    | CE A1       | FF FE A1 03       | Lu
Σ                                  | GREEK CAPITAL LETTER SIGMA                                                                                   | `S*`       | &amp;Sigma;   | x3A3   | 931    | CE A3       | FF FE A3 03       | Lu
Τ                                  | GREEK CAPITAL LETTER TAU                                                                                     | `T*`       | &amp;Tau;     | x3A4   | 932    | CE A4       | FF FE A4 03       | Lu
Υ                                  | GREEK CAPITAL LETTER UPSILON                                                                                 | `U*`       | &amp;Upsilon; | x3A5   | 933    | CE A5       | FF FE A5 03       | Lu
Φ                                  | GREEK CAPITAL LETTER PHI                                                                                     | `F*`       | &amp;Phi;     | x3A6   | 934    | CE A6       | FF FE A6 03       | Lu
Χ                                  | GREEK CAPITAL LETTER CHI                                                                                     | `X*`       | &amp;Chi;     | x3A7   | 935    | CE A7       | FF FE A7 03       | Lu
Ψ                                  | GREEK CAPITAL LETTER PSI                                                                                     | `Q*`       | &amp;Psi;     | x3A8   | 936    | CE A8       | FF FE A8 03       | Lu
Ω                                  | GREEK CAPITAL LETTER OMEGA                                                                                   | `W*`       | &amp;Omega;   | x3A9   | 937    | CE A9       | FF FE A9 03       | Lu
α                                  | GREEK SMALL LETTER ALPHA                                                                                     | `a*`       | &amp;alpha;   | x3B1   | 945    | CE B1       | FF FE B1 03       | Ll
β                                  | GREEK SMALL LETTER BETA                                                                                      | `b*`       | &amp;beta;    | x3B2   | 946    | CE B2       | FF FE B2 03       | Ll
γ                                  | GREEK SMALL LETTER GAMMA                                                                                     | `g*`       | &amp;gamma;   | x3B3   | 947    | CE B3       | FF FE B3 03       | Ll
δ                                  | GREEK SMALL LETTER DELTA                                                                                     | `d*`       | &amp;delta;   | x3B4   | 948    | CE B4       | FF FE B4 03       | Ll
ε                                  | GREEK SMALL LETTER EPSILON                                                                                   | `e*`       | &amp;epsilon; | x3B5   | 949    | CE B5       | FF FE B5 03       | Ll
ζ                                  | GREEK SMALL LETTER ZETA                                                                                      | `z*`       | &amp;zeta;    | x3B6   | 950    | CE B6       | FF FE B6 03       | Ll
η                                  | GREEK SMALL LETTER ETA                                                                                       | `y*`       | &amp;eta;     | x3B7   | 951    | CE B7       | FF FE B7 03       | Ll
θ                                  | GREEK SMALL LETTER THETA                                                                                     | `h*`       | &amp;theta;   | x3B8   | 952    | CE B8       | FF FE B8 03       | Ll
ι                                  | GREEK SMALL LETTER IOTA                                                                                      | `i*`       | &amp;iota;    | x3B9   | 953    | CE B9       | FF FE B9 03       | Ll
κ                                  | GREEK SMALL LETTER KAPPA                                                                                     | `k*`       | &amp;kappa;   | x3BA   | 954    | CE BA       | FF FE BA 03       | Ll
λ                                  | GREEK SMALL LETTER LAMDA                                                                                     | `l*`       | &amp;lambda;  | x3BB   | 955    | CE BB       | FF FE BB 03       | Ll
μ                                  | GREEK SMALL LETTER MU                                                                                        | `m*`       | &amp;mu;      | x3BC   | 956    | CE BC       | FF FE BC 03       | Ll
ν                                  | GREEK SMALL LETTER NU                                                                                        | `n*`       | &amp;nu;      | x3BD   | 957    | CE BD       | FF FE BD 03       | Ll
ξ                                  | GREEK SMALL LETTER XI                                                                                        | `c*`       | &amp;xi;      | x3BE   | 958    | CE BE       | FF FE BE 03       | Ll
ο                                  | GREEK SMALL LETTER OMICRON                                                                                   | `o*`       | &amp;omicron; | x3BF   | 959    | CE BF       | FF FE BF 03       | Ll
π                                  | GREEK SMALL LETTER PI                                                                                        | `p*`       | &amp;pi;      | x3C0   | 960    | CF 80       | FF FE C0 03       | Ll
ρ                                  | GREEK SMALL LETTER RHO                                                                                       | `r*`       | &amp;rho;     | x3C1   | 961    | CF 81       | FF FE C1 03       | Ll
σ                                  | GREEK SMALL LETTER SIGMA                                                                                     | `s*`       | &amp;sigma;   | x3C3   | 963    | CF 83       | FF FE C3 03       | Ll
τ                                  | GREEK SMALL LETTER TAU                                                                                       | `t*`       | &amp;tau;     | x3C4   | 964    | CF 84       | FF FE C4 03       | Ll
υ                                  | GREEK SMALL LETTER UPSILON                                                                                   | `u*`       | &amp;upsilon; | x3C5   | 965    | CF 85       | FF FE C5 03       | Ll
φ                                  | GREEK SMALL LETTER PHI                                                                                       | `f*`       | &amp;phi;     | x3C6   | 966    | CF 86       | FF FE C6 03       | Ll
χ                                  | GREEK SMALL LETTER CHI                                                                                       | `x*`       | &amp;chi;     | x3C7   | 967    | CF 87       | FF FE C7 03       | Ll
ψ                                  | GREEK SMALL LETTER PSI                                                                                       | `q*`       | &amp;psi;     | x3C8   | 968    | CF 88       | FF FE C8 03       | Ll
ω                                  | GREEK SMALL LETTER OMEGA                                                                                     | `w*`       | &amp;omega;   | x3C9   | 969    | CF 89       | FF FE C9 03       | Ll
<a id="cyrillic">*Section*</a>     | [**Cyrillic**](https://en.wikipedia.org/wiki/Cyrillic_(Unicode_block))                                       |            |               |        |        |             |                   |
А                                  | CYRILLIC CAPITAL LETTER A                                                                                    | `A=`       | &amp;x410;    | x410   | 1040   | D0 90       | FF FE 10 04       | Lu
Б                                  | CYRILLIC CAPITAL LETTER BE                                                                                   | `B=`       | &amp;x411;    | x411   | 1041   | D0 91       | FF FE 11 04       | Lu
В                                  | CYRILLIC CAPITAL LETTER VE                                                                                   | `V=`       | &amp;x412;    | x412   | 1042   | D0 92       | FF FE 12 04       | Lu
Г                                  | CYRILLIC CAPITAL LETTER GHE                                                                                  | `G=`       | &amp;x413;    | x413   | 1043   | D0 93       | FF FE 13 04       | Lu
Д                                  | CYRILLIC CAPITAL LETTER DE                                                                                   | `D=`       | &amp;x414;    | x414   | 1044   | D0 94       | FF FE 14 04       | Lu
Е                                  | CYRILLIC CAPITAL LETTER IE                                                                                   | `E=`       | &amp;x415;    | x415   | 1045   | D0 95       | FF FE 15 04       | Lu
Ж                                  | CYRILLIC CAPITAL LETTER ZHE                                                                                  | `Z%`       | &amp;x416;    | x416   | 1046   | D0 96       | FF FE 16 04       | Lu
З                                  | CYRILLIC CAPITAL LETTER ZE                                                                                   | `Z=`       | &amp;x417;    | x417   | 1047   | D0 97       | FF FE 17 04       | Lu
И                                  | CYRILLIC CAPITAL LETTER I                                                                                    | `I=`       | &amp;x418;    | x418   | 1048   | D0 98       | FF FE 18 04       | Lu
Й                                  | CYRILLIC CAPITAL LETTER SHORT I                                                                              | `J=`       | &amp;x419;    | x419   | 1049   | D0 99       | FF FE 19 04       | Lu
К                                  | CYRILLIC CAPITAL LETTER KA                                                                                   | `K=`       | &amp;x41A;    | x41A   | 1050   | D0 9A       | FF FE 1A 04       | Lu
Л                                  | CYRILLIC CAPITAL LETTER EL                                                                                   | `L=`       | &amp;x41B;    | x41B   | 1051   | D0 9B       | FF FE 1B 04       | Lu
М                                  | CYRILLIC CAPITAL LETTER EM                                                                                   | `M=`       | &amp;x41C;    | x41C   | 1052   | D0 9C       | FF FE 1C 04       | Lu
Н                                  | CYRILLIC CAPITAL LETTER EN                                                                                   | `N=`       | &amp;x41D;    | x41D   | 1053   | D0 9D       | FF FE 1D 04       | Lu
О                                  | CYRILLIC CAPITAL LETTER O                                                                                    | `O=`       | &amp;x41E;    | x41E   | 1054   | D0 9E       | FF FE 1E 04       | Lu
П                                  | CYRILLIC CAPITAL LETTER PE                                                                                   | `P=`       | &amp;x41F;    | x41F   | 1055   | D0 9F       | FF FE 1F 04       | Lu
Р                                  | CYRILLIC CAPITAL LETTER ER                                                                                   | `R=`       | &amp;x420;    | x420   | 1056   | D0 A0       | FF FE 20 04       | Lu
С                                  | CYRILLIC CAPITAL LETTER ES                                                                                   | `S=`       | &amp;x421;    | x421   | 1057   | D0 A1       | FF FE 21 04       | Lu
Т                                  | CYRILLIC CAPITAL LETTER TE                                                                                   | `T=`       | &amp;x422;    | x422   | 1058   | D0 A2       | FF FE 22 04       | Lu
У                                  | CYRILLIC CAPITAL LETTER U                                                                                    | `U=`       | &amp;x423;    | x423   | 1059   | D0 A3       | FF FE 23 04       | Lu
Ф                                  | CYRILLIC CAPITAL LETTER EF                                                                                   | `F=`       | &amp;x424;    | x424   | 1060   | D0 A4       | FF FE 24 04       | Lu
Х                                  | CYRILLIC CAPITAL LETTER HA                                                                                   | `H=`       | &amp;x425;    | x425   | 1061   | D0 A5       | FF FE 25 04       | Lu
Ц                                  | CYRILLIC CAPITAL LETTER TSE                                                                                  | `C=`       | &amp;x426;    | x426   | 1062   | D0 A6       | FF FE 26 04       | Lu
Ч                                  | CYRILLIC CAPITAL LETTER CHE                                                                                  | `C%`       | &amp;x427;    | x427   | 1063   | D0 A7       | FF FE 27 04       | Lu
Ш                                  | CYRILLIC CAPITAL LETTER SHA                                                                                  | `S%`       | &amp;x428;    | x428   | 1064   | D0 A8       | FF FE 28 04       | Lu
Щ                                  | CYRILLIC CAPITAL LETTER SHCHA                                                                                | `Sc`       | &amp;x429;    | x429   | 1065   | D0 A9       | FF FE 29 04       | Lu
Ъ                                  | CYRILLIC CAPITAL LETTER HARD SIGN                                                                            | `="`       | &amp;x42A;    | x42A   | 1066   | D0 AA       | FF FE 2A 04       | Lu
Ы                                  | CYRILLIC CAPITAL LETTER YERU                                                                                 | `Y=`       | &amp;x42B;    | x42B   | 1067   | D0 AB       | FF FE 2B 04       | Lu
Ь                                  | CYRILLIC CAPITAL LETTER SOFT SIGN                                                                            | `%"`       | &amp;x42C;    | x42C   | 1068   | D0 AC       | FF FE 2C 04       | Lu
Э                                  | CYRILLIC CAPITAL LETTER E                                                                                    | `JE`       | &amp;x42D;    | x42D   | 1069   | D0 AD       | FF FE 2D 04       | Lu
Ю                                  | CYRILLIC CAPITAL LETTER YU                                                                                   | `JU`       | &amp;x42E;    | x42E   | 1070   | D0 AE       | FF FE 2E 04       | Lu
Я                                  | CYRILLIC CAPITAL LETTER YA                                                                                   | `JA`       | &amp;x42F;    | x42F   | 1071   | D0 AF       | FF FE 2F 04       | Lu
а                                  | CYRILLIC SMALL LETTER A                                                                                      | `a=`       | &amp;x430;    | x430   | 1072   | D0 B0       | FF FE 30 04       | Ll
б                                  | CYRILLIC SMALL LETTER BE                                                                                     | `b=`       | &amp;x431;    | x431   | 1073   | D0 B1       | FF FE 31 04       | Ll
в                                  | CYRILLIC SMALL LETTER VE                                                                                     | `v=`       | &amp;x432;    | x432   | 1074   | D0 B2       | FF FE 32 04       | Ll
г                                  | CYRILLIC SMALL LETTER GHE                                                                                    | `g=`       | &amp;x433;    | x433   | 1075   | D0 B3       | FF FE 33 04       | Ll
д                                  | CYRILLIC SMALL LETTER DE                                                                                     | `d=`       | &amp;x434;    | x434   | 1076   | D0 B4       | FF FE 34 04       | Ll
е                                  | CYRILLIC SMALL LETTER IE                                                                                     | `e=`       | &amp;x435;    | x435   | 1077   | D0 B5       | FF FE 35 04       | Ll
ж                                  | CYRILLIC SMALL LETTER ZHE                                                                                    | `z%`       | &amp;x436;    | x436   | 1078   | D0 B6       | FF FE 36 04       | Ll
з                                  | CYRILLIC SMALL LETTER ZE                                                                                     | `z=`       | &amp;x437;    | x437   | 1079   | D0 B7       | FF FE 37 04       | Ll
и                                  | CYRILLIC SMALL LETTER I                                                                                      | `i=`       | &amp;x438;    | x438   | 1080   | D0 B8       | FF FE 38 04       | Ll
й                                  | CYRILLIC SMALL LETTER SHORT I                                                                                | `j=`       | &amp;x439;    | x439   | 1081   | D0 B9       | FF FE 39 04       | Ll
к                                  | CYRILLIC SMALL LETTER KA                                                                                     | `k=`       | &amp;x43A;    | x43A   | 1082   | D0 BA       | FF FE 3A 04       | Ll
л                                  | CYRILLIC SMALL LETTER EL                                                                                     | `l=`       | &amp;x43B;    | x43B   | 1083   | D0 BB       | FF FE 3B 04       | Ll
м                                  | CYRILLIC SMALL LETTER EM                                                                                     | `m=`       | &amp;x43C;    | x43C   | 1084   | D0 BC       | FF FE 3C 04       | Ll
н                                  | CYRILLIC SMALL LETTER EN                                                                                     | `n=`       | &amp;x43D;    | x43D   | 1085   | D0 BD       | FF FE 3D 04       | Ll
о                                  | CYRILLIC SMALL LETTER O                                                                                      | `o=`       | &amp;x43E;    | x43E   | 1086   | D0 BE       | FF FE 3E 04       | Ll
п                                  | CYRILLIC SMALL LETTER PE                                                                                     | `p=`       | &amp;x43F;    | x43F   | 1087   | D0 BF       | FF FE 3F 04       | Ll
р                                  | CYRILLIC SMALL LETTER ER                                                                                     | `r=`       | &amp;x440;    | x440   | 1088   | D1 80       | FF FE 40 04       | Ll
с                                  | CYRILLIC SMALL LETTER ES                                                                                     | `s=`       | &amp;x441;    | x441   | 1089   | D1 81       | FF FE 41 04       | Ll
т                                  | CYRILLIC SMALL LETTER TE                                                                                     | `t=`       | &amp;x442;    | x442   | 1090   | D1 82       | FF FE 42 04       | Ll
у                                  | CYRILLIC SMALL LETTER U                                                                                      | `u=`       | &amp;x443;    | x443   | 1091   | D1 83       | FF FE 43 04       | Ll
ф                                  | CYRILLIC SMALL LETTER EF                                                                                     | `f=`       | &amp;x444;    | x444   | 1092   | D1 84       | FF FE 44 04       | Ll
х                                  | CYRILLIC SMALL LETTER HA                                                                                     | `h=`       | &amp;x445;    | x445   | 1093   | D1 85       | FF FE 45 04       | Ll
ц                                  | CYRILLIC SMALL LETTER TSE                                                                                    | `c=`       | &amp;x446;    | x446   | 1094   | D1 86       | FF FE 46 04       | Ll
ч                                  | CYRILLIC SMALL LETTER CHE                                                                                    | `c%`       | &amp;x447;    | x447   | 1095   | D1 87       | FF FE 47 04       | Ll
ш                                  | CYRILLIC SMALL LETTER SHA                                                                                    | `s%`       | &amp;x448;    | x448   | 1096   | D1 88       | FF FE 48 04       | Ll
щ                                  | CYRILLIC SMALL LETTER SHCHA                                                                                  | `sc`       | &amp;x449;    | x449   | 1097   | D1 89       | FF FE 49 04       | Ll
ъ                                  | CYRILLIC SMALL LETTER HARD SIGN                                                                              | `='`       | &amp;x44A;    | x44A   | 1098   | D1 8A       | FF FE 4A 04       | Ll
ы                                  | CYRILLIC SMALL LETTER YERU                                                                                   | `y=`       | &amp;x44B;    | x44B   | 1099   | D1 8B       | FF FE 4B 04       | Ll
ь                                  | CYRILLIC SMALL LETTER SOFT SIGN                                                                              | `%'`       | &amp;x44C;    | x44C   | 1100   | D1 8C       | FF FE 4C 04       | Ll
э                                  | CYRILLIC SMALL LETTER E                                                                                      | `je`       | &amp;x44D;    | x44D   | 1101   | D1 8D       | FF FE 4D 04       | Ll
ю                                  | CYRILLIC SMALL LETTER YU                                                                                     | `ju`       | &amp;x44E;    | x44E   | 1102   | D1 8E       | FF FE 4E 04       | Ll
я                                  | CYRILLIC SMALL LETTER YA                                                                                     | `ja`       | &amp;x44F;    | x44F   | 1103   | D1 8F       | FF FE 4F 04       | Ll
<a id="punctuation">*Section*</a>  | [**General Punctuation**](https://en.wikipedia.org/wiki/General_Punctuation)                                 |            |               |        |        |             |                   |
‒                                  | FIGURE DASH                                                                                                  |            | &amp;x2012;   | x2012  | 8210   | E2 80 92    | FF FE 12 20       | Pd
–                                  | EN DASH                                                                                                      | `-N`       | &amp;ndash;   | x2013  | 8211   | E2 80 93    | FF FE 13 20       | Pd
—                                  | EM DASH                                                                                                      | `-M`       | &amp;mdash;   | x2014  | 8212   | E2 80 94    | FF FE 14 20       | Pd
―                                  | HORIZONTAL BAR                                                                                               | `-3`       | &amp;x2015;   | x2015  | 8213   | E2 80 95    | FF FE 15 20       | Pd
‘                                  | LEFT SINGLE QUOTATION MARK                                                                                   | `'6`       | &amp;lsquo;   | x2018  | 8216   | E2 80 98    | FF FE 18 20       | Pi
’                                  | RIGHT SINGLE QUOTATION MARK                                                                                  | `'9`       | &amp;rsquo;   | x2019  | 8217   | E2 80 99    | FF FE 19 20       | Pf
‚                                  | SINGLE LOW-9 QUOTATION MARK                                                                                  | `.9`       | &amp;sbquo;   | x201A  | 8218   | E2 80 9A    | FF FE 1A 20       | Ps
‛                                  | SINGLE HIGH-REVERSED-9 QUOTATION MARK                                                                        | `9'`       | &amp;x201B;   | x201B  | 8219   | E2 80 9B    | FF FE 1B 20       | Pi
“                                  | LEFT DOUBLE QUOTATION MARK                                                                                   | `"6`       | &amp;ldquo;   | x201C  | 8220   | E2 80 9C    | FF FE 1C 20       | Pi
”                                  | RIGHT DOUBLE QUOTATION MARK                                                                                  | `"9`       | &amp;rdquo;   | x201D  | 8221   | E2 80 9D    | FF FE 1D 20       | Pf
„                                  | DOUBLE LOW-9 QUOTATION MARK                                                                                  | `:9`       | &amp;bdquo;   | x201E  | 8222   | E2 80 9E    | FF FE 1E 20       | Ps
‟                                  | DOUBLE HIGH-REVERSED-9 QUOTATION MARK                                                                        | `9"`       | &amp;x201F;   | x201F  | 8223   | E2 80 9F    | FF FE 1F 20       | Pi
…                                  | HORIZONTAL ELLIPSIS                                                                                          | `,.`       | &amp;hellip;  | x2026  | 8230   | E2 80 A6    | FF FE 26 20       | Po
‽                                  | INTERROBANG                                                                                                  |            | &amp;x203D;   | x203D  | 8253   | E2 80 BD    | FF FE 3D 20       | Po
′                                  | PRIME                                                                                                        | `1'`       | &amp;prime;   | x2032  | 8242   | E2 80 B2    | FF FE 32 20       | Po
″                                  | DOUBLE PRIME                                                                                                 | `2'`       | &amp;Prime;   | x2033  | 8243   | E2 80 B3    | FF FE 33 20       | Po
‴                                  | TRIPLE PRIME                                                                                                 | `3'`       | &amp;x2034;   | x2034  | 8244   | E2 80 B4    | FF FE 34 20       | Po
₩                                  | WON SIGN                                                                                                     | `W=`       | &amp;x20A9;   | x20A9  | 8361   | E2 82 A9    | FF FE A9 20       | Sc
€                                  | EURO SIGN                                                                                                    | `Eu`       | &amp;euro;    | x20AC  | 8364   | E2 82 AC    | FF FE AC 20       | Sc
₽                                  | ROUBLE SIGN                                                                                                  | `=R`, `=P` | &amp;x20BD;   | x20BD  | 8381   | E2 82 BD    | FF FE BD 20       | Sc
℅                                  | CARE OF                                                                                                      | `co`       | &amp;x2105;   | x2105  | 8453   | E2 84 85    | FF FE 05 21       | So
™                                  | TRADE MARK SIGN                                                                                              | `TM`       | &amp;trade;   | x2122  | 8482   | E2 84 A2    | FF FE 22 21       | So
<a id="subscripts">*Section*</a>   | [**Superscripts and Subscripts**](https://en.wikipedia.org/wiki/Superscripts_and_Subscripts_(Unicode_block)) |            |               |        |        |             |                   |
ⁱ                                  | SUPERSCRIPT LATIN SMALL LETTER I                                                                             |            | &amp;x2071;   | x2071  | 8305   | E2 81 B1    | FF FE 71 20       | Lm
⁰                                  | SUPERSCRIPT ZERO                                                                                             | `0S`       | &amp;x2070;   | x2070  | 8304   | E2 81 B0    | FF FE 70 20       | No
¹                                  | SUPERSCRIPT ONE                                                                                              | `1S`       | &amp;sup1;    | xB9    | 185    | C2 B9       | FF FE B9 00       | No
²                                  | SUPERSCRIPT TWO                                                                                              | `2S`       | &amp;sup2;    | xB2    | 178    | C2 B2       | FF FE B2 00       | No
³                                  | SUPERSCRIPT THREE                                                                                            | `3S`       | &amp;sup3;    | xB3    | 179    | C2 B3       | FF FE B3 00       | No
⁴                                  | SUPERSCRIPT FOUR                                                                                             | `4S`       | &amp;x2074;   | x2074  | 8308   | E2 81 B4    | FF FE 74 20       | No
⁵                                  | SUPERSCRIPT FIVE                                                                                             | `5S`       | &amp;x2075;   | x2075  | 8309   | E2 81 B5    | FF FE 75 20       | No
⁶                                  | SUPERSCRIPT SIX                                                                                              | `6S`       | &amp;x2076;   | x2076  | 8310   | E2 81 B6    | FF FE 76 20       | No
⁷                                  | SUPERSCRIPT SEVEN                                                                                            | `7S`       | &amp;x2077;   | x2077  | 8311   | E2 81 B7    | FF FE 77 20       | No
⁸                                  | SUPERSCRIPT EIGHT                                                                                            | `8S`       | &amp;x2078;   | x2078  | 8312   | E2 81 B8    | FF FE 78 20       | No
⁹                                  | SUPERSCRIPT NINE                                                                                             | `9S`       | &amp;x2079;   | x2079  | 8313   | E2 81 B9    | FF FE 79 20       | No
⁺                                  | SUPERSCRIPT PLUS SIGN                                                                                        | `+S`       | &amp;x207A;   | x207A  | 8314   | E2 81 BA    | FF FE 7A 20       | Sm
⁻                                  | SUPERSCRIPT MINUS                                                                                            | `-S`       | &amp;x207B;   | x207B  | 8315   | E2 81 BB    | FF FE 7B 20       | Sm
⁼                                  | SUPERSCRIPT EQUALS SIGN                                                                                      | `=S`       | &amp;x207C;   | x207C  | 8316   | E2 81 BC    | FF FE 7C 20       | Sm
⁽                                  | SUPERSCRIPT LEFT PARENTHESIS                                                                                 | `(S`       | &amp;x207D;   | x207D  | 8317   | E2 81 BD    | FF FE 7D 20       | Ps
⁾                                  | SUPERSCRIPT RIGHT PARENTHESIS                                                                                | `)S`       | &amp;x207E;   | x207E  | 8318   | E2 81 BE    | FF FE 7E 20       | Pe
ⁿ                                  | SUPERSCRIPT LATIN SMALL LETTER N                                                                             | `nS`       | &amp;x207F;   | x207F  | 8319   | E2 81 BF    | FF FE 7F 20       | Lm
₀                                  | SUBSCRIPT ZERO                                                                                               | `0s`       | &amp;x2080;   | x2080  | 8320   | E2 82 80    | FF FE 80 20       | No
₁                                  | SUBSCRIPT ONE                                                                                                | `1s`       | &amp;x2081;   | x2081  | 8321   | E2 82 81    | FF FE 81 20       | No
₂                                  | SUBSCRIPT TWO                                                                                                | `2s`       | &amp;x2082;   | x2082  | 8322   | E2 82 82    | FF FE 82 20       | No
₃                                  | SUBSCRIPT THREE                                                                                              | `3s`       | &amp;x2083;   | x2083  | 8323   | E2 82 83    | FF FE 83 20       | No
₄                                  | SUBSCRIPT FOUR                                                                                               | `4s`       | &amp;x2084;   | x2084  | 8324   | E2 82 84    | FF FE 84 20       | No
₅                                  | SUBSCRIPT FIVE                                                                                               | `5s`       | &amp;x2085;   | x2085  | 8325   | E2 82 85    | FF FE 85 20       | No
₆                                  | SUBSCRIPT SIX                                                                                                | `6s`       | &amp;x2086;   | x2086  | 8326   | E2 82 86    | FF FE 86 20       | No
₇                                  | SUBSCRIPT SEVEN                                                                                              | `7s`       | &amp;x2087;   | x2087  | 8327   | E2 82 87    | FF FE 87 20       | No
₈                                  | SUBSCRIPT EIGHT                                                                                              | `8s`       | &amp;x2088;   | x2088  | 8328   | E2 82 88    | FF FE 88 20       | No
₉                                  | SUBSCRIPT NINE                                                                                               | `9s`       | &amp;x2089;   | x2089  | 8329   | E2 82 89    | FF FE 89 20       | No
₊                                  | SUBSCRIPT PLUS SIGN                                                                                          | `+s`       | &amp;x208A;   | x208A  | 8330   | E2 82 8A    | FF FE 8A 20       | Sm
₋                                  | SUBSCRIPT MINUS                                                                                              | `-s`       | &amp;x208B;   | x208B  | 8331   | E2 82 8B    | FF FE 8B 20       | Sm
₌                                  | SUBSCRIPT EQUALS SIGN                                                                                        | `=s`       | &amp;x208C;   | x208C  | 8332   | E2 82 8C    | FF FE 8C 20       | Sm
₍                                  | SUBSCRIPT LEFT PARENTHESIS                                                                                   | `(s`       | &amp;x208D;   | x208D  | 8333   | E2 82 8D    | FF FE 8D 20       | Ps
₎                                  | SUBSCRIPT RIGHT PARENTHESIS                                                                                  | `)s`       | &amp;x208E;   | x208E  | 8334   | E2 82 8E    | FF FE 8E 20       | Pe
₏                                  | *unknown*                                                                                                    |            | &amp;x208F;   | x208F  | 8335   | E2 82 8F    | FF FE 8F 20       | Cn
ₐ                                  | LATIN SUBSCRIPT SMALL LETTER A                                                                               |            | &amp;x2090;   | x2090  | 8336   | E2 82 90    | FF FE 90 20       | Lm
ₑ                                  | LATIN SUBSCRIPT SMALL LETTER E                                                                               |            | &amp;x2091;   | x2091  | 8337   | E2 82 91    | FF FE 91 20       | Lm
ₒ                                  | LATIN SUBSCRIPT SMALL LETTER O                                                                               |            | &amp;x2092;   | x2092  | 8338   | E2 82 92    | FF FE 92 20       | Lm
ₓ                                  | LATIN SUBSCRIPT SMALL LETTER X                                                                               |            | &amp;x2093;   | x2093  | 8339   | E2 82 93    | FF FE 93 20       | Lm
ₔ                                  | LATIN SUBSCRIPT SMALL LETTER SCHWA                                                                           |            | &amp;x2094;   | x2094  | 8340   | E2 82 94    | FF FE 94 20       | Lm
ₕ                                  | LATIN SUBSCRIPT SMALL LETTER H                                                                               |            | &amp;x2095;   | x2095  | 8341   | E2 82 95    | FF FE 95 20       | Lm
ₖ                                  | LATIN SUBSCRIPT SMALL LETTER K                                                                               |            | &amp;x2096;   | x2096  | 8342   | E2 82 96    | FF FE 96 20       | Lm
ₗ                                  | LATIN SUBSCRIPT SMALL LETTER L                                                                               |            | &amp;x2097;   | x2097  | 8343   | E2 82 97    | FF FE 97 20       | Lm
ₘ                                  | LATIN SUBSCRIPT SMALL LETTER M                                                                               |            | &amp;x2098;   | x2098  | 8344   | E2 82 98    | FF FE 98 20       | Lm
ₙ                                  | LATIN SUBSCRIPT SMALL LETTER N                                                                               |            | &amp;x2099;   | x2099  | 8345   | E2 82 99    | FF FE 99 20       | Lm
ₚ                                  | LATIN SUBSCRIPT SMALL LETTER P                                                                               |            | &amp;x209A;   | x209A  | 8346   | E2 82 9A    | FF FE 9A 20       | Lm
ₛ                                  | LATIN SUBSCRIPT SMALL LETTER S                                                                               |            | &amp;x209B;   | x209B  | 8347   | E2 82 9B    | FF FE 9B 20       | Lm
ₜ                                  | LATIN SUBSCRIPT SMALL LETTER T                                                                               |            | &amp;x209C;   | x209C  | 8348   | E2 82 9C    | FF FE 9C 20       | Lm
<a id="math">*Section*</a>         | [**Mathematical Operators**](https://en.wikipedia.org/wiki/Mathematical_Operators)                           |            |               |        |        |             |                   |
±                                  | PLUS-MINUS SIGN                                                                                              | `+-`       | &amp;plusmn;  | xB1    | 177    | C2 B1       | FF FE B1 00       | Sm
ℕ                                  | DOUBLE-STRUCK CAPITAL N                                                                                      |            | &amp;x2115;   | x2115  | 8469   | E2 84 95    | FF FE 15 21       | Lu
ℚ                                  | DOUBLE-STRUCK CAPITAL Q                                                                                      |            | &amp;x211A;   | x211A  | 8474   | E2 84 9A    | FF FE 1A 21       | Lu
ℝ                                  | DOUBLE-STRUCK CAPITAL R                                                                                      |            | &amp;x211D;   | x211D  | 8477   | E2 84 9D    | FF FE 1D 21       | Lu
ℤ                                  | DOUBLE-STRUCK CAPITAL Z                                                                                      |            | &amp;x2124;   | x2124  | 8484   | E2 84 A4    | FF FE 24 21       | Lu
ℵ                                  | ALEF SYMBOL                                                                                                  |            | &amp;alefsym; | x2135  | 8501   | E2 84 B5    | FF FE 35 21       | Lo
∀                                  | FOR ALL                                                                                                      | `FA`       | &amp;forall;  | x2200  | 8704   | E2 88 80    | FF FE 00 22       | Sm
∂                                  | PARTIAL DIFFERENTIAL                                                                                         | `dP`       | &amp;part;    | x2202  | 8706   | E2 88 82    | FF FE 02 22       | Sm
∃                                  | THERE EXISTS                                                                                                 | `TE`       | &amp;exist;   | x2203  | 8707   | E2 88 83    | FF FE 03 22       | Sm
Ǝ                                  | LATIN CAPITAL LETTER REVERSED E                                                                              |            | &amp;x18E;    | x18E   | 398    | C6 8E       | FF FE 8E 01       | Lu
∄                                  | THERE DOES NOT EXIST                                                                                         |            | &amp;x2204;   | x2204  | 8708   | E2 88 84    | FF FE 04 22       | Sm
∅                                  | EMPTY SET                                                                                                    | `/0`       | &amp;empty;   | x2205  | 8709   | E2 88 85    | FF FE 05 22       | Sm
∆                                  | INCREMENT                                                                                                    | `DE`       | &amp;x2206;   | x2206  | 8710   | E2 88 86    | FF FE 06 22       | Sm
∇                                  | NABLA                                                                                                        | `NB`       | &amp;nabla;   | x2207  | 8711   | E2 88 87    | FF FE 07 22       | Sm
∈                                  | ELEMENT OF                                                                                                   | `(-`       | &amp;isin;    | x2208  | 8712   | E2 88 88    | FF FE 08 22       | Sm
∉                                  | NOT AN ELEMENT OF                                                                                            |            | &amp;notin;   | x2209  | 8713   | E2 88 89    | FF FE 09 22       | Sm
∊                                  | SMALL ELEMENT OF                                                                                             |            | &amp;x220A;   | x220A  | 8714   | E2 88 8A    | FF FE 0A 22       | Sm
∋                                  | CONTAINS AS MEMBER                                                                                           | `-)`       | &amp;ni;      | x220B  | 8715   | E2 88 8B    | FF FE 0B 22       | Sm
∌                                  | DOES NOT CONTAIN AS MEMBER                                                                                   |            | &amp;x220C;   | x220C  | 8716   | E2 88 8C    | FF FE 0C 22       | Sm
∍                                  | SMALL CONTAINS AS MEMBER                                                                                     |            | &amp;x220D;   | x220D  | 8717   | E2 88 8D    | FF FE 0D 22       | Sm
∎                                  | END OF PROOF                                                                                                 |            | &amp;x220E;   | x220E  | 8718   | E2 88 8E    | FF FE 0E 22       | Sm
∏                                  | N-ARY PRODUCT                                                                                                | `*P`       | &amp;prod;    | x220F  | 8719   | E2 88 8F    | FF FE 0F 22       | Sm
∐                                  | N-ARY COPRODUCT                                                                                              |            | &amp;x2210;   | x2210  | 8720   | E2 88 90    | FF FE 10 22       | Sm
∑                                  | N-ARY SUMMATION                                                                                              | `+Z`       | &amp;sum;     | x2211  | 8721   | E2 88 91    | FF FE 11 22       | Sm
∕                                  | DIVISION SLASH                                                                                               |            | &amp;x2215;   | x2215  | 8725   | E2 88 95    | FF FE 15 22       | Sm
∖                                  | SET MINUS                                                                                                    |            | &amp;x2216;   | x2216  | 8726   | E2 88 96    | FF FE 16 22       | Sm
∗                                  | ASTERISK OPERATOR                                                                                            | `*-`       | &amp;lowast;  | x2217  | 8727   | E2 88 97    | FF FE 17 22       | Sm
∘                                  | RING OPERATOR                                                                                                | `Ob`       | &amp;x2218;   | x2218  | 8728   | E2 88 98    | FF FE 18 22       | Sm
∙                                  | BULLET OPERATOR                                                                                              | `Sb`       | &amp;x2219;   | x2219  | 8729   | E2 88 99    | FF FE 19 22       | Sm
√                                  | SQUARE ROOT                                                                                                  | `RT`       | &amp;radic;   | x221A  | 8730   | E2 88 9A    | FF FE 1A 22       | Sm
∛                                  | CUBE ROOT                                                                                                    |            | &amp;x221B;   | x221B  | 8731   | E2 88 9B    | FF FE 1B 22       | Sm
∜                                  | FOURTH ROOT                                                                                                  |            | &amp;x221C;   | x221C  | 8732   | E2 88 9C    | FF FE 1C 22       | Sm
∝                                  | PROPORTIONAL TO                                                                                              | `0(`       | &amp;prop;    | x221D  | 8733   | E2 88 9D    | FF FE 1D 22       | Sm
∞                                  | INFINITY                                                                                                     | `00`       | &amp;infin;   | x221E  | 8734   | E2 88 9E    | FF FE 1E 22       | Sm
∟                                  | RIGHT ANGLE                                                                                                  | `-L`       | &amp;x221F;   | x221F  | 8735   | E2 88 9F    | FF FE 1F 22       | Sm
∠                                  | ANGLE                                                                                                        | `-V`       | &amp;ang;     | x2220  | 8736   | E2 88 A0    | FF FE 20 22       | Sm
∡                                  | MEASURED ANGLE                                                                                               |            | &amp;x2221;   | x2221  | 8737   | E2 88 A1    | FF FE 21 22       | Sm
∢                                  | SPHERICAL ANGLE                                                                                              |            | &amp;x2222;   | x2222  | 8738   | E2 88 A2    | FF FE 22 22       | Sm
∣                                  | DIVIDES                                                                                                      |            | &amp;x2223;   | x2223  | 8739   | E2 88 A3    | FF FE 23 22       | Sm
∤                                  | DOES NOT DIVIDE                                                                                              |            | &amp;x2224;   | x2224  | 8740   | E2 88 A4    | FF FE 24 22       | Sm
∥                                  | PARALLEL TO                                                                                                  | `PP`       | &amp;x2225;   | x2225  | 8741   | E2 88 A5    | FF FE 25 22       | Sm
∦                                  | NOT PARALLEL TO                                                                                              |            | &amp;x2226;   | x2226  | 8742   | E2 88 A6    | FF FE 26 22       | Sm
∧                                  | LOGICAL AND                                                                                                  | `AN`       | &amp;and;     | x2227  | 8743   | E2 88 A7    | FF FE 27 22       | Sm
∨                                  | LOGICAL OR                                                                                                   | `OR`       | &amp;or;      | x2228  | 8744   | E2 88 A8    | FF FE 28 22       | Sm
∩                                  | INTERSECTION                                                                                                 | `(U`       | &amp;cap;     | x2229  | 8745   | E2 88 A9    | FF FE 29 22       | Sm
∪                                  | UNION                                                                                                        | `)U`       | &amp;cup;     | x222A  | 8746   | E2 88 AA    | FF FE 2A 22       | Sm
∫                                  | INTEGRAL                                                                                                     | `In`       | &amp;int;     | x222B  | 8747   | E2 88 AB    | FF FE 2B 22       | Sm
∬                                  | DOUBLE INTEGRAL                                                                                              | `DI`       | &amp;x222C;   | x222C  | 8748   | E2 88 AC    | FF FE 2C 22       | Sm
∭                                  | TRIPLE INTEGRAL                                                                                              |            | &amp;x222D;   | x222D  | 8749   | E2 88 AD    | FF FE 2D 22       | Sm
∮                                  | CONTOUR INTEGRAL                                                                                             | `Io`       | &amp;x222E;   | x222E  | 8750   | E2 88 AE    | FF FE 2E 22       | Sm
∯                                  | SURFACE INTEGRAL                                                                                             |            | &amp;x222F;   | x222F  | 8751   | E2 88 AF    | FF FE 2F 22       | Sm
∰                                  | VOLUME INTEGRAL                                                                                              |            | &amp;x2230;   | x2230  | 8752   | E2 88 B0    | FF FE 30 22       | Sm
∱                                  | CLOCKWISE INTEGRAL                                                                                           |            | &amp;x2231;   | x2231  | 8753   | E2 88 B1    | FF FE 31 22       | Sm
∲                                  | CLOCKWISE CONTOUR INTEGRAL                                                                                   |            | &amp;x2232;   | x2232  | 8754   | E2 88 B2    | FF FE 32 22       | Sm
∳                                  | ANTICLOCKWISE CONTOUR INTEGRAL                                                                               |            | &amp;x2233;   | x2233  | 8755   | E2 88 B3    | FF FE 33 22       | Sm
∴                                  | THEREFORE                                                                                                    | `.:`       | &amp;there4;  | x2234  | 8756   | E2 88 B4    | FF FE 34 22       | Sm
∵                                  | BECAUSE                                                                                                      | `:.`       | &amp;x2235;   | x2235  | 8757   | E2 88 B5    | FF FE 35 22       | Sm
≁                                  | NOT TILDE                                                                                                    |            | &amp;x2241;   | x2241  | 8769   | E2 89 81    | FF FE 41 22       | Sm
≂                                  | MINUS TILDE                                                                                                  |            | &amp;x2242;   | x2242  | 8770   | E2 89 82    | FF FE 42 22       | Sm
≃                                  | ASYMPTOTICALLY EQUAL TO                                                                                      | `?-`       | &amp;x2243;   | x2243  | 8771   | E2 89 83    | FF FE 43 22       | Sm
≄                                  | NOT ASYMPTOTICALLY EQUAL TO                                                                                  |            | &amp;x2244;   | x2244  | 8772   | E2 89 84    | FF FE 44 22       | Sm
≅                                  | APPROXIMATELY EQUAL TO                                                                                       | `?=`       | &amp;cong;    | x2245  | 8773   | E2 89 85    | FF FE 45 22       | Sm
≆                                  | APPROXIMATELY BUT NOT ACTUALLY EQUAL TO                                                                      |            | &amp;x2246;   | x2246  | 8774   | E2 89 86    | FF FE 46 22       | Sm
≇                                  | NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO                                                                  |            | &amp;x2247;   | x2247  | 8775   | E2 89 87    | FF FE 47 22       | Sm
≈                                  | ALMOST EQUAL TO                                                                                              | `?2`       | &amp;asymp;   | x2248  | 8776   | E2 89 88    | FF FE 48 22       | Sm
≉                                  | NOT ALMOST EQUAL TO                                                                                          |            | &amp;x2249;   | x2249  | 8777   | E2 89 89    | FF FE 49 22       | Sm
≊                                  | ALMOST EQUAL OR EQUAL TO                                                                                     |            | &amp;x224A;   | x224A  | 8778   | E2 89 8A    | FF FE 4A 22       | Sm
≋                                  | TRIPLE TILDE                                                                                                 |            | &amp;x224B;   | x224B  | 8779   | E2 89 8B    | FF FE 4B 22       | Sm
≌                                  | ALL EQUAL TO                                                                                                 | `=?`       | &amp;x224C;   | x224C  | 8780   | E2 89 8C    | FF FE 4C 22       | Sm
≍                                  | EQUIVALENT TO                                                                                                |            | &amp;x224D;   | x224D  | 8781   | E2 89 8D    | FF FE 4D 22       | Sm
≝                                  | EQUAL TO BY DEFINITION                                                                                       |            | &amp;x225D;   | x225D  | 8797   | E2 89 9D    | FF FE 5D 22       | Sm
≟                                  | QUESTIONED EQUAL TO                                                                                          |            | &amp;x225F;   | x225F  | 8799   | E2 89 9F    | FF FE 5F 22       | Sm
≠                                  | NOT EQUAL TO                                                                                                 | `!=`       | &amp;ne;      | x2260  | 8800   | E2 89 A0    | FF FE 60 22       | Sm
≡                                  | IDENTICAL TO                                                                                                 | `=3`       | &amp;equiv;   | x2261  | 8801   | E2 89 A1    | FF FE 61 22       | Sm
≢                                  | NOT IDENTICAL TO                                                                                             |            | &amp;x2262;   | x2262  | 8802   | E2 89 A2    | FF FE 62 22       | Sm
≣                                  | STRICTLY EQUIVALENT TO                                                                                       |            | &amp;x2263;   | x2263  | 8803   | E2 89 A3    | FF FE 63 22       | Sm
≤                                  | LESS-THAN OR EQUAL TO                                                                                        | `=<`       | &amp;le;      | x2264  | 8804   | E2 89 A4    | FF FE 64 22       | Sm
≥                                  | GREATER-THAN OR EQUAL TO                                                                                     | `>=`       | &amp;ge;      | x2265  | 8805   | E2 89 A5    | FF FE 65 22       | Sm
≦                                  | LESS-THAN OVER EQUAL TO                                                                                      |            | &amp;x2266;   | x2266  | 8806   | E2 89 A6    | FF FE 66 22       | Sm
≧                                  | GREATER-THAN OVER EQUAL TO                                                                                   |            | &amp;x2267;   | x2267  | 8807   | E2 89 A7    | FF FE 67 22       | Sm
≨                                  | LESS-THAN BUT NOT EQUAL TO                                                                                   |            | &amp;x2268;   | x2268  | 8808   | E2 89 A8    | FF FE 68 22       | Sm
≩                                  | GREATER-THAN BUT NOT EQUAL TO                                                                                |            | &amp;x2269;   | x2269  | 8809   | E2 89 A9    | FF FE 69 22       | Sm
≪                                  | MUCH LESS-THAN                                                                                               | `<*`       | &amp;x226A;   | x226A  | 8810   | E2 89 AA    | FF FE 6A 22       | Sm
≫                                  | MUCH GREATER-THAN                                                                                            | `*>`       | &amp;x226B;   | x226B  | 8811   | E2 89 AB    | FF FE 6B 22       | Sm
≬                                  | BETWEEN                                                                                                      |            | &amp;x226C;   | x226C  | 8812   | E2 89 AC    | FF FE 6C 22       | Sm
≭                                  | NOT EQUIVALENT TO                                                                                            |            | &amp;x226D;   | x226D  | 8813   | E2 89 AD    | FF FE 6D 22       | Sm
≮                                  | NOT LESS-THAN                                                                                                | `!<`       | &amp;x226E;   | x226E  | 8814   | E2 89 AE    | FF FE 6E 22       | Sm
≯                                  | NOT GREATER-THAN                                                                                             | `!>`       | &amp;x226F;   | x226F  | 8815   | E2 89 AF    | FF FE 6F 22       | Sm
≰                                  | NEITHER LESS-THAN NOR EQUAL TO                                                                               |            | &amp;x2270;   | x2270  | 8816   | E2 89 B0    | FF FE 70 22       | Sm
≱                                  | NEITHER GREATER-THAN NOR EQUAL TO                                                                            |            | &amp;x2271;   | x2271  | 8817   | E2 89 B1    | FF FE 71 22       | Sm
≲                                  | LESS-THAN OR EQUIVALENT TO                                                                                   |            | &amp;x2272;   | x2272  | 8818   | E2 89 B2    | FF FE 72 22       | Sm
≳                                  | GREATER-THAN OR EQUIVALENT TO                                                                                |            | &amp;x2273;   | x2273  | 8819   | E2 89 B3    | FF FE 73 22       | Sm
≴                                  | NEITHER LESS-THAN NOR EQUIVALENT TO                                                                          |            | &amp;x2274;   | x2274  | 8820   | E2 89 B4    | FF FE 74 22       | Sm
≵                                  | NEITHER GREATER-THAN NOR EQUIVALENT TO                                                                       |            | &amp;x2275;   | x2275  | 8821   | E2 89 B5    | FF FE 75 22       | Sm
≶                                  | LESS-THAN OR GREATER-THAN                                                                                    |            | &amp;x2276;   | x2276  | 8822   | E2 89 B6    | FF FE 76 22       | Sm
≷                                  | GREATER-THAN OR LESS-THAN                                                                                    |            | &amp;x2277;   | x2277  | 8823   | E2 89 B7    | FF FE 77 22       | Sm
≸                                  | NEITHER LESS-THAN NOR GREATER-THAN                                                                           |            | &amp;x2278;   | x2278  | 8824   | E2 89 B8    | FF FE 78 22       | Sm
≹                                  | NEITHER GREATER-THAN NOR LESS-THAN                                                                           |            | &amp;x2279;   | x2279  | 8825   | E2 89 B9    | FF FE 79 22       | Sm
⊂                                  | SUBSET OF                                                                                                    | `(C`       | &amp;sub;     | x2282  | 8834   | E2 8A 82    | FF FE 82 22       | Sm
⊃                                  | SUPERSET OF                                                                                                  | `)C`       | &amp;sup;     | x2283  | 8835   | E2 8A 83    | FF FE 83 22       | Sm
⊄                                  | NOT A SUBSET OF                                                                                              |            | &amp;nsub;    | x2284  | 8836   | E2 8A 84    | FF FE 84 22       | Sm
⊅                                  | NOT A SUPERSET OF                                                                                            |            | &amp;x2285;   | x2285  | 8837   | E2 8A 85    | FF FE 85 22       | Sm
⊆                                  | SUBSET OF OR EQUAL TO                                                                                        | `(_`       | &amp;sube;    | x2286  | 8838   | E2 8A 86    | FF FE 86 22       | Sm
⊇                                  | SUPERSET OF OR EQUAL TO                                                                                      | `)_`       | &amp;supe;    | x2287  | 8839   | E2 8A 87    | FF FE 87 22       | Sm
⊈                                  | NEITHER A SUBSET OF NOR EQUAL TO                                                                             |            | &amp;x2288;   | x2288  | 8840   | E2 8A 88    | FF FE 88 22       | Sm
⊉                                  | NEITHER A SUPERSET OF NOR EQUAL TO                                                                           |            | &amp;x2289;   | x2289  | 8841   | E2 8A 89    | FF FE 89 22       | Sm
⊊                                  | SUBSET OF WITH NOT EQUAL TO                                                                                  |            | &amp;x228A;   | x228A  | 8842   | E2 8A 8A    | FF FE 8A 22       | Sm
⊋                                  | SUPERSET OF WITH NOT EQUAL TO                                                                                |            | &amp;x228B;   | x228B  | 8843   | E2 8A 8B    | FF FE 8B 22       | Sm
⊌                                  | MULTISET                                                                                                     |            | &amp;x228C;   | x228C  | 8844   | E2 8A 8C    | FF FE 8C 22       | Sm
⊍                                  | MULTISET MULTIPLICATION                                                                                      |            | &amp;x228D;   | x228D  | 8845   | E2 8A 8D    | FF FE 8D 22       | Sm
⊎                                  | MULTISET UNION                                                                                               |            | &amp;x228E;   | x228E  | 8846   | E2 8A 8E    | FF FE 8E 22       | Sm
⊏                                  | SQUARE IMAGE OF                                                                                              |            | &amp;x228F;   | x228F  | 8847   | E2 8A 8F    | FF FE 8F 22       | Sm
⊐                                  | SQUARE ORIGINAL OF                                                                                           |            | &amp;x2290;   | x2290  | 8848   | E2 8A 90    | FF FE 90 22       | Sm
⊑                                  | SQUARE IMAGE OF OR EQUAL TO                                                                                  |            | &amp;x2291;   | x2291  | 8849   | E2 8A 91    | FF FE 91 22       | Sm
⊒                                  | SQUARE ORIGINAL OF OR EQUAL TO                                                                               |            | &amp;x2292;   | x2292  | 8850   | E2 8A 92    | FF FE 92 22       | Sm
⊓                                  | SQUARE CAP                                                                                                   |            | &amp;x2293;   | x2293  | 8851   | E2 8A 93    | FF FE 93 22       | Sm
⊔                                  | SQUARE CUP                                                                                                   |            | &amp;x2294;   | x2294  | 8852   | E2 8A 94    | FF FE 94 22       | Sm
⊕                                  | CIRCLED PLUS                                                                                                 |            | &amp;oplus;   | x2295  | 8853   | E2 8A 95    | FF FE 95 22       | Sm
⊖                                  | CIRCLED MINUS                                                                                                |            | &amp;x2296;   | x2296  | 8854   | E2 8A 96    | FF FE 96 22       | Sm
⊗                                  | CIRCLED TIMES                                                                                                |            | &amp;otimes;  | x2297  | 8855   | E2 8A 97    | FF FE 97 22       | Sm
⊘                                  | CIRCLED DIVISION SLASH                                                                                       |            | &amp;x2298;   | x2298  | 8856   | E2 8A 98    | FF FE 98 22       | Sm
⊙                                  | CIRCLED DOT OPERATOR                                                                                         | `0.`       | &amp;x2299;   | x2299  | 8857   | E2 8A 99    | FF FE 99 22       | Sm
⊚                                  | CIRCLED RING OPERATOR                                                                                        | `02`       | &amp;x229A;   | x229A  | 8858   | E2 8A 9A    | FF FE 9A 22       | Sm
⊛                                  | CIRCLED ASTERISK OPERATOR                                                                                    |            | &amp;x229B;   | x229B  | 8859   | E2 8A 9B    | FF FE 9B 22       | Sm
⊜                                  | CIRCLED EQUALS                                                                                               |            | &amp;x229C;   | x229C  | 8860   | E2 8A 9C    | FF FE 9C 22       | Sm
⊝                                  | CIRCLED DASH                                                                                                 |            | &amp;x229D;   | x229D  | 8861   | E2 8A 9D    | FF FE 9D 22       | Sm
⊞                                  | SQUARED PLUS                                                                                                 |            | &amp;x229E;   | x229E  | 8862   | E2 8A 9E    | FF FE 9E 22       | Sm
⊟                                  | SQUARED MINUS                                                                                                |            | &amp;x229F;   | x229F  | 8863   | E2 8A 9F    | FF FE 9F 22       | Sm
⊠                                  | SQUARED TIMES                                                                                                |            | &amp;x22A0;   | x22A0  | 8864   | E2 8A A0    | FF FE A0 22       | Sm
⊡                                  | SQUARED DOT OPERATOR                                                                                         |            | &amp;x22A1;   | x22A1  | 8865   | E2 8A A1    | FF FE A1 22       | Sm
⊢                                  | RIGHT TACK                                                                                                   |            | &amp;x22A2;   | x22A2  | 8866   | E2 8A A2    | FF FE A2 22       | Sm
⊣                                  | LEFT TACK                                                                                                    |            | &amp;x22A3;   | x22A3  | 8867   | E2 8A A3    | FF FE A3 22       | Sm
⊤                                  | DOWN TACK                                                                                                    |            | &amp;x22A4;   | x22A4  | 8868   | E2 8A A4    | FF FE A4 22       | Sm
⊥                                  | UP TACK                                                                                                      | `-T`       | &amp;perp;    | x22A5  | 8869   | E2 8A A5    | FF FE A5 22       | Sm
⊦                                  | ASSERTION                                                                                                    |            | &amp;x22A6;   | x22A6  | 8870   | E2 8A A6    | FF FE A6 22       | Sm
⊧                                  | MODELS                                                                                                       |            | &amp;x22A7;   | x22A7  | 8871   | E2 8A A7    | FF FE A7 22       | Sm
⊨                                  | TRUE                                                                                                         |            | &amp;x22A8;   | x22A8  | 8872   | E2 8A A8    | FF FE A8 22       | Sm
⊩                                  | FORCES                                                                                                       |            | &amp;x22A9;   | x22A9  | 8873   | E2 8A A9    | FF FE A9 22       | Sm
⊪                                  | TRIPLE VERTICAL BAR RIGHT TURNSTILE                                                                          |            | &amp;x22AA;   | x22AA  | 8874   | E2 8A AA    | FF FE AA 22       | Sm
⊫                                  | DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE                                                                   |            | &amp;x22AB;   | x22AB  | 8875   | E2 8A AB    | FF FE AB 22       | Sm
⊬                                  | DOES NOT PROVE                                                                                               |            | &amp;x22AC;   | x22AC  | 8876   | E2 8A AC    | FF FE AC 22       | Sm
⊭                                  | NOT TRUE                                                                                                     |            | &amp;x22AD;   | x22AD  | 8877   | E2 8A AD    | FF FE AD 22       | Sm
⊮                                  | DOES NOT FORCE                                                                                               |            | &amp;x22AE;   | x22AE  | 8878   | E2 8A AE    | FF FE AE 22       | Sm
⊯                                  | NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE                                                           |            | &amp;x22AF;   | x22AF  | 8879   | E2 8A AF    | FF FE AF 22       | Sm
⊲                                  | NORMAL SUBGROUP OF                                                                                           |            | &amp;x22B2;   | x22B2  | 8882   | E2 8A B2    | FF FE B2 22       | Sm
⊳                                  | CONTAINS AS NORMAL SUBGROUP                                                                                  |            | &amp;x22B3;   | x22B3  | 8883   | E2 8A B3    | FF FE B3 22       | Sm
⊴                                  | NORMAL SUBGROUP OF OR EQUAL TO                                                                               |            | &amp;x22B4;   | x22B4  | 8884   | E2 8A B4    | FF FE B4 22       | Sm
⊵                                  | CONTAINS AS NORMAL SUBGROUP OR EQUAL TO                                                                      |            | &amp;x22B5;   | x22B5  | 8885   | E2 8A B5    | FF FE B5 22       | Sm
⊻                                  | XOR                                                                                                          |            | &amp;x22BB;   | x22BB  | 8891   | E2 8A BB    | FF FE BB 22       | Sm
⊼                                  | NAND                                                                                                         |            | &amp;x22BC;   | x22BC  | 8892   | E2 8A BC    | FF FE BC 22       | Sm
⊽                                  | NOR                                                                                                          |            | &amp;x22BD;   | x22BD  | 8893   | E2 8A BD    | FF FE BD 22       | Sm
⊾                                  | RIGHT ANGLE WITH ARC                                                                                         |            | &amp;x22BE;   | x22BE  | 8894   | E2 8A BE    | FF FE BE 22       | Sm
⊿                                  | RIGHT TRIANGLE                                                                                               |            | &amp;x22BF;   | x22BF  | 8895   | E2 8A BF    | FF FE BF 22       | Sm
⋀                                  | N-ARY LOGICAL AND                                                                                            |            | &amp;x22C0;   | x22C0  | 8896   | E2 8B 80    | FF FE C0 22       | Sm
⋁                                  | N-ARY LOGICAL OR                                                                                             |            | &amp;x22C1;   | x22C1  | 8897   | E2 8B 81    | FF FE C1 22       | Sm
⋂                                  | N-ARY INTERSECTION                                                                                           |            | &amp;x22C2;   | x22C2  | 8898   | E2 8B 82    | FF FE C2 22       | Sm
⋃                                  | N-ARY UNION                                                                                                  |            | &amp;x22C3;   | x22C3  | 8899   | E2 8B 83    | FF FE C3 22       | Sm
⋄                                  | DIAMOND OPERATOR                                                                                             |            | &amp;x22C4;   | x22C4  | 8900   | E2 8B 84    | FF FE C4 22       | Sm
⋅                                  | DOT OPERATOR                                                                                                 | `.P`       | &amp;sdot;    | x22C5  | 8901   | E2 8B 85    | FF FE C5 22       | Sm
⋆                                  | STAR OPERATOR                                                                                                |            | &amp;x22C6;   | x22C6  | 8902   | E2 8B 86    | FF FE C6 22       | Sm
⋇                                  | DIVISION TIMES                                                                                               |            | &amp;x22C7;   | x22C7  | 8903   | E2 8B 87    | FF FE C7 22       | Sm
⋈                                  | BOWTIE                                                                                                       |            | &amp;x22C8;   | x22C8  | 8904   | E2 8B 88    | FF FE C8 22       | Sm
⋉                                  | LEFT NORMAL FACTOR SEMIDIRECT PRODUCT                                                                        |            | &amp;x22C9;   | x22C9  | 8905   | E2 8B 89    | FF FE C9 22       | Sm
⋊                                  | RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT                                                                       |            | &amp;x22CA;   | x22CA  | 8906   | E2 8B 8A    | FF FE CA 22       | Sm
⋪                                  | NOT NORMAL SUBGROUP OF                                                                                       |            | &amp;x22EA;   | x22EA  | 8938   | E2 8B AA    | FF FE EA 22       | Sm
⋫                                  | DOES NOT CONTAIN AS NORMAL SUBGROUP                                                                          |            | &amp;x22EB;   | x22EB  | 8939   | E2 8B AB    | FF FE EB 22       | Sm
⋬                                  | NOT NORMAL SUBGROUP OF OR EQUAL TO                                                                           |            | &amp;x22EC;   | x22EC  | 8940   | E2 8B AC    | FF FE EC 22       | Sm
⋭                                  | DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL                                                                 |            | &amp;x22ED;   | x22ED  | 8941   | E2 8B AD    | FF FE ED 22       | Sm
⋮                                  | VERTICAL ELLIPSIS                                                                                            | `:3`       | &amp;x22EE;   | x22EE  | 8942   | E2 8B AE    | FF FE EE 22       | Sm
⋯                                  | MIDLINE HORIZONTAL ELLIPSIS                                                                                  | `.3`       | &amp;x22EF;   | x22EF  | 8943   | E2 8B AF    | FF FE EF 22       | Sm
⋰                                  | UP RIGHT DIAGONAL ELLIPSIS                                                                                   |            | &amp;x22F0;   | x22F0  | 8944   | E2 8B B0    | FF FE F0 22       | Sm
⋱                                  | DOWN RIGHT DIAGONAL ELLIPSIS                                                                                 |            | &amp;x22F1;   | x22F1  | 8945   | E2 8B B1    | FF FE F1 22       | Sm
⋲                                  | ELEMENT OF WITH LONG HORIZONTAL STROKE                                                                       |            | &amp;x22F2;   | x22F2  | 8946   | E2 8B B2    | FF FE F2 22       | Sm
⋳                                  | ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE                                                     |            | &amp;x22F3;   | x22F3  | 8947   | E2 8B B3    | FF FE F3 22       | Sm
⋴                                  | SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE                                               |            | &amp;x22F4;   | x22F4  | 8948   | E2 8B B4    | FF FE F4 22       | Sm
⋵                                  | ELEMENT OF WITH DOT ABOVE                                                                                    |            | &amp;x22F5;   | x22F5  | 8949   | E2 8B B5    | FF FE F5 22       | Sm
⋶                                  | ELEMENT OF WITH OVERBAR                                                                                      |            | &amp;x22F6;   | x22F6  | 8950   | E2 8B B6    | FF FE F6 22       | Sm
⋷                                  | SMALL ELEMENT OF WITH OVERBAR                                                                                |            | &amp;x22F7;   | x22F7  | 8951   | E2 8B B7    | FF FE F7 22       | Sm
⋸                                  | ELEMENT OF WITH UNDERBAR                                                                                     |            | &amp;x22F8;   | x22F8  | 8952   | E2 8B B8    | FF FE F8 22       | Sm
⋹                                  | ELEMENT OF WITH TWO HORIZONTAL STROKES                                                                       |            | &amp;x22F9;   | x22F9  | 8953   | E2 8B B9    | FF FE F9 22       | Sm
⋺                                  | CONTAINS WITH LONG HORIZONTAL STROKE                                                                         |            | &amp;x22FA;   | x22FA  | 8954   | E2 8B BA    | FF FE FA 22       | Sm
⋻                                  | CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE                                                       |            | &amp;x22FB;   | x22FB  | 8955   | E2 8B BB    | FF FE FB 22       | Sm
⋼                                  | SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE                                                 |            | &amp;x22FC;   | x22FC  | 8956   | E2 8B BC    | FF FE FC 22       | Sm
⋽                                  | CONTAINS WITH OVERBAR                                                                                        |            | &amp;x22FD;   | x22FD  | 8957   | E2 8B BD    | FF FE FD 22       | Sm
⋾                                  | SMALL CONTAINS WITH OVERBAR                                                                                  |            | &amp;x22FE;   | x22FE  | 8958   | E2 8B BE    | FF FE FE 22       | Sm
⋿                                  | Z NOTATION BAG MEMBERSHIP                                                                                    |            | &amp;x22FF;   | x22FF  | 8959   | E2 8B BF    | FF FE FF 22       | Sm
⌀                                  | DIAMETER SIGN                                                                                                |            | &amp;x2300;   | x2300  | 8960   | E2 8C 80    | FF FE 00 23       | So
⌈                                  | LEFT CEILING                                                                                                 | `<7`       | &amp;lceil;   | x2308  | 8968   | E2 8C 88    | FF FE 08 23       | Ps
⌉                                  | RIGHT CEILING                                                                                                | `>7`       | &amp;rceil;   | x2309  | 8969   | E2 8C 89    | FF FE 09 23       | Pe
⌊                                  | LEFT FLOOR                                                                                                   | `7<`       | &amp;lfloor;  | x230A  | 8970   | E2 8C 8A    | FF FE 0A 23       | Ps
⌋                                  | RIGHT FLOOR                                                                                                  | `7>`       | &amp;rfloor;  | x230B  | 8971   | E2 8C 8B    | FF FE 0B 23       | Pe
⌌                                  | BOTTOM RIGHT CROP                                                                                            |            | &amp;x230C;   | x230C  | 8972   | E2 8C 8C    | FF FE 0C 23       | So
⌍                                  | BOTTOM LEFT CROP                                                                                             |            | &amp;x230D;   | x230D  | 8973   | E2 8C 8D    | FF FE 0D 23       | So
⌎                                  | TOP RIGHT CROP                                                                                               |            | &amp;x230E;   | x230E  | 8974   | E2 8C 8E    | FF FE 0E 23       | So
⌏                                  | TOP LEFT CROP                                                                                                |            | &amp;x230F;   | x230F  | 8975   | E2 8C 8F    | FF FE 0F 23       | So
⌐                                  | REVERSED NOT SIGN                                                                                            | `NI`       | &amp;x2310;   | x2310  | 8976   | E2 8C 90    | FF FE 10 23       | So
<a id="misc">*Section*</a>         | [**Miscellaneous Symbols**](https://en.wikipedia.org/wiki/Miscellaneous_Symbols)                             |            |               |        |        |             |                   |
⌑                                  | SQUARE LOZENGE                                                                                               |            | &amp;x2311;   | x2311  | 8977   | E2 8C 91    | FF FE 11 23       | So
⌒                                  | ARC                                                                                                          | `(A`       | &amp;x2312;   | x2312  | 8978   | E2 8C 92    | FF FE 12 23       | So
⌓                                  | SEGMENT                                                                                                      |            | &amp;x2313;   | x2313  | 8979   | E2 8C 93    | FF FE 13 23       | So
⌔                                  | SECTOR                                                                                                       |            | &amp;x2314;   | x2314  | 8980   | E2 8C 94    | FF FE 14 23       | So
⌕                                  | TELEPHONE RECORDER                                                                                           | `TR`       | &amp;x2315;   | x2315  | 8981   | E2 8C 95    | FF FE 15 23       | So
⌖                                  | POSITION INDICATOR                                                                                           |            | &amp;x2316;   | x2316  | 8982   | E2 8C 96    | FF FE 16 23       | So
⌗                                  | VIEWDATA SQUARE                                                                                              |            | &amp;x2317;   | x2317  | 8983   | E2 8C 97    | FF FE 17 23       | So
⌘                                  | PLACE OF INTEREST SIGN                                                                                       |            | &amp;x2318;   | x2318  | 8984   | E2 8C 98    | FF FE 18 23       | So
⌙                                  | TURNED NOT SIGN                                                                                              |            | &amp;x2319;   | x2319  | 8985   | E2 8C 99    | FF FE 19 23       | So
⌚                                  | WATCH                                                                                                        |            | &amp;x231A;   | x231A  | 8986   | E2 8C 9A    | FF FE 1A 23       | So
⌛                                  | HOURGLASS                                                                                                    |            | &amp;x231B;   | x231B  | 8987   | E2 8C 9B    | FF FE 1B 23       | So
⌜                                  | TOP LEFT CORNER                                                                                              |            | &amp;x231C;   | x231C  | 8988   | E2 8C 9C    | FF FE 1C 23       | So
⌝                                  | TOP RIGHT CORNER                                                                                             |            | &amp;x231D;   | x231D  | 8989   | E2 8C 9D    | FF FE 1D 23       | So
⌞                                  | BOTTOM LEFT CORNER                                                                                           |            | &amp;x231E;   | x231E  | 8990   | E2 8C 9E    | FF FE 1E 23       | So
⌟                                  | BOTTOM RIGHT CORNER                                                                                          |            | &amp;x231F;   | x231F  | 8991   | E2 8C 9F    | FF FE 1F 23       | So
⌠                                  | TOP HALF INTEGRAL                                                                                            | `Iu`       | &amp;x2320;   | x2320  | 8992   | E2 8C A0    | FF FE 20 23       | Sm
⌡                                  | BOTTOM HALF INTEGRAL                                                                                         | `Il`       | &amp;x2321;   | x2321  | 8993   | E2 8C A1    | FF FE 21 23       | Sm
⌢                                  | FROWN                                                                                                        |            | &amp;x2322;   | x2322  | 8994   | E2 8C A2    | FF FE 22 23       | So
⌣                                  | SMILE                                                                                                        |            | &amp;x2323;   | x2323  | 8995   | E2 8C A3    | FF FE 23 23       | So
⌤                                  | UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS                                                                     |            | &amp;x2324;   | x2324  | 8996   | E2 8C A4    | FF FE 24 23       | So
⌥                                  | OPTION KEY                                                                                                   |            | &amp;x2325;   | x2325  | 8997   | E2 8C A5    | FF FE 25 23       | So
⌦                                  | ERASE TO THE RIGHT                                                                                           |            | &amp;x2326;   | x2326  | 8998   | E2 8C A6    | FF FE 26 23       | So
⌧                                  | X IN A RECTANGLE BOX                                                                                         |            | &amp;x2327;   | x2327  | 8999   | E2 8C A7    | FF FE 27 23       | So
⌨                                  | KEYBOARD                                                                                                     |            | &amp;x2328;   | x2328  | 9000   | E2 8C A8    | FF FE 28 23       | So
〈                                  | LEFT-POINTING ANGLE BRACKET                                                                                  | `</`       | &amp;lang;    | x2329  | 9001   | E2 8C A9    | FF FE 29 23       | Ps
〉                                  | RIGHT-POINTING ANGLE BRACKET                                                                                 | `/>`       | &amp;rang;    | x232A  | 9002   | E2 8C AA    | FF FE 2A 23       | Pe
⌫                                  | ERASE TO THE LEFT                                                                                            |            | &amp;x232B;   | x232B  | 9003   | E2 8C AB    | FF FE 2B 23       | So
⏎                                  | RETURN SYMBOL                                                                                                |            | &amp;x23CE;   | x23CE  | 9166   | E2 8F 8E    | FF FE CE 23       | So
⏏                                  | EJECT SYMBOL                                                                                                 |            | &amp;x23CF;   | x23CF  | 9167   | E2 8F 8F    | FF FE CF 23       | So
⏩                                  | BLACK RIGHT-POINTING DOUBLE TRIANGLE                                                                         |            | &amp;x23E9;   | x23E9  | 9193   | E2 8F A9    | FF FE E9 23       | So
⏪                                  | BLACK LEFT-POINTING DOUBLE TRIANGLE                                                                          |            | &amp;x23EA;   | x23EA  | 9194   | E2 8F AA    | FF FE EA 23       | So
⏫                                  | BLACK UP-POINTING DOUBLE TRIANGLE                                                                            |            | &amp;x23EB;   | x23EB  | 9195   | E2 8F AB    | FF FE EB 23       | So
⏬                                  | BLACK DOWN-POINTING DOUBLE TRIANGLE                                                                          |            | &amp;x23EC;   | x23EC  | 9196   | E2 8F AC    | FF FE EC 23       | So
⏭                                  | BLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR                                                       |            | &amp;x23ED;   | x23ED  | 9197   | E2 8F AD    | FF FE ED 23       | So
⏮                                  | BLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR                                                        |            | &amp;x23EE;   | x23EE  | 9198   | E2 8F AE    | FF FE EE 23       | So
⏯                                  | BLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BAR                                                       |            | &amp;x23EF;   | x23EF  | 9199   | E2 8F AF    | FF FE EF 23       | So
⏰                                  | ALARM CLOCK                                                                                                  |            | &amp;x23F0;   | x23F0  | 9200   | E2 8F B0    | FF FE F0 23       | So
⏱                                  | STOPWATCH                                                                                                    |            | &amp;x23F1;   | x23F1  | 9201   | E2 8F B1    | FF FE F1 23       | So
⏲                                  | TIMER CLOCK                                                                                                  |            | &amp;x23F2;   | x23F2  | 9202   | E2 8F B2    | FF FE F2 23       | So
⏳                                  | HOURGLASS WITH FLOWING SAND                                                                                  |            | &amp;x23F3;   | x23F3  | 9203   | E2 8F B3    | FF FE F3 23       | So
⏴                                  | BLACK MEDIUM LEFT-POINTING TRIANGLE                                                                          |            | &amp;x23F4;   | x23F4  | 9204   | E2 8F B4    | FF FE F4 23       | So
⏵                                  | BLACK MEDIUM RIGHT-POINTING TRIANGLE                                                                         |            | &amp;x23F5;   | x23F5  | 9205   | E2 8F B5    | FF FE F5 23       | So
⏶                                  | BLACK MEDIUM UP-POINTING TRIANGLE                                                                            |            | &amp;x23F6;   | x23F6  | 9206   | E2 8F B6    | FF FE F6 23       | So
⏷                                  | BLACK MEDIUM DOWN-POINTING TRIANGLE                                                                          |            | &amp;x23F7;   | x23F7  | 9207   | E2 8F B7    | FF FE F7 23       | So
⏸                                  | DOUBLE VERTICAL BAR                                                                                          |            | &amp;x23F8;   | x23F8  | 9208   | E2 8F B8    | FF FE F8 23       | So
⏹                                  | BLACK SQUARE FOR STOP                                                                                        |            | &amp;x23F9;   | x23F9  | 9209   | E2 8F B9    | FF FE F9 23       | So
⏺                                  | BLACK CIRCLE FOR RECORD                                                                                      |            | &amp;x23FA;   | x23FA  | 9210   | E2 8F BA    | FF FE FA 23       | So
⏻                                  | POWER SYMBOL                                                                                                 |            | &amp;x23FB;   | x23FB  | 9211   | E2 8F BB    | FF FE FB 23       | So
⏼                                  | POWER ON-OFF SYMBOL                                                                                          |            | &amp;x23FC;   | x23FC  | 9212   | E2 8F BC    | FF FE FC 23       | So
⏽                                  | POWER ON SYMBOL                                                                                              |            | &amp;x23FD;   | x23FD  | 9213   | E2 8F BD    | FF FE FD 23       | So
⏾                                  | POWER SLEEP SYMBOL                                                                                           |            | &amp;x23FE;   | x23FE  | 9214   | E2 8F BE    | FF FE FE 23       | So
⏿                                  | OBSERVER EYE SYMBOL                                                                                          |            | &amp;x23FF;   | x23FF  | 9215   | E2 8F BF    | FF FE FF 23       | So
<a id="number-forms">*Section*</a> | [**Number Forms**](https://en.wikipedia.org/wiki/Number_Forms)                                               |            |               |        |        |             |                   |
¼                                  | VULGAR FRACTION ONE QUARTER                                                                                  | `14`       | &amp;frac14;  | xBC    | 188    | C2 BC       | FF FE BC 00       | No
½                                  | VULGAR FRACTION ONE HALF                                                                                     | `12`       | &amp;frac12;  | xBD    | 189    | C2 BD       | FF FE BD 00       | No
¾                                  | VULGAR FRACTION THREE QUARTERS                                                                               | `34`       | &amp;frac34;  | xBE    | 190    | C2 BE       | FF FE BE 00       | No
⅐                                  | VULGAR FRACTION ONE SEVENTH                                                                                  |            | &amp;x2150;   | x2150  | 8528   | E2 85 90    | FF FE 50 21       | No
⅑                                  | VULGAR FRACTION ONE NINTH                                                                                    |            | &amp;x2151;   | x2151  | 8529   | E2 85 91    | FF FE 51 21       | No
⅒                                  | VULGAR FRACTION ONE TENTH                                                                                    |            | &amp;x2152;   | x2152  | 8530   | E2 85 92    | FF FE 52 21       | No
⅓                                  | VULGAR FRACTION ONE THIRD                                                                                    | `13`       | &amp;x2153;   | x2153  | 8531   | E2 85 93    | FF FE 53 21       | No
⅔                                  | VULGAR FRACTION TWO THIRDS                                                                                   | `23`       | &amp;x2154;   | x2154  | 8532   | E2 85 94    | FF FE 54 21       | No
⅕                                  | VULGAR FRACTION ONE FIFTH                                                                                    | `15`       | &amp;x2155;   | x2155  | 8533   | E2 85 95    | FF FE 55 21       | No
⅖                                  | VULGAR FRACTION TWO FIFTHS                                                                                   | `25`       | &amp;x2156;   | x2156  | 8534   | E2 85 96    | FF FE 56 21       | No
⅗                                  | VULGAR FRACTION THREE FIFTHS                                                                                 | `35`       | &amp;x2157;   | x2157  | 8535   | E2 85 97    | FF FE 57 21       | No
⅘                                  | VULGAR FRACTION FOUR FIFTHS                                                                                  | `45`       | &amp;x2158;   | x2158  | 8536   | E2 85 98    | FF FE 58 21       | No
⅙                                  | VULGAR FRACTION ONE SIXTH                                                                                    | `16`       | &amp;x2159;   | x2159  | 8537   | E2 85 99    | FF FE 59 21       | No
⅚                                  | VULGAR FRACTION FIVE SIXTHS                                                                                  | `56`       | &amp;x215A;   | x215A  | 8538   | E2 85 9A    | FF FE 5A 21       | No
⅛                                  | VULGAR FRACTION ONE EIGHTH                                                                                   | `18`       | &amp;x215B;   | x215B  | 8539   | E2 85 9B    | FF FE 5B 21       | No
⅜                                  | VULGAR FRACTION THREE EIGHTHS                                                                                | `38`       | &amp;x215C;   | x215C  | 8540   | E2 85 9C    | FF FE 5C 21       | No
⅝                                  | VULGAR FRACTION FIVE EIGHTHS                                                                                 | `58`       | &amp;x215D;   | x215D  | 8541   | E2 85 9D    | FF FE 5D 21       | No
⅞                                  | VULGAR FRACTION SEVEN EIGHTHS                                                                                | `78`       | &amp;x215E;   | x215E  | 8542   | E2 85 9E    | FF FE 5E 21       | No
⅟                                  | FRACTION NUMERATOR ONE                                                                                       |            | &amp;x215F;   | x215F  | 8543   | E2 85 9F    | FF FE 5F 21       | No
<a id="geometry">*Section*</a>     | [**Geometric Shapes**](https://en.wikipedia.org/wiki/Geometric_Shapes)                                       |            |               |        |        |             |                   |
←                                  | LEFTWARDS ARROW                                                                                              | `<-`       | &amp;larr;    | x2190  | 8592   | E2 86 90    | FF FE 90 21       | Sm
↑                                  | UPWARDS ARROW                                                                                                | `-!`       | &amp;uarr;    | x2191  | 8593   | E2 86 91    | FF FE 91 21       | Sm
→                                  | RIGHTWARDS ARROW                                                                                             | `->`       | &amp;rarr;    | x2192  | 8594   | E2 86 92    | FF FE 92 21       | Sm
↓                                  | DOWNWARDS ARROW                                                                                              | `-v`       | &amp;darr;    | x2193  | 8595   | E2 86 93    | FF FE 93 21       | Sm
↔                                  | LEFT RIGHT ARROW                                                                                             | `<>`       | &amp;harr;    | x2194  | 8596   | E2 86 94    | FF FE 94 21       | Sm
↕                                  | UP DOWN ARROW                                                                                                | `UD`       | &amp;x2195;   | x2195  | 8597   | E2 86 95    | FF FE 95 21       | So
↖                                  | NORTH WEST ARROW                                                                                             |            | &amp;x2196;   | x2196  | 8598   | E2 86 96    | FF FE 96 21       | So
↗                                  | NORTH EAST ARROW                                                                                             |            | &amp;x2197;   | x2197  | 8599   | E2 86 97    | FF FE 97 21       | So
↘                                  | SOUTH EAST ARROW                                                                                             |            | &amp;x2198;   | x2198  | 8600   | E2 86 98    | FF FE 98 21       | So
↙                                  | SOUTH WEST ARROW                                                                                             |            | &amp;x2199;   | x2199  | 8601   | E2 86 99    | FF FE 99 21       | So
↚                                  | LEFTWARDS ARROW WITH STROKE                                                                                  |            | &amp;x219A;   | x219A  | 8602   | E2 86 9A    | FF FE 9A 21       | Sm
↛                                  | RIGHTWARDS ARROW WITH STROKE                                                                                 |            | &amp;x219B;   | x219B  | 8603   | E2 86 9B    | FF FE 9B 21       | Sm
↜                                  | LEFTWARDS WAVE ARROW                                                                                         |            | &amp;x219C;   | x219C  | 8604   | E2 86 9C    | FF FE 9C 21       | So
↝                                  | RIGHTWARDS WAVE ARROW                                                                                        |            | &amp;x219D;   | x219D  | 8605   | E2 86 9D    | FF FE 9D 21       | So
↞                                  | LEFTWARDS TWO HEADED ARROW                                                                                   |            | &amp;x219E;   | x219E  | 8606   | E2 86 9E    | FF FE 9E 21       | So
↟                                  | UPWARDS TWO HEADED ARROW                                                                                     |            | &amp;x219F;   | x219F  | 8607   | E2 86 9F    | FF FE 9F 21       | So
↠                                  | RIGHTWARDS TWO HEADED ARROW                                                                                  |            | &amp;x21A0;   | x21A0  | 8608   | E2 86 A0    | FF FE A0 21       | Sm
↡                                  | DOWNWARDS TWO HEADED ARROW                                                                                   |            | &amp;x21A1;   | x21A1  | 8609   | E2 86 A1    | FF FE A1 21       | So
↢                                  | LEFTWARDS ARROW WITH TAIL                                                                                    |            | &amp;x21A2;   | x21A2  | 8610   | E2 86 A2    | FF FE A2 21       | So
↣                                  | RIGHTWARDS ARROW WITH TAIL                                                                                   |            | &amp;x21A3;   | x21A3  | 8611   | E2 86 A3    | FF FE A3 21       | Sm
↤                                  | LEFTWARDS ARROW FROM BAR                                                                                     |            | &amp;x21A4;   | x21A4  | 8612   | E2 86 A4    | FF FE A4 21       | So
↥                                  | UPWARDS ARROW FROM BAR                                                                                       |            | &amp;x21A5;   | x21A5  | 8613   | E2 86 A5    | FF FE A5 21       | So
↦                                  | RIGHTWARDS ARROW FROM BAR                                                                                    |            | &amp;x21A6;   | x21A6  | 8614   | E2 86 A6    | FF FE A6 21       | Sm
↧                                  | DOWNWARDS ARROW FROM BAR                                                                                     |            | &amp;x21A7;   | x21A7  | 8615   | E2 86 A7    | FF FE A7 21       | So
↨                                  | UP DOWN ARROW WITH BASE                                                                                      |            | &amp;x21A8;   | x21A8  | 8616   | E2 86 A8    | FF FE A8 21       | So
↩                                  | LEFTWARDS ARROW WITH HOOK                                                                                    |            | &amp;x21A9;   | x21A9  | 8617   | E2 86 A9    | FF FE A9 21       | So
↪                                  | RIGHTWARDS ARROW WITH HOOK                                                                                   |            | &amp;x21AA;   | x21AA  | 8618   | E2 86 AA    | FF FE AA 21       | So
↫                                  | LEFTWARDS ARROW WITH LOOP                                                                                    |            | &amp;x21AB;   | x21AB  | 8619   | E2 86 AB    | FF FE AB 21       | So
↬                                  | RIGHTWARDS ARROW WITH LOOP                                                                                   |            | &amp;x21AC;   | x21AC  | 8620   | E2 86 AC    | FF FE AC 21       | So
↭                                  | LEFT RIGHT WAVE ARROW                                                                                        |            | &amp;x21AD;   | x21AD  | 8621   | E2 86 AD    | FF FE AD 21       | So
↮                                  | LEFT RIGHT ARROW WITH STROKE                                                                                 |            | &amp;x21AE;   | x21AE  | 8622   | E2 86 AE    | FF FE AE 21       | Sm
↯                                  | DOWNWARDS ZIGZAG ARROW                                                                                       |            | &amp;x21AF;   | x21AF  | 8623   | E2 86 AF    | FF FE AF 21       | So
↰                                  | UPWARDS ARROW WITH TIP LEFTWARDS                                                                             |            | &amp;x21B0;   | x21B0  | 8624   | E2 86 B0    | FF FE B0 21       | So
↱                                  | UPWARDS ARROW WITH TIP RIGHTWARDS                                                                            |            | &amp;x21B1;   | x21B1  | 8625   | E2 86 B1    | FF FE B1 21       | So
↲                                  | DOWNWARDS ARROW WITH TIP LEFTWARDS                                                                           |            | &amp;x21B2;   | x21B2  | 8626   | E2 86 B2    | FF FE B2 21       | So
↳                                  | DOWNWARDS ARROW WITH TIP RIGHTWARDS                                                                          |            | &amp;x21B3;   | x21B3  | 8627   | E2 86 B3    | FF FE B3 21       | So
↴                                  | RIGHTWARDS ARROW WITH CORNER DOWNWARDS                                                                       |            | &amp;x21B4;   | x21B4  | 8628   | E2 86 B4    | FF FE B4 21       | So
↵                                  | DOWNWARDS ARROW WITH CORNER LEFTWARDS                                                                        |            | &amp;crarr;   | x21B5  | 8629   | E2 86 B5    | FF FE B5 21       | So
↶                                  | ANTICLOCKWISE TOP SEMICIRCLE ARROW                                                                           |            | &amp;x21B6;   | x21B6  | 8630   | E2 86 B6    | FF FE B6 21       | So
↷                                  | CLOCKWISE TOP SEMICIRCLE ARROW                                                                               |            | &amp;x21B7;   | x21B7  | 8631   | E2 86 B7    | FF FE B7 21       | So
↸                                  | NORTH WEST ARROW TO LONG BAR                                                                                 |            | &amp;x21B8;   | x21B8  | 8632   | E2 86 B8    | FF FE B8 21       | So
↹                                  | LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR                                                          |            | &amp;x21B9;   | x21B9  | 8633   | E2 86 B9    | FF FE B9 21       | So
↺                                  | ANTICLOCKWISE OPEN CIRCLE ARROW                                                                              |            | &amp;x21BA;   | x21BA  | 8634   | E2 86 BA    | FF FE BA 21       | So
↻                                  | CLOCKWISE OPEN CIRCLE ARROW                                                                                  |            | &amp;x21BB;   | x21BB  | 8635   | E2 86 BB    | FF FE BB 21       | So
↼                                  | LEFTWARDS HARPOON WITH BARB UPWARDS                                                                          |            | &amp;x21BC;   | x21BC  | 8636   | E2 86 BC    | FF FE BC 21       | So
↽                                  | LEFTWARDS HARPOON WITH BARB DOWNWARDS                                                                        |            | &amp;x21BD;   | x21BD  | 8637   | E2 86 BD    | FF FE BD 21       | So
↾                                  | UPWARDS HARPOON WITH BARB RIGHTWARDS                                                                         |            | &amp;x21BE;   | x21BE  | 8638   | E2 86 BE    | FF FE BE 21       | So
↿                                  | UPWARDS HARPOON WITH BARB LEFTWARDS                                                                          |            | &amp;x21BF;   | x21BF  | 8639   | E2 86 BF    | FF FE BF 21       | So
⇀                                  | RIGHTWARDS HARPOON WITH BARB UPWARDS                                                                         |            | &amp;x21C0;   | x21C0  | 8640   | E2 87 80    | FF FE C0 21       | So
⇁                                  | RIGHTWARDS HARPOON WITH BARB DOWNWARDS                                                                       |            | &amp;x21C1;   | x21C1  | 8641   | E2 87 81    | FF FE C1 21       | So
⇂                                  | DOWNWARDS HARPOON WITH BARB RIGHTWARDS                                                                       |            | &amp;x21C2;   | x21C2  | 8642   | E2 87 82    | FF FE C2 21       | So
⇃                                  | DOWNWARDS HARPOON WITH BARB LEFTWARDS                                                                        |            | &amp;x21C3;   | x21C3  | 8643   | E2 87 83    | FF FE C3 21       | So
⇄                                  | RIGHTWARDS ARROW OVER LEFTWARDS ARROW                                                                        |            | &amp;x21C4;   | x21C4  | 8644   | E2 87 84    | FF FE C4 21       | So
⇅                                  | UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW                                                                   |            | &amp;x21C5;   | x21C5  | 8645   | E2 87 85    | FF FE C5 21       | So
⇆                                  | LEFTWARDS ARROW OVER RIGHTWARDS ARROW                                                                        |            | &amp;x21C6;   | x21C6  | 8646   | E2 87 86    | FF FE C6 21       | So
⇇                                  | LEFTWARDS PAIRED ARROWS                                                                                      |            | &amp;x21C7;   | x21C7  | 8647   | E2 87 87    | FF FE C7 21       | So
⇈                                  | UPWARDS PAIRED ARROWS                                                                                        |            | &amp;x21C8;   | x21C8  | 8648   | E2 87 88    | FF FE C8 21       | So
⇉                                  | RIGHTWARDS PAIRED ARROWS                                                                                     |            | &amp;x21C9;   | x21C9  | 8649   | E2 87 89    | FF FE C9 21       | So
⇊                                  | DOWNWARDS PAIRED ARROWS                                                                                      |            | &amp;x21CA;   | x21CA  | 8650   | E2 87 8A    | FF FE CA 21       | So
⇋                                  | LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON                                                                    |            | &amp;x21CB;   | x21CB  | 8651   | E2 87 8B    | FF FE CB 21       | So
⇌                                  | RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON                                                                    |            | &amp;x21CC;   | x21CC  | 8652   | E2 87 8C    | FF FE CC 21       | So
⇍                                  | LEFTWARDS DOUBLE ARROW WITH STROKE                                                                           |            | &amp;x21CD;   | x21CD  | 8653   | E2 87 8D    | FF FE CD 21       | So
⇎                                  | LEFT RIGHT DOUBLE ARROW WITH STROKE                                                                          |            | &amp;x21CE;   | x21CE  | 8654   | E2 87 8E    | FF FE CE 21       | Sm
⇏                                  | RIGHTWARDS DOUBLE ARROW WITH STROKE                                                                          |            | &amp;x21CF;   | x21CF  | 8655   | E2 87 8F    | FF FE CF 21       | Sm
⇐                                  | LEFTWARDS DOUBLE ARROW                                                                                       | `<=`       | &amp;lArr;    | x21D0  | 8656   | E2 87 90    | FF FE D0 21       | So
⇑                                  | UPWARDS DOUBLE ARROW                                                                                         |            | &amp;uArr;    | x21D1  | 8657   | E2 87 91    | FF FE D1 21       | So
⇒                                  | RIGHTWARDS DOUBLE ARROW                                                                                      | `=>`       | &amp;rArr;    | x21D2  | 8658   | E2 87 92    | FF FE D2 21       | Sm
⇓                                  | DOWNWARDS DOUBLE ARROW                                                                                       |            | &amp;dArr;    | x21D3  | 8659   | E2 87 93    | FF FE D3 21       | So
⇔                                  | LEFT RIGHT DOUBLE ARROW                                                                                      | `==`       | &amp;hArr;    | x21D4  | 8660   | E2 87 94    | FF FE D4 21       | Sm
⇕                                  | UP DOWN DOUBLE ARROW                                                                                         |            | &amp;x21D5;   | x21D5  | 8661   | E2 87 95    | FF FE D5 21       | So
⇖                                  | NORTH WEST DOUBLE ARROW                                                                                      |            | &amp;x21D6;   | x21D6  | 8662   | E2 87 96    | FF FE D6 21       | So
⇗                                  | NORTH EAST DOUBLE ARROW                                                                                      |            | &amp;x21D7;   | x21D7  | 8663   | E2 87 97    | FF FE D7 21       | So
⇘                                  | SOUTH EAST DOUBLE ARROW                                                                                      |            | &amp;x21D8;   | x21D8  | 8664   | E2 87 98    | FF FE D8 21       | So
⇙                                  | SOUTH WEST DOUBLE ARROW                                                                                      |            | &amp;x21D9;   | x21D9  | 8665   | E2 87 99    | FF FE D9 21       | So
⇚                                  | LEFTWARDS TRIPLE ARROW                                                                                       |            | &amp;x21DA;   | x21DA  | 8666   | E2 87 9A    | FF FE DA 21       | So
⇛                                  | RIGHTWARDS TRIPLE ARROW                                                                                      |            | &amp;x21DB;   | x21DB  | 8667   | E2 87 9B    | FF FE DB 21       | So
⇜                                  | LEFTWARDS SQUIGGLE ARROW                                                                                     |            | &amp;x21DC;   | x21DC  | 8668   | E2 87 9C    | FF FE DC 21       | So
⇝                                  | RIGHTWARDS SQUIGGLE ARROW                                                                                    |            | &amp;x21DD;   | x21DD  | 8669   | E2 87 9D    | FF FE DD 21       | So
⇞                                  | UPWARDS ARROW WITH DOUBLE STROKE                                                                             |            | &amp;x21DE;   | x21DE  | 8670   | E2 87 9E    | FF FE DE 21       | So
⇟                                  | DOWNWARDS ARROW WITH DOUBLE STROKE                                                                           |            | &amp;x21DF;   | x21DF  | 8671   | E2 87 9F    | FF FE DF 21       | So
⇠                                  | LEFTWARDS DASHED ARROW                                                                                       |            | &amp;x21E0;   | x21E0  | 8672   | E2 87 A0    | FF FE E0 21       | So
⇡                                  | UPWARDS DASHED ARROW                                                                                         |            | &amp;x21E1;   | x21E1  | 8673   | E2 87 A1    | FF FE E1 21       | So
⇢                                  | RIGHTWARDS DASHED ARROW                                                                                      |            | &amp;x21E2;   | x21E2  | 8674   | E2 87 A2    | FF FE E2 21       | So
⇣                                  | DOWNWARDS DASHED ARROW                                                                                       |            | &amp;x21E3;   | x21E3  | 8675   | E2 87 A3    | FF FE E3 21       | So
⇤                                  | LEFTWARDS ARROW TO BAR                                                                                       |            | &amp;x21E4;   | x21E4  | 8676   | E2 87 A4    | FF FE E4 21       | So
⇥                                  | RIGHTWARDS ARROW TO BAR                                                                                      |            | &amp;x21E5;   | x21E5  | 8677   | E2 87 A5    | FF FE E5 21       | So
⇦                                  | LEFTWARDS WHITE ARROW                                                                                        |            | &amp;x21E6;   | x21E6  | 8678   | E2 87 A6    | FF FE E6 21       | So
⇧                                  | UPWARDS WHITE ARROW                                                                                          |            | &amp;x21E7;   | x21E7  | 8679   | E2 87 A7    | FF FE E7 21       | So
⇨                                  | RIGHTWARDS WHITE ARROW                                                                                       |            | &amp;x21E8;   | x21E8  | 8680   | E2 87 A8    | FF FE E8 21       | So
⇩                                  | DOWNWARDS WHITE ARROW                                                                                        |            | &amp;x21E9;   | x21E9  | 8681   | E2 87 A9    | FF FE E9 21       | So
⇪                                  | UPWARDS WHITE ARROW FROM BAR                                                                                 |            | &amp;x21EA;   | x21EA  | 8682   | E2 87 AA    | FF FE EA 21       | So
⇫                                  | UPWARDS WHITE ARROW ON PEDESTAL                                                                              |            | &amp;x21EB;   | x21EB  | 8683   | E2 87 AB    | FF FE EB 21       | So
⇬                                  | UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR                                                          |            | &amp;x21EC;   | x21EC  | 8684   | E2 87 AC    | FF FE EC 21       | So
⇭                                  | UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR                                                            |            | &amp;x21ED;   | x21ED  | 8685   | E2 87 AD    | FF FE ED 21       | So
⇮                                  | UPWARDS WHITE DOUBLE ARROW                                                                                   |            | &amp;x21EE;   | x21EE  | 8686   | E2 87 AE    | FF FE EE 21       | So
⇯                                  | UPWARDS WHITE DOUBLE ARROW ON PEDESTAL                                                                       |            | &amp;x21EF;   | x21EF  | 8687   | E2 87 AF    | FF FE EF 21       | So
⇰                                  | RIGHTWARDS WHITE ARROW FROM WALL                                                                             |            | &amp;x21F0;   | x21F0  | 8688   | E2 87 B0    | FF FE F0 21       | So
⇱                                  | NORTH WEST ARROW TO CORNER                                                                                   |            | &amp;x21F1;   | x21F1  | 8689   | E2 87 B1    | FF FE F1 21       | So
⇲                                  | SOUTH EAST ARROW TO CORNER                                                                                   |            | &amp;x21F2;   | x21F2  | 8690   | E2 87 B2    | FF FE F2 21       | So
⇳                                  | UP DOWN WHITE ARROW                                                                                          |            | &amp;x21F3;   | x21F3  | 8691   | E2 87 B3    | FF FE F3 21       | So
⇴                                  | RIGHT ARROW WITH SMALL CIRCLE                                                                                |            | &amp;x21F4;   | x21F4  | 8692   | E2 87 B4    | FF FE F4 21       | Sm
⇵                                  | DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW                                                                   |            | &amp;x21F5;   | x21F5  | 8693   | E2 87 B5    | FF FE F5 21       | Sm
⇶                                  | THREE RIGHTWARDS ARROWS                                                                                      |            | &amp;x21F6;   | x21F6  | 8694   | E2 87 B6    | FF FE F6 21       | Sm
⇷                                  | LEFTWARDS ARROW WITH VERTICAL STROKE                                                                         |            | &amp;x21F7;   | x21F7  | 8695   | E2 87 B7    | FF FE F7 21       | Sm
⇸                                  | RIGHTWARDS ARROW WITH VERTICAL STROKE                                                                        |            | &amp;x21F8;   | x21F8  | 8696   | E2 87 B8    | FF FE F8 21       | Sm
⇹                                  | LEFT RIGHT ARROW WITH VERTICAL STROKE                                                                        |            | &amp;x21F9;   | x21F9  | 8697   | E2 87 B9    | FF FE F9 21       | Sm
⇺                                  | LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE                                                                  |            | &amp;x21FA;   | x21FA  | 8698   | E2 87 BA    | FF FE FA 21       | Sm
⇻                                  | RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE                                                                 |            | &amp;x21FB;   | x21FB  | 8699   | E2 87 BB    | FF FE FB 21       | Sm
⇼                                  | LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE                                                                 |            | &amp;x21FC;   | x21FC  | 8700   | E2 87 BC    | FF FE FC 21       | Sm
⇽                                  | LEFTWARDS OPEN-HEADED ARROW                                                                                  |            | &amp;x21FD;   | x21FD  | 8701   | E2 87 BD    | FF FE FD 21       | Sm
⇾                                  | RIGHTWARDS OPEN-HEADED ARROW                                                                                 |            | &amp;x21FE;   | x21FE  | 8702   | E2 87 BE    | FF FE FE 21       | Sm
⇿                                  | LEFT RIGHT OPEN-HEADED ARROW                                                                                 |            | &amp;x21FF;   | x21FF  | 8703   | E2 87 BF    | FF FE FF 21       | Sm
■                                  | BLACK SQUARE                                                                                                 | `fS`       | &amp;x25A0;   | x25A0  | 9632   | E2 96 A0    | FF FE A0 25       | So
□                                  | WHITE SQUARE                                                                                                 | `OS`       | &amp;x25A1;   | x25A1  | 9633   | E2 96 A1    | FF FE A1 25       | So
▢                                  | WHITE SQUARE WITH ROUNDED CORNERS                                                                            | `RO`       | &amp;x25A2;   | x25A2  | 9634   | E2 96 A2    | FF FE A2 25       | So
▣                                  | WHITE SQUARE CONTAINING BLACK SMALL SQUARE                                                                   | `Rr`       | &amp;x25A3;   | x25A3  | 9635   | E2 96 A3    | FF FE A3 25       | So
▪                                  | BLACK SMALL SQUARE                                                                                           | `sB`       | &amp;x25AA;   | x25AA  | 9642   | E2 96 AA    | FF FE AA 25       | So
▫                                  | WHITE SMALL SQUARE                                                                                           |            | &amp;x25AB;   | x25AB  | 9643   | E2 96 AB    | FF FE AB 25       | So
▬                                  | BLACK RECTANGLE                                                                                              | `SR`       | &amp;x25AC;   | x25AC  | 9644   | E2 96 AC    | FF FE AC 25       | So
▭                                  | WHITE RECTANGLE                                                                                              | `Or`       | &amp;x25AD;   | x25AD  | 9645   | E2 96 AD    | FF FE AD 25       | So
▮                                  | BLACK VERTICAL RECTANGLE                                                                                     |            | &amp;x25AE;   | x25AE  | 9646   | E2 96 AE    | FF FE AE 25       | So
▯                                  | WHITE VERTICAL RECTANGLE                                                                                     |            | &amp;x25AF;   | x25AF  | 9647   | E2 96 AF    | FF FE AF 25       | So
▰                                  | BLACK PARALLELOGRAM                                                                                          |            | &amp;x25B0;   | x25B0  | 9648   | E2 96 B0    | FF FE B0 25       | So
▱                                  | WHITE PARALLELOGRAM                                                                                          |            | &amp;x25B1;   | x25B1  | 9649   | E2 96 B1    | FF FE B1 25       | So
▲                                  | BLACK UP-POINTING TRIANGLE                                                                                   | `UT`       | &amp;x25B2;   | x25B2  | 9650   | E2 96 B2    | FF FE B2 25       | So
△                                  | WHITE UP-POINTING TRIANGLE                                                                                   | `uT`       | &amp;x25B3;   | x25B3  | 9651   | E2 96 B3    | FF FE B3 25       | So
▴                                  | BLACK UP-POINTING SMALL TRIANGLE                                                                             |            | &amp;x25B4;   | x25B4  | 9652   | E2 96 B4    | FF FE B4 25       | So
▵                                  | WHITE UP-POINTING SMALL TRIANGLE                                                                             |            | &amp;x25B5;   | x25B5  | 9653   | E2 96 B5    | FF FE B5 25       | So
▶                                  | BLACK RIGHT-POINTING TRIANGLE                                                                                | `PR`       | &amp;x25B6;   | x25B6  | 9654   | E2 96 B6    | FF FE B6 25       | So
▷                                  | WHITE RIGHT-POINTING TRIANGLE                                                                                | `Tr`       | &amp;x25B7;   | x25B7  | 9655   | E2 96 B7    | FF FE B7 25       | Sm
▸                                  | BLACK RIGHT-POINTING SMALL TRIANGLE                                                                          |            | &amp;x25B8;   | x25B8  | 9656   | E2 96 B8    | FF FE B8 25       | So
▹                                  | WHITE RIGHT-POINTING SMALL TRIANGLE                                                                          |            | &amp;x25B9;   | x25B9  | 9657   | E2 96 B9    | FF FE B9 25       | So
►                                  | BLACK RIGHT-POINTING POINTER                                                                                 |            | &amp;x25BA;   | x25BA  | 9658   | E2 96 BA    | FF FE BA 25       | So
▻                                  | WHITE RIGHT-POINTING POINTER                                                                                 |            | &amp;x25BB;   | x25BB  | 9659   | E2 96 BB    | FF FE BB 25       | So
▼                                  | BLACK DOWN-POINTING TRIANGLE                                                                                 | `Dt`       | &amp;x25BC;   | x25BC  | 9660   | E2 96 BC    | FF FE BC 25       | So
▽                                  | WHITE DOWN-POINTING TRIANGLE                                                                                 | `dT`       | &amp;x25BD;   | x25BD  | 9661   | E2 96 BD    | FF FE BD 25       | So
▾                                  | BLACK DOWN-POINTING SMALL TRIANGLE                                                                           |            | &amp;x25BE;   | x25BE  | 9662   | E2 96 BE    | FF FE BE 25       | So
▿                                  | WHITE DOWN-POINTING SMALL TRIANGLE                                                                           |            | &amp;x25BF;   | x25BF  | 9663   | E2 96 BF    | FF FE BF 25       | So
◀                                  | BLACK LEFT-POINTING TRIANGLE                                                                                 | `PL`       | &amp;x25C0;   | x25C0  | 9664   | E2 97 80    | FF FE C0 25       | So
◁                                  | WHITE LEFT-POINTING TRIANGLE                                                                                 | `Tl`       | &amp;x25C1;   | x25C1  | 9665   | E2 97 81    | FF FE C1 25       | Sm
◂                                  | BLACK LEFT-POINTING SMALL TRIANGLE                                                                           |            | &amp;x25C2;   | x25C2  | 9666   | E2 97 82    | FF FE C2 25       | So
◃                                  | WHITE LEFT-POINTING SMALL TRIANGLE                                                                           |            | &amp;x25C3;   | x25C3  | 9667   | E2 97 83    | FF FE C3 25       | So
◄                                  | BLACK LEFT-POINTING POINTER                                                                                  |            | &amp;x25C4;   | x25C4  | 9668   | E2 97 84    | FF FE C4 25       | So
◅                                  | WHITE LEFT-POINTING POINTER                                                                                  |            | &amp;x25C5;   | x25C5  | 9669   | E2 97 85    | FF FE C5 25       | So
◆                                  | BLACK DIAMOND                                                                                                | `Db`       | &amp;x25C6;   | x25C6  | 9670   | E2 97 86    | FF FE C6 25       | So
◇                                  | WHITE DIAMOND                                                                                                | `Dw`       | &amp;x25C7;   | x25C7  | 9671   | E2 97 87    | FF FE C7 25       | So
◈                                  | WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND                                                                 |            | &amp;x25C8;   | x25C8  | 9672   | E2 97 88    | FF FE C8 25       | So
◉                                  | FISHEYE                                                                                                      |            | &amp;x25C9;   | x25C9  | 9673   | E2 97 89    | FF FE C9 25       | So
◊                                  | LOZENGE                                                                                                      | `LZ`       | &amp;loz;     | x25CA  | 9674   | E2 97 8A    | FF FE CA 25       | So
○                                  | WHITE CIRCLE                                                                                                 | `0m`       | &amp;x25CB;   | x25CB  | 9675   | E2 97 8B    | FF FE CB 25       | So
◌                                  | DOTTED CIRCLE                                                                                                |            | &amp;x25CC;   | x25CC  | 9676   | E2 97 8C    | FF FE CC 25       | So
◍                                  | CIRCLE WITH VERTICAL FILL                                                                                    |            | &amp;x25CD;   | x25CD  | 9677   | E2 97 8D    | FF FE CD 25       | So
◎                                  | BULLSEYE                                                                                                     | `0o`       | &amp;x25CE;   | x25CE  | 9678   | E2 97 8E    | FF FE CE 25       | So
●                                  | BLACK CIRCLE                                                                                                 | `0M`       | &amp;x25CF;   | x25CF  | 9679   | E2 97 8F    | FF FE CF 25       | So
◐                                  | CIRCLE WITH LEFT HALF BLACK                                                                                  | `0L`       | &amp;x25D0;   | x25D0  | 9680   | E2 97 90    | FF FE D0 25       | So
◑                                  | CIRCLE WITH RIGHT HALF BLACK                                                                                 | `0R`       | &amp;x25D1;   | x25D1  | 9681   | E2 97 91    | FF FE D1 25       | So
◒                                  | CIRCLE WITH LOWER HALF BLACK                                                                                 |            | &amp;x25D2;   | x25D2  | 9682   | E2 97 92    | FF FE D2 25       | So
◓                                  | CIRCLE WITH UPPER HALF BLACK                                                                                 |            | &amp;x25D3;   | x25D3  | 9683   | E2 97 93    | FF FE D3 25       | So
◔                                  | CIRCLE WITH UPPER RIGHT QUADRANT BLACK                                                                       |            | &amp;x25D4;   | x25D4  | 9684   | E2 97 94    | FF FE D4 25       | So
◕                                  | CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK                                                                |            | &amp;x25D5;   | x25D5  | 9685   | E2 97 95    | FF FE D5 25       | So
◖                                  | LEFT HALF BLACK CIRCLE                                                                                       |            | &amp;x25D6;   | x25D6  | 9686   | E2 97 96    | FF FE D6 25       | So
◗                                  | RIGHT HALF BLACK CIRCLE                                                                                      |            | &amp;x25D7;   | x25D7  | 9687   | E2 97 97    | FF FE D7 25       | So
◘                                  | INVERSE BULLET                                                                                               | `Sn`       | &amp;x25D8;   | x25D8  | 9688   | E2 97 98    | FF FE D8 25       | So
◙                                  | INVERSE WHITE CIRCLE                                                                                         | `Ic`       | &amp;x25D9;   | x25D9  | 9689   | E2 97 99    | FF FE D9 25       | So
◚                                  | UPPER HALF INVERSE WHITE CIRCLE                                                                              |            | &amp;x25DA;   | x25DA  | 9690   | E2 97 9A    | FF FE DA 25       | So
◛                                  | LOWER HALF INVERSE WHITE CIRCLE                                                                              |            | &amp;x25DB;   | x25DB  | 9691   | E2 97 9B    | FF FE DB 25       | So
◜                                  | UPPER LEFT QUADRANT CIRCULAR ARC                                                                             |            | &amp;x25DC;   | x25DC  | 9692   | E2 97 9C    | FF FE DC 25       | So
◝                                  | UPPER RIGHT QUADRANT CIRCULAR ARC                                                                            |            | &amp;x25DD;   | x25DD  | 9693   | E2 97 9D    | FF FE DD 25       | So
◞                                  | LOWER RIGHT QUADRANT CIRCULAR ARC                                                                            |            | &amp;x25DE;   | x25DE  | 9694   | E2 97 9E    | FF FE DE 25       | So
◟                                  | LOWER LEFT QUADRANT CIRCULAR ARC                                                                             |            | &amp;x25DF;   | x25DF  | 9695   | E2 97 9F    | FF FE DF 25       | So
◠                                  | UPPER HALF CIRCLE                                                                                            |            | &amp;x25E0;   | x25E0  | 9696   | E2 97 A0    | FF FE E0 25       | So
◡                                  | LOWER HALF CIRCLE                                                                                            |            | &amp;x25E1;   | x25E1  | 9697   | E2 97 A1    | FF FE E1 25       | So
◢                                  | BLACK LOWER RIGHT TRIANGLE                                                                                   | `Fd`       | &amp;x25E2;   | x25E2  | 9698   | E2 97 A2    | FF FE E2 25       | So
◣                                  | BLACK LOWER LEFT TRIANGLE                                                                                    | `Bd`       | &amp;x25E3;   | x25E3  | 9699   | E2 97 A3    | FF FE E3 25       | So
◤                                  | BLACK UPPER LEFT TRIANGLE                                                                                    |            | &amp;x25E4;   | x25E4  | 9700   | E2 97 A4    | FF FE E4 25       | So
◥                                  | BLACK UPPER RIGHT TRIANGLE                                                                                   |            | &amp;x25E5;   | x25E5  | 9701   | E2 97 A5    | FF FE E5 25       | So
◦                                  | WHITE BULLET                                                                                                 |            | &amp;x25E6;   | x25E6  | 9702   | E2 97 A6    | FF FE E6 25       | So
◧                                  | SQUARE WITH LEFT HALF BLACK                                                                                  |            | &amp;x25E7;   | x25E7  | 9703   | E2 97 A7    | FF FE E7 25       | So
◨                                  | SQUARE WITH RIGHT HALF BLACK                                                                                 |            | &amp;x25E8;   | x25E8  | 9704   | E2 97 A8    | FF FE E8 25       | So
◩                                  | SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK                                                                   |            | &amp;x25E9;   | x25E9  | 9705   | E2 97 A9    | FF FE E9 25       | So
◪                                  | SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK                                                                  |            | &amp;x25EA;   | x25EA  | 9706   | E2 97 AA    | FF FE EA 25       | So
◫                                  | WHITE SQUARE WITH VERTICAL BISECTING LINE                                                                    |            | &amp;x25EB;   | x25EB  | 9707   | E2 97 AB    | FF FE EB 25       | So
◬                                  | WHITE UP-POINTING TRIANGLE WITH DOT                                                                          |            | &amp;x25EC;   | x25EC  | 9708   | E2 97 AC    | FF FE EC 25       | So
◭                                  | UP-POINTING TRIANGLE WITH LEFT HALF BLACK                                                                    |            | &amp;x25ED;   | x25ED  | 9709   | E2 97 AD    | FF FE ED 25       | So
◮                                  | UP-POINTING TRIANGLE WITH RIGHT HALF BLACK                                                                   |            | &amp;x25EE;   | x25EE  | 9710   | E2 97 AE    | FF FE EE 25       | So
◯                                  | LARGE CIRCLE                                                                                                 |            | &amp;x25EF;   | x25EF  | 9711   | E2 97 AF    | FF FE EF 25       | So
◰                                  | WHITE SQUARE WITH UPPER LEFT QUADRANT                                                                        |            | &amp;x25F0;   | x25F0  | 9712   | E2 97 B0    | FF FE F0 25       | So
◱                                  | WHITE SQUARE WITH LOWER LEFT QUADRANT                                                                        |            | &amp;x25F1;   | x25F1  | 9713   | E2 97 B1    | FF FE F1 25       | So
◲                                  | WHITE SQUARE WITH LOWER RIGHT QUADRANT                                                                       |            | &amp;x25F2;   | x25F2  | 9714   | E2 97 B2    | FF FE F2 25       | So
◳                                  | WHITE SQUARE WITH UPPER RIGHT QUADRANT                                                                       |            | &amp;x25F3;   | x25F3  | 9715   | E2 97 B3    | FF FE F3 25       | So
◴                                  | WHITE CIRCLE WITH UPPER LEFT QUADRANT                                                                        |            | &amp;x25F4;   | x25F4  | 9716   | E2 97 B4    | FF FE F4 25       | So
◵                                  | WHITE CIRCLE WITH LOWER LEFT QUADRANT                                                                        |            | &amp;x25F5;   | x25F5  | 9717   | E2 97 B5    | FF FE F5 25       | So
◶                                  | WHITE CIRCLE WITH LOWER RIGHT QUADRANT                                                                       |            | &amp;x25F6;   | x25F6  | 9718   | E2 97 B6    | FF FE F6 25       | So
◷                                  | WHITE CIRCLE WITH UPPER RIGHT QUADRANT                                                                       |            | &amp;x25F7;   | x25F7  | 9719   | E2 97 B7    | FF FE F7 25       | So
◸                                  | UPPER LEFT TRIANGLE                                                                                          |            | &amp;x25F8;   | x25F8  | 9720   | E2 97 B8    | FF FE F8 25       | Sm
◹                                  | UPPER RIGHT TRIANGLE                                                                                         |            | &amp;x25F9;   | x25F9  | 9721   | E2 97 B9    | FF FE F9 25       | Sm
◺                                  | LOWER LEFT TRIANGLE                                                                                          |            | &amp;x25FA;   | x25FA  | 9722   | E2 97 BA    | FF FE FA 25       | Sm
◻                                  | WHITE MEDIUM SQUARE                                                                                          |            | &amp;x25FB;   | x25FB  | 9723   | E2 97 BB    | FF FE FB 25       | Sm
◼                                  | BLACK MEDIUM SQUARE                                                                                          |            | &amp;x25FC;   | x25FC  | 9724   | E2 97 BC    | FF FE FC 25       | Sm
◽                                  | WHITE MEDIUM SMALL SQUARE                                                                                    |            | &amp;x25FD;   | x25FD  | 9725   | E2 97 BD    | FF FE FD 25       | Sm
◾                                  | BLACK MEDIUM SMALL SQUARE                                                                                    |            | &amp;x25FE;   | x25FE  | 9726   | E2 97 BE    | FF FE FE 25       | Sm
◿                                  | LOWER RIGHT TRIANGLE                                                                                         |            | &amp;x25FF;   | x25FF  | 9727   | E2 97 BF    | FF FE FF 25       | Sm
☀                                  | BLACK SUN WITH RAYS                                                                                          |            | &amp;x2600;   | x2600  | 9728   | E2 98 80    | FF FE 00 26       | So
☁                                  | CLOUD                                                                                                        |            | &amp;x2601;   | x2601  | 9729   | E2 98 81    | FF FE 01 26       | So
☂                                  | UMBRELLA                                                                                                     |            | &amp;x2602;   | x2602  | 9730   | E2 98 82    | FF FE 02 26       | So
☃                                  | SNOWMAN                                                                                                      |            | &amp;x2603;   | x2603  | 9731   | E2 98 83    | FF FE 03 26       | So
☄                                  | COMET                                                                                                        |            | &amp;x2604;   | x2604  | 9732   | E2 98 84    | FF FE 04 26       | So
★                                  | BLACK STAR                                                                                                   | `*2`       | &amp;x2605;   | x2605  | 9733   | E2 98 85    | FF FE 05 26       | So
☆                                  | WHITE STAR                                                                                                   | `*1`       | &amp;x2606;   | x2606  | 9734   | E2 98 86    | FF FE 06 26       | So
<a id="ascii">*Section*</a>        | [**ASCII**](https://en.wikipedia.org/wiki/ASCII)                                                             |            |               |        |        |             |                   |
*n/a*                              | NULL (NUL)                                                                                                   | `NU`       | &amp;x0;      | x0     | 0      | 00          | FF FE 00 00       | Cc
*n/a*                              | START OF HEADING (SOH)                                                                                       | `SH`       | &amp;x1;      | x1     | 1      | 01          | FF FE 01 00       | Cc
*n/a*                              | START OF TEXT (STX)                                                                                          | `SX`       | &amp;x2;      | x2     | 2      | 02          | FF FE 02 00       | Cc
*n/a*                              | END OF TEXT (ETX)                                                                                            | `EX`       | &amp;x3;      | x3     | 3      | 03          | FF FE 03 00       | Cc
*n/a*                              | END OF TRANSMISSION (EOT)                                                                                    | `ET`       | &amp;x4;      | x4     | 4      | 04          | FF FE 04 00       | Cc
*n/a*                              | ENQUIRY (ENQ)                                                                                                | `EQ`       | &amp;x5;      | x5     | 5      | 05          | FF FE 05 00       | Cc
*n/a*                              | ACKNOWLEDGE (ACK)                                                                                            | `AK`       | &amp;x6;      | x6     | 6      | 06          | FF FE 06 00       | Cc
*n/a*                              | BELL (BEL)                                                                                                   | `BL`       | &amp;x7;      | x7     | 7      | 07          | FF FE 07 00       | Cc
*n/a*                              | BACKSPACE (BS)                                                                                               | `BS`       | &amp;x8;      | x8     | 8      | 08          | FF FE 08 00       | Cc
*n/a*                              | CHARACTER TABULATION (HT)                                                                                    | `HT`       | &amp;x9;      | x9     | 9      | 09          | FF FE 09 00       | Cc
*n/a*                              | LINE FEED (LF)                                                                                               | `LF`       | &amp;xA;      | xA     | 10     | 0A          | FF FE 0A 00       | Cc
*n/a*                              | LINE TABULATION (VT)                                                                                         | `VT`       | &amp;xB;      | xB     | 11     | 0B          | FF FE 0B 00       | Cc
*n/a*                              | FORM FEED (FF)                                                                                               | `FF`       | &amp;xC;      | xC     | 12     | 0C          | FF FE 0C 00       | Cc
*n/a*                              | CARRIAGE RETURN (CR)                                                                                         | `CR`       | &amp;xD;      | xD     | 13     | 0D          | FF FE 0D 00       | Cc
*n/a*                              | SHIFT OUT (SO)                                                                                               | `SO`       | &amp;xE;      | xE     | 14     | 0E          | FF FE 0E 00       | Cc
*n/a*                              | SHIFT IN (SI)                                                                                                | `SI`       | &amp;xF;      | xF     | 15     | 0F          | FF FE 0F 00       | Cc
*n/a*                              | DATALINK ESCAPE (DLE)                                                                                        | `DL`       | &amp;x10;     | x10    | 16     | 10          | FF FE 10 00       | Cc
*n/a*                              | DEVICE CONTROL ONE (DC1)                                                                                     | `D1`       | &amp;x11;     | x11    | 17     | 11          | FF FE 11 00       | Cc
*n/a*                              | DEVICE CONTROL TWO (DC2)                                                                                     | `D2`       | &amp;x12;     | x12    | 18     | 12          | FF FE 12 00       | Cc
*n/a*                              | DEVICE CONTROL THREE (DC3)                                                                                   | `D3`       | &amp;x13;     | x13    | 19     | 13          | FF FE 13 00       | Cc
*n/a*                              | DEVICE CONTROL FOUR (DC4)                                                                                    | `D4`       | &amp;x14;     | x14    | 20     | 14          | FF FE 14 00       | Cc
*n/a*                              | NEGATIVE ACKNOWLEDGE (NAK)                                                                                   | `NK`       | &amp;x15;     | x15    | 21     | 15          | FF FE 15 00       | Cc
*n/a*                              | SYNCHRONOUS IDLE (SYN)                                                                                       | `SY`       | &amp;x16;     | x16    | 22     | 16          | FF FE 16 00       | Cc
*n/a*                              | END OF TRANSMISSION BLOCK (ETB)                                                                              | `EB`       | &amp;x17;     | x17    | 23     | 17          | FF FE 17 00       | Cc
*n/a*                              | CANCEL (CAN)                                                                                                 | `CN`       | &amp;x18;     | x18    | 24     | 18          | FF FE 18 00       | Cc
*n/a*                              | END OF MEDIUM (EM)                                                                                           | `EM`       | &amp;x19;     | x19    | 25     | 19          | FF FE 19 00       | Cc
*n/a*                              | SUBSTITUTE (SUB)                                                                                             | `SB`       | &amp;x1A;     | x1A    | 26     | 1A          | FF FE 1A 00       | Cc
*n/a*                              | ESCAPE (ESC)                                                                                                 | `EC`       | &amp;x1B;     | x1B    | 27     | 1B          | FF FE 1B 00       | Cc
*n/a*                              | FILE SEPARATOR (IS4)                                                                                         | `FS`       | &amp;x1C;     | x1C    | 28     | 1C          | FF FE 1C 00       | Cc
*n/a*                              | GROUP SEPARATOR (IS3)                                                                                        | `GS`       | &amp;x1D;     | x1D    | 29     | 1D          | FF FE 1D 00       | Cc
*n/a*                              | RECORD SEPARATOR (IS2)                                                                                       | `RS`       | &amp;x1E;     | x1E    | 30     | 1E          | FF FE 1E 00       | Cc
*n/a*                              | UNIT SEPARATOR (IS1)                                                                                         | `US`       | &amp;x1F;     | x1F    | 31     | 1F          | FF FE 1F 00       | Cc
*n/a*                              | SPACE                                                                                                        | `SP`       | &amp;x20;     | x20    | 32     | 20          | FF FE 20 00       | Zs
\#                                 | NUMBER SIGN                                                                                                  | `Nb`       | &amp;x23;     | x23    | 35     | 23          | FF FE 23 00       | Po
$                                  | DOLLAR SIGN                                                                                                  | `DO`       | &amp;x24;     | x24    | 36     | 24          | FF FE 24 00       | Sc
@                                  | COMMERCIAL AT                                                                                                | `At`       | &amp;x40;     | x40    | 64     | 40          | FF FE 40 00       | Po
[                                  | LEFT SQUARE BRACKET                                                                                          | `<(`       | &amp;x5B;     | x5B    | 91     | 5B          | FF FE 5B 00       | Ps
\                                  | REVERSE SOLIDUS                                                                                              | `//`       | &amp;x5C;     | x5C    | 92     | 5C          | FF FE 5C 00       | Po
]                                  | RIGHT SQUARE BRACKET                                                                                         | `)>`       | &amp;x5D;     | x5D    | 93     | 5D          | FF FE 5D 00       | Pe
^                                  | CIRCUMFLEX ACCENT                                                                                            | `'>`       | &amp;x5E;     | x5E    | 94     | 5E          | FF FE 5E 00       | Sk
`                                  | GRAVE ACCENT                                                                                                 | `'!`       | &amp;x60;     | x60    | 96     | 60          | FF FE 60 00       | Sk
{                                  | LEFT CURLY BRACKET                                                                                           | `(!`       | &amp;x7B;     | x7B    | 123    | 7B          | FF FE 7B 00       | Ps
|                                  | VERTICAL LINE                                                                                                | `!!`       | &amp;x7C;     | x7C    | 124    | 7C          | FF FE 7C 00       | Sm
}                                  | RIGHT CURLY BRACKET                                                                                          | `!)`       | &amp;x7D;     | x7D    | 125    | 7D          | FF FE 7D 00       | Pe
~                                  | TILDE                                                                                                        | `'?`       | &amp;x7E;     | x7E    | 126    | 7E          | FF FE 7E 00       | Sm
*n/a*                              | DELETE (DEL)                                                                                                 | `DT`       | &amp;x7F;     | x7F    | 127    | 7F          | FF FE 7F 00       | Cc
*n/a*                              | PADDING CHARACTER (PAD)                                                                                      | `PA`       | &amp;x80;     | x80    | 128    | C2 80       | FF FE 80 00       | Cc
*n/a*                              | HIGH OCTET PRESET (HOP)                                                                                      | `HO`       | &amp;x81;     | x81    | 129    | C2 81       | FF FE 81 00       | Cc
*n/a*                              | BREAK PERMITTED HERE (BPH)                                                                                   | `BH`       | &amp;x82;     | x82    | 130    | C2 82       | FF FE 82 00       | Cc
*n/a*                              | NO BREAK HERE (NBH)                                                                                          | `NH`       | &amp;x83;     | x83    | 131    | C2 83       | FF FE 83 00       | Cc
*n/a*                              | INDEX (IND)                                                                                                  | `IN`       | &amp;x84;     | x84    | 132    | C2 84       | FF FE 84 00       | Cc
*n/a*                              | NEXT LINE (NEL)                                                                                              | `NL`       | &amp;x85;     | x85    | 133    | C2 85       | FF FE 85 00       | Cc
*n/a*                              | START OF SELECTED AREA (SSA)                                                                                 | `SA`       | &amp;x86;     | x86    | 134    | C2 86       | FF FE 86 00       | Cc
*n/a*                              | END OF SELECTED AREA (ESA)                                                                                   | `ES`       | &amp;x87;     | x87    | 135    | C2 87       | FF FE 87 00       | Cc
*n/a*                              | CHARACTER TABULATION SET (HTS)                                                                               | `HS`       | &amp;x88;     | x88    | 136    | C2 88       | FF FE 88 00       | Cc
*n/a*                              | CHARACTER TABULATION WITH JUSTIFICATION (HTJ)                                                                | `HJ`       | &amp;x89;     | x89    | 137    | C2 89       | FF FE 89 00       | Cc
*n/a*                              | LINE TABULATION SET (VTS)                                                                                    | `VS`       | &amp;x8A;     | x8A    | 138    | C2 8A       | FF FE 8A 00       | Cc
*n/a*                              | PARTIAL LINE FORWARD (PLD)                                                                                   | `PD`       | &amp;x8B;     | x8B    | 139    | C2 8B       | FF FE 8B 00       | Cc
*n/a*                              | PARTIAL LINE BACKWARD (PLU)                                                                                  | `PU`       | &amp;x8C;     | x8C    | 140    | C2 8C       | FF FE 8C 00       | Cc
*n/a*                              | REVERSE LINE FEED (RI)                                                                                       | `RI`       | &amp;x8D;     | x8D    | 141    | C2 8D       | FF FE 8D 00       | Cc
*n/a*                              | SINGLE-SHIFT TWO (SS2)                                                                                       | `S2`       | &amp;x8E;     | x8E    | 142    | C2 8E       | FF FE 8E 00       | Cc
*n/a*                              | SINGLE-SHIFT THREE (SS3)                                                                                     | `S3`       | &amp;x8F;     | x8F    | 143    | C2 8F       | FF FE 8F 00       | Cc
*n/a*                              | DEVICE CONTROL STRING (DCS)                                                                                  | `DC`       | &amp;x90;     | x90    | 144    | C2 90       | FF FE 90 00       | Cc
*n/a*                              | PRIVATE USE ONE (PU1)                                                                                        | `P1`       | &amp;x91;     | x91    | 145    | C2 91       | FF FE 91 00       | Cc
*n/a*                              | PRIVATE USE TWO (PU2)                                                                                        | `P2`       | &amp;x92;     | x92    | 146    | C2 92       | FF FE 92 00       | Cc
*n/a*                              | SET TRANSMIT STATE (STS)                                                                                     | `TS`       | &amp;x93;     | x93    | 147    | C2 93       | FF FE 93 00       | Cc
*n/a*                              | CANCEL CHARACTER (CCH)                                                                                       | `CC`       | &amp;x94;     | x94    | 148    | C2 94       | FF FE 94 00       | Cc
*n/a*                              | MESSAGE WAITING (MW)                                                                                         | `MW`       | &amp;x95;     | x95    | 149    | C2 95       | FF FE 95 00       | Cc
*n/a*                              | START OF GUARDED AREA (SPA)                                                                                  | `SG`       | &amp;x96;     | x96    | 150    | C2 96       | FF FE 96 00       | Cc
*n/a*                              | END OF GUARDED AREA (EPA)                                                                                    | `EG`       | &amp;x97;     | x97    | 151    | C2 97       | FF FE 97 00       | Cc
*n/a*                              | START OF STRING (SOS)                                                                                        | `SS`       | &amp;x98;     | x98    | 152    | C2 98       | FF FE 98 00       | Cc
*n/a*                              | SINGLE GRAPHIC CHARACTER INTRODUCER (SGCI)                                                                   | `GC`       | &amp;x99;     | x99    | 153    | C2 99       | FF FE 99 00       | Cc
*n/a*                              | SINGLE CHARACTER INTRODUCER (SCI)                                                                            | `SC`       | &amp;x9A;     | x9A    | 154    | C2 9A       | FF FE 9A 00       | Cc
*n/a*                              | CONTROL SEQUENCE INTRODUCER (CSI)                                                                            | `CI`       | &amp;x9B;     | x9B    | 155    | C2 9B       | FF FE 9B 00       | Cc
*n/a*                              | STRING TERMINATOR (ST)                                                                                       | `ST`       | &amp;x9C;     | x9C    | 156    | C2 9C       | FF FE 9C 00       | Cc
*n/a*                              | OPERATING SYSTEM COMMAND (OSC)                                                                               | `OC`       | &amp;x9D;     | x9D    | 157    | C2 9D       | FF FE 9D 00       | Cc
*n/a*                              | PRIVACY MESSAGE (PM)                                                                                         | `PM`       | &amp;x9E;     | x9E    | 158    | C2 9E       | FF FE 9E 00       | Cc
*n/a*                              | APPLICATION PROGRAM COMMAND (APC)                                                                            | `AC`       | &amp;x9F;     | x9F    | 159    | C2 9F       | FF FE 9F 00       | Cc
*Section*                          | <a id="music">**music**</a>                                                                                  |            |               |        |        |             |                   |
♩                                  | QUARTER NOTE                                                                                                 | `Md`       | &amp;x2669;   | x2669  | 9833   | E2 99 A9    | FF FE 69 26       | So
♪                                  | EIGHTH NOTE                                                                                                  | `M8`       | &amp;x266A;   | x266A  | 9834   | E2 99 AA    | FF FE 6A 26       | So
♫                                  | BEAMED EIGHTH NOTES                                                                                          | `M2`       | &amp;x266B;   | x266B  | 9835   | E2 99 AB    | FF FE 6B 26       | So
♬                                  | BEAMED SIXTEENTH NOTES                                                                                       |            | &amp;x266C;   | x266C  | 9836   | E2 99 AC    | FF FE 6C 26       | So
♭                                  | MUSIC FLAT SIGN                                                                                              | `Mb`       | &amp;x266D;   | x266D  | 9837   | E2 99 AD    | FF FE 6D 26       | So
♮                                  | MUSIC NATURAL SIGN                                                                                           | `Mx`       | &amp;x266E;   | x266E  | 9838   | E2 99 AE    | FF FE 6E 26       | So
♯                                  | MUSIC SHARP SIGN                                                                                             | `MX`       | &amp;x266F;   | x266F  | 9839   | E2 99 AF    | FF FE 6F 26       | Sm
*Section*                          | <a id="emoji">**emoji**</a>                                                                                  |            |               |        |        |             |                   |
✓                                  | CHECK MARK                                                                                                   | `OK`       | &amp;x2713;   | x2713  | 10003  | E2 9C 93    | FF FE 13 27       | So
✡                                  | STAR OF DAVID                                                                                                |            | &amp;x2721;   | x2721  | 10017  | E2 9C A1    | FF FE 21 27       | So
😺                                  | SMILING CAT FACE WITH OPEN MOUTH                                                                             |            | &amp;x1F63A;  | x1F63A | 128570 | F0 9F 98 BA | FF FE 3D D8 3A DE | So
🐱                                  | CAT FACE                                                                                                     |            | &amp;x1F431;  | x1F431 | 128049 | F0 9F 90 B1 | FF FE 3D D8 31 DC | So
💯                                  | HUNDRED POINTS SYMBOL                                                                                        |            | &amp;x1F4AF;  | x1F4AF | 128175 | F0 9F 92 AF | FF FE 3D D8 AF DC | So
<a id="vim">*Section*</a>          | [**Vim Digraphs**](https://vimhelp.org/digraph.txt.html)                                                     |            |               |        |        |             |                   |
*n/a*                              | NULL (NUL)                                                                                                   | `NU`       | &amp;x0;      | x0     | 0      | 00          | FF FE 00 00       | Cc
*n/a*                              | START OF HEADING (SOH)                                                                                       | `SH`       | &amp;x1;      | x1     | 1      | 01          | FF FE 01 00       | Cc
*n/a*                              | START OF TEXT (STX)                                                                                          | `SX`       | &amp;x2;      | x2     | 2      | 02          | FF FE 02 00       | Cc
*n/a*                              | END OF TEXT (ETX)                                                                                            | `EX`       | &amp;x3;      | x3     | 3      | 03          | FF FE 03 00       | Cc
*n/a*                              | END OF TRANSMISSION (EOT)                                                                                    | `ET`       | &amp;x4;      | x4     | 4      | 04          | FF FE 04 00       | Cc
*n/a*                              | ENQUIRY (ENQ)                                                                                                | `EQ`       | &amp;x5;      | x5     | 5      | 05          | FF FE 05 00       | Cc
*n/a*                              | ACKNOWLEDGE (ACK)                                                                                            | `AK`       | &amp;x6;      | x6     | 6      | 06          | FF FE 06 00       | Cc
*n/a*                              | BELL (BEL)                                                                                                   | `BL`       | &amp;x7;      | x7     | 7      | 07          | FF FE 07 00       | Cc
*n/a*                              | BACKSPACE (BS)                                                                                               | `BS`       | &amp;x8;      | x8     | 8      | 08          | FF FE 08 00       | Cc
*n/a*                              | CHARACTER TABULATION (HT)                                                                                    | `HT`       | &amp;x9;      | x9     | 9      | 09          | FF FE 09 00       | Cc
*n/a*                              | LINE FEED (LF)                                                                                               | `LF`       | &amp;xA;      | xA     | 10     | 0A          | FF FE 0A 00       | Cc
*n/a*                              | LINE TABULATION (VT)                                                                                         | `VT`       | &amp;xB;      | xB     | 11     | 0B          | FF FE 0B 00       | Cc
*n/a*                              | FORM FEED (FF)                                                                                               | `FF`       | &amp;xC;      | xC     | 12     | 0C          | FF FE 0C 00       | Cc
*n/a*                              | CARRIAGE RETURN (CR)                                                                                         | `CR`       | &amp;xD;      | xD     | 13     | 0D          | FF FE 0D 00       | Cc
*n/a*                              | SHIFT OUT (SO)                                                                                               | `SO`       | &amp;xE;      | xE     | 14     | 0E          | FF FE 0E 00       | Cc
*n/a*                              | SHIFT IN (SI)                                                                                                | `SI`       | &amp;xF;      | xF     | 15     | 0F          | FF FE 0F 00       | Cc
*n/a*                              | DATALINK ESCAPE (DLE)                                                                                        | `DL`       | &amp;x10;     | x10    | 16     | 10          | FF FE 10 00       | Cc
*n/a*                              | DEVICE CONTROL ONE (DC1)                                                                                     | `D1`       | &amp;x11;     | x11    | 17     | 11          | FF FE 11 00       | Cc
*n/a*                              | DEVICE CONTROL TWO (DC2)                                                                                     | `D2`       | &amp;x12;     | x12    | 18     | 12          | FF FE 12 00       | Cc
*n/a*                              | DEVICE CONTROL THREE (DC3)                                                                                   | `D3`       | &amp;x13;     | x13    | 19     | 13          | FF FE 13 00       | Cc
*n/a*                              | DEVICE CONTROL FOUR (DC4)                                                                                    | `D4`       | &amp;x14;     | x14    | 20     | 14          | FF FE 14 00       | Cc
*n/a*                              | NEGATIVE ACKNOWLEDGE (NAK)                                                                                   | `NK`       | &amp;x15;     | x15    | 21     | 15          | FF FE 15 00       | Cc
*n/a*                              | SYNCHRONOUS IDLE (SYN)                                                                                       | `SY`       | &amp;x16;     | x16    | 22     | 16          | FF FE 16 00       | Cc
*n/a*                              | END OF TRANSMISSION BLOCK (ETB)                                                                              | `EB`       | &amp;x17;     | x17    | 23     | 17          | FF FE 17 00       | Cc
*n/a*                              | CANCEL (CAN)                                                                                                 | `CN`       | &amp;x18;     | x18    | 24     | 18          | FF FE 18 00       | Cc
*n/a*                              | END OF MEDIUM (EM)                                                                                           | `EM`       | &amp;x19;     | x19    | 25     | 19          | FF FE 19 00       | Cc
*n/a*                              | SUBSTITUTE (SUB)                                                                                             | `SB`       | &amp;x1A;     | x1A    | 26     | 1A          | FF FE 1A 00       | Cc
*n/a*                              | ESCAPE (ESC)                                                                                                 | `EC`       | &amp;x1B;     | x1B    | 27     | 1B          | FF FE 1B 00       | Cc
*n/a*                              | FILE SEPARATOR (IS4)                                                                                         | `FS`       | &amp;x1C;     | x1C    | 28     | 1C          | FF FE 1C 00       | Cc
*n/a*                              | GROUP SEPARATOR (IS3)                                                                                        | `GS`       | &amp;x1D;     | x1D    | 29     | 1D          | FF FE 1D 00       | Cc
*n/a*                              | RECORD SEPARATOR (IS2)                                                                                       | `RS`       | &amp;x1E;     | x1E    | 30     | 1E          | FF FE 1E 00       | Cc
*n/a*                              | UNIT SEPARATOR (IS1)                                                                                         | `US`       | &amp;x1F;     | x1F    | 31     | 1F          | FF FE 1F 00       | Cc
*n/a*                              | SPACE                                                                                                        | `SP`       | &amp;x20;     | x20    | 32     | 20          | FF FE 20 00       | Zs
\#                                 | NUMBER SIGN                                                                                                  | `Nb`       | &amp;x23;     | x23    | 35     | 23          | FF FE 23 00       | Po
$                                  | DOLLAR SIGN                                                                                                  | `DO`       | &amp;x24;     | x24    | 36     | 24          | FF FE 24 00       | Sc
@                                  | COMMERCIAL AT                                                                                                | `At`       | &amp;x40;     | x40    | 64     | 40          | FF FE 40 00       | Po
[                                  | LEFT SQUARE BRACKET                                                                                          | `<(`       | &amp;x5B;     | x5B    | 91     | 5B          | FF FE 5B 00       | Ps
\                                  | REVERSE SOLIDUS                                                                                              | `//`       | &amp;x5C;     | x5C    | 92     | 5C          | FF FE 5C 00       | Po
]                                  | RIGHT SQUARE BRACKET                                                                                         | `)>`       | &amp;x5D;     | x5D    | 93     | 5D          | FF FE 5D 00       | Pe
^                                  | CIRCUMFLEX ACCENT                                                                                            | `'>`       | &amp;x5E;     | x5E    | 94     | 5E          | FF FE 5E 00       | Sk
`                                  | GRAVE ACCENT                                                                                                 | `'!`       | &amp;x60;     | x60    | 96     | 60          | FF FE 60 00       | Sk
{                                  | LEFT CURLY BRACKET                                                                                           | `(!`       | &amp;x7B;     | x7B    | 123    | 7B          | FF FE 7B 00       | Ps
|                                  | VERTICAL LINE                                                                                                | `!!`       | &amp;x7C;     | x7C    | 124    | 7C          | FF FE 7C 00       | Sm
}                                  | RIGHT CURLY BRACKET                                                                                          | `!)`       | &amp;x7D;     | x7D    | 125    | 7D          | FF FE 7D 00       | Pe
~                                  | TILDE                                                                                                        | `'?`       | &amp;x7E;     | x7E    | 126    | 7E          | FF FE 7E 00       | Sm
*n/a*                              | DELETE (DEL)                                                                                                 | `DT`       | &amp;x7F;     | x7F    | 127    | 7F          | FF FE 7F 00       | Cc
*n/a*                              | PADDING CHARACTER (PAD)                                                                                      | `PA`       | &amp;x80;     | x80    | 128    | C2 80       | FF FE 80 00       | Cc
*n/a*                              | HIGH OCTET PRESET (HOP)                                                                                      | `HO`       | &amp;x81;     | x81    | 129    | C2 81       | FF FE 81 00       | Cc
*n/a*                              | BREAK PERMITTED HERE (BPH)                                                                                   | `BH`       | &amp;x82;     | x82    | 130    | C2 82       | FF FE 82 00       | Cc
*n/a*                              | NO BREAK HERE (NBH)                                                                                          | `NH`       | &amp;x83;     | x83    | 131    | C2 83       | FF FE 83 00       | Cc
*n/a*                              | INDEX (IND)                                                                                                  | `IN`       | &amp;x84;     | x84    | 132    | C2 84       | FF FE 84 00       | Cc
*n/a*                              | NEXT LINE (NEL)                                                                                              | `NL`       | &amp;x85;     | x85    | 133    | C2 85       | FF FE 85 00       | Cc
*n/a*                              | START OF SELECTED AREA (SSA)                                                                                 | `SA`       | &amp;x86;     | x86    | 134    | C2 86       | FF FE 86 00       | Cc
*n/a*                              | END OF SELECTED AREA (ESA)                                                                                   | `ES`       | &amp;x87;     | x87    | 135    | C2 87       | FF FE 87 00       | Cc
*n/a*                              | CHARACTER TABULATION SET (HTS)                                                                               | `HS`       | &amp;x88;     | x88    | 136    | C2 88       | FF FE 88 00       | Cc
*n/a*                              | CHARACTER TABULATION WITH JUSTIFICATION (HTJ)                                                                | `HJ`       | &amp;x89;     | x89    | 137    | C2 89       | FF FE 89 00       | Cc
*n/a*                              | LINE TABULATION SET (VTS)                                                                                    | `VS`       | &amp;x8A;     | x8A    | 138    | C2 8A       | FF FE 8A 00       | Cc
*n/a*                              | PARTIAL LINE FORWARD (PLD)                                                                                   | `PD`       | &amp;x8B;     | x8B    | 139    | C2 8B       | FF FE 8B 00       | Cc
*n/a*                              | PARTIAL LINE BACKWARD (PLU)                                                                                  | `PU`       | &amp;x8C;     | x8C    | 140    | C2 8C       | FF FE 8C 00       | Cc
*n/a*                              | REVERSE LINE FEED (RI)                                                                                       | `RI`       | &amp;x8D;     | x8D    | 141    | C2 8D       | FF FE 8D 00       | Cc
*n/a*                              | SINGLE-SHIFT TWO (SS2)                                                                                       | `S2`       | &amp;x8E;     | x8E    | 142    | C2 8E       | FF FE 8E 00       | Cc
*n/a*                              | SINGLE-SHIFT THREE (SS3)                                                                                     | `S3`       | &amp;x8F;     | x8F    | 143    | C2 8F       | FF FE 8F 00       | Cc
*n/a*                              | DEVICE CONTROL STRING (DCS)                                                                                  | `DC`       | &amp;x90;     | x90    | 144    | C2 90       | FF FE 90 00       | Cc
*n/a*                              | PRIVATE USE ONE (PU1)                                                                                        | `P1`       | &amp;x91;     | x91    | 145    | C2 91       | FF FE 91 00       | Cc
*n/a*                              | PRIVATE USE TWO (PU2)                                                                                        | `P2`       | &amp;x92;     | x92    | 146    | C2 92       | FF FE 92 00       | Cc
*n/a*                              | SET TRANSMIT STATE (STS)                                                                                     | `TS`       | &amp;x93;     | x93    | 147    | C2 93       | FF FE 93 00       | Cc
*n/a*                              | CANCEL CHARACTER (CCH)                                                                                       | `CC`       | &amp;x94;     | x94    | 148    | C2 94       | FF FE 94 00       | Cc
*n/a*                              | MESSAGE WAITING (MW)                                                                                         | `MW`       | &amp;x95;     | x95    | 149    | C2 95       | FF FE 95 00       | Cc
*n/a*                              | START OF GUARDED AREA (SPA)                                                                                  | `SG`       | &amp;x96;     | x96    | 150    | C2 96       | FF FE 96 00       | Cc
*n/a*                              | END OF GUARDED AREA (EPA)                                                                                    | `EG`       | &amp;x97;     | x97    | 151    | C2 97       | FF FE 97 00       | Cc
*n/a*                              | START OF STRING (SOS)                                                                                        | `SS`       | &amp;x98;     | x98    | 152    | C2 98       | FF FE 98 00       | Cc
*n/a*                              | SINGLE GRAPHIC CHARACTER INTRODUCER (SGCI)                                                                   | `GC`       | &amp;x99;     | x99    | 153    | C2 99       | FF FE 99 00       | Cc
*n/a*                              | SINGLE CHARACTER INTRODUCER (SCI)                                                                            | `SC`       | &amp;x9A;     | x9A    | 154    | C2 9A       | FF FE 9A 00       | Cc
*n/a*                              | CONTROL SEQUENCE INTRODUCER (CSI)                                                                            | `CI`       | &amp;x9B;     | x9B    | 155    | C2 9B       | FF FE 9B 00       | Cc
*n/a*                              | STRING TERMINATOR (ST)                                                                                       | `ST`       | &amp;x9C;     | x9C    | 156    | C2 9C       | FF FE 9C 00       | Cc
*n/a*                              | OPERATING SYSTEM COMMAND (OSC)                                                                               | `OC`       | &amp;x9D;     | x9D    | 157    | C2 9D       | FF FE 9D 00       | Cc
*n/a*                              | PRIVACY MESSAGE (PM)                                                                                         | `PM`       | &amp;x9E;     | x9E    | 158    | C2 9E       | FF FE 9E 00       | Cc
*n/a*                              | APPLICATION PROGRAM COMMAND (APC)                                                                            | `AC`       | &amp;x9F;     | x9F    | 159    | C2 9F       | FF FE 9F 00       | Cc
                                   | NO-BREAK SPACE                                                                                               | `NS`       | &amp;nbsp;    | xA0    | 160    | C2 A0       | FF FE A0 00       | Zs
¡                                  | INVERTED EXCLAMATION MARK                                                                                    | `!I`       | &amp;iexcl;   | xA1    | 161    | C2 A1       | FF FE A1 00       | Po
¢                                  | CENT SIGN                                                                                                    | `Ct`       | &amp;cent;    | xA2    | 162    | C2 A2       | FF FE A2 00       | Sc
£                                  | POUND SIGN                                                                                                   | `Pd`       | &amp;pound;   | xA3    | 163    | C2 A3       | FF FE A3 00       | Sc
¤                                  | CURRENCY SIGN                                                                                                | `Cu`       | &amp;curren;  | xA4    | 164    | C2 A4       | FF FE A4 00       | Sc
¥                                  | YEN SIGN                                                                                                     | `Ye`       | &amp;yen;     | xA5    | 165    | C2 A5       | FF FE A5 00       | Sc
¦                                  | BROKEN BAR                                                                                                   | `BB`       | &amp;brvbar;  | xA6    | 166    | C2 A6       | FF FE A6 00       | So
§                                  | SECTION SIGN                                                                                                 | `SE`       | &amp;sect;    | xA7    | 167    | C2 A7       | FF FE A7 00       | Po
¨                                  | DIAERESIS                                                                                                    | `':`       | &amp;uml;     | xA8    | 168    | C2 A8       | FF FE A8 00       | Sk
©                                  | COPYRIGHT SIGN                                                                                               | `Co`       | &amp;copy;    | xA9    | 169    | C2 A9       | FF FE A9 00       | So
ª                                  | FEMININE ORDINAL INDICATOR                                                                                   | `-a`       | &amp;ordf;    | xAA    | 170    | C2 AA       | FF FE AA 00       | Lo
«                                  | LEFT-POINTING DOUBLE ANGLE QUOTATION MARK                                                                    | `<<`       | &amp;laquo;   | xAB    | 171    | C2 AB       | FF FE AB 00       | Pi
¬                                  | NOT SIGN                                                                                                     | `NO`       | &amp;not;     | xAC    | 172    | C2 AC       | FF FE AC 00       | Sm
*n/a*                              | SOFT HYPHEN                                                                                                  | `--`       | &amp;shy;     | xAD    | 173    | C2 AD       | FF FE AD 00       | Cf
®                                  | REGISTERED SIGN                                                                                              | `Rg`       | &amp;reg;     | xAE    | 174    | C2 AE       | FF FE AE 00       | So
¯                                  | MACRON                                                                                                       | `'m`       | &amp;macr;    | xAF    | 175    | C2 AF       | FF FE AF 00       | Sk
°                                  | DEGREE SIGN                                                                                                  | `DG`       | &amp;deg;     | xB0    | 176    | C2 B0       | FF FE B0 00       | So
±                                  | PLUS-MINUS SIGN                                                                                              | `+-`       | &amp;plusmn;  | xB1    | 177    | C2 B1       | FF FE B1 00       | Sm
²                                  | SUPERSCRIPT TWO                                                                                              | `2S`       | &amp;sup2;    | xB2    | 178    | C2 B2       | FF FE B2 00       | No
³                                  | SUPERSCRIPT THREE                                                                                            | `3S`       | &amp;sup3;    | xB3    | 179    | C2 B3       | FF FE B3 00       | No
´                                  | ACUTE ACCENT                                                                                                 | `''`       | &amp;acute;   | xB4    | 180    | C2 B4       | FF FE B4 00       | Sk
µ                                  | MICRO SIGN                                                                                                   | `My`       | &amp;micro;   | xB5    | 181    | C2 B5       | FF FE B5 00       | Ll
¶                                  | PILCROW SIGN                                                                                                 | `PI`       | &amp;para;    | xB6    | 182    | C2 B6       | FF FE B6 00       | Po
·                                  | MIDDLE DOT                                                                                                   | `.M`       | &amp;middot;  | xB7    | 183    | C2 B7       | FF FE B7 00       | Po
¸                                  | CEDILLA                                                                                                      | `',`       | &amp;cedil;   | xB8    | 184    | C2 B8       | FF FE B8 00       | Sk
¹                                  | SUPERSCRIPT ONE                                                                                              | `1S`       | &amp;sup1;    | xB9    | 185    | C2 B9       | FF FE B9 00       | No
º                                  | MASCULINE ORDINAL INDICATOR                                                                                  | `-o`       | &amp;ordm;    | xBA    | 186    | C2 BA       | FF FE BA 00       | Lo
»                                  | RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK                                                                   | `>>`       | &amp;raquo;   | xBB    | 187    | C2 BB       | FF FE BB 00       | Pf
¼                                  | VULGAR FRACTION ONE QUARTER                                                                                  | `14`       | &amp;frac14;  | xBC    | 188    | C2 BC       | FF FE BC 00       | No
½                                  | VULGAR FRACTION ONE HALF                                                                                     | `12`       | &amp;frac12;  | xBD    | 189    | C2 BD       | FF FE BD 00       | No
¾                                  | VULGAR FRACTION THREE QUARTERS                                                                               | `34`       | &amp;frac34;  | xBE    | 190    | C2 BE       | FF FE BE 00       | No
¿                                  | INVERTED QUESTION MARK                                                                                       | `?I`       | &amp;iquest;  | xBF    | 191    | C2 BF       | FF FE BF 00       | Po
À                                  | LATIN CAPITAL LETTER A WITH GRAVE                                                                            | `A!`       | &amp;Agrave;  | xC0    | 192    | C3 80       | FF FE C0 00       | Lu
Á                                  | LATIN CAPITAL LETTER A WITH ACUTE                                                                            | `A'`       | &amp;Aacute;  | xC1    | 193    | C3 81       | FF FE C1 00       | Lu
Â                                  | LATIN CAPITAL LETTER A WITH CIRCUMFLEX                                                                       | `A>`       | &amp;Acirc;   | xC2    | 194    | C3 82       | FF FE C2 00       | Lu
Ã                                  | LATIN CAPITAL LETTER A WITH TILDE                                                                            | `A?`       | &amp;Atilde;  | xC3    | 195    | C3 83       | FF FE C3 00       | Lu
Ä                                  | LATIN CAPITAL LETTER A WITH DIAERESIS                                                                        | `A:`       | &amp;Auml;    | xC4    | 196    | C3 84       | FF FE C4 00       | Lu
Å                                  | LATIN CAPITAL LETTER A WITH RING ABOVE                                                                       | `AA`       | &amp;Aring;   | xC5    | 197    | C3 85       | FF FE C5 00       | Lu
Æ                                  | LATIN CAPITAL LETTER AE                                                                                      | `AE`       | &amp;AElig;   | xC6    | 198    | C3 86       | FF FE C6 00       | Lu
Ç                                  | LATIN CAPITAL LETTER C WITH CEDILLA                                                                          | `C,`       | &amp;Ccedil;  | xC7    | 199    | C3 87       | FF FE C7 00       | Lu
È                                  | LATIN CAPITAL LETTER E WITH GRAVE                                                                            | `E!`       | &amp;Egrave;  | xC8    | 200    | C3 88       | FF FE C8 00       | Lu
É                                  | LATIN CAPITAL LETTER E WITH ACUTE                                                                            | `E'`       | &amp;Eacute;  | xC9    | 201    | C3 89       | FF FE C9 00       | Lu
Ê                                  | LATIN CAPITAL LETTER E WITH CIRCUMFLEX                                                                       | `E>`       | &amp;Ecirc;   | xCA    | 202    | C3 8A       | FF FE CA 00       | Lu
Ë                                  | LATIN CAPITAL LETTER E WITH DIAERESIS                                                                        | `E:`       | &amp;Euml;    | xCB    | 203    | C3 8B       | FF FE CB 00       | Lu
Ì                                  | LATIN CAPITAL LETTER I WITH GRAVE                                                                            | `I!`       | &amp;Igrave;  | xCC    | 204    | C3 8C       | FF FE CC 00       | Lu
Í                                  | LATIN CAPITAL LETTER I WITH ACUTE                                                                            | `I'`       | &amp;Iacute;  | xCD    | 205    | C3 8D       | FF FE CD 00       | Lu
Î                                  | LATIN CAPITAL LETTER I WITH CIRCUMFLEX                                                                       | `I>`       | &amp;Icirc;   | xCE    | 206    | C3 8E       | FF FE CE 00       | Lu
Ï                                  | LATIN CAPITAL LETTER I WITH DIAERESIS                                                                        | `I:`       | &amp;Iuml;    | xCF    | 207    | C3 8F       | FF FE CF 00       | Lu
Ð                                  | LATIN CAPITAL LETTER ETH (Icelandic)                                                                         | `D-`       | &amp;ETH;     | xD0    | 208    | C3 90       | FF FE D0 00       | Lu
Ñ                                  | LATIN CAPITAL LETTER N WITH TILDE                                                                            | `N?`       | &amp;Ntilde;  | xD1    | 209    | C3 91       | FF FE D1 00       | Lu
Ò                                  | LATIN CAPITAL LETTER O WITH GRAVE                                                                            | `O!`       | &amp;Ograve;  | xD2    | 210    | C3 92       | FF FE D2 00       | Lu
Ó                                  | LATIN CAPITAL LETTER O WITH ACUTE                                                                            | `O'`       | &amp;Oacute;  | xD3    | 211    | C3 93       | FF FE D3 00       | Lu
Ô                                  | LATIN CAPITAL LETTER O WITH CIRCUMFLEX                                                                       | `O>`       | &amp;Ocirc;   | xD4    | 212    | C3 94       | FF FE D4 00       | Lu
Õ                                  | LATIN CAPITAL LETTER O WITH TILDE                                                                            | `O?`       | &amp;Otilde;  | xD5    | 213    | C3 95       | FF FE D5 00       | Lu
Ö                                  | LATIN CAPITAL LETTER O WITH DIAERESIS                                                                        | `O:`       | &amp;Ouml;    | xD6    | 214    | C3 96       | FF FE D6 00       | Lu
×                                  | MULTIPLICATION SIGN                                                                                          | `*X`       | &amp;times;   | xD7    | 215    | C3 97       | FF FE D7 00       | Sm
Ø                                  | LATIN CAPITAL LETTER O WITH STROKE                                                                           | `O/`       | &amp;Oslash;  | xD8    | 216    | C3 98       | FF FE D8 00       | Lu
Ù                                  | LATIN CAPITAL LETTER U WITH GRAVE                                                                            | `U!`       | &amp;Ugrave;  | xD9    | 217    | C3 99       | FF FE D9 00       | Lu
Ú                                  | LATIN CAPITAL LETTER U WITH ACUTE                                                                            | `U'`       | &amp;Uacute;  | xDA    | 218    | C3 9A       | FF FE DA 00       | Lu
Û                                  | LATIN CAPITAL LETTER U WITH CIRCUMFLEX                                                                       | `U>`       | &amp;Ucirc;   | xDB    | 219    | C3 9B       | FF FE DB 00       | Lu
Ü                                  | LATIN CAPITAL LETTER U WITH DIAERESIS                                                                        | `U:`       | &amp;Uuml;    | xDC    | 220    | C3 9C       | FF FE DC 00       | Lu
Ý                                  | LATIN CAPITAL LETTER Y WITH ACUTE                                                                            | `Y'`       | &amp;Yacute;  | xDD    | 221    | C3 9D       | FF FE DD 00       | Lu
Þ                                  | LATIN CAPITAL LETTER THORN (Icelandic)                                                                       | `TH`       | &amp;THORN;   | xDE    | 222    | C3 9E       | FF FE DE 00       | Lu
ß                                  | LATIN SMALL LETTER SHARP S (German)                                                                          | `ss`       | &amp;szlig;   | xDF    | 223    | C3 9F       | FF FE DF 00       | Ll
à                                  | LATIN SMALL LETTER A WITH GRAVE                                                                              | `a!`       | &amp;agrave;  | xE0    | 224    | C3 A0       | FF FE E0 00       | Ll
á                                  | LATIN SMALL LETTER A WITH ACUTE                                                                              | `a'`       | &amp;aacute;  | xE1    | 225    | C3 A1       | FF FE E1 00       | Ll
â                                  | LATIN SMALL LETTER A WITH CIRCUMFLEX                                                                         | `a>`       | &amp;acirc;   | xE2    | 226    | C3 A2       | FF FE E2 00       | Ll
ã                                  | LATIN SMALL LETTER A WITH TILDE                                                                              | `a?`       | &amp;atilde;  | xE3    | 227    | C3 A3       | FF FE E3 00       | Ll
ä                                  | LATIN SMALL LETTER A WITH DIAERESIS                                                                          | `a:`       | &amp;auml;    | xE4    | 228    | C3 A4       | FF FE E4 00       | Ll
å                                  | LATIN SMALL LETTER A WITH RING ABOVE                                                                         | `aa`       | &amp;aring;   | xE5    | 229    | C3 A5       | FF FE E5 00       | Ll
æ                                  | LATIN SMALL LETTER AE                                                                                        | `ae`       | &amp;aelig;   | xE6    | 230    | C3 A6       | FF FE E6 00       | Ll
ç                                  | LATIN SMALL LETTER C WITH CEDILLA                                                                            | `c,`       | &amp;ccedil;  | xE7    | 231    | C3 A7       | FF FE E7 00       | Ll
è                                  | LATIN SMALL LETTER E WITH GRAVE                                                                              | `e!`       | &amp;egrave;  | xE8    | 232    | C3 A8       | FF FE E8 00       | Ll
é                                  | LATIN SMALL LETTER E WITH ACUTE                                                                              | `e'`       | &amp;eacute;  | xE9    | 233    | C3 A9       | FF FE E9 00       | Ll
ê                                  | LATIN SMALL LETTER E WITH CIRCUMFLEX                                                                         | `e>`       | &amp;ecirc;   | xEA    | 234    | C3 AA       | FF FE EA 00       | Ll
ë                                  | LATIN SMALL LETTER E WITH DIAERESIS                                                                          | `e:`       | &amp;euml;    | xEB    | 235    | C3 AB       | FF FE EB 00       | Ll
ì                                  | LATIN SMALL LETTER I WITH GRAVE                                                                              | `i!`       | &amp;igrave;  | xEC    | 236    | C3 AC       | FF FE EC 00       | Ll
í                                  | LATIN SMALL LETTER I WITH ACUTE                                                                              | `i'`       | &amp;iacute;  | xED    | 237    | C3 AD       | FF FE ED 00       | Ll
î                                  | LATIN SMALL LETTER I WITH CIRCUMFLEX                                                                         | `i>`       | &amp;icirc;   | xEE    | 238    | C3 AE       | FF FE EE 00       | Ll
ï                                  | LATIN SMALL LETTER I WITH DIAERESIS                                                                          | `i:`       | &amp;iuml;    | xEF    | 239    | C3 AF       | FF FE EF 00       | Ll
ð                                  | LATIN SMALL LETTER ETH (Icelandic)                                                                           | `d-`       | &amp;eth;     | xF0    | 240    | C3 B0       | FF FE F0 00       | Ll
ñ                                  | LATIN SMALL LETTER N WITH TILDE                                                                              | `n?`       | &amp;ntilde;  | xF1    | 241    | C3 B1       | FF FE F1 00       | Ll
ò                                  | LATIN SMALL LETTER O WITH GRAVE                                                                              | `o!`       | &amp;ograve;  | xF2    | 242    | C3 B2       | FF FE F2 00       | Ll
ó                                  | LATIN SMALL LETTER O WITH ACUTE                                                                              | `o'`       | &amp;oacute;  | xF3    | 243    | C3 B3       | FF FE F3 00       | Ll
ô                                  | LATIN SMALL LETTER O WITH CIRCUMFLEX                                                                         | `o>`       | &amp;ocirc;   | xF4    | 244    | C3 B4       | FF FE F4 00       | Ll
õ                                  | LATIN SMALL LETTER O WITH TILDE                                                                              | `o?`       | &amp;otilde;  | xF5    | 245    | C3 B5       | FF FE F5 00       | Ll
ö                                  | LATIN SMALL LETTER O WITH DIAERESIS                                                                          | `o:`       | &amp;ouml;    | xF6    | 246    | C3 B6       | FF FE F6 00       | Ll
÷                                  | DIVISION SIGN                                                                                                | `-:`       | &amp;divide;  | xF7    | 247    | C3 B7       | FF FE F7 00       | Sm
ø                                  | LATIN SMALL LETTER O WITH STROKE                                                                             | `o/`       | &amp;oslash;  | xF8    | 248    | C3 B8       | FF FE F8 00       | Ll
ù                                  | LATIN SMALL LETTER U WITH GRAVE                                                                              | `u!`       | &amp;ugrave;  | xF9    | 249    | C3 B9       | FF FE F9 00       | Ll
ú                                  | LATIN SMALL LETTER U WITH ACUTE                                                                              | `u'`       | &amp;uacute;  | xFA    | 250    | C3 BA       | FF FE FA 00       | Ll
û                                  | LATIN SMALL LETTER U WITH CIRCUMFLEX                                                                         | `u>`       | &amp;ucirc;   | xFB    | 251    | C3 BB       | FF FE FB 00       | Ll
ü                                  | LATIN SMALL LETTER U WITH DIAERESIS                                                                          | `u:`       | &amp;uuml;    | xFC    | 252    | C3 BC       | FF FE FC 00       | Ll
ý                                  | LATIN SMALL LETTER Y WITH ACUTE                                                                              | `y'`       | &amp;yacute;  | xFD    | 253    | C3 BD       | FF FE FD 00       | Ll
þ                                  | LATIN SMALL LETTER THORN (Icelandic)                                                                         | `th`       | &amp;thorn;   | xFE    | 254    | C3 BE       | FF FE FE 00       | Ll
ÿ                                  | LATIN SMALL LETTER Y WITH DIAERESIS                                                                          | `y:`       | &amp;yuml;    | xFF    | 255    | C3 BF       | FF FE FF 00       | Ll
Ā                                  | LATIN CAPITAL LETTER A WITH MACRON                                                                           | `A-`       | &amp;x100;    | x100   | 256    | C4 80       | FF FE 00 01       | Lu
ā                                  | LATIN SMALL LETTER A WITH MACRON                                                                             | `a-`       | &amp;x101;    | x101   | 257    | C4 81       | FF FE 01 01       | Ll
Ă                                  | LATIN CAPITAL LETTER A WITH BREVE                                                                            | `A(`       | &amp;x102;    | x102   | 258    | C4 82       | FF FE 02 01       | Lu
ă                                  | LATIN SMALL LETTER A WITH BREVE                                                                              | `a(`       | &amp;x103;    | x103   | 259    | C4 83       | FF FE 03 01       | Ll
Ą                                  | LATIN CAPITAL LETTER A WITH OGONEK                                                                           | `A;`       | &amp;x104;    | x104   | 260    | C4 84       | FF FE 04 01       | Lu
ą                                  | LATIN SMALL LETTER A WITH OGONEK                                                                             | `a;`       | &amp;x105;    | x105   | 261    | C4 85       | FF FE 05 01       | Ll
Ć                                  | LATIN CAPITAL LETTER C WITH ACUTE                                                                            | `C'`       | &amp;x106;    | x106   | 262    | C4 86       | FF FE 06 01       | Lu
ć                                  | LATIN SMALL LETTER C WITH ACUTE                                                                              | `c'`       | &amp;x107;    | x107   | 263    | C4 87       | FF FE 07 01       | Ll
Ĉ                                  | LATIN CAPITAL LETTER C WITH CIRCUMFLEX                                                                       | `C>`       | &amp;x108;    | x108   | 264    | C4 88       | FF FE 08 01       | Lu
ĉ                                  | LATIN SMALL LETTER C WITH CIRCUMFLEX                                                                         | `c>`       | &amp;x109;    | x109   | 265    | C4 89       | FF FE 09 01       | Ll
Ċ                                  | LATIN CAPITAL LETTER C WITH DOT ABOVE                                                                        | `C.`       | &amp;x10A;    | x10A   | 266    | C4 8A       | FF FE 0A 01       | Lu
ċ                                  | LATIN SMALL LETTER C WITH DOT ABOVE                                                                          | `c.`       | &amp;x10B;    | x10B   | 267    | C4 8B       | FF FE 0B 01       | Ll
Č                                  | LATIN CAPITAL LETTER C WITH CARON                                                                            | `C<`       | &amp;x10C;    | x10C   | 268    | C4 8C       | FF FE 0C 01       | Lu
č                                  | LATIN SMALL LETTER C WITH CARON                                                                              | `c<`       | &amp;x10D;    | x10D   | 269    | C4 8D       | FF FE 0D 01       | Ll
Ď                                  | LATIN CAPITAL LETTER D WITH CARON                                                                            | `D<`       | &amp;x10E;    | x10E   | 270    | C4 8E       | FF FE 0E 01       | Lu
ď                                  | LATIN SMALL LETTER D WITH CARON                                                                              | `d<`       | &amp;x10F;    | x10F   | 271    | C4 8F       | FF FE 0F 01       | Ll
Đ                                  | LATIN CAPITAL LETTER D WITH STROKE                                                                           | `D/`       | &amp;x110;    | x110   | 272    | C4 90       | FF FE 10 01       | Lu
đ                                  | LATIN SMALL LETTER D WITH STROKE                                                                             | `d/`       | &amp;x111;    | x111   | 273    | C4 91       | FF FE 11 01       | Ll
Ē                                  | LATIN CAPITAL LETTER E WITH MACRON                                                                           | `E-`       | &amp;x112;    | x112   | 274    | C4 92       | FF FE 12 01       | Lu
ē                                  | LATIN SMALL LETTER E WITH MACRON                                                                             | `e-`       | &amp;x113;    | x113   | 275    | C4 93       | FF FE 13 01       | Ll
Ĕ                                  | LATIN CAPITAL LETTER E WITH BREVE                                                                            | `E(`       | &amp;x114;    | x114   | 276    | C4 94       | FF FE 14 01       | Lu
ĕ                                  | LATIN SMALL LETTER E WITH BREVE                                                                              | `e(`       | &amp;x115;    | x115   | 277    | C4 95       | FF FE 15 01       | Ll
Ė                                  | LATIN CAPITAL LETTER E WITH DOT ABOVE                                                                        | `E.`       | &amp;x116;    | x116   | 278    | C4 96       | FF FE 16 01       | Lu
ė                                  | LATIN SMALL LETTER E WITH DOT ABOVE                                                                          | `e.`       | &amp;x117;    | x117   | 279    | C4 97       | FF FE 17 01       | Ll
Ę                                  | LATIN CAPITAL LETTER E WITH OGONEK                                                                           | `E;`       | &amp;x118;    | x118   | 280    | C4 98       | FF FE 18 01       | Lu
ę                                  | LATIN SMALL LETTER E WITH OGONEK                                                                             | `e;`       | &amp;x119;    | x119   | 281    | C4 99       | FF FE 19 01       | Ll
Ě                                  | LATIN CAPITAL LETTER E WITH CARON                                                                            | `E<`       | &amp;x11A;    | x11A   | 282    | C4 9A       | FF FE 1A 01       | Lu
ě                                  | LATIN SMALL LETTER E WITH CARON                                                                              | `e<`       | &amp;x11B;    | x11B   | 283    | C4 9B       | FF FE 1B 01       | Ll
Ĝ                                  | LATIN CAPITAL LETTER G WITH CIRCUMFLEX                                                                       | `G>`       | &amp;x11C;    | x11C   | 284    | C4 9C       | FF FE 1C 01       | Lu
ĝ                                  | LATIN SMALL LETTER G WITH CIRCUMFLEX                                                                         | `g>`       | &amp;x11D;    | x11D   | 285    | C4 9D       | FF FE 1D 01       | Ll
Ğ                                  | LATIN CAPITAL LETTER G WITH BREVE                                                                            | `G(`       | &amp;x11E;    | x11E   | 286    | C4 9E       | FF FE 1E 01       | Lu
ğ                                  | LATIN SMALL LETTER G WITH BREVE                                                                              | `g(`       | &amp;x11F;    | x11F   | 287    | C4 9F       | FF FE 1F 01       | Ll
Ġ                                  | LATIN CAPITAL LETTER G WITH DOT ABOVE                                                                        | `G.`       | &amp;x120;    | x120   | 288    | C4 A0       | FF FE 20 01       | Lu
ġ                                  | LATIN SMALL LETTER G WITH DOT ABOVE                                                                          | `g.`       | &amp;x121;    | x121   | 289    | C4 A1       | FF FE 21 01       | Ll
Ģ                                  | LATIN CAPITAL LETTER G WITH CEDILLA                                                                          | `G,`       | &amp;x122;    | x122   | 290    | C4 A2       | FF FE 22 01       | Lu
ģ                                  | LATIN SMALL LETTER G WITH CEDILLA                                                                            | `g,`       | &amp;x123;    | x123   | 291    | C4 A3       | FF FE 23 01       | Ll
Ĥ                                  | LATIN CAPITAL LETTER H WITH CIRCUMFLEX                                                                       | `H>`       | &amp;x124;    | x124   | 292    | C4 A4       | FF FE 24 01       | Lu
ĥ                                  | LATIN SMALL LETTER H WITH CIRCUMFLEX                                                                         | `h>`       | &amp;x125;    | x125   | 293    | C4 A5       | FF FE 25 01       | Ll
Ħ                                  | LATIN CAPITAL LETTER H WITH STROKE                                                                           | `H/`       | &amp;x126;    | x126   | 294    | C4 A6       | FF FE 26 01       | Lu
ħ                                  | LATIN SMALL LETTER H WITH STROKE                                                                             | `h/`       | &amp;x127;    | x127   | 295    | C4 A7       | FF FE 27 01       | Ll
Ĩ                                  | LATIN CAPITAL LETTER I WITH TILDE                                                                            | `I?`       | &amp;x128;    | x128   | 296    | C4 A8       | FF FE 28 01       | Lu
ĩ                                  | LATIN SMALL LETTER I WITH TILDE                                                                              | `i?`       | &amp;x129;    | x129   | 297    | C4 A9       | FF FE 29 01       | Ll
Ī                                  | LATIN CAPITAL LETTER I WITH MACRON                                                                           | `I-`       | &amp;x12A;    | x12A   | 298    | C4 AA       | FF FE 2A 01       | Lu
ī                                  | LATIN SMALL LETTER I WITH MACRON                                                                             | `i-`       | &amp;x12B;    | x12B   | 299    | C4 AB       | FF FE 2B 01       | Ll
Ĭ                                  | LATIN CAPITAL LETTER I WITH BREVE                                                                            | `I(`       | &amp;x12C;    | x12C   | 300    | C4 AC       | FF FE 2C 01       | Lu
ĭ                                  | LATIN SMALL LETTER I WITH BREVE                                                                              | `i(`       | &amp;x12D;    | x12D   | 301    | C4 AD       | FF FE 2D 01       | Ll
Į                                  | LATIN CAPITAL LETTER I WITH OGONEK                                                                           | `I;`       | &amp;x12E;    | x12E   | 302    | C4 AE       | FF FE 2E 01       | Lu
į                                  | LATIN SMALL LETTER I WITH OGONEK                                                                             | `i;`       | &amp;x12F;    | x12F   | 303    | C4 AF       | FF FE 2F 01       | Ll
İ                                  | LATIN CAPITAL LETTER I WITH DOT ABOVE                                                                        | `I.`       | &amp;x130;    | x130   | 304    | C4 B0       | FF FE 30 01       | Lu
ı                                  | LATIN SMALL LETTER DOTLESS I                                                                                 | `i.`       | &amp;x131;    | x131   | 305    | C4 B1       | FF FE 31 01       | Ll
Ĳ                                  | LATIN CAPITAL LIGATURE IJ                                                                                    | `IJ`       | &amp;x132;    | x132   | 306    | C4 B2       | FF FE 32 01       | Lu
ĳ                                  | LATIN SMALL LIGATURE IJ                                                                                      | `ij`       | &amp;x133;    | x133   | 307    | C4 B3       | FF FE 33 01       | Ll
Ĵ                                  | LATIN CAPITAL LETTER J WITH CIRCUMFLEX                                                                       | `J>`       | &amp;x134;    | x134   | 308    | C4 B4       | FF FE 34 01       | Lu
ĵ                                  | LATIN SMALL LETTER J WITH CIRCUMFLEX                                                                         | `j>`       | &amp;x135;    | x135   | 309    | C4 B5       | FF FE 35 01       | Ll
Ķ                                  | LATIN CAPITAL LETTER K WITH CEDILLA                                                                          | `K,`       | &amp;x136;    | x136   | 310    | C4 B6       | FF FE 36 01       | Lu
ķ                                  | LATIN SMALL LETTER K WITH CEDILLA                                                                            | `k,`       | &amp;x137;    | x137   | 311    | C4 B7       | FF FE 37 01       | Ll
ĸ                                  | LATIN SMALL LETTER KRA                                                                                       | `kk`       | &amp;x138;    | x138   | 312    | C4 B8       | FF FE 38 01       | Ll
Ĺ                                  | LATIN CAPITAL LETTER L WITH ACUTE                                                                            | `L'`       | &amp;x139;    | x139   | 313    | C4 B9       | FF FE 39 01       | Lu
ĺ                                  | LATIN SMALL LETTER L WITH ACUTE                                                                              | `l'`       | &amp;x13A;    | x13A   | 314    | C4 BA       | FF FE 3A 01       | Ll
Ļ                                  | LATIN CAPITAL LETTER L WITH CEDILLA                                                                          | `L,`       | &amp;x13B;    | x13B   | 315    | C4 BB       | FF FE 3B 01       | Lu
ļ                                  | LATIN SMALL LETTER L WITH CEDILLA                                                                            | `l,`       | &amp;x13C;    | x13C   | 316    | C4 BC       | FF FE 3C 01       | Ll
Ľ                                  | LATIN CAPITAL LETTER L WITH CARON                                                                            | `L<`       | &amp;x13D;    | x13D   | 317    | C4 BD       | FF FE 3D 01       | Lu
ľ                                  | LATIN SMALL LETTER L WITH CARON                                                                              | `l<`       | &amp;x13E;    | x13E   | 318    | C4 BE       | FF FE 3E 01       | Ll
Ŀ                                  | LATIN CAPITAL LETTER L WITH MIDDLE DOT                                                                       | `L.`       | &amp;x13F;    | x13F   | 319    | C4 BF       | FF FE 3F 01       | Lu
ŀ                                  | LATIN SMALL LETTER L WITH MIDDLE DOT                                                                         | `l.`       | &amp;x140;    | x140   | 320    | C5 80       | FF FE 40 01       | Ll
Ł                                  | LATIN CAPITAL LETTER L WITH STROKE                                                                           | `L/`       | &amp;x141;    | x141   | 321    | C5 81       | FF FE 41 01       | Lu
ł                                  | LATIN SMALL LETTER L WITH STROKE                                                                             | `l/`       | &amp;x142;    | x142   | 322    | C5 82       | FF FE 42 01       | Ll
Ń                                  | LATIN CAPITAL LETTER N WITH ACUTE                                                                            | `N'`       | &amp;x143;    | x143   | 323    | C5 83       | FF FE 43 01       | Lu
ń                                  | LATIN SMALL LETTER N WITH ACUTE                                                                              | `n'`       | &amp;x144;    | x144   | 324    | C5 84       | FF FE 44 01       | Ll
Ņ                                  | LATIN CAPITAL LETTER N WITH CEDILLA                                                                          | `N,`       | &amp;x145;    | x145   | 325    | C5 85       | FF FE 45 01       | Lu
ņ                                  | LATIN SMALL LETTER N WITH CEDILLA                                                                            | `n,`       | &amp;x146;    | x146   | 326    | C5 86       | FF FE 46 01       | Ll
Ň                                  | LATIN CAPITAL LETTER N WITH CARON                                                                            | `N<`       | &amp;x147;    | x147   | 327    | C5 87       | FF FE 47 01       | Lu
ň                                  | LATIN SMALL LETTER N WITH CARON                                                                              | `n<`       | &amp;x148;    | x148   | 328    | C5 88       | FF FE 48 01       | Ll
ŉ                                  | LATIN SMALL LETTER N PRECEDED BY APOSTROPHE                                                                  | `'n`       | &amp;x149;    | x149   | 329    | C5 89       | FF FE 49 01       | Ll
Ŋ                                  | LATIN CAPITAL LETTER ENG                                                                                     | `NG`       | &amp;x14A;    | x14A   | 330    | C5 8A       | FF FE 4A 01       | Lu
ŋ                                  | LATIN SMALL LETTER ENG                                                                                       | `ng`       | &amp;x14B;    | x14B   | 331    | C5 8B       | FF FE 4B 01       | Ll
Ō                                  | LATIN CAPITAL LETTER O WITH MACRON                                                                           | `O-`       | &amp;x14C;    | x14C   | 332    | C5 8C       | FF FE 4C 01       | Lu
ō                                  | LATIN SMALL LETTER O WITH MACRON                                                                             | `o-`       | &amp;x14D;    | x14D   | 333    | C5 8D       | FF FE 4D 01       | Ll
Ŏ                                  | LATIN CAPITAL LETTER O WITH BREVE                                                                            | `O(`       | &amp;x14E;    | x14E   | 334    | C5 8E       | FF FE 4E 01       | Lu
ŏ                                  | LATIN SMALL LETTER O WITH BREVE                                                                              | `o(`       | &amp;x14F;    | x14F   | 335    | C5 8F       | FF FE 4F 01       | Ll
Ő                                  | LATIN CAPITAL LETTER O WITH DOUBLE ACUTE                                                                     | `O"`       | &amp;x150;    | x150   | 336    | C5 90       | FF FE 50 01       | Lu
ő                                  | LATIN SMALL LETTER O WITH DOUBLE ACUTE                                                                       | `o"`       | &amp;x151;    | x151   | 337    | C5 91       | FF FE 51 01       | Ll
Œ                                  | LATIN CAPITAL LIGATURE OE                                                                                    | `OE`       | &amp;OElig;   | x152   | 338    | C5 92       | FF FE 52 01       | Lu
œ                                  | LATIN SMALL LIGATURE OE                                                                                      | `oe`       | &amp;oelig;   | x153   | 339    | C5 93       | FF FE 53 01       | Ll
Ŕ                                  | LATIN CAPITAL LETTER R WITH ACUTE                                                                            | `R'`       | &amp;x154;    | x154   | 340    | C5 94       | FF FE 54 01       | Lu
ŕ                                  | LATIN SMALL LETTER R WITH ACUTE                                                                              | `r'`       | &amp;x155;    | x155   | 341    | C5 95       | FF FE 55 01       | Ll
Ŗ                                  | LATIN CAPITAL LETTER R WITH CEDILLA                                                                          | `R,`       | &amp;x156;    | x156   | 342    | C5 96       | FF FE 56 01       | Lu
ŗ                                  | LATIN SMALL LETTER R WITH CEDILLA                                                                            | `r,`       | &amp;x157;    | x157   | 343    | C5 97       | FF FE 57 01       | Ll
Ř                                  | LATIN CAPITAL LETTER R WITH CARON                                                                            | `R<`       | &amp;x158;    | x158   | 344    | C5 98       | FF FE 58 01       | Lu
ř                                  | LATIN SMALL LETTER R WITH CARON                                                                              | `r<`       | &amp;x159;    | x159   | 345    | C5 99       | FF FE 59 01       | Ll
Ś                                  | LATIN CAPITAL LETTER S WITH ACUTE                                                                            | `S'`       | &amp;x15A;    | x15A   | 346    | C5 9A       | FF FE 5A 01       | Lu
ś                                  | LATIN SMALL LETTER S WITH ACUTE                                                                              | `s'`       | &amp;x15B;    | x15B   | 347    | C5 9B       | FF FE 5B 01       | Ll
Ŝ                                  | LATIN CAPITAL LETTER S WITH CIRCUMFLEX                                                                       | `S>`       | &amp;x15C;    | x15C   | 348    | C5 9C       | FF FE 5C 01       | Lu
ŝ                                  | LATIN SMALL LETTER S WITH CIRCUMFLEX                                                                         | `s>`       | &amp;x15D;    | x15D   | 349    | C5 9D       | FF FE 5D 01       | Ll
Ş                                  | LATIN CAPITAL LETTER S WITH CEDILLA                                                                          | `S,`       | &amp;x15E;    | x15E   | 350    | C5 9E       | FF FE 5E 01       | Lu
ş                                  | LATIN SMALL LETTER S WITH CEDILLA                                                                            | `s,`       | &amp;x15F;    | x15F   | 351    | C5 9F       | FF FE 5F 01       | Ll
Š                                  | LATIN CAPITAL LETTER S WITH CARON                                                                            | `S<`       | &amp;Scaron;  | x160   | 352    | C5 A0       | FF FE 60 01       | Lu
š                                  | LATIN SMALL LETTER S WITH CARON                                                                              | `s<`       | &amp;scaron;  | x161   | 353    | C5 A1       | FF FE 61 01       | Ll
Ţ                                  | LATIN CAPITAL LETTER T WITH CEDILLA                                                                          | `T,`       | &amp;x162;    | x162   | 354    | C5 A2       | FF FE 62 01       | Lu
ţ                                  | LATIN SMALL LETTER T WITH CEDILLA                                                                            | `t,`       | &amp;x163;    | x163   | 355    | C5 A3       | FF FE 63 01       | Ll
Ť                                  | LATIN CAPITAL LETTER T WITH CARON                                                                            | `T<`       | &amp;x164;    | x164   | 356    | C5 A4       | FF FE 64 01       | Lu
ť                                  | LATIN SMALL LETTER T WITH CARON                                                                              | `t<`       | &amp;x165;    | x165   | 357    | C5 A5       | FF FE 65 01       | Ll
Ŧ                                  | LATIN CAPITAL LETTER T WITH STROKE                                                                           | `T/`       | &amp;x166;    | x166   | 358    | C5 A6       | FF FE 66 01       | Lu
ŧ                                  | LATIN SMALL LETTER T WITH STROKE                                                                             | `t/`       | &amp;x167;    | x167   | 359    | C5 A7       | FF FE 67 01       | Ll
Ũ                                  | LATIN CAPITAL LETTER U WITH TILDE                                                                            | `U?`       | &amp;x168;    | x168   | 360    | C5 A8       | FF FE 68 01       | Lu
ũ                                  | LATIN SMALL LETTER U WITH TILDE                                                                              | `u?`       | &amp;x169;    | x169   | 361    | C5 A9       | FF FE 69 01       | Ll
Ū                                  | LATIN CAPITAL LETTER U WITH MACRON                                                                           | `U-`       | &amp;x16A;    | x16A   | 362    | C5 AA       | FF FE 6A 01       | Lu
ū                                  | LATIN SMALL LETTER U WITH MACRON                                                                             | `u-`       | &amp;x16B;    | x16B   | 363    | C5 AB       | FF FE 6B 01       | Ll
Ŭ                                  | LATIN CAPITAL LETTER U WITH BREVE                                                                            | `U(`       | &amp;x16C;    | x16C   | 364    | C5 AC       | FF FE 6C 01       | Lu
ŭ                                  | LATIN SMALL LETTER U WITH BREVE                                                                              | `u(`       | &amp;x16D;    | x16D   | 365    | C5 AD       | FF FE 6D 01       | Ll
Ů                                  | LATIN CAPITAL LETTER U WITH RING ABOVE                                                                       | `U0`       | &amp;x16E;    | x16E   | 366    | C5 AE       | FF FE 6E 01       | Lu
ů                                  | LATIN SMALL LETTER U WITH RING ABOVE                                                                         | `u0`       | &amp;x16F;    | x16F   | 367    | C5 AF       | FF FE 6F 01       | Ll
Ű                                  | LATIN CAPITAL LETTER U WITH DOUBLE ACUTE                                                                     | `U"`       | &amp;x170;    | x170   | 368    | C5 B0       | FF FE 70 01       | Lu
ű                                  | LATIN SMALL LETTER U WITH DOUBLE ACUTE                                                                       | `u"`       | &amp;x171;    | x171   | 369    | C5 B1       | FF FE 71 01       | Ll
Ų                                  | LATIN CAPITAL LETTER U WITH OGONEK                                                                           | `U;`       | &amp;x172;    | x172   | 370    | C5 B2       | FF FE 72 01       | Lu
ų                                  | LATIN SMALL LETTER U WITH OGONEK                                                                             | `u;`       | &amp;x173;    | x173   | 371    | C5 B3       | FF FE 73 01       | Ll
Ŵ                                  | LATIN CAPITAL LETTER W WITH CIRCUMFLEX                                                                       | `W>`       | &amp;x174;    | x174   | 372    | C5 B4       | FF FE 74 01       | Lu
ŵ                                  | LATIN SMALL LETTER W WITH CIRCUMFLEX                                                                         | `w>`       | &amp;x175;    | x175   | 373    | C5 B5       | FF FE 75 01       | Ll
Ŷ                                  | LATIN CAPITAL LETTER Y WITH CIRCUMFLEX                                                                       | `Y>`       | &amp;x176;    | x176   | 374    | C5 B6       | FF FE 76 01       | Lu
ŷ                                  | LATIN SMALL LETTER Y WITH CIRCUMFLEX                                                                         | `y>`       | &amp;x177;    | x177   | 375    | C5 B7       | FF FE 77 01       | Ll
Ÿ                                  | LATIN CAPITAL LETTER Y WITH DIAERESIS                                                                        | `Y:`       | &amp;Yuml;    | x178   | 376    | C5 B8       | FF FE 78 01       | Lu
Ź                                  | LATIN CAPITAL LETTER Z WITH ACUTE                                                                            | `Z'`       | &amp;x179;    | x179   | 377    | C5 B9       | FF FE 79 01       | Lu
ź                                  | LATIN SMALL LETTER Z WITH ACUTE                                                                              | `z'`       | &amp;x17A;    | x17A   | 378    | C5 BA       | FF FE 7A 01       | Ll
Ż                                  | LATIN CAPITAL LETTER Z WITH DOT ABOVE                                                                        | `Z.`       | &amp;x17B;    | x17B   | 379    | C5 BB       | FF FE 7B 01       | Lu
ż                                  | LATIN SMALL LETTER Z WITH DOT ABOVE                                                                          | `z.`       | &amp;x17C;    | x17C   | 380    | C5 BC       | FF FE 7C 01       | Ll
Ž                                  | LATIN CAPITAL LETTER Z WITH CARON                                                                            | `Z<`       | &amp;x17D;    | x17D   | 381    | C5 BD       | FF FE 7D 01       | Lu
ž                                  | LATIN SMALL LETTER Z WITH CARON                                                                              | `z<`       | &amp;x17E;    | x17E   | 382    | C5 BE       | FF FE 7E 01       | Ll
Ơ                                  | LATIN CAPITAL LETTER O WITH HORN                                                                             | `O9`       | &amp;x1A0;    | x1A0   | 416    | C6 A0       | FF FE A0 01       | Lu
ơ                                  | LATIN SMALL LETTER O WITH HORN                                                                               | `o9`       | &amp;x1A1;    | x1A1   | 417    | C6 A1       | FF FE A1 01       | Ll
Ƣ                                  | LATIN CAPITAL LETTER OI                                                                                      | `OI`       | &amp;x1A2;    | x1A2   | 418    | C6 A2       | FF FE A2 01       | Lu
ƣ                                  | LATIN SMALL LETTER OI                                                                                        | `oi`       | &amp;x1A3;    | x1A3   | 419    | C6 A3       | FF FE A3 01       | Ll
Ʀ                                  | LATIN LETTER YR                                                                                              | `yr`       | &amp;x1A6;    | x1A6   | 422    | C6 A6       | FF FE A6 01       | Lu
Ư                                  | LATIN CAPITAL LETTER U WITH HORN                                                                             | `U9`       | &amp;x1AF;    | x1AF   | 431    | C6 AF       | FF FE AF 01       | Lu
ư                                  | LATIN SMALL LETTER U WITH HORN                                                                               | `u9`       | &amp;x1B0;    | x1B0   | 432    | C6 B0       | FF FE B0 01       | Ll
Ƶ                                  | LATIN CAPITAL LETTER Z WITH STROKE                                                                           | `Z/`       | &amp;x1B5;    | x1B5   | 437    | C6 B5       | FF FE B5 01       | Lu
ƶ                                  | LATIN SMALL LETTER Z WITH STROKE                                                                             | `z/`       | &amp;x1B6;    | x1B6   | 438    | C6 B6       | FF FE B6 01       | Ll
Ʒ                                  | LATIN CAPITAL LETTER EZH                                                                                     | `ED`       | &amp;x1B7;    | x1B7   | 439    | C6 B7       | FF FE B7 01       | Lu
Ǎ                                  | LATIN CAPITAL LETTER A WITH CARON                                                                            | `A<`       | &amp;x1CD;    | x1CD   | 461    | C7 8D       | FF FE CD 01       | Lu
ǎ                                  | LATIN SMALL LETTER A WITH CARON                                                                              | `a<`       | &amp;x1CE;    | x1CE   | 462    | C7 8E       | FF FE CE 01       | Ll
Ǐ                                  | LATIN CAPITAL LETTER I WITH CARON                                                                            | `I<`       | &amp;x1CF;    | x1CF   | 463    | C7 8F       | FF FE CF 01       | Lu
ǐ                                  | LATIN SMALL LETTER I WITH CARON                                                                              | `i<`       | &amp;x1D0;    | x1D0   | 464    | C7 90       | FF FE D0 01       | Ll
Ǒ                                  | LATIN CAPITAL LETTER O WITH CARON                                                                            | `O<`       | &amp;x1D1;    | x1D1   | 465    | C7 91       | FF FE D1 01       | Lu
ǒ                                  | LATIN SMALL LETTER O WITH CARON                                                                              | `o<`       | &amp;x1D2;    | x1D2   | 466    | C7 92       | FF FE D2 01       | Ll
Ǔ                                  | LATIN CAPITAL LETTER U WITH CARON                                                                            | `U<`       | &amp;x1D3;    | x1D3   | 467    | C7 93       | FF FE D3 01       | Lu
ǔ                                  | LATIN SMALL LETTER U WITH CARON                                                                              | `u<`       | &amp;x1D4;    | x1D4   | 468    | C7 94       | FF FE D4 01       | Ll
Ǟ                                  | LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON                                                             | `A1`       | &amp;x1DE;    | x1DE   | 478    | C7 9E       | FF FE DE 01       | Lu
ǟ                                  | LATIN SMALL LETTER A WITH DIAERESIS AND MACRON                                                               | `a1`       | &amp;x1DF;    | x1DF   | 479    | C7 9F       | FF FE DF 01       | Ll
Ǡ                                  | LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON                                                             | `A7`       | &amp;x1E0;    | x1E0   | 480    | C7 A0       | FF FE E0 01       | Lu
ǡ                                  | LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON                                                               | `a7`       | &amp;x1E1;    | x1E1   | 481    | C7 A1       | FF FE E1 01       | Ll
Ǣ                                  | LATIN CAPITAL LETTER AE WITH MACRON                                                                          | `A3`       | &amp;x1E2;    | x1E2   | 482    | C7 A2       | FF FE E2 01       | Lu
ǣ                                  | LATIN SMALL LETTER AE WITH MACRON                                                                            | `a3`       | &amp;x1E3;    | x1E3   | 483    | C7 A3       | FF FE E3 01       | Ll
Ǥ                                  | LATIN CAPITAL LETTER G WITH STROKE                                                                           | `G/`       | &amp;x1E4;    | x1E4   | 484    | C7 A4       | FF FE E4 01       | Lu
ǥ                                  | LATIN SMALL LETTER G WITH STROKE                                                                             | `g/`       | &amp;x1E5;    | x1E5   | 485    | C7 A5       | FF FE E5 01       | Ll
Ǧ                                  | LATIN CAPITAL LETTER G WITH CARON                                                                            | `G<`       | &amp;x1E6;    | x1E6   | 486    | C7 A6       | FF FE E6 01       | Lu
ǧ                                  | LATIN SMALL LETTER G WITH CARON                                                                              | `g<`       | &amp;x1E7;    | x1E7   | 487    | C7 A7       | FF FE E7 01       | Ll
Ǩ                                  | LATIN CAPITAL LETTER K WITH CARON                                                                            | `K<`       | &amp;x1E8;    | x1E8   | 488    | C7 A8       | FF FE E8 01       | Lu
ǩ                                  | LATIN SMALL LETTER K WITH CARON                                                                              | `k<`       | &amp;x1E9;    | x1E9   | 489    | C7 A9       | FF FE E9 01       | Ll
Ǫ                                  | LATIN CAPITAL LETTER O WITH OGONEK                                                                           | `O;`       | &amp;x1EA;    | x1EA   | 490    | C7 AA       | FF FE EA 01       | Lu
ǫ                                  | LATIN SMALL LETTER O WITH OGONEK                                                                             | `o;`       | &amp;x1EB;    | x1EB   | 491    | C7 AB       | FF FE EB 01       | Ll
Ǭ                                  | LATIN CAPITAL LETTER O WITH OGONEK AND MACRON                                                                | `O1`       | &amp;x1EC;    | x1EC   | 492    | C7 AC       | FF FE EC 01       | Lu
ǭ                                  | LATIN SMALL LETTER O WITH OGONEK AND MACRON                                                                  | `o1`       | &amp;x1ED;    | x1ED   | 493    | C7 AD       | FF FE ED 01       | Ll
Ǯ                                  | LATIN CAPITAL LETTER EZH WITH CARON                                                                          | `EZ`       | &amp;x1EE;    | x1EE   | 494    | C7 AE       | FF FE EE 01       | Lu
ǯ                                  | LATIN SMALL LETTER EZH WITH CARON                                                                            | `ez`       | &amp;x1EF;    | x1EF   | 495    | C7 AF       | FF FE EF 01       | Ll
ǰ                                  | LATIN SMALL LETTER J WITH CARON                                                                              | `j<`       | &amp;x1F0;    | x1F0   | 496    | C7 B0       | FF FE F0 01       | Ll
Ǵ                                  | LATIN CAPITAL LETTER G WITH ACUTE                                                                            | `G'`       | &amp;x1F4;    | x1F4   | 500    | C7 B4       | FF FE F4 01       | Lu
ǵ                                  | LATIN SMALL LETTER G WITH ACUTE                                                                              | `g'`       | &amp;x1F5;    | x1F5   | 501    | C7 B5       | FF FE F5 01       | Ll
ʿ                                  | MODIFIER LETTER LEFT HALF RING                                                                               | `;S`       | &amp;x2BF;    | x2BF   | 703    | CA BF       | FF FE BF 02       | Lm
ˇ                                  | CARON                                                                                                        | `'<`       | &amp;x2C7;    | x2C7   | 711    | CB 87       | FF FE C7 02       | Lm
˘                                  | BREVE                                                                                                        | `'(`       | &amp;x2D8;    | x2D8   | 728    | CB 98       | FF FE D8 02       | Sk
˙                                  | DOT ABOVE                                                                                                    | `'.`       | &amp;x2D9;    | x2D9   | 729    | CB 99       | FF FE D9 02       | Sk
˚                                  | RING ABOVE                                                                                                   | `'0`       | &amp;x2DA;    | x2DA   | 730    | CB 9A       | FF FE DA 02       | Sk
˛                                  | OGONEK                                                                                                       | `';`       | &amp;x2DB;    | x2DB   | 731    | CB 9B       | FF FE DB 02       | Sk
˝                                  | DOUBLE ACUTE ACCENT                                                                                          | `'"`       | &amp;x2DD;    | x2DD   | 733    | CB 9D       | FF FE DD 02       | Sk
Ά                                  | GREEK CAPITAL LETTER ALPHA WITH TONOS                                                                        | `A%`       | &amp;x386;    | x386   | 902    | CE 86       | FF FE 86 03       | Lu
Έ                                  | GREEK CAPITAL LETTER EPSILON WITH TONOS                                                                      | `E%`       | &amp;x388;    | x388   | 904    | CE 88       | FF FE 88 03       | Lu
Ή                                  | GREEK CAPITAL LETTER ETA WITH TONOS                                                                          | `Y%`       | &amp;x389;    | x389   | 905    | CE 89       | FF FE 89 03       | Lu
Ί                                  | GREEK CAPITAL LETTER IOTA WITH TONOS                                                                         | `I%`       | &amp;x38A;    | x38A   | 906    | CE 8A       | FF FE 8A 03       | Lu
Ό                                  | GREEK CAPITAL LETTER OMICRON WITH TONOS                                                                      | `O%`       | &amp;x38C;    | x38C   | 908    | CE 8C       | FF FE 8C 03       | Lu
Ύ                                  | GREEK CAPITAL LETTER UPSILON WITH TONOS                                                                      | `U%`       | &amp;x38E;    | x38E   | 910    | CE 8E       | FF FE 8E 03       | Lu
Ώ                                  | GREEK CAPITAL LETTER OMEGA WITH TONOS                                                                        | `W%`       | &amp;x38F;    | x38F   | 911    | CE 8F       | FF FE 8F 03       | Lu
ΐ                                  | GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS                                                             | `i3`       | &amp;x390;    | x390   | 912    | CE 90       | FF FE 90 03       | Ll
Α                                  | GREEK CAPITAL LETTER ALPHA                                                                                   | `A*`       | &amp;Alpha;   | x391   | 913    | CE 91       | FF FE 91 03       | Lu
Β                                  | GREEK CAPITAL LETTER BETA                                                                                    | `B*`       | &amp;Beta;    | x392   | 914    | CE 92       | FF FE 92 03       | Lu
Γ                                  | GREEK CAPITAL LETTER GAMMA                                                                                   | `G*`       | &amp;Gamma;   | x393   | 915    | CE 93       | FF FE 93 03       | Lu
Δ                                  | GREEK CAPITAL LETTER DELTA                                                                                   | `D*`       | &amp;Delta;   | x394   | 916    | CE 94       | FF FE 94 03       | Lu
Ε                                  | GREEK CAPITAL LETTER EPSILON                                                                                 | `E*`       | &amp;Epsilon; | x395   | 917    | CE 95       | FF FE 95 03       | Lu
Ζ                                  | GREEK CAPITAL LETTER ZETA                                                                                    | `Z*`       | &amp;Zeta;    | x396   | 918    | CE 96       | FF FE 96 03       | Lu
Η                                  | GREEK CAPITAL LETTER ETA                                                                                     | `Y*`       | &amp;Eta;     | x397   | 919    | CE 97       | FF FE 97 03       | Lu
Θ                                  | GREEK CAPITAL LETTER THETA                                                                                   | `H*`       | &amp;Theta;   | x398   | 920    | CE 98       | FF FE 98 03       | Lu
Ι                                  | GREEK CAPITAL LETTER IOTA                                                                                    | `I*`       | &amp;Iota;    | x399   | 921    | CE 99       | FF FE 99 03       | Lu
Κ                                  | GREEK CAPITAL LETTER KAPPA                                                                                   | `K*`       | &amp;Kappa;   | x39A   | 922    | CE 9A       | FF FE 9A 03       | Lu
Λ                                  | GREEK CAPITAL LETTER LAMDA                                                                                   | `L*`       | &amp;Lambda;  | x39B   | 923    | CE 9B       | FF FE 9B 03       | Lu
Μ                                  | GREEK CAPITAL LETTER MU                                                                                      | `M*`       | &amp;Mu;      | x39C   | 924    | CE 9C       | FF FE 9C 03       | Lu
Ν                                  | GREEK CAPITAL LETTER NU                                                                                      | `N*`       | &amp;Nu;      | x39D   | 925    | CE 9D       | FF FE 9D 03       | Lu
Ξ                                  | GREEK CAPITAL LETTER XI                                                                                      | `C*`       | &amp;Xi;      | x39E   | 926    | CE 9E       | FF FE 9E 03       | Lu
Ο                                  | GREEK CAPITAL LETTER OMICRON                                                                                 | `O*`       | &amp;Omicron; | x39F   | 927    | CE 9F       | FF FE 9F 03       | Lu
Π                                  | GREEK CAPITAL LETTER PI                                                                                      | `P*`       | &amp;Pi;      | x3A0   | 928    | CE A0       | FF FE A0 03       | Lu
Ρ                                  | GREEK CAPITAL LETTER RHO                                                                                     | `R*`       | &amp;Rho;     | x3A1   | 929    | CE A1       | FF FE A1 03       | Lu
Σ                                  | GREEK CAPITAL LETTER SIGMA                                                                                   | `S*`       | &amp;Sigma;   | x3A3   | 931    | CE A3       | FF FE A3 03       | Lu
Τ                                  | GREEK CAPITAL LETTER TAU                                                                                     | `T*`       | &amp;Tau;     | x3A4   | 932    | CE A4       | FF FE A4 03       | Lu
Υ                                  | GREEK CAPITAL LETTER UPSILON                                                                                 | `U*`       | &amp;Upsilon; | x3A5   | 933    | CE A5       | FF FE A5 03       | Lu
Φ                                  | GREEK CAPITAL LETTER PHI                                                                                     | `F*`       | &amp;Phi;     | x3A6   | 934    | CE A6       | FF FE A6 03       | Lu
Χ                                  | GREEK CAPITAL LETTER CHI                                                                                     | `X*`       | &amp;Chi;     | x3A7   | 935    | CE A7       | FF FE A7 03       | Lu
Ψ                                  | GREEK CAPITAL LETTER PSI                                                                                     | `Q*`       | &amp;Psi;     | x3A8   | 936    | CE A8       | FF FE A8 03       | Lu
Ω                                  | GREEK CAPITAL LETTER OMEGA                                                                                   | `W*`       | &amp;Omega;   | x3A9   | 937    | CE A9       | FF FE A9 03       | Lu
Ϊ                                  | GREEK CAPITAL LETTER IOTA WITH DIALYTIKA                                                                     | `J*`       | &amp;x3AA;    | x3AA   | 938    | CE AA       | FF FE AA 03       | Lu
Ϋ                                  | GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA                                                                  | `V*`       | &amp;x3AB;    | x3AB   | 939    | CE AB       | FF FE AB 03       | Lu
ά                                  | GREEK SMALL LETTER ALPHA WITH TONOS                                                                          | `a%`       | &amp;x3AC;    | x3AC   | 940    | CE AC       | FF FE AC 03       | Ll
έ                                  | GREEK SMALL LETTER EPSILON WITH TONOS                                                                        | `e%`       | &amp;x3AD;    | x3AD   | 941    | CE AD       | FF FE AD 03       | Ll
ή                                  | GREEK SMALL LETTER ETA WITH TONOS                                                                            | `y%`       | &amp;x3AE;    | x3AE   | 942    | CE AE       | FF FE AE 03       | Ll
ί                                  | GREEK SMALL LETTER IOTA WITH TONOS                                                                           | `i%`       | &amp;x3AF;    | x3AF   | 943    | CE AF       | FF FE AF 03       | Ll
ΰ                                  | GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS                                                          | `u3`       | &amp;x3B0;    | x3B0   | 944    | CE B0       | FF FE B0 03       | Ll
α                                  | GREEK SMALL LETTER ALPHA                                                                                     | `a*`       | &amp;alpha;   | x3B1   | 945    | CE B1       | FF FE B1 03       | Ll
β                                  | GREEK SMALL LETTER BETA                                                                                      | `b*`       | &amp;beta;    | x3B2   | 946    | CE B2       | FF FE B2 03       | Ll
γ                                  | GREEK SMALL LETTER GAMMA                                                                                     | `g*`       | &amp;gamma;   | x3B3   | 947    | CE B3       | FF FE B3 03       | Ll
δ                                  | GREEK SMALL LETTER DELTA                                                                                     | `d*`       | &amp;delta;   | x3B4   | 948    | CE B4       | FF FE B4 03       | Ll
ε                                  | GREEK SMALL LETTER EPSILON                                                                                   | `e*`       | &amp;epsilon; | x3B5   | 949    | CE B5       | FF FE B5 03       | Ll
ζ                                  | GREEK SMALL LETTER ZETA                                                                                      | `z*`       | &amp;zeta;    | x3B6   | 950    | CE B6       | FF FE B6 03       | Ll
η                                  | GREEK SMALL LETTER ETA                                                                                       | `y*`       | &amp;eta;     | x3B7   | 951    | CE B7       | FF FE B7 03       | Ll
θ                                  | GREEK SMALL LETTER THETA                                                                                     | `h*`       | &amp;theta;   | x3B8   | 952    | CE B8       | FF FE B8 03       | Ll
ι                                  | GREEK SMALL LETTER IOTA                                                                                      | `i*`       | &amp;iota;    | x3B9   | 953    | CE B9       | FF FE B9 03       | Ll
κ                                  | GREEK SMALL LETTER KAPPA                                                                                     | `k*`       | &amp;kappa;   | x3BA   | 954    | CE BA       | FF FE BA 03       | Ll
λ                                  | GREEK SMALL LETTER LAMDA                                                                                     | `l*`       | &amp;lambda;  | x3BB   | 955    | CE BB       | FF FE BB 03       | Ll
μ                                  | GREEK SMALL LETTER MU                                                                                        | `m*`       | &amp;mu;      | x3BC   | 956    | CE BC       | FF FE BC 03       | Ll
ν                                  | GREEK SMALL LETTER NU                                                                                        | `n*`       | &amp;nu;      | x3BD   | 957    | CE BD       | FF FE BD 03       | Ll
ξ                                  | GREEK SMALL LETTER XI                                                                                        | `c*`       | &amp;xi;      | x3BE   | 958    | CE BE       | FF FE BE 03       | Ll
ο                                  | GREEK SMALL LETTER OMICRON                                                                                   | `o*`       | &amp;omicron; | x3BF   | 959    | CE BF       | FF FE BF 03       | Ll
π                                  | GREEK SMALL LETTER PI                                                                                        | `p*`       | &amp;pi;      | x3C0   | 960    | CF 80       | FF FE C0 03       | Ll
ρ                                  | GREEK SMALL LETTER RHO                                                                                       | `r*`       | &amp;rho;     | x3C1   | 961    | CF 81       | FF FE C1 03       | Ll
ς                                  | GREEK SMALL LETTER FINAL SIGMA                                                                               | `*s`       | &amp;sigmaf;  | x3C2   | 962    | CF 82       | FF FE C2 03       | Ll
σ                                  | GREEK SMALL LETTER SIGMA                                                                                     | `s*`       | &amp;sigma;   | x3C3   | 963    | CF 83       | FF FE C3 03       | Ll
τ                                  | GREEK SMALL LETTER TAU                                                                                       | `t*`       | &amp;tau;     | x3C4   | 964    | CF 84       | FF FE C4 03       | Ll
υ                                  | GREEK SMALL LETTER UPSILON                                                                                   | `u*`       | &amp;upsilon; | x3C5   | 965    | CF 85       | FF FE C5 03       | Ll
φ                                  | GREEK SMALL LETTER PHI                                                                                       | `f*`       | &amp;phi;     | x3C6   | 966    | CF 86       | FF FE C6 03       | Ll
χ                                  | GREEK SMALL LETTER CHI                                                                                       | `x*`       | &amp;chi;     | x3C7   | 967    | CF 87       | FF FE C7 03       | Ll
ψ                                  | GREEK SMALL LETTER PSI                                                                                       | `q*`       | &amp;psi;     | x3C8   | 968    | CF 88       | FF FE C8 03       | Ll
ω                                  | GREEK SMALL LETTER OMEGA                                                                                     | `w*`       | &amp;omega;   | x3C9   | 969    | CF 89       | FF FE C9 03       | Ll
ϊ                                  | GREEK SMALL LETTER IOTA WITH DIALYTIKA                                                                       | `j*`       | &amp;x3CA;    | x3CA   | 970    | CF 8A       | FF FE CA 03       | Ll
ϋ                                  | GREEK SMALL LETTER UPSILON WITH DIALYTIKA                                                                    | `v*`       | &amp;x3CB;    | x3CB   | 971    | CF 8B       | FF FE CB 03       | Ll
ό                                  | GREEK SMALL LETTER OMICRON WITH TONOS                                                                        | `o%`       | &amp;x3CC;    | x3CC   | 972    | CF 8C       | FF FE CC 03       | Ll
ύ                                  | GREEK SMALL LETTER UPSILON WITH TONOS                                                                        | `u%`       | &amp;x3CD;    | x3CD   | 973    | CF 8D       | FF FE CD 03       | Ll
ώ                                  | GREEK SMALL LETTER OMEGA WITH TONOS                                                                          | `w%`       | &amp;x3CE;    | x3CE   | 974    | CF 8E       | FF FE CE 03       | Ll
Ϙ                                  | GREEK LETTER ARCHAIC KOPPA                                                                                   | `'G`       | &amp;x3D8;    | x3D8   | 984    | CF 98       | FF FE D8 03       | Lu
ϙ                                  | GREEK SMALL LETTER ARCHAIC KOPPA                                                                             | `,G`       | &amp;x3D9;    | x3D9   | 985    | CF 99       | FF FE D9 03       | Ll
Ϛ                                  | GREEK LETTER STIGMA                                                                                          | `T3`       | &amp;x3DA;    | x3DA   | 986    | CF 9A       | FF FE DA 03       | Lu
ϛ                                  | GREEK SMALL LETTER STIGMA                                                                                    | `t3`       | &amp;x3DB;    | x3DB   | 987    | CF 9B       | FF FE DB 03       | Ll
Ϝ                                  | GREEK LETTER DIGAMMA                                                                                         | `M3`       | &amp;x3DC;    | x3DC   | 988    | CF 9C       | FF FE DC 03       | Lu
ϝ                                  | GREEK SMALL LETTER DIGAMMA                                                                                   | `m3`       | &amp;x3DD;    | x3DD   | 989    | CF 9D       | FF FE DD 03       | Ll
Ϟ                                  | GREEK LETTER KOPPA                                                                                           | `K3`       | &amp;x3DE;    | x3DE   | 990    | CF 9E       | FF FE DE 03       | Lu
ϟ                                  | GREEK SMALL LETTER KOPPA                                                                                     | `k3`       | &amp;x3DF;    | x3DF   | 991    | CF 9F       | FF FE DF 03       | Ll
Ϡ                                  | GREEK LETTER SAMPI                                                                                           | `P3`       | &amp;x3E0;    | x3E0   | 992    | CF A0       | FF FE E0 03       | Lu
ϡ                                  | GREEK SMALL LETTER SAMPI                                                                                     | `p3`       | &amp;x3E1;    | x3E1   | 993    | CF A1       | FF FE E1 03       | Ll
ϴ                                  | GREEK CAPITAL THETA SYMBOL                                                                                   | `'%`       | &amp;x3F4;    | x3F4   | 1012   | CF B4       | FF FE F4 03       | Lu
ϵ                                  | GREEK LUNATE EPSILON SYMBOL                                                                                  | `j3`       | &amp;x3F5;    | x3F5   | 1013   | CF B5       | FF FE F5 03       | Ll
Ё                                  | CYRILLIC CAPITAL LETTER IO                                                                                   | `IO`       | &amp;x401;    | x401   | 1025   | D0 81       | FF FE 01 04       | Lu
Ђ                                  | CYRILLIC CAPITAL LETTER DJE                                                                                  | `D%`       | &amp;x402;    | x402   | 1026   | D0 82       | FF FE 02 04       | Lu
Ѓ                                  | CYRILLIC CAPITAL LETTER GJE                                                                                  | `G%`       | &amp;x403;    | x403   | 1027   | D0 83       | FF FE 03 04       | Lu
Є                                  | CYRILLIC CAPITAL LETTER UKRAINIAN IE                                                                         | `IE`       | &amp;x404;    | x404   | 1028   | D0 84       | FF FE 04 04       | Lu
Ѕ                                  | CYRILLIC CAPITAL LETTER DZE                                                                                  | `DS`       | &amp;x405;    | x405   | 1029   | D0 85       | FF FE 05 04       | Lu
І                                  | CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I                                                             | `II`       | &amp;x406;    | x406   | 1030   | D0 86       | FF FE 06 04       | Lu
Ї                                  | CYRILLIC CAPITAL LETTER YI                                                                                   | `YI`       | &amp;x407;    | x407   | 1031   | D0 87       | FF FE 07 04       | Lu
Ј                                  | CYRILLIC CAPITAL LETTER JE                                                                                   | `J%`       | &amp;x408;    | x408   | 1032   | D0 88       | FF FE 08 04       | Lu
Љ                                  | CYRILLIC CAPITAL LETTER LJE                                                                                  | `LJ`       | &amp;x409;    | x409   | 1033   | D0 89       | FF FE 09 04       | Lu
Њ                                  | CYRILLIC CAPITAL LETTER NJE                                                                                  | `NJ`       | &amp;x40A;    | x40A   | 1034   | D0 8A       | FF FE 0A 04       | Lu
Ћ                                  | CYRILLIC CAPITAL LETTER TSHE                                                                                 | `Ts`       | &amp;x40B;    | x40B   | 1035   | D0 8B       | FF FE 0B 04       | Lu
Ќ                                  | CYRILLIC CAPITAL LETTER KJE                                                                                  | `KJ`       | &amp;x40C;    | x40C   | 1036   | D0 8C       | FF FE 0C 04       | Lu
Ў                                  | CYRILLIC CAPITAL LETTER SHORT U                                                                              | `V%`       | &amp;x40E;    | x40E   | 1038   | D0 8E       | FF FE 0E 04       | Lu
Џ                                  | CYRILLIC CAPITAL LETTER DZHE                                                                                 | `DZ`       | &amp;x40F;    | x40F   | 1039   | D0 8F       | FF FE 0F 04       | Lu
А                                  | CYRILLIC CAPITAL LETTER A                                                                                    | `A=`       | &amp;x410;    | x410   | 1040   | D0 90       | FF FE 10 04       | Lu
Б                                  | CYRILLIC CAPITAL LETTER BE                                                                                   | `B=`       | &amp;x411;    | x411   | 1041   | D0 91       | FF FE 11 04       | Lu
В                                  | CYRILLIC CAPITAL LETTER VE                                                                                   | `V=`       | &amp;x412;    | x412   | 1042   | D0 92       | FF FE 12 04       | Lu
Г                                  | CYRILLIC CAPITAL LETTER GHE                                                                                  | `G=`       | &amp;x413;    | x413   | 1043   | D0 93       | FF FE 13 04       | Lu
Д                                  | CYRILLIC CAPITAL LETTER DE                                                                                   | `D=`       | &amp;x414;    | x414   | 1044   | D0 94       | FF FE 14 04       | Lu
Е                                  | CYRILLIC CAPITAL LETTER IE                                                                                   | `E=`       | &amp;x415;    | x415   | 1045   | D0 95       | FF FE 15 04       | Lu
Ж                                  | CYRILLIC CAPITAL LETTER ZHE                                                                                  | `Z%`       | &amp;x416;    | x416   | 1046   | D0 96       | FF FE 16 04       | Lu
З                                  | CYRILLIC CAPITAL LETTER ZE                                                                                   | `Z=`       | &amp;x417;    | x417   | 1047   | D0 97       | FF FE 17 04       | Lu
И                                  | CYRILLIC CAPITAL LETTER I                                                                                    | `I=`       | &amp;x418;    | x418   | 1048   | D0 98       | FF FE 18 04       | Lu
Й                                  | CYRILLIC CAPITAL LETTER SHORT I                                                                              | `J=`       | &amp;x419;    | x419   | 1049   | D0 99       | FF FE 19 04       | Lu
К                                  | CYRILLIC CAPITAL LETTER KA                                                                                   | `K=`       | &amp;x41A;    | x41A   | 1050   | D0 9A       | FF FE 1A 04       | Lu
Л                                  | CYRILLIC CAPITAL LETTER EL                                                                                   | `L=`       | &amp;x41B;    | x41B   | 1051   | D0 9B       | FF FE 1B 04       | Lu
М                                  | CYRILLIC CAPITAL LETTER EM                                                                                   | `M=`       | &amp;x41C;    | x41C   | 1052   | D0 9C       | FF FE 1C 04       | Lu
Н                                  | CYRILLIC CAPITAL LETTER EN                                                                                   | `N=`       | &amp;x41D;    | x41D   | 1053   | D0 9D       | FF FE 1D 04       | Lu
О                                  | CYRILLIC CAPITAL LETTER O                                                                                    | `O=`       | &amp;x41E;    | x41E   | 1054   | D0 9E       | FF FE 1E 04       | Lu
П                                  | CYRILLIC CAPITAL LETTER PE                                                                                   | `P=`       | &amp;x41F;    | x41F   | 1055   | D0 9F       | FF FE 1F 04       | Lu
Р                                  | CYRILLIC CAPITAL LETTER ER                                                                                   | `R=`       | &amp;x420;    | x420   | 1056   | D0 A0       | FF FE 20 04       | Lu
С                                  | CYRILLIC CAPITAL LETTER ES                                                                                   | `S=`       | &amp;x421;    | x421   | 1057   | D0 A1       | FF FE 21 04       | Lu
Т                                  | CYRILLIC CAPITAL LETTER TE                                                                                   | `T=`       | &amp;x422;    | x422   | 1058   | D0 A2       | FF FE 22 04       | Lu
У                                  | CYRILLIC CAPITAL LETTER U                                                                                    | `U=`       | &amp;x423;    | x423   | 1059   | D0 A3       | FF FE 23 04       | Lu
Ф                                  | CYRILLIC CAPITAL LETTER EF                                                                                   | `F=`       | &amp;x424;    | x424   | 1060   | D0 A4       | FF FE 24 04       | Lu
Х                                  | CYRILLIC CAPITAL LETTER HA                                                                                   | `H=`       | &amp;x425;    | x425   | 1061   | D0 A5       | FF FE 25 04       | Lu
Ц                                  | CYRILLIC CAPITAL LETTER TSE                                                                                  | `C=`       | &amp;x426;    | x426   | 1062   | D0 A6       | FF FE 26 04       | Lu
Ч                                  | CYRILLIC CAPITAL LETTER CHE                                                                                  | `C%`       | &amp;x427;    | x427   | 1063   | D0 A7       | FF FE 27 04       | Lu
Ш                                  | CYRILLIC CAPITAL LETTER SHA                                                                                  | `S%`       | &amp;x428;    | x428   | 1064   | D0 A8       | FF FE 28 04       | Lu
Щ                                  | CYRILLIC CAPITAL LETTER SHCHA                                                                                | `Sc`       | &amp;x429;    | x429   | 1065   | D0 A9       | FF FE 29 04       | Lu
Ъ                                  | CYRILLIC CAPITAL LETTER HARD SIGN                                                                            | `="`       | &amp;x42A;    | x42A   | 1066   | D0 AA       | FF FE 2A 04       | Lu
Ы                                  | CYRILLIC CAPITAL LETTER YERU                                                                                 | `Y=`       | &amp;x42B;    | x42B   | 1067   | D0 AB       | FF FE 2B 04       | Lu
Ь                                  | CYRILLIC CAPITAL LETTER SOFT SIGN                                                                            | `%"`       | &amp;x42C;    | x42C   | 1068   | D0 AC       | FF FE 2C 04       | Lu
Э                                  | CYRILLIC CAPITAL LETTER E                                                                                    | `JE`       | &amp;x42D;    | x42D   | 1069   | D0 AD       | FF FE 2D 04       | Lu
Ю                                  | CYRILLIC CAPITAL LETTER YU                                                                                   | `JU`       | &amp;x42E;    | x42E   | 1070   | D0 AE       | FF FE 2E 04       | Lu
Я                                  | CYRILLIC CAPITAL LETTER YA                                                                                   | `JA`       | &amp;x42F;    | x42F   | 1071   | D0 AF       | FF FE 2F 04       | Lu
а                                  | CYRILLIC SMALL LETTER A                                                                                      | `a=`       | &amp;x430;    | x430   | 1072   | D0 B0       | FF FE 30 04       | Ll
б                                  | CYRILLIC SMALL LETTER BE                                                                                     | `b=`       | &amp;x431;    | x431   | 1073   | D0 B1       | FF FE 31 04       | Ll
в                                  | CYRILLIC SMALL LETTER VE                                                                                     | `v=`       | &amp;x432;    | x432   | 1074   | D0 B2       | FF FE 32 04       | Ll
г                                  | CYRILLIC SMALL LETTER GHE                                                                                    | `g=`       | &amp;x433;    | x433   | 1075   | D0 B3       | FF FE 33 04       | Ll
д                                  | CYRILLIC SMALL LETTER DE                                                                                     | `d=`       | &amp;x434;    | x434   | 1076   | D0 B4       | FF FE 34 04       | Ll
е                                  | CYRILLIC SMALL LETTER IE                                                                                     | `e=`       | &amp;x435;    | x435   | 1077   | D0 B5       | FF FE 35 04       | Ll
ж                                  | CYRILLIC SMALL LETTER ZHE                                                                                    | `z%`       | &amp;x436;    | x436   | 1078   | D0 B6       | FF FE 36 04       | Ll
з                                  | CYRILLIC SMALL LETTER ZE                                                                                     | `z=`       | &amp;x437;    | x437   | 1079   | D0 B7       | FF FE 37 04       | Ll
и                                  | CYRILLIC SMALL LETTER I                                                                                      | `i=`       | &amp;x438;    | x438   | 1080   | D0 B8       | FF FE 38 04       | Ll
й                                  | CYRILLIC SMALL LETTER SHORT I                                                                                | `j=`       | &amp;x439;    | x439   | 1081   | D0 B9       | FF FE 39 04       | Ll
к                                  | CYRILLIC SMALL LETTER KA                                                                                     | `k=`       | &amp;x43A;    | x43A   | 1082   | D0 BA       | FF FE 3A 04       | Ll
л                                  | CYRILLIC SMALL LETTER EL                                                                                     | `l=`       | &amp;x43B;    | x43B   | 1083   | D0 BB       | FF FE 3B 04       | Ll
м                                  | CYRILLIC SMALL LETTER EM                                                                                     | `m=`       | &amp;x43C;    | x43C   | 1084   | D0 BC       | FF FE 3C 04       | Ll
н                                  | CYRILLIC SMALL LETTER EN                                                                                     | `n=`       | &amp;x43D;    | x43D   | 1085   | D0 BD       | FF FE 3D 04       | Ll
о                                  | CYRILLIC SMALL LETTER O                                                                                      | `o=`       | &amp;x43E;    | x43E   | 1086   | D0 BE       | FF FE 3E 04       | Ll
п                                  | CYRILLIC SMALL LETTER PE                                                                                     | `p=`       | &amp;x43F;    | x43F   | 1087   | D0 BF       | FF FE 3F 04       | Ll
р                                  | CYRILLIC SMALL LETTER ER                                                                                     | `r=`       | &amp;x440;    | x440   | 1088   | D1 80       | FF FE 40 04       | Ll
с                                  | CYRILLIC SMALL LETTER ES                                                                                     | `s=`       | &amp;x441;    | x441   | 1089   | D1 81       | FF FE 41 04       | Ll
т                                  | CYRILLIC SMALL LETTER TE                                                                                     | `t=`       | &amp;x442;    | x442   | 1090   | D1 82       | FF FE 42 04       | Ll
у                                  | CYRILLIC SMALL LETTER U                                                                                      | `u=`       | &amp;x443;    | x443   | 1091   | D1 83       | FF FE 43 04       | Ll
ф                                  | CYRILLIC SMALL LETTER EF                                                                                     | `f=`       | &amp;x444;    | x444   | 1092   | D1 84       | FF FE 44 04       | Ll
х                                  | CYRILLIC SMALL LETTER HA                                                                                     | `h=`       | &amp;x445;    | x445   | 1093   | D1 85       | FF FE 45 04       | Ll
ц                                  | CYRILLIC SMALL LETTER TSE                                                                                    | `c=`       | &amp;x446;    | x446   | 1094   | D1 86       | FF FE 46 04       | Ll
ч                                  | CYRILLIC SMALL LETTER CHE                                                                                    | `c%`       | &amp;x447;    | x447   | 1095   | D1 87       | FF FE 47 04       | Ll
ш                                  | CYRILLIC SMALL LETTER SHA                                                                                    | `s%`       | &amp;x448;    | x448   | 1096   | D1 88       | FF FE 48 04       | Ll
щ                                  | CYRILLIC SMALL LETTER SHCHA                                                                                  | `sc`       | &amp;x449;    | x449   | 1097   | D1 89       | FF FE 49 04       | Ll
ъ                                  | CYRILLIC SMALL LETTER HARD SIGN                                                                              | `='`       | &amp;x44A;    | x44A   | 1098   | D1 8A       | FF FE 4A 04       | Ll
ы                                  | CYRILLIC SMALL LETTER YERU                                                                                   | `y=`       | &amp;x44B;    | x44B   | 1099   | D1 8B       | FF FE 4B 04       | Ll
ь                                  | CYRILLIC SMALL LETTER SOFT SIGN                                                                              | `%'`       | &amp;x44C;    | x44C   | 1100   | D1 8C       | FF FE 4C 04       | Ll
э                                  | CYRILLIC SMALL LETTER E                                                                                      | `je`       | &amp;x44D;    | x44D   | 1101   | D1 8D       | FF FE 4D 04       | Ll
ю                                  | CYRILLIC SMALL LETTER YU                                                                                     | `ju`       | &amp;x44E;    | x44E   | 1102   | D1 8E       | FF FE 4E 04       | Ll
я                                  | CYRILLIC SMALL LETTER YA                                                                                     | `ja`       | &amp;x44F;    | x44F   | 1103   | D1 8F       | FF FE 4F 04       | Ll
ё                                  | CYRILLIC SMALL LETTER IO                                                                                     | `io`       | &amp;x451;    | x451   | 1105   | D1 91       | FF FE 51 04       | Ll
ђ                                  | CYRILLIC SMALL LETTER DJE                                                                                    | `d%`       | &amp;x452;    | x452   | 1106   | D1 92       | FF FE 52 04       | Ll
ѓ                                  | CYRILLIC SMALL LETTER GJE                                                                                    | `g%`       | &amp;x453;    | x453   | 1107   | D1 93       | FF FE 53 04       | Ll
є                                  | CYRILLIC SMALL LETTER UKRAINIAN IE                                                                           | `ie`       | &amp;x454;    | x454   | 1108   | D1 94       | FF FE 54 04       | Ll
ѕ                                  | CYRILLIC SMALL LETTER DZE                                                                                    | `ds`       | &amp;x455;    | x455   | 1109   | D1 95       | FF FE 55 04       | Ll
і                                  | CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I                                                               | `ii`       | &amp;x456;    | x456   | 1110   | D1 96       | FF FE 56 04       | Ll
ї                                  | CYRILLIC SMALL LETTER YI                                                                                     | `yi`       | &amp;x457;    | x457   | 1111   | D1 97       | FF FE 57 04       | Ll
ј                                  | CYRILLIC SMALL LETTER JE                                                                                     | `j%`       | &amp;x458;    | x458   | 1112   | D1 98       | FF FE 58 04       | Ll
љ                                  | CYRILLIC SMALL LETTER LJE                                                                                    | `lj`       | &amp;x459;    | x459   | 1113   | D1 99       | FF FE 59 04       | Ll
њ                                  | CYRILLIC SMALL LETTER NJE                                                                                    | `nj`       | &amp;x45A;    | x45A   | 1114   | D1 9A       | FF FE 5A 04       | Ll
ћ                                  | CYRILLIC SMALL LETTER TSHE                                                                                   | `ts`       | &amp;x45B;    | x45B   | 1115   | D1 9B       | FF FE 5B 04       | Ll
ќ                                  | CYRILLIC SMALL LETTER KJE                                                                                    | `kj`       | &amp;x45C;    | x45C   | 1116   | D1 9C       | FF FE 5C 04       | Ll
ў                                  | CYRILLIC SMALL LETTER SHORT U                                                                                | `v%`       | &amp;x45E;    | x45E   | 1118   | D1 9E       | FF FE 5E 04       | Ll
џ                                  | CYRILLIC SMALL LETTER DZHE                                                                                   | `dz`       | &amp;x45F;    | x45F   | 1119   | D1 9F       | FF FE 5F 04       | Ll
Ѣ                                  | CYRILLIC CAPITAL LETTER YAT                                                                                  | `Y3`       | &amp;x462;    | x462   | 1122   | D1 A2       | FF FE 62 04       | Lu
ѣ                                  | CYRILLIC SMALL LETTER YAT                                                                                    | `y3`       | &amp;x463;    | x463   | 1123   | D1 A3       | FF FE 63 04       | Ll
Ѫ                                  | CYRILLIC CAPITAL LETTER BIG YUS                                                                              | `O3`       | &amp;x46A;    | x46A   | 1130   | D1 AA       | FF FE 6A 04       | Lu
ѫ                                  | CYRILLIC SMALL LETTER BIG YUS                                                                                | `o3`       | &amp;x46B;    | x46B   | 1131   | D1 AB       | FF FE 6B 04       | Ll
Ѳ                                  | CYRILLIC CAPITAL LETTER FITA                                                                                 | `F3`       | &amp;x472;    | x472   | 1138   | D1 B2       | FF FE 72 04       | Lu
ѳ                                  | CYRILLIC SMALL LETTER FITA                                                                                   | `f3`       | &amp;x473;    | x473   | 1139   | D1 B3       | FF FE 73 04       | Ll
Ѵ                                  | CYRILLIC CAPITAL LETTER IZHITSA                                                                              | `V3`       | &amp;x474;    | x474   | 1140   | D1 B4       | FF FE 74 04       | Lu
ѵ                                  | CYRILLIC SMALL LETTER IZHITSA                                                                                | `v3`       | &amp;x475;    | x475   | 1141   | D1 B5       | FF FE 75 04       | Ll
Ҁ                                  | CYRILLIC CAPITAL LETTER KOPPA                                                                                | `C3`       | &amp;x480;    | x480   | 1152   | D2 80       | FF FE 80 04       | Lu
ҁ                                  | CYRILLIC SMALL LETTER KOPPA                                                                                  | `c3`       | &amp;x481;    | x481   | 1153   | D2 81       | FF FE 81 04       | Ll
Ґ                                  | CYRILLIC CAPITAL LETTER GHE WITH UPTURN                                                                      | `G3`       | &amp;x490;    | x490   | 1168   | D2 90       | FF FE 90 04       | Lu
ґ                                  | CYRILLIC SMALL LETTER GHE WITH UPTURN                                                                        | `g3`       | &amp;x491;    | x491   | 1169   | D2 91       | FF FE 91 04       | Ll
א                                  | HEBREW LETTER ALEF                                                                                           | `A+`       | &amp;x5D0;    | x5D0   | 1488   | D7 90       | FF FE D0 05       | Lo
ב                                  | HEBREW LETTER BET                                                                                            | `B+`       | &amp;x5D1;    | x5D1   | 1489   | D7 91       | FF FE D1 05       | Lo
ג                                  | HEBREW LETTER GIMEL                                                                                          | `G+`       | &amp;x5D2;    | x5D2   | 1490   | D7 92       | FF FE D2 05       | Lo
ד                                  | HEBREW LETTER DALET                                                                                          | `D+`       | &amp;x5D3;    | x5D3   | 1491   | D7 93       | FF FE D3 05       | Lo
ה                                  | HEBREW LETTER HE                                                                                             | `H+`       | &amp;x5D4;    | x5D4   | 1492   | D7 94       | FF FE D4 05       | Lo
ו                                  | HEBREW LETTER VAV                                                                                            | `W+`       | &amp;x5D5;    | x5D5   | 1493   | D7 95       | FF FE D5 05       | Lo
ז                                  | HEBREW LETTER ZAYIN                                                                                          | `Z+`       | &amp;x5D6;    | x5D6   | 1494   | D7 96       | FF FE D6 05       | Lo
ח                                  | HEBREW LETTER HET                                                                                            | `X+`       | &amp;x5D7;    | x5D7   | 1495   | D7 97       | FF FE D7 05       | Lo
ט                                  | HEBREW LETTER TET                                                                                            | `Tj`       | &amp;x5D8;    | x5D8   | 1496   | D7 98       | FF FE D8 05       | Lo
י                                  | HEBREW LETTER YOD                                                                                            | `J+`       | &amp;x5D9;    | x5D9   | 1497   | D7 99       | FF FE D9 05       | Lo
ך                                  | HEBREW LETTER FINAL KAF                                                                                      | `K%`       | &amp;x5DA;    | x5DA   | 1498   | D7 9A       | FF FE DA 05       | Lo
כ                                  | HEBREW LETTER KAF                                                                                            | `K+`       | &amp;x5DB;    | x5DB   | 1499   | D7 9B       | FF FE DB 05       | Lo
ל                                  | HEBREW LETTER LAMED                                                                                          | `L+`       | &amp;x5DC;    | x5DC   | 1500   | D7 9C       | FF FE DC 05       | Lo
ם                                  | HEBREW LETTER FINAL MEM                                                                                      | `M%`       | &amp;x5DD;    | x5DD   | 1501   | D7 9D       | FF FE DD 05       | Lo
מ                                  | HEBREW LETTER MEM                                                                                            | `M+`       | &amp;x5DE;    | x5DE   | 1502   | D7 9E       | FF FE DE 05       | Lo
ן                                  | HEBREW LETTER FINAL NUN                                                                                      | `N%`       | &amp;x5DF;    | x5DF   | 1503   | D7 9F       | FF FE DF 05       | Lo
נ                                  | HEBREW LETTER NUN                                                                                            | `N+`       | &amp;x5E0;    | x5E0   | 1504   | D7 A0       | FF FE E0 05       | Lo
ס                                  | HEBREW LETTER SAMEKH                                                                                         | `S+`       | &amp;x5E1;    | x5E1   | 1505   | D7 A1       | FF FE E1 05       | Lo
ע                                  | HEBREW LETTER AYIN                                                                                           | `E+`       | &amp;x5E2;    | x5E2   | 1506   | D7 A2       | FF FE E2 05       | Lo
ף                                  | HEBREW LETTER FINAL PE                                                                                       | `P%`       | &amp;x5E3;    | x5E3   | 1507   | D7 A3       | FF FE E3 05       | Lo
פ                                  | HEBREW LETTER PE                                                                                             | `P+`       | &amp;x5E4;    | x5E4   | 1508   | D7 A4       | FF FE E4 05       | Lo
ץ                                  | HEBREW LETTER FINAL TSADI                                                                                    | `Zj`       | &amp;x5E5;    | x5E5   | 1509   | D7 A5       | FF FE E5 05       | Lo
צ                                  | HEBREW LETTER TSADI                                                                                          | `ZJ`       | &amp;x5E6;    | x5E6   | 1510   | D7 A6       | FF FE E6 05       | Lo
ק                                  | HEBREW LETTER QOF                                                                                            | `Q+`       | &amp;x5E7;    | x5E7   | 1511   | D7 A7       | FF FE E7 05       | Lo
ר                                  | HEBREW LETTER RESH                                                                                           | `R+`       | &amp;x5E8;    | x5E8   | 1512   | D7 A8       | FF FE E8 05       | Lo
ש                                  | HEBREW LETTER SHIN                                                                                           | `Sh`       | &amp;x5E9;    | x5E9   | 1513   | D7 A9       | FF FE E9 05       | Lo
ת                                  | HEBREW LETTER TAV                                                                                            | `T+`       | &amp;x5EA;    | x5EA   | 1514   | D7 AA       | FF FE EA 05       | Lo
،                                  | ARABIC COMMA                                                                                                 | `,+`       | &amp;x60C;    | x60C   | 1548   | D8 8C       | FF FE 0C 06       | Po
؛                                  | ARABIC SEMICOLON                                                                                             | `;+`       | &amp;x61B;    | x61B   | 1563   | D8 9B       | FF FE 1B 06       | Po
؟                                  | ARABIC QUESTION MARK                                                                                         | `?+`       | &amp;x61F;    | x61F   | 1567   | D8 9F       | FF FE 1F 06       | Po
ء                                  | ARABIC LETTER HAMZA                                                                                          | `H'`       | &amp;x621;    | x621   | 1569   | D8 A1       | FF FE 21 06       | Lo
آ                                  | ARABIC LETTER ALEF WITH MADDA ABOVE                                                                          | `aM`       | &amp;x622;    | x622   | 1570   | D8 A2       | FF FE 22 06       | Lo
أ                                  | ARABIC LETTER ALEF WITH HAMZA ABOVE                                                                          | `aH`       | &amp;x623;    | x623   | 1571   | D8 A3       | FF FE 23 06       | Lo
ؤ                                  | ARABIC LETTER WAW WITH HAMZA ABOVE                                                                           | `wH`       | &amp;x624;    | x624   | 1572   | D8 A4       | FF FE 24 06       | Lo
إ                                  | ARABIC LETTER ALEF WITH HAMZA BELOW                                                                          | `ah`       | &amp;x625;    | x625   | 1573   | D8 A5       | FF FE 25 06       | Lo
ئ                                  | ARABIC LETTER YEH WITH HAMZA ABOVE                                                                           | `yH`       | &amp;x626;    | x626   | 1574   | D8 A6       | FF FE 26 06       | Lo
ا                                  | ARABIC LETTER ALEF                                                                                           | `a+`       | &amp;x627;    | x627   | 1575   | D8 A7       | FF FE 27 06       | Lo
ب                                  | ARABIC LETTER BEH                                                                                            | `b+`       | &amp;x628;    | x628   | 1576   | D8 A8       | FF FE 28 06       | Lo
ة                                  | ARABIC LETTER TEH MARBUTA                                                                                    | `tm`       | &amp;x629;    | x629   | 1577   | D8 A9       | FF FE 29 06       | Lo
ت                                  | ARABIC LETTER TEH                                                                                            | `t+`       | &amp;x62A;    | x62A   | 1578   | D8 AA       | FF FE 2A 06       | Lo
ث                                  | ARABIC LETTER THEH                                                                                           | `tk`       | &amp;x62B;    | x62B   | 1579   | D8 AB       | FF FE 2B 06       | Lo
ج                                  | ARABIC LETTER JEEM                                                                                           | `g+`       | &amp;x62C;    | x62C   | 1580   | D8 AC       | FF FE 2C 06       | Lo
ح                                  | ARABIC LETTER HAH                                                                                            | `hk`       | &amp;x62D;    | x62D   | 1581   | D8 AD       | FF FE 2D 06       | Lo
خ                                  | ARABIC LETTER KHAH                                                                                           | `x+`       | &amp;x62E;    | x62E   | 1582   | D8 AE       | FF FE 2E 06       | Lo
د                                  | ARABIC LETTER DAL                                                                                            | `d+`       | &amp;x62F;    | x62F   | 1583   | D8 AF       | FF FE 2F 06       | Lo
ذ                                  | ARABIC LETTER THAL                                                                                           | `dk`       | &amp;x630;    | x630   | 1584   | D8 B0       | FF FE 30 06       | Lo
ر                                  | ARABIC LETTER REH                                                                                            | `r+`       | &amp;x631;    | x631   | 1585   | D8 B1       | FF FE 31 06       | Lo
ز                                  | ARABIC LETTER ZAIN                                                                                           | `z+`       | &amp;x632;    | x632   | 1586   | D8 B2       | FF FE 32 06       | Lo
س                                  | ARABIC LETTER SEEN                                                                                           | `s+`       | &amp;x633;    | x633   | 1587   | D8 B3       | FF FE 33 06       | Lo
ش                                  | ARABIC LETTER SHEEN                                                                                          | `sn`       | &amp;x634;    | x634   | 1588   | D8 B4       | FF FE 34 06       | Lo
ص                                  | ARABIC LETTER SAD                                                                                            | `c+`       | &amp;x635;    | x635   | 1589   | D8 B5       | FF FE 35 06       | Lo
ض                                  | ARABIC LETTER DAD                                                                                            | `dd`       | &amp;x636;    | x636   | 1590   | D8 B6       | FF FE 36 06       | Lo
ط                                  | ARABIC LETTER TAH                                                                                            | `tj`       | &amp;x637;    | x637   | 1591   | D8 B7       | FF FE 37 06       | Lo
ظ                                  | ARABIC LETTER ZAH                                                                                            | `zH`       | &amp;x638;    | x638   | 1592   | D8 B8       | FF FE 38 06       | Lo
ع                                  | ARABIC LETTER AIN                                                                                            | `e+`       | &amp;x639;    | x639   | 1593   | D8 B9       | FF FE 39 06       | Lo
غ                                  | ARABIC LETTER GHAIN                                                                                          | `i+`       | &amp;x63A;    | x63A   | 1594   | D8 BA       | FF FE 3A 06       | Lo
ـ                                  | ARABIC TATWEEL                                                                                               | `++`       | &amp;x640;    | x640   | 1600   | D9 80       | FF FE 40 06       | Lm
ف                                  | ARABIC LETTER FEH                                                                                            | `f+`       | &amp;x641;    | x641   | 1601   | D9 81       | FF FE 41 06       | Lo
ق                                  | ARABIC LETTER QAF                                                                                            | `q+`       | &amp;x642;    | x642   | 1602   | D9 82       | FF FE 42 06       | Lo
ك                                  | ARABIC LETTER KAF                                                                                            | `k+`       | &amp;x643;    | x643   | 1603   | D9 83       | FF FE 43 06       | Lo
ل                                  | ARABIC LETTER LAM                                                                                            | `l+`       | &amp;x644;    | x644   | 1604   | D9 84       | FF FE 44 06       | Lo
م                                  | ARABIC LETTER MEEM                                                                                           | `m+`       | &amp;x645;    | x645   | 1605   | D9 85       | FF FE 45 06       | Lo
ن                                  | ARABIC LETTER NOON                                                                                           | `n+`       | &amp;x646;    | x646   | 1606   | D9 86       | FF FE 46 06       | Lo
ه                                  | ARABIC LETTER HEH                                                                                            | `h+`       | &amp;x647;    | x647   | 1607   | D9 87       | FF FE 47 06       | Lo
و                                  | ARABIC LETTER WAW                                                                                            | `w+`       | &amp;x648;    | x648   | 1608   | D9 88       | FF FE 48 06       | Lo
ى                                  | ARABIC LETTER ALEF MAKSURA                                                                                   | `j+`       | &amp;x649;    | x649   | 1609   | D9 89       | FF FE 49 06       | Lo
ي                                  | ARABIC LETTER YEH                                                                                            | `y+`       | &amp;x64A;    | x64A   | 1610   | D9 8A       | FF FE 4A 06       | Lo
ً                                  | ARABIC FATHATAN                                                                                              | `:+`       | &amp;x64B;    | x64B   | 1611   | D9 8B       | FF FE 4B 06       | Mn
ٌ                                  | ARABIC DAMMATAN                                                                                              | `"+`       | &amp;x64C;    | x64C   | 1612   | D9 8C       | FF FE 4C 06       | Mn
ٍ                                  | ARABIC KASRATAN                                                                                              | `=+`       | &amp;x64D;    | x64D   | 1613   | D9 8D       | FF FE 4D 06       | Mn
َ                                  | ARABIC FATHA                                                                                                 | `/+`       | &amp;x64E;    | x64E   | 1614   | D9 8E       | FF FE 4E 06       | Mn
ُ                                  | ARABIC DAMMA                                                                                                 | `'+`       | &amp;x64F;    | x64F   | 1615   | D9 8F       | FF FE 4F 06       | Mn
ِ                                  | ARABIC KASRA                                                                                                 | `1+`       | &amp;x650;    | x650   | 1616   | D9 90       | FF FE 50 06       | Mn
ّ                                  | ARABIC SHADDA                                                                                                | `3+`       | &amp;x651;    | x651   | 1617   | D9 91       | FF FE 51 06       | Mn
ْ                                  | ARABIC SUKUN                                                                                                 | `0+`       | &amp;x652;    | x652   | 1618   | D9 92       | FF FE 52 06       | Mn
ٰ                                  | ARABIC LETTER SUPERSCRIPT ALEF                                                                               | `aS`       | &amp;x670;    | x670   | 1648   | D9 B0       | FF FE 70 06       | Mn
پ                                  | ARABIC LETTER PEH                                                                                            | `p+`       | &amp;x67E;    | x67E   | 1662   | D9 BE       | FF FE 7E 06       | Lo
ڤ                                  | ARABIC LETTER VEH                                                                                            | `v+`       | &amp;x6A4;    | x6A4   | 1700   | DA A4       | FF FE A4 06       | Lo
گ                                  | ARABIC LETTER GAF                                                                                            | `gf`       | &amp;x6AF;    | x6AF   | 1711   | DA AF       | FF FE AF 06       | Lo
۰                                  | EXTENDED ARABIC-INDIC DIGIT ZERO                                                                             | `0a`       | &amp;x6F0;    | x6F0   | 1776   | DB B0       | FF FE F0 06       | Nd
۱                                  | EXTENDED ARABIC-INDIC DIGIT ONE                                                                              | `1a`       | &amp;x6F1;    | x6F1   | 1777   | DB B1       | FF FE F1 06       | Nd
۲                                  | EXTENDED ARABIC-INDIC DIGIT TWO                                                                              | `2a`       | &amp;x6F2;    | x6F2   | 1778   | DB B2       | FF FE F2 06       | Nd
۳                                  | EXTENDED ARABIC-INDIC DIGIT THREE                                                                            | `3a`       | &amp;x6F3;    | x6F3   | 1779   | DB B3       | FF FE F3 06       | Nd
۴                                  | EXTENDED ARABIC-INDIC DIGIT FOUR                                                                             | `4a`       | &amp;x6F4;    | x6F4   | 1780   | DB B4       | FF FE F4 06       | Nd
۵                                  | EXTENDED ARABIC-INDIC DIGIT FIVE                                                                             | `5a`       | &amp;x6F5;    | x6F5   | 1781   | DB B5       | FF FE F5 06       | Nd
۶                                  | EXTENDED ARABIC-INDIC DIGIT SIX                                                                              | `6a`       | &amp;x6F6;    | x6F6   | 1782   | DB B6       | FF FE F6 06       | Nd
۷                                  | EXTENDED ARABIC-INDIC DIGIT SEVEN                                                                            | `7a`       | &amp;x6F7;    | x6F7   | 1783   | DB B7       | FF FE F7 06       | Nd
۸                                  | EXTENDED ARABIC-INDIC DIGIT EIGHT                                                                            | `8a`       | &amp;x6F8;    | x6F8   | 1784   | DB B8       | FF FE F8 06       | Nd
۹                                  | EXTENDED ARABIC-INDIC DIGIT NINE                                                                             | `9a`       | &amp;x6F9;    | x6F9   | 1785   | DB B9       | FF FE F9 06       | Nd
Ḃ                                  | LATIN CAPITAL LETTER B WITH DOT ABOVE                                                                        | `B.`       | &amp;x1E02;   | x1E02  | 7682   | E1 B8 82    | FF FE 02 1E       | Lu
ḃ                                  | LATIN SMALL LETTER B WITH DOT ABOVE                                                                          | `b.`       | &amp;x1E03;   | x1E03  | 7683   | E1 B8 83    | FF FE 03 1E       | Ll
Ḇ                                  | LATIN CAPITAL LETTER B WITH LINE BELOW                                                                       | `B_`       | &amp;x1E06;   | x1E06  | 7686   | E1 B8 86    | FF FE 06 1E       | Lu
ḇ                                  | LATIN SMALL LETTER B WITH LINE BELOW                                                                         | `b_`       | &amp;x1E07;   | x1E07  | 7687   | E1 B8 87    | FF FE 07 1E       | Ll
Ḋ                                  | LATIN CAPITAL LETTER D WITH DOT ABOVE                                                                        | `D.`       | &amp;x1E0A;   | x1E0A  | 7690   | E1 B8 8A    | FF FE 0A 1E       | Lu
ḋ                                  | LATIN SMALL LETTER D WITH DOT ABOVE                                                                          | `d.`       | &amp;x1E0B;   | x1E0B  | 7691   | E1 B8 8B    | FF FE 0B 1E       | Ll
Ḏ                                  | LATIN CAPITAL LETTER D WITH LINE BELOW                                                                       | `D_`       | &amp;x1E0E;   | x1E0E  | 7694   | E1 B8 8E    | FF FE 0E 1E       | Lu
ḏ                                  | LATIN SMALL LETTER D WITH LINE BELOW                                                                         | `d_`       | &amp;x1E0F;   | x1E0F  | 7695   | E1 B8 8F    | FF FE 0F 1E       | Ll
Ḑ                                  | LATIN CAPITAL LETTER D WITH CEDILLA                                                                          | `D,`       | &amp;x1E10;   | x1E10  | 7696   | E1 B8 90    | FF FE 10 1E       | Lu
ḑ                                  | LATIN SMALL LETTER D WITH CEDILLA                                                                            | `d,`       | &amp;x1E11;   | x1E11  | 7697   | E1 B8 91    | FF FE 11 1E       | Ll
Ḟ                                  | LATIN CAPITAL LETTER F WITH DOT ABOVE                                                                        | `F.`       | &amp;x1E1E;   | x1E1E  | 7710   | E1 B8 9E    | FF FE 1E 1E       | Lu
ḟ                                  | LATIN SMALL LETTER F WITH DOT ABOVE                                                                          | `f.`       | &amp;x1E1F;   | x1E1F  | 7711   | E1 B8 9F    | FF FE 1F 1E       | Ll
Ḡ                                  | LATIN CAPITAL LETTER G WITH MACRON                                                                           | `G-`       | &amp;x1E20;   | x1E20  | 7712   | E1 B8 A0    | FF FE 20 1E       | Lu
ḡ                                  | LATIN SMALL LETTER G WITH MACRON                                                                             | `g-`       | &amp;x1E21;   | x1E21  | 7713   | E1 B8 A1    | FF FE 21 1E       | Ll
Ḣ                                  | LATIN CAPITAL LETTER H WITH DOT ABOVE                                                                        | `H.`       | &amp;x1E22;   | x1E22  | 7714   | E1 B8 A2    | FF FE 22 1E       | Lu
ḣ                                  | LATIN SMALL LETTER H WITH DOT ABOVE                                                                          | `h.`       | &amp;x1E23;   | x1E23  | 7715   | E1 B8 A3    | FF FE 23 1E       | Ll
Ḧ                                  | LATIN CAPITAL LETTER H WITH DIAERESIS                                                                        | `H:`       | &amp;x1E26;   | x1E26  | 7718   | E1 B8 A6    | FF FE 26 1E       | Lu
ḧ                                  | LATIN SMALL LETTER H WITH DIAERESIS                                                                          | `h:`       | &amp;x1E27;   | x1E27  | 7719   | E1 B8 A7    | FF FE 27 1E       | Ll
Ḩ                                  | LATIN CAPITAL LETTER H WITH CEDILLA                                                                          | `H,`       | &amp;x1E28;   | x1E28  | 7720   | E1 B8 A8    | FF FE 28 1E       | Lu
ḩ                                  | LATIN SMALL LETTER H WITH CEDILLA                                                                            | `h,`       | &amp;x1E29;   | x1E29  | 7721   | E1 B8 A9    | FF FE 29 1E       | Ll
Ḱ                                  | LATIN CAPITAL LETTER K WITH ACUTE                                                                            | `K'`       | &amp;x1E30;   | x1E30  | 7728   | E1 B8 B0    | FF FE 30 1E       | Lu
ḱ                                  | LATIN SMALL LETTER K WITH ACUTE                                                                              | `k'`       | &amp;x1E31;   | x1E31  | 7729   | E1 B8 B1    | FF FE 31 1E       | Ll
Ḵ                                  | LATIN CAPITAL LETTER K WITH LINE BELOW                                                                       | `K_`       | &amp;x1E34;   | x1E34  | 7732   | E1 B8 B4    | FF FE 34 1E       | Lu
ḵ                                  | LATIN SMALL LETTER K WITH LINE BELOW                                                                         | `k_`       | &amp;x1E35;   | x1E35  | 7733   | E1 B8 B5    | FF FE 35 1E       | Ll
Ḻ                                  | LATIN CAPITAL LETTER L WITH LINE BELOW                                                                       | `L_`       | &amp;x1E3A;   | x1E3A  | 7738   | E1 B8 BA    | FF FE 3A 1E       | Lu
ḻ                                  | LATIN SMALL LETTER L WITH LINE BELOW                                                                         | `l_`       | &amp;x1E3B;   | x1E3B  | 7739   | E1 B8 BB    | FF FE 3B 1E       | Ll
Ḿ                                  | LATIN CAPITAL LETTER M WITH ACUTE                                                                            | `M'`       | &amp;x1E3E;   | x1E3E  | 7742   | E1 B8 BE    | FF FE 3E 1E       | Lu
ḿ                                  | LATIN SMALL LETTER M WITH ACUTE                                                                              | `m'`       | &amp;x1E3F;   | x1E3F  | 7743   | E1 B8 BF    | FF FE 3F 1E       | Ll
Ṁ                                  | LATIN CAPITAL LETTER M WITH DOT ABOVE                                                                        | `M.`       | &amp;x1E40;   | x1E40  | 7744   | E1 B9 80    | FF FE 40 1E       | Lu
ṁ                                  | LATIN SMALL LETTER M WITH DOT ABOVE                                                                          | `m.`       | &amp;x1E41;   | x1E41  | 7745   | E1 B9 81    | FF FE 41 1E       | Ll
Ṅ                                  | LATIN CAPITAL LETTER N WITH DOT ABOVE                                                                        | `N.`       | &amp;x1E44;   | x1E44  | 7748   | E1 B9 84    | FF FE 44 1E       | Lu
ṅ                                  | LATIN SMALL LETTER N WITH DOT ABOVE                                                                          | `n.`       | &amp;x1E45;   | x1E45  | 7749   | E1 B9 85    | FF FE 45 1E       | Ll
Ṉ                                  | LATIN CAPITAL LETTER N WITH LINE BELOW                                                                       | `N_`       | &amp;x1E48;   | x1E48  | 7752   | E1 B9 88    | FF FE 48 1E       | Lu
ṉ                                  | LATIN SMALL LETTER N WITH LINE BELOW                                                                         | `n_`       | &amp;x1E49;   | x1E49  | 7753   | E1 B9 89    | FF FE 49 1E       | Ll
Ṕ                                  | LATIN CAPITAL LETTER P WITH ACUTE                                                                            | `P'`       | &amp;x1E54;   | x1E54  | 7764   | E1 B9 94    | FF FE 54 1E       | Lu
ṕ                                  | LATIN SMALL LETTER P WITH ACUTE                                                                              | `p'`       | &amp;x1E55;   | x1E55  | 7765   | E1 B9 95    | FF FE 55 1E       | Ll
Ṗ                                  | LATIN CAPITAL LETTER P WITH DOT ABOVE                                                                        | `P.`       | &amp;x1E56;   | x1E56  | 7766   | E1 B9 96    | FF FE 56 1E       | Lu
ṗ                                  | LATIN SMALL LETTER P WITH DOT ABOVE                                                                          | `p.`       | &amp;x1E57;   | x1E57  | 7767   | E1 B9 97    | FF FE 57 1E       | Ll
Ṙ                                  | LATIN CAPITAL LETTER R WITH DOT ABOVE                                                                        | `R.`       | &amp;x1E58;   | x1E58  | 7768   | E1 B9 98    | FF FE 58 1E       | Lu
ṙ                                  | LATIN SMALL LETTER R WITH DOT ABOVE                                                                          | `r.`       | &amp;x1E59;   | x1E59  | 7769   | E1 B9 99    | FF FE 59 1E       | Ll
Ṟ                                  | LATIN CAPITAL LETTER R WITH LINE BELOW                                                                       | `R_`       | &amp;x1E5E;   | x1E5E  | 7774   | E1 B9 9E    | FF FE 5E 1E       | Lu
ṟ                                  | LATIN SMALL LETTER R WITH LINE BELOW                                                                         | `r_`       | &amp;x1E5F;   | x1E5F  | 7775   | E1 B9 9F    | FF FE 5F 1E       | Ll
Ṡ                                  | LATIN CAPITAL LETTER S WITH DOT ABOVE                                                                        | `S.`       | &amp;x1E60;   | x1E60  | 7776   | E1 B9 A0    | FF FE 60 1E       | Lu
ṡ                                  | LATIN SMALL LETTER S WITH DOT ABOVE                                                                          | `s.`       | &amp;x1E61;   | x1E61  | 7777   | E1 B9 A1    | FF FE 61 1E       | Ll
Ṫ                                  | LATIN CAPITAL LETTER T WITH DOT ABOVE                                                                        | `T.`       | &amp;x1E6A;   | x1E6A  | 7786   | E1 B9 AA    | FF FE 6A 1E       | Lu
ṫ                                  | LATIN SMALL LETTER T WITH DOT ABOVE                                                                          | `t.`       | &amp;x1E6B;   | x1E6B  | 7787   | E1 B9 AB    | FF FE 6B 1E       | Ll
Ṯ                                  | LATIN CAPITAL LETTER T WITH LINE BELOW                                                                       | `T_`       | &amp;x1E6E;   | x1E6E  | 7790   | E1 B9 AE    | FF FE 6E 1E       | Lu
ṯ                                  | LATIN SMALL LETTER T WITH LINE BELOW                                                                         | `t_`       | &amp;x1E6F;   | x1E6F  | 7791   | E1 B9 AF    | FF FE 6F 1E       | Ll
Ṽ                                  | LATIN CAPITAL LETTER V WITH TILDE                                                                            | `V?`       | &amp;x1E7C;   | x1E7C  | 7804   | E1 B9 BC    | FF FE 7C 1E       | Lu
ṽ                                  | LATIN SMALL LETTER V WITH TILDE                                                                              | `v?`       | &amp;x1E7D;   | x1E7D  | 7805   | E1 B9 BD    | FF FE 7D 1E       | Ll
Ẁ                                  | LATIN CAPITAL LETTER W WITH GRAVE                                                                            | `W!`       | &amp;x1E80;   | x1E80  | 7808   | E1 BA 80    | FF FE 80 1E       | Lu
ẁ                                  | LATIN SMALL LETTER W WITH GRAVE                                                                              | `w!`       | &amp;x1E81;   | x1E81  | 7809   | E1 BA 81    | FF FE 81 1E       | Ll
Ẃ                                  | LATIN CAPITAL LETTER W WITH ACUTE                                                                            | `W'`       | &amp;x1E82;   | x1E82  | 7810   | E1 BA 82    | FF FE 82 1E       | Lu
ẃ                                  | LATIN SMALL LETTER W WITH ACUTE                                                                              | `w'`       | &amp;x1E83;   | x1E83  | 7811   | E1 BA 83    | FF FE 83 1E       | Ll
Ẅ                                  | LATIN CAPITAL LETTER W WITH DIAERESIS                                                                        | `W:`       | &amp;x1E84;   | x1E84  | 7812   | E1 BA 84    | FF FE 84 1E       | Lu
ẅ                                  | LATIN SMALL LETTER W WITH DIAERESIS                                                                          | `w:`       | &amp;x1E85;   | x1E85  | 7813   | E1 BA 85    | FF FE 85 1E       | Ll
Ẇ                                  | LATIN CAPITAL LETTER W WITH DOT ABOVE                                                                        | `W.`       | &amp;x1E86;   | x1E86  | 7814   | E1 BA 86    | FF FE 86 1E       | Lu
ẇ                                  | LATIN SMALL LETTER W WITH DOT ABOVE                                                                          | `w.`       | &amp;x1E87;   | x1E87  | 7815   | E1 BA 87    | FF FE 87 1E       | Ll
Ẋ                                  | LATIN CAPITAL LETTER X WITH DOT ABOVE                                                                        | `X.`       | &amp;x1E8A;   | x1E8A  | 7818   | E1 BA 8A    | FF FE 8A 1E       | Lu
ẋ                                  | LATIN SMALL LETTER X WITH DOT ABOVE                                                                          | `x.`       | &amp;x1E8B;   | x1E8B  | 7819   | E1 BA 8B    | FF FE 8B 1E       | Ll
Ẍ                                  | LATIN CAPITAL LETTER X WITH DIAERESIS                                                                        | `X:`       | &amp;x1E8C;   | x1E8C  | 7820   | E1 BA 8C    | FF FE 8C 1E       | Lu
ẍ                                  | LATIN SMALL LETTER X WITH DIAERESIS                                                                          | `x:`       | &amp;x1E8D;   | x1E8D  | 7821   | E1 BA 8D    | FF FE 8D 1E       | Ll
Ẏ                                  | LATIN CAPITAL LETTER Y WITH DOT ABOVE                                                                        | `Y.`       | &amp;x1E8E;   | x1E8E  | 7822   | E1 BA 8E    | FF FE 8E 1E       | Lu
ẏ                                  | LATIN SMALL LETTER Y WITH DOT ABOVE                                                                          | `y.`       | &amp;x1E8F;   | x1E8F  | 7823   | E1 BA 8F    | FF FE 8F 1E       | Ll
Ẑ                                  | LATIN CAPITAL LETTER Z WITH CIRCUMFLEX                                                                       | `Z>`       | &amp;x1E90;   | x1E90  | 7824   | E1 BA 90    | FF FE 90 1E       | Lu
ẑ                                  | LATIN SMALL LETTER Z WITH CIRCUMFLEX                                                                         | `z>`       | &amp;x1E91;   | x1E91  | 7825   | E1 BA 91    | FF FE 91 1E       | Ll
Ẕ                                  | LATIN CAPITAL LETTER Z WITH LINE BELOW                                                                       | `Z_`       | &amp;x1E94;   | x1E94  | 7828   | E1 BA 94    | FF FE 94 1E       | Lu
ẕ                                  | LATIN SMALL LETTER Z WITH LINE BELOW                                                                         | `z_`       | &amp;x1E95;   | x1E95  | 7829   | E1 BA 95    | FF FE 95 1E       | Ll
ẖ                                  | LATIN SMALL LETTER H WITH LINE BELOW                                                                         | `h_`       | &amp;x1E96;   | x1E96  | 7830   | E1 BA 96    | FF FE 96 1E       | Ll
ẗ                                  | LATIN SMALL LETTER T WITH DIAERESIS                                                                          | `t:`       | &amp;x1E97;   | x1E97  | 7831   | E1 BA 97    | FF FE 97 1E       | Ll
ẘ                                  | LATIN SMALL LETTER W WITH RING ABOVE                                                                         | `w0`       | &amp;x1E98;   | x1E98  | 7832   | E1 BA 98    | FF FE 98 1E       | Ll
ẙ                                  | LATIN SMALL LETTER Y WITH RING ABOVE                                                                         | `y0`       | &amp;x1E99;   | x1E99  | 7833   | E1 BA 99    | FF FE 99 1E       | Ll
Ả                                  | LATIN CAPITAL LETTER A WITH HOOK ABOVE                                                                       | `A2`       | &amp;x1EA2;   | x1EA2  | 7842   | E1 BA A2    | FF FE A2 1E       | Lu
ả                                  | LATIN SMALL LETTER A WITH HOOK ABOVE                                                                         | `a2`       | &amp;x1EA3;   | x1EA3  | 7843   | E1 BA A3    | FF FE A3 1E       | Ll
Ẻ                                  | LATIN CAPITAL LETTER E WITH HOOK ABOVE                                                                       | `E2`       | &amp;x1EBA;   | x1EBA  | 7866   | E1 BA BA    | FF FE BA 1E       | Lu
ẻ                                  | LATIN SMALL LETTER E WITH HOOK ABOVE                                                                         | `e2`       | &amp;x1EBB;   | x1EBB  | 7867   | E1 BA BB    | FF FE BB 1E       | Ll
Ẽ                                  | LATIN CAPITAL LETTER E WITH TILDE                                                                            | `E?`       | &amp;x1EBC;   | x1EBC  | 7868   | E1 BA BC    | FF FE BC 1E       | Lu
ẽ                                  | LATIN SMALL LETTER E WITH TILDE                                                                              | `e?`       | &amp;x1EBD;   | x1EBD  | 7869   | E1 BA BD    | FF FE BD 1E       | Ll
Ỉ                                  | LATIN CAPITAL LETTER I WITH HOOK ABOVE                                                                       | `I2`       | &amp;x1EC8;   | x1EC8  | 7880   | E1 BB 88    | FF FE C8 1E       | Lu
ỉ                                  | LATIN SMALL LETTER I WITH HOOK ABOVE                                                                         | `i2`       | &amp;x1EC9;   | x1EC9  | 7881   | E1 BB 89    | FF FE C9 1E       | Ll
Ỏ                                  | LATIN CAPITAL LETTER O WITH HOOK ABOVE                                                                       | `O2`       | &amp;x1ECE;   | x1ECE  | 7886   | E1 BB 8E    | FF FE CE 1E       | Lu
ỏ                                  | LATIN SMALL LETTER O WITH HOOK ABOVE                                                                         | `o2`       | &amp;x1ECF;   | x1ECF  | 7887   | E1 BB 8F    | FF FE CF 1E       | Ll
Ủ                                  | LATIN CAPITAL LETTER U WITH HOOK ABOVE                                                                       | `U2`       | &amp;x1EE6;   | x1EE6  | 7910   | E1 BB A6    | FF FE E6 1E       | Lu
ủ                                  | LATIN SMALL LETTER U WITH HOOK ABOVE                                                                         | `u2`       | &amp;x1EE7;   | x1EE7  | 7911   | E1 BB A7    | FF FE E7 1E       | Ll
Ỳ                                  | LATIN CAPITAL LETTER Y WITH GRAVE                                                                            | `Y!`       | &amp;x1EF2;   | x1EF2  | 7922   | E1 BB B2    | FF FE F2 1E       | Lu
ỳ                                  | LATIN SMALL LETTER Y WITH GRAVE                                                                              | `y!`       | &amp;x1EF3;   | x1EF3  | 7923   | E1 BB B3    | FF FE F3 1E       | Ll
Ỷ                                  | LATIN CAPITAL LETTER Y WITH HOOK ABOVE                                                                       | `Y2`       | &amp;x1EF6;   | x1EF6  | 7926   | E1 BB B6    | FF FE F6 1E       | Lu
ỷ                                  | LATIN SMALL LETTER Y WITH HOOK ABOVE                                                                         | `y2`       | &amp;x1EF7;   | x1EF7  | 7927   | E1 BB B7    | FF FE F7 1E       | Ll
Ỹ                                  | LATIN CAPITAL LETTER Y WITH TILDE                                                                            | `Y?`       | &amp;x1EF8;   | x1EF8  | 7928   | E1 BB B8    | FF FE F8 1E       | Lu
ỹ                                  | LATIN SMALL LETTER Y WITH TILDE                                                                              | `y?`       | &amp;x1EF9;   | x1EF9  | 7929   | E1 BB B9    | FF FE F9 1E       | Ll
ἀ                                  | GREEK SMALL LETTER ALPHA WITH PSILI                                                                          | `;'`       | &amp;x1F00;   | x1F00  | 7936   | E1 BC 80    | FF FE 00 1F       | Ll
ἁ                                  | GREEK SMALL LETTER ALPHA WITH DASIA                                                                          | `,'`       | &amp;x1F01;   | x1F01  | 7937   | E1 BC 81    | FF FE 01 1F       | Ll
ἂ                                  | GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA                                                                | `;!`       | &amp;x1F02;   | x1F02  | 7938   | E1 BC 82    | FF FE 02 1F       | Ll
ἃ                                  | GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA                                                                | `,!`       | &amp;x1F03;   | x1F03  | 7939   | E1 BC 83    | FF FE 03 1F       | Ll
ἄ                                  | GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA                                                                 | `?;`       | &amp;x1F04;   | x1F04  | 7940   | E1 BC 84    | FF FE 04 1F       | Ll
ἅ                                  | GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA                                                                 | `?,`       | &amp;x1F05;   | x1F05  | 7941   | E1 BC 85    | FF FE 05 1F       | Ll
ἆ                                  | GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI                                                          | `!:`       | &amp;x1F06;   | x1F06  | 7942   | E1 BC 86    | FF FE 06 1F       | Ll
ἇ                                  | GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI                                                          | `?:`       | &amp;x1F07;   | x1F07  | 7943   | E1 BC 87    | FF FE 07 1F       | Ll
                                   | EN SPACE                                                                                                     | `1N`       | &amp;ensp;    | x2002  | 8194   | E2 80 82    | FF FE 02 20       | Zs
                                   | EM SPACE                                                                                                     | `1M`       | &amp;emsp;    | x2003  | 8195   | E2 80 83    | FF FE 03 20       | Zs
                                   | THREE-PER-EM SPACE                                                                                           | `3M`       | &amp;x2004;   | x2004  | 8196   | E2 80 84    | FF FE 04 20       | Zs
                                   | FOUR-PER-EM SPACE                                                                                            | `4M`       | &amp;x2005;   | x2005  | 8197   | E2 80 85    | FF FE 05 20       | Zs
                                   | SIX-PER-EM SPACE                                                                                             | `6M`       | &amp;x2006;   | x2006  | 8198   | E2 80 86    | FF FE 06 20       | Zs
                                   | THIN SPACE                                                                                                   | `1T`       | &amp;thinsp;  | x2009  | 8201   | E2 80 89    | FF FE 09 20       | Zs
                                   | HAIR SPACE                                                                                                   | `1H`       | &amp;x200A;   | x200A  | 8202   | E2 80 8A    | FF FE 0A 20       | Zs
‐                                  | HYPHEN                                                                                                       | `-1`       | &amp;x2010;   | x2010  | 8208   | E2 80 90    | FF FE 10 20       | Pd
–                                  | EN DASH                                                                                                      | `-N`       | &amp;ndash;   | x2013  | 8211   | E2 80 93    | FF FE 13 20       | Pd
—                                  | EM DASH                                                                                                      | `-M`       | &amp;mdash;   | x2014  | 8212   | E2 80 94    | FF FE 14 20       | Pd
―                                  | HORIZONTAL BAR                                                                                               | `-3`       | &amp;x2015;   | x2015  | 8213   | E2 80 95    | FF FE 15 20       | Pd
‖                                  | DOUBLE VERTICAL LINE                                                                                         | `!2`       | &amp;x2016;   | x2016  | 8214   | E2 80 96    | FF FE 16 20       | Po
‗                                  | DOUBLE LOW LINE                                                                                              | `=2`       | &amp;x2017;   | x2017  | 8215   | E2 80 97    | FF FE 17 20       | Po
‘                                  | LEFT SINGLE QUOTATION MARK                                                                                   | `'6`       | &amp;lsquo;   | x2018  | 8216   | E2 80 98    | FF FE 18 20       | Pi
’                                  | RIGHT SINGLE QUOTATION MARK                                                                                  | `'9`       | &amp;rsquo;   | x2019  | 8217   | E2 80 99    | FF FE 19 20       | Pf
‚                                  | SINGLE LOW-9 QUOTATION MARK                                                                                  | `.9`       | &amp;sbquo;   | x201A  | 8218   | E2 80 9A    | FF FE 1A 20       | Ps
‛                                  | SINGLE HIGH-REVERSED-9 QUOTATION MARK                                                                        | `9'`       | &amp;x201B;   | x201B  | 8219   | E2 80 9B    | FF FE 1B 20       | Pi
“                                  | LEFT DOUBLE QUOTATION MARK                                                                                   | `"6`       | &amp;ldquo;   | x201C  | 8220   | E2 80 9C    | FF FE 1C 20       | Pi
”                                  | RIGHT DOUBLE QUOTATION MARK                                                                                  | `"9`       | &amp;rdquo;   | x201D  | 8221   | E2 80 9D    | FF FE 1D 20       | Pf
„                                  | DOUBLE LOW-9 QUOTATION MARK                                                                                  | `:9`       | &amp;bdquo;   | x201E  | 8222   | E2 80 9E    | FF FE 1E 20       | Ps
‟                                  | DOUBLE HIGH-REVERSED-9 QUOTATION MARK                                                                        | `9"`       | &amp;x201F;   | x201F  | 8223   | E2 80 9F    | FF FE 1F 20       | Pi
†                                  | DAGGER                                                                                                       | `/-`       | &amp;dagger;  | x2020  | 8224   | E2 80 A0    | FF FE 20 20       | Po
‡                                  | DOUBLE DAGGER                                                                                                | `/=`       | &amp;Dagger;  | x2021  | 8225   | E2 80 A1    | FF FE 21 20       | Po
‥                                  | TWO DOT LEADER                                                                                               | `..`       | &amp;x2025;   | x2025  | 8229   | E2 80 A5    | FF FE 25 20       | Po
…                                  | HORIZONTAL ELLIPSIS                                                                                          | `,.`       | &amp;hellip;  | x2026  | 8230   | E2 80 A6    | FF FE 26 20       | Po
‰                                  | PER MILLE SIGN                                                                                               | `%0`       | &amp;permil;  | x2030  | 8240   | E2 80 B0    | FF FE 30 20       | Po
′                                  | PRIME                                                                                                        | `1'`       | &amp;prime;   | x2032  | 8242   | E2 80 B2    | FF FE 32 20       | Po
″                                  | DOUBLE PRIME                                                                                                 | `2'`       | &amp;Prime;   | x2033  | 8243   | E2 80 B3    | FF FE 33 20       | Po
‴                                  | TRIPLE PRIME                                                                                                 | `3'`       | &amp;x2034;   | x2034  | 8244   | E2 80 B4    | FF FE 34 20       | Po
‵                                  | REVERSED PRIME                                                                                               | `1"`       | &amp;x2035;   | x2035  | 8245   | E2 80 B5    | FF FE 35 20       | Po
‶                                  | REVERSED DOUBLE PRIME                                                                                        | `2"`       | &amp;x2036;   | x2036  | 8246   | E2 80 B6    | FF FE 36 20       | Po
‷                                  | REVERSED TRIPLE PRIME                                                                                        | `3"`       | &amp;x2037;   | x2037  | 8247   | E2 80 B7    | FF FE 37 20       | Po
‸                                  | CARET                                                                                                        | `Ca`       | &amp;x2038;   | x2038  | 8248   | E2 80 B8    | FF FE 38 20       | Po
‹                                  | SINGLE LEFT-POINTING ANGLE QUOTATION MARK                                                                    | `<1`       | &amp;lsaquo;  | x2039  | 8249   | E2 80 B9    | FF FE 39 20       | Pi
›                                  | SINGLE RIGHT-POINTING ANGLE QUOTATION MARK                                                                   | `>1`       | &amp;rsaquo;  | x203A  | 8250   | E2 80 BA    | FF FE 3A 20       | Pf
※                                  | REFERENCE MARK                                                                                               | `:X`       | &amp;x203B;   | x203B  | 8251   | E2 80 BB    | FF FE 3B 20       | Po
‾                                  | OVERLINE                                                                                                     | `'-`       | &amp;oline;   | x203E  | 8254   | E2 80 BE    | FF FE 3E 20       | Po
⁄                                  | FRACTION SLASH                                                                                               | `/f`       | &amp;frasl;   | x2044  | 8260   | E2 81 84    | FF FE 44 20       | Sm
⁰                                  | SUPERSCRIPT ZERO                                                                                             | `0S`       | &amp;x2070;   | x2070  | 8304   | E2 81 B0    | FF FE 70 20       | No
⁴                                  | SUPERSCRIPT FOUR                                                                                             | `4S`       | &amp;x2074;   | x2074  | 8308   | E2 81 B4    | FF FE 74 20       | No
⁵                                  | SUPERSCRIPT FIVE                                                                                             | `5S`       | &amp;x2075;   | x2075  | 8309   | E2 81 B5    | FF FE 75 20       | No
⁶                                  | SUPERSCRIPT SIX                                                                                              | `6S`       | &amp;x2076;   | x2076  | 8310   | E2 81 B6    | FF FE 76 20       | No
⁷                                  | SUPERSCRIPT SEVEN                                                                                            | `7S`       | &amp;x2077;   | x2077  | 8311   | E2 81 B7    | FF FE 77 20       | No
⁸                                  | SUPERSCRIPT EIGHT                                                                                            | `8S`       | &amp;x2078;   | x2078  | 8312   | E2 81 B8    | FF FE 78 20       | No
⁹                                  | SUPERSCRIPT NINE                                                                                             | `9S`       | &amp;x2079;   | x2079  | 8313   | E2 81 B9    | FF FE 79 20       | No
⁺                                  | SUPERSCRIPT PLUS SIGN                                                                                        | `+S`       | &amp;x207A;   | x207A  | 8314   | E2 81 BA    | FF FE 7A 20       | Sm
⁻                                  | SUPERSCRIPT MINUS                                                                                            | `-S`       | &amp;x207B;   | x207B  | 8315   | E2 81 BB    | FF FE 7B 20       | Sm
⁼                                  | SUPERSCRIPT EQUALS SIGN                                                                                      | `=S`       | &amp;x207C;   | x207C  | 8316   | E2 81 BC    | FF FE 7C 20       | Sm
⁽                                  | SUPERSCRIPT LEFT PARENTHESIS                                                                                 | `(S`       | &amp;x207D;   | x207D  | 8317   | E2 81 BD    | FF FE 7D 20       | Ps
⁾                                  | SUPERSCRIPT RIGHT PARENTHESIS                                                                                | `)S`       | &amp;x207E;   | x207E  | 8318   | E2 81 BE    | FF FE 7E 20       | Pe
ⁿ                                  | SUPERSCRIPT LATIN SMALL LETTER N                                                                             | `nS`       | &amp;x207F;   | x207F  | 8319   | E2 81 BF    | FF FE 7F 20       | Lm
₀                                  | SUBSCRIPT ZERO                                                                                               | `0s`       | &amp;x2080;   | x2080  | 8320   | E2 82 80    | FF FE 80 20       | No
₁                                  | SUBSCRIPT ONE                                                                                                | `1s`       | &amp;x2081;   | x2081  | 8321   | E2 82 81    | FF FE 81 20       | No
₂                                  | SUBSCRIPT TWO                                                                                                | `2s`       | &amp;x2082;   | x2082  | 8322   | E2 82 82    | FF FE 82 20       | No
₃                                  | SUBSCRIPT THREE                                                                                              | `3s`       | &amp;x2083;   | x2083  | 8323   | E2 82 83    | FF FE 83 20       | No
₄                                  | SUBSCRIPT FOUR                                                                                               | `4s`       | &amp;x2084;   | x2084  | 8324   | E2 82 84    | FF FE 84 20       | No
₅                                  | SUBSCRIPT FIVE                                                                                               | `5s`       | &amp;x2085;   | x2085  | 8325   | E2 82 85    | FF FE 85 20       | No
₆                                  | SUBSCRIPT SIX                                                                                                | `6s`       | &amp;x2086;   | x2086  | 8326   | E2 82 86    | FF FE 86 20       | No
₇                                  | SUBSCRIPT SEVEN                                                                                              | `7s`       | &amp;x2087;   | x2087  | 8327   | E2 82 87    | FF FE 87 20       | No
₈                                  | SUBSCRIPT EIGHT                                                                                              | `8s`       | &amp;x2088;   | x2088  | 8328   | E2 82 88    | FF FE 88 20       | No
₉                                  | SUBSCRIPT NINE                                                                                               | `9s`       | &amp;x2089;   | x2089  | 8329   | E2 82 89    | FF FE 89 20       | No
₊                                  | SUBSCRIPT PLUS SIGN                                                                                          | `+s`       | &amp;x208A;   | x208A  | 8330   | E2 82 8A    | FF FE 8A 20       | Sm
₋                                  | SUBSCRIPT MINUS                                                                                              | `-s`       | &amp;x208B;   | x208B  | 8331   | E2 82 8B    | FF FE 8B 20       | Sm
₌                                  | SUBSCRIPT EQUALS SIGN                                                                                        | `=s`       | &amp;x208C;   | x208C  | 8332   | E2 82 8C    | FF FE 8C 20       | Sm
₍                                  | SUBSCRIPT LEFT PARENTHESIS                                                                                   | `(s`       | &amp;x208D;   | x208D  | 8333   | E2 82 8D    | FF FE 8D 20       | Ps
₎                                  | SUBSCRIPT RIGHT PARENTHESIS                                                                                  | `)s`       | &amp;x208E;   | x208E  | 8334   | E2 82 8E    | FF FE 8E 20       | Pe
₤                                  | LIRA SIGN                                                                                                    | `Li`       | &amp;x20A4;   | x20A4  | 8356   | E2 82 A4    | FF FE A4 20       | Sc
₧                                  | PESETA SIGN                                                                                                  | `Pt`       | &amp;x20A7;   | x20A7  | 8359   | E2 82 A7    | FF FE A7 20       | Sc
₩                                  | WON SIGN                                                                                                     | `W=`       | &amp;x20A9;   | x20A9  | 8361   | E2 82 A9    | FF FE A9 20       | Sc
€                                  | EURO SIGN                                                                                                    | `Eu`       | &amp;euro;    | x20AC  | 8364   | E2 82 AC    | FF FE AC 20       | Sc
₽                                  | ROUBLE SIGN                                                                                                  | `=R`, `=P` | &amp;x20BD;   | x20BD  | 8381   | E2 82 BD    | FF FE BD 20       | Sc
℃                                  | DEGREE CELSIUS                                                                                               | `oC`       | &amp;x2103;   | x2103  | 8451   | E2 84 83    | FF FE 03 21       | So
℅                                  | CARE OF                                                                                                      | `co`       | &amp;x2105;   | x2105  | 8453   | E2 84 85    | FF FE 05 21       | So
℉                                  | DEGREE FAHRENHEIT                                                                                            | `oF`       | &amp;x2109;   | x2109  | 8457   | E2 84 89    | FF FE 09 21       | So
№                                  | NUMERO SIGN                                                                                                  | `N0`       | &amp;x2116;   | x2116  | 8470   | E2 84 96    | FF FE 16 21       | So
℗                                  | SOUND RECORDING COPYRIGHT                                                                                    | `PO`       | &amp;x2117;   | x2117  | 8471   | E2 84 97    | FF FE 17 21       | So
℞                                  | PRESCRIPTION TAKE                                                                                            | `Rx`       | &amp;x211E;   | x211E  | 8478   | E2 84 9E    | FF FE 1E 21       | So
℠                                  | SERVICE MARK                                                                                                 | `SM`       | &amp;x2120;   | x2120  | 8480   | E2 84 A0    | FF FE 20 21       | So
™                                  | TRADE MARK SIGN                                                                                              | `TM`       | &amp;trade;   | x2122  | 8482   | E2 84 A2    | FF FE 22 21       | So
Ω                                  | OHM SIGN                                                                                                     | `Om`       | &amp;x2126;   | x2126  | 8486   | E2 84 A6    | FF FE 26 21       | Lu
Å                                  | ANGSTROM SIGN                                                                                                | `AO`       | &amp;x212B;   | x212B  | 8491   | E2 84 AB    | FF FE 2B 21       | Lu
⅓                                  | VULGAR FRACTION ONE THIRD                                                                                    | `13`       | &amp;x2153;   | x2153  | 8531   | E2 85 93    | FF FE 53 21       | No
⅔                                  | VULGAR FRACTION TWO THIRDS                                                                                   | `23`       | &amp;x2154;   | x2154  | 8532   | E2 85 94    | FF FE 54 21       | No
⅕                                  | VULGAR FRACTION ONE FIFTH                                                                                    | `15`       | &amp;x2155;   | x2155  | 8533   | E2 85 95    | FF FE 55 21       | No
⅖                                  | VULGAR FRACTION TWO FIFTHS                                                                                   | `25`       | &amp;x2156;   | x2156  | 8534   | E2 85 96    | FF FE 56 21       | No
⅗                                  | VULGAR FRACTION THREE FIFTHS                                                                                 | `35`       | &amp;x2157;   | x2157  | 8535   | E2 85 97    | FF FE 57 21       | No
⅘                                  | VULGAR FRACTION FOUR FIFTHS                                                                                  | `45`       | &amp;x2158;   | x2158  | 8536   | E2 85 98    | FF FE 58 21       | No
⅙                                  | VULGAR FRACTION ONE SIXTH                                                                                    | `16`       | &amp;x2159;   | x2159  | 8537   | E2 85 99    | FF FE 59 21       | No
⅚                                  | VULGAR FRACTION FIVE SIXTHS                                                                                  | `56`       | &amp;x215A;   | x215A  | 8538   | E2 85 9A    | FF FE 5A 21       | No
⅛                                  | VULGAR FRACTION ONE EIGHTH                                                                                   | `18`       | &amp;x215B;   | x215B  | 8539   | E2 85 9B    | FF FE 5B 21       | No
⅜                                  | VULGAR FRACTION THREE EIGHTHS                                                                                | `38`       | &amp;x215C;   | x215C  | 8540   | E2 85 9C    | FF FE 5C 21       | No
⅝                                  | VULGAR FRACTION FIVE EIGHTHS                                                                                 | `58`       | &amp;x215D;   | x215D  | 8541   | E2 85 9D    | FF FE 5D 21       | No
⅞                                  | VULGAR FRACTION SEVEN EIGHTHS                                                                                | `78`       | &amp;x215E;   | x215E  | 8542   | E2 85 9E    | FF FE 5E 21       | No
Ⅰ                                  | ROMAN NUMERAL ONE                                                                                            | `1R`       | &amp;x2160;   | x2160  | 8544   | E2 85 A0    | FF FE 60 21       | Nl
Ⅱ                                  | ROMAN NUMERAL TWO                                                                                            | `2R`       | &amp;x2161;   | x2161  | 8545   | E2 85 A1    | FF FE 61 21       | Nl
Ⅲ                                  | ROMAN NUMERAL THREE                                                                                          | `3R`       | &amp;x2162;   | x2162  | 8546   | E2 85 A2    | FF FE 62 21       | Nl
Ⅳ                                  | ROMAN NUMERAL FOUR                                                                                           | `4R`       | &amp;x2163;   | x2163  | 8547   | E2 85 A3    | FF FE 63 21       | Nl
Ⅴ                                  | ROMAN NUMERAL FIVE                                                                                           | `5R`       | &amp;x2164;   | x2164  | 8548   | E2 85 A4    | FF FE 64 21       | Nl
Ⅵ                                  | ROMAN NUMERAL SIX                                                                                            | `6R`       | &amp;x2165;   | x2165  | 8549   | E2 85 A5    | FF FE 65 21       | Nl
Ⅶ                                  | ROMAN NUMERAL SEVEN                                                                                          | `7R`       | &amp;x2166;   | x2166  | 8550   | E2 85 A6    | FF FE 66 21       | Nl
Ⅷ                                  | ROMAN NUMERAL EIGHT                                                                                          | `8R`       | &amp;x2167;   | x2167  | 8551   | E2 85 A7    | FF FE 67 21       | Nl
Ⅸ                                  | ROMAN NUMERAL NINE                                                                                           | `9R`       | &amp;x2168;   | x2168  | 8552   | E2 85 A8    | FF FE 68 21       | Nl
Ⅹ                                  | ROMAN NUMERAL TEN                                                                                            | `aR`       | &amp;x2169;   | x2169  | 8553   | E2 85 A9    | FF FE 69 21       | Nl
Ⅺ                                  | ROMAN NUMERAL ELEVEN                                                                                         | `bR`       | &amp;x216A;   | x216A  | 8554   | E2 85 AA    | FF FE 6A 21       | Nl
Ⅻ                                  | ROMAN NUMERAL TWELVE                                                                                         | `cR`       | &amp;x216B;   | x216B  | 8555   | E2 85 AB    | FF FE 6B 21       | Nl
ⅰ                                  | SMALL ROMAN NUMERAL ONE                                                                                      | `1r`       | &amp;x2170;   | x2170  | 8560   | E2 85 B0    | FF FE 70 21       | Nl
ⅱ                                  | SMALL ROMAN NUMERAL TWO                                                                                      | `2r`       | &amp;x2171;   | x2171  | 8561   | E2 85 B1    | FF FE 71 21       | Nl
ⅲ                                  | SMALL ROMAN NUMERAL THREE                                                                                    | `3r`       | &amp;x2172;   | x2172  | 8562   | E2 85 B2    | FF FE 72 21       | Nl
ⅳ                                  | SMALL ROMAN NUMERAL FOUR                                                                                     | `4r`       | &amp;x2173;   | x2173  | 8563   | E2 85 B3    | FF FE 73 21       | Nl
ⅴ                                  | SMALL ROMAN NUMERAL FIVE                                                                                     | `5r`       | &amp;x2174;   | x2174  | 8564   | E2 85 B4    | FF FE 74 21       | Nl
ⅵ                                  | SMALL ROMAN NUMERAL SIX                                                                                      | `6r`       | &amp;x2175;   | x2175  | 8565   | E2 85 B5    | FF FE 75 21       | Nl
ⅶ                                  | SMALL ROMAN NUMERAL SEVEN                                                                                    | `7r`       | &amp;x2176;   | x2176  | 8566   | E2 85 B6    | FF FE 76 21       | Nl
ⅷ                                  | SMALL ROMAN NUMERAL EIGHT                                                                                    | `8r`       | &amp;x2177;   | x2177  | 8567   | E2 85 B7    | FF FE 77 21       | Nl
ⅸ                                  | SMALL ROMAN NUMERAL NINE                                                                                     | `9r`       | &amp;x2178;   | x2178  | 8568   | E2 85 B8    | FF FE 78 21       | Nl
ⅹ                                  | SMALL ROMAN NUMERAL TEN                                                                                      | `ar`       | &amp;x2179;   | x2179  | 8569   | E2 85 B9    | FF FE 79 21       | Nl
ⅺ                                  | SMALL ROMAN NUMERAL ELEVEN                                                                                   | `br`       | &amp;x217A;   | x217A  | 8570   | E2 85 BA    | FF FE 7A 21       | Nl
ⅻ                                  | SMALL ROMAN NUMERAL TWELVE                                                                                   | `cr`       | &amp;x217B;   | x217B  | 8571   | E2 85 BB    | FF FE 7B 21       | Nl
←                                  | LEFTWARDS ARROW                                                                                              | `<-`       | &amp;larr;    | x2190  | 8592   | E2 86 90    | FF FE 90 21       | Sm
↑                                  | UPWARDS ARROW                                                                                                | `-!`       | &amp;uarr;    | x2191  | 8593   | E2 86 91    | FF FE 91 21       | Sm
→                                  | RIGHTWARDS ARROW                                                                                             | `->`       | &amp;rarr;    | x2192  | 8594   | E2 86 92    | FF FE 92 21       | Sm
↓                                  | DOWNWARDS ARROW                                                                                              | `-v`       | &amp;darr;    | x2193  | 8595   | E2 86 93    | FF FE 93 21       | Sm
↔                                  | LEFT RIGHT ARROW                                                                                             | `<>`       | &amp;harr;    | x2194  | 8596   | E2 86 94    | FF FE 94 21       | Sm
↕                                  | UP DOWN ARROW                                                                                                | `UD`       | &amp;x2195;   | x2195  | 8597   | E2 86 95    | FF FE 95 21       | So
⇐                                  | LEFTWARDS DOUBLE ARROW                                                                                       | `<=`       | &amp;lArr;    | x21D0  | 8656   | E2 87 90    | FF FE D0 21       | So
⇒                                  | RIGHTWARDS DOUBLE ARROW                                                                                      | `=>`       | &amp;rArr;    | x21D2  | 8658   | E2 87 92    | FF FE D2 21       | Sm
⇔                                  | LEFT RIGHT DOUBLE ARROW                                                                                      | `==`       | &amp;hArr;    | x21D4  | 8660   | E2 87 94    | FF FE D4 21       | Sm
∀                                  | FOR ALL                                                                                                      | `FA`       | &amp;forall;  | x2200  | 8704   | E2 88 80    | FF FE 00 22       | Sm
∂                                  | PARTIAL DIFFERENTIAL                                                                                         | `dP`       | &amp;part;    | x2202  | 8706   | E2 88 82    | FF FE 02 22       | Sm
∃                                  | THERE EXISTS                                                                                                 | `TE`       | &amp;exist;   | x2203  | 8707   | E2 88 83    | FF FE 03 22       | Sm
∅                                  | EMPTY SET                                                                                                    | `/0`       | &amp;empty;   | x2205  | 8709   | E2 88 85    | FF FE 05 22       | Sm
∆                                  | INCREMENT                                                                                                    | `DE`       | &amp;x2206;   | x2206  | 8710   | E2 88 86    | FF FE 06 22       | Sm
∇                                  | NABLA                                                                                                        | `NB`       | &amp;nabla;   | x2207  | 8711   | E2 88 87    | FF FE 07 22       | Sm
∈                                  | ELEMENT OF                                                                                                   | `(-`       | &amp;isin;    | x2208  | 8712   | E2 88 88    | FF FE 08 22       | Sm
∋                                  | CONTAINS AS MEMBER                                                                                           | `-)`       | &amp;ni;      | x220B  | 8715   | E2 88 8B    | FF FE 0B 22       | Sm
∏                                  | N-ARY PRODUCT                                                                                                | `*P`       | &amp;prod;    | x220F  | 8719   | E2 88 8F    | FF FE 0F 22       | Sm
∑                                  | N-ARY SUMMATION                                                                                              | `+Z`       | &amp;sum;     | x2211  | 8721   | E2 88 91    | FF FE 11 22       | Sm
−                                  | MINUS SIGN                                                                                                   | `-2`       | &amp;minus;   | x2212  | 8722   | E2 88 92    | FF FE 12 22       | Sm
∓                                  | MINUS-OR-PLUS SIGN                                                                                           | `-+`       | &amp;x2213;   | x2213  | 8723   | E2 88 93    | FF FE 13 22       | Sm
∗                                  | ASTERISK OPERATOR                                                                                            | `*-`       | &amp;lowast;  | x2217  | 8727   | E2 88 97    | FF FE 17 22       | Sm
∘                                  | RING OPERATOR                                                                                                | `Ob`       | &amp;x2218;   | x2218  | 8728   | E2 88 98    | FF FE 18 22       | Sm
∙                                  | BULLET OPERATOR                                                                                              | `Sb`       | &amp;x2219;   | x2219  | 8729   | E2 88 99    | FF FE 19 22       | Sm
√                                  | SQUARE ROOT                                                                                                  | `RT`       | &amp;radic;   | x221A  | 8730   | E2 88 9A    | FF FE 1A 22       | Sm
∝                                  | PROPORTIONAL TO                                                                                              | `0(`       | &amp;prop;    | x221D  | 8733   | E2 88 9D    | FF FE 1D 22       | Sm
∞                                  | INFINITY                                                                                                     | `00`       | &amp;infin;   | x221E  | 8734   | E2 88 9E    | FF FE 1E 22       | Sm
∟                                  | RIGHT ANGLE                                                                                                  | `-L`       | &amp;x221F;   | x221F  | 8735   | E2 88 9F    | FF FE 1F 22       | Sm
∠                                  | ANGLE                                                                                                        | `-V`       | &amp;ang;     | x2220  | 8736   | E2 88 A0    | FF FE 20 22       | Sm
∥                                  | PARALLEL TO                                                                                                  | `PP`       | &amp;x2225;   | x2225  | 8741   | E2 88 A5    | FF FE 25 22       | Sm
∧                                  | LOGICAL AND                                                                                                  | `AN`       | &amp;and;     | x2227  | 8743   | E2 88 A7    | FF FE 27 22       | Sm
∨                                  | LOGICAL OR                                                                                                   | `OR`       | &amp;or;      | x2228  | 8744   | E2 88 A8    | FF FE 28 22       | Sm
∩                                  | INTERSECTION                                                                                                 | `(U`       | &amp;cap;     | x2229  | 8745   | E2 88 A9    | FF FE 29 22       | Sm
∪                                  | UNION                                                                                                        | `)U`       | &amp;cup;     | x222A  | 8746   | E2 88 AA    | FF FE 2A 22       | Sm
∫                                  | INTEGRAL                                                                                                     | `In`       | &amp;int;     | x222B  | 8747   | E2 88 AB    | FF FE 2B 22       | Sm
∬                                  | DOUBLE INTEGRAL                                                                                              | `DI`       | &amp;x222C;   | x222C  | 8748   | E2 88 AC    | FF FE 2C 22       | Sm
∮                                  | CONTOUR INTEGRAL                                                                                             | `Io`       | &amp;x222E;   | x222E  | 8750   | E2 88 AE    | FF FE 2E 22       | Sm
∴                                  | THEREFORE                                                                                                    | `.:`       | &amp;there4;  | x2234  | 8756   | E2 88 B4    | FF FE 34 22       | Sm
∵                                  | BECAUSE                                                                                                      | `:.`       | &amp;x2235;   | x2235  | 8757   | E2 88 B5    | FF FE 35 22       | Sm
∶                                  | RATIO                                                                                                        | `:R`       | &amp;x2236;   | x2236  | 8758   | E2 88 B6    | FF FE 36 22       | Sm
∷                                  | PROPORTION                                                                                                   | `::`       | &amp;x2237;   | x2237  | 8759   | E2 88 B7    | FF FE 37 22       | Sm
∼                                  | TILDE OPERATOR                                                                                               | `?1`       | &amp;sim;     | x223C  | 8764   | E2 88 BC    | FF FE 3C 22       | Sm
∾                                  | INVERTED LAZY S                                                                                              | `CG`       | &amp;x223E;   | x223E  | 8766   | E2 88 BE    | FF FE 3E 22       | Sm
≃                                  | ASYMPTOTICALLY EQUAL TO                                                                                      | `?-`       | &amp;x2243;   | x2243  | 8771   | E2 89 83    | FF FE 43 22       | Sm
≅                                  | APPROXIMATELY EQUAL TO                                                                                       | `?=`       | &amp;cong;    | x2245  | 8773   | E2 89 85    | FF FE 45 22       | Sm
≈                                  | ALMOST EQUAL TO                                                                                              | `?2`       | &amp;asymp;   | x2248  | 8776   | E2 89 88    | FF FE 48 22       | Sm
≌                                  | ALL EQUAL TO                                                                                                 | `=?`       | &amp;x224C;   | x224C  | 8780   | E2 89 8C    | FF FE 4C 22       | Sm
≓                                  | IMAGE OF OR APPROXIMATELY EQUAL TO                                                                           | `HI`       | &amp;x2253;   | x2253  | 8787   | E2 89 93    | FF FE 53 22       | Sm
≠                                  | NOT EQUAL TO                                                                                                 | `!=`       | &amp;ne;      | x2260  | 8800   | E2 89 A0    | FF FE 60 22       | Sm
≡                                  | IDENTICAL TO                                                                                                 | `=3`       | &amp;equiv;   | x2261  | 8801   | E2 89 A1    | FF FE 61 22       | Sm
≤                                  | LESS-THAN OR EQUAL TO                                                                                        | `=<`       | &amp;le;      | x2264  | 8804   | E2 89 A4    | FF FE 64 22       | Sm
≥                                  | GREATER-THAN OR EQUAL TO                                                                                     | `>=`       | &amp;ge;      | x2265  | 8805   | E2 89 A5    | FF FE 65 22       | Sm
≪                                  | MUCH LESS-THAN                                                                                               | `<*`       | &amp;x226A;   | x226A  | 8810   | E2 89 AA    | FF FE 6A 22       | Sm
≫                                  | MUCH GREATER-THAN                                                                                            | `*>`       | &amp;x226B;   | x226B  | 8811   | E2 89 AB    | FF FE 6B 22       | Sm
≮                                  | NOT LESS-THAN                                                                                                | `!<`       | &amp;x226E;   | x226E  | 8814   | E2 89 AE    | FF FE 6E 22       | Sm
≯                                  | NOT GREATER-THAN                                                                                             | `!>`       | &amp;x226F;   | x226F  | 8815   | E2 89 AF    | FF FE 6F 22       | Sm
⊂                                  | SUBSET OF                                                                                                    | `(C`       | &amp;sub;     | x2282  | 8834   | E2 8A 82    | FF FE 82 22       | Sm
⊃                                  | SUPERSET OF                                                                                                  | `)C`       | &amp;sup;     | x2283  | 8835   | E2 8A 83    | FF FE 83 22       | Sm
⊆                                  | SUBSET OF OR EQUAL TO                                                                                        | `(_`       | &amp;sube;    | x2286  | 8838   | E2 8A 86    | FF FE 86 22       | Sm
⊇                                  | SUPERSET OF OR EQUAL TO                                                                                      | `)_`       | &amp;supe;    | x2287  | 8839   | E2 8A 87    | FF FE 87 22       | Sm
⊙                                  | CIRCLED DOT OPERATOR                                                                                         | `0.`       | &amp;x2299;   | x2299  | 8857   | E2 8A 99    | FF FE 99 22       | Sm
⊚                                  | CIRCLED RING OPERATOR                                                                                        | `02`       | &amp;x229A;   | x229A  | 8858   | E2 8A 9A    | FF FE 9A 22       | Sm
⊥                                  | UP TACK                                                                                                      | `-T`       | &amp;perp;    | x22A5  | 8869   | E2 8A A5    | FF FE A5 22       | Sm
⋅                                  | DOT OPERATOR                                                                                                 | `.P`       | &amp;sdot;    | x22C5  | 8901   | E2 8B 85    | FF FE C5 22       | Sm
⋮                                  | VERTICAL ELLIPSIS                                                                                            | `:3`       | &amp;x22EE;   | x22EE  | 8942   | E2 8B AE    | FF FE EE 22       | Sm
⋯                                  | MIDLINE HORIZONTAL ELLIPSIS                                                                                  | `.3`       | &amp;x22EF;   | x22EF  | 8943   | E2 8B AF    | FF FE EF 22       | Sm
⌂                                  | HOUSE                                                                                                        | `Eh`       | &amp;x2302;   | x2302  | 8962   | E2 8C 82    | FF FE 02 23       | So
⌈                                  | LEFT CEILING                                                                                                 | `<7`       | &amp;lceil;   | x2308  | 8968   | E2 8C 88    | FF FE 08 23       | Ps
⌉                                  | RIGHT CEILING                                                                                                | `>7`       | &amp;rceil;   | x2309  | 8969   | E2 8C 89    | FF FE 09 23       | Pe
⌊                                  | LEFT FLOOR                                                                                                   | `7<`       | &amp;lfloor;  | x230A  | 8970   | E2 8C 8A    | FF FE 0A 23       | Ps
⌋                                  | RIGHT FLOOR                                                                                                  | `7>`       | &amp;rfloor;  | x230B  | 8971   | E2 8C 8B    | FF FE 0B 23       | Pe
⌐                                  | REVERSED NOT SIGN                                                                                            | `NI`       | &amp;x2310;   | x2310  | 8976   | E2 8C 90    | FF FE 10 23       | So
⌒                                  | ARC                                                                                                          | `(A`       | &amp;x2312;   | x2312  | 8978   | E2 8C 92    | FF FE 12 23       | So
⌕                                  | TELEPHONE RECORDER                                                                                           | `TR`       | &amp;x2315;   | x2315  | 8981   | E2 8C 95    | FF FE 15 23       | So
⌠                                  | TOP HALF INTEGRAL                                                                                            | `Iu`       | &amp;x2320;   | x2320  | 8992   | E2 8C A0    | FF FE 20 23       | Sm
⌡                                  | BOTTOM HALF INTEGRAL                                                                                         | `Il`       | &amp;x2321;   | x2321  | 8993   | E2 8C A1    | FF FE 21 23       | Sm
〈                                  | LEFT-POINTING ANGLE BRACKET                                                                                  | `</`       | &amp;lang;    | x2329  | 9001   | E2 8C A9    | FF FE 29 23       | Ps
〉                                  | RIGHT-POINTING ANGLE BRACKET                                                                                 | `/>`       | &amp;rang;    | x232A  | 9002   | E2 8C AA    | FF FE 2A 23       | Pe
␣                                  | OPEN BOX                                                                                                     | `Vs`       | &amp;x2423;   | x2423  | 9251   | E2 90 A3    | FF FE 23 24       | So
⑀                                  | OCR HOOK                                                                                                     | `1h`       | &amp;x2440;   | x2440  | 9280   | E2 91 80    | FF FE 40 24       | So
⑁                                  | OCR CHAIR                                                                                                    | `3h`       | &amp;x2441;   | x2441  | 9281   | E2 91 81    | FF FE 41 24       | So
⑂                                  | OCR FORK                                                                                                     | `2h`       | &amp;x2442;   | x2442  | 9282   | E2 91 82    | FF FE 42 24       | So
⑃                                  | OCR INVERTED FORK                                                                                            | `4h`       | &amp;x2443;   | x2443  | 9283   | E2 91 83    | FF FE 43 24       | So
⑆                                  | OCR BRANCH BANK IDENTIFICATION                                                                               | `1j`       | &amp;x2446;   | x2446  | 9286   | E2 91 86    | FF FE 46 24       | So
⑇                                  | OCR AMOUNT OF CHECK                                                                                          | `2j`       | &amp;x2447;   | x2447  | 9287   | E2 91 87    | FF FE 47 24       | So
⑈                                  | OCR DASH                                                                                                     | `3j`       | &amp;x2448;   | x2448  | 9288   | E2 91 88    | FF FE 48 24       | So
⑉                                  | OCR CUSTOMER ACCOUNT NUMBER                                                                                  | `4j`       | &amp;x2449;   | x2449  | 9289   | E2 91 89    | FF FE 49 24       | So
⒈                                  | DIGIT ONE FULL STOP                                                                                          | `1.`       | &amp;x2488;   | x2488  | 9352   | E2 92 88    | FF FE 88 24       | No
⒉                                  | DIGIT TWO FULL STOP                                                                                          | `2.`       | &amp;x2489;   | x2489  | 9353   | E2 92 89    | FF FE 89 24       | No
⒊                                  | DIGIT THREE FULL STOP                                                                                        | `3.`       | &amp;x248A;   | x248A  | 9354   | E2 92 8A    | FF FE 8A 24       | No
⒋                                  | DIGIT FOUR FULL STOP                                                                                         | `4.`       | &amp;x248B;   | x248B  | 9355   | E2 92 8B    | FF FE 8B 24       | No
⒌                                  | DIGIT FIVE FULL STOP                                                                                         | `5.`       | &amp;x248C;   | x248C  | 9356   | E2 92 8C    | FF FE 8C 24       | No
⒍                                  | DIGIT SIX FULL STOP                                                                                          | `6.`       | &amp;x248D;   | x248D  | 9357   | E2 92 8D    | FF FE 8D 24       | No
⒎                                  | DIGIT SEVEN FULL STOP                                                                                        | `7.`       | &amp;x248E;   | x248E  | 9358   | E2 92 8E    | FF FE 8E 24       | No
⒏                                  | DIGIT EIGHT FULL STOP                                                                                        | `8.`       | &amp;x248F;   | x248F  | 9359   | E2 92 8F    | FF FE 8F 24       | No
⒐                                  | DIGIT NINE FULL STOP                                                                                         | `9.`       | &amp;x2490;   | x2490  | 9360   | E2 92 90    | FF FE 90 24       | No
─                                  | BOX DRAWINGS LIGHT HORIZONTAL                                                                                | `hh`       | &amp;x2500;   | x2500  | 9472   | E2 94 80    | FF FE 00 25       | So
━                                  | BOX DRAWINGS HEAVY HORIZONTAL                                                                                | `HH`       | &amp;x2501;   | x2501  | 9473   | E2 94 81    | FF FE 01 25       | So
│                                  | BOX DRAWINGS LIGHT VERTICAL                                                                                  | `vv`       | &amp;x2502;   | x2502  | 9474   | E2 94 82    | FF FE 02 25       | So
┃                                  | BOX DRAWINGS HEAVY VERTICAL                                                                                  | `VV`       | &amp;x2503;   | x2503  | 9475   | E2 94 83    | FF FE 03 25       | So
┄                                  | BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL                                                                    | `3-`       | &amp;x2504;   | x2504  | 9476   | E2 94 84    | FF FE 04 25       | So
┅                                  | BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL                                                                    | `3_`       | &amp;x2505;   | x2505  | 9477   | E2 94 85    | FF FE 05 25       | So
┆                                  | BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL                                                                      | `3!`       | &amp;x2506;   | x2506  | 9478   | E2 94 86    | FF FE 06 25       | So
┇                                  | BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL                                                                      | `3/`       | &amp;x2507;   | x2507  | 9479   | E2 94 87    | FF FE 07 25       | So
┈                                  | BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL                                                                 | `4-`       | &amp;x2508;   | x2508  | 9480   | E2 94 88    | FF FE 08 25       | So
┉                                  | BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL                                                                 | `4_`       | &amp;x2509;   | x2509  | 9481   | E2 94 89    | FF FE 09 25       | So
┊                                  | BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL                                                                   | `4!`       | &amp;x250A;   | x250A  | 9482   | E2 94 8A    | FF FE 0A 25       | So
┋                                  | BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL                                                                   | `4/`       | &amp;x250B;   | x250B  | 9483   | E2 94 8B    | FF FE 0B 25       | So
┌                                  | BOX DRAWINGS LIGHT DOWN AND RIGHT                                                                            | `dr`       | &amp;x250C;   | x250C  | 9484   | E2 94 8C    | FF FE 0C 25       | So
┍                                  | BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY                                                                      | `dR`       | &amp;x250D;   | x250D  | 9485   | E2 94 8D    | FF FE 0D 25       | So
┎                                  | BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT                                                                      | `Dr`       | &amp;x250E;   | x250E  | 9486   | E2 94 8E    | FF FE 0E 25       | So
┏                                  | BOX DRAWINGS HEAVY DOWN AND RIGHT                                                                            | `DR`       | &amp;x250F;   | x250F  | 9487   | E2 94 8F    | FF FE 0F 25       | So
┐                                  | BOX DRAWINGS LIGHT DOWN AND LEFT                                                                             | `dl`       | &amp;x2510;   | x2510  | 9488   | E2 94 90    | FF FE 10 25       | So
┑                                  | BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY                                                                       | `dL`       | &amp;x2511;   | x2511  | 9489   | E2 94 91    | FF FE 11 25       | So
┒                                  | BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT                                                                       | `Dl`       | &amp;x2512;   | x2512  | 9490   | E2 94 92    | FF FE 12 25       | So
┓                                  | BOX DRAWINGS HEAVY DOWN AND LEFT                                                                             | `LD`       | &amp;x2513;   | x2513  | 9491   | E2 94 93    | FF FE 13 25       | So
└                                  | BOX DRAWINGS LIGHT UP AND RIGHT                                                                              | `ur`       | &amp;x2514;   | x2514  | 9492   | E2 94 94    | FF FE 14 25       | So
┕                                  | BOX DRAWINGS UP LIGHT AND RIGHT HEAVY                                                                        | `uR`       | &amp;x2515;   | x2515  | 9493   | E2 94 95    | FF FE 15 25       | So
┖                                  | BOX DRAWINGS UP HEAVY AND RIGHT LIGHT                                                                        | `Ur`       | &amp;x2516;   | x2516  | 9494   | E2 94 96    | FF FE 16 25       | So
┗                                  | BOX DRAWINGS HEAVY UP AND RIGHT                                                                              | `UR`       | &amp;x2517;   | x2517  | 9495   | E2 94 97    | FF FE 17 25       | So
┘                                  | BOX DRAWINGS LIGHT UP AND LEFT                                                                               | `ul`       | &amp;x2518;   | x2518  | 9496   | E2 94 98    | FF FE 18 25       | So
┙                                  | BOX DRAWINGS UP LIGHT AND LEFT HEAVY                                                                         | `uL`       | &amp;x2519;   | x2519  | 9497   | E2 94 99    | FF FE 19 25       | So
┚                                  | BOX DRAWINGS UP HEAVY AND LEFT LIGHT                                                                         | `Ul`       | &amp;x251A;   | x251A  | 9498   | E2 94 9A    | FF FE 1A 25       | So
┛                                  | BOX DRAWINGS HEAVY UP AND LEFT                                                                               | `UL`       | &amp;x251B;   | x251B  | 9499   | E2 94 9B    | FF FE 1B 25       | So
├                                  | BOX DRAWINGS LIGHT VERTICAL AND RIGHT                                                                        | `vr`       | &amp;x251C;   | x251C  | 9500   | E2 94 9C    | FF FE 1C 25       | So
┝                                  | BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY                                                                  | `vR`       | &amp;x251D;   | x251D  | 9501   | E2 94 9D    | FF FE 1D 25       | So
┠                                  | BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT                                                                  | `Vr`       | &amp;x2520;   | x2520  | 9504   | E2 94 A0    | FF FE 20 25       | So
┣                                  | BOX DRAWINGS HEAVY VERTICAL AND RIGHT                                                                        | `VR`       | &amp;x2523;   | x2523  | 9507   | E2 94 A3    | FF FE 23 25       | So
┤                                  | BOX DRAWINGS LIGHT VERTICAL AND LEFT                                                                         | `vl`       | &amp;x2524;   | x2524  | 9508   | E2 94 A4    | FF FE 24 25       | So
┥                                  | BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY                                                                   | `vL`       | &amp;x2525;   | x2525  | 9509   | E2 94 A5    | FF FE 25 25       | So
┨                                  | BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT                                                                   | `Vl`       | &amp;x2528;   | x2528  | 9512   | E2 94 A8    | FF FE 28 25       | So
┫                                  | BOX DRAWINGS HEAVY VERTICAL AND LEFT                                                                         | `VL`       | &amp;x252B;   | x252B  | 9515   | E2 94 AB    | FF FE 2B 25       | So
┬                                  | BOX DRAWINGS LIGHT DOWN AND HORIZONTAL                                                                       | `dh`       | &amp;x252C;   | x252C  | 9516   | E2 94 AC    | FF FE 2C 25       | So
┯                                  | BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY                                                                 | `dH`       | &amp;x252F;   | x252F  | 9519   | E2 94 AF    | FF FE 2F 25       | So
┰                                  | BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT                                                                 | `Dh`       | &amp;x2530;   | x2530  | 9520   | E2 94 B0    | FF FE 30 25       | So
┳                                  | BOX DRAWINGS HEAVY DOWN AND HORIZONTAL                                                                       | `DH`       | &amp;x2533;   | x2533  | 9523   | E2 94 B3    | FF FE 33 25       | So
┴                                  | BOX DRAWINGS LIGHT UP AND HORIZONTAL                                                                         | `uh`       | &amp;x2534;   | x2534  | 9524   | E2 94 B4    | FF FE 34 25       | So
┷                                  | BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY                                                                   | `uH`       | &amp;x2537;   | x2537  | 9527   | E2 94 B7    | FF FE 37 25       | So
┸                                  | BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT                                                                   | `Uh`       | &amp;x2538;   | x2538  | 9528   | E2 94 B8    | FF FE 38 25       | So
┻                                  | BOX DRAWINGS HEAVY UP AND HORIZONTAL                                                                         | `UH`       | &amp;x253B;   | x253B  | 9531   | E2 94 BB    | FF FE 3B 25       | So
┼                                  | BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL                                                                   | `vh`       | &amp;x253C;   | x253C  | 9532   | E2 94 BC    | FF FE 3C 25       | So
┿                                  | BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY                                                             | `vH`       | &amp;x253F;   | x253F  | 9535   | E2 94 BF    | FF FE 3F 25       | So
╂                                  | BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT                                                             | `Vh`       | &amp;x2542;   | x2542  | 9538   | E2 95 82    | FF FE 42 25       | So
╋                                  | BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL                                                                   | `VH`       | &amp;x254B;   | x254B  | 9547   | E2 95 8B    | FF FE 4B 25       | So
╱                                  | BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT                                                        | `FD`       | &amp;x2571;   | x2571  | 9585   | E2 95 B1    | FF FE 71 25       | So
╲                                  | BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT                                                        | `BD`       | &amp;x2572;   | x2572  | 9586   | E2 95 B2    | FF FE 72 25       | So
▀                                  | UPPER HALF BLOCK                                                                                             | `TB`       | &amp;x2580;   | x2580  | 9600   | E2 96 80    | FF FE 80 25       | So
▄                                  | LOWER HALF BLOCK                                                                                             | `LB`       | &amp;x2584;   | x2584  | 9604   | E2 96 84    | FF FE 84 25       | So
█                                  | FULL BLOCK                                                                                                   | `FB`       | &amp;x2588;   | x2588  | 9608   | E2 96 88    | FF FE 88 25       | So
▌                                  | LEFT HALF BLOCK                                                                                              | `lB`       | &amp;x258C;   | x258C  | 9612   | E2 96 8C    | FF FE 8C 25       | So
▐                                  | RIGHT HALF BLOCK                                                                                             | `RB`       | &amp;x2590;   | x2590  | 9616   | E2 96 90    | FF FE 90 25       | So
░                                  | LIGHT SHADE                                                                                                  | `.S`       | &amp;x2591;   | x2591  | 9617   | E2 96 91    | FF FE 91 25       | So
▒                                  | MEDIUM SHADE                                                                                                 | `:S`       | &amp;x2592;   | x2592  | 9618   | E2 96 92    | FF FE 92 25       | So
▓                                  | DARK SHADE                                                                                                   | `?S`       | &amp;x2593;   | x2593  | 9619   | E2 96 93    | FF FE 93 25       | So
■                                  | BLACK SQUARE                                                                                                 | `fS`       | &amp;x25A0;   | x25A0  | 9632   | E2 96 A0    | FF FE A0 25       | So
□                                  | WHITE SQUARE                                                                                                 | `OS`       | &amp;x25A1;   | x25A1  | 9633   | E2 96 A1    | FF FE A1 25       | So
▢                                  | WHITE SQUARE WITH ROUNDED CORNERS                                                                            | `RO`       | &amp;x25A2;   | x25A2  | 9634   | E2 96 A2    | FF FE A2 25       | So
▣                                  | WHITE SQUARE CONTAINING BLACK SMALL SQUARE                                                                   | `Rr`       | &amp;x25A3;   | x25A3  | 9635   | E2 96 A3    | FF FE A3 25       | So
▤                                  | SQUARE WITH HORIZONTAL FILL                                                                                  | `RF`       | &amp;x25A4;   | x25A4  | 9636   | E2 96 A4    | FF FE A4 25       | So
▥                                  | SQUARE WITH VERTICAL FILL                                                                                    | `RY`       | &amp;x25A5;   | x25A5  | 9637   | E2 96 A5    | FF FE A5 25       | So
▦                                  | SQUARE WITH ORTHOGONAL CROSSHATCH FILL                                                                       | `RH`       | &amp;x25A6;   | x25A6  | 9638   | E2 96 A6    | FF FE A6 25       | So
▧                                  | SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL                                                                   | `RZ`       | &amp;x25A7;   | x25A7  | 9639   | E2 96 A7    | FF FE A7 25       | So
▨                                  | SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL                                                                   | `RK`       | &amp;x25A8;   | x25A8  | 9640   | E2 96 A8    | FF FE A8 25       | So
▩                                  | SQUARE WITH DIAGONAL CROSSHATCH FILL                                                                         | `RX`       | &amp;x25A9;   | x25A9  | 9641   | E2 96 A9    | FF FE A9 25       | So
▪                                  | BLACK SMALL SQUARE                                                                                           | `sB`       | &amp;x25AA;   | x25AA  | 9642   | E2 96 AA    | FF FE AA 25       | So
▬                                  | BLACK RECTANGLE                                                                                              | `SR`       | &amp;x25AC;   | x25AC  | 9644   | E2 96 AC    | FF FE AC 25       | So
▭                                  | WHITE RECTANGLE                                                                                              | `Or`       | &amp;x25AD;   | x25AD  | 9645   | E2 96 AD    | FF FE AD 25       | So
▲                                  | BLACK UP-POINTING TRIANGLE                                                                                   | `UT`       | &amp;x25B2;   | x25B2  | 9650   | E2 96 B2    | FF FE B2 25       | So
△                                  | WHITE UP-POINTING TRIANGLE                                                                                   | `uT`       | &amp;x25B3;   | x25B3  | 9651   | E2 96 B3    | FF FE B3 25       | So
▶                                  | BLACK RIGHT-POINTING TRIANGLE                                                                                | `PR`       | &amp;x25B6;   | x25B6  | 9654   | E2 96 B6    | FF FE B6 25       | So
▷                                  | WHITE RIGHT-POINTING TRIANGLE                                                                                | `Tr`       | &amp;x25B7;   | x25B7  | 9655   | E2 96 B7    | FF FE B7 25       | Sm
▼                                  | BLACK DOWN-POINTING TRIANGLE                                                                                 | `Dt`       | &amp;x25BC;   | x25BC  | 9660   | E2 96 BC    | FF FE BC 25       | So
▽                                  | WHITE DOWN-POINTING TRIANGLE                                                                                 | `dT`       | &amp;x25BD;   | x25BD  | 9661   | E2 96 BD    | FF FE BD 25       | So
◀                                  | BLACK LEFT-POINTING TRIANGLE                                                                                 | `PL`       | &amp;x25C0;   | x25C0  | 9664   | E2 97 80    | FF FE C0 25       | So
◁                                  | WHITE LEFT-POINTING TRIANGLE                                                                                 | `Tl`       | &amp;x25C1;   | x25C1  | 9665   | E2 97 81    | FF FE C1 25       | Sm
◆                                  | BLACK DIAMOND                                                                                                | `Db`       | &amp;x25C6;   | x25C6  | 9670   | E2 97 86    | FF FE C6 25       | So
◇                                  | WHITE DIAMOND                                                                                                | `Dw`       | &amp;x25C7;   | x25C7  | 9671   | E2 97 87    | FF FE C7 25       | So
◊                                  | LOZENGE                                                                                                      | `LZ`       | &amp;loz;     | x25CA  | 9674   | E2 97 8A    | FF FE CA 25       | So
○                                  | WHITE CIRCLE                                                                                                 | `0m`       | &amp;x25CB;   | x25CB  | 9675   | E2 97 8B    | FF FE CB 25       | So
◎                                  | BULLSEYE                                                                                                     | `0o`       | &amp;x25CE;   | x25CE  | 9678   | E2 97 8E    | FF FE CE 25       | So
●                                  | BLACK CIRCLE                                                                                                 | `0M`       | &amp;x25CF;   | x25CF  | 9679   | E2 97 8F    | FF FE CF 25       | So
◐                                  | CIRCLE WITH LEFT HALF BLACK                                                                                  | `0L`       | &amp;x25D0;   | x25D0  | 9680   | E2 97 90    | FF FE D0 25       | So
◑                                  | CIRCLE WITH RIGHT HALF BLACK                                                                                 | `0R`       | &amp;x25D1;   | x25D1  | 9681   | E2 97 91    | FF FE D1 25       | So
◘                                  | INVERSE BULLET                                                                                               | `Sn`       | &amp;x25D8;   | x25D8  | 9688   | E2 97 98    | FF FE D8 25       | So
◙                                  | INVERSE WHITE CIRCLE                                                                                         | `Ic`       | &amp;x25D9;   | x25D9  | 9689   | E2 97 99    | FF FE D9 25       | So
◢                                  | BLACK LOWER RIGHT TRIANGLE                                                                                   | `Fd`       | &amp;x25E2;   | x25E2  | 9698   | E2 97 A2    | FF FE E2 25       | So
◣                                  | BLACK LOWER LEFT TRIANGLE                                                                                    | `Bd`       | &amp;x25E3;   | x25E3  | 9699   | E2 97 A3    | FF FE E3 25       | So
★                                  | BLACK STAR                                                                                                   | `*2`       | &amp;x2605;   | x2605  | 9733   | E2 98 85    | FF FE 05 26       | So
☆                                  | WHITE STAR                                                                                                   | `*1`       | &amp;x2606;   | x2606  | 9734   | E2 98 86    | FF FE 06 26       | So
☜                                  | WHITE LEFT POINTING INDEX                                                                                    | `<H`       | &amp;x261C;   | x261C  | 9756   | E2 98 9C    | FF FE 1C 26       | So
☞                                  | WHITE RIGHT POINTING INDEX                                                                                   | `>H`       | &amp;x261E;   | x261E  | 9758   | E2 98 9E    | FF FE 1E 26       | So
☺                                  | WHITE SMILING FACE                                                                                           | `0u`       | &amp;x263A;   | x263A  | 9786   | E2 98 BA    | FF FE 3A 26       | So
☻                                  | BLACK SMILING FACE                                                                                           | `0U`       | &amp;x263B;   | x263B  | 9787   | E2 98 BB    | FF FE 3B 26       | So
☼                                  | WHITE SUN WITH RAYS                                                                                          | `SU`       | &amp;x263C;   | x263C  | 9788   | E2 98 BC    | FF FE 3C 26       | So
♀                                  | FEMALE SIGN                                                                                                  | `Fm`       | &amp;x2640;   | x2640  | 9792   | E2 99 80    | FF FE 40 26       | So
♂                                  | MALE SIGN                                                                                                    | `Ml`       | &amp;x2642;   | x2642  | 9794   | E2 99 82    | FF FE 42 26       | So
♠                                  | BLACK SPADE SUIT                                                                                             | `cS`       | &amp;spades;  | x2660  | 9824   | E2 99 A0    | FF FE 60 26       | So
♡                                  | WHITE HEART SUIT                                                                                             | `cH`       | &amp;x2661;   | x2661  | 9825   | E2 99 A1    | FF FE 61 26       | So
♢                                  | WHITE DIAMOND SUIT                                                                                           | `cD`       | &amp;x2662;   | x2662  | 9826   | E2 99 A2    | FF FE 62 26       | So
♣                                  | BLACK CLUB SUIT                                                                                              | `cC`       | &amp;clubs;   | x2663  | 9827   | E2 99 A3    | FF FE 63 26       | So
♩                                  | QUARTER NOTE                                                                                                 | `Md`       | &amp;x2669;   | x2669  | 9833   | E2 99 A9    | FF FE 69 26       | So
♪                                  | EIGHTH NOTE                                                                                                  | `M8`       | &amp;x266A;   | x266A  | 9834   | E2 99 AA    | FF FE 6A 26       | So
♫                                  | BEAMED EIGHTH NOTES                                                                                          | `M2`       | &amp;x266B;   | x266B  | 9835   | E2 99 AB    | FF FE 6B 26       | So
♭                                  | MUSIC FLAT SIGN                                                                                              | `Mb`       | &amp;x266D;   | x266D  | 9837   | E2 99 AD    | FF FE 6D 26       | So
♮                                  | MUSIC NATURAL SIGN                                                                                           | `Mx`       | &amp;x266E;   | x266E  | 9838   | E2 99 AE    | FF FE 6E 26       | So
♯                                  | MUSIC SHARP SIGN                                                                                             | `MX`       | &amp;x266F;   | x266F  | 9839   | E2 99 AF    | FF FE 6F 26       | Sm
✓                                  | CHECK MARK                                                                                                   | `OK`       | &amp;x2713;   | x2713  | 10003  | E2 9C 93    | FF FE 13 27       | So
✗                                  | BALLOT X                                                                                                     | `XX`       | &amp;x2717;   | x2717  | 10007  | E2 9C 97    | FF FE 17 27       | So
✠                                  | MALTESE CROSS                                                                                                | `-X`       | &amp;x2720;   | x2720  | 10016  | E2 9C A0    | FF FE 20 27       | So
　                                  | IDEOGRAPHIC SPACE                                                                                            | `IS`       | &amp;x3000;   | x3000  | 12288  | E3 80 80    | FF FE 00 30       | Zs
、                                  | IDEOGRAPHIC COMMA                                                                                            | `,_`       | &amp;x3001;   | x3001  | 12289  | E3 80 81    | FF FE 01 30       | Po
。                                  | IDEOGRAPHIC FULL STOP                                                                                        | `._`       | &amp;x3002;   | x3002  | 12290  | E3 80 82    | FF FE 02 30       | Po
〃                                  | DITTO MARK                                                                                                   | `+"`       | &amp;x3003;   | x3003  | 12291  | E3 80 83    | FF FE 03 30       | Po
〄                                  | JAPANESE INDUSTRIAL STANDARD SYMBOL                                                                          | `+_`       | &amp;x3004;   | x3004  | 12292  | E3 80 84    | FF FE 04 30       | So
々                                  | IDEOGRAPHIC ITERATION MARK                                                                                   | `*_`       | &amp;x3005;   | x3005  | 12293  | E3 80 85    | FF FE 05 30       | Lm
〆                                  | IDEOGRAPHIC CLOSING MARK                                                                                     | `;_`       | &amp;x3006;   | x3006  | 12294  | E3 80 86    | FF FE 06 30       | Lo
〇                                  | IDEOGRAPHIC NUMBER ZERO                                                                                      | `0_`       | &amp;x3007;   | x3007  | 12295  | E3 80 87    | FF FE 07 30       | Nl
《                                  | LEFT DOUBLE ANGLE BRACKET                                                                                    | `<+`       | &amp;x300A;   | x300A  | 12298  | E3 80 8A    | FF FE 0A 30       | Ps
》                                  | RIGHT DOUBLE ANGLE BRACKET                                                                                   | `>+`       | &amp;x300B;   | x300B  | 12299  | E3 80 8B    | FF FE 0B 30       | Pe
「                                  | LEFT CORNER BRACKET                                                                                          | `<'`       | &amp;x300C;   | x300C  | 12300  | E3 80 8C    | FF FE 0C 30       | Ps
」                                  | RIGHT CORNER BRACKET                                                                                         | `>'`       | &amp;x300D;   | x300D  | 12301  | E3 80 8D    | FF FE 0D 30       | Pe
『                                  | LEFT WHITE CORNER BRACKET                                                                                    | `<"`       | &amp;x300E;   | x300E  | 12302  | E3 80 8E    | FF FE 0E 30       | Ps
』                                  | RIGHT WHITE CORNER BRACKET                                                                                   | `>"`       | &amp;x300F;   | x300F  | 12303  | E3 80 8F    | FF FE 0F 30       | Pe
【                                  | LEFT BLACK LENTICULAR BRACKET                                                                                | `("`       | &amp;x3010;   | x3010  | 12304  | E3 80 90    | FF FE 10 30       | Ps
】                                  | RIGHT BLACK LENTICULAR BRACKET                                                                               | `)"`       | &amp;x3011;   | x3011  | 12305  | E3 80 91    | FF FE 11 30       | Pe
〒                                  | POSTAL MARK                                                                                                  | `=T`       | &amp;x3012;   | x3012  | 12306  | E3 80 92    | FF FE 12 30       | So
〓                                  | GETA MARK                                                                                                    | `=_`       | &amp;x3013;   | x3013  | 12307  | E3 80 93    | FF FE 13 30       | So
〔                                  | LEFT TORTOISE SHELL BRACKET                                                                                  | `('`       | &amp;x3014;   | x3014  | 12308  | E3 80 94    | FF FE 14 30       | Ps
〕                                  | RIGHT TORTOISE SHELL BRACKET                                                                                 | `)'`       | &amp;x3015;   | x3015  | 12309  | E3 80 95    | FF FE 15 30       | Pe
〖                                  | LEFT WHITE LENTICULAR BRACKET                                                                                | `(I`       | &amp;x3016;   | x3016  | 12310  | E3 80 96    | FF FE 16 30       | Ps
〗                                  | RIGHT WHITE LENTICULAR BRACKET                                                                               | `)I`       | &amp;x3017;   | x3017  | 12311  | E3 80 97    | FF FE 17 30       | Pe
〜                                  | WAVE DASH                                                                                                    | `-?`       | &amp;x301C;   | x301C  | 12316  | E3 80 9C    | FF FE 1C 30       | Pd
ぁ                                  | HIRAGANA LETTER SMALL A                                                                                      | `A5`       | &amp;x3041;   | x3041  | 12353  | E3 81 81    | FF FE 41 30       | Lo
あ                                  | HIRAGANA LETTER A                                                                                            | `a5`       | &amp;x3042;   | x3042  | 12354  | E3 81 82    | FF FE 42 30       | Lo
ぃ                                  | HIRAGANA LETTER SMALL I                                                                                      | `I5`       | &amp;x3043;   | x3043  | 12355  | E3 81 83    | FF FE 43 30       | Lo
い                                  | HIRAGANA LETTER I                                                                                            | `i5`       | &amp;x3044;   | x3044  | 12356  | E3 81 84    | FF FE 44 30       | Lo
ぅ                                  | HIRAGANA LETTER SMALL U                                                                                      | `U5`       | &amp;x3045;   | x3045  | 12357  | E3 81 85    | FF FE 45 30       | Lo
う                                  | HIRAGANA LETTER U                                                                                            | `u5`       | &amp;x3046;   | x3046  | 12358  | E3 81 86    | FF FE 46 30       | Lo
ぇ                                  | HIRAGANA LETTER SMALL E                                                                                      | `E5`       | &amp;x3047;   | x3047  | 12359  | E3 81 87    | FF FE 47 30       | Lo
え                                  | HIRAGANA LETTER E                                                                                            | `e5`       | &amp;x3048;   | x3048  | 12360  | E3 81 88    | FF FE 48 30       | Lo
ぉ                                  | HIRAGANA LETTER SMALL O                                                                                      | `O5`       | &amp;x3049;   | x3049  | 12361  | E3 81 89    | FF FE 49 30       | Lo
お                                  | HIRAGANA LETTER O                                                                                            | `o5`       | &amp;x304A;   | x304A  | 12362  | E3 81 8A    | FF FE 4A 30       | Lo
か                                  | HIRAGANA LETTER KA                                                                                           | `ka`       | &amp;x304B;   | x304B  | 12363  | E3 81 8B    | FF FE 4B 30       | Lo
が                                  | HIRAGANA LETTER GA                                                                                           | `ga`       | &amp;x304C;   | x304C  | 12364  | E3 81 8C    | FF FE 4C 30       | Lo
き                                  | HIRAGANA LETTER KI                                                                                           | `ki`       | &amp;x304D;   | x304D  | 12365  | E3 81 8D    | FF FE 4D 30       | Lo
ぎ                                  | HIRAGANA LETTER GI                                                                                           | `gi`       | &amp;x304E;   | x304E  | 12366  | E3 81 8E    | FF FE 4E 30       | Lo
く                                  | HIRAGANA LETTER KU                                                                                           | `ku`       | &amp;x304F;   | x304F  | 12367  | E3 81 8F    | FF FE 4F 30       | Lo
ぐ                                  | HIRAGANA LETTER GU                                                                                           | `gu`       | &amp;x3050;   | x3050  | 12368  | E3 81 90    | FF FE 50 30       | Lo
け                                  | HIRAGANA LETTER KE                                                                                           | `ke`       | &amp;x3051;   | x3051  | 12369  | E3 81 91    | FF FE 51 30       | Lo
げ                                  | HIRAGANA LETTER GE                                                                                           | `ge`       | &amp;x3052;   | x3052  | 12370  | E3 81 92    | FF FE 52 30       | Lo
こ                                  | HIRAGANA LETTER KO                                                                                           | `ko`       | &amp;x3053;   | x3053  | 12371  | E3 81 93    | FF FE 53 30       | Lo
ご                                  | HIRAGANA LETTER GO                                                                                           | `go`       | &amp;x3054;   | x3054  | 12372  | E3 81 94    | FF FE 54 30       | Lo
さ                                  | HIRAGANA LETTER SA                                                                                           | `sa`       | &amp;x3055;   | x3055  | 12373  | E3 81 95    | FF FE 55 30       | Lo
ざ                                  | HIRAGANA LETTER ZA                                                                                           | `za`       | &amp;x3056;   | x3056  | 12374  | E3 81 96    | FF FE 56 30       | Lo
し                                  | HIRAGANA LETTER SI                                                                                           | `si`       | &amp;x3057;   | x3057  | 12375  | E3 81 97    | FF FE 57 30       | Lo
じ                                  | HIRAGANA LETTER ZI                                                                                           | `zi`       | &amp;x3058;   | x3058  | 12376  | E3 81 98    | FF FE 58 30       | Lo
す                                  | HIRAGANA LETTER SU                                                                                           | `su`       | &amp;x3059;   | x3059  | 12377  | E3 81 99    | FF FE 59 30       | Lo
ず                                  | HIRAGANA LETTER ZU                                                                                           | `zu`       | &amp;x305A;   | x305A  | 12378  | E3 81 9A    | FF FE 5A 30       | Lo
せ                                  | HIRAGANA LETTER SE                                                                                           | `se`       | &amp;x305B;   | x305B  | 12379  | E3 81 9B    | FF FE 5B 30       | Lo
ぜ                                  | HIRAGANA LETTER ZE                                                                                           | `ze`       | &amp;x305C;   | x305C  | 12380  | E3 81 9C    | FF FE 5C 30       | Lo
そ                                  | HIRAGANA LETTER SO                                                                                           | `so`       | &amp;x305D;   | x305D  | 12381  | E3 81 9D    | FF FE 5D 30       | Lo
ぞ                                  | HIRAGANA LETTER ZO                                                                                           | `zo`       | &amp;x305E;   | x305E  | 12382  | E3 81 9E    | FF FE 5E 30       | Lo
た                                  | HIRAGANA LETTER TA                                                                                           | `ta`       | &amp;x305F;   | x305F  | 12383  | E3 81 9F    | FF FE 5F 30       | Lo
だ                                  | HIRAGANA LETTER DA                                                                                           | `da`       | &amp;x3060;   | x3060  | 12384  | E3 81 A0    | FF FE 60 30       | Lo
ち                                  | HIRAGANA LETTER TI                                                                                           | `ti`       | &amp;x3061;   | x3061  | 12385  | E3 81 A1    | FF FE 61 30       | Lo
ぢ                                  | HIRAGANA LETTER DI                                                                                           | `di`       | &amp;x3062;   | x3062  | 12386  | E3 81 A2    | FF FE 62 30       | Lo
っ                                  | HIRAGANA LETTER SMALL TU                                                                                     | `tU`       | &amp;x3063;   | x3063  | 12387  | E3 81 A3    | FF FE 63 30       | Lo
つ                                  | HIRAGANA LETTER TU                                                                                           | `tu`       | &amp;x3064;   | x3064  | 12388  | E3 81 A4    | FF FE 64 30       | Lo
づ                                  | HIRAGANA LETTER DU                                                                                           | `du`       | &amp;x3065;   | x3065  | 12389  | E3 81 A5    | FF FE 65 30       | Lo
て                                  | HIRAGANA LETTER TE                                                                                           | `te`       | &amp;x3066;   | x3066  | 12390  | E3 81 A6    | FF FE 66 30       | Lo
で                                  | HIRAGANA LETTER DE                                                                                           | `de`       | &amp;x3067;   | x3067  | 12391  | E3 81 A7    | FF FE 67 30       | Lo
と                                  | HIRAGANA LETTER TO                                                                                           | `to`       | &amp;x3068;   | x3068  | 12392  | E3 81 A8    | FF FE 68 30       | Lo
ど                                  | HIRAGANA LETTER DO                                                                                           | `do`       | &amp;x3069;   | x3069  | 12393  | E3 81 A9    | FF FE 69 30       | Lo
な                                  | HIRAGANA LETTER NA                                                                                           | `na`       | &amp;x306A;   | x306A  | 12394  | E3 81 AA    | FF FE 6A 30       | Lo
に                                  | HIRAGANA LETTER NI                                                                                           | `ni`       | &amp;x306B;   | x306B  | 12395  | E3 81 AB    | FF FE 6B 30       | Lo
ぬ                                  | HIRAGANA LETTER NU                                                                                           | `nu`       | &amp;x306C;   | x306C  | 12396  | E3 81 AC    | FF FE 6C 30       | Lo
ね                                  | HIRAGANA LETTER NE                                                                                           | `ne`       | &amp;x306D;   | x306D  | 12397  | E3 81 AD    | FF FE 6D 30       | Lo
の                                  | HIRAGANA LETTER NO                                                                                           | `no`       | &amp;x306E;   | x306E  | 12398  | E3 81 AE    | FF FE 6E 30       | Lo
は                                  | HIRAGANA LETTER HA                                                                                           | `ha`       | &amp;x306F;   | x306F  | 12399  | E3 81 AF    | FF FE 6F 30       | Lo
ば                                  | HIRAGANA LETTER BA                                                                                           | `ba`       | &amp;x3070;   | x3070  | 12400  | E3 81 B0    | FF FE 70 30       | Lo
ぱ                                  | HIRAGANA LETTER PA                                                                                           | `pa`       | &amp;x3071;   | x3071  | 12401  | E3 81 B1    | FF FE 71 30       | Lo
ひ                                  | HIRAGANA LETTER HI                                                                                           | `hi`       | &amp;x3072;   | x3072  | 12402  | E3 81 B2    | FF FE 72 30       | Lo
び                                  | HIRAGANA LETTER BI                                                                                           | `bi`       | &amp;x3073;   | x3073  | 12403  | E3 81 B3    | FF FE 73 30       | Lo
ぴ                                  | HIRAGANA LETTER PI                                                                                           | `pi`       | &amp;x3074;   | x3074  | 12404  | E3 81 B4    | FF FE 74 30       | Lo
ふ                                  | HIRAGANA LETTER HU                                                                                           | `hu`       | &amp;x3075;   | x3075  | 12405  | E3 81 B5    | FF FE 75 30       | Lo
ぶ                                  | HIRAGANA LETTER BU                                                                                           | `bu`       | &amp;x3076;   | x3076  | 12406  | E3 81 B6    | FF FE 76 30       | Lo
ぷ                                  | HIRAGANA LETTER PU                                                                                           | `pu`       | &amp;x3077;   | x3077  | 12407  | E3 81 B7    | FF FE 77 30       | Lo
へ                                  | HIRAGANA LETTER HE                                                                                           | `he`       | &amp;x3078;   | x3078  | 12408  | E3 81 B8    | FF FE 78 30       | Lo
べ                                  | HIRAGANA LETTER BE                                                                                           | `be`       | &amp;x3079;   | x3079  | 12409  | E3 81 B9    | FF FE 79 30       | Lo
ぺ                                  | HIRAGANA LETTER PE                                                                                           | `pe`       | &amp;x307A;   | x307A  | 12410  | E3 81 BA    | FF FE 7A 30       | Lo
ほ                                  | HIRAGANA LETTER HO                                                                                           | `ho`       | &amp;x307B;   | x307B  | 12411  | E3 81 BB    | FF FE 7B 30       | Lo
ぼ                                  | HIRAGANA LETTER BO                                                                                           | `bo`       | &amp;x307C;   | x307C  | 12412  | E3 81 BC    | FF FE 7C 30       | Lo
ぽ                                  | HIRAGANA LETTER PO                                                                                           | `po`       | &amp;x307D;   | x307D  | 12413  | E3 81 BD    | FF FE 7D 30       | Lo
ま                                  | HIRAGANA LETTER MA                                                                                           | `ma`       | &amp;x307E;   | x307E  | 12414  | E3 81 BE    | FF FE 7E 30       | Lo
み                                  | HIRAGANA LETTER MI                                                                                           | `mi`       | &amp;x307F;   | x307F  | 12415  | E3 81 BF    | FF FE 7F 30       | Lo
む                                  | HIRAGANA LETTER MU                                                                                           | `mu`       | &amp;x3080;   | x3080  | 12416  | E3 82 80    | FF FE 80 30       | Lo
め                                  | HIRAGANA LETTER ME                                                                                           | `me`       | &amp;x3081;   | x3081  | 12417  | E3 82 81    | FF FE 81 30       | Lo
も                                  | HIRAGANA LETTER MO                                                                                           | `mo`       | &amp;x3082;   | x3082  | 12418  | E3 82 82    | FF FE 82 30       | Lo
ゃ                                  | HIRAGANA LETTER SMALL YA                                                                                     | `yA`       | &amp;x3083;   | x3083  | 12419  | E3 82 83    | FF FE 83 30       | Lo
や                                  | HIRAGANA LETTER YA                                                                                           | `ya`       | &amp;x3084;   | x3084  | 12420  | E3 82 84    | FF FE 84 30       | Lo
ゅ                                  | HIRAGANA LETTER SMALL YU                                                                                     | `yU`       | &amp;x3085;   | x3085  | 12421  | E3 82 85    | FF FE 85 30       | Lo
ゆ                                  | HIRAGANA LETTER YU                                                                                           | `yu`       | &amp;x3086;   | x3086  | 12422  | E3 82 86    | FF FE 86 30       | Lo
ょ                                  | HIRAGANA LETTER SMALL YO                                                                                     | `yO`       | &amp;x3087;   | x3087  | 12423  | E3 82 87    | FF FE 87 30       | Lo
よ                                  | HIRAGANA LETTER YO                                                                                           | `yo`       | &amp;x3088;   | x3088  | 12424  | E3 82 88    | FF FE 88 30       | Lo
ら                                  | HIRAGANA LETTER RA                                                                                           | `ra`       | &amp;x3089;   | x3089  | 12425  | E3 82 89    | FF FE 89 30       | Lo
り                                  | HIRAGANA LETTER RI                                                                                           | `ri`       | &amp;x308A;   | x308A  | 12426  | E3 82 8A    | FF FE 8A 30       | Lo
る                                  | HIRAGANA LETTER RU                                                                                           | `ru`       | &amp;x308B;   | x308B  | 12427  | E3 82 8B    | FF FE 8B 30       | Lo
れ                                  | HIRAGANA LETTER RE                                                                                           | `re`       | &amp;x308C;   | x308C  | 12428  | E3 82 8C    | FF FE 8C 30       | Lo
ろ                                  | HIRAGANA LETTER RO                                                                                           | `ro`       | &amp;x308D;   | x308D  | 12429  | E3 82 8D    | FF FE 8D 30       | Lo
ゎ                                  | HIRAGANA LETTER SMALL WA                                                                                     | `wA`       | &amp;x308E;   | x308E  | 12430  | E3 82 8E    | FF FE 8E 30       | Lo
わ                                  | HIRAGANA LETTER WA                                                                                           | `wa`       | &amp;x308F;   | x308F  | 12431  | E3 82 8F    | FF FE 8F 30       | Lo
ゐ                                  | HIRAGANA LETTER WI                                                                                           | `wi`       | &amp;x3090;   | x3090  | 12432  | E3 82 90    | FF FE 90 30       | Lo
ゑ                                  | HIRAGANA LETTER WE                                                                                           | `we`       | &amp;x3091;   | x3091  | 12433  | E3 82 91    | FF FE 91 30       | Lo
を                                  | HIRAGANA LETTER WO                                                                                           | `wo`       | &amp;x3092;   | x3092  | 12434  | E3 82 92    | FF FE 92 30       | Lo
ん                                  | HIRAGANA LETTER N                                                                                            | `n5`       | &amp;x3093;   | x3093  | 12435  | E3 82 93    | FF FE 93 30       | Lo
ゔ                                  | HIRAGANA LETTER VU                                                                                           | `vu`       | &amp;x3094;   | x3094  | 12436  | E3 82 94    | FF FE 94 30       | Lo
゛                                  | KATAKANA-HIRAGANA VOICED SOUND MARK                                                                          | `"5`       | &amp;x309B;   | x309B  | 12443  | E3 82 9B    | FF FE 9B 30       | Sk
゜                                  | KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK                                                                     | `05`       | &amp;x309C;   | x309C  | 12444  | E3 82 9C    | FF FE 9C 30       | Sk
ゝ                                  | HIRAGANA ITERATION MARK                                                                                      | `*5`       | &amp;x309D;   | x309D  | 12445  | E3 82 9D    | FF FE 9D 30       | Lm
ゞ                                  | HIRAGANA VOICED ITERATION MARK                                                                               | `+5`       | &amp;x309E;   | x309E  | 12446  | E3 82 9E    | FF FE 9E 30       | Lm
ァ                                  | KATAKANA LETTER SMALL A                                                                                      | `a6`       | &amp;x30A1;   | x30A1  | 12449  | E3 82 A1    | FF FE A1 30       | Lo
ア                                  | KATAKANA LETTER A                                                                                            | `A6`       | &amp;x30A2;   | x30A2  | 12450  | E3 82 A2    | FF FE A2 30       | Lo
ィ                                  | KATAKANA LETTER SMALL I                                                                                      | `i6`       | &amp;x30A3;   | x30A3  | 12451  | E3 82 A3    | FF FE A3 30       | Lo
イ                                  | KATAKANA LETTER I                                                                                            | `I6`       | &amp;x30A4;   | x30A4  | 12452  | E3 82 A4    | FF FE A4 30       | Lo
ゥ                                  | KATAKANA LETTER SMALL U                                                                                      | `u6`       | &amp;x30A5;   | x30A5  | 12453  | E3 82 A5    | FF FE A5 30       | Lo
ウ                                  | KATAKANA LETTER U                                                                                            | `U6`       | &amp;x30A6;   | x30A6  | 12454  | E3 82 A6    | FF FE A6 30       | Lo
ェ                                  | KATAKANA LETTER SMALL E                                                                                      | `e6`       | &amp;x30A7;   | x30A7  | 12455  | E3 82 A7    | FF FE A7 30       | Lo
エ                                  | KATAKANA LETTER E                                                                                            | `E6`       | &amp;x30A8;   | x30A8  | 12456  | E3 82 A8    | FF FE A8 30       | Lo
ォ                                  | KATAKANA LETTER SMALL O                                                                                      | `o6`       | &amp;x30A9;   | x30A9  | 12457  | E3 82 A9    | FF FE A9 30       | Lo
オ                                  | KATAKANA LETTER O                                                                                            | `O6`       | &amp;x30AA;   | x30AA  | 12458  | E3 82 AA    | FF FE AA 30       | Lo
カ                                  | KATAKANA LETTER KA                                                                                           | `Ka`       | &amp;x30AB;   | x30AB  | 12459  | E3 82 AB    | FF FE AB 30       | Lo
ガ                                  | KATAKANA LETTER GA                                                                                           | `Ga`       | &amp;x30AC;   | x30AC  | 12460  | E3 82 AC    | FF FE AC 30       | Lo
キ                                  | KATAKANA LETTER KI                                                                                           | `Ki`       | &amp;x30AD;   | x30AD  | 12461  | E3 82 AD    | FF FE AD 30       | Lo
ギ                                  | KATAKANA LETTER GI                                                                                           | `Gi`       | &amp;x30AE;   | x30AE  | 12462  | E3 82 AE    | FF FE AE 30       | Lo
ク                                  | KATAKANA LETTER KU                                                                                           | `Ku`       | &amp;x30AF;   | x30AF  | 12463  | E3 82 AF    | FF FE AF 30       | Lo
グ                                  | KATAKANA LETTER GU                                                                                           | `Gu`       | &amp;x30B0;   | x30B0  | 12464  | E3 82 B0    | FF FE B0 30       | Lo
ケ                                  | KATAKANA LETTER KE                                                                                           | `Ke`       | &amp;x30B1;   | x30B1  | 12465  | E3 82 B1    | FF FE B1 30       | Lo
ゲ                                  | KATAKANA LETTER GE                                                                                           | `Ge`       | &amp;x30B2;   | x30B2  | 12466  | E3 82 B2    | FF FE B2 30       | Lo
コ                                  | KATAKANA LETTER KO                                                                                           | `Ko`       | &amp;x30B3;   | x30B3  | 12467  | E3 82 B3    | FF FE B3 30       | Lo
ゴ                                  | KATAKANA LETTER GO                                                                                           | `Go`       | &amp;x30B4;   | x30B4  | 12468  | E3 82 B4    | FF FE B4 30       | Lo
サ                                  | KATAKANA LETTER SA                                                                                           | `Sa`       | &amp;x30B5;   | x30B5  | 12469  | E3 82 B5    | FF FE B5 30       | Lo
ザ                                  | KATAKANA LETTER ZA                                                                                           | `Za`       | &amp;x30B6;   | x30B6  | 12470  | E3 82 B6    | FF FE B6 30       | Lo
シ                                  | KATAKANA LETTER SI                                                                                           | `Si`       | &amp;x30B7;   | x30B7  | 12471  | E3 82 B7    | FF FE B7 30       | Lo
ジ                                  | KATAKANA LETTER ZI                                                                                           | `Zi`       | &amp;x30B8;   | x30B8  | 12472  | E3 82 B8    | FF FE B8 30       | Lo
ス                                  | KATAKANA LETTER SU                                                                                           | `Su`       | &amp;x30B9;   | x30B9  | 12473  | E3 82 B9    | FF FE B9 30       | Lo
ズ                                  | KATAKANA LETTER ZU                                                                                           | `Zu`       | &amp;x30BA;   | x30BA  | 12474  | E3 82 BA    | FF FE BA 30       | Lo
セ                                  | KATAKANA LETTER SE                                                                                           | `Se`       | &amp;x30BB;   | x30BB  | 12475  | E3 82 BB    | FF FE BB 30       | Lo
ゼ                                  | KATAKANA LETTER ZE                                                                                           | `Ze`       | &amp;x30BC;   | x30BC  | 12476  | E3 82 BC    | FF FE BC 30       | Lo
ソ                                  | KATAKANA LETTER SO                                                                                           | `So`       | &amp;x30BD;   | x30BD  | 12477  | E3 82 BD    | FF FE BD 30       | Lo
ゾ                                  | KATAKANA LETTER ZO                                                                                           | `Zo`       | &amp;x30BE;   | x30BE  | 12478  | E3 82 BE    | FF FE BE 30       | Lo
タ                                  | KATAKANA LETTER TA                                                                                           | `Ta`       | &amp;x30BF;   | x30BF  | 12479  | E3 82 BF    | FF FE BF 30       | Lo
ダ                                  | KATAKANA LETTER DA                                                                                           | `Da`       | &amp;x30C0;   | x30C0  | 12480  | E3 83 80    | FF FE C0 30       | Lo
チ                                  | KATAKANA LETTER TI                                                                                           | `Ti`       | &amp;x30C1;   | x30C1  | 12481  | E3 83 81    | FF FE C1 30       | Lo
ヂ                                  | KATAKANA LETTER DI                                                                                           | `Di`       | &amp;x30C2;   | x30C2  | 12482  | E3 83 82    | FF FE C2 30       | Lo
ッ                                  | KATAKANA LETTER SMALL TU                                                                                     | `TU`       | &amp;x30C3;   | x30C3  | 12483  | E3 83 83    | FF FE C3 30       | Lo
ツ                                  | KATAKANA LETTER TU                                                                                           | `Tu`       | &amp;x30C4;   | x30C4  | 12484  | E3 83 84    | FF FE C4 30       | Lo
ヅ                                  | KATAKANA LETTER DU                                                                                           | `Du`       | &amp;x30C5;   | x30C5  | 12485  | E3 83 85    | FF FE C5 30       | Lo
テ                                  | KATAKANA LETTER TE                                                                                           | `Te`       | &amp;x30C6;   | x30C6  | 12486  | E3 83 86    | FF FE C6 30       | Lo
デ                                  | KATAKANA LETTER DE                                                                                           | `De`       | &amp;x30C7;   | x30C7  | 12487  | E3 83 87    | FF FE C7 30       | Lo
ト                                  | KATAKANA LETTER TO                                                                                           | `To`       | &amp;x30C8;   | x30C8  | 12488  | E3 83 88    | FF FE C8 30       | Lo
ド                                  | KATAKANA LETTER DO                                                                                           | `Do`       | &amp;x30C9;   | x30C9  | 12489  | E3 83 89    | FF FE C9 30       | Lo
ナ                                  | KATAKANA LETTER NA                                                                                           | `Na`       | &amp;x30CA;   | x30CA  | 12490  | E3 83 8A    | FF FE CA 30       | Lo
ニ                                  | KATAKANA LETTER NI                                                                                           | `Ni`       | &amp;x30CB;   | x30CB  | 12491  | E3 83 8B    | FF FE CB 30       | Lo
ヌ                                  | KATAKANA LETTER NU                                                                                           | `Nu`       | &amp;x30CC;   | x30CC  | 12492  | E3 83 8C    | FF FE CC 30       | Lo
ネ                                  | KATAKANA LETTER NE                                                                                           | `Ne`       | &amp;x30CD;   | x30CD  | 12493  | E3 83 8D    | FF FE CD 30       | Lo
ノ                                  | KATAKANA LETTER NO                                                                                           | `No`       | &amp;x30CE;   | x30CE  | 12494  | E3 83 8E    | FF FE CE 30       | Lo
ハ                                  | KATAKANA LETTER HA                                                                                           | `Ha`       | &amp;x30CF;   | x30CF  | 12495  | E3 83 8F    | FF FE CF 30       | Lo
バ                                  | KATAKANA LETTER BA                                                                                           | `Ba`       | &amp;x30D0;   | x30D0  | 12496  | E3 83 90    | FF FE D0 30       | Lo
パ                                  | KATAKANA LETTER PA                                                                                           | `Pa`       | &amp;x30D1;   | x30D1  | 12497  | E3 83 91    | FF FE D1 30       | Lo
ヒ                                  | KATAKANA LETTER HI                                                                                           | `Hi`       | &amp;x30D2;   | x30D2  | 12498  | E3 83 92    | FF FE D2 30       | Lo
ビ                                  | KATAKANA LETTER BI                                                                                           | `Bi`       | &amp;x30D3;   | x30D3  | 12499  | E3 83 93    | FF FE D3 30       | Lo
ピ                                  | KATAKANA LETTER PI                                                                                           | `Pi`       | &amp;x30D4;   | x30D4  | 12500  | E3 83 94    | FF FE D4 30       | Lo
フ                                  | KATAKANA LETTER HU                                                                                           | `Hu`       | &amp;x30D5;   | x30D5  | 12501  | E3 83 95    | FF FE D5 30       | Lo
ブ                                  | KATAKANA LETTER BU                                                                                           | `Bu`       | &amp;x30D6;   | x30D6  | 12502  | E3 83 96    | FF FE D6 30       | Lo
プ                                  | KATAKANA LETTER PU                                                                                           | `Pu`       | &amp;x30D7;   | x30D7  | 12503  | E3 83 97    | FF FE D7 30       | Lo
ヘ                                  | KATAKANA LETTER HE                                                                                           | `He`       | &amp;x30D8;   | x30D8  | 12504  | E3 83 98    | FF FE D8 30       | Lo
ベ                                  | KATAKANA LETTER BE                                                                                           | `Be`       | &amp;x30D9;   | x30D9  | 12505  | E3 83 99    | FF FE D9 30       | Lo
ペ                                  | KATAKANA LETTER PE                                                                                           | `Pe`       | &amp;x30DA;   | x30DA  | 12506  | E3 83 9A    | FF FE DA 30       | Lo
ホ                                  | KATAKANA LETTER HO                                                                                           | `Ho`       | &amp;x30DB;   | x30DB  | 12507  | E3 83 9B    | FF FE DB 30       | Lo
ボ                                  | KATAKANA LETTER BO                                                                                           | `Bo`       | &amp;x30DC;   | x30DC  | 12508  | E3 83 9C    | FF FE DC 30       | Lo
ポ                                  | KATAKANA LETTER PO                                                                                           | `Po`       | &amp;x30DD;   | x30DD  | 12509  | E3 83 9D    | FF FE DD 30       | Lo
マ                                  | KATAKANA LETTER MA                                                                                           | `Ma`       | &amp;x30DE;   | x30DE  | 12510  | E3 83 9E    | FF FE DE 30       | Lo
ミ                                  | KATAKANA LETTER MI                                                                                           | `Mi`       | &amp;x30DF;   | x30DF  | 12511  | E3 83 9F    | FF FE DF 30       | Lo
ム                                  | KATAKANA LETTER MU                                                                                           | `Mu`       | &amp;x30E0;   | x30E0  | 12512  | E3 83 A0    | FF FE E0 30       | Lo
メ                                  | KATAKANA LETTER ME                                                                                           | `Me`       | &amp;x30E1;   | x30E1  | 12513  | E3 83 A1    | FF FE E1 30       | Lo
モ                                  | KATAKANA LETTER MO                                                                                           | `Mo`       | &amp;x30E2;   | x30E2  | 12514  | E3 83 A2    | FF FE E2 30       | Lo
ャ                                  | KATAKANA LETTER SMALL YA                                                                                     | `YA`       | &amp;x30E3;   | x30E3  | 12515  | E3 83 A3    | FF FE E3 30       | Lo
ヤ                                  | KATAKANA LETTER YA                                                                                           | `Ya`       | &amp;x30E4;   | x30E4  | 12516  | E3 83 A4    | FF FE E4 30       | Lo
ュ                                  | KATAKANA LETTER SMALL YU                                                                                     | `YU`       | &amp;x30E5;   | x30E5  | 12517  | E3 83 A5    | FF FE E5 30       | Lo
ユ                                  | KATAKANA LETTER YU                                                                                           | `Yu`       | &amp;x30E6;   | x30E6  | 12518  | E3 83 A6    | FF FE E6 30       | Lo
ョ                                  | KATAKANA LETTER SMALL YO                                                                                     | `YO`       | &amp;x30E7;   | x30E7  | 12519  | E3 83 A7    | FF FE E7 30       | Lo
ヨ                                  | KATAKANA LETTER YO                                                                                           | `Yo`       | &amp;x30E8;   | x30E8  | 12520  | E3 83 A8    | FF FE E8 30       | Lo
ラ                                  | KATAKANA LETTER RA                                                                                           | `Ra`       | &amp;x30E9;   | x30E9  | 12521  | E3 83 A9    | FF FE E9 30       | Lo
リ                                  | KATAKANA LETTER RI                                                                                           | `Ri`       | &amp;x30EA;   | x30EA  | 12522  | E3 83 AA    | FF FE EA 30       | Lo
ル                                  | KATAKANA LETTER RU                                                                                           | `Ru`       | &amp;x30EB;   | x30EB  | 12523  | E3 83 AB    | FF FE EB 30       | Lo
レ                                  | KATAKANA LETTER RE                                                                                           | `Re`       | &amp;x30EC;   | x30EC  | 12524  | E3 83 AC    | FF FE EC 30       | Lo
ロ                                  | KATAKANA LETTER RO                                                                                           | `Ro`       | &amp;x30ED;   | x30ED  | 12525  | E3 83 AD    | FF FE ED 30       | Lo
ヮ                                  | KATAKANA LETTER SMALL WA                                                                                     | `WA`       | &amp;x30EE;   | x30EE  | 12526  | E3 83 AE    | FF FE EE 30       | Lo
ワ                                  | KATAKANA LETTER WA                                                                                           | `Wa`       | &amp;x30EF;   | x30EF  | 12527  | E3 83 AF    | FF FE EF 30       | Lo
ヰ                                  | KATAKANA LETTER WI                                                                                           | `Wi`       | &amp;x30F0;   | x30F0  | 12528  | E3 83 B0    | FF FE F0 30       | Lo
ヱ                                  | KATAKANA LETTER WE                                                                                           | `We`       | &amp;x30F1;   | x30F1  | 12529  | E3 83 B1    | FF FE F1 30       | Lo
ヲ                                  | KATAKANA LETTER WO                                                                                           | `Wo`       | &amp;x30F2;   | x30F2  | 12530  | E3 83 B2    | FF FE F2 30       | Lo
ン                                  | KATAKANA LETTER N                                                                                            | `N6`       | &amp;x30F3;   | x30F3  | 12531  | E3 83 B3    | FF FE F3 30       | Lo
ヴ                                  | KATAKANA LETTER VU                                                                                           | `Vu`       | &amp;x30F4;   | x30F4  | 12532  | E3 83 B4    | FF FE F4 30       | Lo
ヵ                                  | KATAKANA LETTER SMALL KA                                                                                     | `KA`       | &amp;x30F5;   | x30F5  | 12533  | E3 83 B5    | FF FE F5 30       | Lo
ヶ                                  | KATAKANA LETTER SMALL KE                                                                                     | `KE`       | &amp;x30F6;   | x30F6  | 12534  | E3 83 B6    | FF FE F6 30       | Lo
ヷ                                  | KATAKANA LETTER VA                                                                                           | `Va`       | &amp;x30F7;   | x30F7  | 12535  | E3 83 B7    | FF FE F7 30       | Lo
ヸ                                  | KATAKANA LETTER VI                                                                                           | `Vi`       | &amp;x30F8;   | x30F8  | 12536  | E3 83 B8    | FF FE F8 30       | Lo
ヹ                                  | KATAKANA LETTER VE                                                                                           | `Ve`       | &amp;x30F9;   | x30F9  | 12537  | E3 83 B9    | FF FE F9 30       | Lo
ヺ                                  | KATAKANA LETTER VO                                                                                           | `Vo`       | &amp;x30FA;   | x30FA  | 12538  | E3 83 BA    | FF FE FA 30       | Lo
・                                  | KATAKANA MIDDLE DOT                                                                                          | `.6`       | &amp;x30FB;   | x30FB  | 12539  | E3 83 BB    | FF FE FB 30       | Po
ー                                  | KATAKANA-HIRAGANA PROLONGED SOUND MARK                                                                       | `-6`       | &amp;x30FC;   | x30FC  | 12540  | E3 83 BC    | FF FE FC 30       | Lm
ヽ                                  | KATAKANA ITERATION MARK                                                                                      | `*6`       | &amp;x30FD;   | x30FD  | 12541  | E3 83 BD    | FF FE FD 30       | Lm
ヾ                                  | KATAKANA VOICED ITERATION MARK                                                                               | `+6`       | &amp;x30FE;   | x30FE  | 12542  | E3 83 BE    | FF FE FE 30       | Lm
ㄅ                                  | BOPOMOFO LETTER B                                                                                            | `b4`       | &amp;x3105;   | x3105  | 12549  | E3 84 85    | FF FE 05 31       | Lo
ㄆ                                  | BOPOMOFO LETTER P                                                                                            | `p4`       | &amp;x3106;   | x3106  | 12550  | E3 84 86    | FF FE 06 31       | Lo
ㄇ                                  | BOPOMOFO LETTER M                                                                                            | `m4`       | &amp;x3107;   | x3107  | 12551  | E3 84 87    | FF FE 07 31       | Lo
ㄈ                                  | BOPOMOFO LETTER F                                                                                            | `f4`       | &amp;x3108;   | x3108  | 12552  | E3 84 88    | FF FE 08 31       | Lo
ㄉ                                  | BOPOMOFO LETTER D                                                                                            | `d4`       | &amp;x3109;   | x3109  | 12553  | E3 84 89    | FF FE 09 31       | Lo
ㄊ                                  | BOPOMOFO LETTER T                                                                                            | `t4`       | &amp;x310A;   | x310A  | 12554  | E3 84 8A    | FF FE 0A 31       | Lo
ㄋ                                  | BOPOMOFO LETTER N                                                                                            | `n4`       | &amp;x310B;   | x310B  | 12555  | E3 84 8B    | FF FE 0B 31       | Lo
ㄌ                                  | BOPOMOFO LETTER L                                                                                            | `l4`       | &amp;x310C;   | x310C  | 12556  | E3 84 8C    | FF FE 0C 31       | Lo
ㄍ                                  | BOPOMOFO LETTER G                                                                                            | `g4`       | &amp;x310D;   | x310D  | 12557  | E3 84 8D    | FF FE 0D 31       | Lo
ㄎ                                  | BOPOMOFO LETTER K                                                                                            | `k4`       | &amp;x310E;   | x310E  | 12558  | E3 84 8E    | FF FE 0E 31       | Lo
ㄏ                                  | BOPOMOFO LETTER H                                                                                            | `h4`       | &amp;x310F;   | x310F  | 12559  | E3 84 8F    | FF FE 0F 31       | Lo
ㄐ                                  | BOPOMOFO LETTER J                                                                                            | `j4`       | &amp;x3110;   | x3110  | 12560  | E3 84 90    | FF FE 10 31       | Lo
ㄑ                                  | BOPOMOFO LETTER Q                                                                                            | `q4`       | &amp;x3111;   | x3111  | 12561  | E3 84 91    | FF FE 11 31       | Lo
ㄒ                                  | BOPOMOFO LETTER X                                                                                            | `x4`       | &amp;x3112;   | x3112  | 12562  | E3 84 92    | FF FE 12 31       | Lo
ㄓ                                  | BOPOMOFO LETTER ZH                                                                                           | `zh`       | &amp;x3113;   | x3113  | 12563  | E3 84 93    | FF FE 13 31       | Lo
ㄔ                                  | BOPOMOFO LETTER CH                                                                                           | `ch`       | &amp;x3114;   | x3114  | 12564  | E3 84 94    | FF FE 14 31       | Lo
ㄕ                                  | BOPOMOFO LETTER SH                                                                                           | `sh`       | &amp;x3115;   | x3115  | 12565  | E3 84 95    | FF FE 15 31       | Lo
ㄖ                                  | BOPOMOFO LETTER R                                                                                            | `r4`       | &amp;x3116;   | x3116  | 12566  | E3 84 96    | FF FE 16 31       | Lo
ㄗ                                  | BOPOMOFO LETTER Z                                                                                            | `z4`       | &amp;x3117;   | x3117  | 12567  | E3 84 97    | FF FE 17 31       | Lo
ㄘ                                  | BOPOMOFO LETTER C                                                                                            | `c4`       | &amp;x3118;   | x3118  | 12568  | E3 84 98    | FF FE 18 31       | Lo
ㄙ                                  | BOPOMOFO LETTER S                                                                                            | `s4`       | &amp;x3119;   | x3119  | 12569  | E3 84 99    | FF FE 19 31       | Lo
ㄚ                                  | BOPOMOFO LETTER A                                                                                            | `a4`       | &amp;x311A;   | x311A  | 12570  | E3 84 9A    | FF FE 1A 31       | Lo
ㄛ                                  | BOPOMOFO LETTER O                                                                                            | `o4`       | &amp;x311B;   | x311B  | 12571  | E3 84 9B    | FF FE 1B 31       | Lo
ㄜ                                  | BOPOMOFO LETTER E                                                                                            | `e4`       | &amp;x311C;   | x311C  | 12572  | E3 84 9C    | FF FE 1C 31       | Lo
ㄞ                                  | BOPOMOFO LETTER AI                                                                                           | `ai`       | &amp;x311E;   | x311E  | 12574  | E3 84 9E    | FF FE 1E 31       | Lo
ㄟ                                  | BOPOMOFO LETTER EI                                                                                           | `ei`       | &amp;x311F;   | x311F  | 12575  | E3 84 9F    | FF FE 1F 31       | Lo
ㄠ                                  | BOPOMOFO LETTER AU                                                                                           | `au`       | &amp;x3120;   | x3120  | 12576  | E3 84 A0    | FF FE 20 31       | Lo
ㄡ                                  | BOPOMOFO LETTER OU                                                                                           | `ou`       | &amp;x3121;   | x3121  | 12577  | E3 84 A1    | FF FE 21 31       | Lo
ㄢ                                  | BOPOMOFO LETTER AN                                                                                           | `an`       | &amp;x3122;   | x3122  | 12578  | E3 84 A2    | FF FE 22 31       | Lo
ㄣ                                  | BOPOMOFO LETTER EN                                                                                           | `en`       | &amp;x3123;   | x3123  | 12579  | E3 84 A3    | FF FE 23 31       | Lo
ㄤ                                  | BOPOMOFO LETTER ANG                                                                                          | `aN`       | &amp;x3124;   | x3124  | 12580  | E3 84 A4    | FF FE 24 31       | Lo
ㄥ                                  | BOPOMOFO LETTER ENG                                                                                          | `eN`       | &amp;x3125;   | x3125  | 12581  | E3 84 A5    | FF FE 25 31       | Lo
ㄦ                                  | BOPOMOFO LETTER ER                                                                                           | `er`       | &amp;x3126;   | x3126  | 12582  | E3 84 A6    | FF FE 26 31       | Lo
ㄧ                                  | BOPOMOFO LETTER I                                                                                            | `i4`       | &amp;x3127;   | x3127  | 12583  | E3 84 A7    | FF FE 27 31       | Lo
ㄨ                                  | BOPOMOFO LETTER U                                                                                            | `u4`       | &amp;x3128;   | x3128  | 12584  | E3 84 A8    | FF FE 28 31       | Lo
ㄩ                                  | BOPOMOFO LETTER IU                                                                                           | `iu`       | &amp;x3129;   | x3129  | 12585  | E3 84 A9    | FF FE 29 31       | Lo
ㄪ                                  | BOPOMOFO LETTER V                                                                                            | `v4`       | &amp;x312A;   | x312A  | 12586  | E3 84 AA    | FF FE 2A 31       | Lo
ㄫ                                  | BOPOMOFO LETTER NG                                                                                           | `nG`       | &amp;x312B;   | x312B  | 12587  | E3 84 AB    | FF FE 2B 31       | Lo
ㄬ                                  | BOPOMOFO LETTER GN                                                                                           | `gn`       | &amp;x312C;   | x312C  | 12588  | E3 84 AC    | FF FE 2C 31       | Lo
㈠                                  | PARENTHESIZED IDEOGRAPH ONE                                                                                  | `1c`       | &amp;x3220;   | x3220  | 12832  | E3 88 A0    | FF FE 20 32       | No
㈡                                  | PARENTHESIZED IDEOGRAPH TWO                                                                                  | `2c`       | &amp;x3221;   | x3221  | 12833  | E3 88 A1    | FF FE 21 32       | No
㈢                                  | PARENTHESIZED IDEOGRAPH THREE                                                                                | `3c`       | &amp;x3222;   | x3222  | 12834  | E3 88 A2    | FF FE 22 32       | No
㈣                                  | PARENTHESIZED IDEOGRAPH FOUR                                                                                 | `4c`       | &amp;x3223;   | x3223  | 12835  | E3 88 A3    | FF FE 23 32       | No
㈤                                  | PARENTHESIZED IDEOGRAPH FIVE                                                                                 | `5c`       | &amp;x3224;   | x3224  | 12836  | E3 88 A4    | FF FE 24 32       | No
㈥                                  | PARENTHESIZED IDEOGRAPH SIX                                                                                  | `6c`       | &amp;x3225;   | x3225  | 12837  | E3 88 A5    | FF FE 25 32       | No
㈦                                  | PARENTHESIZED IDEOGRAPH SEVEN                                                                                | `7c`       | &amp;x3226;   | x3226  | 12838  | E3 88 A6    | FF FE 26 32       | No
㈧                                  | PARENTHESIZED IDEOGRAPH EIGHT                                                                                | `8c`       | &amp;x3227;   | x3227  | 12839  | E3 88 A7    | FF FE 27 32       | No
㈨                                  | PARENTHESIZED IDEOGRAPH NINE                                                                                 | `9c`       | &amp;x3228;   | x3228  | 12840  | E3 88 A8    | FF FE 28 32       | No
ﬀ                                  | LATIN SMALL LIGATURE FF                                                                                      | `ff`       | &amp;xFB00;   | xFB00  | 64256  | EF AC 80    | FF FE 00 FB       | Ll
ﬁ                                  | LATIN SMALL LIGATURE FI                                                                                      | `fi`       | &amp;xFB01;   | xFB01  | 64257  | EF AC 81    | FF FE 01 FB       | Ll
ﬂ                                  | LATIN SMALL LIGATURE FL                                                                                      | `fl`       | &amp;xFB02;   | xFB02  | 64258  | EF AC 82    | FF FE 02 FB       | Ll
ﬅ                                  | LATIN SMALL LIGATURE LONG S T                                                                                | `ft`       | &amp;xFB05;   | xFB05  | 64261  | EF AC 85    | FF FE 05 FB       | Ll
ﬆ                                  | LATIN SMALL LIGATURE ST                                                                                      | `st`       | &amp;xFB06;   | xFB06  | 64262  | EF AC 86    | FF FE 06 FB       | Ll


## Unassigned Digraphs <a id="unassigned-digraphs"></a>


Vim provides 1304 pre-defined digraphs using the following characters:

```
!"%'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz
```
The following 1021 digraphs areunassigned, but their reverse is assigned and therefore Vim will treat them as their reverse.
```
!', !(, !,, !-, !3, !4, !;, !A, !E, !O, !U, !W, !Y, !a, !e, !i, !o, !u
!w, !y, "%, "', "(, "), "1, "2, "3, "<, "=, ">, "O, "U, "o, "u, %A, %C
%D, %E, %G, %I, %J, %K, %M, %N, %O, %P, %S, %U, %V, %W, %Y, %Z, %a, %c
%d, %e, %g, %i, %j, %o, %s, %u, %v, %w, %y, %z, '), '1, '2, '3, '=, 'A
'C, 'E, 'H, 'I, 'K, 'L, 'M, 'N, 'O, 'P, 'R, 'S, 'U, 'W, 'Y, 'Z, 'a, 'c
'e, 'g, 'i, 'k, 'l, 'o, 'p, 'r, 's, 'u, 'w, 'y, 'z, (0, (<, (E, (G, (O
(a, (e, (g, (i, (o, (u, )!, )-, *<, *A, *B, *C, *D, *E, *F, *G, *H, *I
*J, *K, *L, *M, *N, *O, *Q, *R, *S, *T, *U, *V, *W, *Y, *Z, *a, *b, *c
*d, *e, *f, *g, *h, *i, *j, *k, *l, *m, *n, *o, *p, *q, *r, *t, *u, *v
*w, *x, *y, *z, +', +,, +/, +0, +1, +3, +:, +;, +<, +=, +>, +?, +A, +B
+D, +E, +G, +H, +J, +K, +L, +M, +N, +P, +Q, +R, +T, +W, +X, +a, +b, +c
+d, +e, +f, +g, +h, +i, +j, +k, +l, +m, +n, +p, +q, +r, +t, +v, +w, +x
+y, +z, ,?, ,C, ,D, ,H, ,K, ,L, ,N, ,R, ,S, ,T, ,c, ,d, ,g, ,h, ,k, ,l
,n, ,r, ,s, ,t, -', -(, -*, -/, -4, -<, -A, -D, -E, -G, -I, -O, -U, -d
-e, -g, -i, -u, .', .,, .0, .1, .2, .4, .5, .7, .8, .B, .C, .D, .E, .F
.G, .H, .I, .L, .N, .R, .T, .W, .X, .Y, .Z, .b, .c, .d, .e, .f, .g, .h
.i, .l, .m, .n, .p, .r, .s, .t, .w, .x, .y, .z, /3, /4, /<, /D, /G, /H
/L, /O, /T, /Z, /d, /g, /h, /l, /o, /t, /z, 0%, 0', 0/, 0N, 0w, 0y, 1*
1-, 1<, 1>, 1?, 1A, 1D, 1O, 1P, 1o, 2!, 2*, 2-, 20, 21, 2=, 2?, 2A, 2D
2E, 2I, 2M, 2O, 2P, 2U, 2Y, 2e, 2i, 2o, 2u, 2y, 31, 32, 3:, 3=, 3A, 3C
3D, 3F, 3G, 3K, 3O, 3P, 3T, 3V, 3Y, 3f, 3g, 3i, 3k, 3m, 3o, 3p, 3t, 3u
3v, 3y, 41, 43, 4D, 4b, 4d, 4e, 4f, 4g, 4i, 4k, 4l, 4m, 4n, 4o, 4p, 4q
4t, 4u, 4v, 4x, 4z, 5", 5*, 5+, 50, 51, 52, 53, 54, 5A, 5E, 5I, 5O, 5U
5e, 5i, 5n, 5o, 5u, 6", 6', 6*, 6+, 6-, 61, 65, 6A, 6E, 6I, 6N, 6O, 6U
6e, 6i, 6o, 6u, 7A, 81, 83, 85, 87, 8M, 9:, 9O, 9U, 9o, 9u, :!, :', :-
:?, :A, :E, :H, :I, :O, :U, :W, :Y, :a, :e, :h, :i, :o, :t, :u, :w, :x
:y, ;?, ;A, ;E, ;I, ;O, ;U, ;a, ;e, ;i, ;o, ;u, <!, <A, <C, <D, <E, <G
<I, <K, <L, <N, <O, <R, <S, <T, <U, <Z, <a, <c, <d, <e, <g, <i, <j, <k
<l, <n, <o, <r, <s, <t, <u, <z, =!, =/, =A, =B, =C, =D, =E, =F, =G, =H
=I, =J, =K, =L, =M, =N, =O, =U, =V, =W, =Y, =Z, =a, =b, =c, =d, =e, =f
=g, =h, =i, =j, =k, =l, =m, =n, =o, =p, =r, =t, =u, =v, =y, =z, >!, >)
>*, >-, >/, ><, >A, >C, >E, >G, >I, >J, >O, >S, >U, >W, >Y, >Z, >a, >c
>e, >g, >h, >i, >j, >o, >s, >u, >w, >y, >z, ?', ?A, ?E, ?N, ?O, ?U, ?V
?Y, ?a, ?e, ?i, ?n, ?o, ?u, ?v, ?y, AF, AJ, AP, AS, AW, AY, Aw, Ay, BE
BF, BN, BR, BT, Bl, Bs, C(, C), CA, CD, CE, CO, CS, Cc, DB, DF, DP, DU
Dc, EA, EI, EJ, EK, EO, FL, FR, Fo, GD, GE, GN, Gn, H1, H<, HB, HD, HN
HR, HU, HV, Hc, Hd, Hv, Hw, Hy, Hz, I), IC, ID, IH, IP, IR, IY, JH, JI
JK, JL, JN, JZ, KN, KO, KR, L-, L0, LN, LP, LU, LV, Ld, Lu, Lv, M-, M0
M1, M4, M6, ME, MP, MS, MT, N-, N1, NA, NC, OA, OD, OH, ON, OP, OY, Oy
PS, QE, R0, R1, R2, R3, R4, R5, R6, R7, R8, R9, R:, RC, RD, RP, RU, RV
Rb, Rc, Rd, Rv, S(, S), S-, S0, S1, S4, S5, S6, S7, S8, S9, S:, S;, S?
SD, SF, SN, SV, Sf, T-, T1, TD, TV, Td, U), UJ, UN, UP, UY, Ut, Uy, V-
WM, X-, XE, XM, XR, XS, YR, YS, ZD, ZE, ZL, ZR, a0, a8, a9, aB, aC, aD
aG, aK, aP, aT, aV, aW, aY, aZ, ab, ad, ag, aj, ak, am, ap, as, at, aw
ay, az, bD, bM, bN, bO, bS, c1, c2, c5, c6, c7, c8, c9, cI, cs, dB, dF
dM, eB, eD, eG, eH, eK, eM, eP, eR, eS, eT, eV, eW, eY, eZ, ea, eb, ed
eg, eh, ej, ek, em, eo, ep, es, et, ew, f/, fg, gR, h1, h2, h3, hD, hE
hS, hU, hV, hc, hd, hs, ht, hv, hz, iB, iD, iG, iH, iK, iL, iM, iN, iP
iR, iS, iT, iV, iW, iZ, ia, ib, id, if, ig, ih, ik, im, in, ip, ir, is
it, iw, iy, iz, j1, j2, jT, jZ, ji, jk, jl, jn, jt, kd, kh, kt, lD, lI
lM, lT, lU, lV, ld, lf, lu, lv, m0, mF, mO, mt, nI, ns, o0, oB, oD, oG
oH, oI, oK, oM, oN, oP, oR, oS, oT, oV, oW, oY, oZ, ob, oc, od, og, oh
ok, om, on, op, or, os, ot, ow, oy, oz, r1, r2, r3, r5, r6, r7, r8, r9
rD, rO, rR, rT, rU, rV, rb, rc, rd, rv, ry, s(, s), s-, s0, s1, s2, s3
s5, s6, s7, s8, s9, sT, sV, sd, tA, tC, tD, tP, tf, uB, uC, uD, uE, uG
uI, uK, uM, uN, uP, uS, uV, uY, uZ, ua, ub, ud, ug, ui, uj, uk, um, un
uo, up, us, ut, uv, uy, uz, v-, wD, xM, xR, yM, zd
```
The following 4122 are fully unassigned.
```
!"/"!, !%/%!, !*/*!, !+/+!, !./.!, !///!, !0/0!, !1/1!, !5/5!, !6/6!
!7/7!, !8/8!, !9/9!, !?/?!, !B/B!, !C/C!, !D/D!, !F/F!, !G/G!, !H/H!
!J/J!, !K/K!, !L/L!, !M/M!, !N/N!, !P/P!, !Q/Q!, !R/R!, !S/S!, !T/T!
!V/V!, !X/X!, !Z/Z!, !_, !b/b!, !c/c!, !d/d!, !f/f!, !g/g!, !h/h!
!j/j!, !k/k!, !l/l!, !m/m!, !n/n!, !p/p!, !q/q!, !r/r!, !s/s!, !t/t!
!v/v!, !x/x!, !z/z!, "*/*", ",/,", "-/-", "./.", "///", "0/0", "4/4"
"7/7", "8/8", ":/:", ";/;", "?/?", "A/A", "B/B", "C/C", "D/D", "E/E"
"F/F", "G/G", "H/H", "I/I", "J/J", "K/K", "L/L", "M/M", "N/N", "P/P"
"Q/Q", "R/R", "S/S", "T/T", "V/V", "W/W", "X/X", "Y/Y", "Z/Z", "_
"a/a", "b/b", "c/c", "d/d", "e/e", "f/f", "g/g", "h/h", "i/i", "j/j"
"k/k", "l/l", "m/m", "n/n", "p/p", "q/q", "r/r", "s/s", "t/t", "v/v"
"w/w", "x/x", "y/y", "z/z", %(/(%, %)/)%, %*/*%, %+/+%, %,/,%, %-/-%
%./.%, %///%, %1/1%, %2/2%, %3/3%, %4/4%, %5/5%, %6/6%, %7/7%, %8/8%
%9/9%, %:/:%, %;/;%, %</<%, %=/=%, %>/>%, %?/?%, %B/B%, %F/F%, %H/H%
%L/L%, %Q/Q%, %R/R%, %T/T%, %X/X%, %_, %b/b%, %f/f%, %h/h%, %k/k%
%l/l%, %m/m%, %n/n%, %p/p%, %q/q%, %r/r%, %t/t%, %x/x%, '*/*', '///'
'4/4', '5/5', '7/7', '8/8', 'B/B', 'D/D', 'F/F', 'J/J', 'Q/Q', 'T/T'
'V/V', 'X/X', '_, 'b/b', 'd/d', 'f/f', 'h/h', 'j/j', 'q/q', 't/t'
'v/v', 'x/x', ()/)(, (*/*(, (+/+(, (,/,(, (./.(, (///(, (1/1(, (2/2(
(3/3(, (4/4(, (5/5(, (6/6(, (7/7(, (8/8(, (9/9(, (:/:(, (;/;(, (=/=(
(>/>(, (?/?(, (B/B(, (D/D(, (F/F(, (H/H(, (J/J(, (K/K(, (L/L(, (M/M(
(N/N(, (P/P(, (Q/Q(, (R/R(, (T/T(, (V/V(, (W/W(, (X/X(, (Y/Y(, (Z/Z(
(b/b(, (c/c(, (d/d(, (f/f(, (h/h(, (j/j(, (k/k(, (l/l(, (m/m(, (n/n(
(p/p(, (q/q(, (r/r(, (t/t(, (v/v(, (w/w(, (x/x(, (y/y(, (z/z(, )*/*)
)+/+), ),/,), )./.), )///), )0/0), )1/1), )2/2), )3/3), )4/4), )5/5)
)6/6), )7/7), )8/8), )9/9), ):/:), );/;), )</<), )=/=), )?/?), )A/A)
)B/B), )D/D), )E/E), )F/F), )G/G), )H/H), )J/J), )K/K), )L/L), )M/M)
)N/N), )O/O), )P/P), )Q/Q), )R/R), )T/T), )V/V), )W/W), )X/X), )Y/Y)
)Z/Z), )a/a), )b/b), )c/c), )d/d), )e/e), )f/f), )g/g), )h/h), )i/i)
)j/j), )k/k), )l/l), )m/m), )n/n), )o/o), )p/p), )q/q), )r/r), )t/t)
)u/u), )v/v), )w/w), )x/x), )y/y), )z/z), *+/+*, *,/,*, *./.*, *///*
*0/0*, *3/3*, *4/4*, *7/7*, *8/8*, *9/9*, *:/:*, *;/;*, *=/=*, *?/?*
+./.+, +2/2+, +4/4+, +7/7+, +8/8+, +9/9+, +C/C+, +F/F+, +I/I+, +O/O+
+U/U+, +V/V+, +Y/Y+, +o/o+, +u/u+, ,-/-,, ,///,, ,0/0,, ,1/1,, ,2/2,
,3/3,, ,4/4,, ,5/5,, ,6/6,, ,7/7,, ,8/8,, ,9/9,, ,:/:,, ,;/;,, ,</<,
,=/=,, ,>/>,, ,A/A,, ,B/B,, ,E/E,, ,F/F,, ,I/I,, ,J/J,, ,M/M,, ,O/O,
,P/P,, ,Q/Q,, ,U/U,, ,V/V,, ,W/W,, ,X/X,, ,Y/Y,, ,Z/Z,, ,a/a,, ,b/b,
,e/e,, ,f/f,, ,i/i,, ,j/j,, ,m/m,, ,o/o,, ,p/p,, ,q/q,, ,u/u,, ,v/v,
,w/w,, ,x/x,, ,y/y,, ,z/z,, -./.-, -0/0-, -5/5-, -7/7-, -8/8-, -9/9-
-;/;-, -=/=-, -B/B-, -C/C-, -F/F-, -H/H-, -J/J-, -K/K-, -P/P-, -Q/Q-
-R/R-, -W/W-, -Y/Y-, -Z/Z-, -_, -b/b-, -c/c-, -f/f-, -h/h-, -j/j-
-k/k-, -l/l-, -m/m-, -n/n-, -p/p-, -q/q-, -r/r-, -t/t-, -w/w-, -x/x-
-y/y-, -z/z-, .///., .;/;., .</<., .=/=., .>/>., .?/?., .A/A., .J/J.
.K/K., .O/O., .Q/Q., .U/U., .V/V., .a/a., .j/j., .k/k., .o/o., .q/q.
.u/u., .v/v., /1/1/, /2/2/, /5/5/, /6/6/, /7/7/, /8/8/, /9/9/, /:/:/
/;/;/, /?/?/, /A/A/, /B/B/, /C/C/, /E/E/, /F/F/, /I/I/, /J/J/, /K/K/
/M/M/, /N/N/, /P/P/, /Q/Q/, /R/R/, /S/S/, /U/U/, /V/V/, /W/W/, /X/X/
/Y/Y/, /_, /a/a/, /b/b/, /c/c/, /e/e/, /i/i/, /j/j/, /k/k/, /m/m/
/n/n/, /p/p/, /q/q/, /r/r/, /s/s/, /u/u/, /v/v/, /w/w/, /x/x/, /y/y/
01/10, 03/30, 04/40, 06/60, 07/70, 08/80, 09/90, 0:/:0, 0;/;0, 0</<0
0=/=0, 0>/>0, 0?/?0, 0A/A0, 0B/B0, 0C/C0, 0D/D0, 0E/E0, 0F/F0, 0G/G0
0H/H0, 0I/I0, 0J/J0, 0K/K0, 0O/O0, 0P/P0, 0Q/Q0, 0T/T0, 0V/V0, 0W/W0
0X/X0, 0Y/Y0, 0Z/Z0, 0b/b0, 0c/c0, 0d/d0, 0e/e0, 0f/f0, 0g/g0, 0h/h0
0i/i0, 0j/j0, 0k/k0, 0l/l0, 0n/n0, 0p/p0, 0q/q0, 0r/r0, 0t/t0, 0v/v0
0x/x0, 0z/z0, 17/71, 19/91, 1:/:1, 1;/;1, 1=/=1, 1B/B1, 1C/C1, 1E/E1
1F/F1, 1G/G1, 1I/I1, 1J/J1, 1K/K1, 1L/L1, 1Q/Q1, 1U/U1, 1V/V1, 1W/W1
1X/X1, 1Y/Y1, 1Z/Z1, 1_, 1b/b1, 1d/d1, 1e/e1, 1f/f1, 1g/g1, 1i/i1
1k/k1, 1l/l1, 1m/m1, 1n/n1, 1p/p1, 1q/q1, 1t/t1, 1u/u1, 1v/v1, 1w/w1
1x/x1, 1y/y1, 1z/z1, 24/42, 26/62, 27/72, 28/82, 29/92, 2:/:2, 2;/;2
2</<2, 2>/>2, 2B/B2, 2C/C2, 2F/F2, 2G/G2, 2H/H2, 2J/J2, 2K/K2, 2L/L2
2N/N2, 2Q/Q2, 2T/T2, 2V/V2, 2W/W2, 2X/X2, 2Z/Z2, 2_, 2b/b2, 2d/d2
2f/f2, 2g/g2, 2k/k2, 2l/l2, 2m/m2, 2n/n2, 2p/p2, 2q/q2, 2t/t2, 2v/v2
2w/w2, 2x/x2, 2z/z2, 36/63, 37/73, 39/93, 3;/;3, 3</<3, 3>/>3, 3?/?3
3B/B3, 3E/E3, 3H/H3, 3I/I3, 3J/J3, 3L/L3, 3N/N3, 3Q/Q3, 3U/U3, 3W/W3
3X/X3, 3Z/Z3, 3b/b3, 3d/d3, 3e/e3, 3l/l3, 3n/n3, 3q/q3, 3w/w3, 3x/x3
3z/z3, 46/64, 47/74, 48/84, 49/94, 4:/:4, 4;/;4, 4</<4, 4=/=4, 4>/>4
4?/?4, 4A/A4, 4B/B4, 4C/C4, 4E/E4, 4F/F4, 4G/G4, 4H/H4, 4I/I4, 4J/J4
4K/K4, 4L/L4, 4N/N4, 4O/O4, 4P/P4, 4Q/Q4, 4T/T4, 4U/U4, 4V/V4, 4W/W4
4X/X4, 4Y/Y4, 4Z/Z4, 4w/w4, 4y/y4, 57/75, 59/95, 5:/:5, 5;/;5, 5</<5
5=/=5, 5>/>5, 5?/?5, 5B/B5, 5C/C5, 5D/D5, 5F/F5, 5G/G5, 5H/H5, 5J/J5
5K/K5, 5L/L5, 5M/M5, 5N/N5, 5P/P5, 5Q/Q5, 5T/T5, 5V/V5, 5W/W5, 5X/X5
5Y/Y5, 5Z/Z5, 5_, 5b/b5, 5d/d5, 5f/f5, 5g/g5, 5h/h5, 5j/j5, 5k/k5
5l/l5, 5m/m5, 5p/p5, 5q/q5, 5t/t5, 5v/v5, 5w/w5, 5x/x5, 5y/y5, 5z/z5
67/76, 68/86, 69/96, 6:/:6, 6;/;6, 6</<6, 6=/=6, 6>/>6, 6?/?6, 6B/B6
6C/C6, 6D/D6, 6F/F6, 6G/G6, 6H/H6, 6J/J6, 6K/K6, 6L/L6, 6P/P6, 6Q/Q6
6T/T6, 6V/V6, 6W/W6, 6X/X6, 6Y/Y6, 6Z/Z6, 6_, 6b/b6, 6d/d6, 6f/f6
6g/g6, 6h/h6, 6j/j6, 6k/k6, 6l/l6, 6m/m6, 6n/n6, 6p/p6, 6q/q6, 6t/t6
6v/v6, 6w/w6, 6x/x6, 6y/y6, 6z/z6, 79/97, 7:/:7, 7;/;7, 7=/=7, 7?/?7
7B/B7, 7C/C7, 7D/D7, 7E/E7, 7F/F7, 7G/G7, 7H/H7, 7I/I7, 7J/J7, 7K/K7
7L/L7, 7M/M7, 7N/N7, 7O/O7, 7P/P7, 7Q/Q7, 7T/T7, 7U/U7, 7V/V7, 7W/W7
7X/X7, 7Y/Y7, 7Z/Z7, 7_, 7b/b7, 7d/d7, 7e/e7, 7f/f7, 7g/g7, 7h/h7
7i/i7, 7j/j7, 7k/k7, 7l/l7, 7m/m7, 7n/n7, 7o/o7, 7p/p7, 7q/q7, 7t/t7
7u/u7, 7v/v7, 7w/w7, 7x/x7, 7y/y7, 7z/z7, 89/98, 8:/:8, 8;/;8, 8</<8
8=/=8, 8>/>8, 8?/?8, 8A/A8, 8B/B8, 8C/C8, 8D/D8, 8E/E8, 8F/F8, 8G/G8
8H/H8, 8I/I8, 8J/J8, 8K/K8, 8L/L8, 8N/N8, 8O/O8, 8P/P8, 8Q/Q8, 8T/T8
8U/U8, 8V/V8, 8W/W8, 8X/X8, 8Y/Y8, 8Z/Z8, 8_, 8b/b8, 8d/d8, 8e/e8
8f/f8, 8g/g8, 8h/h8, 8i/i8, 8j/j8, 8k/k8, 8l/l8, 8m/m8, 8n/n8, 8o/o8
8p/p8, 8q/q8, 8t/t8, 8u/u8, 8v/v8, 8w/w8, 8x/x8, 8y/y8, 8z/z8, 9;/;9
9</<9, 9=/=9, 9>/>9, 9?/?9, 9A/A9, 9B/B9, 9C/C9, 9D/D9, 9E/E9, 9F/F9
9G/G9, 9H/H9, 9I/I9, 9J/J9, 9K/K9, 9L/L9, 9M/M9, 9N/N9, 9P/P9, 9Q/Q9
9T/T9, 9V/V9, 9W/W9, 9X/X9, 9Y/Y9, 9Z/Z9, 9_, 9b/b9, 9d/d9, 9e/e9
9f/f9, 9g/g9, 9h/h9, 9i/i9, 9j/j9, 9k/k9, 9l/l9, 9m/m9, 9n/n9, 9p/p9
9q/q9, 9t/t9, 9v/v9, 9w/w9, 9x/x9, 9y/y9, 9z/z9, :;/;:, :</<:, :=/=:
:>/>:, :B/B:, :C/C:, :D/D:, :F/F:, :G/G:, :J/J:, :K/K:, :L/L:, :M/M:
:N/N:, :P/P:, :Q/Q:, :T/T:, :V/V:, :Z/Z:, :_, :b/b:, :c/c:, :d/d:
:f/f:, :g/g:, :j/j:, :k/k:, :l/l:, :m/m:, :n/n:, :p/p:, :q/q:, :r/r:
:s/s:, :v/v:, :z/z:, ;</<;, ;=/=;, ;>/>;, ;B/B;, ;C/C;, ;D/D;, ;F/F;
;G/G;, ;H/H;, ;J/J;, ;K/K;, ;L/L;, ;M/M;, ;N/N;, ;P/P;, ;Q/Q;, ;R/R;
;T/T;, ;V/V;, ;W/W;, ;X/X;, ;Y/Y;, ;Z/Z;, ;b/b;, ;c/c;, ;d/d;, ;f/f;
;g/g;, ;h/h;, ;j/j;, ;k/k;, ;l/l;, ;m/m;, ;n/n;, ;p/p;, ;q/q;, ;r/r;
;s/s;, ;t/t;, ;v/v;, ;w/w;, ;x/x;, ;y/y;, ;z/z;, <?/?<, <B/B<, <F/F<
<J/J<, <M/M<, <P/P<, <Q/Q<, <V/V<, <W/W<, <X/X<, <Y/Y<, <_, <b/b<
<f/f<, <h/h<, <m/m<, <p/p<, <q/q<, <v/v<, <w/w<, <x/x<, <y/y<, =Q/Q=
=X/X=, =q/q=, =w/w=, =x/x=, >?/?>, >B/B>, >D/D>, >F/F>, >K/K>, >L/L>
>M/M>, >N/N>, >P/P>, >Q/Q>, >R/R>, >T/T>, >V/V>, >X/X>, >_, >b/b>
>d/d>, >f/f>, >k/k>, >l/l>, >m/m>, >n/n>, >p/p>, >q/q>, >r/r>, >t/t>
>v/v>, >x/x>, ?B/B?, ?C/C?, ?D/D?, ?F/F?, ?G/G?, ?H/H?, ?J/J?, ?K/K?
?L/L?, ?M/M?, ?P/P?, ?Q/Q?, ?R/R?, ?T/T?, ?W/W?, ?X/X?, ?Z/Z?, ?_
?b/b?, ?c/c?, ?d/d?, ?f/f?, ?g/g?, ?h/h?, ?j/j?, ?k/k?, ?l/l?, ?m/m?
?p/p?, ?q/q?, ?r/r?, ?s/s?, ?t/t?, ?w/w?, ?x/x?, ?z/z?, AB/BA, AD/DA
AG/GA, AH/HA, AI/IA, AL/LA, AM/MA, AQ/QA, AR/RA, AT/TA, AU/UA, AV/VA
AX/XA, AZ/ZA, A_, Aa/aA, Ab/bA, Ac/cA, Ad/dA, Ae/eA, Af/fA, Ag/gA
Ah/hA, Ai/iA, Aj/jA, Ak/kA, Al/lA, Am/mA, An/nA, Ao/oA, Ap/pA, Aq/qA
Ar/rA, As/sA, Au/uA, Av/vA, Ax/xA, Az/zA, BC/CB, BG/GB, BI/IB, BJ/JB
BK/KB, BM/MB, BO/OB, BP/PB, BQ/QB, BU/UB, BV/VB, BW/WB, BX/XB, BY/YB
BZ/ZB, Bb/bB, Bc/cB, Bf/fB, Bg/gB, Bh/hB, Bj/jB, Bk/kB, Bm/mB, Bn/nB
Bp/pB, Bq/qB, Br/rB, Bt/tB, Bv/vB, Bw/wB, Bx/xB, By/yB, Bz/zB, CF/FC
CH/HC, CJ/JC, CK/KC, CL/LC, CM/MC, CP/PC, CQ/QC, CT/TC, CU/UC, CV/VC
CW/WC, CX/XC, CY/YC, CZ/ZC, C_, Cb/bC, Cd/dC, Ce/eC, Cf/fC, Cg/gC
Ch/hC, Ci/iC, Cj/jC, Ck/kC, Cl/lC, Cm/mC, Cn/nC, Cp/pC, Cq/qC, Cr/rC
Cs/sC, Cv/vC, Cw/wC, Cx/xC, Cy/yC, Cz/zC, DJ/JD, DK/KD, DM/MD, DN/ND
DQ/QD, DV/VD, DW/WD, DX/XD, DY/YD, Dd/dD, Df/fD, Dg/gD, Dj/jD, Dk/kD
Dm/mD, Dn/nD, Dp/pD, Dq/qD, Ds/sD, Dv/vD, Dx/xD, Dy/yD, Dz/zD, EF/FE
EH/HE, EL/LE, EN/NE, EP/PE, ER/RE, EU/UE, EV/VE, EW/WE, EY/YE, E_
Ea/aE, Eb/bE, Ec/cE, Ed/dE, Ee/eE, Ef/fE, Eg/gE, Ei/iE, Ej/jE, Ek/kE
El/lE, Em/mE, En/nE, Eo/oE, Ep/pE, Eq/qE, Er/rE, Es/sE, Et/tE, Ev/vE
Ew/wE, Ex/xE, Ey/yE, Ez/zE, FG/GF, FH/HF, FI/IF, FJ/JF, FK/KF, FM/MF
FN/NF, FO/OF, FP/PF, FQ/QF, FT/TF, FU/UF, FV/VF, FW/WF, FX/XF, FY/YF
FZ/ZF, F_, Fa/aF, Fb/bF, Fc/cF, Fe/eF, Ff/fF, Fg/gF, Fh/hF, Fi/iF
Fj/jF, Fk/kF, Fl/lF, Fn/nF, Fp/pF, Fq/qF, Fr/rF, Fs/sF, Ft/tF, Fu/uF
Fv/vF, Fw/wF, Fx/xF, Fy/yF, Fz/zF, GH/HG, GI/IG, GJ/JG, GK/KG, GL/LG
GM/MG, GO/OG, GP/PG, GQ/QG, GR/RG, GT/TG, GU/UG, GV/VG, GW/WG, GX/XG
GY/YG, GZ/ZG, G_, Gb/bG, Gc/cG, Gd/dG, Gf/fG, Gg/gG, Gh/hG, Gj/jG
Gk/kG, Gl/lG, Gm/mG, Gp/pG, Gq/qG, Gr/rG, Gs/sG, Gt/tG, Gv/vG, Gw/wG
Gx/xG, Gy/yG, Gz/zG, HK/KH, HL/LH, HM/MH, HP/PH, HQ/QH, HW/WH, HX/XH
HY/YH, HZ/ZH, H_, Hb/bH, Hf/fH, Hg/gH, Hh/hH, Hj/jH, Hk/kH, Hl/lH
Hm/mH, Hn/nH, Hp/pH, Hq/qH, Hr/rH, Hs/sH, Ht/tH, Hx/xH, IK/KI, IL/LI
IM/MI, IQ/QI, IT/TI, IU/UI, IV/VI, IW/WI, IX/XI, IZ/ZI, I_, Ia/aI
Ib/bI, Id/dI, Ie/eI, If/fI, Ig/gI, Ih/hI, Ii/iI, Ij/jI, Ik/kI, Im/mI
Ip/pI, Iq/qI, Ir/rI, Is/sI, It/tI, Iv/vI, Iw/wI, Ix/xI, Iy/yI, Iz/zI
JM/MJ, JO/OJ, JP/PJ, JQ/QJ, JR/RJ, JS/SJ, JT/TJ, JV/VJ, JW/WJ, JX/XJ
JY/YJ, J_, Ja/aJ, Jb/bJ, Jc/cJ, Jd/dJ, Je/eJ, Jf/fJ, Jg/gJ, Jh/hJ
Ji/iJ, Jj/jJ, Jk/kJ, Jl/lJ, Jm/mJ, Jn/nJ, Jo/oJ, Jp/pJ, Jq/qJ, Jr/rJ
Js/sJ, Jt/tJ, Ju/uJ, Jv/vJ, Jw/wJ, Jx/xJ, Jy/yJ, Jz/zJ, KL/LK, KM/MK
KP/PK, KQ/QK, KS/SK, KT/TK, KU/UK, KV/VK, KW/WK, KX/XK, KY/YK, KZ/ZK
Kb/bK, Kc/cK, Kd/dK, Kf/fK, Kg/gK, Kh/hK, Kj/jK, Kk/kK, Kl/lK, Km/mK
Kn/nK, Kp/pK, Kq/qK, Kr/rK, Ks/sK, Kt/tK, Kv/vK, Kw/wK, Kx/xK, Ky/yK
Kz/zK, LM/ML, LO/OL, LQ/QL, LR/RL, LS/SL, LT/TL, LW/WL, LX/XL, LY/YL
La/aL, Lb/bL, Lc/cL, Le/eL, Lf/fL, Lg/gL, Lh/hL, Lj/jL, Lk/kL, Ll/lL
Lm/mL, Ln/nL, Lo/oL, Lp/pL, Lq/qL, Lr/rL, Ls/sL, Lt/tL, Lw/wL, Lx/xL
Ly/yL, Lz/zL, MN/NM, MO/OM, MQ/QM, MR/RM, MU/UM, MV/VM, MY/YM, MZ/ZM
M_, Mc/cM, Mf/fM, Mg/gM, Mh/hM, Mj/jM, Mk/kM, Mm/mM, Mn/nM, Mp/pM
Mq/qM, Mr/rM, Ms/sM, Mt/tM, Mv/vM, Mw/wM, Mz/zM, NP/PN, NQ/QN, NR/RN
NT/TN, NV/VN, NW/WN, NX/XN, NY/YN, NZ/ZN, Nc/cN, Nd/dN, Nf/fN, Ng/gN
Nh/hN, Nj/jN, Nk/kN, Nl/lN, Nm/mN, Nn/nN, Np/pN, Nq/qN, Nr/rN, Ns/sN
Nt/tN, Nv/vN, Nw/wN, Nx/xN, Ny/yN, Nz/zN, OQ/QO, OT/TO, OU/UO, OV/VO
OW/WO, OX/XO, OZ/ZO, O_, Oa/aO, Oc/cO, Od/dO, Oe/eO, Of/fO, Og/gO
Oh/hO, Oi/iO, Oj/jO, Ok/kO, Ol/lO, On/nO, Oo/oO, Op/pO, Oq/qO, Os/sO
Ot/tO, Ou/uO, Ov/vO, Ow/wO, Ox/xO, Oz/zO, PQ/QP, PT/TP, PV/VP, PW/WP
PX/XP, PY/YP, PZ/ZP, P_, Pb/bP, Pc/cP, Pf/fP, Pg/gP, Ph/hP, Pj/jP
Pk/kP, Pl/lP, Pm/mP, Pn/nP, Pp/pP, Pq/qP, Pr/rP, Ps/sP, Pv/vP, Pw/wP
Px/xP, Py/yP, Pz/zP, QR/RQ, QS/SQ, QT/TQ, QU/UQ, QV/VQ, QW/WQ, QX/XQ
QY/YQ, QZ/ZQ, Q_, Qa/aQ, Qb/bQ, Qc/cQ, Qd/dQ, Qe/eQ, Qf/fQ, Qg/gQ
Qh/hQ, Qi/iQ, Qj/jQ, Qk/kQ, Ql/lQ, Qm/mQ, Qn/nQ, Qo/oQ, Qp/pQ, Qq/qQ
Qr/rQ, Qs/sQ, Qt/tQ, Qu/uQ, Qv/vQ, Qw/wQ, Qx/xQ, Qy/yQ, Qz/zQ, RW/WR
Rf/fR, Rh/hR, Rj/jR, Rk/kR, Rl/lR, Rm/mR, Rn/nR, Rp/pR, Rq/qR, Rs/sR
Rt/tR, Rw/wR, Ry/yR, Rz/zR, SW/WS, SZ/ZS, S_, Sd/dS, Sg/gS, Sj/jS
Sk/kS, Sl/lS, Sm/mS, Sp/pS, Sq/qS, Sr/rS, Ss/sS, St/tS, Sv/vS, Sw/wS
Sx/xS, Sy/yS, Sz/zS, TW/WT, TX/XT, TY/YT, TZ/ZT, Tb/bT, Tc/cT, Tf/fT
Tg/gT, Th/hT, Tk/kT, Tm/mT, Tn/nT, Tp/pT, Tq/qT, Tt/tT, Tv/vT, Tw/wT
Tx/xT, Ty/yT, Tz/zT, UV/VU, UW/WU, UX/XU, UZ/ZU, U_, Ua/aU, Ub/bU
Uc/cU, Ud/dU, Ue/eU, Uf/fU, Ug/gU, Ui/iU, Uj/jU, Uk/kU, Um/mU, Un/nU
Uo/oU, Up/pU, Uq/qU, Us/sU, Uu/uU, Uv/vU, Uw/wU, Ux/xU, Uz/zU, VW/WV
VX/XV, VY/YV, VZ/ZV, V_, Vb/bV, Vc/cV, Vd/dV, Vf/fV, Vg/gV, Vj/jV
Vk/kV, Vm/mV, Vn/nV, Vp/pV, Vq/qV, Vt/tV, Vv/vV, Vw/wV, Vx/xV, Vy/yV
Vz/zV, WX/XW, WY/YW, WZ/ZW, W_, Wb/bW, Wc/cW, Wd/dW, Wf/fW, Wg/gW
Wh/hW, Wj/jW, Wk/kW, Wl/lW, Wm/mW, Wn/nW, Wp/pW, Wq/qW, Wr/rW, Ws/sW
Wt/tW, Wu/uW, Wv/vW, Ww/wW, Wx/xW, Wy/yW, Wz/zW, XY/YX, XZ/ZX, X_
Xa/aX, Xb/bX, Xc/cX, Xd/dX, Xe/eX, Xf/fX, Xg/gX, Xh/hX, Xi/iX, Xj/jX
Xk/kX, Xl/lX, Xm/mX, Xn/nX, Xo/oX, Xp/pX, Xq/qX, Xr/rX, Xs/sX, Xt/tX
Xu/uX, Xv/vX, Xw/wX, Xx/xX, Xy/yX, Xz/zX, YZ/ZY, Y_, Yb/bY, Yc/cY
Yd/dY, Yf/fY, Yg/gY, Yh/hY, Yi/iY, Yj/jY, Yk/kY, Yl/lY, Ym/mY, Yn/nY
Yp/pY, Yq/qY, Yr/rY, Ys/sY, Yt/tY, Yv/vY, Yw/wY, Yx/xY, Yy/yY, Yz/zY
Zb/bZ, Zc/cZ, Zd/dZ, Zf/fZ, Zg/gZ, Zh/hZ, Zk/kZ, Zl/lZ, Zm/mZ, Zn/nZ
Zp/pZ, Zq/qZ, Zr/rZ, Zs/sZ, Zt/tZ, Zv/vZ, Zw/wZ, Zx/xZ, Zy/yZ, Zz/zZ
ac/ca, af/fa, al/la, ao/oa, aq/qa, av/va, ax/xa, bc/cb, bd/db, bf/fb
bg/gb, bh/hb, bj/jb, bk/kb, bl/lb, bm/mb, bn/nb, bp/pb, bq/qb, bs/sb
bt/tb, bv/vb, bw/wb, bx/xb, by/yb, bz/zb, cd/dc, ce/ec, cf/fc, cg/gc
ci/ic, cj/jc, ck/kc, cl/lc, cm/mc, cn/nc, cp/pc, cq/qc, ct/tc, cu/uc
cv/vc, cw/wc, cx/xc, cy/yc, cz/zc, df/fd, dg/gd, dj/jd, dm/md, dn/nd
dp/pd, dq/qd, dt/td, dv/vd, dw/wd, dx/xd, dy/yd, ef/fe, el/le, eq/qe
eu/ue, ev/ve, ex/xe, ey/ye, fh/hf, fj/jf, fk/kf, fm/mf, fn/nf, fo/of
fp/pf, fq/qf, fr/rf, fs/sf, fu/uf, fv/vf, fw/wf, fx/xf, fy/yf, fz/zf
gh/hg, gj/jg, gk/kg, gl/lg, gm/mg, gp/pg, gq/qg, gr/rg, gs/sg, gt/tg
gv/vg, gw/wg, gx/xg, gy/yg, gz/zg, hj/jh, hl/lh, hm/mh, hn/nh, hp/ph
hq/qh, hr/rh, hw/wh, hx/xh, hy/yh, il/li, iq/qi, iv/vi, ix/xi, jm/mj
jo/oj, jp/pj, jq/qj, jr/rj, js/sj, jv/vj, jw/wj, jx/xj, jy/yj, jz/zj
kl/lk, km/mk, kn/nk, kp/pk, kq/qk, kr/rk, ks/sk, kv/vk, kw/wk, kx/xk
ky/yk, kz/zk, lm/ml, ln/nl, lo/ol, lp/pl, lq/ql, lr/rl, ls/sl, lt/tl
lw/wl, lx/xl, ly/yl, lz/zl, mn/nm, mp/pm, mq/qm, mr/rm, ms/sm, mv/vm
mw/wm, mx/xm, my/ym, mz/zm, np/pn, nq/qn, nr/rn, nt/tn, nv/vn, nw/wn
nx/xn, ny/yn, nz/zn, oq/qo, ov/vo, ox/xo, pq/qp, pr/rp, ps/sp, pt/tp
pv/vp, pw/wp, px/xp, py/yp, pz/zp, qr/rq, qs/sq, qt/tq, qu/uq, qv/vq
qw/wq, qx/xq, qy/yq, qz/zq, rs/sr, rt/tr, rw/wr, rx/xr, rz/zr, sv/vs
sw/ws, sx/xs, sy/ys, sz/zs, tv/vt, tw/wt, tx/xt, ty/yt, tz/zt, uw/wu
ux/xu, vw/wv, vx/xv, vy/yv, vz/zv, wx/xw, wy/yw, wz/zw, xy/yx, xz/zx
yz/zy
```
