﻿---
title: Подробнее о Markdown
last_updated: Oct 10, 2019
sidebar: mydoc_sidebar
permalink: More-about-Markdown.html
folder: publishing-doc
---

Большинство решений docs-as-code используют упрощенный синтаксис разметки, часто Markdown. Итак, давайте узнаем немного больше о Markdown. Markdown - это сокращенный синтаксис для HTML. Например, вместо тегов `ul` и `li`  используются звездочки  `*`. Вместо использования тегов `h2` используются хэши `##`. Для большинства наиболее часто используемых элементов HTML существуют аналоги тегов Markdown, но не для всех.

<a name="sample"></a>
## Пример синтаксиса Markdown

Чтобы понять синтаксис Markdown, посмотрите на этот пример:

    ## Заголовок 2 уровня

    Ненумерованный список:

    - fireStructuredText item
    - second item
    - third item

    Нумерованный список:

    1. Click this **button**.
    2. Go to [this site](http://www.example.com).
    3. See this image:

    Рисунок:

    ![My alt tag](myimagefile.png)

Markdown должен быть простым, поэтому для каждого HTML-тега нет всеобъемлющего тэга Markdown. Например, если нужны элементы `figure` и `figcaption`, нужно использовать HTML. Что хорошо в Markdown, так это то, что если в синтаксисе Markdown отсутствует нужный тег, можно просто использовать тег HTML.

<a name="development"></a>
## Самостоятельное развитие против комитета

Джон Грубер, блогер, создал Markdown как способ упрощения HTML (см. [документацию по Markdown](https://daringfireball.net/projects/markdown/)). Другие приняли его, и многие внесли изменения, чтобы включить необходимый им синтаксис. В результате существуют различные «варианты» Markdown, такие как [Github-flavored Markdown](https://help.github.com/en/categories/writing-on-github), [Multimarkdown](https://fletcherpenney.net/multimarkdown/), [kramdown](https://kramdown.gettalong.org/), [CommonMark](https://commonmark.org/) и другие.

Напротив, DITA - это основанная на комитетах архитектура XML, созданная комитетом. Существует не так много разных вариантов DITA, основанных на том, как люди настраивали теги. Существует официальная спецификация DITA, согласованная комитетом DITA OASIS. У Markdown нет такого комитета, поэтому он развивается сам по себе, так, как люди решают его реализовать.

<a name="why-love"></a>
## Почему разработчики любят Markdown

Во многих инструментах разработки (в частности, [генераторах статичных сайтов](Static-site-generators.html) ), которые используются для публикации документации, поддерживается Markdown. Например, Github использует Markdown. При загрузке файлов, содержащих Markdown с расширением md, Github автоматически отобразит Markdown в HTML.

Markdown привлекателен (особенно для разработчиков) по разным причинам:

- можно работать в текстовых форматах, используя любимый редактор кода;
- можно обрабатывать файлы Markdown теми же рабочими процессами и маршрутизацией, что и код;
- Markdown легко изучить, поэтому можно сосредоточиться на содержании, а не на форматировании.

<a name="semantic"></a>
### Почему не использовать более богатую семантически разметку

Почему бы не использовать более семантически богатый язык разметки, такой как DITA? С DITA можно работать в текстовом редакторе, хотя читать код со всем синтаксисом тегов XML намного сложнее.

Например, посмотрим на теги, требуемые DITA для простой инструкции о печати страницы:

    <task id="task_mhs_zjk_pp">
        <title>Printing a page</title>
        <taskbody>
    <steps>
            <stepsection>To print a page:</stepsection>
        <step>
            <cmd>Go to <menucascade>
                <uicontrol>File</uicontrol><uicontrol>Print</uicontrol>
            </menucascade></cmd>
        </step>
        <step>
            <cmd>Click the <uicontrol>Print</uicontrol> button.</cmd>
        </step>
    </steps>
        </taskbody>
    </task>

И сравним с синтаксисом в Markdown:

    ## Print a page

    1. Go to **File > Print**.
    2. Click the **Print** button.

Об этой разнице написано в статье [Why developers will never adopt DITA](https://idratherbewriting.com/2014/09/30/why-developers-will-never-adopt-dita/). Конечно, в примере XML содержится гораздо больше семантической информации, которой нет в версии Markdown. Так что, теоретически, эти два контента не имеют одинакового содержания, даже если результат один и тот же. Однако, если не использовать дополнительную семантическую информацию, включенную в DITA, результат будет тем же.

Можно читать XML и привыкнуть к нему. Большинство людей, которые пишут на XML, используют специализированные редакторы XML (такие как OxygenXML), которые делают необработанный текст более читабельным. Работая некоторое время с XML, появляется привычка работать со всеми тегами.

Но если отправить разработчику файл XML, вероятно, ему не будут знаком все теги, или схема вложенности тегов. Разработчики склонны иметь аллергию на XML по крайней мере по следующим причинам:

- большинство разработчиков обычно не хотят тратить энергию на изучение формата документации XML. Их мозг уже болит от всех программ, которые они должны выяснить, поэтому, работая с документацией они не захотят увеличивать эту техническую нагрузку;
- большинство разработчиков в первую очередь не хотят тратить много времени на документацию, поэтому, чем проще формат, тем лучше.

Напротив, Markdown легко читать и работать с ним в текстовом редакторе.

{% include tip.html content="Большинство текстовых редакторов (например, Sublime Text или Webstorm или Atom) имеют плагины / расширения Markdown, которые создают подсветку синтаксиса на основе тегов Markdown." %}

Еще одно преимущество Markdown (в отличие от бинарных инструментов, таких как Word или Framemaker) заключается в том, что можно упаковать файлы Markdown и запустить их в том же Флоу, что и код. Можно запустить diff, чтобы увидеть, что изменилось, вставить комментарии и использовать тот же элемент управления, что и для обычных файлов кода. Работа с файлами Markdown естественна для разработчиков. (Конечно, можно работать с DITA в виде простых текстовых файлов и управлять содержимым в репозиториях Git.)

<a name="drawbacks"></a>
## Недостатки Markdown

Есть у Markdown и несколько недостатков:

- **ограничен тегами HTML:** в значительной степени ограничены тегами HTML. В тех случаях, когда Markdown не предлагает ярлык для HTML, просто используется HTML напрямую. Сторонники XML любят подчеркивать, как XML предлагает семантические теги (и избегает солянку div, которой может стать HTML). Тем не менее, HTML5 предлагает много семантических тегов (таких как `section`, `header`, `footer` и т.д.), И даже для тех случаев, когда нет уникальных элементов HTML, все структуры XML, которые преобразуются в HTML, становятся связанными пределами HTML.
- **Нестандартный:** поскольку Markdown не является стандартным, может быть чем-то вроде игры в догадки относительно того, что поддерживается процессором Markdown, который можно использовать. В общем и целом, Github-flavored Markdown является наиболее распространенным диалектом, так как позволяет добавлять синтаксические классы в примеры кода и использовать таблицы. Какую бы систему ни использовать, если она использует Markdown, нужно убедиться, какой тип Markdown она поддерживает.
- **чувствительность к пробелам:** Markdown чувствителен к пробелам, что иногда может расстраивать. Если есть пробелы, которых не должно быть, они могут вызвать проблемы с форматированием. Например, если не добавить пробелы в список, то список перезапустится. Поэтому легко ошибаться при форматировании в Markdown . Документы обычно по-прежнему отображают поврежденный Markdown как действительный при преобразовании его в HTML, что затрудняет выявление ошибок форматирования.

<a name="complexity"></a>
## Сложности Markdown

Если нужно больше возможностей, чем предлагают Markdown или HTML, многие инструменты используют другие языки шаблонов, такие как [Liquid](https://help.shopify.com/en/themes/liquid/basics) или [CoffeeScript](https://coffeescript.org/). Такие языки обработки (например, облегченный JavaScript) заполняют пробелы в Markdown и предоставляют возможность создавать включения, условные атрибуты, условный текст и многое другое.

Например, используя Jekyll, мы получаем доступ ко многим расширенным скриптовым функциям. Можно использовать переменные для циклов, сортировки и множества других функций. Для понимания того, как получить функциональность DITA для Jekyll, см. [Jekyll versus DITA](https://idratherbewriting.com/2015/03/23/new-series-jekyll-versus-dita/). Там затрагивается следующее:

- [переменные и условная обработка](https://idratherbewriting.com/2015/03/26/variables-and-conditional-processing-jekyll-versus-dita/);
- [переиспользование частей содержимого (conref)](https://idratherbewriting.com/2015/04/01/creating-re-usable-chunks-conref-in-jekyll-versus-dita/);
- [составление оглавления](https://idratherbewriting.com/2015/04/02/building-a-table-of-contents-with-dita-versus-jekyll/);
- [просмотр содержимого](https://idratherbewriting.com/2015/04/13/reviewing-markdown-content/);
- [создание PDF-файлов](https://idratherbewriting.com/2015/04/14/producing-pdfs-in-dita-versus-jekyll/);
- [создание ссылок](https://idratherbewriting.com/2015/04/06/creating-links-in-dita-versus-jekyll/).

<a name="activity"></a>
## 👨‍💻 Практическое занятие: работа в Markdown

Чтобы понять, как работает Markdown, давайте немного потренируемся с Markdown.

1. Переходим в онлайн редактор Markdown (например [Dillinger.io](https://dillinger.io/))
2. Создаем следующее:
    - нумерованный список;
    - ненумерованный список;
    - текст, выделенный шрифтом **Bold**;
    - пример кода;
    - заголовок 2 уровня;
    - кодированный текст.
3. При желании можно скопировать содержимое Markdown из файла [surfreportendpoint.md](https://github.com/Starkovden/Starkovden.github.io/blob/master/images/surfreportendpoint.md) и посмотреть различные теги Markdown.

Markdown обрабатывает большую часть обычно используемого синтаксиса, но для таблиц лучше использовать синтаксис HTML. Синтаксис HTML дает больше контроля над шириной столбцов, что может быть важно при настройке таблиц, особенно если таблицы имеют теги кода.

<a name="static-sites"></a>
## Markdown и генераторы статичных сайтов

Генераторы статичных сайтов используют специфичный синтаксис Markdown. В Jekyll по умолчанию это [kramdown](https://kramdown.gettalong.org/).

У kramdown больше возможностей, чем у базового Markdown. Например, в kramdown можно добавить класс к такому элементу:

    {: .note}
    This is a note.

В HTML этот же класс будет выглядеть так:

    <p class="note">This is a note.</p>

kramdown также позволяет использовать Markdown внутри HTML-элементов (что обычно не допускается). При добавлении атрибута `markdown="span"` или `markdown="block"` к элементу HTML содержимое Markdown будет обрабатываться либо как `span`, либо как блочный элемент `div`. Например:

    <p markdown="span">This is a **bold** tag</p>.

Обычно теги Markdown `**` не обрабатываются, поскольку они отображаются внутри тегов HTML. Но через атрибут `markdown="span"` kramdown будет обрабатывать Markdown. Содержимое обрабатывается как `span`, что означает отсутствие разрывов строк. Если надо обработать содержимое как div, можно поступить так:

    <ul markdown="span">
    first section

    second section
    </ul>

Содержимое будет обрабатываться в виде двух абзацев, а не одной строки. См. [Синтаксис](https://kramdown.gettalong.org/syntax.html) в документации kramdown для более подробной информации.

<a name="RST"></a>
## Как насчет reStructuredText и Asciidoc?

Еще как варианты могут быть интересны [reStructured Text (rST)](http://docutils.sourceforge.net/reStructuredText.html) или [Asciidoc](http://asciidoc.org/). reStructuredText похож на Markdown тем, что предлагает легкий вики-подобный синтаксис для более сложного HTML. Однако reStructuredText более богат семантически, чем Markdown (например, есть синтаксис для классов Python, заметок или предупреждений).


reStructuredText расширяется, соответствует стандарту ( не иметь много вариантов) и дает больше возможностей, специфичных для написания технической документации, такой как перекрестные ссылки. См. [ReStructuredText против Markdown для документации](https://eli.thegreenplace.net/2017/restructuredtext-vs-markdown-for-technical-documentation/) для более подробного сравнения. При использовании [Sphinx](http://www.sphinx-doc.org/en/stable/), стоит использовать reStructuredText.

[Asciidoc](http://asciidoc.org/) также обладает семантическим богатством и стандартизацией. Asciidoc предоставляет синтаксис для таблиц, сносок, перекрестных ссылок, видео и многого другого. Фактически, Asciidoc «изначально разрабатывался как текстовая альтернатива XML-схеме DocBook» ([asciidoc-vs-markdown.adoc](https://asciidoctor.org/docs/asciidoc-vs-markdown/)). Как и в случае с reStructuredText, Asciidoc не имеет разнообразия вариаций, как  Markdown, поэтому обрабатывается он более консистентно. [Asciidoctor](https://asciidoctor.org/) - это генератор статичных сайтов, который использует Asciidoc в качестве синтаксиса. Оба reStructuredText и Asciidoc (и другие синтаксисы) [поддерживаются на GitHub](https://github.com/github/markup#markups).

<a name="objections"></a>
## Возражения против markdown

Некоторые люди возражают против markdown из-за несоответствия между его вариациями. Учитывая, что существует множество разновидностей Markdown ([CommonMark](https://commonmark.org/), [kramdown](https://kramdown.gettalong.org/), [оригинальный Markdown Грубера](https://daringfireball.net/projects/markdown/syntax), [markdown для Gitub](https://github.github.com/gfm/), [Multimarkdown](https://fletcherpenney.net/multimarkdown/) и т. Д.), трудно создать единый инструмент для последовательной обработки Markdown.

Эрик Холшер, соучредитель [Write the Docs](http://www.writethedocs.org/) и платформы [Read the Docs](https://readthedocs.org/), утверждает, что Markdown создает блокировку для конкретного инструмента. Он говорит, что многие авторы считают Markdown хорошим выбором, потому что многие инструменты поддерживают его, и они думают, что всегда смогут перенести свой контент Markdown на другой инструмент. Но. разновидности Markdown делают такую миграцию проблематичной. Эрик пишет:

{% include callout.html content="Взрыв вариантов и отсутствие семантического значения приводит к блокировке. После создания большого набора документов Markdown их довольно сложно перенести на другой инструмент, даже если этот инструмент заявляет о поддержке Markdown! У вас есть большой набор пользовательских классов HTML и странных расширений, которые не будут работать нигде, кроме текущего набора инструментов и дизайна.
Вы также не можете легко перенести Markdown на другой язык разметки (Asciidoc или reStructuredText), потому что Pandoc и другие инструменты преобразования не будут поддерживать расширения вашего аромата. ([Why You Shouldn’t Use Markdown for Documentation](http://www.ericholscher.com/blog/2016/mar/15/dont-use-markdown-for-technical-docs/))" type="info" %} 

Его аргумент наверняка имеет смысл. Возможно, и получится переключаться между вариациями Markdown, используя такой инструмент, как [Pandoc](https://pandoc.org/), или преобразовывать Markdown в HTML, а затем преобразовывать HTML в другую версию Markdown. Переключение инструментов, скорее всего, приведет к головной боли при обновлении синтаксиса в контенте.

Вот пример. В течение многих лет Jekyll  использовал [redcarpet](https://github.com/vmg/redcarpet) и [pygments](http://pygments.org/) для обработки Markdown и применения подсветки синтаксиса кода. Однако, чтобы увеличить поддержку Windows, Jekyll перешел на [kramdown](https://kramdown.gettalong.org/) и [rouge](https://github.com/jneen/rouge) в версии 3.0. Предполагалось, что это будет простой серверный коммутатор, который не потребует никакой корректировки существующего Markdown. Тем не менее, обнаружено, что kramdown предъявляет различные требования к интервалу, что разрушает большую часть контента, особенно списки. Проблема описана здесь: [Updating from redcarpet and Pygments to Kramdown and Rouge on Github Pages](https://idratherbewriting.com/2016/02/21/bug-with-kramdown-and-rouge-with-github-pages/).

Несмотря на различия в Markdown, некоторый не хотят  переходить на семантически более упрощенный синтаксис, потому что поддержка Markdown в целом, и GitHub-flavored Markdown, более распространена, чем поддержка reStructuredText или Asciidoc. kramdown в значительной степени совместим с GitHub-flavored Markdown, поэтому на него перейти будет не так сложно.

Кроме того, разработчики, как правило, знакомы с Markdown, но не с reStructuredText или Asciidoc. Работая с разработчиками, можно столкнуться с большим сопротивлением, заставляя их писать в reStructuredText или Asciidoc. Простые вещи имеет тенденцию побеждать, и у Markdown есть большой плюс на арене облегченного синтаксиса. Возможно, лет через 10 reStructuredText и Asciidoc будут вытеснены так же, как [RAML](RAML-tutorial.html) и [API Blueprint](API-Blueprint-tutorial.html) были вытеснены [спецификацией OpenAPI](introduction-openapi-and-swagger.html)

Кроме того, спецификация OpenAPI позволяет использовать [CommonMark Markdown](https://commonmark.org/) в элементах `description` , что может сделать Markdown лучшим выбором для документации API. Миграция (если она потребуется в какой-то момент) может быть не такой болезненной при использовании элементов Markdown.

В целом, дебаты о Markdown, reStructuredText и Asciidoc довольно жаркие.  Можно найти много аргументов «за» и «против» для каждого упрощенного синтаксиса, также как и дебаты между XML и упрощенным синтаксисом.

Одной из проблем облегченного синтаксиса является его несовместимость с более крупными системами управления контентом. Компонентные системы управления контентом (CCMS) обычно требуют более структурированного контента, такого как DITA. Комитет DITA недавно одобрил [Lightweight DITA](http://docs.oasis-open.org/dita/LwDITA/v1.0/cnprd01/LwDITA-v1.0-cnprd01.html), который позволяет использовать GitHub-flavored Markdown и HTML в проектах DITA (при условии, что поставщики инструментов поддерживают это). Таким образом, мы можем надеяться на сближение инструментов XML и Markdown в ближайшие годы. Для получения более подробной информации об Lightweight DITA (LwDITA), можно посмотреть [интервью с Карлосом Эвией](https://idratherbewriting.com/2018/07/23/adventures-of-techie-academic-conversation-with-carlos-evia/). Карлос является сопредседателем комитета OASIS для LwDITA.

[🔙](Doc-as-code-tools.html)

[Go next ➡](Version-control-system.html)
