#include <stdio.h>
#include <windows.h>
#include <dim_common.h>
#include <dis.h>

#include "dim_queue.c"

queueHead *discmndQueue = NULL; // Queue for commands.

int disinfoid[3]={0,0,0};
int discmndid[3]={0,0,0};

long loopcount=0;
unsigned long tickcount=0;

unsigned long tick;
unsigned long lasttick1=0;
unsigned long lasttick2=0;

void dis_handler(dim_long *tag, int **address, int *size)
{
    switch (*tag)
    {
        case 1: *address = &loopcount;
                *size = sizeof(loopcount);
                break;
        case 2: *address = &tickcount;
                *size = sizeof(tickcount);
                break;
        default:
                break;
    };
};

void execute_cmnd(dim_long *tag, char *buffer, int *size)
{
    if((*tag != 0) && (buffer != NULL ) && (size > 0)){
        queue_push(discmndQueue,*tag,buffer,*size);
    };
};

main()
{
    queue_tester();
    discmndQueue = queue_init();
    disinfoid[1] = dis_add_service("LOOPCOUNT", "L:1", 0, 0,  dis_handler, 1);
    disinfoid[2] = dis_add_service("TICKCOUNT", "L:1", 0, 0,  dis_handler, 2);
    dis_add_cmnd("SERV_CMND1", "C", execute_cmnd, 1);
    dis_add_cmnd("SERV_CMND2", "C", execute_cmnd, 2);
    dis_start_serving("DEMO_TEST");
    //
    // Main polling loop
    //
    while(1)
    {
        tick=GetTickCount();
        if (tick-lasttick1>=1000){
         loopcount++;
         dis_update_service(disinfoid[1]);
         lasttick1=tick;
        };
        if (tick-lasttick2>=100){
         tickcount=tick;
         dis_update_service(disinfoid[2]);
         lasttick2=tick;
        };
        //
        // Handle queue
        //
        while(queue_pop(discmndQueue)){
         queueNode *node = queue_node(discmndQueue);
         printf("Command[%d] received[%d] %s\n",node->tag,node->size,node->data.C);
        };
        //
        // Yield  CPU
        //
        Sleep(1);
    };
};
