 {
 ****************************************************************************
 CRW32 project
 Copyright (C) by Kuryakin Alexey, Sarov, Russia, 2001, <kouriakine@mail.ru>
 Real Time Clock procedures.
 Modifications:
 20010705 - Creation (uses CRW16) & test
 20010707 - test (Ok), GetDateStr/GetTimeStr overload
 20011009 - TIntervalTimer (uses CRW16) & test (Ok)
 20011028 - uses wasborn,mustdie
 20011031 - TLatch
 20030517 - MkSecNow
 20041116 - msecnow,intmsecnow modified
 20041130 - msecnow makes faster; msecnowerrors
 20051225 - msecnow modified,FileTimeNow,NativeTimeNow,LocalMeanFileTimeBiasNow,
            GMTFileTimeToLMT,LMTFileTimeToGMT,FileTimeToMsec,MsecToFileTime etc.
 20060906 - Get/SetClockResolution
 20061212 - RDTSC
 20170302 - JavaTimeBase, UnixTimeBase, GetMidnightByTimeMs
 20200401 - GetTickCount64,GetTickCount64_Fallback,UseKernelGetTickCount64
 20200402 - Timer_Check_RTC_Monotonicity,Allow_Check_RTC_Monotonicity
 20221121 - Time units functions: MsToUnixTime,UnixTimeToMs,..,OleTimeToMs.
 20221224 - StrTimeFmt.
 ****************************************************************************
 }

 {
 ****************************************************************************
      ()  CRW 
  ,     (Xmas),    
     01/01/0001-00:00:00:000.  
   ,      
  (  MSecNow   0.2   K7-650).
       0001   9999 .
    ,     
    t1,t2     t2-t1.

       
 ,     TSystemTime,    
 ,           
   ( NativeTimeNow   30   K7-650).
          .

 ,         
   Windows.GetTickCount,    
 0.05   K7-650,     .   ,  
    GetTickCount     ,
       .
 *****************************************************************************
 }

unit _rtc; { real time clock }

{$I _sysdef}

interface

uses
 sysutils, windows, classes, _alloc, _fpu, _fifo, _str;

 {
 *******************************************************************************
   -  ,     - 
  ,       
 ,  ,  , .
 *******************************************************************************
  :
 ------------------
 1)    ,    1193180 Hz,
      ,    ,
       ..
     -   ,  .
     -   (    ),
     (      
    10 ).
 2)  CMOS,     ,    
    (  ).
     - .
     -    ,  , .
 3)   -    ,    .
 *******************************************************************************
   Windows      .
 1)GetTickCount            -   ,    .
 2)GetSystemTimeAsFileTime -    ()    CMOS ().
 3)QueryPerformanceCounter -    ,    .
    -    .
 *******************************************************************************
   :
 ----------------------------
 1) GMT - Greenwich Mean Time -      
    (     ),
         .
 2) LMT - Local Mean Time -     ,
      GMT  ,    ,
         , \   ..
 *******************************************************************************
  :
 ----------------
 1) ms - ,  msecnow.
 2) mks - ,  mksecnow.
 3) 100-ns -    100 ,  FileTimeNow.
 4)    - ,,,,,,,
      NativeTimeNow.
 *******************************************************************************
   :
 -----------------------
 1)    (Xmas) 0001.01.01-00:00:000,  msecnow.
 2)  1601.01.01-00:00,  FileTimeNow.
 3)   Windows,  GetTickCount.
 4)    ,  mksecnow.
 *******************************************************************************
   .
 -----------------------------
    ,   , 
  \ ,   FileTimeNow  ,
          .
     DAQ       
 Windows.GetTickCount  Windows.QueryPerformanceCouter,   
    (    ).
        GetTickCount   DAQ-,
      - SYS, .  rtc_SYS,rtc_DAQ.
 *******************************************************************************
  :
 -----------------
 FileTimeNow                   100-ns
                             1601.01.01-00:00.
                           Mode   rtc_LMT, rtc_GMT,
                               LMT 
                            GMT .
 NativeTimeNow                  
                          TSystemTime -   .
                           Mode   rtc_LMT, rtc_GMT,
                               LMT 
                            GMT .
 LocalMeanFileTimeBiasNow     
                          (   )  LMT 
                              (GMT)  100-ns
                          ,    
                          LocalTimeZoneBiasNow=FileTimeNow(LMT)-FileTimeNow(GMT)
                              ,   
                           ,  /   ..
    :
 ----------------------------------------
              ,ns ,ms          
  GetTickCount       25       10/15    ms       Windows          GetTickCount
  FileTimeNow(GMT)   41       10/15    100-ns  1601.01.01-00:00   GMT           GetSystemTimeAsFileTime
  FileTimeNow(LMT)   59       10/15    100-ns  1601.01.01-00:00   LMT           GetSystemTimeAsFileTime
  mSecNow(SYS+LMT)   97       10/15    ms      0001.01.01-00:00   LMT           GetSystemTimeAsFileTime
  mSecNow(SYS+GMT)   97       10/15    ms      0001.01.01-00:00   GMT,          GetSystemTimeAsFileTime
  mSecNow(DAQ+LMT)   194      10/15    ms      0001.01.01-00:00   LMT           GetTickCount
  mSecNow(DAQ+GMT)   194      10/15    ms      0001.01.01-00:00   GMT           GetTickCount
  NativeTimeNow(GMT) 452      10/15    . 0001.01.01-00:00   GMT           GetSystemTimeAsFileTime
  NativeTimeNow(LMT) 466      10/15    . 0001.01.01-00:00   LMT           GetSystemTimeAsFileTime
  mkSecNow           1610           mks              QueryPerformanceCounter
 *******************************************************************************
 :
 -----------
 1)    P4-2000.
 2)  ,  mksecnow,    ,
     Windows,   10 ms (single processor)
    15 ms (multiprocessor).
 3)msecnow, mksecnow -  -  ,
      ,       
       .
   GetTickCount -  -   ,  
    49.7    (   ).
   QueryPerformanceCounter -  -  
    ,     .
      - ,    
      ,      
   , \   ..
 *******************************************************************************
 }

const
 rtc_DAQ     = 0;               // DAQ applications, GetTickCount - based timing
 rtc_SYS     = 1;               // SYS applications, FileTimeNow  - based timing
 rtc_LMT     = 0;               // LMT - based timing
 rtc_GMT     = 2;               // GMT - based timing
 rtc_LMT_DAQ = rtc_LMT+rtc_DAQ; // LMT timing for DAQ applications
 rtc_GMT_DAQ = rtc_GMT+rtc_DAQ; // GMT timing for DAQ applications
 rtc_LMT_SYS = rtc_LMT+rtc_SYS; // LMT timing for SYS applications
 rtc_GMT_SYS = rtc_GMT+rtc_SYS; // GMT timing for SYS applications
 rtc_DEFAULT = rtc_LMT_DAQ;     // Default for msecnow

function  FileTimeNow(Mode:Integer):Int64;
function  NativeTimeNow(Mode:Integer=rtc_DEFAULT):TSystemTime;
function  LocalMeanFileTimeBiasNow(GMT:Int64):Int64;

 {
  :
   FileTimeNow(GMT)  FileTimeNow(LMT)  
   mSecNow(LMT)  FileTimeNow(GMT)  
 }
function  GMTFileTimeToLMT(GMT:Int64):Int64;
function  LMTFileTimeToGMT(LMT:Int64):Int64;
function  FileTimeToMsec(FileTime:Int64):Double;
function  MsecToFileTime(mSecTime:Double):Int64;

 {
 *******************************************************************************
  RDTSC (ReaD from Time Stamp Counter)   64- 
    TSC (Time Stamp Counter).    .
      OF,31 -   "DW $310F"   "DB $0F,$31".
 RDTSC     32-  EDX:.  
  ,    .
 *******************************************************************************
     TSC (Time Stamp Counter)   CPU,
        .
       x86   Pentium.
      ( RESET)    
   .      
     (2^64/(1e9*3600*24*365)=584   1 GHz CPU).
        HLT,    
    STPCLK# ( ).
     RDTSC.    
 CR4.TSD (Time Stamp Disable      )
     (   CPL=0).
 *  CR4.TSD=0,   RDTSC     .
 *  CR4.TSD=1,   RDTSC    0  .
    TSC       MSR ( CPL=0),
        32 ,   
    .
 *******************************************************************************
   TSC :
 1)  WinNt -  IsProcessorFeaturePresent(PF_RDTSC_INSTRUCTION_AVAILABLE).
 2)   CPUID (=1).       4  EDX
     1,    RDTSC. ,,  
       CPUID.
 *******************************************************************************
 RDTSC
     RDTSC      , 
          .
 ReadTimeStampCounter
      RDTSC.     TSC,
   0,   RDTSC .
 EastimateCpuFrequencyMHz
        MHz,    ,  
  ""  TimeOut.     TimeOut.
      ReadTimeStampCounter  mksecnow.  
     ,      
    .      
    , .    RDTSC.
 *******************************************************************************
    RDTSC:
 1)   RDTSC     .
     ,       
   ,         .
       RDTSC      
   ()    .
 1)RDTSC        ,  
      .     
     ..
      RDTSC   
  1)    ,   
        .
  2)      ,   
   .
 *******************************************************************************
   ()      (Pentium-D-3GHz):
  call                 - 10
  GetTickCount         - 15
  ReadTimeStampCounter - 105
  msecnow              - 220
  mksecnow             - 1100
 *******************************************************************************
 }
function RDTSC:Int64; assembler; register;
function ReadTimeStampCounter:Int64; register;
function EastimateCpuFrequencyMHz(TimeOut:Cardinal):Double;

 {
   ntdll.dll  Native Timer API.
   >=0    <0   .
       Windows,    
  STATUS_UNSUCCESSFUL=$C0000001.  NtSetTimerResolution,
 NtQueryTimerResolution  ""    
 timeBeginPeriod,timeEndPeriod etc,    
 (..    Win32 API),    .

     (http://sysinternals.com):

 Inside Windows NT High Resolution Timers
 Copyright  1997 Mark Russinovich
 Last Updated: Last updated July 9, 1997
 Note: The information presented here is the result of my own study.
 No source code was used.

 Introduction
 High resolution timers are desirable in a wide variety of different applications.
 For example, the most common use of such timers in Windows is by multimedia applications
 that are producing sound or audio that require precise control. MIDI is a perfect example
 because MIDI sequencers must maintain the pace of MIDI events with 1 millisecond accuracy.
 This article describes how high resolution timers are implemented in NT and documents
 NtSetTimerResolution and NtQueryTimerResolution, the NT kernel functions that manipulate
 and return information about the system clock. Unfortunately, NtSetTimerResolution and
 NtQueryTimerResolution are not exported by the NT kernel, so they are not available
 to kernel-mode device drivers.

 The Timer API
 Windows NT bases all of its timer support off of one system clock interrupt,
 which by default runs at a 10 millisecond granularity. This is therefore the resolution
 of standard Windows timers. When a multimedia application uses the timeBeginPeriod mutlimedia API,
 which is exported by the Windows NT dynamic link library WINMM.DLL, the call is redirected
 into the Windows NT kernel-mode function NtSetTimerResolution, which is exported by the native
 Windows NT library NTDLL.DLL.

 NtSetTimerResolution and NtQueryTimerResolution are defined as follows.
 All times are specifified in hundreds of nanoseconds.

 NTSTATUS NtSetTimerResolution (
    IN ULONG RequestedResolution,
    IN BOOLEAN Set,
    OUT PULONG ActualResolution);
 Parameters
 RequestedResolution
 The desired timer resolution. Must be within the legal range of system timer values
 supported by NT. On standard x86 systems this is 1-10 milliseconds. Values that are within
 the acceptable range are rounded to the next highest millisecond boundary by the standard x86 HAL.
 This parameter is ignored if the Set parameter is FALSE.
 Set
 This is TRUE if a new timer resolution is being requested, and FALSE if the application
 is indicating it no longer needs a previously implemented resolution.
 ActualResolution
 The timer resolution in effect after the call is returned in this parameter.
 Comments
 NtSetTimerResolution returns STATUS_SUCCESS=0 if the resolution requested is within
 the valid range of timer values. If Set is FALSE, the caller must have made a previous
 call to NtSetTimerResolution or STATUS_TIMER_RESOLUTION_NOT_SET=$C0000245 is returned.

 NTSTATUS NtQueryTimerResolution (
    OUT PULONG MinimumResolution,
    OUT PULONG Maximum Resolution,
    OUT PULONG ActualResolution);
 Parameters
 MinimumResolution
 The minimum timer resolution. On standard x86 systems this is 0x2625A, which is about 10 milliseconds
 MaximumResolution
 The maximum timer resolution. On standard x86 systems this is 0x2710, which is about 1 millisecond.
 ActualResolution
 This is the current resolution of the system clock.

 Implementation Details
 NtSetTimerResolution can be called to set timer resolutions by more than on application.
 To support a subsequent process setting a timer resolution without violating the resolution
 assumptions of a previous caller, NtSetTimerResolution never lowers the timer's resolution,
 only raises it. For example, if a process sets the resolution to 5 milliseconds, subequent
 calls to set the resolution to between 5 and 10 millseconds will return a status code indicating
 success, but the timer will be left at 5 milliseconds.
 NtSetTimerResolution also keeps track of whether a process has set the timer resolution in its
 process control block, so that when a call is made with Set equal to FALSE it can verify that
 the caller has previously requested a new resolution. Every time a new resolution is set a global
 counter is incremented, and every time it is reset the counter is decremented. When the counter
 becomes 0 on a reset call the timer is changed back to its default rate, otherwise no action is taken.
 Again, this preserves the timer resolution assumptions of all the applications that have requested
 high resolution timers by guaranteeing that the resolution will be at least as good as what they specified.
 }
function NtSetTimerResolution(RequestedResolution:DWORD; SetResolution:BOOL;
    var ActualResolution:DWORD) : LongInt stdcall;
function NtQueryTimerResolution(var MinimumResolution, MaximumResolution,
    ActualResolution:DWORD) : LongInt stdcall;

 {
 GetClockResolution
       ,   
       .   
    100 ns. , ,     ms 
   GetClockResolution/10000.     0.
       NT (   Win9x).
  ,  Win9x ...
 GetClockResolution(cr_StdRes):
        .
       GetTickCount   
      ( ).     100000=10[ms]
   Single CPU  150000=15[ms]  Multi CPU.
 GetClockResolution(cr_MinRes):
     .     
  100000=10[ms],   GetClockResolution(cr_StdRes).
 GetClockResolution(cr_MaxRes):
     .     
  10000=1[ms],      .
 GetClockResolution(cr_ActRes):
   ()    .    
     .     GetTickCount, msecnow
     GetClockResolution(cr_StdRes).
 SetClockResolution
       ,   
       .  
    100 ns.   ,   
    .     0.    ,
        ,   
  ,      .
  :
   clock:=GetClockResolution(2); //   
   SetClockResolution(+clock);   //   
   ...
   SetClockResolution(-clock);   //     
 }
const
 cr_StdRes = 0; // Standard timer resolution, uses by GetTickCount
 cr_MinRes = 1; // Maximal timer period, minimal resolution
 cr_MaxRes = 2; // Minimal timer period, maximal resolution
 cr_ActRes = 3; // Actual timer resolution

function GetClockResolution(What:Integer=cr_StdRes):LongInt;
function SetClockResolution(NewRes:LongInt):LongInt;

 {
 MSecNow    ,   
   ,    01/01/0001-00:00:00:000.
    CRW       PC.
  ,    0.2   K7-650.
 IntMSecNow -       0.1   K7-650.
  ,  ,    GetTickCount.
     ,     
  10   Win-NT/2K/XP.    
      mksecnow,  mksecnow
    ( 1.5 mks)   , 
  ,   .    
  msecnow,       mksecnow.
     :
 1) Method=0, ,   GetTickCount,    .
        msecnow(0)  ,
          Windows   ,
        ,    .
          ,      
    ,        
    ,     Windows.
 2) Method=1, ,   GetSystemTimeAsFileTime.
        msecnow(1)  ,  
        Windows.
  ,  msecnow(0)-msecnow(1),    , ,
      Windows    .
     ,    .
 MSecNowErrors -     msecnow.
   Windows Vista   GetTickCount64 -   ms  .
    GetTickCount,  GetTickCount64  ,   
  1)     2)    .
  GetTickCount64   UseKernelGetTickCount64.
 :
 1)  GetTickCount64_Fallback     ,
    ,    
  GetTickCount.      Timer_Check_RTC.
 2)  Timer_Check_RTC    ( ) 
     .    
    MSecNowErrors.
 }

const     UseKernelGetTickCount64:Boolean=true;   // Use kernel32.GetTickCount64 if one supported
function  IsKernelGetTickCount64:Boolean;         // True if kernel32.GetTickCount64 is supported and uses now
function  HasKernelGetTickCount64:Boolean;        // True if kernel32.GetTickCount64 is supported and may be used
function  GetTickCount64:Int64; stdcall;          // Uptime by kernel32.GetTickCount64 if one supported and enabled
function  GetTickCount64_Standard:Int64; stdcall; // Uptime by kernel32.GetTickCount64 if one supported and enabled
function  GetTickCount64_Relevant:Int64; stdcall; // Uptime by kernel32.GetTickCount64 if one supported (since Vista)
function  GetTickCount64_Fallback:Int64; stdcall; // Uptime by kernel32.GetTickCount - fallback version for obsolete systems
function  IntMSecNow(Method:Integer=rtc_DEFAULT):Int64;
function  MSecNow(Method:Integer=rtc_DEFAULT):Double;
function  MSecNowErrors:DWORD;
procedure MSecNowErrorFound;
procedure MSecNowErrorClear;
procedure Timer_Check_RTC_Monotonicity;
const     Allow_Check_RTC_Monotonicity:Boolean=true;

 ////////////////////////////////////////////////////////////////////
 // program Test_RTC; {$APPTYPE CONSOLE} {$I _sysdef}
 // uses ShareMem,SysUtils,Windows,_alloc,_str,_rtc;
 // begin
 //  Writeln(Benchmark_RTC(1000*1000*100,true));
 //  Writeln(Benchmark_RTC(1000*1000*100,false));
 // end.
 ////////////////////////////////////////////////////////////////////
 // =======================================================
 // Benchmark_RTC() - time functions benchmark measurement.
 // =======================================================
 // Test for CPU: Intel(R) Core(TM) i7-4700MQ CPU @ 2.40GHz
 // =======================================================
 // Function \ OS > WinXPx32  W10LTSCx32  W10PROx32   units
 // =======================================================
 // Benchmark_RTC(100000000,1) => UseKernelGetTickCount64=1
 // GetTickCount       2.030       4.060      4.220 ns/call
 // GetTickCount64    20.620       6.410      6.410 ns/call
 // IntMSecNow        21.250       7.970      7.970 ns/call
 // MSecNow           29.070      14.690     15.000 ns/call
 // Benchmark_RTC(100000000,0) => UseKernelGetTickCount64=0
 // GetTickCount       2.030       4.070      4.220 ns/call
 // GetTickCount64    20.630      23.900     24.530 ns/call
 // IntMSecNow        21.090      25.780     26.720 ns/call
 // MSecNow           29.220      33.750     34.680 ns/call
 ////////////////////////////////////////////////////////////////////
function  Benchmark_RTC(n:DWORD=1000*1000*100; Kern:Boolean=true):String;

 {
 MkSecNow      ,   
 . ,    msecnow,    ,
     Double     
    2^53 ,   2^53/356/24/60/60/1000000=285.6 ,
     .     
       ,   
    .     
   ,     msecnow
     mksecnow    ,   
       10 , - ,
       Double,   CRW-DAQ
    .
  msecnow    10  ( NT/2K/XP), 
  mksecnow   .     
 msecnow   0.2 ,   mksecnow   1.5 ,
   mksecnow   .
    CRW       PC.
  .      , 
      (  PC  ).
        .
 }
function MkSecNow:Extended;

 {
 AssignNativeTime    , 
    
 }

function  AssignNativeTime(Year         : word = 1;
                           Month        : word = 1;
                           Day          : word = 1;
                           Hour         : word = 0;
                           Minute       : word = 0;
                           Second       : word = 0;
                           Milliseconds : word = 0): TSystemTime;

 {
         .
 }

function  MSecToNativeTime(mSecond:Double):TSystemTime;
function  NativeTimeToMSec(const T:TSystemTime):double;

function  GetMidnightByTimeMs(ms:Double):Double;

function  DateTimeToMSec(Year  : Word = 1;
                         Month : Word = 1;
                         Day   : Word = 1;
                         Hour  : Word = 0;
                         Min   : Word = 0;
                         Sec   : Word = 0;
                         MSec  : Word = 0): Double;
procedure MSecToDateTime(T:Double; var Year,Month,Day,Hour,Min,Sec,MSec:word);

 {
 General Date,Time format function.
 Similar to FormatDateTime but uses ms since Xmas instead of TDateTime.
 Return empty string if ms is out of range [MSecRangeMin,MSecRangeMax].
 Also use exception handler.
 }                                      
function StrTimeFmt(const Fmt:String; ms:Double; mode:Integer=0):String;

const             // StrTimeFmt mode:
 stfm_Report = 0; // BugReport on error, return empty string
 stfm_Ignore = 1; // Ignore exceptions,  return empty string
 stfm_Raise  = 2; // Raise an exception on EConvertError

 {
      .
           .
  :  ms=63129943111030  05.07.2001-15:18:31:030
 GetDateStr(ms)                = 05.07.2001   -   
 GetDateStr(ms,'\')            = 05\07\2001   -  '\'
 GetDateStr(ms,'.',true)       = 2001.07.05   -  (,,)
 GetDateStr(ms,#0,true)        = 20010705     -  
 GetDateStr(ms,'.',false,true) = 05.07.01     -   
 GetTimeStr(ms)                = 15:18:31     -   
 GetTimeStr(ms,#0)             = 151831       -  
 GetTimeStr(ms,':',true)       = 15:18:31:030 -  
 }
function  GetDateStr(const Time      : TSystemTime;     { global time to convert }
                           Delim     : Char    = '.';   { #0 for no delim }
                           YMD_Order : Boolean = false; { Year,Month,Day order }
                           ShortYear : Boolean = false  { Year takes 2 chars }
                           ): ShortString; overload;
function  GetDateStr(ms        : Double;                { global time to convert }
                     Delim     : Char    = '.';         { #0 for no delim }
                     YMD_Order : Boolean = false;       { Year,Month,Day order }
                     ShortYear : Boolean = false        { Year takes 2 chars }
                     ): ShortString; overload;
function  GetTimeStr(const Time      : TSystemTime;     { global time to convert }
                           Delim     : Char    = ':';   { #0 for no delim }
                           ShowMSec  : Boolean = false  { to show milliseconds }
                           ): ShortString; overload;
function  GetTimeStr(ms        : double;                { global time to convert }
                     Delim     : Char    = ':';         { #0 for no delim }
                     ShowMSec  : Boolean = false        { to show milliseconds }
                     ): ShortString; overload;

 {
   -      
  ,    -  
     .
    (/)   ,
      ,  
   .     Start.    
      Event,   true
     .  ,  
 ,   What.      Event
  true      .
    - tmCyclic,     
   .   ,   
   .
  Event  LocalTime   0.27 mks  K7-650.
 ****************************
  1 -  
 ****************************
  program test1;
  uses _rtc;
  var P:TIntervalTimer;
  begin
   P:=NewIntervalTimer;
   P.LocalTimeUnits:=1000;  // 
   P.Start;
   while P.LocalTime<10 do begin
    Echo(Format('%g',[P.LocalTime]));
    Sleep(3);
   end;
   P.Stop;
   Kill(P);
  end.
 ************************************************************
  2 -    :
 ************************************************************
  program test2;
  uses _rtc;
  var P:TIntervalTimer;
  begin
   P:=NewIntervalTimer(tmCyclic,NewIntervalMs(300,1,
                                NewIntervalMs(3000,2,
                                NewIntervalMs(1000,3,
                                nil))));
   P.LocalTimeUnits:=1000;  // 
   P.Start;
   while P.LocalTime<10 do begin
    if P.Event then
    case P.What of
     1:Echo('1');
     2:Echo('2');
     3:Echo('3');
    end;
   end;
   P.Stop;
   Kill(P);
  end.
 }
const               {    }
 tmCyclic  = $0001; {    }
 tmStart   = $8000; {   IntervalTimer }
 tmNothing = 0;     {      }

type
 TTimerInterval = packed record
  Delta : double;
  Event : word;
 end;
 PTimerIntervalArray = ^TTimerIntervalArray;
 TTimerIntervalArray = packed array[0..1000] of TTimerInterval;
 PIntervalItem = ^TIntervalItem;
 TIntervalItem = packed record
  Delta : double;
  Event : integer;
  Next  : PIntervalItem;
 end;
 TIntervalTimer = class(TLatch)
 private
  myNumInt     : integer;             {   }
  myCurInt     : integer;             {    }
  myFlags      : word;                {    }
  myiWhat      : word;                {    }
  mygStart     : double;              {     }
  myiStart     : double;              {      }
  myiLimit     : double;              {     }
  myInterval   : PTimerIntervalArray; {     }
  myMsPerUnit  : double;              {   }
  myUnitPerMs  : double;              {    }
  function    GetIntervalMs(i:integer):double;
  procedure   SetIntervalMs(i:integer; Ms:double);
  function    GetIntervalEvent(i:integer):word;
  procedure   SetIntervalEvent(i:integer; Event:word);
  function    GetLocalTimeUnits:double;
  procedure   SetLocalTimeUnits(MSecPerUnit:double);
  function    GetLocalTime:double;
  function    GetNumIntervals:integer;
  function    GetCurrentInterval:integer;
  function    GetTime:double;
  function    GetStartTime:double;
  function    GetIntervalStartTime:double;
  function    GetEvent:boolean;
  function    GetWhat:word;
 public
  {
   .
  }
  constructor Create(Mode:word=tmNothing; IntervalList:PIntervalItem=nil);
  {
   .
  }
  destructor  Destroy; override;
  {
   ,       , 
    .
  }
  procedure   StartAt(OriginTime:double);
  {
      .
  }
  procedure   Start;
  {
   .
  }
  procedure   Stop;
  {
   -    .
  }
  function    isStart:boolean;
  {
          
  }
  procedure   AddIntervalMs(IntervalMs:double; EventId:word);
  {
     (  ) ?
  }
  property    GlobalTime : double            read GetTime;
  {
           ?
  LocalTime=(GlobalTime-StartTime)/LocalTimeUnits
  }
  property    LocalTime : double             read GetLocalTime;
  {
         .
        .
  ,  LocalTimeUnits=1000,    .
  }
  property    LocalTimeUnits : double        read GetLocalTimeUnits write SetLocalTimeUnits;
  {
     (  ) ?
  }
  property    StartTime : double             read GetStartTime;
  {
       (  ) ?
  }
  property    IntervalStartTime : double     read GetIntervalStartTime;
  {
   true    .
        .
  }
  property    Event : boolean                read GetEvent;
  {
     .
    What     Event.
  }
  property    What : word                    read GetWhat;
  {
      ?
  }
  property    NumIntervals : integer         read GetNumIntervals;
  {
      ?
  }
  property    CurrentInterval : integer      read GetCurrentInterval;
  {
         .
  }
  property    IntervalMs[i:integer] : double read GetIntervalMs write SetIntervalMs;
  {
         .
  }
  property    IntervalEvent[i:integer] : word read GetIntervalEvent write SetIntervalEvent;
 end;

 {
     .
 :
  P:=IntervalTimer(tmCyclic,NewIntervalMs(300,1,
                            NewIntervalMs(3000,2,
                            NewIntervalMs(1000,3,
                            nil))));
 }
function  NewIntervalMs(Interval:double; Event:word; Next: PIntervalItem): PIntervalItem;

 {
    nil
 }
procedure Kill(var TheObject:TIntervalTimer); overload;

 {
      .
     tmStart     .
 }
function NewIntervalTimer(Mode:word=tmNothing; IntervalList:PIntervalItem=nil):TIntervalTimer;

 {
 Magic numerals
 }
const
 QuartzFrequency  = 1193180;
 CountsPerTick    = 65536;
 SecsPerDay       = 24 * 60 * 60;
 MSecsPerDay      = SecsPerDay  * 1000;
 TicksPerDay      = 1573040 {QuartzFrequency / CountsPerTick * SecsPerDay};
 SecsPerTick      = SecsPerDay  / TicksPerDay;
 TicksPerSec      = TicksPerDay / SecsPerDay;
 MSecsPerTick     = MSecsPerDay / TicksPerDay;
 TicksPerMSec     = TicksPerDay / MSecsPerDay;
 FloatMSecsPerDay = MSecsPerDay * 1.0;
 DateDelta        = 693594;             // Days from Xmas to 1899.12.31-00:00:00.000
 FileTimesPerMSec = 10000;              // Num. 100 ns FileTime's ticks per 1 ms
 TickCountOverInc = $100000000;         // GetTickCount increment, when overflow
 FileTimeZeroOffs = 504911232000000000; // FileTimeZero-XmasTimeZero,[100ns]
 XmasTimeZeroDate = '0001.01.01-00:00'; // Christmas time zero date
 FileTimeZeroDate = '1601.01.01-00:00'; // Win32 GMT time zero date
 JavaTimeBase     = 621355968e5;        // 1970.01.01-00:00:00 UTC Epoch
 JavaTimeUnit     = 1;                  // JavaScript use ms since Epoch
 UnixTimeBase     = 621355968e5;        // 1970.01.01-00:00:00 UTC Epoch
 UnixTimeUnit     = 1000;               // Unix time(), secs since Epoch
 FileTimeBase     = 504911232e5;        // 1601.01.01-00:00:00 UTC Win32
 FileTimeUnit     = 1e-4;               // FileTime uses 100 ns units
 WinsTimeBase     = 504911232e5;        // 1601.01.01-00:00:00 UTC Win32
 WinsTimeUnit     = 1;                  // SystemTime uses ms unit Win32
 OleTimeBase      = 599264352e5;        // 1899.12.30-00:00:00 - OLE Automation date format
 OleTimeUnit      = 86400000;           // Equals MSecsPerDay  - OLE Automation date format

const                                   // Range of Msec since Xmas
 MsecRangeMin     = 0;                  // 01/01/0001 00:00:00.000 - Xmas
 MsecRangeMax     = 315537897599999;    // 12/31/9999 23:59:59.999 - High(TDateTime)

 {
 Time unit conversion routines.
 }

 {
 Note: 'ms' means 'milliseconds since Xmas'
 Xmas is: 0001.01.0.1-00:00:00 +0000 (UTC).
 It's DaqPascal msecnow function time unit.
 }

 {
 UnixTime is number of seconds since Epoch.
 Epoch is: 1970-01-01 00:00:00 +0000 (UTC).
 It's standard Unix/Linux time(.) function.
 }
function MsToUnixTime(ms:Double):Double;
function UnixTimeToMs(tm:Double):Double;

 {
 JavaTime is number of milliseconds since Epoch.
 It's time units uses by JavaScript new Data().
 }
function MsToJavaTime(ms:Double):Double;
function JavaTimeToMs(tm:Double):Double;

 {
 FileTime is number of 100 ns units since 1601.01.01-00:00:00 UTC.
 It's time units uses by Win32 GetSystemTimeAsFileTime() FILETIME.
 }
function MsToFileTime(ms:Double):Double;
function FileTimeToMs(tm:Double):Double;

 {
 WinsTime is number milliseconds since 1601.01.01-00:00:00 UTC.
 It's time units uses by Win32 GetSystemTime.
 }
function MsToWinsTime(ms:Double):Double;
function WinsTimeToMs(tm:Double):Double;

 {
 OleTime is number of days since 1899.12.30-00:00:00 UTC.
 It's time unit uses by OLE, OLEDB, ADO, OPC DA & Delphi.
 TDateTime is same as OleTime.
 }
function MsToOleTime(ms:Double):Double;
function OleTimeToMs(tm:Double):Double;

implementation

function MsToUnixTime(ms:Double):Double;
begin
 MsToUnixTime:=(ms-UnixTimeBase)/UnixTimeUnit;
end;
function UnixTimeToMs(tm:Double):Double;
begin
 UnixTimeToMs:=tm*UnixTimeUnit+UnixTimeBase;
end;

function MsToJavaTime(ms:Double):Double;
begin
 MsToJavaTime:=(ms-JavaTimeBase)/JavaTimeUnit;
end;
function JavaTimeToMs(tm:Double):Double;
begin
 JavaTimeToMs:=tm*JavaTimeUnit+JavaTimeBase;
end;

function MsToFileTime(ms:Double):Double;
begin
 MsToFileTime:=(ms-FileTimeBase)/FileTimeUnit;
end;
function FileTimeToMs(tm:Double):Double;
begin
 FileTimeToMs:=tm*FileTimeUnit+FileTimeBase;
end;

function MsToWinsTime(ms:Double):Double;
begin
 MsToWinsTime:=(ms-WinsTimeBase)/WinsTimeUnit;
end;
function WinsTimeToMs(tm:Double):Double;
begin
 WinsTimeToMs:=tm*WinsTimeUnit+WinsTimeBase;
end;

function MsToOleTime(ms:Double):Double;
begin
 MsToOleTime:=(ms-OleTimeBase)/OleTimeUnit;
end;
function OleTimeToMs(tm:Double):Double;
begin
 OleTimeToMs:=tm*OleTimeUnit+OleTimeBase;
end;

 {
 *****************************
 TIntervalTimer implementation
 *****************************
 }
constructor TIntervalTimer.Create(Mode:word=tmNothing; IntervalList:PIntervalItem=nil);
var
 I : PIntervalItem;
begin
 inherited Create;
 myNumInt:=0;
 myCurInt:=0;
 myFlags:=Mode and not tmStart;
 mygStart:=0;
 myiStart:=0;
 myiLimit:=0;
 myiWhat:=tmNothing;
 myInterval:=nil;
 LocalTimeUnits:=1;
 while Assigned(IntervalList) do begin
  AddIntervalMs(IntervalList.Delta,IntervalList.Event);
  I:=IntervalList;
  IntervalList:=IntervalList.Next;
  Dispose(I);
 end;
 if Mode and tmStart <> 0 then Start;
end;

destructor TIntervalTimer.Destroy;
begin
 Lock;
 Deallocate(Pointer(myInterval));
 Unlock;
 inherited Destroy;
end;

procedure TIntervalTimer.AddIntervalMs(IntervalMs:double; EventId:word);
var
 i           : integer;
 OldInterval : PTimerIntervalArray;
begin
 if Assigned(Self) then begin
  Lock;
  OldInterval:=myInterval;
  myInterval:=Allocate((myNumInt+1)*sizeof(myInterval[0]));
  if Assigned(myInterval) then begin
   if Assigned(OldInterval) then
   for i:=0 to myNumInt-1 do myInterval[i]:=OldInterval[i];
   myInterval[myNumInt].Delta:=IntervalMs;
   myInterval[myNumInt].Event:=EventId;
   Deallocate(Pointer(OldInterval));
   inc(myNumInt);
  end else begin
   Deallocate(Pointer(myInterval));
   myInterval:=OldInterval;
  end;
  Unlock;
 end;
end;

procedure  TIntervalTimer.StartAt(OriginTime:double);
begin
 if Assigned(Self) then begin
  Lock;
  Stop;
  myFlags:=myFlags or tmStart;
  myCurInt:=0;
  mygStart:=OriginTime;
  myiStart:=mygStart;
  myiLimit:=myiStart+IntervalMs[myCurInt];
  myiWhat:=tmNothing;
  Unlock;
 end;
end;

procedure  TIntervalTimer.Start;
begin
 StartAt(MSecNow);
end;

procedure  TIntervalTimer.Stop;
begin
 if Assigned(Self) then begin
  Lock;
  myFlags:=myFlags and not tmStart;
  Unlock;
 end;
end;

function TIntervalTimer.isStart:boolean;
begin
 if Assigned(Self) then begin
  Lock;
  Result:=(myFlags and tmStart<>0);
  Unlock;
 end else Result:=false;
end;

function TIntervalTimer.GetTime:double;
begin
 GetTime:=msecnow;
end;

function  TIntervalTimer.GetStartTime:double;
begin
 if Assigned(Self) then begin
  Lock;
  Result:=mygStart;
  Unlock;
 end else Result:=0;
end;

function  TIntervalTimer.GetIntervalStartTime:double;
begin
 if Assigned(Self) then begin
  Lock;
  Result:=myiStart;
  Unlock;
 end else Result:=0;
end;

function  TIntervalTimer.GetLocalTime:double;
begin
 if Assigned(Self) then begin
  Lock;
  Result:=(MSecNow-mygStart)*myUnitPerMs;
  Unlock;
 end else Result:=0;
end;

function  TIntervalTimer.GetEvent:boolean;
var
 Time : double;
begin
 Result:=false;
 if Assigned(Self) then begin
  Lock;
  myiWhat:=tmNothing;
  if (myFlags and tmStart <> 0) and (myNumInt > 0) then begin
   Time:=MSecNow;
   if Time>=myiLimit then begin
    myiWhat:=IntervalEvent[myCurInt];
    Result:=true;
    inc(myCurInt);
    if myCurInt>=myNumInt then begin
     myCurInt:=0;
     if myFlags and tmCyclic = 0 then Stop;
    end;
    if myFlags and tmStart <> 0 then begin
     myiStart:=Time;
     myiLimit:=myiStart+IntervalMs[myCurInt];
    end;
   end;
  end;
  Unlock;
 end;
end;

function TIntervalTimer.GetWhat:word;
begin
 if Assigned(Self) then begin
  Lock;
  Result:=myiWhat;
  Unlock;
 end else Result:=tmNothing;
end;

function  TIntervalTimer.GetNumIntervals:integer;
begin
 if Assigned(Self) then begin
  Lock;
  Result:=myNumInt;
  Unlock;
 end else Result:=0;
end;

function  TIntervalTimer.GetCurrentInterval:integer;
begin
 if Assigned(Self) then begin
  Lock;
  Result:=myCurInt;
  Unlock;
 end else Result:=0;
end;

function  TIntervalTimer.GetIntervalMs(i:integer):double;
begin
 if Assigned(Self) then begin
  Lock;
  if (i>=0) and (i<myNumInt) and Assigned(myInterval)
  then Result:=myInterval[i].Delta
  else Result:=0;
  Unlock;
 end else Result:=0;
end;

procedure TIntervalTimer.SetIntervalMs(i:integer; Ms:double);
begin
 if Assigned(Self) then begin
  Lock;
  if (i>=0) and (i<myNumInt) and Assigned(myInterval) then begin
   myInterval[i].Delta:=Ms;
   if (myFlags and tmStart <> 0) and (i=myCurInt) then myiLimit:=myiStart+Ms;
  end;
  Unlock;
 end;
end;

function  TIntervalTimer.GetIntervalEvent(i:integer):word;
begin
 if Assigned(Self) then begin
  Lock;
  if (i>=0) and (i<myNumInt) and Assigned(myInterval)
  then Result:=myInterval[i].Event
  else Result:=tmNothing;
  Unlock;
 end else Result:=tmNothing;
end;

procedure TIntervalTimer.SetIntervalEvent(i:integer; Event:word);
begin
 if Assigned(Self) then begin
  Lock;
  if (i>=0) and (i<myNumInt) and Assigned(myInterval)
  then myInterval[i].Event:=Event;
  Unlock;
 end;
end;

function TIntervalTimer.GetLocalTimeUnits:double;
begin
 if Assigned(Self) then begin
  Lock;
  Result:=myMsPerUnit;
  Unlock;
 end else Result:=0;
end;

procedure TIntervalTimer.SetLocalTimeUnits(MSecPerUnit:double);
begin
 if Assigned(Self) then begin
  Lock;
  myMsPerUnit:=MSecPerUnit;
  myUnitPerMs:=1/myMsPerUnit;
  Unlock;
 end;
end;

function NewIntervalMs(Interval:double; Event:word; Next: PIntervalItem): PIntervalItem;
begin
 Result:=New(PIntervalItem);
 if Assigned(Result) then begin
  Result.Delta:=Interval;
  Result.Event:=Event;
  Result.Next:=Next;
 end;
end;

function NewIntervalTimer(Mode:word=tmNothing; IntervalList:PIntervalItem=nil):TIntervalTimer;
begin
 Result:=nil;
 try
  Result:=TIntervalTimer.Create(Mode,IntervalList);
 except
  on E:Exception do BugReport(E);
 end;
end;

procedure Kill(var TheObject:TIntervalTimer); overload;
begin
 try
  FreeAndNil(TheObject);
 except
  on E:Exception do BugReport(E);
 end;
end;

 {
 Date / Time conversion
 }

const
 MonthTable       : array[Boolean] of array[1..12] of Word =
                    ((31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31),
                     (31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31));
 {
procedure DivMod(Dividend:LongInt; Divisor:Word; var Result,Remainder:Word);
begin
 Result    := Dividend div Divisor;
 Remainder := Dividend mod Divisor;
end;
 }
procedure DivMod(Dividend: Integer; Divisor: Word; var Result, Remainder: Word);
register;
asm
 PUSH EBX
 MOV  EBX,EDX
 MOV  EDX,EAX
 SHR  EDX,16
 DIV  BX
 MOV  EBX,Remainder
 MOV  [ECX],AX
 MOV  [EBX],DX
 POP  EBX
end;

function EncodeTime(Hour,Min,Sec,MSec:Word; var MSecFromMidnight:LongInt):boolean;
begin
 Result:=false;
 if (Hour<24) and (Min<60) and (Sec<60) and (MSec<1000) then begin
  MSecFromMidnight:=Hour*3600000+Min*60000+Sec*1000+MSec;
  Result:=true;
 end;
end;

procedure DecodeTime(MSecFromMidnight:LongInt; var Hour,Min,Sec,MSec:Word);
var
 MinCount  : Word;
 MSecCount : Word;
begin
 DivMod(MSecFromMidnight, 60000, MinCount, MSecCount);
 DivMod(MinCount, 60, Hour, Min);
 DivMod(MSecCount, 1000, Sec, MSec);
end;

function IsLeapYear(Year: Word): Boolean;
begin
 Result:=(Year mod 4 = 0) and ((Year mod 100 <> 0) or (Year mod 400 = 0));
end;

function EncodeDate(Year,Month,Day:Word; var NumDaysFromXmas:LongInt):Boolean;
var
 I      : LongInt;
 isLeap : Boolean;
begin
 Result := False;
 isLeap := IsLeapYear(Year);
 if (Year >= 1) and (Year <= 9999) and (Month >= 1) and (Month <= 12) and
   (Day >= 1) and (Day <= MonthTable[isLeap][Month]) then
 begin
  for I := 1 to Month - 1 do Inc(Day, MonthTable[isLeap][I]);
  I := Year - 1;
  NumDaysFromXmas := I * 365 + I div 4 - I div 100 + I div 400 + Day - 1;
  Result:= True;
 end;
end;

procedure DecodeDate(NumDaysFromXmas:LongInt; var Year,Month,Day,DayOfWeek:Word);
const
  D1   = 365;
  D4   = D1 * 4 + 1;
  D100 = D4 * 25 - 1;
  D400 = D100 * 4 + 1;
var
 Y      : Word;
 M      : Word;
 D      : Word;
 I      : Word;
 T      : LongInt;
 isLeap : Boolean;
begin
 T := NumDaysFromXmas + 1;
 if T <= 0 then begin
  Year := 0;
  Month := 0;
  Day := 0;
  DayOfWeek:=0;
 end else begin
  DayOfWeek := T mod 7;
  Dec(T);
  Y := 1;
  while T >= D400 do begin
   Dec(T, D400);
   Inc(Y, 400);
  end;
  DivMod(T, D100, I, D);
  if I = 4 then begin
   Dec(I);
   Inc(D, D100);
  end;
  Inc(Y, I * 100);
  DivMod(D, D4, I, D);
  Inc(Y, I * 4);
  DivMod(D, D1, I, D);
  if I = 4 then begin
   Dec(I);
   Inc(D, D1);
  end;
  Inc(Y, I);
  isLeap := IsLeapYear(Y);
  M := 1;
  while True do begin
   I := MonthTable[isLeap][M];
   if D < I then Break;
   Dec(D, I);
   Inc(M);
  end;
  Year := Y;
  Month := M;
  Day := D + 1;
 end;
end;

function AssignNativeTime(Year         : word = 1;
                          Month        : word = 1;
                          Day          : word = 1;
                          Hour         : word = 0;
                          Minute       : word = 0;
                          Second       : word = 0;
                          Milliseconds : word = 0): TSystemTime;
begin
 with Result do begin
  wYear:=Year;
  wMonth:=Month;
  wDay:=Day;
  wDayOfWeek:=sysutils.DayOfWeek(sysutils.EncodeDate(Year, Month, Day));
  wHour:=Hour;
  wMinute:=Minute;
  wSecond:=Second;
  wMilliseconds:=Milliseconds;
 end;
end;

function MSecToNativeTime(mSecond:Double):TSystemTime;
var
 NumDaysFromXmas  : LongInt;
 MSecFromMidnight : LongInt;
begin
 NumDaysFromXmas:=trunc(mSecond/FloatMSecsPerDay);
 MSecFromMidnight:=trunc(mSecond-NumDaysFromXmas*FloatMSecsPerDay);
 with Result do begin
  DecodeTime(MSecFromMidnight,wHour,wMinute,wSecond,wMilliseconds);
  DecodeDate(NumDaysFromXmas,wYear,wMonth,wDay,wDayOfWeek);
 end;
end;

function NativeTimeToMSec(const T:TSystemTime):double;
var
 NumDaysFromXmas  : LongInt;
 MSecFromMidnight : LongInt;
begin
 with T do begin
  if EncodeDate(wYear,wMonth,wDay,NumDaysFromXmas) and
     EncodeTime(wHour,wMinute,wSecond,wMilliseconds,MSecFromMidnight)
  then Result:=NumDaysFromXmas*FloatMSecsPerDay+MSecFromMidnight
  else Result:=_NaN;
 end;
end;

function GetMidnightByTimeMs(ms:Double):Double;
var st:TSystemTime;
begin
 st:=MSecToNativeTime(ms);
 st.wHour:=0; st.wMinute:=0; st.wSecond:=0; st.wMilliseconds:=0;
 Result:=NativeTimeToMSec(st);
end;

function  DateTimeToMSec(Year  : Word = 1;
                         Month : Word = 1;
                         Day   : Word = 1;
                         Hour  : Word = 0;
                         Min   : Word = 0;
                         Sec   : Word = 0;
                         MSec  : Word = 0): Double;
var
 NumDaysFromXmas  : LongInt;
 MSecFromMidnight : LongInt;
begin
 if EncodeDate(Year,Month,Day,NumDaysFromXmas) and
    EncodeTime(Hour,Min,Sec,MSec,MSecFromMidnight)
 then Result:=NumDaysFromXmas*FloatMSecsPerDay+MSecFromMidnight
 else Result:=_NaN;
end;

procedure  MSecToDateTime(T:Double; var Year,Month,Day,Hour,Min,Sec,MSec:word);
var
 NumDaysFromXmas  : LongInt;
 MSecFromMidnight : LongInt;
 DayOfWeek        : word;
begin
 NumDaysFromXmas:=trunc(T/MSecsPerDay);
 MSecFromMidnight:=trunc(T-NumDaysFromXmas*FloatMSecsPerDay);
 DecodeTime(MSecFromMidnight,Hour,Min,Sec,MSec);
 DecodeDate(NumDaysFromXmas,Year,Month,Day,DayOfWeek);
end;

function StrTimeFmt(const Fmt:String; ms:Double; mode:Integer=0):String;
begin
 Result:='';
 if (ms>=MsecRangeMin) then
 if (ms<=MsecRangeMax) then
 try
  Result:=FormatDateTime(Fmt,MsToOleTime(ms));
 except
  on E:EConvertError do begin
   case mode of
    stfm_Report: BugReport(E,nil,'StrTimeFmt');
    stfm_Ignore: Exit;
    else raise;
   end;
  end;
  on E:Exception do BugReport(E,nil,'StrTimeFmt');
 end;
end;

function  GetDateStr(const Time      : TSystemTime;     { global time to convert }
                           Delim     : Char    = '.';   { #0 for no delim }
                           YMD_Order : Boolean = false; { Year,Month,Day order }
                           ShortYear : Boolean = false  { Year takes 2 chars }
                           ): ShortString;
var
 fmt  : String[30];
 Year : word;
begin
 if ShortYear then begin
  Year:=Time.wYear mod 100;
  fmt:='%2.2d';
 end else begin
  Year:=Time.wYear;
  fmt:='%4.4d';
 end;
 if YMD_Order then begin
  if Delim<>#0 then fmt:=fmt+Delim;
  fmt:=fmt+'%2.2d';
  if Delim<>#0 then fmt:=fmt+Delim;
  fmt:=fmt+'%2.2d';
  Result:=Format(fmt,[Year,Time.wMonth,Time.wDay]);
 end else begin
  if Delim<>#0 then fmt:=Delim+fmt;
  fmt:='%2.2d'+fmt;
  if Delim<>#0 then fmt:=Delim+fmt;
  fmt:='%2.2d'+fmt;
  Result:=Format(fmt,[Time.wDay,Time.wMonth,Year]);
 end;
end;

function  GetDateStr(ms        : Double;          { global time to convert }
                     Delim     : Char    = '.';   { #0 for no delim }
                     YMD_Order : Boolean = false; { Year,Month,Day order }
                     ShortYear : Boolean = false  { Year takes 2 chars }
                     ): ShortString;
begin
 Result:=GetDateStr(MSecToNativeTime(ms),Delim,YMD_Order,ShortYear);
end;

function  GetTimeStr(const Time      : TSystemTime;     { global time to convert }
                           Delim     : Char    = ':';   { #0 for no delim }
                           ShowMSec  : Boolean = false  { to show milliseconds }
                           ): ShortString;
var
 fmt   : String[30];
begin
 fmt:='%2.2d';
 if Delim<>#0 then fmt:=fmt+Delim;
 fmt:=fmt+'%2.2d';
 if Delim<>#0 then fmt:=fmt+Delim;
 fmt:=fmt+'%2.2d';
 if ShowMSec then begin
  if Delim<>#0 then fmt:=fmt+Delim;
  fmt:=fmt+'%3.3d';
  Result:=Format(fmt,[Time.wHour,Time.wMinute,Time.wSecond,Time.wMilliSeconds]);
 end else begin
  Result:=Format(fmt,[Time.wHour,Time.wMinute,Time.wSecond]);
 end;
end;

function  GetTimeStr(ms        : double;          { global time to convert }
                     Delim     : Char    = ':';   { #0 for no delim }
                     ShowMSec  : Boolean = false  { to show milliseconds }
                     ): ShortString;
begin
 Result:=GetTimeStr(MSecToNativeTime(ms),Delim,ShowMSec);
end;

 {
 ***********************************
 MSecNow & IntMSecNow implementation
 ***********************************
 }

const
 GMT_Offset  : Int64 = 0;                  // GMT-Xmas time offset, [100 ns]
 LMT_Offset  : Int64 = 0;                  // LMT-Xmas time offset, [100 ns]
 GMT_Base_32 : Int64 = 0;                  // GMT Base time on x32, [ms] (Fallback)
 LMT_Base_32 : Int64 = 0;                  // LMT Base time on x32, [ms] (Fallback)
 GMT_Base_64 : Int64 = 0;                  // GMT Base time on x64, [ms] (Standard)
 LMT_Base_64 : Int64 = 0;                  // LMT Base time on x64, [ms] (Standard)
 TheFailures : DWORD = 0;                  // Time failures counter
 TheRtcLatch : TRTLCriticalSection = ();   // Synchronizer for thread safety

const GetTickCount64_Kernel32:function:Int64; stdcall = nil;

procedure InitGetTickCount64;
begin
 @GetTickCount64_Kernel32:=GetProcAddress(GetModuleHandle('kernel32.dll'),'GetTickCount64');
end;

function HasKernelGetTickCount64:Boolean;
begin
 Result:=Assigned(GetTickCount64_Kernel32);
end;

function IsKernelGetTickCount64:Boolean;
begin
 Result:=Assigned(GetTickCount64_Kernel32) and UseKernelGetTickCount64;
end;

function GetTickCount64_Fallback:Int64; stdcall;
const TickBase : Int64 = 0;
const TickMsec : Int64 = 0;
const TickLast : DWORD = 0;
var aTick:DWORD;
begin
 EnterCriticalSection(TheRtcLatch);
 aTick:=GetTickCount;
 if aTick<>TickLast then begin
  if aTick<TickLast then TickBase:=TickBase+TickCountOverInc;
  if TickBase+aTick<TickMsec then MSecNowErrorFound;
  TickMsec:=TickBase+aTick;
  TickLast:=aTick;
 end;
 Result:=TickMsec;
 LeaveCriticalSection(TheRtcLatch);
end;

function GetTickCount64_Relevant:Int64; stdcall;
begin
 if Assigned(GetTickCount64_Kernel32)
 then Result:=GetTickCount64_Kernel32
 else Result:=GetTickCount64_Fallback;
end;

function GetTickCount64_Standard:Int64; stdcall;
begin
 if Assigned(GetTickCount64_Kernel32) and UseKernelGetTickCount64
 then Result:=GetTickCount64_Kernel32
 else Result:=GetTickCount64_Fallback;
end;

function GetTickCount64:Int64; stdcall;
begin
 if Assigned(GetTickCount64_Kernel32) and UseKernelGetTickCount64
 then Result:=GetTickCount64_Kernel32
 else Result:=GetTickCount64_Fallback;
end;

procedure InitializeMSecNow;
var TheFileTime,TickTime_64,TickTime_32:Int64; Tick,Iter:DWORD;
begin
 InitializeCriticalSection(TheRtcLatch);
 InitGetTickCount64;
 EnterCriticalSection(TheRtcLatch);
 for Iter:=1 to 9 do begin
  Tick:=GetTickCount;
  TickTime_32:=GetTickCount64_Fallback;
  TickTime_64:=GetTickCount64_Relevant;
  TheFileTime:=FileTimeNow(rtc_GMT);
  if Tick=GetTickCount then Break;
 end;
 GMT_Offset:=FileTimeZeroOffs;
 LMT_Offset:=FileTimeZeroOffs+LocalMeanFileTimeBiasNow(TheFileTime);
 GMT_Base_32:=System.Trunc((TheFileTime+GMT_Offset)/FileTimesPerMSec)-TickTime_32;
 LMT_Base_32:=System.Trunc((TheFileTime+LMT_Offset)/FileTimesPerMSec)-TickTime_32;
 GMT_Base_64:=System.Trunc((TheFileTime+GMT_Offset)/FileTimesPerMSec)-TickTime_64;
 LMT_Base_64:=System.Trunc((TheFileTime+LMT_Offset)/FileTimesPerMSec)-TickTime_64;
 LeaveCriticalSection(TheRtcLatch);
end;

procedure FinalizeMSecNow;
begin
 DeleteCriticalSection(TheRtcLatch);
 ResourceLeakageLog(Format('%-60s = %d',['MSecNow.Monotone.Violations', TheFailures]));
end;

function MSecNow(Method:Integer):Double;
var aTime : Int64;
begin
 if Method and rtc_SYS = rtc_SYS then begin
  GetSystemTimeAsFileTime(TFileTime(aTime));
  if Method and rtc_GMT = rtc_GMT
  then Result:=System.Int((aTime+GMT_Offset)/FileTimesPerMSec)
  else Result:=System.Int((aTime+LMT_Offset)/FileTimesPerMSec);
 end else begin
  if Assigned(GetTickCount64_Kernel32) and UseKernelGetTickCount64 then begin
   if Method and rtc_GMT = rtc_GMT
   then Result:=GMT_Base_64+GetTickCount64_Kernel32
   else Result:=LMT_Base_64+GetTickCount64_Kernel32;
  end else begin
   if Method and rtc_GMT = rtc_GMT
   then Result:=GMT_Base_32+GetTickCount64_Fallback
   else Result:=LMT_Base_32+GetTickCount64_Fallback;
  end;
 end;
end;

function IntMSecNow(Method:Integer):Int64;
var aTime : Int64;
begin
 if Method and rtc_SYS = rtc_SYS then begin
  GetSystemTimeAsFileTime(TFileTime(aTime));
  if Method and rtc_GMT = rtc_GMT
  then Result:=System.Trunc((aTime+GMT_Offset)/FileTimesPerMSec)
  else Result:=System.Trunc((aTime+LMT_Offset)/FileTimesPerMSec);
 end else begin
  if Assigned(GetTickCount64_Kernel32) and UseKernelGetTickCount64 then begin
   if Method and rtc_GMT = rtc_GMT
   then Result:=GMT_Base_64+GetTickCount64_Kernel32
   else Result:=LMT_Base_64+GetTickCount64_Kernel32;
  end else begin
   if Method and rtc_GMT = rtc_GMT
   then Result:=GMT_Base_32+GetTickCount64_Fallback
   else Result:=LMT_Base_32+GetTickCount64_Fallback;
  end;
 end;
end;

function MSecNowErrors:DWORD;
begin
 Result:=TheFailures;
end;

procedure MSecNowErrorFound;
begin
 InterlockedIncrement(Integer(TheFailures));
end;

procedure MSecNowErrorClear;
begin
 InterlockedExchange(Integer(TheFailures),0);
end;

procedure Timer_Check_RTC_Monotonicity;
const Last : array[1..2] of Int64 = (0,0);
const ThId : Cardinal = 0;
var i:Integer; Tick:Int64;
begin
 if not Allow_Check_RTC_Monotonicity then Exit;
 if ThId=0 then ThId:=GetCurrentThreadId;
 if (GetCurrentThreadId<>ThId) then Exit;
 for i:=Low(Last) to High(Last) do begin
  if i=Low(Last)
  then Tick:=GetTickCount64_Relevant
  else Tick:=GetTickCount64_Fallback;
  //  Monotonicity violation checking
  if Tick<Last[i] then MSecNowErrorFound;
  Last[i]:=Tick;
 end;
end;

function Benchmark_RTC(n:DWORD=1000*1000*100; Kern:Boolean=true):String;
const CRLF=#13#10; procedure Nop(x:Double); begin end;
var dw,i:DWORD; qw:Int64; dt,t,ms:Double; Save:Boolean;
begin
 Save:=UseKernelGetTickCount64;
 UseKernelGetTickCount64:=Kern;
 Result:=Format('Benchmark_RTC(%d,%d):',[n,Ord(Kern)]);
 dw:=0; qw:=0; t:=0;
 //
 // GetTickCount
 //
 dt:=GetTickCount;
 for i:=1 to n do dw:=GetTickCount;
 dt:=GetTickCount-dt;
 Result:=Result+CRLF+Format('GetTickCount   %7.3f ns/call',[1e6*dt/n]);
 Nop(dw);
 //
 // GetTickCount64
 //
 dt:=GetTickCount;
 for i:=1 to n do qw:=GetTickCount64;
 dt:=GetTickCount-dt;
 Result:=Result+CRLF+Format('GetTickCount64 %7.3f ns/call',[1e6*dt/n]);
 Nop(qw);
 //
 // IntMSecNow
 //
 dt:=GetTickCount;
 for i:=1 to n do qw:=IntMSecNow;
 dt:=GetTickCount-dt;
 Result:=Result+CRLF+Format('IntMSecNow     %7.3f ns/call',[1e6*dt/n]);
 Nop(qw);
 //
 // MSecNow
 //
 dt:=GetTickCount;
 for i:=1 to n do t:=MSecNow;
 dt:=GetTickCount-dt;
 Result:=Result+CRLF+Format('MSecNow        %7.3f ns/call',[1e6*dt/n]);
 Nop(t);
 //
 // Summary
 //
 Result:=Result+CRLF+Format('GetTickCount   %d ms',[GetTickCount]);
 Result:=Result+CRLF+Format('GetTickCount64 %d ms',[GetTickCount64_Standard])+' (Standard)';
 Result:=Result+CRLF+Format('GetTickCount64 %d ms',[GetTickCount64_Fallback])+' (Fallback)';
 Result:=Result+CRLF+Format('IntMSecNow     %d ms',[IntMSecNow]);
 Result:=Result+CRLF+Format('MSecNow        %g ms',[MSecNow]);
 ms:=mSecNow;
 Result:=Result+CRLF+Format('Date-Time      %s-%s',   [GetDateStr(ms,'.',true),GetTimeStr(ms)]);
 UseKernelGetTickCount64:=Save;
end;

 {
 *******************************************************************************
 FileTimeNow, NativeTimeNow, LocalMeanFileTimeBiasNow etc
 *******************************************************************************
 }
function FileTimeNow(Mode:Integer):Int64;
var LMT:Int64;
begin
 GetSystemTimeAsFileTime(TFileTime(Result));
 if Mode and rtc_GMT = rtc_LMT then
 if FileTimeToLocalFileTime(TFileTime(Result),TFileTime(LMT))
 then Result:=LMT;
end;

function NativeTimeNow(Mode:Integer):TSystemTime;
begin
 if Mode and rtc_GMT = rtc_GMT
 then GetSystemTime(Result)
 else GetLocalTime(Result);
end;

function LocalMeanFileTimeBiasNow(GMT:Int64):Int64;
var LMT:Int64;
begin
 if FileTimeToLocalFileTime(TFileTime(GMT),TFileTime(LMT))
 then Result:=LMT-GMT
 else Result:=0;
end;

function GMTFileTimeToLMT(GMT:Int64):Int64;
begin
 if not FileTimeToLocalFileTime(TFileTime(GMT),TFileTime(Result))
 then Result:=GMT;
end;

function LMTFileTimeToGMT(LMT:Int64):Int64;
begin
 if not LocalFileTimeToFileTime(TFileTime(LMT),TFileTime(Result))
 then Result:=LMT;
end;

function FileTimeToMsec(FileTime:Int64):Double;
begin
 Result:=System.Trunc((FileTime+LMT_Offset)/FileTimesPerMSec);
end;

function MsecToFileTime(mSecTime:Double):Int64;
begin
 Result:=System.Trunc(mSecTime)*FileTimesPerMSec-LMT_Offset;
end;

function RDTSC:Int64; assembler; register;
asm
 DW $310F  // RDTSC (ReaD Time Stamp Counter), opcode 0F,31
end;

function ReadTimeStampCounter:Int64; register;
const
 Flag:Integer=0;
 PF_RDTSC_INSTRUCTION_AVAILABLE=8; // The RDTSC instruction is available.
 // http://msdn.microsoft.com/library/en-us/sysinfo/base/isprocessorfeaturepresent.asp
 function hasCPUID:Boolean; assembler; register;
 asm
  PUSHFD                //     ,   
  POP    EAX            //   EAX
  MOV    EDX,EAX        //   
  XOR    EAX,$200000    //  ID  
  PUSH   EAX            //  
  POPFD                 //    ,   ID
  PUSHFD                //   
  POP    EAX            //   EAX
  XOR    EAX,EDX        // ,    ID
  JZ     @exit          // , CPUID  
  MOV    AL,True        // Result=True
 @exit:
 end;
 function hasRDTSC: Boolean;
 var Features: DWORD;
 begin
  Result:=false;
  if not hasCPUID then Exit;
  asm
   MOV    Features,0
   PUSH   EBX
   XOR    EAX,EAX
   DW     $A20F
   POP    EBX
   CMP    EAX,$01
   JL     @Fail
   XOR    EAX,EAX
   MOV    EAX,$01
   PUSH   EBX
   DW     $A20F
   MOV    Features,EDX
   POP    EBX
  @Fail:
  end;
  Result := (Features and $10) <> 0;
 end;
begin
 if Flag>0 then begin            // If initialization was successed
  try
   Result:=RDTSC;                // Read Time Stamp Counter register
   if Result=0 then Inc(Result); // Zero Result reserved for errors
  except                         // Exception on privileges ?
   Result:=0;                    // Set "Error" result
  end;
 end else
 if Flag<0 then begin            // If initialization failed
  Result:=0;                     // Set "Error" result
 end else                        // Initialization should be done
 try                             // Protected initialization, exception possible
  // On WinNT4.0 and higher we can use IsProcessorFeaturePresent to check RDTSC
  // On Win9x IsProcessorFeaturePresent may not work so we use hasRDTSC instead
  if IsProcessorFeaturePresent(PF_RDTSC_INSTRUCTION_AVAILABLE)
  or ((Win32Platform=VER_PLATFORM_WIN32_WINDOWS) and hasRDTSC) then begin
   Result:=RDTSC;                // Read Time Stamp Counter register
   if Result=0 then Inc(Result); // Zero Result reserved for errors
   LockedExchange(Flag,+1);      // Set "Ok" flag for future calls
  end else begin
   Result:=0;                    // Set "Error" result
   LockedExchange(Flag,-1);      // Set "Error" flag
  end;
 except                          // Exception means that RDTSC is not supported
  Result:=0;                     // Set "Error" result
  LockedExchange(Flag,-1);       // Set "Error" flag
 end;
end;

type
 TCpuThread=class(TThread)
 protected
  FreqMHz : Double;
  TimeOut : Cardinal;
  procedure Execute; override;
 end;

procedure TCpuThread.Execute;
const
 MaxIter = 100;
var
 tsc1,tsc2:Int64;
 i,t1,t2:Cardinal;
 mks1,mks2:Double;
begin
 FreqMHz:=0;
 try
  if ReadTimeStampCounter<>0 then begin
   for i:=1 to MaxIter do begin
    t1:=GetTickCount;
    mks1:=mksecnow;
    tsc1:=ReadTimeStampCounter;
    t2:=GetTickCount;
    if t1=t2 then Break; // All timers measured at the same time quantum?
   end;
   Sleep(TimeOut);
   for i:=1 to MaxIter do begin
    t1:=GetTickCount;
    mks2:=mksecnow;
    tsc2:=ReadTimeStampCounter;
    t2:=GetTickCount;
    if t1=t2 then Break; // All timers measured at the same time quantum?
   end;
   FreqMHz:=(tsc2-tsc1)/(mks2-mks1);
  end;
 except
  on E:Exception do BugReport(E);
 end;
end;

 //
 // We should use separate thread with affinity mask assigned to 1-st available
 // CPU only to avoid problems with RDTSC in multi-processor systems.
 //
function EastimateCpuFrequencyMHz(TimeOut:Cardinal):Double;
var t:TCpuThread; i,a1,a2:DWORD;
begin
 Result:=0;
 try
  t:=TCpuThread.Create(true);                // Create suspended thread
  t.Priority:=tpTimeCritical;                // with highest priority
  t.FreeOnTerminate:=False;
  t.TimeOut:=TimeOut;
  try
   if GetProcessAffinityMask(GetCurrentProcess,a1,a2) then
   for i:=0 to 31 do
   if (1 shl i) and a1 <> 0 then begin       // Find 1-st available CPU
    SetThreadAffinityMask(t.Handle,1 shl i); // and set thread affinity
    Break;
   end;
   t.Resume;
   t.WaitFor;
   Result:=t.FreqMHz;
  finally
   Kill(TThread(t));
  end;
 except
  on E:Exception do BugReport(E);
 end;
end;

 {
 *************************************
 Get/SetClockResolution implementation
 *************************************
 }
const
 hNtDll : HINST = 0;
 _NtSetTimerResolution : function(RequestedResolution:DWORD; SetResolution:BOOL;
    var ActualResolution:DWORD) : LongInt stdcall = nil;
 _NtQueryTimerResolution : function(var MinimumResolution, MaximumResolution,
    ActualResolution:DWORD) : LongInt stdcall = nil;

procedure ExitNtDll;
begin
 try
  if hNtDll <> 0 then FreeLibrary(hNtDll);
  _NtQueryTimerResolution:=nil;
  _NtSetTimerResolution:=nil;
  hNtDll:=0;
 except
  on E:Exception do BugReport(E);
 end;
end;

procedure InitNtDll;
begin
 if Win32Platform >= VER_PLATFORM_WIN32_NT then
 try
  if hNtDll=0 then begin
   hNtDll := LoadLibrary(PChar('ntdll.dll'));
   if hNtDll <> 0 then begin
    @_NtSetTimerResolution := GetProcAddress(hNtDll, PChar('NtSetTimerResolution'));
    @_NtQueryTimerResolution := GetProcAddress(hNtDll, PChar('NtQueryTimerResolution'));
    if not Assigned(_NtSetTimerResolution) then ExitNtDll;
    if not Assigned(_NtQueryTimerResolution) then ExitNtDll;
   end;
  end;
 except
  on E:Exception do BugReport(E);
 end;
end;

function NtSetTimerResolution(RequestedResolution:DWORD; SetResolution:BOOL;
    var ActualResolution:DWORD) : LongInt stdcall;
begin
 Result:=LongInt($C0000001); // STATUS_UNSUCCESSFUL
 try
  if Assigned(_NtSetTimerResolution) then
  Result:=_NtSetTimerResolution(RequestedResolution, SetResolution, ActualResolution);
 except
  on E:Exception do BugReport(E);
 end;
end;

function NtQueryTimerResolution(var MinimumResolution, MaximumResolution,
    ActualResolution:DWORD) : LongInt stdcall;
begin
 Result:=LongInt($C0000001); // STATUS_UNSUCCESSFUL
 try
  if Assigned(_NtQueryTimerResolution) then
  Result:=_NtQueryTimerResolution(MinimumResolution, MaximumResolution, ActualResolution);
 except
  on E:Exception do BugReport(E);
 end;
end;

function GetClockResolution(What:Integer):LongInt;
var
 Adj,StdRes,MinRes,MaxRes,ActRes:DWORD; AdjDisabled:BOOL;
begin
 Result:=0;
 if Win32Platform >= VER_PLATFORM_WIN32_NT then
 try
  case What of
   cr_StdRes: if GetSystemTimeAdjustment(Adj,StdRes,AdjDisabled) then Result:=StdRes;
   cr_MinRes: if NtQueryTimerResolution(MinRes,MaxRes,ActRes)>=0 then Result:=MinRes;
   cr_MaxRes: if NtQueryTimerResolution(MinRes,MaxRes,ActRes)>=0 then Result:=MaxRes;
   cr_ActRes: if NtQueryTimerResolution(MinRes,MaxRes,ActRes)>=0 then Result:=ActRes;
  end;
 except
  on E:Exception do BugReport(E);
 end;
end;

function SetClockResolution(NewRes:LongInt):LongInt;
var
 ActRes:DWORD;
begin
 Result:=0;
 if NewRes<>0 then
 if Win32Platform >= VER_PLATFORM_WIN32_NT then
 try
  if NtSetTimerResolution(Abs(NewRes),(NewRes>0),ActRes)>=0 then Result:=ActRes;
 except
  on E:Exception do BugReport(E);
 end;
end;

 {
 ***********************
 MkSecNow implementation
 ***********************
 }
var
 FixPerformanceFrequency : Int64;
 FixPerformanceCounter   : Int64;
 FixPerformanceFactor    : Extended;

procedure InitializeMkSecNow;
begin
 if QueryPerformanceCounter(FixPerformanceCounter) and
    QueryPerformanceFrequency(FixPerformanceFrequency) and
    (FixPerformanceFrequency>0)
 then FixPerformanceFactor:=1000000.0/FixPerformanceFrequency
 else begin
  FixPerformanceFrequency:=0;
  FixPerformanceCounter:=0;
  FixPerformanceFactor:=0;
 end;
end;

function MkSecNow:Extended;
var
 PerformanceCounter : Int64;
begin
 if QueryPerformanceCounter(PerformanceCounter) then begin
  Dec(PerformanceCounter,FixPerformanceCounter);
  Result:=PerformanceCounter*FixPerformanceFactor;
 end else Result:=0;
end;

initialization

 InitNtDll;
 InitializeMSecNow;
 InitializeMkSecNow;

finalization

 FinalizeMSecNow;
 ExitNtDll;

end.
