 {
 Standard routines for Vector:
 function  iVec_Init(n:Integer):String;
 function  rVec_Init(n:Integer):String;
 procedure iVec_Free(var vec:String);
 procedure rVec_Free(var vec:String);
 function  iVec_Get(var vec:String; i:Integer):Integer;
 function  rVec_Get(var vec:String; i:Integer):Real;
 procedure iVec_Set(var vec:String; i:Integer; data:Integer);
 procedure rVec_Set(var vec:String; i:Integer; data:Real);
 function  iVec_Length(var vec:String):Integer;
 function  rVec_Length(var vec:String):Integer;
 procedure iVec_SetLength(var vec:String; n:Integer);
 procedure rVec_SetLength(var vec:String; n:Integer);
 procedure ClearStdTools;
 procedure InitStdTools;
 procedure FreeStdTools;
 procedure PollStdTools;
 }
 {
 Allocate the string buffer for vector
 }
 function iVec_Init(n:Integer):String;
 begin
  if (n>0)
  then iVec_Init:=StringOfChar(Chr(0),n*SizeOfInteger)
  else iVec_Init:='';
 end;
 function rVec_Init(n:Integer):String;
 begin
  if (n>0)
  then rVec_Init:=StringOfChar(Chr(0),n*SizeOfReal)
  else rVec_Init:='';
 end;
 {
 Free/Clear the string buffer of vector
 }
 procedure iVec_Free(var vec:String);
 begin
  vec:='';
 end;
 procedure rVec_Free(var vec:String);
 begin
  vec:='';
 end;
 {
 Get vector element value by index i
 }
 function iVec_Get(var vec:String; i:Integer):Integer;
 begin
  iVec_Get:=iGetDump(vec,i*SizeOfInteger);
 end;
 function rVec_Get(var vec:String; i:Integer):Real;
 begin
  rVec_Get:=rGetDump(vec,i*SizeOfReal);
 end;
 {
 Set vector element value by index i
 }
 procedure iVec_Set(var vec:String; i:Integer; data:Integer);
 begin
  if not iSetDump(vec,i*SizeOfInteger,data)
  then iVec_ErrorsCount:=iVec_ErrorsCount+1;
 end;
 procedure rVec_Set(var vec:String; i:Integer; data:Real);
 begin
  if not rSetDump(vec,i*SizeOfReal,data)
  then rVec_ErrorsCount:=rVec_ErrorsCount+1;
 end;
 {
 Returns the length of vector (vec).
 }
 function iVec_Length(var vec:String):Integer;
 begin
  iVec_Length:=(Length(vec) div SizeOfInteger);
 end;
 function rVec_Length(var vec:String):Integer;
 begin
  rVec_Length:=(Length(vec) div SizeOfReal);
 end;
 {
 Set new vector (vec) length (n).
 }
 procedure iVec_SetLength(var vec:String; n:Integer);
 var newlen,oldlen:Integer;
 begin
  if (n>0) then begin
   oldlen:=Length(vec);
   newlen:=n*SizeOfInteger;
   if (newlen<>oldlen) then begin
    if (newlen<oldlen) then vec:=copy(vec,1,newlen)
    else vec:=vec+StringOfChar(Chr(0),newlen-oldlen);
   end;
  end else vec:='';
 end;
 procedure rVec_SetLength(var vec:String; n:Integer);
 var newlen,oldlen:Integer;
 begin
  if (n>0) then begin
   oldlen:=Length(vec);
   newlen:=n*SizeOfReal;
   if (newlen<>oldlen) then begin
    if (newlen<oldlen) then vec:=copy(vec,1,newlen)
    else vec:=vec+StringOfChar(Chr(0),newlen-oldlen);
   end;
  end else vec:='';
 end;
 {
 Clear standard Vector.
 }
 procedure ClearStdVector;
 begin
 end;
 {
 Initialize standard Vector.
 }
 procedure InitStdVector;
 begin
  ShouldPollStdVector:=false;
  iVec_ErrorsCount:=0;
  rVec_ErrorsCount:=0;
 end;
 {
 Finalize standard Vector.
 }
 procedure FreeStdVector;
 begin
 end;
 {
 Poll standard Vector.
 }
 procedure PollStdVector;
 begin
 end;
