 {
 Standard routines for StdPyApp:
 procedure StdPyApp_Clear;
 function  StdPyApp_Started:Boolean;
 function  StdPyApp_Running:Boolean;
 function  StdPyApp_ValidToStart:Boolean;
 procedure StdPyApp_Send(msg:String);
 procedure StdPyApp_Take(var data:String);
 procedure StdPyApp_Stop;
 procedure StdPyApp_TaskStatusReport;
 procedure StdPyApp_ServerStatusReport;
 procedure StdPyApp_Start;
 procedure StdPyApp_Control(arg:String);
 procedure StdPyApp_HandlePollCount(var arg:String);
 function  StdPyApp_DefaultHookStdIn(var Data:String):Boolean;
 procedure StdPyApp_Init;
 procedure StdPyApp_Poll;
 procedure StdPyApp_Free;
 procedure RegisterStdPyApp;
 procedure ClearStdPyApp;
 procedure InitStdPyApp;
 procedure FreeStdPyApp;
 procedure PollStdPyApp;
 }
 {
 StdPyApp - clear data table.
 }
 procedure StdPyApp_Clear;
 begin
  StdPyApp.Tid:=0;
  StdPyApp.Buff:='';
  StdPyApp.Line:='';
  StdPyApp.Launch:='';
  StdPyApp.Script:='';
  StdPyApp.Params:='';
  StdPyApp.PingCall:='';
  StdPyApp.PipeSizeKb:=0;
  StdPyApp.TimeOutToSend:=0;
  StdPyApp.AutoStart:=False;
  StdPyApp.PreferToSend:=False;
  StdPyApp.TimeoutToStop:=0;
  StdPyApp.GuardTimerPeriod:=0;
  StdPyApp.PingTimerPeriod:=0;
  StdPyApp.PollCount:=0;
  StdPyApp.PollTime:=0;
  StdPyApp.PollRate:=0;
  StdPyApp.PingTime:=0;
  StdPyApp.PingWhen:=0;
  StdPyApp.CalcPing:=False;
  StdPyApp.RamRss:=0;
  StdPyApp.RamVms:=0;
  StdPyApp.RamGc:='';
  StdPyApp.RamGcWhen:=0;
  StdPyApp.strStat:='';
  StdPyApp.tagStat:=0;
 end;
 {
 StdPyApp - check is started.
 }
 function StdPyApp_Started:Boolean;
 begin
  StdPyApp_Started:=(StdPyApp.Tid<>0);
 end;
 {
 StdPyApp - check is running.
 }
 function StdPyApp_Running:Boolean;
 begin
  if (StdPyApp.Tid<>0)
  then StdPyApp_Running:=task_wait(StdPyApp.Tid,0)
  else StdPyApp_Running:=false;
 end;
 {
 StdPyApp - check parameters is valid to Start.
 }
 function StdPyApp_ValidToStart:Boolean;
 var nerr:Integer;
 begin
  nerr:=0;
  if IsEmptyStr(StdPyApp.Script) then begin
   Details('Error: PyApp Script is empty.');
   nerr:=nerr+1;
  end else
  if not FileExists(StdPyApp.Script) then begin
   Details('Error: PyApp Script not found.');
   nerr:=nerr+1;
  end;
  if (StdPyApp.PipeSizeKb<1) then begin
   Details('Error: PyApp PipeSizeKb invalid.');
   nerr:=nerr+1;
  end;
  if (StdPyApp.TimeOutToSend<0) then begin
   Details('Error: PyApp TimeOutToSend invalid.');
   nerr:=nerr+1;
  end;
  if (StdPyApp.TimeOutToStop<1) then begin
   Details('Error: PyApp TimeOutToStop invalid.');
   nerr:=nerr+1;
  end;
  if (StdPyApp.GuardTimerPeriod<1) then begin
   Details('Error: PyApp GuardTimerPeriod invalid.');
   nerr:=nerr+1;
  end;
  if (StdPyApp.PingTimerPeriod<0) then begin
   Details('Error: PyApp PingTimerPeriod invalid.');
   nerr:=nerr+1;
  end;
  StdPyApp_ValidToStart:=(nerr=0);
 end;
 {
 StdPyApp - send message to task StdIn stream.
 Wait for some time if transmitter FIFO is over.
 Multiline messages allowed (send line by line).
 }
 procedure StdPyApp_Send(msg:String);
 var Deadline:Real; p:Integer;
 begin
  if (StdPyApp.Tid<>0) then
  if (msg<>'') then begin
   p:=PosEol(msg,1,0);
   if (p>0) then begin
    StdPyApp_Send(Copy(msg,1,p-1));
    StdPyApp_Send(Copy(msg,PosEol(msg,1,1)));
   end else begin
    if (task_txspace(StdPyApp.Tid)<Length(msg)) then begin
     Deadline:=msecnow+StdPyApp.TimeOutToSend;
     while(msecnow<Deadline) and (task_txspace(StdPyApp.Tid)<Length(msg)) do bNul(Sleep(1));
    end;
    if (task_send(StdPyApp.Tid,msg+EOL)=0)
    then Trouble('PyApp: Send error!')
    else if DebugFlagEnabled(dfViewExp) then ViewExp('PYA: '+msg);
   end;
  end;
 end;
 {
 StdPyApp - take data from task stdout stream.
 Process data coming from PyApp task stdout.
 Post data to device stdin as '@PyAns data'.
 }
 procedure StdPyApp_Take(var data:String);
 var sent:Real;
 begin
  if (devMySelf<>0) then
  if (data<>'') then begin
   if StdPyApp.PreferToSend
   then sent:=devSend(devMySelf,'@PyAns '+data+EOL)
   else sent:=devPost(devMySelf,'@PyAns '+data+EOL);
   if (sent<1) then Trouble('PyApp: StdIn overflow.');
  end;
 end;
 {
 StdPyApp - stop server task if one started.
 Send '@PyInf Stopped ..' to device stdin.
 }
 procedure StdPyApp_Stop;
 var Deadline:Real; pid,code:Integer;
 begin
  if (StdPyApp.Tid<>0) then begin
   if task_wait(StdPyApp.Tid,0) then begin
    Deadline:=mSecNow+StdPyApp.TimeoutToStop;
    while task_wait(StdPyApp.Tid,0) and (mSecNow<Deadline) do begin
     StdPyApp_Send('@Exit');
     bNul(Sleep(4));
    end;
    if task_wait(StdPyApp.Tid,0) then bNul(task_kill(StdPyApp.Tid,1,0,StdPyApp.TimeoutToStop));
    if task_wait(StdPyApp.Tid,0) then bNul(task_kill(StdPyApp.Tid,0,0,StdPyApp.TimeoutToStop));
    if (task_rxcount(StdPyApp.Tid)>0) then
    while Task_Readln(StdPyApp.Tid,StdPyApp.Line,StdPyApp.Buff) do StdPyApp_Take(StdPyApp.Line);
    pid:=task_pid(StdPyApp.Tid); code:=task_result(StdPyApp.Tid);
    DevPostCmdLocal('@PyInf Stopped PID '+Str(pid)+' CODE '+Str(code));
   end;
   FreeAndZero(StdPyApp.Tid);
  end;
  StdPyApp.Tid:=0;
  StdPyApp.Buff:='';
  StdPyApp.Line:='';
 end;
 {
 StdPyApp - print status report on task.
 }
 procedure StdPyApp_TaskStatusReport;
 begin
  if StdPyApp_Running then begin
   Success('TaskId  = '+str(StdPyApp.Tid));
   Success('TaskPid = '+str(task_pid(StdPyApp.Tid)));
   Success('TaskRef = '+str(task_ref(StdPyApp.Tid)));
   Success('CmdLine = '+task_ctrl(StdPyApp.Tid,'CmdLine'));
   Success('HomeDir = '+task_ctrl(StdPyApp.Tid,'HomeDir'));
   Success('PipeIn  = '+task_ctrl(StdPyApp.Tid,'StdInPipeSize'));
   Success('PipeOut = '+task_ctrl(StdPyApp.Tid,'StdOutPipeSize'));
   Success('IPrior. = '+task_ctrl(StdPyApp.Tid,'StdInPriority'));
   Success('OPrior. = '+task_ctrl(StdPyApp.Tid,'StdOutPriority'));
   Success('TPrior. = '+task_ctrl(StdPyApp.Tid,'ThreadPriority'));
   Success('PPrior. = '+task_ctrl(StdPyApp.Tid,'ProcessPriority'));
   Success('Display = '+task_ctrl(StdPyApp.Tid,'Display'));
  end;
 end;
 {
 StdPyApp - print status report on server.
 }
 procedure StdPyApp_ServerStatusReport;
 begin
  Success('PyApp parameters:');
  Success('@PyApp Set Launch '+StdPyApp.Launch);
  Success('@PyApp Set Script '+StdPyApp.Script);
  Success('@PyApp Set Params '+StdPyApp.Params);
  Success('@PyApp Set PingCall '+StdPyApp.PingCall);
  Success('@PyApp Set AutoStart '+Str(Ord(StdPyApp.AutoStart)));
  Success('@PyApp Set PipeSizeKb '+Str(StdPyApp.PipeSizeKb));
  Success('@PyApp Set PreferToSend '+Str(Ord(StdPyApp.PreferToSend)));
  Success('@PyApp Set TimeOutToSend '+Str(StdPyApp.TimeOutToSend));
  Success('@PyApp Set TimeOutToStop '+Str(StdPyApp.TimeOutToStop));
  Success('@PyApp Set GuardTimerPeriod '+Str(StdPyApp.GuardTimerPeriod));
  Success('@PyApp Set PingTimerPeriod '+Str(StdPyApp.PingTimerPeriod));
  Success('@PyApp Set CalcPing '+Str(Ord(StdPyApp.CalcPing)));
  if StdPyApp_Running
  then Success('PyApp: server task is RUNNING.')
  else Success('PyApp: server task is STOPPED.');
 end;
 {
 StdPyApp - start server if one not started.
 }
 procedure StdPyApp_Start;
 var i,txt:Integer; b:Boolean; s:String;
 begin
  s:='';
  if (StdPyApp.Tid=0) then begin
   {
   Initialize StdPyApp task, run it invisible...
   }
   if StdPyApp_ValidToStart then begin
    StdPyApp.Tid:=task_init(Trim(StdPyApp.Launch+' '+StdPyApp.Script+' '+StdPyApp.Params));
    if pos('?',task_ctrl(StdPyApp.Tid,'HomeDir='+ExtractFilePath(StdPyApp.Script))
              +task_ctrl(StdPyApp.Tid,'StdInPipeSize='+str(StdPyApp.PipeSizeKb*1024))
              +task_ctrl(StdPyApp.Tid,'StdOutPipeSize='+str(StdPyApp.PipeSizeKb*1024))
              +task_ctrl(StdPyApp.Tid,'Display=0')
           )>0
    then begin
     Trouble('PyApp: User task setup error!');
     StdPyApp_Stop;
    end;
   end else begin
    Trouble('PyApp: Parameters is not valid to start.');
    StdPyApp_Stop;
   end;
   {
   Set CodePage for non-Unicode system.
   }
   if IsWindows and (StdPyApp.Tid<>0)
   then sNul(task_ctrl(StdPyApp.Tid,'CodePage='+ParamStr('OemCodePage')));
   {
   Run task if one was created...
   }
   if (StdPyApp.Tid<>0) then
   if task_run(StdPyApp.Tid) then begin
    StdPyApp_TaskStatusReport;
    DevPostCmdLocal('@PyInf Started PID '+Str(task_pid(StdPyApp.Tid)));
   end else begin
    Trouble('PyApp: Could not start Server!');
    StdPyApp_Stop;
   end;
   {
   Is it Ok with user task? Send preset parameters.
   }
   if FALSE then // SKIP_DRAFT
   if StdPyApp_Started then
   if StdPyApp_Running then begin
    s:=ReadIni('StartupScript');
    txt:=ReadIniSection(text_new,28,'',s);
    for i:=0 to text_numln(txt)-1 do begin
     s:=text_getln(txt,i);
     if IsSameText(ExtractWord(1,s),'@PyApp')
     then DevSendCmd(devMySelf,s);
    end;
    bNul(text_free(txt));
    //DevSendCmd(devMySelf,'@StartupScript');
   end else Trouble('PyApp: Could not config Server!');
  end;
  s:='';
 end;
 {
 StdPyApp Control command: 
 @PyApp Stop                               ; Stop    PyApp task
 @PyApp Start                              ; Start   PyApp task
 @PyApp Status                             ; Status  PyApp task
 @PyApp Restart                            ; Restart PyApp task
 @PyApp Set Launch unix pyvenv             ; Command to launch script
 @PyApp Set Script ..\daqpas\demo_pycon.py ; Target script pathname
 @PyApp Set Params                         ; Script parameters
 @PyApp Set PingCall @PollCount            ; Set ping command
 @PyApp Add PingCall @Memory               ; Add ping command
 @PyApp Set AutoStart 1                    ; Enable AutoStart
 @PyApp Set PipeSizeKb 64                  ; IO pipe size, kb
 @PyApp Set PreferToSend 0                 ; 0:devPost, 1:devSend
 @PyApp Set TimeOutToSend 100              ; Timeout to send data, ms
 @PyApp Set TimeOutToStop 1000             ; Timeout to stop task, ms
 @PyApp Set GuardTimerPeriod 1000          ; Timer period to AutoStart
 @PyApp Set PingTimerPeriod 1000           ; Timer for PingCall
 @PyApp Set CalcPing 1                     ; Flag - calculate Ping
 }
 procedure StdPyApp_Control(arg:String);
 var p:Integer;
  procedure SetBool(arg,id:String; var b:Boolean);
  var iv:Integer;
  begin
   if IsSameText(ExtractWord(2,arg),id) then begin
    iv:=iValDef(ExtractWord(3,arg),-1);
    if (iv>=0) then b:=(iv>0);
    Details('@PyApp Set '+id+' '+Str(Ord(b)));
   end;
  end;
  procedure SetInts(arg,id:String; var i:Integer; a,b:Integer);
  var rv:Real;
  begin
   if IsSameText(ExtractWord(2,arg),id) then begin
    rv:=rVal(ExtractWord(3,arg));
    if not IsNan(rv) and not IsInf(rv) then
    if (a=b) or ((rv>=a) and (rv<=b)) then i:=Round(rv);
    Details('@PyApp Set '+id+' '+Str(i));
   end;
  end;
  procedure SetText(arg,id:String; var s:String; env:Boolean);
  begin
   if IsSameText(ExtractWord(2,arg),id) then begin
    if (WordCount(arg)>2) then begin
     s:=Trim(SkipWords(2,arg));
     if env then s:=ExpEnv(s);
    end;
    Details('@PyApp Set '+id+' '+s);
   end;
  end;
  procedure AddText(arg,id:String; var s:String; env:Boolean);
  var a:String;
  begin
   a:=s;
   if IsSameText(ExtractWord(2,arg),id) then begin
    if (WordCount(arg)>2) then begin
     s:=Trim(SkipWords(2,arg));
     if env then s:=ExpEnv(s);
     if (a<>'') then s:=a+EOL+s;
    end;
    Details('@PyApp Set '+id+' '+s);
   end;
   a:='';
  end;
  procedure SetFile(arg,id:String; var s:String; env:Boolean);
  begin
   if IsSameText(ExtractWord(2,arg),id) then begin
    if (WordCount(arg)>2) then begin
     s:=Trim(SkipWords(2,arg));
     if env then s:=ExpEnv(s);
     s:=DaqFileRef(s,'');
    end;
    Details('@PyApp Set '+id+' '+s);
   end;
  end;
 begin
  if (arg<>'') then begin
   p:=PosEol(arg,1,0);
   if (p>0) then begin
    StdPyApp_Control(Copy(arg,1,p-1));
    StdPyApp_Control(Copy(arg,PosEol(arg,1,1)));
   end else
   if IsSameText(ExtractWord(1,arg),'@PyApp') then begin
    arg:=Trim(SkipWords(1,arg));
    if not IsEmptyStr(arg) then begin
     if IsSameText(ExtractWord(1,arg),'Set') then begin
      SetBool(arg, 'CalcPing',         StdPyApp.CalcPing);
      SetBool(arg, 'AutoStart',        StdPyApp.AutoStart);
      SetBool(arg, 'PreferToSend',     StdPyApp.PreferToSend);
      SetInts(arg, 'PipeSizeKb',       StdPyApp.PipeSizeKb,       1, 65536);
      SetInts(arg, 'TimeOutToSend',    StdPyApp.TimeOutToSend,    0, 1000);
      SetInts(arg, 'TimeOutToStop',    StdPyApp.TimeOutToStop,    1, 5000);
      SetInts(arg, 'GuardTimerPeriod', StdPyApp.GuardTimerPeriod, 1, 60000);
      SetInts(arg, 'PingTimerPeriod',  StdPyApp.PingTimerPeriod,  0, 60000);
      SetText(arg, 'PingCall',         StdPyApp.PingCall, true);
      SetText(arg, 'Launch',           StdPyApp.Launch, true);
      SetFile(arg, 'Script',           StdPyApp.Script, true);
      SetText(arg, 'Params',           StdPyApp.Params, true);
     end else
     if IsSameText(ExtractWord(1,arg),'Add') then begin
      AddText(arg, 'PingCall',        StdPyApp.PingCall, true);
     end else
     if IsSameText(ExtractWord(1,arg),'Status') then begin
      StdPyApp_ServerStatusReport;
      StdPyApp_TaskStatusReport;
     end else
     if IsSameText(ExtractWord(1,arg),'Restart') then begin
      if StdPyApp_Started then StdPyApp_Stop;
      if not StdPyApp_Started then StdPyApp_Start;
     end else
     if IsSameText(ExtractWord(1,arg),'Start') then begin
      if not StdPyApp_Started then StdPyApp_Start;
     end else
     if IsSameText(ExtractWord(1,arg),'Stop') then begin
      if StdPyApp_Started then StdPyApp_Stop;
     end;
    end;
   end;
  end;
 end;
 {
 StdPyApp - handle @PollCount, @Memory and @PingEcho.
 }
 procedure StdPyApp_HandlePollCount(var arg:String);
 var pc,pr,pt,dc,dt,pp,mk:Real; up:Boolean;
 begin
  up:=false;
  if (arg<>'') then begin
   if IsSameText(ExtractWord(1,arg),'@Memory') then begin
    StdPyApp.RamGc:=SkipWords(1,arg); // memory params rss=…;vms=…;gc=…;
    StdPyApp.RamRss:=rValDef(CookieScan(StdPyApp.RamGc,'rss',Ord(';')),0);
    StdPyApp.RamVms:=rValDef(CookieScan(StdPyApp.RamGc,'vms',Ord(';')),0);
    StdPyApp.RamGc:=Trim(CookieScan(StdPyApp.RamGc,'gc',Ord(';')));
    StdPyApp.RamGcWhen:=mSecNow;
    up:=True;
   end else
   if IsSameText(ExtractWord(1,arg),'@PingEcho') then begin
    mk:=0; pt:=rVal(ExtractWord(2,arg));
    if StdPyApp.CalcPing then mk:=mkSecNow;
    pp:=(mk-pt)*Ord(StdPyApp.CalcPing)*1e-3;
    StdPyApp.PingTime:=pp;
    StdPyApp.PingWhen:=mSecNow;
    up:=True;
   end else
   if IsSameText(ExtractWord(1,arg),'@PollCount') then begin
    pc:=rVal(ExtractWord(2,arg)); pt:=mSecNow;
    dc:=(pc-StdPyApp.PollCount);
    dt:=(pt-StdPyApp.PollTime);
    pp:=StdPyApp.PingTime;
    pr:=1e3*dc/dt;
    StdPyApp.PollCount:=pc;
    StdPyApp.PollRate:=pr;
    StdPyApp.PollTime:=pt;
    Details(StrFmt('PyApp: PollRate %1.0f poll/sec',pr)
           +StrFmt(' PingTime %1.3f ms',pp));
    up:=True;
   end;
  end;
  if up then begin
   StdPyApp.strStat:=StrFmt('rss=%g;',StdPyApp.RamRss)
                    +StrFmt('vms=%g;',StdPyApp.RamVms)
                    +StrFmt('gc=%s,',StdPyApp.RamGc)
                    +StrFmt('%g;',StdPyApp.RamGcWhen)
                    +StrFmt('poll=%g,',StdPyApp.PollCount)
                    +StrFmt('%.7g,',StdPyApp.PollRate)
                    +StrFmt('%g;',StdPyApp.PollTime)
                    +StrFmt('ping=%.7g,',StdPyApp.PingTime)
                    +StrFmt('%g;',StdPyApp.PingWhen);
   if (StdPyApp.tagStat<>0) then begin
    bNul(sSetTag(StdPyApp.tagStat,StdPyApp.strStat));
   end;
  end;
 end;
 {
 StdPyApp - Default Hook for StdIn commands.
 }
 function StdPyApp_DefaultHookStdIn(var Data:String):Boolean;
 var cmd,arg:String; cmdid:Integer; Hook:Boolean;
 begin
  cmd:=''; arg:='';
  Hook:=False; cmdid:=0;
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   if (cmdid=cmd_Std_PyApp) then begin
    StdPyApp_Control(Data);
    Hook:=True;
   end else
   if (cmdid=cmd_Std_PyAsk) then begin
    if DebugFlagEnabled(dfViewExp)
    then ViewExp('PYA: '+Data);
    StdPyApp_Send(arg);
    Hook:=True;
   end else
   if (cmdid=cmd_Std_PyAns) then begin
    StdPyApp_HandlePollCount(arg);
    if DebugFlagEnabled(dfViewImp)
    then ViewImp('PYA: '+Data);
    Hook:=True;
   end else
   if (cmdid=cmd_Std_PyInf) then begin
    Success('PyApp: '+arg);
    Hook:=True;
   end;
  end;
  StdPyApp_DefaultHookStdIn:=Hook;
  cmd:=''; arg:='';
 end;
 {
 StdPyApp - initialize table.
 }
 procedure StdPyApp_Init;
  procedure StdPyApp_InitTags(id:String);
  begin
   if (id<>'') then begin
    InitTag(StdPyApp.tagStat,id,-3);
   end;
  end;
 begin
  StdPyApp_Clear; // Clear and set default parameters
  StdPyApp_Control('@PyApp Set Launch unix pyvenv             '+EOL
                  +'@PyApp Set Script ..\daqpas\demo_pycon.py '+EOL
                  +'@PyApp Set Params                         '+EOL
                  +'@PyApp Set PingCall @PollCount            '+EOL
                  +'@PyApp Add PingCall @Memory               '+EOL
                  +'@PyApp Set AutoStart 1                    '+EOL
                  +'@PyApp Set PipeSizeKb 64                  '+EOL
                  +'@PyApp Set PreferToSend 0                 '+EOL
                  +'@PyApp Set TimeOutToSend 100              '+EOL
                  +'@PyApp Set TimeOutToStop 1000             '+EOL
                  +'@PyApp Set GuardTimerPeriod 5000          '+EOL
                  +'@PyApp Set PingTimerPeriod 1000           '+EOL
                  +'@PyApp Set CalcPing 1                     '+EOL
                  );
  StdPyApp_InitTags(ReadIni('tagStdPyAppStat'));
 end;
 {
 StdPyApp - polling.
 }
 procedure StdPyApp_Poll;
 begin
  {
  If PyApp server is not still running,
  try to start PyApp server periodically.
  }
  if (StdPyApp.Tid=0) then
  if StdPyApp.AutoStart then
  if SysTimer_Pulse(StdPyApp.GuardTimerPeriod)>0 then StdPyApp_Start;
  {
  Communicate with PyApp server if one still running...
  }
  if (StdPyApp.Tid<>0) then
  if task_wait(StdPyApp.Tid,0) then begin
   {
   If has data coming from Task StdOut, analyse it...
   }
   if task_rxcount(StdPyApp.Tid)>0 then begin
    while Task_Readln(StdPyApp.Tid,StdPyApp.Line,StdPyApp.Buff)
    do StdPyApp_Take(StdPyApp.Line);
   end;
   {
   Periodically send Ping
   }
   if StdPyApp.PingTimerPeriod>0 then
   if SysTimer_Pulse(StdPyApp.PingTimerPeriod)>0 then begin
    if StdPyApp.CalcPing then StdPyApp_Send('@PingEcho '+Str(mkSecNow));
    StdPyApp_Send(StdPyApp.PingCall);
   end;
  end else begin
   Trouble('PyApp: Terminated, exit code = '+str(task_result(StdPyApp.Tid)));
   StdPyApp_Stop;
  end;
 end;
 {
 Finalize PyApp task.
 }
 procedure StdPyApp_Free;
 begin
  StdPyApp_Stop;
  StdPyApp_Clear;
 end;
 {
 Register commands for Standard PyApp.
 }
 procedure RegisterStdPyApp;
 begin
  cmd_Std_PyApp:=RegisterStdInCmd('@PyApp','control for PyApp');
  cmd_Std_PyAsk:=RegisterStdInCmd('@PyAsk','send xxx to PyApp');
  cmd_Std_PyAns:=RegisterStdInCmd('@PyAns','answer from PyApp');
  cmd_Std_PyInf:=RegisterStdInCmd('@PyInf','inform from PyApp');
 end;
 {
 Clear standard PyApp.
 }
 procedure ClearStdPyApp;
 begin
  StdPyApp_Clear;
 end;
 {
 Initialize standard PyApp.
 }
 procedure InitStdPyApp;
 begin
  StdPyApp_Init;
  RegisterStdPyApp;
  ShouldPollStdPyApp:=false;
 end;
 {
 Finalize standard PyApp.
 }
 procedure FreeStdPyApp;
 begin
  StdPyApp_Free;
 end;
 {
 Poll standard PyApp.
 }
 procedure PollStdPyApp;
 begin
  StdPyApp_Poll;
 end;
