 {
 Standard routines for DLLs:
 procedure DLL_FREE(var hDll:Integer);
 function  DLL_INIT(DllPath:String):Integer;
 procedure DLL_POLL(hDll:Integer);
 procedure STD_DLL_CLEAR;
 procedure STD_DLL_FREE;
 function  STD_DLL_FILE_PATH(arg:String):String;
 procedure STD_DLL_INIT(arg:String);
 procedure STD_DLL_POLL;
 procedure ClearStdDLLs;
 procedure InitStdDLLs;
 procedure FreeStdDLLs;
 procedure PollStdDLLs;
 }
 {
 Free DLL instance.
 }
 procedure DLL_FREE(var hDll:Integer);
 var stop,done:Boolean;
 begin
  if (hDll<>0) then begin
   stop:=DaqDllCall(hDll,DAQ_CMD_FREE);
   Assertion(stop,'DLL_STOP');
   done:=DaqDllFree(hDll);
   Assertion(done,'DLL_FREE');
   hDll:=0;
  end;
 end;
 {
 Initialize DLL and return reference of instance or 0.
 }
 function DLL_INIT(DllPath:String):Integer;
 var hDll,nErr:Integer; init:Boolean; DllName:String;
 begin
  hDll:=DaqDllInit(DllPath);
  DllName:=ExtractFileName(DllPath);
  DllName:=DllName+ExtractFileExt(DllPath);
  if IsWindows then DllName:=LoCaseStr(DllName);
  Assertion((hDll<>0),'DLL_LOAD '+DllName);
  if (hDll<>0) then begin
   init:=DaqDllCall(hDll,DAQ_CMD_INIT);
   Assertion(init,'DLL_INIT '+DllName);
   if not init then DLL_FREE(hDll);
  end;
  if (hDll=0) then begin
   nErr:=RegisterErr('Fail load '+DllName+' !');
   bNul(FixError(nErr));
  end;
  DllName:='';
  DllPath:='';
  DLL_INIT:=hDll;
 end;
 {
 Polling actions for DLL.
 }
 procedure DLL_POLL(hDll:Integer);
 var cond:Boolean;
 begin
  if (hDll<>0) then begin
   cond:=DaqDllCall(hDll,DAQ_CMD_POLL);
   if not cond then Trouble('DLL_POLL');
  end;
 end;
 {
 Standard DLL cleaning.
 }
 procedure STD_DLL_CLEAR;
 begin
  STD_DLL_REF:=0;
 end;
 {
 Standard DLL finalization.
 }
 procedure STD_DLL_FREE;
 begin
  DLL_FREE(STD_DLL_REF);
  ShouldPollStdDlls:=false;
 end;
 {
 Standard DLL file path by config parameter (arg).
 On empty arg uses parameter DLL_FILE_PATH.
 }
 function STD_DLL_FILE_PATH(arg:String):String;
 var s:String;
 begin
  arg:=TrimDef(arg,'DLL_FILE_PATH');
  s:=AdaptDllFileName(ReadIni(arg));
  s:=DaqFileRef(s,''); arg:='';
  STD_DLL_FILE_PATH:=s;
  s:='';
 end;
 {
 Standard DLL initialization.
 arg is inifile parameter of DLL file path.
 On empty arg uses parameter DLL_FILE_PATH.
 }
 procedure STD_DLL_INIT(arg:String);
 begin
  STD_DLL_FREE;
  arg:=STD_DLL_FILE_PATH(Trim(arg));
  STD_DLL_REF:=DLL_INIT(arg);
  ShouldPollStdDlls:=(STD_DLL_REF<>0);
 end;
 {
 Standard DLL polling.
 }
 procedure STD_DLL_POLL;
 begin
  DLL_POLL(STD_DLL_REF);
 end;
 {
 Clear standard DLLs.
 }
 procedure ClearStdDLLs;
 begin
  STD_DLL_CLEAR;
 end;
 {
 Initialize standard DLLs.
 }
 procedure InitStdDLLs;
 begin
  ShouldPollStdDlls:=false;
 end;
 {
 Finalize standard DLLs.
 }
 procedure FreeStdDLLs;
 begin
  STD_DLL_FREE;
 end;
 {
 Poll standard DLLs.
 }
 procedure PollStdDLLs;
 begin
  STD_DLL_POLL;
 end;
