 {
 ***************************************************************************
 Универсальная программа для сохранения данных в формате CRW по требованию.
 Для сохранения даных есть два способа: старый и новый, как удобнее
 1)Внешняя программа взводит тег запроса WriteEnableTag, программа _crwsave
   по тегу запроса сохраняет данные и затем сбрасывает тег.
   Получается как бы "фотоснимок" интересующих данных.
 2)Внешняя программа шлет сообщения:
      Save Windows WINDOW1,WINDOW2...
      Save CurveList CURVE1,CURVE2,...
   При этом список указанных окон Curve_Window или кривых сохраняется в файл.
 ***************************************************************************
 Через теги WinCaptionTag, WinTitleTag, WinLabelTag задается текст
 имени, заголовка и метки окна при сохранении списка кривых.
 Тег WriteErrorsTag считает ошибки.
 Список кривых теперь задается в виде
      CurveList = Curve1,Curve2,...Section1,Section2...
 где CurveN - имя кривой, SectionN - имя секции, содержащей список кривых
 ***************************************************************************
 Каталог сохранения задается переменной DataPath.
 Данные сохраняются в файл типа PPYYYYMMDD.CRW (QMS_20050819.CRW)
 в окне под именем типа YYYY.MM.DD\hh:mm:ss-xxx
 где  PP         - префикс, задается переменной FilePrefix
      YYYY,MM,DD - год, месяц, день
      hh,mm,ss   - часы, минуты, секунды
      xxx        - заголовок окна
 ***************************************************************************
 Пример конфигурации:
      [DeviceList]
      &QMS_CRWSAVE = device software program
      [&QMS_CRWSAVE]
      Comment        = Program to save data to *.CRW files
      InquiryPeriod  = 1
      DevicePolling  = 50, tpNormal
      ProgramSource  = ..\daqpas\_crwsave
      OpenConsole    = 0
      DebugFlags     = 15
      FilePrefix     = QMS_
      DataPath       = ..\data
      WinCaptionTag  = QMS_CrwCaption
      WinTitleTag    = QMS_CrwTitle
      WinLabelTag    = QMS_CrwLable
      WriteEnableTag = QMS_CRWSAVE
      WriteErrorsTag = QMS_IoErrors
      CurveList      = QMS_CH0, QMS_CH1
      CurveList      = [QMS_Curves]     
 ***************************************************************************
 Пример посылки сообщений:
      r:=devPostMsg('&QMS_CRWSAVE Save Windows QMS_Curves'+EOL);
      r:=devPostMsg('&QMS_CRWSAVE Save CurveList QMS_CH0,QMS_CH1'+EOL);
 ***************************************************************************
 }
program _crwsave;
const
 maxndat       = 32;      { Max. number of saved items       }
 snd_Click     = 'Click'; { Sound on button click            }
 snd_Fails     = 'Fails'; { Sound on operation failure       }
 dfTrouble     = 1;       { DebugFlags - Trouble             }
 dfSuccess     = 2;       { DebugFlags - Success             }
 dfViewInp     = 4;       { DebugFlags - ViewInp             }
 dfViewOut     = 8;       { DebugFlags - ViewOut             }
 idSave        = 'Save';
 idWindows     = 'Windows';
 idCurveList   = 'CurveList';
var
 s             : string;  { Temporary                        }
 b             : Boolean; { Temporary                        }
 Ok            : Boolean; { Program initialization is Ok?    }
 errors        : Integer; { Program error counter            }
 errorcode     : Integer; { Error code for this device       }
 fixmaxavail   : Integer; { String manager leak control      }
 DebugFlags    : Integer; { Debug bit flags                  }
 winConsole    : String;  { Console window name              }
 i,j,txt       : Integer; { Temporary                        }
 tagSave       : Integer; { Button to save data              }
 tagSaveErr    : Integer; { Error counter                    }
 tagWinCaption : Integer; { Window caption                   }
 tagWinTitle   : Integer; { Window title                     }
 tagWinLabel   : Integer; { Window legend                    }
 fpath,fpref   : string;  { File path & prefix               }
 fname,wname   : string;  { File & Window name               }
 clist         : string;  { Curve list                       }
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on data input.
 }
 procedure ViewInp(msg:String);
 begin
  if iand(DebugFlags,dfViewInp)>0 then
  if Length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data output.
 }
 procedure ViewOut(msg:String);
 begin
  if iand(DebugFlags,dfViewOut)>0 then
  if Length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Fix file write error
 }
 procedure SaveErr(msg:string);
 begin
  Trouble(msg);
  b:=rsettag(tagSaveErr,rgettag(tagSaveErr)+1);
 end;
 {
 Check I/O status.
 }
 function IoError:boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var s:string):boolean;
 begin
  StdIn_Readln:=false;
  if not IoError then 
  if not eof then begin
   readln(s);
   if not IoError then StdIn_Readln:=true;
  end;
 end;
 {
 Clear all strings.
 }
 procedure ClearStrings;
 begin
  s:='';
  clist:='';
  wname:='';
  fname:='';
  fpath:='';
  fpref:='';
  winConsole:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Get date as integer number, like 20050816 - YearMonthDay.
 }
 function GetDateAsNumber(ms:real):Integer;
 begin
  GetDateAsNumber:=(ms2year(ms)*100+ms2month(ms))*100+ms2day(ms);
 end;
 {
 Get file name corresponded to current time.
 }
 procedure getfname(var f:string);
 begin
  f:=AddPathDelim(fpath)+fpref+str(GetDateAsNumber(msecnow))+'.crw';
  f:=AdaptFileName(f);
 end;
 {
 Get window name by current date.
 }
 procedure getwname(var w:string);
 var yy,mm,dd,hh,mn,ss:string; t:real;
 begin
  t:=msecnow;
  yy:=str(ms2year(t));
  while length(yy)<4 do yy:='0'+yy;
  mm:=str(ms2month(t) mod 100);
  while length(mm)<2 do mm:='0'+mm;
  dd:=str(ms2day(t) mod 100);
  while length(dd)<2 do dd:='0'+dd;
  hh:=str(ms2hour(t) mod 100);
  while length(hh)<2 do hh:='0'+hh;
  mn:=str(ms2min(t) mod 100);
  while length(mn)<2 do mn:='0'+mn;
  ss:=str(ms2sec(t) mod 100);
  while length(ss)<2 do ss:='0'+ss;
  w:=extractword(1,sgettag(tagWinCaption));
  if length(w)>0 then w:='-'+w;
  w:=' '+yy+'.'+mm+'.'+dd+'\'+hh+':'+mn+':'+ss+w;
  yy:='';mm:='';dd:='';hh:='';mn:='';ss:='';
 end;
 {
 Save curves in list clist
 }
 procedure SaveCurveList(clist:string);
 var s:string;
 begin
  s:='';
  b:=MkDir(fpath);
  getfname(fname);
  getwname(wname);
  s:=fname+' '+wname+
           ' '+extractword(1,sgettag(tagWinTitle))+
           ' '+extractword(1,sgettag(tagWinLabel))+
           ' '+clist;
  if savecrw(s)
  then ViewOut(s)
  else SaveErr('Fail: '+s);
  s:='';
 end;
 {
 Save windows in list wlist
 }
 procedure SaveWindows(wlist:string);
 begin
  b:=MkDir(fpath);
  getfname(fname);
  for i:=1 to WordCount(wlist)do begin
   if windraw(ExtractWord(i,wlist)+'|SaveCrw='+fname)
   then ViewOut(ExtractWord(i,wlist))
   else SaveErr('Fail: '+ExtractWord(i,wlist));
  end;
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then Trouble('Could not init tag '+name);
 end;
begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  {
  Initialize errors & strings, clear variables.
  }
  errors:=0;
  errorcode:=registererr(devname);
  ClearStrings;
  {
  Open console window...
  }
  if val(ReadIni('OpenConsole'))>0 then begin
   winConsole:=ParamStr('Console '+devname);
   b:=winshow(winConsole);
   b:=windraw(winConsole+'|top=317|left=0|Width=600|Height=317');
   b:=winselect(winConsole);
  end;
  {
  Read parameters from config file.
  }
  DebugFlags:=Val(readini('DebugFlags'));
  InitTag( tagSave,       readini('WriteEnableTag'), 1);
  InitTag( tagSaveErr,    readini('WriteErrorsTag'), 2);
  InitTag( tagWinCaption, readini('WinCaptionTag'),  3);
  InitTag( tagWinTitle,   readini('WinTitleTag'),    3);
  InitTag( tagWinLabel,   readini('WinLabelTag'),    3);
  {
  Read & check file path & prefix 
  }
  fpath:=AdaptFileName(readini('DataPath'));
  if Length(fpath)>0 then fpath:=DaqFileRef(fpath,'');
  if IsWindows then fpath:=LoCaseStr(fpath);
  if MkDir(fpath)
  then Success('Data path Ok: '+fpath)
  else Trouble('Data path INVALID: '+fpath);
  fpref:=LoCaseStr(readini('FilePrefix'));
  {
  Read & check data list
  }
  clist:='';
  txt:=ReadIniSection(text_new,28,ParamStr('DaqConfigFile'),'['+devname+']');
  for i:=0 to text_numln(txt)-1 do begin
   s:=Trim(text_getln(txt,i));
   if IsSameText(ExtractWord(1,s),idCurveList) then
   for j:=2 to WordCount(s) do begin
    if length(clist)>0 then clist:=clist+',';
    clist:=clist+ExtractWord(j,s);
   end;
  end;
  b:=text_free(txt);
  if length(clist)>0
  then Success(idCurveList+'='+clist)
  else Trouble(idCurveList+ ' items not found in ['+devname+'] section');
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok') else Trouble('Start fails');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop.
 }
 if isinf(runcount) then begin
  Success('Stop');
  ClearStrings;
 end else 
 {
 Actions on Poll.
 }
 if Ok then begin
  {
  Process StdIn:
  Save Windows WINDOW1,WINDOW2...
  Save CurveList CURVE1,CURVE2,...
  }
  while StdIn_Readln(s) do begin
   s:=Trim(s);
   ViewInp(s);
   if IsSameText(ExtractWord(1,s),idSave) then begin
    s:=Trim(Copy(s,Length(idSave)+1));
    if IsSameText(ExtractWord(1,s),idWindows) then begin
     s:=Trim(Copy(s,Length(idWindows)+1));
     SaveWindows(s);
     s:='';
    end;
    if IsSameText(ExtractWord(1,s),idCurveList) then begin
     s:=Trim(Copy(s,Length(idCurveList)+1));
     SaveCurveList(s);
     s:='';
    end;
   end;
   if Length(s)>0 then Trouble('Unknown message: '+s);
  end;
  {
  Handle Save button
  }
  if igettag(tagSave)>0 then begin
   SaveCurveList(clist);
   b:=isettag(tagSave,0);
  end;
  {
  Handle button click.
  }
  if (clickbutton=1) then begin
   if clicktag=tagSave then begin
    b:=isettag(clicktag,ord(igettag(clicktag)=0));
    b:=voice(snd_Click);
   end;
   if clicktag=tagSaveErr then begin
    b:=isettag(clicktag,0);
    b:=voice(snd_Click);
   end;
  end;
 end;
end.
