 {
 ***********************************************************************
 Daq Pascal application program _DimRcv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Remote @cmd   - run @cmd remotely: send to DIM server.
| @DimTagUpdate  - handle remote click from DIM.
|********************************************************
[]
 Example config:
 ***********************************************************************
 [DeviceList]
 &DEMO.CTRL = device software program
 [&DEMO.CTRL]
 Comment        = DIM RECEIVER FOR DEMO.
 InquiryPeriod  = 1
 DevicePolling  = 10, tpNormal
 ProgramSource  = ~~\Resource\DaqSite\DimServer\_dimrcv.pas
 AnalogFifo     = 1024
 DebugFlags     = 3
 OpenConsole    = 2
 AnalogOutputs  = 2 ; Data to receive:
 Link AnalogOutput  0 with curve DEMO.DATA1  history 1000
 Link AnalogOutput  1 with curve DEMO.DATA2  history 1000
 EncryptMethod   = RC6              ; This parameters required
 TrustedUsers    = [TrustedUsers]   ; to send @Remote commands
 DIM_GuiClickTag = DEMO.DIMGUICLICK ; to DIM server
 []
 ***********************************************************************
 }
program _DimRcv;                 { DIM ReCeiVer                     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 hash_nao             : Integer; { HashList for AO's                }
 hash_ndo             : Integer; { HashList for AO's                }
 cmd_Remote           : Integer; { @Remote                          }
 cmd_DimTagUpdate     : Integer; { @DimTagUpdate                    }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 //
 // Post command to local/remote server.
 //
 procedure PostCmdLocal(cmd:String);
 begin
  DevPostCmdLocal(cmd);
 end;
 procedure PostCmdRemote(cmd:String);
 begin
  Dim_GuiConsoleSend(DevName,cmd);
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var ClickCurve:Integer; s:String;
 begin
  DIM_GuiClickBuff:=''; s:='';
  //
  // Edit handling...
  //
  if EditState=ef_Done then begin
   //
   // Warning, Information dialog completion.
   //
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Warning') then sNul(Edit(''));
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Information') then sNul(Edit(''));
  end;
  if EditState=ef_Done then begin
   Problem('Uncompleted edit detected!');
   sNul(Edit(''));
  end else
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Edit error detected!');
   sNul(Edit(''));
  end;
  //
  // Handle user mouse/keyboard clicks...
  // ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  // ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  //
  if ClickWhat<>0 then
  repeat
   //
   // Copy GUI click to DIM buffer for remote execution.
   //
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   //
   // Handle MouseDown/KeyDown
   //
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    //
    // Handle Left mouse button click
    //
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Handle local clicks
     //
     if ClickIsLocal then begin
      //
      // Handle sensor clicks...
      //
      if IsSameText(ClickSensor,'HELP') then begin
       Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
       bNul(Voice(snd_Click));
      end;
      //
      // Console commands: @url_encoded_sensor ...
      //
      if LooksLikeCommand(ClickSensor) then begin
       DevSendCmdLocal(url_decode(ClickSensor));
       bNul(Voice(snd_Click));
      end;
      //
      // Plot & Tab windows ...
      //
      ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
      if IsRefCurve(ClickCurve) then begin
       iNul(WinSelectByCurve(ClickCurve,ClickCurve));
       bNul(Voice(snd_Wheel));
      end;
     end;
     //
     // Handle remote clicks comes from DIM via @DimGuiClick message.
     // @DimGuiClick default handler decode and write events to FIFO,
     // so we can find it as clicks and can handle it in usual way.
     //
     if ClickIsRemote then begin
      //
      // Show time difference.
      //
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      //
      // Handle remote console commands...
      //
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
      //
      // Handle remote sensor clicks...
      //
      if TypeTag(ClickTag)>0 then begin
      end;
     end;
    end;
   end;
  until (ClickRead=0);
  DIM_GuiClickBuff:=''; s:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 var i:Integer;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  cmd_Remote:=RegisterStdInCmd('@Remote','');
  cmd_DimTagUpdate:=RegisterStdInCmd('@DimTagUpdate','');
  DIM_GuiClickInit(ReadIni('DIM_GuiClickTag'));
  hash_nao:=HashList_Init(0);
  hash_ndo:=HashList_Init(0);
  for i:=0 to NumAos-1 do if (RefAo(i)<>_Nil) then bNul(HashList_SetLink(hash_nao,CrvName(RefAo(i)),i+1));
  for i:=0 to NumDos-1 do if (RefDo(i)<>_Nil) then bNul(HashList_SetLink(hash_ndo,CrvName(RefDo(i)),i+1));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  bNul(HashList_Free(hash_nao)); hash_nao:=0;
  bNul(HashList_Free(hash_ndo)); hash_ndo:=0;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  GUIHandler;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; tag,nao,ndo:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Remote
   }
   if (cmdid=cmd_Remote) then begin
    if not IsEmptyStr(arg) then PostCmdRemote(Trim(arg));
    Data:='';
   end else
   {
   @DimTagUpdate tag
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    arg:=Trim(arg);
    if (Length(arg)>0) then begin
     tag:=FindTag(arg);
     if (tag<>0) then begin
      if (NumAos>0) then nao:=HashList_GetLink(hash_nao,arg)-1 else nao:=-1;
      if (NumDos>0) then ndo:=HashList_GetLink(hash_ndo,arg)-1 else ndo:=-1;
      if (TypeTag(tag)=2) then begin
       if (nao>=0) then UpdateAo(nao,time,rGetTag(tag));
       if (ndo>=0) then UpdateDo(ndo,time,rGetTag(tag));
      end else
      if (TypeTag(tag)=1) then begin
       if (nao>=0) then UpdateAo(nao,time,iGetTag(tag));
       if (ndo>=0) then UpdateDo(ndo,time,iGetTag(tag));
      end;
     end;
    end;
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
