@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:Comment
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright (c) 2024 Alexey Kuryakin daqgroup@mail.ru
:: crwprintlnk.cmd file.lnk - print content of specified *.lnk file.
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:CheckCatLnkExe
rem If catlnk.exe found, use it.
set "catlnk=%~dp0\shell\catlnk.exe"
if defined catlnk if exist "%catlnk%" goto :ExecCatLnk

:FallbackWithVbs
rem If catlnk.exe was not found, use VBS to read *.lnk.
:SetTemporaryVbs
set "TmpVbs=%Temp%\%~nx0.vbs"
:CreateTemporaryVbs
echo set WshShell = WScript.CreateObject("WScript.Shell")>"%TmpVbs%"
echo set Lnk = WshShell.Createshortcut(WScript.Arguments(0))>>"%TmpVbs%"
echo WScript.Echo "TargetPath:       ", Lnk.TargetPath>>"%TmpVbs%"
echo WScript.Echo "Arguments:        ", Lnk.Arguments>>"%TmpVbs%"
echo WScript.Echo "WorkingDirectory: ", Lnk.WorkingDirectory>>"%TmpVbs%"
echo WScript.Echo "IconLocation:     ", Lnk.IconLocation>>"%TmpVbs%"
echo WScript.Echo "Description:      ", Lnk.Description>>"%TmpVbs%"
echo WScript.Echo "WindowStyle:      ", Lnk.WindowStyle>>"%TmpVbs%"
echo WScript.Echo "HotKey:           ", Lnk.HotKey>>"%TmpVbs%"
:CallTemporaryVbs
cscript.exe //nologo "%TmpVbs%" "%~1"
:DeleteTemporaryVbs
del /f /q "%TmpVbs%" > nul
goto :EOF

:ExecCatLnk
set "Exec="
if "%~1" == "" ( "%catlnk%" & goto :EOF )
for /f "tokens=* delims=" %%i in ('"%catlnk%" %1') do set %%i
if defined Exec call :PrintParams
goto :EOF
:PrintParams
echo TargetPath:       %TargetPath%
echo Arguments:        %Arguments%
echo WorkingDirectory: %WorkingDirectory%
echo IconLocation:     %IconLocation%
echo Description:      %Description%
echo WindowStyle:      %WindowStyle%
echo HotKey:           %HotKey%
goto :EOF
