@echo off
SetLocal EnableExtensions EnableDelayedExpansion

chcp 65001
goto :Start

:About
echo.
echo #####################################################
echo CRW-DAQ tool to call Help on Free Pascal projects.
echo Param[1]  - project ^(*.lpr^) or help ^(*.chm;*.html^).
echo This script designed to use with FpcUpDeluxe.
echo Note: put fpcupdeluxe.lnk in script directory.
echo #####################################################
echo.
goto :EOF

:Start

call :About

:ScriptIdentification
set "scriptfile=%~f0"
set "scriptbase=%~n0"
set "scriptname=%~nx0"
for %%i in ( "%~dp0\." ) do set "scripthome=%%~fi"

:AppendShellToPath
set "PATH=%PATH%;%scripthome%\shell"

:SetWindowActivator
set "ShowWindow=unix shell-appactivate"
set "ActivateWindow=unix shell-appactivate"
set "wmquery=%scripthome%\shell\wmquery.exe"
for %%i in ( wmquery.exe ) do set "wmquery=%%~$PATH:i"
if exist "%wmquery%" echo Found the command "%wmquery%"
if exist "%wmquery%" set "ShowWindow=%wmquery% ShowWindow -class Window -title"
if exist "%wmquery%" set "ActivateWindow=%wmquery% ActivateWindow -class Window -title"

:CheckNoArgsumens
:CheckArgumentIsTocChm
if /i "%~1" == ""         goto :StartTocChm
if /i "%~1" == "toc"      goto :StartTocChm
if /i "%~1" == "toc.chm"  goto :StartTocChm
if /i "%~1" == "toc.htm"  goto :StartTocChm
if /i "%~1" == "toc.html" goto :StartTocChm

:HasArguments
:CheckFileExtension
if /i "%~x1" == ".chm"  goto :OpenChm
if /i "%~x1" == ".htm"  goto :OpenHtm
if /i "%~x1" == ".html" goto :OpenHtm

:StartTocChm
call :TryOpenLHelpItem "Table of Contents" && exit /b 0

:AssignFpcUpDeluxeDirectories
set FpcUpDeluxeDir=c:\opt\daqgroup\development\tools\fpcupdeluxe
set PrimaryConfigPath=%FpcUpDeluxeDir%\config_lazarus
set LazarusBinDir=%FpcUpDeluxeDir%\lazarus
set toc_chm=toc.chm

:GetLazarusBinDirFromLnk
for /f "tokens=1* delims= " %%i in ('%~dp0\crwprintlnk.cmd %~dp0\fpcupdeluxe.lnk ^| findstr /c:TargetPath:') do set "LazarusBinDir=%%~dpj"
for %%i in ("%LazarusBinDir%\.") do if exist "%%~fi\" set "LazarusBinDir=%%~fi"
echo LazarusBinDir=%LazarusBinDir%

:FindLHelpExe
set LHelpExe=none
for /f "tokens=* delims=" %%i in ('dir /b /s "%LazarusBinDir%" ^| findstr /i /c:\lhelp.exe') do set "LHelpExe=%%~fi"
if /i "%LHelpExe%" == "none" ( echo Error: not found LHELP.EXE & exit /b 1 )
echo LHelpExe=%LHelpExe%

:FindTocChm
set TocChm=none
for /f "tokens=* delims=" %%i in ('dir /b /s "%LazarusBinDir%" ^| findstr /i /c:\toc.chm') do set "TocChm=%%~fi"
if /i "%TocChm%" == "none" ( echo Error: not found TOC.CHM & exit /b 1 )
echo TocChm=%TocChm%

:CountLHelpInstances
set /a np=0
for /f "tokens=* delims=" %%i in ('tasklist /nh /fi "imagename eq lhelp.exe" ^| findstr /i /c:lhelp.exe') do echo %%i
for /f "tokens=* delims=" %%i in ('tasklist /nh /fi "imagename eq lhelp.exe" ^| findstr /i /c:lhelp.exe') do set /a np+=1

:EnforceNP
set /a np=0

:StartLHelpIfNotRunning
if "%np%" == "0" (
 echo "%LHelpExe%" "%TocChm%"
 start "LHelp" "%LHelpExe%" "%TocChm%"
 exit /b %ErrorLevel%
)

:ShowLHelpWindow
echo unix showwindow -r "LHelp - .*"
call unix showwindow -r "LHelp - .*"

:ActivateLHelpWindow
echo unix shell-appactivate "LHelp - "
call unix shell-appactivate "LHelp - "

:TocChmDone
goto :EOF

:OpenHtm
set "PATH=%PATH%;%scripthome%\shell"
unix getapppath firefox.exe chrome.exe edge.exe iexplore.exe -a .html --run "%~1"
goto :EOF

:OpenChm
:CheckCrwlibChm
if /i "%~nx1" == "crwlib.chm" ( call :TryOpenLHelpItem "crwlib" && exit /b 0 )
unix getapppath lhelp.exe sumatrapdf.exe -t SumatraPDF.chm hh.exe -a .chm --run "%~1"
goto :EOF

:TryOpenLHelpItem
call :ActivateWindow "LHelp -  [%~1]" && exit /b 0
call :ActivateWindow "LHelp - [%~1]"  && exit /b 0
call :ActivateWindow "LHelp -  %~1"   && exit /b 0
call :ActivateWindow "LHelp - %~1"    && exit /b 0
exit /b 1
goto :EOF

:ActivateWindow
set /a errors=0
call %ShowWindow%     "%~1" || set /a errors+=1
call %ActivateWindow% "%~1" || set /a errors+=1
if "%errors%" == "0" echo Open Found Window "%~1"
if "%errors%" == "0" exit /b 0
:SearchAndActivateWindow
set /a wnd=0 & set /a errors=0
for /f "tokens=1,* delims= " %%i in ('wmquery.exe ListWindows ^| findstr /c:" Window " ^| findstr /i /c:" %computername% %~1"') do set "wnd=%%~i"
if "%wnd%" == "0" exit /b 1
wmquery.exe ShowWindow -wnd %wnd%     || set /a errors+=1
wmquery.exe ActivateWindow -wnd %wnd% || set /a errors+=1
if "%errors%" == "0" echo Open Found Window "%~1"
if "%errors%" == "0" exit /b 0
exit /b %errors%
goto :EOF

::::::::::::::
:: END OF FILE
::::::::::::::
