 {
 Example for config\_sinwavp.cfg [mainprogram]
 Config file interface:
  [mainprogram]
  AnalogInputs = 3
  DigitalInputs = 1
  AnalogOutputs = 1
  DigitalOutputs = 0
  Calibrations = 0
  DebugMode = 1
  Link DigitalInput 0 with curve switchbutton bit 0
  Link AnalogInput  0 with curve sinusomega
  Link AnalogInput  1 with curve amplitude
  Link AnalogInput  2 with curve addnoise
  Link AnalogOutput 0 with curve sinusvalue
  ProgramSource = ..\daqpas\_sinwavp
 }
program _sinwavp;
var
 b        : boolean;
 Ok       : boolean;
 errors   : integer;
 errcode  : integer;
 tagStart : integer; 
 w        : real;
 a        : real;
 n        : real;
 v        : real;
 t        : real;
 q        : real;
begin
 if runcount=1 then begin
  errors:=0;
  errcode:=registererr('SinVaveProgram fails.');
  if rewrite('')<>0 then errors:=errors+1;
  writeln('Start SinVaveProgram test.');
  tagStart:=findtag('start');
  if typetag(tagStart)<>1 then errors:=errors+1;
  if errors<>0 then b:=fixerror(errcode);
  Ok:=errors=0;
 end else
 if isinf(runcount) then begin
  writeln('Stop SinVaveProgram test.');
 end else
 if Ok then begin
  if igettag(tagStart)>0 then begin
   t:=time;
   w:=getai_yn(0);
   a:=getai_yn(1);
   n:=getai_yn(2);
   v:=a*sin(2*pi*t*w)+n*random(-1,1);
   b:=putao(0,t,v);
  end;
  if clickbutton=1 then begin
   if clicksensor='START' then begin
    b:=voice('чик');
    b:=isettag(tagStart,ord(igettag(tagStart)=0));
   end;
   if clicksensor='VALUE' then begin
    b:=voice('чик');
    b:=winselect('Кривые-Sinwave');
   end;
  end;
  t:=msecnow;
  writeln(ms2year(t):4,'.',ms2month(t):2,'.',ms2day(t):2,'-',ms2hour(t):2,':',ms2min(t):2,':',ms2sec(t):2);
 end;
end.
