@echo off
title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright (c) 2001-2021 Alexey Kuryakin kouriakine@mail.ru ::
:: Under MIT License, see https://opensource.org/licenses/MIT ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Utility to generate UniHeater`s configuration.             ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:SetSelfInfo                                          
set SelfArgs=%*
set "SelfExt=%~x0"
set "SelfBase=%~n0"
set "SelfFile=%~f0"
set "SelfName=%~nx0"
for %%i in (".") do set "HomeDir=%%~fi"
for %%i in ("%~dp0\.") do set "SelfDir=%%~fi"

:ParseOptions
if /i "%~1" == "/?"         goto :PrintHelp
if /i "%~1" == "-h"         goto :PrintHelp
if /i "%~1" == "--help"     goto :PrintHelp
if /i "%~1" == "--version"  goto :PrintVersion
if /i "%~1" == "--samples"  goto :CopySamples

:ParseArguments
call :RequiredParamStr UH_PrefixName %1                     || exit /b 1    & rem Prefix string to identify UniHeater
call :RequiredParamInt UH_NumHeaters %2                     || exit /b 1    & rem Number of Unified Heaters, 1..32
call :RequiredParamInt UH_TileNumber %3                     || exit /b 1    & rem Tile number = columns per row, 1..UH_NumHeaters

:SetAddonVariables
call :GetPrefixFile UH_PrefixFile %UH_PrefixName%                           & rem File name prefix
call :Define UH_PrefixFile %UH_PrefixName:.=_%                              & rem File name prefix
for %%i in ( "%SelfDir%\..\Config" )   do set "UH_CfgFolder=%%~fi"          & rem Target folder for CFG files
for %%i in ( "%SelfDir%\..\Bitmaps" )  do set "UH_BmpFolder=%%~fi"          & rem Target folder for BMP files
for %%i in ( "%SelfDir%\..\Circuits" ) do set "UH_CrcFolder=%%~fi"          & rem Target folder for CRC files
call :Define UH_HomeDir %CRW_DAQ_SYS_HOME_DIR%\Resource\DaqSite\UniHeater   & rem Source directory of UniHeater

:CheckRequiredEntities
call :RequiredUnixUtils                                     || exit /b 1
call :RequiredAdminRights                                   || exit /b 1
call :RequiredParentCrwDaq                                  || exit /b 1
call :RequiredDefined UH_PrefixName                         || exit /b 1
call :RequiredDefined UH_PrefixFile                         || exit /b 1
call :RequiredDefined UH_NumHeaters                         || exit /b 1
call :RequiredDefined UH_TileNumber                         || exit /b 1
call :RequiredIntRange %UH_NumHeaters% 1 32                 || exit /b 1
call :RequiredIntRange %UH_TileNumber% 1 %UH_NumHeaters%    || exit /b 1
call :RequiredDefined UH_CfgFolder                          || exit /b 1
call :RequiredDefined UH_BmpFolder                          || exit /b 1
call :RequiredDefined UH_CrcFolder                          || exit /b 1
call :RequiredFile "%UH_CfgFolder%\"                        || exit /b 1
call :RequiredFile "%UH_BmpFolder%\"                        || exit /b 1
call :RequiredFile "%UH_CrcFolder%\"                        || exit /b 1
call :RequiredDefined UH_HomeDir                            || exit /b 1
call :RequiredFile "%UH_HomeDir%\"                          || exit /b 1
call :RequiredFile "%UH_HomeDir%\uniheater_make_crc.cmd"    || exit /b 1
call :RequiredFile "%UH_HomeDir%\uniheater_make_cfg.cmd"    || exit /b 1

:Main
call :SetErrors 0
call :SetErrorLevel 0
call :SetAnsiCodePage
pushd "%SelfDir%" && call :UniHeaterConfig
popd
call :HasNoErrors || call :ErrorPrintLn "%errors% error(s) found in %SelfName%."
call :RestoreCodePage
exit /b %ERRORLEVEL%
goto :EOF

:PrintVersion
echo %SelfBase% version 1.0
goto :EOF

:PrintHelp
call :PrintVersion
echo Copyright ^(c^) 2001-2021 Alexey Kuryakin kouriakine@mail.ru
echo Utility to generate UniHeater`s configuration.
echo Usage:
echo  %SelfBase% [Options] [Arguments]
echo Options:
echo  -h,--help  - print help
echo  --version  - print version
echo  --samples  - create command files [init,make,zero] to generate config
echo Arguments:
echo  UH_PrefixName - Prefix name to identify UniHeater
echo  UH_NumHeaters - Number of Unified Heaters, 1..32
echo  UH_TileNumber - Tile number = columns per row, 1..UH_NumHeaters
echo Example:
echo  call %SelfBase% DEMO 16 8
goto :EOF

:UniHeaterConfig
call :exec  "%UH_HomeDir%\uniheater_make_cfg.cmd" %UH_PrefixName% %UH_NumHeaters% %UH_TileNumber% "%UH_CfgFolder%" "%UH_CrcFolder%" "%UH_BmpFolder%" || call :IncErrors 1
goto :EOF

:CopySamples
call :RequiredUnixUtils || exit /b 1
call :RequiredAdminRights || exit /b 1
call :RequiredParentCrwDaq || exit /b 1
call :RequiredParamStr UH_PrefixName %2 || exit /b 1
call :GetPrefixFile UH_PrefixFile %UH_PrefixName%
call :Define UH_PrefixFile %UH_PrefixName:.=_%
call :Define UH_HomeDir %CRW_DAQ_SYS_HOME_DIR%\Resource\DaqSite\UniHeater
for %%i in ("%UH_HomeDir%\sample_uniheater_*.cmd") do for /f "tokens=* delims=" %%j in ('echo %%~nxi^|unix replacestr -i sample_ %UH_PrefixFile%_') do ( type "%%i" | unix replacestr SAMPLE %UH_PrefixName%  > "%SelfDir%\%%j" )
exit /b %ERRORLEVEL%
goto :EOF



::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Common library routines                                                    ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Define
if "%~1" == "" goto :EOF & rem Environ Variable Name
if "%~2" == "" goto :EOF & rem Environ Variable Value
if not defined %~1 set "%~1=%~2"
goto :EOF

:exec
echo %*
call %*
goto :EOF

:GetPrefixFile
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
for /f "tokens=* delims=" %%i in ('echo %~2^|unix replacestr -l . _ 2^>nul') do set "%~1=%%i"
goto :EOF

:RequiredParamStr
if "%~1" == "" goto :EOF
if not "%~2" == "" set "%~1=%~2"
if defined %~1 exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : missed string param %~1. Call %SelfName% --help for details."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredParamInt
if "%~1" == "" goto :EOF
if not "%~2" == "" set /a "%~1=%~2"
if defined %~1 exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : missed integer param %~1. Call %SelfName% --help for details."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredAdminRights
net session 1>nul 2>nul && exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : Access denied. Admin rights required."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredUnixUtils
if defined UnixRoot call unix %* 1>nul 2>nul && exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : UnixUtils is not valid. Install UnixUtils first."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredParentCrwDaq
if not defined CRW_DAQ_SYS_EXE_PID  goto :FailureParentCrwDaq
if not defined CRW_DAQ_SYS_HOME_DIR goto :FailureParentCrwDaq
if not defined CRW_DAQ_SYS_EXE_FILE goto :FailureParentCrwDaq
if not exist %CRW_DAQ_SYS_HOME_DIR% goto :FailureParentCrwDaq
call :TaskExePidIsRunning "%CRW_DAQ_SYS_EXE_FILE%" "%CRW_DAQ_SYS_EXE_PID%" && exit /b 0
rem for %%i in ( %CRW_DAQ_SYS_EXE_FILE% ) do ( unix lsps --pid %CRW_DAQ_SYS_EXE_PID% --name %%~nxi --format pid,name 1>nul 2>nul && exit /b 0 )
:FailureParentCrwDaq
call :ErrorPrintLn "ERROR in %SelfName% : parent CRW-DAQ is not found. Run this script from CRW-DAQ."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredFile
if "%~1" == "" goto :EOF
if exist "%~f1" exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : not found %~f1."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredDefined
if not "%~1" == "" if defined %1 exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : undefined variable %~1. Call %SelfName% --help for details."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredIntRange
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if "%~3" == "" goto :EOF
if %1 GEQ %2 if %1 LEQ %3 exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : invalid value %~1 (not in %~2..%~3 range). Call %SelfName% --help for details."
call :Sleep 5 . .
exit /b 1
goto :EOF

:EnableCloseMenu
unix setclosemenu -e
goto :EOF

:DisableCloseMenu
unix setclosemenu -d
goto :EOF

:StartTimer
unix cltimer -start
goto :EOF

:StopTimer
unix cltimer -stop
goto :EOF

:SetAnsiCodePage
for /f "tokens=1* delims=:" %%i in ('chcp') do set /a "CodePage=%%j"
if "%CodePage%" == "866" chcp 1251 > nul & rem Set RU ANSI CodePage
goto :EOF

:RestoreCodePage
if defined CodePage chcp %CodePage% > nul
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift /1 & goto :DeleteFiles
goto :EOF

:TaskExePidIsRunning
if "%~1" == "" exit /b 1 & rem EXE name
if "%~2" == "" exit /b 1 & rem PID number
SetLocal EnableExtensions EnableDelayedExpansion
for /f "tokens=1,2*" %%i in ('tasklist /nh /fi "imagename eq %~nx1"') do if /i "%%i" == "%~nx1" if /i "%%j" == "%~2" exit /b 0
exit /b 1
goto :EOF

:Sleep
:: Usage = call :Sleep NumSeconds [StartMessage] [ProgressChar]
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
set /a "PingCount=%~1+1"
if not "%~2" == "" call :ErrorPrint %2
if not "%~3" == "" for /L %%i in (1,1,%1) do ( call ping -n 2 localhost 1>nul 2>nul & call :ErrorPrint %~3 )
if     "%~3" == "" call ping -n %PingCount% localhost 1>nul 2>nul
if not "%~2" == "" call :ErrorPrintLn
EndLocal
goto :EOF

:Print
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
if not "%~2" == "" <nul set /p "_=%~1 "
if     "%~2" == "" <nul set /p "_=%~1"
EndLocal & shift /1 & goto :Print
goto :EOF

:PrintLn
call :Print %*
echo.
goto :EOF

:ErrorPrint
1>&2 call :Print %*
goto :EOF

:ErrorPrintLn
1>&2 call :PrintLn %*
goto :EOF

:SetErrors
set /a "errors=%~1"
goto :EOF

:IncErrors
set /a "errors+=%~1"
goto :EOF

:HasNoErrors
if "%errors%" == "0" exit /b %ERRORLEVEL%
exit /b 1
goto :EOF

:SetErrorLevel
exit /b %1
goto :EOF

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: END OF FILE                                                                ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
