﻿---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Справка по UniHeat

**UniHeat** (_Universal Heater_) - универсальная система для управления нагревателями в пакете **CRW-DAQ**.  
Система **UniHeat** может стабилизировать температуру с точностью порядка **1** градуса, содержит блокировку  
по температуре, давлению, сторожевому таймеру и внешнему сигналу.  
Эта система широко применяется в исследовательских установках, связанных с газовыми комплексами.  
В текущей версии возможно использование до **32** каналов управляемого нагрева.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="doc"></a>

## Документация по UniHeat

Документация по системе **UniHeat** содержится в файле **[uniheat.pdf](uniheat.pdf)**.  
Там есть краткое описание интерфейса, принципа и алгоритма работы.  
Сама система находится в каталоге **[~~/resource/daqsite/uniheat/](../../uniheat/)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="principal"></a>

## Принципиальная схема канала UniHeat

На рисунке изображена принципиальная схема канала нагрева **UniHeat**.  

![uh_principal.png](uniheat.files/uh_principal.png)  
Принципиальная схема канала нагревателя **UniHeat**.  

Она включает твердотельное реле, включаемое по сигналу меандра **GATE** и нормально-разомкнутое электромагнитное реле,
включаемое по инверсному сигналу блокировки <span class="bold" style="text-decoration:overline;">BLK</span>.
Твердотельное реле обеспечивает регулирование температуры, а реле блокировки — безопасность работы в случае пробоя твердотельного реле,
блокировки по превышению температуры или давления, по внешней блокировке или по сторожевому таймеру.
Регулирование осуществляется по датчику температуры **T**, а блокировка - по датчиками температуры **T**,
давления **P** и внешней блокировки **E**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="gui"></a>

## Интерфейс пользователя UniHeat

Окно **`***_КОНТРОЛЬ_НАГРЕВАТЕЛЕЙ_UNIHEAT_***`**  
![demo_uh_ctrl.png](uniheat.files/demo_uh_ctrl.png)  
служит для управления нагревателями:  
- включения и выключения,  
- задания температуры стабилизации,  
- вызова диалога настройки.  

Окно **`***_НАСТРОЙКА_НАГРЕВАТЕЛЕЙ_UNIHEAT_***`**  
![demo_uh_prop.png](uniheat.files/demo_uh_prop.png)  
служит для более детальной настройки параметров выбранного нагревателя.  
Здесь, кроме целевой температуры, можно задать:  
- используемые датчики температуры и давления,  
- условия блокировки по температуре, давлению и сторожевому таймеру,  
- параметры стабилизации температуры (скважность начального нагрева **Q1**,  
- коридор температур **&Delta;T1** и скважность **Q2** медленного нагрева,  
- коридор температур **&Delta;T2** и скважность **Q3** легкого подогрева).  

Здесь также можно сохранить параметры в **[INI](../data/uniheat.ini)** файл инициализации
или загрузить их из этого файла.  
Использование файла инициализации делает систему легко настраиваемой и удобной в работе.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="config"></a>

## Конфигурирование

Все файлы, теги и кривые **UniHeat** имеют префикс **`UH_`**.
Поэтому, во избежание возможного конфликта имен, следует избегать использования
данного префикса в прикладных системах, использующих **UniHeat**.

Основная часть файлов **UniHeat** содержится в каталоге **[~~/resource/daqsite/uniheat/](../../uniheat/)**.
Прикладному программисту требуется добавить в прикладную систему лишь небольшую согласующую конфигурацию,
содержащую специфику конкретной системы.

Для включения **UniHeat** в прикладную систему нужно создать и включить в рабочую конфигурацию
файл **[uniheat.cfg](../config/uniheat.cfg)** примерно такого содержания:

``` ini
;***********************************************************
;*** КОНФИГУРАЦИОННЫЙ ФАЙЛ CRW-DAQ ДЛЯ СОЗДАНИЯ ПРОГРАММ  **
;*** УПРАВЛЕНИЯ ПЕЧАМИ (ЗАГОТОВКА НА 8,16,24 или 32 ПЕЧИ) **
;*** Подсистема селектора каналов для управления UniHeat  **
;*** Этот файл надо настраивать индивидуально для каждой  **
;*** системы, т.к. кривые источников данных меняются.     **
;*** Для задействования 8,16,24 или 32 печей используйте  **
;*** конфигурации UH_8, UH_16, UH_24, UH_32 соответственно. **
;***********************************************************
[ConfigFileList] ; Подключение конфигурации UniHeat
ConfigFile = ~~\resource\daqsite\uniheat\config\uh_16.cfg
[]

;************************************
;*** Селектор каналов температуры ***
;*** Редактируются AnalogInputs и ***
;*** UH_TNAMES - имена датчиков T ***
;*** Имена датчиков без пробелов, ***
;*** разделяются слэшем: T1/T2/.. ***
;*** Имена датчиков должны строго ***
;*** соответствовать AnalogInputs ***
;************************************
[&amp;UH_REDIR_T]
UsesSmoothing  = 1
AnalogInputs   = 11
Link AnalogInput 1  with curve SENSOR.T1
Link AnalogInput 2  with curve SENSOR.T2
Link AnalogInput 3  with curve SENSOR.T3
Link AnalogInput 4  with curve SENSOR.T4
Link AnalogInput 5  with curve SENSOR.T5
Link AnalogInput 6  with curve SENSOR.T6
Link AnalogInput 7  with curve SENSOR.T7
Link AnalogInput 8  with curve SENSOR.T8
Link AnalogInput 9  with curve SENSOR.T9
Link AnalogInput 10 with curve SENSOR.T10
[]
[TagList]
UH_TNAMES = string SENT1/SENT2/SENT3/SENT4/SENT5/SENT6/SENT7/SENT8/SENT9/SENT10
[]

;************************************
;*** Селектор каналов давлений    ***
;*** Редактируются AnalogInputs и ***
;*** UH_PNAMES - имена датчиков P ***
;*** Имена датчиков без пробелов, ***
;*** разделяются слэшем: P1/P2/.. ***
;*** Имена датчиков должны строго ***
;*** соответствовать AnalogInputs ***
;************************************
[&amp;UH_REDIR_P]
UsesSmoothing  = 1
AnalogInputs   = 11
Link AnalogInput 1  with curve SENSOR.P1
Link AnalogInput 2  with curve SENSOR.P2
Link AnalogInput 3  with curve SENSOR.P3
Link AnalogInput 4  with curve SENSOR.P4
Link AnalogInput 5  with curve SENSOR.P5
Link AnalogInput 6  with curve SENSOR.P6
Link AnalogInput 7  with curve SENSOR.P7
Link AnalogInput 8  with curve SENSOR.P8
Link AnalogInput 9  with curve SENSOR.P9
Link AnalogInput 10 with curve SENSOR.P10
[]
[TagList]
UH_PNAMES = string SENP1/SENP2/SENP3/SENP4/SENP5/SENP6/SENP7/SENP8/SENP9/SENP10
[]
```

В секции **`[ConfigFileList]`** в зависимости от размера системы (8,16,24 или 32 канала)
используется включаемая конфигурация **uh_8.cfg**, **uh_16.cfg**, **uh_24.cfg** или **uh_32.cfg**.

В секции **`[&UH_REDIR_T]`** подключаются кривые датчиков температур, используемых для управления нагревателями.
Эти кривые объявляются и генерируются прикладной программой индивидуально для каждой системы.

В секции **`[&UH_REDIR_P]`** подключаются кривые датчиков давлений, используемых в системе блокировки нагревателей.
Эти кривые объявляются и генерируются прикладной программой индивидуально для каждой системы.

В секции **`[TagList]`** также задаются строковые теги **`UH_TNAMES`** и **`UH_PNAMES`**,
в которых указываются имена датчиков температур (UH_TNAMES) и давлений (UH_PNAMES). 
Эти имена, следующие через разделительный слеш (/), не должны быть длиннее 6 символов и не должны содержать пробелы.
Их число и порядок должны строго соответствовать списку подключенных кривых.
Списки имен датчиков используются в диалоге выбора каналов управления датчиков температуры и каналов блокировки по давлениям.
Поэтому эти имена должны быть хорошо известны пользователям.

Используйте кривые **`UH_GATEn`** для формирования управляющего меандра нагревателя _n_.
Эти кривые подаются на входы цифровых модулей, управляющих твердотельным реле нагревателя.

Используйте кривые **`UH_BLKn`** для формирования сигнала блокировки нагревателя _n_.
Эти кривые подаются на входы цифровых модулей, управляющих электромагнитным реле блокировки нагревателя.
Лучше всего использовать нормально-разомкнутое реле блокировки и замыкать его по инверсному сигналу 
<span class="bold" style="text-decoration:overline;">**UH_BLKn**</span>.

Используйте теги **`UH_EBLKn`** для блокировки нагревателя _n_ внешним сигналом.  
Формирование этого сигнала отдается прикладной программе.

Все параметры **UniHeat** могут быть сохранены в файле **[uniheat.ini](../data/uniheat.ini)**,  
который автоматически загружается при старте измерительной системы.

Для управления окнами **`***_КОНТРОЛЬ_НАГРЕВАТЕЛЕЙ_UNIHEAT_***`** и **`***_НАСТРОЙКА_НАГРЕВАТЕЛЕЙ_UNIHEAT_***`**  
с помощью сервера **Cron** можно использовать задания **`UH_CONTROL.HOME`**, **`UH_CONTROL.SHOW`**, **`UH_CONTROL.HIDE`**,  
**`UH_CONTROL.SELECT`**, **`UH_PROPERTY.HOME`**, **`UH_PROPERTY.SHOW`**, **`UH_PROPERTY.HIDE`**, **`UH_PROPERTY.SELECT`**.  

Например:

``` pascal
Cron('@cron.run UH_CONTROL.SELECT'); // Открыть окно контроля нагревателей UniHeat.
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Желаем успешного использования **UniHeat**.

---

> **CRW-DAQ** Copyright © 2001-2024 Alexey Kuryakin <daqgroup@mail.ru>

---
