 {
 *****************************************************************
 Copyright © by Kuryakin A.V., Sarov, Russia, 2006.
 That is test and demo program to understand and check strings
 in DAQ-PASCAL.
 *****************************************************************
 }
program Demo_Strings;
{$T+}
{$S-}
const
 dfTrouble         = 1;       { DebugFlags - Trouble             }
 dfSuccess         = 2;       { DebugFlags - Success             }
 dfViewExp         = 4;       { DebugFlags - ViewExp             }
 dfViewImp         = 8;       { DebugFlags - ViewImp             }
var
 b                 : Boolean; { Temporary                        }
 Ok                : Boolean; { Program initialization is Ok?    }
 errors            : Integer; { Program error counter            }
 errorcode         : Integer; { Error code for this device       }
 fixmaxavail       : Integer; { String manager leak control      }
 DebugFlags        : Integer; { Debug bit flags                  }
 TestNum           : Integer; { Test number                      }
 TestTot           : Integer; { Test total number                }
 i,j               : Integer; { Temporary                        }
 s,dt,s1,s2,s3,s4  : String;  { Temporary                        }
 ms                : Real;    { Temporary                        }
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:=''; dt:=''; s1:=''; s2:=''; s3:=''; s4:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Replace all "a" to "b" in string "s".
 Flag = 1 - Replace All, 2 - Not Case sensitive
 }
 function StrReplace(s,a,b:String; Flags:Integer):String;
 var p:Integer;
 begin
  if iAnd(Flags,1)=0
  then p:=Pos(a,s)
  else p:=Pos(UpCaseStr(a),UpCaseStr(s));
  if p=0 then StrReplace:=s else begin
   if iAnd(Flags,2)=0
   then StrReplace:=Copy(s,1,p-1)+b+Copy(s,p+Length(a))
   else StrReplace:=Copy(s,1,p-1)+b+StrReplace(Copy(s,p+Length(a)),a,b,Flags);
  end;
 end;
 {
 Calculate Fibonnaci values for integer.
 Uses as well known reference version.
 }
 function iFibonnaci(arg:Integer):Integer;
 begin
  if arg<=2
  then iFibonnaci:=1
  else iFibonnaci:=iFibonnaci(arg-1)+iFibonnaci(arg-2);
 end;
 {
 Calculate Fibonnaci values as strings.
 This very strange functions uses to check different kind of string manipulations.
 }
 function sFibonnaci1(s:String):String;
 var arg:Integer;
 begin
  arg:=Val(s);
  if arg<=2
  then sFibonnaci1:='1'
  else sFibonnaci1:=Str(Eval(sFibonnaci1(Str(arg-1))+'+'+sFibonnaci1(Str(arg-2))));
 end;
 function sFibonnaci2(s:String):String;
 var arg:Integer; s1,s2:String;
 begin
  arg:=Val(s);
  if arg<=2
  then sFibonnaci2:='1' else begin
   s1:=sFibonnaci1(Str(arg-1)+'  ');
   s2:=sFibonnaci2('  '+Str(arg-2));
   sFibonnaci2:=Str(Eval(s1+'+'+s2));
  end;
 end;
 function sFibonnaci3(s:String):String;
 var arg:Integer;
 begin
  arg:=Round(Eval(s));
  if arg<=2
  then sFibonnaci3:='1.0'
  else sFibonnaci3:='( '+sFibonnaci3(Str(arg-2))+' + '+sFibonnaci2(Str(arg-1))+' )';
 end;
 function sFibonnaci4(s:String):String;
 var arg:Integer;
 begin
  arg:=Round(Eval(s));
  if arg<=2
  then s:='1'
  else s:='('+sFibonnaci3(Str(arg-1))+'+'+sFibonnaci4(Str(arg-2))+')';
  sFibonnaci4:=s;
 end;
 function sFibonnaci5(s:String):String;
 var arg:Integer; s1,s2:String;
 begin
  arg:=Round(Eval(s));
  if arg<=2
  then s:='1' else begin
   s1:=Str(arg-1);
   s2:=Str(arg-2);
   s:='('+Str(Eval(sFibonnaci5(s1)))+'+'+sFibonnaci4(s2)+')';
  end;
  sFibonnaci5:=s;
 end;
 procedure sFibonnaci6(var s:String);
 var arg:Integer; s1,s2:String;
 begin
  arg:=Round(Eval(s));
  if arg<=2
  then s:='1' else begin
   s1:=Str(arg-1);
   s2:=Str(arg-2);
   sFibonnaci6(s1);
   s:='('+Str(Eval(s1))+' + '+Str(Eval(sFibonnaci5(s2)))+')';
  end;
 end;
 {
 Test string functions using recursive Fibbonaci functions.
 }
 procedure Test_Fibbonaci;
 var s1,s2,s3,s4,s5,s6:String;
 begin
  s1:=''; s2:=''; s3:=''; s4:=''; s5:=''; s6:='';
  write('  ');
  for i:=1 to 15 do begin
   j:=iFibonnaci(i);
   write(' ',j:1);
   s1:=sFibonnaci1(Str(i));
   s2:=sFibonnaci2(Str(i));
   s3:=sFibonnaci3(Str(i));
   s4:=sFibonnaci4(Str(i));
   s5:=sFibonnaci5(Str(i));
   s6:=Str(i); sFibonnaci6(s6);
   if Str(j)<>s1 then errors:=errors+1;
   if Str(j)<>s2 then errors:=errors+1;
   if (j<>Eval(s3)) or IsNan(Eval(s3)) then errors:=errors+1;
   if (j<>Eval(s4)) or IsNaN(Eval(s4)) then errors:=errors+1;
   if (j<>Eval(s5)) or IsNaN(Eval(s5)) then errors:=errors+1;
   if (j<>Eval(s6)) or IsNaN(Eval(s6)) then errors:=errors+1;
   {writeln(EOL,s6);}
  end;
 end;
 {
 Get string like 2006.09.21-00:12:30
 Simplest version for reference.
 }
 procedure GetDateTime(var s:String; ms:Real);
 begin
  s:='';
  s:=str(ms2sec(ms))+s;   while Length(s)<2  do s:='0'+s; s:=':'+s;
  s:=str(ms2min(ms))+s;   while Length(s)<5  do s:='0'+s; s:=':'+s;
  s:=str(ms2hour(ms))+s;  while Length(s)<8  do s:='0'+s; s:='-'+s;
  s:=str(ms2day(ms))+s;   while Length(s)<11 do s:='0'+s; s:='.'+s;
  s:=str(ms2month(ms))+s; while Length(s)<14 do s:='0'+s; s:='.'+s;
  s:=str(ms2year(ms))+s;  while Length(s)<19 do s:='0'+s;
 end;
 {
 Get string like 2006.09.21-00:12:30
 }
 procedure GetDateTime1(var s:String; ms:Real);
  function Pad(s:String; n:Integer):String;
  begin
   s:=Trim(s);
   while Length(s)<n do s:='0'+s;
   Pad:=s;
  end;
  function Concat(s1,s2:String):String;
  var s:String;
  begin
   s:=s1+s2;
   Concat:=s;
  end;
 begin
  s:=Pad(Str(ms2year(ms)),4)+'.'+
     Pad(Str(ms2month(ms)),2)+'.'+
     Pad(Str(ms2day(ms)),2)+'-'+
     Concat(Pad(Str(ms2hour(ms)),2),':'+Pad(Str(ms2min(ms))+':'+Pad(Str(ms2sec(ms)),2),5));
 end;
 {}
 procedure CheckDateTime;
 var ms,t:Real; year,month,day,hour,min,sec,msec:Integer;
 begin
  ms:=msecnow;
  year:=ms2year(ms);
  month:=ms2month(ms);
  day:=ms2day(ms);
  hour:=ms2hour(ms);
  min:=ms2min(ms);
  sec:=ms2sec(ms);
  msec:=Round(Frac(ms/1000)*1000);
  t:=datetime2ms(year,month,day,hour,min,sec,msec);
  writeln('   Check datetime2ms:',t-ms:1:0);
 end;
 {}
 procedure CheckMime;
 var s,s1:String; e:Integer;
 begin
  e:=errors;
  for i:=1 to 50 do begin
   s:='';
   for j:=1 to Round(Random(0,30)) do s:=s+Chr(Round(Random(0,255)));
   s1:=Mime_Encode(s);
   if Mime_Decode(s1)<>s then errors:=errors+1;
   if i=1 then Writeln('   Mime_Encode ',s1);
  end;
  if e<>errors
  then Writeln('   MIME_Encode/Decode errors found!')
  else Writeln('   MIME_Encode/Decode Ok.');
  s:=''; s1:='';
 end;
 {}
 procedure CheckURL;
 var s,s1,s2:String; e:Integer;
 begin
  e:=errors;
  for i:=1 to 50 do begin
   s:='';
   for j:=1 to Round(Random(0,30)) do s:=s+Chr(Round(Random(0,255)));
   s1:=URL_Packed(s);
   s2:=URL_Encode(s);
   if URL_Decode(s1)<>s then errors:=errors+1;
   if URL_Decode(s2)<>s then errors:=errors+1;
   if i=1 then Writeln('   URL_Packed ',s1);
   if i=1 then Writeln('   URL_Encode ',s2);
  end;
  if e<>errors
  then Writeln('   URL_Encode/Decode errors found!')
  else Writeln('   URL_Encode/Decode Ok.');
  s:=''; s1:=''; s2:='';
 end;
 {}
 procedure CheckHex;
 var s,s1:String; e:Integer;
 begin
  e:=errors;
  for i:=1 to 50 do begin
   s:='';
   for j:=1 to Round(Random(0,30)) do s:=s+Chr(Round(Random(0,255)));
   s1:=HEX_Encode(s);
   if HEX_Decode(s1)<>s then errors:=errors+1;
   if i=1 then Writeln('   HEX_Encode ',s1);
  end;
  if e<>errors
  then Writeln('   HEX_Encode/Decode errors found!')
  else Writeln('   HEX_Encode/Decode Ok.');
  s:=''; s1:='';
 end;
 {}
 procedure stest;
 const
  con = 'a constant string';
  v   = 'a constant string';
  w   = v;
 type
   atyp = array[1..10] of string;
   rtyp = record h:integer; s:string; end;
 var
  p,q,r,s,t : string; n:integer;
  s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s12,s13,s14,s15,s16,s17: string;
  a:atyp; ch,c,c1:char; rec,rec2:rtyp; carray:array[1..5] of char; re:real;
  procedure parpass(var v1,v2: string; v3:string; v4:atyp);
   procedure level_2(var w1: string);
   begin
    w1 := w1 + 'r';
   end;
  begin
   v1 := v1 + 'mete';
   v3 := v3 + 'mete';
   level_2(v1); level_2(v3);
   v2 := v3;
   if v4[5] <> 'Value para' then begin
    writeln('***ARRAY VAL PARAM FAILURE');
    errors := errors+1;
   end;
   V4[5] := 'a long dummy string';
  end; {parpass}
 begin  {stest}
  if w <> v then begin
   writeln('   ***CONSTANT DECLARATION FAILURE');
   errors := errors+1;
  end;
  {}
  s1 := 'a literal string';
  s2 := 'assignment';
  t := s2;
  if (s1<>'a literal string') or (t<>'assignment') then begin
   writeln('   ***ASSIGNMENT FAILURE');
   errors := errors+1;
  end;
  {}
  s := 'ab';
  if not (('abc'='abc') and (s+'d'>'abc') and ('abc'<'abd') and ('abc'>'ab')
     and (s<>'ba') and ('a'<'abc') and ('b'>s+'c') and ('abc'>'a')
     and (s+'c'<'b'))
     or ((s+s)=s) or ('a'>'b') or ('ba'<=copy(s,1,1)+'b')
     or (s>=('a'+'b'+'c'))
  then begin
   writeln('   ***RELATIONAL OPERATOR FAILURE');
   errors := errors+1;
  end;
  {}
  t := 'arrays and records';
  a[7] := t; rec.s := a[7]; s3 := rec.s;
  rec2 := rec; rec2.s := 'X';
  if (rec.s <> t) or (rec2.s <> 'X') then begin
   writeln('   ***RECORD ASSIGNMENT FAILURE');
   errors := errors+1;
  end;
  {}
  c := 's'; s4 := c; s5 := t;  s5 := 'c';  c := s5; 
  if (s4 <> 's') or (c <> 'c') then begin
   writeln('   ***CHAR ASSIGNMENT FAILURE');
   errors := errors+1;
  end;
  {}
  s6 := 'h' + 'a'; s7 := 'c' + 'har'; s8 := 'cha' + 'r';
  s9 := 'string'; s9 := s9+' + '+s9;
  if (s6<>'ha') or (s7<>'char') or (s8<>'char') or (s9<>'string + string') then begin
   writeln('   ***CONCATENATION FAILURE');
   errors := errors+1;
  end;
  {}
  s := 'ghCopy fudd'; s10 := copy(s,3,7);
  s14 := copy('XXXtemp '+'stringXXX',4,11);
  c := 'A'; s15 := copy(c,1,1);
  s11 := copy('XXXXrightstring',5);
  if (s14 <> 'temp string') or (s15 <> 'A') or (s11 <> 'rightstring') then begin
   writeln('   ***COPY FUNCTION FAILURE');
   errors := errors+1;
  end;
  {}
  q := 'avprnlwcif'; s := 'Pos fu'; n := pos('f',s);
  if (pos('lw',q) <> 6) or (pos('za','z'+q) <> 1) or (pos('',q) <> 0)
  or (pos(q,'') <> 0) or (pos('wc'+'ifx',q) <> 0)
  or (pos('ci'+'fx',q+'xu') <> 8) or (n <> 5) then begin
   writeln('   ***POS FUNCTION FAILURE');
   errors := errors+1;
  end;
  {}
  s := 'gnixednI gnirtS';
  if (s[1] <> 'g') or (s[13] <> 'r') then begin
   writeln('   ***INDEXING FAILURE');
   errors := errors+1;
  end;
  {}
  q := ' dummy';
  if (length(q) <> 6) or (length(q+s) <> 21)
  or (length('') <> 0) or (length('Q') <> 1) then begin
   writeln('   ***LENGTH FUNCTION FAILURE');
   errors := errors+1;
  end;
  {}
  s12 := 'Var para'; q := 'Value para'; t := 'oops'; a[5] := q; parpass(s12,t,q,a); 
  if (q <> 'Value para') or (a[5] <> 'Value para') then begin
   writeln('   ***VALUE PARAMETER CHANGED');
   errors := errors+1;
  end;
  {}
  carray := 'charXr'; carray[5] := 'a'; s16 := carray;
  carray := 'rr'+'ay'; s := carray;
  if (s16 <> 'chara') or (s <> 'rray ') then begin
   writeln('   ***CHAR ARRAY NOT COMPATIBLE');
   errors := errors+1;
  end;
  {}
  if (str(-12345) <> '-12345') or (strfmt('%.7g',765.4321E21) <> '7.654321E23') then begin
   writeln('   ***STR FUNCTION FAILURE');
   errors := errors+1;
  end;
  {}
  writeln('   '+StrFmt('%.7g',765.4321E21),' = 765.4321E21');
  if (val('12345') <> 12345) or (val('-111'+'11') <> -11111) then begin
   writeln('   ***VAL FUNCTION FAILURE');
   errors := errors+1;
  end;
  {}
  if (rval('12345678.0')<>1.2345678e7) or (rval('3.1'+'416')<>3.1416) then begin
   writeln('   ***RVAL FUNCTION FAILURE');
   errors := errors+1;
  end;
  {}
  if Length(copy(c,4,1))+Length(copy('xx',-3,2))+Length(copy('xx',1,-3))<>0 then begin
   writeln('   ***COPY FUNCTION FAILURE');
   errors := errors+1;
  end;
 end; {stest}
 {
 Main program
 }
begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  errors:=0;
  errorcode:=registererr(devname);
  DebugFlags:=255;
  ClearStrings;
  writeln(devname+' : Start');
  TestTot:=0;
  {
  Is it Ok?
  }
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop
 }
 if isinf(runcount) then begin
  ClearStrings;
  writeln(devname+' : Stop.');
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  {}
  for i:=1 to 10 do writeln;
  writeln('****************');
  writeln('STRING TEST DEMO');
  writeln('****************');
  writeln('RunCount = ',runcount:5:0);
  writeln('MaxAvail = ',maxavail:5);
  writeln('Errors   = ',errors:5);
  writeln('****************');
  TestNum:=0;
  {}
  TestNum:=TestNum+1;
  writeln(TestNum:1,'. Standard strings test (stest): ');
  i:=maxavail;
  stest;
  j:=maxavail;
  if i <> j then writeln('   ***GARBAGE COLLECTION FAILURE')
            else writeln('   Garbage collection OK: '+Str(maxavail));
  {}
  TestNum:=TestNum+1;
  writeln(TestNum:1,'. Fibbonaci test: ');
  Test_Fibbonaci;
  {}
  writeln;
  TestNum:=TestNum+1;
  writeln(TestNum:1,'. DateTime test:');
  ms:=msecnow; GetDateTime(dt,ms); writeln('   ',dt);
  GetDateTime1(s,ms); if s<>dt then errors:=errors+1;
  CheckDateTime;
  {}
  TestNum:=TestNum+1;
  Writeln(TestNum:1,'. Registry test: ');
  Writeln('   ',ParamStr('Registry HKLM SOFTWARE\Microsoft\Windows\CurrentVersion ProductId'));
  {}
  TestNum:=TestNum+1;
  Writeln(TestNum:1,'. UserList test: ');
  Writeln('   ',StrReplace(ParamStr('UserList'),EOL,Dump(','),3));
  {}
  TestNum:=TestNum+1;
  writeln(TestNum:1,'. MIME test: ');
  CheckMime;
  {}
  TestNum:=TestNum+1;
  writeln(TestNum:1,'. URL test: ');
  CheckURL;
  {}
  TestNum:=TestNum+1;
  writeln(TestNum:1,'. HEX test: ');
  CheckHex;
  {}
  TestTot:=TestTot+TestNum;
  writeln('****************');
  writeln('Tests passed : ',TestNum:1,' (total ',TestTot:1,')');
  writeln('Errors found : ',errors:1);
  writeln('****************');
 end;
end.
