---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Справка по демонстрационной системе DEMO_SPEAK2.

Демонстрационная конфигурация **DEMO_SPEAK** служит для иллюстрации того,
как в системе **CRW-DAQ** можно организовывать речевые сообщения при помощи
речевого синтезатора.
Под **Windows** это **Speech API**, под **Linux** - пакет **RHVoice**.

Данный пример использует сервер речевых сообщений, запускаемый как отдельный процесс.
Это сделано для повышения надежности работы основного пакета.
Это рекомендуемый подход к созданию конфигураций для прикладных **DAQ**-систем.

Конфигурация сервера речевых сообщений выглядит так:

``` ini
[DeviceList]
&SpeakSrv = device software program
[&SpeakSrv]
Comment        = SPEAK server
InquiryPeriod  = 1
DevicePolling  = 100, tpNormal
ProgramSource  = ~~\resource\daqsite\speakserver\speaksrv.pas
SPEAK_SERVER   = ~~\resource\daqsite\speakserver\speaksrv.exe
OpenConsole    = 2    ; 0=None, 1=Open, 2=Minimized
DebugFlags     = 15   ; 1/2/4/8=Trouble/Success/Export/Import
StdInFifo      = 16   ; Размер FIFO StdIn, kB
StdOutFifo     = 16   ; Размер FIFO StdOut,kB
StdInPipe      = 16   ; Размер анонимного канала StdIn,kB
StdOutPipe     = 16   ; Размер анонимного канала StdOut,kB
CheckSpeechApi = 7    ; Проверять наличие библиотек 1:SpeechApi, 2:Russian, 4:English
Engine         = Adult Male #1 Russian (L&H) ; Номер или имя активного движка или -1 для отключения
[]  
```

Имя сервера фиксировано, содержимое в общем-то тоже.
Для реализации сообщений клиенты используют процедуру:

``` pascal
{
Speak, i.e. send message to speech server.
}
procedure Speak(msg:String);
var b:Boolean; ref:Integer;
begin
 msg:=Trim(msg);
 if Length(msg)>0 then begin
  ref:=RefFind('Device &SpeakSrv');
  if ref<>0 then b:=DevSend(ref,'@speak='+msg+EOL)>0;
 end;
end;
```

Речевой синтезатор не работает, пока не установлен движок.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Установка движка под Windows

Под **Windows** надо установить **Speech API**. Нужно установить два компонента:

1. Библиотеку **[spchapi.exe](..\..\resource\tools\speechapi\spchapi.exe)** и  
2. Голоса
   **[lhttsrur.exe](..\..\resource\tools\speechapi\lhttsrur.exe)** (русский) и
   **[lhttseng.exe](..\..\resource\tools\speechapi\lhttseng.exe)** (английский).  
Это можно сделать через меню **Web\Home**.

Эти компоненты доступны в Интернете:  
1. **[spchapi.exe](http://activex.microsoft.com/activex/controls/sapi/spchapi.exe)**,  
2. **[lhttsrur.exe](http://activex.microsoft.com/activex/controls/agent2/lhttsrur.exe)** и  
3. **[lhttseng.exe](http://activex.microsoft.com/activex/controls/agent2/lhttseng.exe)**.

Установка **spchapi.exe** происходит "молча", никаких диалогов.
Установка **lhttsrur.exe**, **lhttseng.exe** происходит через стандартный диалог инсталляции.
Больше настроек не требуется.

После установки движков они доступны по именам:

- Adult Female #1 Russian (L&H)  
- Adult Male #1 Russian (L&H)  
- Adult Female #1 British English (L&H)  
- Adult Male #1 British English (L&H)  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Установка движка под Linux

Под **Linux** устанавливается пакет **daqgroup-rhvoice**, входящий в состав
репозитория **DaqGroup**:

``` bash
sudo qapt-deb-installer /srv/public/mirror/addons/daqgroupkit/install-daqgroup-rhvoice.deb
```
Также необходимо установить пакет **daqgroup-crwkit**:

``` bash
/srv/public/mirror/addons/daqgroupkit/install-daqgroup-crwkit.run
```

Для проверки работы:

``` bash
crwkit speak "Привет, друг."
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Вызов речевых сообщений

Собственно сообщения делаются так:

``` pascal
Speak('Привет, Мир!');
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Успехов!

---

> CRW-DAQ Copyright (c) 2002-2024 Alexey Kuryakin <daqgroup@mail.ru>

---
