 {
 ***********************************************************************
 Daq Pascal application program SmiProxyEvtBuilder.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @smi_proxy cmd - Send command (cmd) to smiProxy.exe.
|********************************************************
[]
 }
program SmiProxyEvtBuilder;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_SmiProxy}              { Include SMI Proxy    constants   }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_SmiProxy}              { Include SMI Proxy    variables   }
 tagDelay      : Integer;        { Delay to simulate real work      }
 tagKicker     : Integer;        { Kick timer to simulate errors    }
 KickTime      : Real;           { Event marker for demo purposes   }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_SmiProxy}              { Include SMI Proxy    functions   }

 procedure InitEvtBuilder;
 begin
  InitTag(tagDelay,  ReadIni('tagPrefix')+'.SimDelay',  -1);
  InitTag(tagKicker, ReadIni('tagPrefix')+'.SimKicker', -1);
  KickTime:=0;
 end;

 //
 // SMI Proxy Logic.
 //
 procedure SmiProxyLogic;
 var complete:Boolean; typ:String; nr:Integer; delay,period:Integer;
 begin
  typ:='';
  //
  // Delay to simulate operation execution
  //
  delay:=iGetTag(tagDelay);
  period:=iGetTag(tagKicker);
  //
  // SMI Proxy BUSY operations.
  // SMI actions handler there.
  //
  if smi_proxy_handler_busy then begin
   complete:=false;
   if smi_test_action('START') then begin
    complete:=true;
    if complete then begin
     KickTime:=mSecNow; // Set marker of START to generate ERROR later for demo
     typ:=smi_proxy_handler_params_value_byname('TYPE');
     nr:=Val(smi_proxy_handler_params_value_byname('NR'));
     if IsSameText(typ,'PHYSICS') then smi_set_par('NUMBER_P',Str(nr+1),SMI_INTEGER);
     if IsSameText(typ,'TEST') then smi_set_par('NUMBER_T',Str(nr+1),SMI_INTEGER);
     smi_terminate_action('RUNNING');
    end;
   end else
   if smi_test_action('STOP') then begin
    complete:=(smi_proxy_handler_uptime>delay);
    if complete then begin
     KickTime:=0; // Reset marker
     smi_terminate_action('READY');
    end;
   end else
   if smi_test_action('RECOVER') then begin
    complete:=(smi_proxy_handler_uptime>delay);
    if complete then begin
     KickTime:=0; // Reset marker
     smi_terminate_action('READY');
    end;
   end else
   begin // Unknown action came
    KickTime:=0; // Reset marker
    smi_terminate_action('ERROR');
    Problem('Unknown action came: '+smi_proxy_handler_action);
   end;
  end else
  //
  // SMI Proxy IDLE operations.
  // Do when actions completed.
  //
  if smi_proxy_handler_idle then begin
   if (period>0) then
   if msElapsedSinceMarker(KickTime)>period then begin
    smi_set_state('ERROR');
    KickTime:=0;
   end;
  end;
  typ:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearSmiProxy;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('@StartupScript','@FinallyScript');
  StdIn_SetTimeouts(0,60000,0,3000);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitSmiProxy;
  InitEvtBuilder;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreeSmiProxy;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if ShouldPollSmiProxy then PollSmiProxy;
  SmiProxyLogic;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   !!! Handle SMI Proxy by default handler !!!
   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   }
   if smi_proxy_default_handler(Data,cmd,arg,cmdid) then begin
    if (Data<>'') then Success(smi_proxy_prompt+Data);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
