 {
 ***********************************************************************
 Daq Pascal application program pacman
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Cheat - cheats (are you cheater??!)
|********************************************************
[]
 }
program pacman;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 mapWidth = 19;                  {                                  }
 mapHeight = 21;                 {              ******              }
 sttGaming = 1;                  {         ****************         }
 sttPaused = 2;                  {      ****              ****      }
 sttLoss = 3;                    {    ***                    ***    }
 sttDeath = 4;                   {   **                        **   }
 scorePoint = 10;                {  **                          **  }
 maxLives = 3;                   {  **                          **  }
 deathTimer = 1000;              { **      ****        ****      ** }
 facePacman = '@';               { **     ******      ******     ** }
 faceBlinky = 'B';               { **                            ** }
 facePinky = 'P';                { **                            ** }
 faceInky = 'I';                 {  **    ******************    **  }
 faceClyde = 'C';                {  **    ******************    **  }
 faceDeath = 'X';                {   **     **************     **   }
 faceWall = '#';                 {    ***       ******       ***    }
 faceFood = '.';                 {      ****              ****      }
 faceField = ' ';                {         ****************         }
 newGameBtn = 'N';               {              ******              }
 pauseBtn = 'P';                 {                                  }
 sttError = 666;                 {                                  }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 TArray = record
  y : array [0..mapHeight] of Char;
 end;

 TTagArray = record
  tagY : array [0..mapHeight] of Integer;
 end;

 TGhost = record
  x, y, s, d : Integer;
 end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 map : record
  x  : array [0..mapWidth] of TArray;
  tagX : array [0..mapWidth] of TTagArray;
 end;

 mov : record
  x  : array [0..mapWidth] of TArray;
 end;

 pacman, blinky, pinky, inky, clyde : TGhost;
 score, bestScore : Integer;
 tagScore, tagBestScore : Integer;
 tagLevel, tagStatus : Integer;
 tagLives : Integer;
 gameState, level, lives : Integer;
 maxCoins, coinsCount : Integer;
 deathTime : Real;
 cmdCheat : Integer;

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {}
 procedure Inc(var i:Integer);
 begin
  i:=i+1;
 end;

 {}
 procedure SetTagMap(x,y:Integer);
 var cell:Integer;
 begin
  if (mov.x[x].y[y]=faceField) then cell:=0 else
  if (mov.x[x].y[y]=faceFood) then cell:=1 else
  if (mov.x[x].y[y]=facePacman) then cell:=2 else
  if (mov.x[x].y[y]=faceBlinky) then cell:=3 else
  if (mov.x[x].y[y]=facePinky) then cell:=4 else
  if (mov.x[x].y[y]=faceInky) then cell:=5 else
  if (mov.x[x].y[y]=faceClyde) then cell:=6 else
  if (mov.x[x].y[y]=faceDeath) then cell:=7 else
  if (mov.x[x].y[y]=faceWall) then cell:=8;
  bNul(iSetTag(map.tagX[x].tagY[y], cell));
 end;

 {}
 procedure RefreshMapTags;
 var i,j:Integer;
 begin
  for i:=0 to mapWidth-1 do begin
   for j:=0 to mapHeight-1 do begin
    SetTagMap(i, j);
   end;
  end;
 end;

 {}
 procedure DrawMap;
 var x,y:Integer;
 begin
  for y:=0 to mapHeight-1 do begin
   for x:=0 to mapWidth-1 do begin
    write(mov.x[x].y[y]);
   end;
   writeln('');
  end;
 end;

 {}
 procedure RefreshMovMap;
 var i,j:Integer;
 begin
  for i:=0 to mapWidth-1 do begin
   for j:=0 to mapHeight-1 do begin
    mov.x[i].y[j]:=map.x[i].y[j];
   end;
  end;
 end;

 {}
 procedure TagsInit(tagPrefix:String);
 var x,y:Integer;
 begin
  if not IsEmptyStr(tagPrefix) then begin
   InitTag(tagLives, tagPrefix+'.LIVES', 1);
   InitTag(tagLevel, tagPrefix+'.LEVEL', 1);
   InitTag(tagScore, tagPrefix+'.SCORE', 1);
   InitTag(tagStatus, tagPrefix+'.STATUS', 1);
   InitTag(tagBestScore, tagPrefix+'.BESTSCORE', 1);
   for y:=0 to mapHeight-1 do
    for x:=0 to mapWidth-1 do InitTag(map.tagX[x].tagY[y], tagPrefix+'.'+Str(x)+'.'+Str(y), 1);
  end else Trouble('Tag prefix is not specified!');
 end;

 {}
 procedure PacmanSelfInit;
 const pacmanInitPosX = 9;
       pacmanInitPosY = 19;
 begin
  pacman.x:=pacmanInitPosX;
  pacman.y:=pacmanInitPosY;
  pacman.s:=-1;
  pacman.d:=-1;
 end;

 {}
 procedure GhostsInit;
 const ghostInitPosX = 9;
       ghostInitPosY = 9;
 begin
  blinky.s:=VK_UP;
  pinky.s:=VK_UP;
  inky.s:=VK_UP;
  clyde.s:=VK_UP;
  blinky.x:=ghostInitPosX;
  blinky.y:=ghostInitPosY;
  pinky.x:=ghostInitPosX;
  pinky.y:=ghostInitPosY;
  inky.x:=ghostInitPosX;
  inky.y:=ghostInitPosY;
  clyde.x:=ghostInitPosX+2;
  clyde.y:=ghostInitPosY+1;
 end;

 {}
 procedure ReadMapFile;
 var x,y:Integer; mapFile,line:String;
  procedure Cleanup;
  begin
   mapFile:=''; line:='';
  end;
 begin
  Cleanup;
  maxCoins:=0; y:=0;
  mapFile:=AdaptFileName(DaqFileRef(AddPathDelim('..')+AddPathDelim('data')+'map.txt', '.txt'));
  if FileExists(mapFile) then begin
   iNul(reset(mapFile));
   while not eof do begin
    Readln(line);
    for x:=0 to Length(line)-1 do begin
     map.x[x].y[y]:=line[x+1];
     if (map.x[x].y[y]=faceFood) then Inc(maxCoins);
    end;
    Inc(y);
   end;
  end else begin
   gameState:=sttError;
   Trouble('Map file '+mapFile+' not found!');
  end;
  iNul(reset(''));
  Cleanup;
 end;

 {}
 procedure InitValues;
 begin
  coinsCount:=0;
  deathTime:=0;
  score:=0;
  level:=1;
  lives:=maxLives;
  if (gameState<>sttError) then gameState:=0;
 end;

 {}
 procedure InitGame;
 begin
  ReadMapFile;
  RefreshMovMap;
  RefreshMapTags;
  PacmanSelfInit;
  GhostsInit;
  InitValues;
 end;

 {}
 procedure PACMAN_Init;
 begin
  TagsInit(ReadIni('tagPrefix'));
  InitGame;
  DrawMap;
 end;

 {}
 procedure NewGame;
 begin
  bestScore:=Round(Max(bestScore, score));
  InitGame;
  if (gameState<>sttError) then gameState:=sttGaming;
 end;

 {}
 procedure PauseGame;
 begin
  if (gameState=sttGaming) then gameState:=sttPaused else
  if (gameState=sttPaused) then gameState:=sttGaming;
 end;

 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if (Length(s)>0) then ShowTooltip('guid '+Str(getpid)+'@'+ProgName+' text "'+s+'" preset stdHelp delay 15000 btn1 Справка cmd1 '
                         +AnsiQuotedStr(GetEnv('WantedWebBrowser')+' '+DaqFileRef(ReadIni('[DAQ] HelpFile'), '.htm'), QuoteMark));
 end;

 {}
 function IsWall(way:Integer; entity:TGhost):Boolean;
 begin
  IsWall:=false;
  if (way=VK_LEFT) then begin
   if (map.x[entity.x-1].y[entity.y]=faceWall) then IsWall:=true;
  end else if (way=VK_RIGHT) then begin
   if (map.x[entity.x+1].y[entity.y]=faceWall) then IsWall:=true;
  end else if (way=VK_UP) then begin
   if (map.x[entity.x].y[entity.y-1]=faceWall) then IsWall:=true;
  end else if (way=VK_DOWN) then begin
   if (map.x[entity.x].y[entity.y+1]=faceWall) then IsWall:=true;
  end;
 end;

 {}
 procedure SetDirOrWay;
 begin
  if not IsWall(ClickButton, pacman)
  then pacman.s:=ClickButton
  else pacman.d:=ClickButton;
 end;

 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var s:String; ClickCurve:Integer;
  procedure Cleanup;
  begin
   s:=''; ClickCurve:=0;
  end;
 begin
  Cleanup;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if (ClickWhat<>0) then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if ((ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown)) then begin
    pacman.d:=-1;
    if (ClickButton=VK_LEFT) then begin
     SetDirOrWay;
    end else
    if (ClickButton=VK_RIGHT) then begin
     SetDirOrWay;
    end else
    if (ClickButton=VK_UP) then begin
     SetDirOrWay;
    end else
    if (ClickButton=VK_DOWN) then begin
     SetDirOrWay;
    end;
    if (ClickButton=str2shortcut(newGameBtn)) then begin
     NewGame;
    end;
    if (ClickButton=str2shortcut(pauseBtn)) then begin
     PauseGame;
    end;
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle sensor clicks...
     }
     if IsSameText(ClickSensor, 'PACMAN.NEW.BT') then begin
      NewGame;
     end;
     if IsSameText(ClickSensor, 'PACMAN.PAUSE.BT') then begin
      PauseGame;
     end;
     if IsSameText(ClickSensor, 'HELP') then begin
      Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'), '.htm'));
      bNul(Voice(snd_Click));
     end;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve, ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  Cleanup;
 end;

 {}
 procedure SetPacmanWay;
 begin
  if not IsWall(pacman.d, pacman) then begin
   pacman.s:=pacman.d;
   pacman.d:=-1;
  end;
 end;

 {}
 procedure PacmanMove;
 begin
  if (pacman.d>0) then begin
   if ((pacman.d=VK_LEFT) and (pacman.s<>VK_RIGHT)) then begin
    SetPacmanWay;
   end else
   if ((pacman.d=VK_RIGHT) and (pacman.s<>VK_LEFT)) then begin
    SetPacmanWay;
   end else
   if ((pacman.d=VK_UP) and (pacman.s<>VK_DOWN)) then begin
    SetPacmanWay;
   end else
   if ((pacman.d=VK_DOWN) and (pacman.s<>VK_UP)) then begin
    SetPacmanWay;
   end;
  end;
  if (pacman.s=VK_LEFT) then begin
   if not IsWall(pacman.s, pacman) then pacman.x:=pacman.x-1;
  end else
  if (pacman.s=VK_RIGHT) then begin
   if not IsWall(pacman.s, pacman) then pacman.x:=pacman.x+1;
  end else
  if (pacman.s=VK_UP) then begin
   if not IsWall(pacman.s, pacman) then pacman.y:=pacman.y-1;
  end else
  if (pacman.s=VK_DOWN) then begin
   if not IsWall(pacman.s, pacman) then pacman.y:=pacman.y+1;
  end;
 end;

 {}
 function ChangeWay(var ghost:TGhost):Integer;
 const left=1; right=2; up=3; down=4;
 var r,result,way:Integer;
 begin
  way:=ghost.s; result:=way;
  if ((way=VK_LEFT) or (way=VK_RIGHT)) then begin
   r:=Round(Random(up, down));
  end else
  if ((way=VK_UP) or (way=VK_DOWN)) then begin
   r:=Round(Random(left, right));
  end;
  if (r=left) then begin
   if not IsWall(VK_LEFT, ghost) then result:=VK_LEFT else
   if not IsWall(VK_RIGHT, ghost) then result:=VK_RIGHT;
  end else if (r=right) then begin
   if not IsWall(VK_RIGHT, ghost) then result:=VK_RIGHT else
   if not IsWall(VK_LEFT, ghost) then result:=VK_LEFT;
  end else if (r=up) then begin
   if not IsWall(VK_UP, ghost) then result:=VK_UP else
   if not IsWall(VK_DOWN, ghost) then result:=VK_DOWN;
  end else if (r=down) then begin
   if not IsWall(VK_DOWN, ghost) then result:=VK_DOWN else
   if not IsWall(VK_UP, ghost) then result:=VK_UP;
  end;
  if ((way=VK_LEFT) and (result=VK_LEFT)) then begin
   if IsWall(VK_LEFT, ghost) then result:=VK_RIGHT;
  end else if ((way=VK_RIGHT) and (result=VK_RIGHT)) then begin
   if IsWall(VK_RIGHT, ghost) then result:=VK_LEFT;
  end else if ((way=VK_UP) and (result=VK_UP)) then begin
   if IsWall(VK_UP, ghost) then result:=VK_DOWN;
  end else if ((way=VK_DOWN) and (result=VK_DOWN)) then begin
   if IsWall(VK_DOWN, ghost) then result:=VK_UP;
  end;
  ChangeWay:=result;
 end;

 {}
 procedure GhostMove(var ghost:TGhost);
 var x,y:Integer;
 begin
  x:=ghost.x; y:=ghost.y;
  if (ghost.s=VK_LEFT) then begin
   if not IsWall(VK_LEFT, ghost) then ghost.x:=x-1 else ghost.s:=ChangeWay(ghost);
  end else
  if (ghost.s=VK_RIGHT) then begin
   if not IsWall(VK_RIGHT, ghost) then ghost.x:=x+1 else ghost.s:=ChangeWay(ghost);
  end else
  if (ghost.s=VK_UP) then begin
   if not IsWall(VK_UP, ghost) then ghost.y:=y-1 else ghost.s:=ChangeWay(ghost);
  end else
  if (ghost.s=VK_DOWN) then begin
   if not IsWall(VK_DOWN, ghost) then ghost.y:=y+1 else ghost.s:=ChangeWay(ghost);
  end;
 end;

 {}
 procedure RefreshMap;
 var i,j:Integer;
 begin
  for i:=0 to mapWidth-1 do begin
   for j:=0 to mapHeight-1 do begin
    mov.x[i].y[j]:=map.x[i].y[j];
   end;
  end;
 end;

 {}
 procedure PacmanMoving;
 begin
  if (SysTimer_Pulse(200)>0) then begin
   PacmanMove;
  end;
 end;

 {}
 procedure GhostMoving;
 begin
  if (SysTimer_Pulse(210-level*10)>0) then begin
   GhostMove(blinky);
   GhostMove(pinky);
   GhostMove(inky);
   GhostMove(clyde);
  end;
  if (SysTimer_Pulse(350+Round(Random(10, 100)))>0) then blinky.s:=ChangeWay(blinky);
  if (SysTimer_Pulse(450+Round(Random(10, 150)))>0) then pinky.s:=ChangeWay(pinky);
  if (SysTimer_Pulse(550+Round(Random(10, 200)))>0) then inky.s:=ChangeWay(inky);
  if (SysTimer_Pulse(650+Round(Random(10, 250)))>0) then clyde.s:=ChangeWay(clyde);
 end;

 {}
 procedure Teleport(var entity:TGhost);
 const magicY=9; magicX1=0; magicX2=18;
 begin
  if ((entity.x=magicX1) and (entity.y=magicY)) then entity.x:=magicX2-1;
  if ((entity.x=magicX2) and (entity.y=magicY)) then entity.x:=magicX1+1;
 end;

 {}
 procedure LevelUp;
 begin
  Inc(level);
  ReadMapFile;
  RefreshMovMap;
  RefreshMapTags;
  PacmanSelfInit;
  GhostsInit;
  coinsCount:=0;
  gameState:=sttGaming;
  SysTimer_Init;
 end;

 {}
 procedure LoseLife;
 begin
  lives:=lives-1;
  if (lives>0) then begin
   deathTime:=mSecNow;
   gameState:=sttDeath;
  end else begin
   gameState:=sttLoss;
  end;
 end;

 {}
 procedure PacmanRevival;
 begin
  if (mSecNow>=deathTime+deathTimer) then begin
   RefreshMovMap;
   RefreshMapTags;
   PacmanSelfInit;
   GhostsInit;
   gameState:=sttGaming;
  end;
 end;

 {}
 function IsCaughtPacman:Boolean;
 begin
  if ((pacman.x=blinky.x) and (pacman.y=blinky.y)) or
     ((pacman.x=pinky.x)  and (pacman.y=pinky.y)) or
     ((pacman.x=inky.x)   and (pacman.y=inky.y)) or
     ((pacman.x=clyde.x)  and (pacman.y=clyde.y))
  then isCaughtPacman:=true
  else isCaughtPacman:=false;
 end;

 {}
 procedure KillPacman;
 begin
  mov.x[pacman.x].y[pacman.y]:=faceDeath;
  LoseLife;
 end;

 {}
 procedure DrawGhost(var entity:TGhost; c:Char);
 begin
  mov.x[entity.x].y[entity.y]:=c;
 end;

 {}
 function FoundFood:Boolean;
 begin
  if (map.x[pacman.x].y[pacman.y]=faceFood)
  then FoundFood:=true
  else FoundFood:=false;
 end;

 {}
 procedure EatFood;
 begin
  map.x[pacman.x].y[pacman.y]:=faceField;
  score:=score+scorePoint*level;
  Inc(coinsCount);
 end;

 {}
 procedure UpdateTags;
 begin
  bNul(iSetTag(tagLives, lives));
  bNul(iSetTag(tagLevel, level));
  bNul(iSetTag(tagScore, score));
  bNul(iSetTag(tagBestScore, bestScore));
 end;

 {}
 procedure PACMAN_Poll;
 begin
  DrawGhost(pacman, facePacman);
  DrawGhost(blinky, faceBlinky);
  DrawGhost(pinky, facePinky);
  DrawGhost(inky, faceInky);
  DrawGhost(clyde, faceClyde);
  if IsCaughtPacman then KillPacman;
  Teleport(pacman);
  Teleport(blinky);
  Teleport(pinky);
  Teleport(inky);
  Teleport(clyde);
  DrawMap;
  writeln('Score '+Str(score)+' Best score '+Str(bestScore)+' / '+Str(coinsCount)+' / '+Str(maxCoins));
  RefreshMapTags;
  RefreshMap;
  if FoundFood then EatFood;
  if (coinsCount=maxCoins) then LevelUp;
  UpdateTags;
  GhostMoving;
  PacmanMoving;
 end;

 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;

 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  PACMAN_Init;
  StdIn_SetScripts('', '');
  StdIn_SetTimeouts(0, 0, 0, MaxInt);
  iNul(ClickFilter(ClickFilter(5)));
  iNul(ClickAwaker(ClickAwaker(1)));
  cmdCheat:=RegisterStdInCmd('@Cheat', '');
 end;

 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;

 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  GUIHandler;
  if (gameState=sttGaming) then PACMAN_Poll
  else if (gameState=sttDeath) then PacmanRevival;
  bNul(iSetTag(tagStatus, gameState));
 end;

 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 const heal='+'; healMax='++';
       lvlUp='l+'; lvlDn='l-';
       immortal='god';
 var cmd,arg,w1:String; cmdid:Integer;
  procedure Cleanup;
  begin
   cmd:=''; arg:=''; w1:='';
  end;
 begin
  Cleanup;
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  if GotCommandId(Data, cmd, arg, cmdid) then begin
   {
   @Cheat cheater!
   @Cheat + - heal one heart
   @Cheat ++ - heal to max lives
   @Cheat l+ - level up
   @Cheat l- - level down
   @Cheat god - pacman immortal
   }
   if (cmdid=cmdCheat) then begin
    // Do something, for example, make pacman faster or immortal
    if not IsEmptyStr(arg) then begin
     w1:=ExtractWord(1, arg);
     if IsSameText(w1, heal) then begin
      if (lives<maxLives) then Inc(lives);
     end else
     if IsSameText(w1, healMax) then begin
      lives:=maxLives;
     end else
     if IsSameText(w1, lvlUp) then begin
      Inc(level);
     end else
     if IsSameText(w1, lvlDn) then begin
      if (level>1) then level:=level-1;
     end;
     if IsSameText(w1, immortal) then begin
      lives:=MaxInt;
     end;
     SysTimer_Init;
    end;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data, cmd, arg);
  end;
  Data:='';
  Cleanup;
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***      PPPP        IIII          ******       ***}
{***    PP    PP    II    II      *        *     ***}
{***   PP O  O PP  II      II    *  X   X   *    ***}
{***   PP  __  PP  II O  O II    *  #####   *    ***}
{***   PP      PP  II      II     *        *     ***}
{***   PP/\/\/\PP  II/\/\/\II       ******       ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
