 {
 ***********************************************************************
 EDUTC main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @MenuCloseConfirmation - for internal use.
| @MenuToolsConfirmation - for internal use.
| @MenuToolsOpen - open Menu Tools dialog.
| @BrowseHelp    - open help file in browser.
|********************************************************
[]
 }
program edutc_main_ctrl;       { EDUTC main control program     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod = 1000;             { Polling period for smile face    }
 AwakePeriod = 100;              { Period of checks to awake DatSrv }

type
 TTagRef = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 TEDUTCMainRec = record        { Main control & GUI               }
  CMD    : record                { Commands to control GUI          }
   OPEN  : TTagRef;              { Open DAT file(s)                 }
   SAVE  : TTagRef;              { Save DAT file(s)                 }
   SOUND : TTagRef;              { Sound menu                       }
   SMILE : TTagRef;              { Smile menu                       }
   CLOSE : TTagRef;              { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;                            {                                  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 EDUTC     : record            { All EDUTC data                 }
  MAIN       : TEDUTCMainRec;  { Main control & GUI               }
  AwokeTime  : Real;             { Time when DatSrv last awoke      }
  DatSrvGate : TTagRef;          { Save data to DatSrv              }
 end;                            {                                  }
 cmd_MenuCloseConfirmation:Integer;{ Command @MenuCloseConfirmation }
 cmd_MenuToolsConfirmation:Integer;{ Command @MenuToolsConfirmation }
 cmd_MenuToolsOpen : Integer;    { @MenuToolsOpen                   }
 cmd_BrowseHelp    : Integer;    { @BrowseHelp                      }
 MenuToolsSelected : Integer;    { MenuTools selected item index    }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Initilize EDUTC.MAIN record tags
 }
 procedure TEDUTCMainRec_Init(var Rec:TEDUTCMainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.OPEN.tag,  TagPrefix+'.CMD.OPEN',  1);
   InitTag(Rec.CMD.SAVE.tag,  TagPrefix+'.CMD.SAVE',  1);
   InitTag(Rec.CMD.SOUND.tag, TagPrefix+'.CMD.SOUND', 1);
   InitTag(Rec.CMD.SMILE.tag, TagPrefix+'.CMD.SMILE', 1);
   InitTag(Rec.CMD.CLOSE.tag, TagPrefix+'.CMD.CLOSE', 1);
   Rec.CMD.CLOSE.val:=-1;
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Nice tooltip notifier.
 }
 procedure NiceNotify(aText:String; aDelay:Integer);
 begin
  if Length(aText)>0 then ShowTooltip('text "'+aText+'" preset stdNotify delay '+Str(aDelay));
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Get text of Close menu items
 }
 function MenuCloseItem(MenuClose:Integer):String;
 begin
  if MenuClose=0 then MenuCloseItem:='Продолжить работу'                          else
  if MenuClose=1 then MenuCloseItem:='Перезапустить сервер '+DatSrv               else
  if MenuClose=2 then MenuCloseItem:='Перезапустить сервер '+CronSrv              else
  if MenuClose=3 then MenuCloseItem:='Перезапустить сервер '+SpeakSrv             else
  if MenuClose=4 then MenuCloseItem:='Перезапустить сеанс АСУ'                    else
  if MenuClose=5 then MenuCloseItem:='Завершить текущий сеанс АСУ'                else
  if MenuClose=6 then MenuCloseItem:='Завершить работу АСУ и выйти из программы'  else
  if MenuClose=7 then MenuCloseItem:='Завершить работу АСУ и выключить компьютер' else
  MenuCloseItem:='';
 end;
 {
 Execute Close menu commands
 }
  {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu CLOSE Starter to start editing.
 }
 procedure MenuCloseStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@syseval @silent @tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:16\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 635 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
  {
 Menu CLOSE Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
  {
 Menu Tools Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  EDUTC.AwokeTime:=mSecNow;
  DevPostCmd(devDatSrv,'  ');
 end;
 {
 EDUTC clear strings
 }
 procedure EDUTC_CLEAR;
 begin
 end;
 {
 EDUTC initialization
 }
 procedure EDUTC_INIT;
 begin
  //
  // Initialize tags & devices...
  //
  TEDUTCMainRec_Init(EDUTC.MAIN,ReadIni('tagEDUTC')+'.MAIN');
  InitTag(EDUTC.DatSrvGate.tag,'DATSRV.GATE',-1);
  //
  // Initialize values...
  //
  MenuToolsSelected:=-1;
  EDUTC.AwokeTime:=0;
 end;
 {
 EDUTC finalization
 }
 procedure EDUTC_FREE;
 begin
 end;
 {
 EDUTC polling
 }
 procedure EDUTC_POLL;
 var nerrors:Real; ClickCurve:Integer;
 begin
  {
  Awake DatSrv to enforce data save.
  }
  if SysTimer_Pulse(AwakePeriod)>0 then bNul(iSetTag(EDUTC.DatSrvGate.tag,Ord(iGetTag(EDUTC.MAIN.CMD.SAVE.tag)<>0)));
  {
  Execute GUI commands
  }
  if iGetTag(EDUTC.MAIN.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '+URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.dat;*.crw'));
   bNul(iSetTag(EDUTC.MAIN.CMD.OPEN.tag,0));
  end;
  {
  Handle Smile button state
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   nerrors:=GetErrCount(-2);
   if nerrors>EDUTC.MAIN.CMD.SMILE.val then bNul(iSetTag(EDUTC.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(EDUTC.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(EDUTC.MAIN.CMD.SMILE.tag,1));
   EDUTC.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Menu Tools
   }
   MenuToolsHandler;
   { 
   Menu CLOSE
   }
   MenuCloseHandler;
   {
   Warning, Information dialog completion.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Warning') then sNul(Edit(''));
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Information') then sNul(Edit(''));
  end;
  if EditStateDone then begin
   Problem('Uncompleted edit detected!');
   sNul(Edit(''));
  end else
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Edit error detected!');
   sNul(Edit(''));
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Toolbar buttons...
     //
     ClickBitXorLocal(EDUTC.MAIN.CMD.OPEN.tag,1);
     ClickBitXorLocal(EDUTC.MAIN.CMD.SAVE.tag,1);
     ClickBitXorLocal(EDUTC.MAIN.CMD.SOUND.tag,1);
     ClickBitXorLocal(EDUTC.MAIN.CMD.CLOSE.tag,1);
     if ClickTag=EDUTC.MAIN.CMD.SAVE.tag then begin
      bNul(iSetTag(EDUTC.DatSrvGate.tag,Ord(iGetTag(EDUTC.MAIN.CMD.SAVE.tag)<>0)));
      if iGetTag(EDUTC.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
     end;
     if IsSameText(ClickSensor,'EDUTC.MAIN.CMD.HOME') then begin
      DevPostCmd(DevMySelf,'@Cron @Cron.Run EDUTC.MAIN.CTRL.HOME');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'EDUTC.MAIN.CMD.HELP') then begin
      DevPostCmd(DevMySelf,'@BrowseHelp');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'EDUTC.MAIN.CMD.TOOLS') then begin
      MenuToolsStarter;
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'EDUTC.MAIN.CMD.CLOSE') then begin
      bNul(Voice(snd_Click));
      MenuCloseStarter;
     end;
     //
     // Smile face button...
     //
     if ClickTag=EDUTC.MAIN.CMD.SMILE.tag then begin
      bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      bNul(iSetTag(EDUTC.MAIN.CMD.SMILE.tag,0));
      bNul(Voice(snd_Click));
     end;
     //
     // Select Plot & Tab windows by curve...
     //
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     //
     // Console commands: @url_encoded_sensor ...
     //
     if (strFetch(ClickSensor,1)='@') then begin
      DevSendCmd(devMySelf,url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Calibrations
     //
     if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
      bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
      bNul(Voice(snd_Click));
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  EDUTC_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  EDUTC_INIT;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmd(devMySelf,'@LoadIni');
  cmd_MenuCloseConfirmation:=RegisterStdInCmd('@MenuCloseConfirmation','');
  cmd_MenuToolsConfirmation:=RegisterStdInCmd('@MenuToolsConfirmation','');
  cmd_MenuToolsOpen        :=RegisterStdInCmd('@MenuToolsOpen',        '');
  cmd_BrowseHelp           :=RegisterStdInCmd('@BrowseHelp',           '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then DevPostCmd(devMySelf,'@SaveIni');
  EDUTC_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  EDUTC_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @BrowseHelp
   }
   if (cmdid=cmd_BrowseHelp) then begin
    rNul(Eval('@Global @Async @Silent @Run WebBrowser '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm')));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
