---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Пример demo_benchmark

---

Программа служит для оценки производительности и тестирования работы компилятора **DAQ PASCAL**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Как работает demo_benchmark

Здесь надо отметить следующее:

- Компилятор **DAQ PASCAL** создает код виртуальной **DAQ**-машины,
  то есть некоторый промежуточный код, называемый **P-кодом**,
  который затем исполняется интерпретатором **P-кода**.

- В ходе тестов происходит циклическое исполнение фрагмента кода,
  содержащего некоторый набор типичных операторов **Pascal**.
  При этом оценивается:
  
    - **Pascal operators per second** - число операторов **Pascal** в секунду
    
    - **P-Code operators per second** - число операторов **P-кода** в секунду
    
    - **native operators per second** - число машинных инструкций (тактов процессора) в секунду
    
    - **native operators per Pascal operators** - число машинных инструкций на один оператор **Pascal**
    
    - **native operators per P-code operators** - число машинных инструкций на один оператор **P-кода**
    
    - **P-code operators per Pascal operators** -  - число операторов **P-кода** на один оператор **Pascal**

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Коды для тестирования

Конечно, указанные характеристики зависят от конкретного набора операторов **Pascal**, взятых для тестирования.  
Вопрос ведь в том, что считать оператором **Pascal**. Например, для тестов берутся такие фрагменты:

1. Тест 1 - набор из 10 простейших операторов вещественной арифметики.

``` pascal
x:=pi;    y:=1.0;
z:=x+y;   z:=x-y;
z:=x*y;   z:=x/y;
z:=x+1.0; z:=x-1.0;
z:=x*1.0; z:=x/1.0;
```

2. Тест 2 - вызов процедур/функций.  
   Для теста взята рекурсивная функция вычисления последовательности Фибонначи.  
   Оператором здесь считается каждый вызов функции.

``` pascal
Fibonnaci(20);

  где

function Fibonnaci(n:Integer):Integer;
begin
 if n<=2 then Fibonnaci:=1 else Fibonnaci:=Fibonnaci(n-1)+Fibonnaci(n-2);
end;
```

3. Тест 3 - набор из 10 простейших строковых операторов.

``` pascal
s:=dump(time);
s:=s+dump(time);
s:=dump(time)+dump(time);
s:=s+s;
x:=dump2r(s);
x:=dump2r(copy(s,9,8));
x:=dump2r(copy(s,17,8));
x:=dump2r(copy(s,25,8));
x:=dump2r(copy(s,33,8));
j:=pos('123',s);
```

При оценке производительности надо также иметь в виду, что число операторов **P-кода** на один оператор **Pascal**
определяется компилятором **Daq Pascal** и является константой для этого компилятора, не зависящей от процессора.
В то же время число машинных инструкций на один оператор **P-кода** может зависить от процессора и от реализации
интерпретатора, т.е. от версии **DAQ PASCAL**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Пример вывода

Если все в порядке, в консоли должно быть что-то вроде:

```
&BENCHMARK : RunCount 1066
&BENCHMARK : Performance, REAL := + - * / statement :
&BENCHMARK :         9.145 million Pascal operators per second
&BENCHMARK :        43.128 million P-Code operators per second
&BENCHMARK :      3010.684 million native operators per second
&BENCHMARK :       329.215 native operators per Pascal operators
&BENCHMARK :        69.808 native operators per P-code operators
&BENCHMARK :         4.716 P-code operators per Pascal operators
&BENCHMARK : Performance, CALL Fibonnaci(20) statement :
&BENCHMARK :         2.297 million Pascal operators per second
&BENCHMARK :        47.096 million P-Code operators per second
&BENCHMARK :      3010.682 million native operators per second
&BENCHMARK :      1310.514 native operators per Pascal operators
&BENCHMARK :        63.926 native operators per P-code operators
&BENCHMARK :        20.500 P-code operators per Pascal operators
&BENCHMARK : Performance, STRING := + copy pos dump statement :
&BENCHMARK :         0.783 million Pascal operators per second
&BENCHMARK :         4.708 million P-Code operators per second
&BENCHMARK :      3010.683 million native operators per second
&BENCHMARK :      3847.059 native operators per Pascal operators
&BENCHMARK :       639.467 native operators per P-code operators
&BENCHMARK :         6.016 P-code operators per Pascal operators
&BENCHMARK : Performance, TOTAL :
&BENCHMARK :         4.076 million Pascal operators per second
&BENCHMARK :        31.880 million P-code operators per second
&BENCHMARK :      3010.698 million native operators per second
&BENCHMARK :       738.691 native operators per Pascal operators
&BENCHMARK :        94.440 native operators per P-code operators
&BENCHMARK :         7.822 P-code operators per Pascal operators
&BENCHMARK : CPU frequency is about 3010.698 MHz
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Желаем успешного использования тестовой программы **demo_benchmark**.

---

> **CRW-DAQ** Copyright (c) 2001-2024 Alexey Kuryakin <daqgroup@mail.ru>

---
