{******************************************************************
 Генератор псевдослучайных чисел.
 Оригинал с сайта НИВЦ МГУ.
 ******************************************************************}
{$mode objfpc}
program gsu1r_p;

{Остаток от деления}
function Emod(Arg1,Arg2 :Extended):Extended;
Var
  
begin
  Result := Arg1 -(Int(arg1 / arg2 ) * arg2);
end;

// Вычисление псевдослучайных чисел с равномерным распределением
// в диапазоне от 0 до 1
// Входные параметры:
//	ISEED - целая переменная, значение которой перед обращением 
//		к подпрограмме может быть любым целым числом в пределах 
//		[1..2147483646]; по окончании работы ее значение полагается 
//		равным (2^31) * R (N), и это значение может быть использовано 
//		при последующем вхождении в подпрограмму;
//	N - 	заданное количество генерируемых псевдослучайных чисел (тип: целый);
//	R - 	вещественный массив длины N, содержащий вычисленные псевдослучайные числа. 
procedure GSU1R(var ISEED :Integer; N :Integer; var R :Array of Real);
var
  I :Integer;
  Z :Extended;
const
  D2P31M :Extended = 2147483647.0e0;
  D2PN31 :Extended = 4.656612873077393e-10;
  D2P32M :Integer = 16807;

begin
  Z := (ISEED);
  for I:=1 to N do
  begin
    Z := Emod2(D2P32M*Z,D2P31M);
    R[I-1] := Z*D2PN31;
  end;
  ISEED := Trunc( Z );
end;

var
  ISEED,N, i :Integer;
  R :Array [0..2] of Real;
begin
  ISEED := 123457;
  N := 3;
  GSU1R(ISEED,N,R);
  for i:=0 to 2 do
    writeln(r[i]);
end.
