/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.Memory;
import dim.MutableMemory;
import dim.Native;

public class ObjectDescriptor {
    long objectDescriptorAddress;
    Class theClass;
    int offset;

    static {
        Native.loadNativeLibrary();
    }

    public ObjectDescriptor(Class aClass, int initialEntries) {
        this.theClass = aClass;
        this.objectDescriptorAddress = ObjectDescriptor.newObjectDescriptor(this.theClass, initialEntries);
        this.offset = 0;
    }

    public ObjectDescriptor(Class theClass) {
        this.objectDescriptorAddress = ObjectDescriptor.newObjectDescriptor(theClass, 10);
    }

    public void addField(String fieldName, String fieldType) {
        this.offset += ObjectDescriptor.addFieldToObjectDescriptor(this.objectDescriptorAddress, fieldName, fieldType, this.offset);
    }

    public Object newObject(Memory nativeData) throws Memory.ReadingOutOfBoundException {
        Object target;
        int size = this.offset;
        if (size < 0 || nativeData.dataFetchOffset + size > nativeData.highWaterMark) {
            throw new Memory.ReadingOutOfBoundException();
        }
        try {
            target = this.theClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
        ObjectDescriptor.copyIntoObject(nativeData.dataAddress + (long)nativeData.dataFetchOffset, target, this.objectDescriptorAddress);
        nativeData.dataFetchOffset += size;
        return target;
    }

    public void copyIntoObject(Object target, Memory nativeData) throws Memory.ReadingOutOfBoundException {
        int size = this.offset;
        if (size < 0 || nativeData.dataFetchOffset + size > nativeData.highWaterMark) {
            throw new Memory.ReadingOutOfBoundException();
        }
        ObjectDescriptor.copyIntoObject(nativeData.dataAddress + (long)nativeData.dataFetchOffset, target, this.objectDescriptorAddress);
        nativeData.dataFetchOffset += size;
    }

    public void copyFromObject(Object source, MutableMemory nativeData) throws MutableMemory.NoRoomException {
        int size = this.offset;
        if (nativeData.dataStoreOffset + size > nativeData.allocatedSize) {
            throw new MutableMemory.NoRoomException();
        }
        ObjectDescriptor.copyFromObject(nativeData.dataAddress + (long)nativeData.dataStoreOffset, source, this.objectDescriptorAddress);
        nativeData.dataStoreOffset += size;
        if (nativeData.highWaterMark < nativeData.dataStoreOffset) {
            nativeData.highWaterMark = nativeData.dataStoreOffset;
        }
    }

    protected void finalize() {
        ObjectDescriptor.deleteObjectDescriptor(this.objectDescriptorAddress);
    }

    public void dumpInternalData(int dumpOptions) {
        Memory.dumpInternalData(this.objectDescriptorAddress, 128, dumpOptions);
    }

    private static native long newObjectDescriptor(Class var0, int var1);

    private static native int addFieldToObjectDescriptor(long var0, String var2, String var3, int var4);

    private static native void deleteObjectDescriptor(long var0);

    private static native void copyIntoObject(long var0, Object var2, long var3);

    private static native void copyFromObject(long var0, Object var2, long var3);
}

