@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright(c) 2020 Alexey Kuryakin kouriakine@mail.ru
:: SmiCheckDll.cmd - Tool to check smirtl.dll, smiuirtl.dll
:: exported methods is corresponded to his *.pas interfaces
:: Uses UnixUtils, http://crw-daq.su/download/unixutils/
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Main
pushd "%~dp0" && ( call :OnCheckDll smirtl & call :OnCheckDll smiuirtl )
popd
goto :EOF

:OnCheckDll
set /a ngood=0
set /a nfail=0
echo.
echo Checking %1.pas and %1.dll ...
echo.
call :CheckDll "%1.pas" "..\smi\bin\%1.dll"
echo.
echo Check %1.pas external links with %1.dll results:
echo GOOD: %ngood%   FAIL: %nfail%
echo.
ping -n 6 localhost >nul 2>nul
goto :EOF

:CheckDll
::type %1 | unix grep external | unix sed 's/.*name \''//' | unix sed 's/\''.*//'
for /f "usebackq delims=" %%i in (`type %1 ^| unix grep external ^| unix sed 's/.*name \''//' ^| unix sed 's/\''.*//'`) do call :CheckItem %%i %2
goto :EOF

:CheckItem
::for /f "delims=" %%j in ('unix strings -n 7 %2 ^| unix grep %1') do if "%%~j" == "%~1" goto :CheckGood
for /f "delims=" %%j in ('unix pexports %2 ^| unix grep %1') do if "%%~j" == "%~1" goto :CheckGood
:CheckFail
set /a nfail+=1
echo FAIL: %1
goto :EOF
:CheckGood
set /a ngood+=1
echo GOOD: %1
goto :EOF
