		//----------------------------------------------------------
		// Consts
		//----------------------------------------------------------
		// Object's parameter names
		var opnValue = 'value';
		var opnTitle = 'title';
		var opnHelpLink = 'helpLink';
		var opnExampleLink = 'exampleLink';
		var opnId = 'elementId';

		// Script variables
		var svG = '';
		var svI = '';
		var svOper = 'VRegExp.exec(AInputText)';
		var addOper = '';
		var svReplaceParam = '';
		var svReplaceParamComment = '';
		var ButtCount = 0;
		//----------------------------------------------------------
		// Functions
		//----------------------------------------------------------

		function ExecScript(AScriptText, VInputText, VReplaceText) {
			var VRegExp = new RegExp(/function .*{([\W\w]*)}$/);
			var Arr = VRegExp.exec(AScriptText);
			var VResult = '';
			try {
				var taInputText = document.getElementById('taInputText');
				var rbtnreplace = document.getElementById('rbtnreplace')
				if (rbtnreplace && rbtnreplace.checked) {
					VResult = (new Function ('AInputText', 'AReplaceText', Arr[1]))(VInputText, VReplaceText);
				} else {
					VResult = (new Function ('AInputText', Arr[1]))(VInputText);
				}
			}
			catch(err) {
				var VedtRegExp = document.getElementById('edtRegExp');
				if (VedtRegExp.value) {
					return 'Error. Please input correct expression';
				}
			}
			return VResult;
		}
		
		function GetScriptText(VRegExp) {
			var VRegExp = "/" + VRegExp + "/" + svG + svI;
			var VResult =
				"  // AInputText - входной текс \n" +
				svReplaceParamComment +
				"  // VRegExp - экземпляр объекта RegExp (регулярное выражение)\n" +
				"  // VResult - результат полученный после применения регулярного выражения \n" +
				"  function GetText(AInputText" + svReplaceParam + ") { \n" +
				"    var VRegExp = new RegExp(" + VRegExp + ");\n" +
					(addOper ? ("    " + addOper + ";\n") : "") +
				"    var VResult = " + svOper + "; \n" +
				"    return VResult; \n" +
				"  }"
			return VResult;
		}

		function SetScriptText(ARegExpValue) {
			VResult = GetScriptText(ARegExpValue);
			var taJScript = document.getElementById('taJScript');
			taJScript.value = VResult;
			return VResult;
		}

		function GetButObj(AValue, ATitle, AHelpLink, AExampleLink) {
			var ButObj = new Object();
			ButObj[opnValue] = AValue;
			ButObj[opnTitle] = ATitle;
			ButObj[opnHelpLink] = AHelpLink;
			ButObj[opnExampleLink] = AExampleLink;
			return ButObj;
		}

		function GetButtonArr(ButtonArr, AColCount) {
			var Length = ButtonArr.length;
			var HTMLText = '<table>';
			var ColInRow = 0;
			for (var i = 0; i < Length; i++) {
				if ((ColInRow >= AColCount) || (!ColInRow)) {
					HTMLText = HTMLText + '<tr>';
					ColInRow = 0;
				}
				var btnName = "btn" + ButtCount++;
				var ButObj = ButtonArr[i];
				var HelpLinkText = ButObj[opnHelpLink] ? 
					("<br><a target=_blank href='" + ButObj[opnHelpLink] + "'>Описание</a>") : "";
				var ExampleLinkText = ButObj[opnExampleLink] ? 
					("<a style='padding-left:10px' target=_blank href='" + 
					 	ButObj[opnExampleLink] + "'>Пример</a>") : "";
				HTMLText += '<td>';
				HTMLText += "<input class=litbut id='" + btnName + "' name='" + btnName
					+ "' type='button' value='" + ButObj[opnValue]
					+ "' onClick='GetButtonValue(id);' title=\"" + ButObj[opnTitle] 
					+  HelpLinkText + ExampleLinkText + "\">";
				ColInRow++;
			}
			HTMLText += '</table>';
			document.write(HTMLText);
		}

		function GetRadioButtonArr(ButtonArr, AColCount) {
			var Length = ButtonArr.length;
			var HTMLText = '<table>';
			var ColInRow = 0;
			for (var i = 0; i < Length; i++) {
				if ((ColInRow >= AColCount) || (!ColInRow)) {
					HTMLText = HTMLText + '<tr>';
					ColInRow = 0;
				}
				var btnName = "rbtnGroup";
				var ButObj = ButtonArr[i];
				var objValue = ButObj[opnValue];
				ButtCount++;
				var btnID = "rbtn" + objValue;
				ButObj[opnId] = btnID;
				var HelpLinkText = ButObj[opnHelpLink] ? 
					("<br><a target=_blank href='" + ButObj[opnHelpLink] + "'>Описание</a>") : "";
				HTMLText += '<td>';
				HTMLText += "<div class='rbut'><input ";
				if (i==0) {
					HTMLText += "checked ";
				}
				HTMLText += "id='" + btnID + "' name='" + btnName
					+ "' value='" + objValue
					+ "' type='radio' onClick='OnCheckRadioBut(id);' title=\"" + ButObj[opnTitle] + HelpLinkText + "\">"
					+ objValue + "</input></div><td><a target='_blank' href='" + ButObj[opnHelpLink] + "' title='Подробное описание'><div id='help'></div></a>";
				ColInRow++;
			}
			HTMLText += '</table>';
			document.write(HTMLText);
			return ButtonArr;
		}

		function GetCheckButtonArr(ButtonArr, AColCount) {
			var Length = ButtonArr.length;
			var HTMLText = '<table align=left>';
			var ColInRow = 0;
			for (var i = 0; i < Length; i++) {
				if ((ColInRow >= AColCount) || (!ColInRow)) {
					HTMLText += '<tr>';
					ColInRow = 0;
				}
				var ButObj = ButtonArr[i];
				var objValue = ButObj[opnValue];
				HTMLText += '<td>';
				HTMLText += "<div class=chbut title='" + ButObj[opnTitle] + "'><input ";
				HTMLText += " id='" + objValue + "' name='" + objValue
					+ "' value='" + ButObj[opnValue]
				+ "' type='checkbox' onClick='OnCheckCheckBut(id);'>"
					+ objValue + "</input></div>";
				ColInRow++;
			}
			HTMLText += '</table>';
			document.write(HTMLText);
		}

		function GetMengButtonArr(ButtonArr, AColCount) {
			var Length = ButtonArr.length;
			var HTMLText = '<table align=right>';
			var ColInRow = 0;
			for (var i = 0; i < Length; i++) {
				if ((ColInRow >= AColCount) || (!ColInRow)) {
					HTMLText = HTMLText + '<tr>';
					ColInRow = 0;
				}
				var btnName = "mngbtn" + ButtCount++;
				var ButObj = ButtonArr[i];
				HTMLText += '<td>';
				HTMLText += "<input class=mengbut id='" + btnName + "' name='" + btnName
					+ "' type='button' value='" + ButObj[opnValue]
					+ "' onClick='OnClickMengButton(id);' title='" + ButObj[opnTitle] + "'>";
				ColInRow++;
			}
			HTMLText += '</table>';
			document.write(HTMLText);
		}

		function RefreshData() {
			var VedtRegExp = document.getElementById('edtRegExp');
			var taInputText = document.getElementById('taInputText');
			var VScriptText = SetScriptText(VedtRegExp.value);
			var taOutputText = document.getElementById('taOutputText');
			var VedtReplaceInput = document.getElementById('edtReplaceInput');
			taOutputText.value = ExecScript(VScriptText, taInputText.value, VedtReplaceInput.value);
		}
		//----------------------------------------------------------
		// HANDLES
		//----------------------------------------------------------
		function OnDataChangRegExp(ASerderId) {
			RefreshData();
		}

		function OnDataChangReplaceInput(ASerderId) {
			RefreshData();
		}

		function OnDataChangeInputText(ASenderId) {
			RefreshData();
		}

		function GetButtonValue(ASenderId) {
			var edtRegExp = document.getElementById('edtRegExp');
			var SenderValue = document.getElementById(ASenderId).value;
			var VRegExp = edtRegExp.value + SenderValue.replace(/\s/g,'');
			edtRegExp.value = VRegExp;
			RefreshData();
			edtRegExp.onfocus();
		}

		function OnCheckRadioBut(ASenderId) {
			addOper = '';
			svReplaceParam = '';
			svReplaceParamComment = '';
			var VReplaceInputColor = '#E9E9E9';
			var VReplaceInputDisabled = true;
			var VSenderElm = document.getElementById(ASenderId);
			var ElmValue = VSenderElm.value;
			if (ElmValue == 'replace') {
				svOper = 'AInputText.replace(VRegExp, AReplaceText)';
				svReplaceParam = ', AReplaceText';
				svReplaceParamComment = '  // AReplaceText - текст замены найденых совпадений \n';
				VReplaceInputColor = 'transparent';
				VReplaceInputDisabled = false;
			} else if (ElmValue == 'test') {
				svOper = 'VRegExp.test(AInputText)';
			} else if (ElmValue == 'lastIndex') {
				addOper = 'VRegExp.exec(AInputText)';
				svOper = 'VRegExp.lastIndex';
			} else if (ElmValue == 'source') {
				svOper = 'VRegExp.source';
			} else if (ElmValue == 'match') {
				svOper = 'AInputText.match(VRegExp)';
			} else if (ElmValue == 'search') {
				svOper = 'AInputText.search(VRegExp)';
			} else if (ElmValue == 'split') {
				svOper = 'AInputText.split(VRegExp)';
			} else {
				svOper = 'VRegExp.exec(AInputText)';
			}
			var edtReplaceInput = document.getElementById('edtReplaceInput');
			edtReplaceInput.disabled = VReplaceInputDisabled;
			RefreshData();
		}

		function OnClickMengButton(ASenderId) {
			var VSenderElm = document.getElementById(ASenderId);
			var VSenderValue = VSenderElm.value;
			if (VSenderValue == 'CE/C') {
				var VedtRegExp = document.getElementById('edtRegExp');	
				VedtRegExp.value = '';
				RefreshData();
				VedtRegExp.onfocus();
			} else
			if (VSenderValue == 'Backspace') {
				var VedtRegExp = document.getElementById('edtRegExp');	
				var VRegExpValue = VedtRegExp.value;
				VedtRegExp.value = VRegExpValue.slice(0, VRegExpValue.length - 1);
				RefreshData();
				VedtRegExp.onfocus();
			}
		}

		function OnCheckCheckBut(ASenderId) {
			var VSenderElm = document.getElementById(ASenderId);
			if (ASenderId == 'g') {
				VSenderElm.checked?svG='g':svG='';
			} else 
			if (ASenderId == 'i') {
				VSenderElm.checked?svI='i':svI='';
			} 
			RefreshData();
		}
        
        function BenchMarkIt(ASenderId) {
			var timeBench = Number(document.getElementById('timeBench').value);
            var VRegExp = new RegExp(edtRegExp.value);
			var VedtRegExp = document.getElementById('edtRegExp').value;
			// var taInputText = document.getElementById('taInputText').value;
			var AInputText = document.getElementById('taInputText').value;
            var AReplaceText = document.getElementById('edtReplaceInput').value;
            var counter = 0;
            var empty_counter = 0;
            var mark_start = 0;
            var operation = svOper;
            
            switch(svOper) {
                case 'AInputText.replace(VRegExp, AReplaceText)': {
                    console.log('!**! Выполняем replace');
                    mark_start = Date.now();
                    while (mark_start+timeBench > Date.now()) {
                        AInputText.replace(VRegExp, AReplaceText);
                        counter++;
                    }
                    break;
                }
                case 'VRegExp.test(AInputText)': {
                    console.log('!**! Выполняем test');
                    mark_start = Date.now();
                    while (mark_start+timeBench > Date.now()) {
                        VRegExp.test(AInputText);
                        counter++;
                    }
                    break;
                }
                case 'VRegExp.exec(AInputText)': {
                    console.log('!**! Выполняем exec');
                    mark_start = Date.now();
                    while (mark_start+timeBench > Date.now()) {
                        VRegExp.exec(AInputText);
                        counter++;
                    }
                    break;
                }
                case 'AInputText.replace(VRegExp, AReplaceText)': {
                    console.log('!**! Выполняем replace');
                    mark_start = Date.now();
                    while (mark_start+timeBench > Date.now()) {
                        AInputText.replace(VRegExp, AReplaceText)
                        counter++;
                    }
                    break;
                }
                case 'VRegExp.source': {                
                    console.log('!**! Выполняем source');
                    mark_start = Date.now();
                    while (mark_start+timeBench > Date.now()) {
                        VRegExp.source;
                        counter++;
                    }
                    break;
                }
                case 'AInputText.split(VRegExp)': {
                    console.log('!**! Выполняем split');
                    mark_start = Date.now();
                    while (mark_start+timeBench > Date.now()) {
                        AInputText.split(VRegExp);
                        counter++;
                    }
                    break;
                }
                case 'AInputText.match(VRegExp)': {
                    console.log('!**! Выполняем match');
                    mark_start = Date.now();
                    while (mark_start+timeBench > Date.now()) {
                        AInputText.match(VRegExp);
                        counter++;
                    }
                    break;
                }
                case 'VRegExp.lastIndex': {
                    console.log('!**! Выполняем lastIndex');
                    mark_start = Date.now();
                    while (mark_start+timeBench > Date.now()) {
                        VRegExp.lastIndex;
                        counter++;
                    }
                    break;
                }
                case 'AInputText.search(VRegExp)': {                
                    console.log('!**! Выполняем search');
                    mark_start = Date.now();
                    while (mark_start+timeBench > Date.now()) {
                        AInputText.search(VRegExp);
                        counter++;
                    }
                    break;
                }
            }
            
            var empty_mark_start = Date.now();
            while (empty_mark_start+timeBench > Date.now()) {
                empty_counter++;
            }
            
            console.log(svOper);
            console.log('!**! ЦИКЛОВ '+counter);
            var ExecTime = timeBench/counter*1000;
            var EmptyExecTime = timeBench/empty_counter*1000;
            console.log('!**! ВЫПОЛНЕНО ЗА '+ExecTime.toFixed(3)+' mksec., пустой цикл занял '+EmptyExecTime.toFixed(3)+' mksec.');
            
            document.getElementById('bech_output').innerHTML = 'Пустой цикл: <i>'+EmptyExecTime.toFixed(3)+'</i> mksec. Общее время: <i>'+ExecTime.toFixed(3)+'</i> mksec.';
            
			return VResult;
		}
