Option Explicit
dim WSO
set WSO = WScript.CreateObject("Scripting.WindowSystemObject")
WSO.EnableVisualStyles = true

dim MonoSize : MonoSize = 10
dim MonoFont : MonoFont = "PT Mono"
MonoFont = CheckMonoFont(MonoFont,"Courier New")
MonoFont = CheckMonoFont(MonoFont,"Consolas")
MonoFont = CheckMonoFont(MonoFont,"Courier")

dim NBSP : NBSP = chr(160)

dim Form
set Form = WSO.CreateForm()
Form.ClientWidth = 410
Form.ClientHeight = 360
Form.CenterControl()
Form.Text = NBSP+" DIM Control Center - GUI for DIM System"
call SetMonoFont(Form)
Form.Icon = GetHomeDir+"favicon.ico"
Form.CreateStatusBar().Name = "StatusBar"
Form.StatusBar.Add(100).AutoSize = true
call SetMonoFont(Form.StatusBar)
Form.SizeGrip = false
Form.TopMost = true

'**** Button creation
'********************

dim bx,by,bw,bh,dw,dh
bx = 10 : by = 10 : bw = 190 : bh = 25 : dw = 10 : dh = 5

dim ButtonDimDnsExecShow
set ButtonDimDnsExecShow = Form.CreateButton(bx,by,bw,bh,"DNS.EXE   Exec + Show")
ButtonDimDnsExecShow.OnClick = GetRef("ButtonDimDnsExecShowClick")
call SetMonoFont(ButtonDimDnsExecShow)
by = by + bh + dh

dim ButtonDimDnsExecHide
set ButtonDimDnsExecHide = Form.CreateButton(bx,by,bw,bh,"DNS.EXE   Exec + Hide")
ButtonDimDnsExecHide.OnClick = GetRef("ButtonDimDnsExecHideClick")
call SetMonoFont(ButtonDimDnsExecHide)
by = by + bh + dh

dim ButtonDimDnsShow
set ButtonDimDnsShow = Form.CreateButton(bx,by,bw,bh,"DNS.EXE   Show Window")
ButtonDimDnsShow.OnClick = GetRef("ButtonDimDnsShowClick")
call SetMonoFont(ButtonDimDnsShow)
by = by + bh + dh

dim ButtonDimDnsHide
set ButtonDimDnsHide = Form.CreateButton(bx,by,bw,bh,"DNS.EXE   Hide Window")
ButtonDimDnsHide.OnClick = GetRef("ButtonDimDnsHideClick")
call SetMonoFont(ButtonDimDnsHide)
by = by + bh + dh

dim ButtonDimDnsClose
set ButtonDimDnsClose = Form.CreateButton(bx,by,bw,bh,"DNS.EXE  Close Window")
ButtonDimDnsClose.OnClick = GetRef("ButtonDimDnsCloseClick")
call SetMonoFont(ButtonDimDnsClose)
by = by + bh + dh

dim ButtonDimDnsKill
set ButtonDimDnsKill = Form.CreateButton(bx,by,bw,bh,"DNS.EXE  Kill Process")
ButtonDimDnsKill.OnClick = GetRef("ButtonDimDnsKillClick")
call SetMonoFont(ButtonDimDnsKill)
by = by + bh + dh

dim ButtonDimDnsDebugOn
set ButtonDimDnsDebugOn = Form.CreateButton(bx,by,bw,bh,"DNS.EXE      Debug ON")
ButtonDimDnsDebugOn.OnClick = GetRef("ButtonDimDnsDebugOnClick")
call SetMonoFont(ButtonDimDnsDebugOn)
by = by + bh + dh

dim ButtonDimDnsDebugOff
set ButtonDimDnsDebugOff = Form.CreateButton(bx,by,bw,bh,"DNS.EXE     Debug OFF")
ButtonDimDnsDebugOff.OnClick = GetRef("ButtonDimDnsDebugOffClick")
call SetMonoFont(ButtonDimDnsDebugOff)
by = by + bh + dh

dim ButtonDimStatCli
set ButtonDimStatCli = Form.CreateButton(bx,by,bw,bh,"DimStat Utility - CLI")
ButtonDimStatCli.OnClick = GetRef("ButtonDimStatCliClick")
call SetMonoFont(ButtonDimStatCli)
by = by + bh + dh

dim ButtonDimStatGui
set ButtonDimStatGui = Form.CreateButton(bx,by,bw,bh,"DimStat Utility - GUI")
ButtonDimStatGui.OnClick = GetRef("ButtonDimStatGuiClick")
call SetMonoFont(ButtonDimStatGui)
by = by + bh + dh

dim ButtonDimMonitor1
set ButtonDimMonitor1 = Form.CreateButton(bx,by,bw,bh,"DimMonitor --number 1")
ButtonDimMonitor1.OnClick = GetRef("ButtonDimMonitor1Click")
call SetMonoFont(ButtonDimMonitor1)
by = by + bh + dh

bx = bx + bw +dw
by = 10

dim ButtonClose
set ButtonClose = Form.CreateButton(bx,by,bw,bh,"Close  DIM Control GUI")
ButtonClose.OnClick = GetRef("ButtonCloseClick")
call SetMonoFont(ButtonClose)
by = by + bh + dh

dim ButtonDimHomeWebSite
set ButtonDimHomeWebSite = Form.CreateButton(bx,by,bw,bh,"DIM ==> Home Web Site")
ButtonDimHomeWebSite.OnClick = GetRef("ButtonDimHomeWebSiteClick")
call SetMonoFont(ButtonDimHomeWebSite)
by = by + bh + dh

dim ButtonDimIndexHtml
set ButtonDimIndexHtml = Form.CreateButton(bx,by,bw,bh,"DIM HELP:  index.html")
ButtonDimIndexHtml.OnClick = GetRef("ButtonDimIndexHtmlClick")
call SetMonoFont(ButtonDimIndexHtml)
by = by + bh + dh

dim ButtonDimReadmeHtm
set ButtonDimReadmeHtm = Form.CreateButton(bx,by,bw,bh,"DIM HELP:  readme.htm")
ButtonDimReadmeHtm.OnClick = GetRef("ButtonDimReadmeHtmClick")
call SetMonoFont(ButtonDimReadmeHtm)
by = by + bh + dh

dim ButtonDimCopy
set ButtonDimCopy = Form.CreateButton(bx,by,bw,bh,"DIM Copy to Common Dir")
ButtonDimCopy.OnClick = GetRef("ButtonDimCopyClick")
call SetMonoFont(ButtonDimCopy)
by = by + bh + dh

dim ButtonDimPortsAdd
set ButtonDimPortsAdd = Form.CreateButton(bx,by,bw,bh,"DIM Ports Add + Enable")
ButtonDimPortsAdd.OnClick = GetRef("ButtonDimPortsAddClick")
call SetMonoFont(ButtonDimPortsAdd)
by = by + bh + dh

dim ButtonDimPortsShow
set ButtonDimPortsShow = Form.CreateButton(bx,by,bw,bh,"DIM Ports   Show State")
ButtonDimPortsShow.OnClick = GetRef("ButtonDimPortsShowClick")
call SetMonoFont(ButtonDimPortsShow)
by = by + bh + dh

dim ButtonDimPortsDelete
set ButtonDimPortsDelete = Form.CreateButton(bx,by,bw,bh,"DIM Ports       Delete")
ButtonDimPortsDelete.OnClick = GetRef("ButtonDimPortsDeleteClick")
call SetMonoFont(ButtonDimPortsDelete)
by = by + bh + dh

dim ButtonDimDidExec
set ButtonDimDidExec = Form.CreateButton(bx,by,bw,bh,"DID.EXE   Exec Program")
ButtonDimDidExec.OnClick = GetRef("ButtonDimDidExecClick")
call SetMonoFont(ButtonDimDidExec)
by = by + bh + dh

dim ButtonDimDimTreeOpen
set ButtonDimDimTreeOpen = Form.CreateButton(bx,by,bw,bh,"Start DIM TREE Browser")
ButtonDimDimTreeOpen.OnClick = GetRef("ButtonDimDimTreeOpenClick")
call SetMonoFont(ButtonDimDimTreeOpen)
by = by + bh + dh

dim ButtonDimMonitor2
set ButtonDimMonitor2 = Form.CreateButton(bx,by,(bw-dw)/2,bh,"--number 2")
ButtonDimMonitor2.OnClick = GetRef("ButtonDimMonitor2Click")
call SetMonoFont(ButtonDimMonitor2)
dim ButtonDimMonitor3
set ButtonDimMonitor3 = Form.CreateButton(bx+(bw-dw)/2+dw,by,(bw-dw)/2,bh,"--number 3")
ButtonDimMonitor3.OnClick = GetRef("ButtonDimMonitor3Click")
call SetMonoFont(ButtonDimMonitor3)
by = by + bh + dh

ButtonDimMonitor1.Font.Bold = true
ButtonDimMonitor2.Font.Bold = false
ButtonDimMonitor3.Font.Bold = false
ButtonDimStatGui.Font.Bold = true
ButtonDimDimTreeOpen.Font.Bold = true
ButtonDimHomeWebSite.Font.Bold = true
ButtonDimIndexHtml.Font.Bold = true
ButtonDimReadmeHtm.Font.Bold = true
ButtonClose.Font.Bold = true
ButtonClose.Cancel = true

'**** Event handlers
'*******************

sub ButtonDimDnsExecShowClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dns open show",7,false)
end sub

sub ButtonDimDnsExecHideClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dns exec hide",7,false)
end sub

sub ButtonDimDnsShowClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dns show",7,false)
end sub

sub ButtonDimDnsHideClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dns hide",7,false)
end sub

sub ButtonDimDnsCloseClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dns close",7,false)
end sub

sub ButtonDimDnsKillClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dns kill",7,false)
end sub

sub ButtonDimDnsDebugOnClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" sendcmd DIS_DNS/DEBUG_ON 1 -dns localhost -i",7,false)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" sendcmd DIS_DNS/PRINT_HASH_TABLE 1 -dns localhost -i",7,false)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" sendcmd DIS_DNS/PRINT_STATS 1 -dns localhost -i",7,false)
end sub

sub ButtonDimDnsDebugOffClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" sendcmd DIS_DNS/DEBUG_OFF 1 -dns localhost -i",7,false)
end sub

sub ButtonDimReadmeHtmClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" readme.htm",7,false)
end sub

sub ButtonDimCopyClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" copy & pause",1,false)
end sub

sub ButtonDimDidExecClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" did exec",7,false)
end sub

sub ButtonDimDimTreeOpenClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dimtree exec",7,false)
end sub

sub ButtonDimPortsAddClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dimports add & pause",1,false)
end sub

sub ButtonDimPortsShowClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dimports show & pause",1,false)
end sub

sub ButtonDimPortsDeleteClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dimports delete & pause",1,false)
end sub

sub ButtonCloseClick(this)
 Form.Close()
end sub

sub ButtonDimStatCliClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dimstatcli",7,false)
end sub

sub ButtonDimStatGuiClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" dimstatgui",7,false)
end sub

sub ButtonDimMonitor1Click(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" monitor --number 1",7,false)
end sub

sub ButtonDimMonitor2Click(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" monitor --number 2",7,false)
end sub

sub ButtonDimMonitor3Click(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" monitor --number 3",7,false)
end sub

sub ButtonDimIndexHtmlClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" index.html",7,false)
end sub

sub ButtonDimHomeWebSiteClick(this)
 call Run("cmd /c """+GetHomeDir+"dim.cmd"" HomeWebSite",7,false)
end sub

'**** Timer actions
'******************

dim TimerEachSec
set TimerEachSec = WSO.CreateTimer()
TimerEachSec.OnExecute = GetRef("TimerEachSecExecute")
TimerEachSec.Interval = 1000
TimerEachSec.Active = true

sub TimerEachSecExecute(Sender)
 dim pid : pid = FindDnsExe
 if (pid=0) then
  Form.StatusBar.Item(0).Text = " dns.exe is stopped"
  ButtonDimDnsExecShow.Enabled = true
  ButtonDimDnsExecHide.Enabled = true
  ButtonDimDnsShow.Enabled = false
  ButtonDimDnsHide.Enabled = false
  ButtonDimDnsClose.Enabled = false
  ButtonDimDnsKill.Enabled = false
  ButtonDimDnsDebugOn.Enabled = false
  ButtonDimDnsDebugOff.Enabled = false
  Form.StatusBar.Font.Bold = false
 else
  Form.StatusBar.Item(0).Text = " dns.exe ("+cstr(pid)+") is running"
  ButtonDimDnsExecShow.Enabled = false
  ButtonDimDnsExecHide.Enabled = false
  ButtonDimDnsShow.Enabled = true
  ButtonDimDnsHide.Enabled = true
  ButtonDimDnsClose.Enabled = true
  ButtonDimDnsKill.Enabled = true
  ButtonDimDnsDebugOn.Enabled = true
  ButtonDimDnsDebugOff.Enabled = true
  Form.StatusBar.Font.Bold = true
 end if
end sub

'**** Service routines
'*********************

dim WMI
set WMI = GetObject("winmgmts://./root/cimv2")

sub SetMonoFont(this)
 this.Font.Name = MonoFont
 this.Font.Size = MonoSize
end sub

sub Run(cmd,sw,Wait)
 dim wshShell
 set wshShell = CreateObject("WScript.Shell")
 call wshShell.Run(cmd,sw,Wait)
 set wshShell = Nothing
end sub

function GetHomeDir() ' Script path with trailing backslash
 GetHomeDir = left(WScript.ScriptFullName,InStrRev(WScript.ScriptFullName,"\"))
end function

function FindDnsExe()
 dim pid : pid = 0
 dim proc,p : set proc = WMI.ExecQuery("Select * From Win32_Process")
 for each p in proc : if (lcase(p.Name) = "dns.exe") then pid = p.ProcessId : end if : Next
 set proc = Nothing
 FindDnsExe = pid
end function

function FindFontReg(FontName)
 dim wshShell : set wshShell = CreateObject("WScript.Shell")
 on error resume next
 FindFontReg = wshShell.RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Fonts\"+FontName+" (TrueType)")
 if Err then FindFontReg = "" end if : Err.Clear
 on error goto 0
 set wshShell = Nothing
end function

function IsFontReg(FontName)
 IsFontReg = (FindFontReg(FontName) <> "")
end function

function CheckMonoFont(FontName,FallbackFont)
 if IsFontReg(FontName) then CheckMonoFont = FontName else CheckMonoFont = FallbackFont end if
end function

'**** Start GUI
'**************
Form.Show()
WSO.Run()