 {
 ***********************************************************************
 Daq Pascal application program VkbdSrv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @State=n       - Set state, Bit0=0/1=Rus/Eng, Bit1=0/1=Shift Off/On.
| @CharSet=s     - Set of avaiable chars, as URL-encoded string. Empty=all.
| @Language=n    - Set language 0/1=Rus/Eng
| @Home          - Put  &Vkbd.Ctrl window to default location.
| @WinShow       - Show &Vkbd.Ctrl window.
| @WinHide       - Hide &Vkbd.Ctrl window.
| @WinSelect     - Activate &Vkbd.Ctrl.
| @Label=s       - Set text for label.
| @Text=s        - Set text for edit.
| @Prev=s        - Set text for previous edit.
| @DevMsg=s      - Set device msg on Ok.
|                  Use %Text% to transfer Text "as is".
|                  Use %HexText%  to transfer Hex_Encode(Text).
|                  Use %UrlText%  to transfer Url_Packed(Text).
|                  Use %MimeText% to transfer Mime_Encode(Text).
|********************************************************
[]
 }
program VkbdSrv;                 { Virtual keyboard server control  }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 g_Lock            = 0;          { Access level - Lock              }
 g_Guest           = 1;          { Access level - Guest             }
 g_User            = 2;          { Access level - User              }
 g_Root            = 3;          { Access level - Root              }
 g_List            = 'Lock,Guest,User,Root'; { Guard levels         }
 snd_WinShow       = 'WinWheel'; { Sound on open window             }
 Languages         = 'Rus,Eng';  { List of supported languages      }
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 winVKbdCtrl       : String;     { VKbd control window              }
 tagVKbdText       : Integer;    { Input text                       }
 tagVKbdPrev       : Integer;    { Previous text                    }
 tagVKbdLabel      : Integer;    { Label text                       }
 tagVKbdState      : Integer;    { VKbd State                       }
 tagVKbdDevMsg     : Integer;    { VKbd device message on Ok click  }
 Language          : Integer;    { 0=Rus,1=Eng                      }
 CharSet           : String;     { Available chars                  }
 SizeFactor        : Integer;    { 0/1=Normal/Huge                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Speak hint message in format "Russian msg. English msg."
 }
 procedure SpeakHint(Pause:Integer; Hint:String);
 var p:Integer;
 begin
  p:=Pos('.',Hint);
  if p=0 then p:=Pos('?',Hint);
  if p>0 then begin
   if Language=0
   then Hint:=Trim(Copy(Hint,1,p))
   else Hint:=Trim(Copy(Hint,p+1));
  end;
  if Length(Hint)>0 then begin
   if Pause>0 then Hint:='\Pau='+Str(Pause)+'\'+Hint;
   Hint:=StrReplace(Hint,'м/с','метров в секунду',0);
   Hint:=StrReplace(Hint,'m/s','metre per second',0);
   Hint:=StrReplace(Hint,'м/мин','метров в минуту',0);
   Hint:=StrReplace(Hint,'m/min','metre per minute',0);
   Hint:=StrReplace(Hint,'кН','килоНьютонов',0);
   Hint:=StrReplace(Hint,'kN','kiloNewtons',0);
   Speak(Hint);
  end;
 end;
 {
 Get char name to speak.
 }
 function CharName(s:String):String;
  function RuEn(ru,en:String):String;
  begin
   if (Language=0)
   then RuEn:=ru
   else RuEn:=en;
  end;
 begin
  if (s=' ') then s:=RuEn('пробел','space');
  if (s='!') then s:=RuEn('восклицательный знак','exclamation');
  if (s='"') then s:=RuEn('кавычки','quotation');
  if (s='#') then s:=RuEn('решётка','number');
  if (s='$') then s:=RuEn('доллар','dollar');
  if (s='%') then s:=RuEn('процент','percent');
  if (s='&') then s:=RuEn('амперсанд','ampersand');
  if (s='''') then s:=RuEn('апостроф','apostrophe');
  if (s='(') then s:=RuEn('левая круглая скобка','left parenthesis');
  if (s=')') then s:=RuEn('правая круглая скобка','right paranthesis');
  if (s='*') then s:=RuEn('звёздочка','asterisk');
  if (s='+') then s:=RuEn('плюс','plus');
  if (s=',') then s:=RuEn('запятая','comma');
  if (s='-') then s:=RuEn('минус','minus');;
  if (s='.') then s:=RuEn('точка','dot');
  if (s='/') then s:=RuEn('слэш','slash');
  if (s=':') then s:=RuEn('двоеточие','colon');
  if (s=';') then s:=RuEn('точка с запятой','semicolon');
  if (s='<') then s:=RuEn('меньше','less');
  if (s='=') then s:=RuEn('равно','equal');
  if (s='>') then s:=RuEn('больше','more');
  if (s='?') then s:=RuEn('вопросительный знак','question');
  if (s='@') then s:=RuEn('собака','at sign');
  if (s='[') then s:=RuEn('левая квадратная скобка','left bracket');
  if (s='\') then s:=RuEn('обратный слэш','backslash');
  if (s=']') then s:=RuEn('правая квадратная скобка','right bracket');
  if (s='^') then s:=RuEn('крышка','circumflex');
  if (s='_') then s:=RuEn('знак подчёркивания','underscore');
  if (s='`') then s:=RuEn('обратный апостроф','grave accent');
  if (s='{') then s:=RuEn('левая фигурная скобка','left curly');
  if (s='|') then s:=RuEn('вертикальная черта','vertical line');
  if (s='}') then s:=RuEn('правая фигурная скобка','right curly');
  if (s='~') then s:=RuEn('тильда','tilde');
  if (s='№') then s:=RuEn('номер','number');
  if (s='€') then s:=RuEn('евро','euro');
  if (s='₽') then s:=RuEn('рубль','ruble');
  CharName:=s;
 end;
 {
 Check access level.
 }
 function GrantAccess(gWanted:Integer):Boolean;
 var gLevel:Integer;
 begin
  gLevel:=WordIndex(ParamStr('Guard'),g_List)-1;
  if gLevel>=gWanted then GrantAccess:=True else begin
   rNul(eval('@system @async @silent @menu run FormCrwDaq.ActionWindowsSecretService'));
   SpeakHint(200,'Требуется пароль '+ExtractWord(gWanted+1,g_List)+'. '
                 +ExtractWord(gWanted+1,g_List)+' password required.');
   bNul(Voice(snd_Deny));
   GrantAccess:=False;
  end;
 end;
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Get clicked char.
 }
 function GetClickChar:String;
 var s:String; p,n,c,ss:Integer;
 begin
  s:=Url_Decode(ClickParams('Hint'));
  p:=Pos(EOL,s); n:=Length(EOL);
  ss:=iGetTag(tagVKbdState);
  if (p>0) then s:=Copy(s,p+n) else s:='';
  if (p>0) and (s<>'')
  then c:=utf8_ord(s,1+iAnd(ss,3))
  else c:=-1;
  if DebugFlagEnabled(dfDetails)
  then Details('Кнопка: '+s+' '+Str(ss)+' '+utf8_chr(c));
  if (c>=0) 
  then GetClickChar:=utf8_chr(c)
  else GetClickChar:=Chr(0);
  s:='';
 end;
 {
 Is UTF8 char c is good to use?
 }
 function IsGoodChar(c:String):Boolean;
 var cl,cp:Integer;
 begin
  cl:=utf8_length(c); cp:=Pos(c,CharSet);
  IsGoodChar:=(Length(CharSet)=0) or ((cp>0) and (cl>0));
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  CharSet:='';
  winVKbdCtrl:='';
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,MaxInt,0);
  {
  Initialize variables...
  }
  winVKbdCtrl:=ReadIni('winVKbdCtrl');
  if Length(winVKbdCtrl)>0
  then DevPostCmdLocal('@WinShow'+EOL+'@Home'+EOL+'@WinSelect'+EOL+'@WinHide'+EOL);
  {
  Initialize tags...
  }
  InitTag(tagVKbdText,   ReadIni('tagVKbdText'),   3);
  InitTag(tagVKbdPrev,   ReadIni('tagVKbdPrev'),   3);
  InitTag(tagVKbdLabel,  ReadIni('tagVKbdLabel'),  3);
  InitTag(tagVKbdState,  ReadIni('tagVKbdState'),  1);
  InitTag(tagVKbdDevMsg, ReadIni('tagVKbdDevMsg'), 3);
  bNul(sSetTag(tagVKbdDevMsg,''));
  bNul(sSetTag(tagVKbdLabel,''));
  bNul(sSetTag(tagVKbdText,''));
  bNul(sSetTag(tagVKbdPrev,''));
  bNul(iSetTag(tagVKbdState,0));
  SizeFactor:=WordIndex(ExtractFileName(ExtractFilePath(
                        ReadIni('['+DevName+'.Ctrl] Circuit'))),'Normal,Huge')-1;
  Success('SizeFactor='+ExtractWord(SizeFactor+1,'Normal,Huge'));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var s,c:String; r:Real; i,j:Integer;
 begin
  s:=''; c:='';
  {
  Handle sensor click...
  }
  if ClickButton=1 then begin
   {
   Commands...
   }
   if IsSameText(ClickSensor,'VKbd.Escape') then begin
    if GrantAccess(g_Guest) then begin
     bNul(WinHide(winVKbdCtrl));
     SpeakHint(0,Url_Decode(ClickParams('Hint')));
     bNul(Voice(snd_Click));
    end;
   end;
   if IsSameText(ClickSensor,'VKbd.Ok') then begin
    if GrantAccess(g_Guest) then begin
     bNul(WinHide(winVKbdCtrl));
     s:=sGetTag(tagVKbdDevMsg);
     s:=StrReplace(s,'%Text%',sGetTag(tagVKbdText),3);
     s:=StrReplace(s,'%UrlText%',url_encode(sGetTag(tagVKbdText)),3);
     s:=StrReplace(s,'%HexText%',hex_encode(sGetTag(tagVKbdText)),3);
     s:=StrReplace(s,'%MimeText%',mime_encode(sGetTag(tagVKbdText)),3);
     if Length(Trim(s))>0 then
     if RefFind('Device '+ExtractWord(1,s))<>0 then
     if DevSendMsg(s+EOL)=0 then Trouble('Failed DevSendMsg("'+s+'")!');
     bNul(Voice(snd_Click));
     Speak('Ok.');
    end;
   end;
   if IsSameText(ClickSensor,'VKbd.Text') then begin
    if GrantAccess(g_Guest) then begin
     r:=eval(sGetTag(tagVKbdText));
     if IsNan(r) then begin
      bNul(Voice(snd_Deny));
      SpeakHint(0,'Ошибка. Error.');
     end else begin
      bNul(sSetTag(tagVKbdText,Str(r)));
      bNul(Voice(snd_Click));
      Speak('Ok.');
     end;
    end;
   end;
   if IsSameText(ClickSensor,'VKbd.Label') then begin
    if GrantAccess(g_Guest) then begin
     Speak(sGetTag(tagVKbdLabel));
     bNul(Voice(snd_Click));
    end;
   end;
   if IsSameText(ClickSensor,'VKbd.PrevText')
   or IsSameText(ClickSensor,'VKbd.PrevLabel') then begin
    if GrantAccess(g_Guest) then begin
     SpeakHint(0,'Старое значение. Previous value.');
     bNul(sSetTag(tagVKbdText,sGetTag(tagVKbdPrev)));
     bNul(Voice(snd_Click));
    end;
   end;
   if IsSameText(ClickSensor,'VKbd.Clear') then begin
    if GrantAccess(g_Guest) then begin
     SpeakHint(0,Url_Decode(ClickParams('Hint')));
     bNul(sSetTag(tagVKbdText,''));
     bNul(Voice(snd_Click));
    end;
   end;
   if IsSameText(ClickSensor,'VKbd.Bsp') then begin
    if GrantAccess(g_Guest) then begin
     bNul(sSetTag(tagVKbdText,Copy(sGetTag(tagVKbdText),1,Length(sGetTag(tagVKbdText))-1)));
     SpeakHint(0,Url_Decode(ClickParams('Hint')));
     bNul(Voice(snd_Click));
    end;
   end;
   if IsSameText(ClickSensor,'VKbd.Shift') then begin
    if GrantAccess(g_Guest) then begin
     SpeakHint(0,Url_Decode(ClickParams('Hint')));
     ClickBitXorLocal(tagVKbdState,2);
    end;
   end;
   if IsSameText(ClickSensor,'VKbd.Lang') then begin
    if GrantAccess(g_Guest) then begin
     SpeakHint(200,Url_Decode(ClickParams('Hint')));
     ClickBitXorLocal(tagVKbdState,1);
    end;
   end;
   for i:=0 to 15 do
   for j:=0 to 15 do
   if IsSameText(ClickSensor,'VKbd.Key'+HexB(i*16+j)) then begin
    if GrantAccess(g_Guest) then begin
     c:=GetClickChar;
     if (c<>'') then
     if IsGoodChar(c) then begin
      bNul(sSetTag(tagVKbdText,sGetTag(tagVKbdText)+c));
      if (Pos(c,'0123456789+-.*/')>0) then Speak(' '+CharName(c)) else
      if (Pos(c,'(){}[]<>?!:;''"#№@%&$^^~`|,=')>0) then Speak(' '+CharName(c)) else
      if (Pos(c,'abcdefghijklmnopqrstuvwxyz')>0) then Speak(' '+CharName(c)) else
      if (Pos(c,'ABCDEFGHIJKLMNOPQRSTUVWXYZ')>0) then Speak(' '+CharName(c)) else
      if (Language=0) or (Language=iAnd(iGetTag(tagVKbdState),1)) then Speak(' '+CharName(c));
      bNul(Voice(snd_Click));
     end else begin
      bNul(Voice(snd_Deny));
     end;
    end;
   end;
   s:=''; c:='';
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,s:String;
 begin
  s:='';
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {}
   if IsSameText(cmd,'@State') then begin
    if not IsNan(rVal(arg))
    then bNul(iSetTag(tagVKbdState,iAnd(Round(rVal(arg)),3)));
    Success(cmd+'='+Str(iGetTag(tagVKbdState)));
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@CharSet') then begin
    CharSet:=Url_Decode(Trim(arg));
    Success(cmd+'='+Url_Packed(CharSet));
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@Language') then begin
    if WordIndex(Trim(arg),Languages)>0
    then Language:=WordIndex(Trim(arg),Languages)-1;
    if not IsNan(rVal(arg)) then Language:=Round(Max(0,Min(1,rVal(arg))));
    Success(cmd+'='+Str(Language)+'='+ExtractWord(Language+1,Languages));
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@Home') then begin
    if SizeFactor=0
    then Success(cmd+'='+Str(Ord(WinDraw(winVKbdCtrl+'|Left=167|Top=0|Width=563|Height=365'
                        +'|Options=-Min,-Max,-Close,-Width,-Height,-HScroll,-VScroll'))))
    else Success(cmd+'='+Str(Ord(WinDraw(winVKbdCtrl+'|Left=0|Top=0|Width=1115|Height=690'
                        +'|Options=-Min,-Max,-Close,-Width,-Height,-HScroll,-VScroll'))));
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@WinShow') then begin
    if Length(Trim(arg))=0 then s:=winVKbdCtrl else s:=Trim(arg);
    Success(cmd+'='+Str(Ord(WinShow(s))));
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@WinHide') then begin
    if Length(Trim(arg))=0 then s:=winVKbdCtrl else s:=Trim(arg);
    Success(cmd+'='+Str(Ord(WinHide(s))));
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@WinSelect') then begin
    if Length(Trim(arg))=0 then s:=winVKbdCtrl else s:=Trim(arg);
    Success(cmd+'='+Str(Ord(WinSelect(s))));
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@Label') then begin
    s:=Url_Decode(Trim(arg));
    bNul(sSetTag(tagVKbdLabel,s));
    Success(cmd+'='+s);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@Text') then begin
    s:=Url_Decode(Trim(arg));
    bNul(sSetTag(tagVKbdText,s));
    Success(cmd+'='+s);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@Prev') then begin
    s:=Url_Decode(Trim(arg));
    bNul(sSetTag(tagVKbdPrev,s));
    Success(cmd+'='+s);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@DevMsg') then begin
    s:=Url_Decode(Trim(arg));
    bNul(sSetTag(tagVKbdDevMsg,s));
    Success(cmd+'='+s);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  s:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
